/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;
import org.unitime.timetable.util.IdValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionalOfferingModifyForm
extends ActionForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 5412595518174343486L;
    private String op;
    private Integer subjectAreaId;
    private Long instrOfferingId;
    private String instrOfferingName;
    private boolean instrOffrConfigUnlimited;
    private Integer instrOffrConfigLimit;
    private boolean instrOffrConfigUnlimitedReadOnly;
    private Long instrOffrConfigId;
    private String origSubparts;
    private Boolean displayMaxLimit;
    private Boolean displayOptionForMaxLimit;
    private Boolean displayEnrollment;
    private String enableAllClassesForStudentScheduling;
    private String displayAllClassesInstructors;
    private Boolean displayExternalId;
    private Boolean editExternalId;
    private Boolean displayDisplayInstructors;
    private Boolean displayEnabledForStudentScheduling;
    private Long instructionalMethod;
    private List classIds;
    private List subpartIds;
    private List itypes;
    private List mustHaveChildClasses;
    private List parentClassIds;
    private List readOnlyClasses;
    private List classLabels;
    private List classLabelIndents;
    private List enrollments;
    private List minClassLimits;
    private List maxClassLimits;
    private List roomRatios;
    private List numberOfRooms;
    private List departments;
    private List datePatterns;
    private List displayInstructors;
    private List enabledForStudentScheduling;
    private List classCanMoveUp;
    private List classCanMoveDown;
    private List subtotalIndexes;
    private List subtotalLabels;
    private List subtotalValues;
    private List enableAllClassesForStudentSchedulingForSubpart;
    private List displayAllClassesInstructorsForSubpart;
    private List readOnlySubparts;
    private List times;
    private List rooms;
    private List instructors;
    private List externalIds;
    private List canDelete;
    private List canCancel;
    private List isCancelled;
    private List classHasErrors;
    private Long addTemplateClassId;
    private Long moveUpClassId;
    private Long moveDownClassId;
    private Long deletedClassId;
    private static String CLASS_IDS_TOKEN = "classIds";
    private static String SUBPART_IDS_TOKEN = "subpartIds";
    private static String PARENT_CLASS_IDS_TOKEN = "parentClassIds";
    private static String ITYPES_TOKEN = "itypes";
    private static String MUST_HAVE_CHILD_CLASSES_TOKEN = "mustHaveChildClasses";
    private static String READ_ONLY_CLASSES_TOKEN = "readOnlyClasses";
    private static String CLASS_LABELS_TOKEN = "classLabels";
    private static String CLASS_LABEL_INDENTS_TOKEN = "classLabelIndents";
    private static String ENROLLMENTS_TOKEN = "enrollments";
    private static String MIN_CLASS_LIMITS_TOKEN = "minClassLimits";
    private static String MAX_CLASS_LIMITS_TOKEN = "maxClassLimits";
    private static String ROOM_RATIOS_TOKEN = "roomRatios";
    private static String NUMBER_OF_ROOMS_TOKEN = "numberOfRooms";
    private static String DEPARTMENTS_TOKEN = "departments";
    private static String DATE_PATTERNS_TOKEN = "datePatterns";
    private static String DISPLAY_INSTRUCTORS_TOKEN = "displayInstructors";
    private static String ENABLED_FOR_STUDENT_SCHEDULING_TOKEN = "enabledForStudentScheduling";
    private static String DIRECTION_UP = "up";
    private static String DIRECTION_DOWN = "down";
    private static String SUBTOTAL_INDEXES_TOKEN = "subtotalIndexes";
    private static String TIMES_TOKEN = "times";
    private static String ROOMS_TOKEN = "rooms";
    private static String INSTRUCTORS_TOKEN = "instructors";
    private static String EXTERNAL_IDS_TOKEN = "externalIds";
    private static String CAN_DELETE_TOKEN = "canDelete";
    private static String CAN_CANCEL_TOKEN = "canCancel";
    private static String IS_CANCELLED_TOKEN = "isCancelled";
    protected DynamicListObjectFactory factoryClasses = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        MessageResources rsc = (MessageResources)super.getServlet().getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        if (this.op.equals(rsc.getMessage("button.add")) && (this.addTemplateClassId == null || this.addTemplateClassId <= 0L)) {
            errors.add("getAddTemplateClassId", new ActionMessage("errors.generic", (Object)MSG.errorRequiredClass()));
        }
        if (this.op.equals(rsc.getMessage("button.moveUp")) && (this.moveUpClassId == null || this.moveUpClassId <= 0L)) {
            errors.add("getMoveUpClassId", new ActionMessage("errors.generic", (Object)MSG.errorRequiredClass()));
        }
        if (this.op.equals(rsc.getMessage("button.moveDown")) && (this.moveDownClassId == null || this.moveDownClassId <= 0L)) {
            errors.add("getMoveDownClassId", new ActionMessage("errors.generic", (Object)MSG.errorRequiredClass()));
        }
        if (this.op.equals(MSG.actionUpdateMultipleClassSetup())) {
            if (this.instrOffrConfigId == null || this.instrOffrConfigId.intValue() <= 0) {
                errors.add("instrOffrConfigId", new ActionMessage("errors.generic", (Object)MSG.errorRequiredIOConfiguration()));
            }
            this.validateChildClassExistence(errors);
            this.validateClassLimits(errors);
            this.validateAllSubpartsHaveAtLeastOneClass(errors);
        }
        return errors;
    }

    private void validateChildClassExistence(ActionErrors errors) {
        for (int index = 0; index < this.getClassIds().size(); ++index) {
            if (!Boolean.valueOf((String)this.getMustHaveChildClasses().get(index)).booleanValue()) continue;
            String classId = (String)this.getClassIds().get(index);
            if (index + 1 == this.getClassIds().size()) {
                errors.add("mustHaveChildClasses", new ActionMessage("errors.generic", (Object)MSG.errorClassMustHaveChildClasses((String)this.getClassLabels().get(index))));
                this.getClassHasErrors().set(index, new Boolean(true));
                continue;
            }
            String parentOfNextClass = (String)this.getParentClassIds().get(index + 1);
            if (parentOfNextClass != null && parentOfNextClass.equals(classId)) continue;
            errors.add("mustHaveChildClasses", new ActionMessage("errors.generic", (Object)MSG.errorClassMustHaveChildClasses((String)this.getClassLabels().get(index))));
            this.getClassHasErrors().set(index, new Boolean(true));
        }
    }

    private void validateAllSubpartsHaveAtLeastOneClass(ActionErrors errors) {
        String[] subparts = this.getOrigSubparts().split(",");
        for (int i = 0; i < subparts.length; ++i) {
            if (this.getSubpartIds().contains(subparts[i])) continue;
            errors.add("allSubpartsMustHaveAClass", new ActionMessage("errors.generic", (Object)MSG.errorEachSubpartMustHaveClass()));
            break;
        }
    }

    private void validateMinLessThanMaxClassLimits(ActionErrors errors) {
        Iterator it1 = this.getMinClassLimits().iterator();
        Iterator it2 = this.getMaxClassLimits().iterator();
        int index = 0;
        String minLimitStr = null;
        String maxLimitStr = null;
        while (it1.hasNext()) {
            int maxLimit;
            minLimitStr = (String)it1.next();
            int minLimit = minLimitStr != null && minLimitStr.length() > 0 ? Integer.parseInt(minLimitStr) : 0;
            if (minLimit > (maxLimit = (maxLimitStr = (String)it2.next()) != null && maxLimitStr.length() > 0 ? Integer.parseInt(maxLimitStr) : 0)) {
                errors.add("minLimitGreaterThanMaxLimit", new ActionMessage("errors.generic", (Object)MSG.errorMaxLessThanMinLimit((String)this.getClassLabels().get(index))));
                this.getClassHasErrors().set(index, new Boolean(true));
            }
            ++index;
        }
    }

    private void validateMinOrMaxParentClassLimits(ActionErrors errors, List limits, String errorName, String errorMessage) {
        HashMap<String, HashMap> childClassLimits = new HashMap<String, HashMap>();
        Iterator it1 = this.getSubpartIds().iterator();
        Iterator it2 = limits.iterator();
        Iterator it3 = this.getParentClassIds().iterator();
        String subpartKey = null;
        String parentKey = null;
        String tmp = null;
        HashMap subpartLimits = null;
        while (it1.hasNext()) {
            int value2;
            subpartKey = (String)it1.next();
            tmp = (String)it2.next();
            int clsLimit = tmp != null && tmp.length() != 0 ? Integer.parseInt(tmp) : 0;
            parentKey = (String)it3.next();
            if (parentKey == null || parentKey.length() <= 0) continue;
            if (childClassLimits.get(parentKey) == null) {
                subpartLimits = new HashMap();
                childClassLimits.put(parentKey, subpartLimits);
                value2 = 0;
            } else {
                subpartLimits = (HashMap)childClassLimits.get(parentKey);
                value2 = subpartLimits.get(subpartKey) == null ? 0 : (Integer)subpartLimits.get(subpartKey);
            }
            subpartLimits.put(subpartKey, new Integer(value2 += clsLimit));
        }
        HashMap<String, String> childClassesUnderLimit = new HashMap<String, String>();
        String parentKey1 = null;
        Integer childLimit = null;
        Integer parentLimit = null;
        Iterator it4 = this.getClassIds().iterator();
        Iterator it5 = limits.iterator();
        String subpartKey22 = null;
        while (it4.hasNext()) {
            parentKey1 = (String)it4.next();
            parentLimit = new Integer((String)it5.next());
            if (childClassLimits.get(parentKey1) == null) continue;
            subpartLimits = (HashMap)childClassLimits.get(parentKey1);
            for (String subpartKey22 : subpartLimits.keySet()) {
                childLimit = (Integer)subpartLimits.get(subpartKey22);
                if (parentLimit == null || childLimit >= parentLimit) continue;
                childClassesUnderLimit.put(parentKey1, subpartKey22);
            }
        }
        if (childClassesUnderLimit.size() > 0) {
            errors.add(errorName, new ActionMessage("errors.generic", (Object)errorMessage));
        }
        if (childClassesUnderLimit.size() > 0) {
            Iterator it6 = this.getParentClassIds().iterator();
            Iterator it7 = this.getSubpartIds().iterator();
            String subpartId = null;
            String parentId = null;
            int index = 0;
            while (it6.hasNext()) {
                parentId = (String)it6.next();
                subpartId = (String)it7.next();
                if (!((Boolean)this.getClassHasErrors().get(index)).booleanValue() && childClassesUnderLimit.keySet().contains(parentId) && subpartId.equals((String)childClassesUnderLimit.get(parentId))) {
                    this.getClassHasErrors().set(index, new Boolean(true));
                }
                ++index;
            }
        }
    }

    private void validateSubpartClassLimits(ActionErrors errors) {
        int limit = this.getInstrOffrConfigLimit();
        HashMap<String, Integer> subpartClassLimits = new HashMap<String, Integer>();
        Iterator it1 = this.getSubpartIds().iterator();
        Iterator it2 = this.getMaxClassLimits().iterator();
        Iterator it3 = this.getParentClassIds().iterator();
        String subpartKey = null;
        String parentKey = null;
        String tmp = null;
        while (it1.hasNext()) {
            subpartKey = (String)it1.next();
            tmp = (String)it2.next();
            int clsLimit = tmp != null && tmp.length() != 0 ? Integer.parseInt(tmp) : 0;
            parentKey = (String)it3.next();
            if (parentKey != null && parentKey.length() != 0) continue;
            int value1 = subpartClassLimits.get(subpartKey) == null ? 0 : (Integer)subpartClassLimits.get(subpartKey);
            subpartClassLimits.put(subpartKey, new Integer(value1 += clsLimit));
        }
        HashSet<String> subpartsUnderLimit = new HashSet<String>();
        String subpartKey1 = null;
        Integer subpartLimit = null;
        Iterator it4 = subpartClassLimits.keySet().iterator();
        while (it4.hasNext()) {
            subpartKey1 = it4.next().toString();
            subpartLimit = (Integer)subpartClassLimits.get(subpartKey1);
            if (subpartLimit == null || subpartLimit >= limit) continue;
            subpartsUnderLimit.add(subpartKey1);
        }
        if (subpartsUnderLimit.size() > 0) {
            if (this.getDisplayMaxLimit().booleanValue()) {
                errors.add("maxLimit", new ActionMessage("errors.generic", (Object)MSG.errorMaxLimitsTotalTooLow()));
            } else {
                errors.add("maxLimit", new ActionMessage("errors.generic", (Object)MSG.errorLimitsForTopLevelClassesTooLow()));
            }
        }
        if (subpartsUnderLimit.size() > 0) {
            Iterator it7 = this.getSubpartIds().iterator();
            String subpartId = null;
            int index = 0;
            while (it7.hasNext()) {
                subpartId = (String)it7.next();
                if (!((Boolean)this.getClassHasErrors().get(index)).booleanValue() && subpartsUnderLimit.contains(subpartId)) {
                    this.getClassHasErrors().set(index, new Boolean(true));
                }
                ++index;
            }
        }
    }

    private void initClassHasErrorsToFalse() {
        this.setClassHasErrors(DynamicList.getInstance(new ArrayList(), this.factoryClasses));
        Iterator it = this.getClassIds().iterator();
        while (it.hasNext()) {
            this.getClassHasErrors().add(new Boolean(false));
            it.next();
        }
    }

    private void initClassMoveDirections() {
        this.setClassCanMoveDown(DynamicList.getInstance(new ArrayList(), this.factoryClasses));
        this.setClassCanMoveUp(DynamicList.getInstance(new ArrayList(), this.factoryClasses));
        Iterator it = this.getClassIds().iterator();
        while (it.hasNext()) {
            this.getClassCanMoveDown().add(new Boolean(false));
            this.getClassCanMoveUp().add(new Boolean(false));
            it.next();
        }
    }

    private void validateClassLimits(ActionErrors errors) {
        boolean unlimited = this.isInstrOffrConfigUnlimited();
        int limit = this.getInstrOffrConfigLimit();
        if (!unlimited && limit > 0) {
            this.initClassHasErrorsToFalse();
            this.validateMinLessThanMaxClassLimits(errors);
            this.validateMinOrMaxParentClassLimits(errors, this.getMaxClassLimits(), "maxLimit", this.getDisplayMaxLimit() != false ? MSG.errorTotalMaxChildrenAtLeastMaxParent() : MSG.errorLimitsChildClasses());
            if (ApplicationProperty.ConfigEditCheckLimits.isTrue()) {
                this.validateSubpartClassLimits(errors);
            }
        }
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.instrOfferingId = null;
        this.instrOffrConfigLimit = null;
        this.instrOffrConfigUnlimited = false;
        this.instrOffrConfigUnlimitedReadOnly = false;
        this.instrOffrConfigId = null;
        this.instrOfferingName = "";
        this.origSubparts = "";
        this.displayMaxLimit = new Boolean(false);
        this.displayOptionForMaxLimit = new Boolean(false);
        this.displayEnrollment = new Boolean(false);
        this.displayDisplayInstructors = new Boolean(false);
        this.displayEnabledForStudentScheduling = new Boolean(false);
        this.displayExternalId = new Boolean(false);
        this.editExternalId = new Boolean(false);
        this.enableAllClassesForStudentScheduling = "";
        this.displayAllClassesInstructors = "";
        this.instructionalMethod = null;
        this.resetLists();
    }

    private void resetLists() {
        this.classIds = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.subpartIds = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.itypes = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.mustHaveChildClasses = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.parentClassIds = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.readOnlyClasses = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.classHasErrors = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.classLabels = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.classLabelIndents = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.enrollments = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.minClassLimits = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.maxClassLimits = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.roomRatios = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.numberOfRooms = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.departments = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.datePatterns = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.displayInstructors = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.enabledForStudentScheduling = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.subtotalIndexes = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.subtotalLabels = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.subtotalValues = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.enableAllClassesForStudentSchedulingForSubpart = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.displayAllClassesInstructorsForSubpart = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.classCanMoveUp = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.classCanMoveDown = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.readOnlySubparts = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.times = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.rooms = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.instructors = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.externalIds = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.canDelete = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.canCancel = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
        this.isCancelled = DynamicList.getInstance(new ArrayList(), this.factoryClasses);
    }

    private void setClassCannotMove(int classIndex) {
        this.getClassCanMoveDown().set(classIndex, new Boolean(false));
        this.getClassCanMoveUp().set(classIndex, new Boolean(false));
    }

    public void setDirectionsClassesCanMove() {
        String parentClassId = null;
        String classItype = null;
        String parentSubpartId = null;
        String parentClassItype = null;
        this.initClassMoveDirections();
        for (int classIndex = 0; classIndex < this.getClassIds().size(); ++classIndex) {
            int highestParentSubpartIdIndex;
            parentClassId = (String)this.getParentClassIds().get(classIndex);
            if (parentClassId == null || parentClassId.length() == 0) {
                this.setClassCannotMove(classIndex);
                continue;
            }
            int parentClassIndex = this.getClassIds().indexOf(parentClassId);
            if (parentClassIndex < 0) {
                this.setClassCannotMove(classIndex);
                continue;
            }
            classItype = (String)this.getItypes().get(classIndex);
            parentClassItype = (String)this.getItypes().get(parentClassIndex);
            if (classItype != null && parentClassItype != null && classItype.equals(parentClassItype)) {
                this.setClassCannotMove(classIndex);
                continue;
            }
            parentSubpartId = (String)this.getSubpartIds().get(parentClassIndex);
            if (parentSubpartId == null || parentSubpartId.length() == 0) {
                this.setClassCannotMove(classIndex);
                continue;
            }
            int lowestParentSubpartIdIndex = this.getSubpartIds().indexOf(parentSubpartId);
            if (lowestParentSubpartIdIndex < parentClassIndex) {
                this.getClassCanMoveUp().set(classIndex, new Boolean(true));
            }
            if ((highestParentSubpartIdIndex = this.getSubpartIds().lastIndexOf(parentSubpartId)) <= parentClassIndex) continue;
            this.getClassCanMoveDown().set(classIndex, new Boolean(true));
        }
    }

    public void initializeOrigSubparts() {
        TreeSet<String> ts = new TreeSet<String>();
        Iterator it = this.getSubpartIds().iterator();
        while (it.hasNext()) {
            ts.add((String)it.next());
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator it2 = ts.iterator();
        while (it2.hasNext()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append((String)it2.next());
        }
        this.setOrigSubparts(sb.toString());
    }

    public void initializeEnableAllClassesForStudentScheduling() {
        if (this.getClassLabels().size() > this.getEnabledForStudentScheduling().size()) {
            this.setEnableAllClassesForStudentScheduling("false");
            return;
        }
        String display = "true";
        for (String value : this.getEnabledForStudentScheduling()) {
            if (value != null && (value.equals("on") || Boolean.parseBoolean(value))) continue;
            display = "false";
            break;
        }
        this.setEnableAllClassesForStudentScheduling(display);
    }

    public void initializeDisplayAllClassInstructors() {
        if (this.getClassLabels().size() > this.getDisplayInstructors().size()) {
            this.setDisplayAllClassesInstructors("false");
            return;
        }
        String display = "true";
        for (String value : this.getDisplayInstructors()) {
            if (value != null && (value.equals("on") || Boolean.parseBoolean(value))) continue;
            display = "false";
            break;
        }
        this.setDisplayAllClassesInstructors(display);
    }

    public void initalizeSubpartSubtotalsAndDisplayFlags() {
        HashMap<Long, Integer> subpartToIndex = new HashMap<Long, Integer>();
        this.setSubtotalIndexes(DynamicList.getInstance(new ArrayList(), this.factoryClasses));
        this.setSubtotalLabels(DynamicList.getInstance(new ArrayList(), this.factoryClasses));
        this.setSubtotalValues(DynamicList.getInstance(new ArrayList(), this.factoryClasses));
        this.setEnableAllClassesForStudentSchedulingForSubpart(DynamicList.getInstance(new ArrayList(), this.factoryClasses));
        this.setDisplayAllClassesInstructorsForSubpart(DynamicList.getInstance(new ArrayList(), this.factoryClasses));
        this.setReadOnlySubparts(DynamicList.getInstance(new ArrayList(), this.factoryClasses));
        SchedulingSubpartDAO ssDao = new SchedulingSubpartDAO();
        SchedulingSubpart ss = null;
        int i = 0;
        int cnt = 0;
        Iterator ssIt = this.getSubpartIds().iterator();
        Iterator limitIt = this.getMinClassLimits().iterator();
        Iterator cancelIt = this.getIsCancelled().iterator();
        Boolean enableForScheduling = null;
        Boolean displayInstructor = null;
        Boolean readOnlySubpart = null;
        while (ssIt.hasNext() && limitIt.hasNext() && cancelIt.hasNext()) {
            Long subpartId = Long.valueOf((String)ssIt.next());
            Integer limit = new Integer((String)limitIt.next());
            boolean cancelled = "true".equals(cancelIt.next());
            enableForScheduling = new Boolean(this.determineBooleanValueAtIndex(this.getEnabledForStudentScheduling(), cnt));
            displayInstructor = new Boolean(this.determineBooleanValueAtIndex(this.getDisplayInstructors(), cnt));
            readOnlySubpart = new Boolean(this.determineBooleanValueAtIndex(this.getReadOnlyClasses(), cnt));
            int addLimit = limit == null || cancelled ? 0 : limit;
            Integer subtotalIndex = null;
            if (!subpartToIndex.containsKey(subpartId)) {
                ss = (SchedulingSubpart)ssDao.get(subpartId);
                this.getSubtotalValues().add(addLimit);
                this.getEnableAllClassesForStudentSchedulingForSubpart().add(enableForScheduling);
                this.getDisplayAllClassesInstructorsForSubpart().add(displayInstructor);
                this.getReadOnlySubparts().add(readOnlySubpart);
                String label = ss.getItypeDesc() + ss.getSchedulingSubpartSuffix();
                this.getSubtotalLabels().add(label);
                subpartToIndex.put(subpartId, new Integer(i));
                subtotalIndex = new Integer(i);
                ++i;
            } else {
                subtotalIndex = (Integer)subpartToIndex.get(subpartId);
                int oldSubtotal = (Integer)this.getSubtotalValues().get(subtotalIndex);
                int newSubtotal = oldSubtotal + addLimit;
                this.getSubtotalValues().set(subtotalIndex, newSubtotal);
                boolean oldEnableForScheduling = (Boolean)this.getEnableAllClassesForStudentSchedulingForSubpart().get(subtotalIndex);
                boolean newEnableForScheduling = oldEnableForScheduling && enableForScheduling != false;
                this.getEnableAllClassesForStudentSchedulingForSubpart().set(subtotalIndex, new Boolean(newEnableForScheduling));
                boolean oldDisplayInstructor = (Boolean)this.getDisplayAllClassesInstructorsForSubpart().get(subtotalIndex);
                boolean newDisplayInstructor = oldDisplayInstructor && displayInstructor != false;
                this.getDisplayAllClassesInstructorsForSubpart().set(subtotalIndex, newDisplayInstructor);
                boolean oldReadOnlySubpart = (Boolean)this.getReadOnlySubparts().get(subtotalIndex);
                boolean newReadOnlySubpart = oldReadOnlySubpart && readOnlySubpart != false;
                this.getReadOnlySubparts().set(subtotalIndex, newReadOnlySubpart);
            }
            this.getSubtotalIndexes().add(subtotalIndex);
            ++cnt;
        }
    }

    private boolean determineBooleanValueAtIndex(List l, int index) {
        if (l == null) {
            return false;
        }
        if (l.size() == 0) {
            return false;
        }
        if (l.size() < index + 1) {
            return false;
        }
        if (l.get(index) == null) {
            return false;
        }
        if (l.get(index) instanceof Boolean) {
            Boolean value = (Boolean)l.get(index);
            return value;
        }
        if (l.get(index) instanceof String) {
            String str_value = (String)l.get(index);
            if (str_value.equals("on")) {
                return true;
            }
            if (str_value.equals("yes")) {
                return true;
            }
            return Boolean.parseBoolean(str_value);
        }
        return false;
    }

    public List getClassIds() {
        return this.classIds;
    }

    public void setClassIds(List classIds) {
        this.classIds = classIds;
    }

    public List getClassHasErrors() {
        return this.classHasErrors;
    }

    public void setClassHasErrors(List classHasErrors) {
        this.classHasErrors = classHasErrors;
    }

    public List getClassLabels() {
        return this.classLabels;
    }

    public void setClassLabels(List classLabels) {
        this.classLabels = classLabels;
    }

    public List getMinClassLimits() {
        return this.minClassLimits;
    }

    public void setMinClassLimits(List classLimits) {
        this.minClassLimits = classLimits;
    }

    public List getDatePatterns() {
        return this.datePatterns;
    }

    public void setDatePatterns(List datePatterns) {
        this.datePatterns = datePatterns;
    }

    public Long getInstrOffrConfigId() {
        return this.instrOffrConfigId;
    }

    public void setInstrOffrConfigId(Long instrOffrConfigId) {
        this.instrOffrConfigId = instrOffrConfigId;
    }

    public Integer getInstrOffrConfigLimit() {
        return this.instrOffrConfigLimit;
    }

    public void setInstrOffrConfigLimit(Integer instrOffrConfigLimit) {
        this.instrOffrConfigLimit = instrOffrConfigLimit;
    }

    public boolean isInstrOffrConfigUnlimited() {
        return this.instrOffrConfigUnlimited;
    }

    public void setInstrOffrConfigUnlimited(boolean instrOffrConfigUnlimited) {
        this.instrOffrConfigUnlimited = instrOffrConfigUnlimited;
    }

    public boolean getInstrOffrConfigUnlimitedReadOnly() {
        return this.instrOffrConfigUnlimitedReadOnly;
    }

    public void setInstrOffrConfigUnlimitedReadOnly(boolean instrOffrConfigUnlimitedReadOnly) {
        this.instrOffrConfigUnlimitedReadOnly = instrOffrConfigUnlimitedReadOnly;
    }

    public List getDepartments() {
        return this.departments;
    }

    public void setDepartments(List managers) {
        this.departments = managers;
    }

    public List getNumberOfRooms() {
        return this.numberOfRooms;
    }

    public void setNumberOfRooms(List numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public List getParentClassIds() {
        return this.parentClassIds;
    }

    public void setParentClassIds(List parentClassIds) {
        this.parentClassIds = parentClassIds;
    }

    public List getMaxClassLimits() {
        return this.maxClassLimits;
    }

    public void setMaxClassLimits(List roomLimits) {
        this.maxClassLimits = roomLimits;
    }

    public List getSubpartIds() {
        return this.subpartIds;
    }

    public void setSubpartIds(List subpartIds) {
        this.subpartIds = subpartIds;
    }

    public List getReadOnlyClasses() {
        return this.readOnlyClasses;
    }

    public void setReadOnlyClasses(List readOnlyClasses) {
        this.readOnlyClasses = readOnlyClasses;
    }

    public Long getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(Long instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public Long getAddTemplateClassId() {
        return this.addTemplateClassId;
    }

    public void setAddTemplateClassId(Long addTemplateClassId) {
        this.addTemplateClassId = addTemplateClassId;
    }

    public void removeFromClasses(String classId) {
        this.removeClass(classId);
        this.initClassHasErrorsToFalse();
        this.setDirectionsClassesCanMove();
    }

    private void removeClass(String classId) {
        ArrayList<String> classesToDel = new ArrayList<String>();
        ListIterator it1 = this.classIds.listIterator();
        ListIterator it2 = this.subpartIds.listIterator();
        ListIterator it3 = this.parentClassIds.listIterator();
        ListIterator it4 = this.readOnlyClasses.listIterator();
        ListIterator it5 = this.minClassLimits.listIterator();
        ListIterator it6 = this.departments.listIterator();
        ListIterator it7 = this.datePatterns.listIterator();
        ListIterator it8 = this.numberOfRooms.listIterator();
        ListIterator it9 = this.maxClassLimits.listIterator();
        ListIterator it10 = this.roomRatios.listIterator();
        ListIterator it11 = this.classLabels.listIterator();
        ListIterator it12 = this.classLabelIndents.listIterator();
        ListIterator it13 = this.displayInstructors.listIterator();
        ListIterator it14 = this.enabledForStudentScheduling.listIterator();
        ListIterator it15 = this.itypes.listIterator();
        ListIterator it16 = this.mustHaveChildClasses.listIterator();
        ListIterator it17 = this.enrollments.listIterator();
        ListIterator it18 = this.times.listIterator();
        ListIterator it19 = this.rooms.listIterator();
        ListIterator it20 = this.instructors.listIterator();
        ListIterator it21 = this.externalIds.listIterator();
        ListIterator it22 = this.canDelete.listIterator();
        ListIterator it23 = this.canCancel.listIterator();
        ListIterator it24 = this.isCancelled.listIterator();
        while (it1.hasNext()) {
            boolean canRemoveFromEnrollment;
            boolean canRemoveFromEnableForStudentScheduling;
            boolean canRemoveFromDisplayInstructors;
            String cls1 = it1.next().toString();
            it2.next();
            String pCls1 = it3.next().toString();
            it4.next();
            it5.next();
            it6.next();
            it7.next();
            it8.next();
            it9.next();
            it10.next();
            it11.next();
            it12.next();
            if (it13.hasNext()) {
                it13.next();
                canRemoveFromDisplayInstructors = true;
            } else {
                canRemoveFromDisplayInstructors = false;
            }
            if (it14.hasNext()) {
                it14.next();
                canRemoveFromEnableForStudentScheduling = true;
            } else {
                canRemoveFromEnableForStudentScheduling = false;
            }
            it15.next();
            it16.next();
            if (it17.hasNext()) {
                it17.next();
                canRemoveFromEnrollment = true;
            } else {
                canRemoveFromEnrollment = false;
            }
            it18.next();
            it19.next();
            it20.next();
            it21.next();
            it22.next();
            it23.next();
            it24.next();
            if (cls1.equals(classId)) {
                it1.remove();
                it2.remove();
                it3.remove();
                it4.remove();
                it5.remove();
                it6.remove();
                it7.remove();
                it8.remove();
                it9.remove();
                it10.remove();
                it11.remove();
                it12.remove();
                if (canRemoveFromDisplayInstructors) {
                    it13.remove();
                }
                if (canRemoveFromEnableForStudentScheduling) {
                    it14.remove();
                }
                it15.remove();
                it16.remove();
                if (canRemoveFromEnrollment) {
                    it17.remove();
                }
                it18.remove();
                it19.remove();
                it20.remove();
                it21.remove();
                it22.remove();
                it23.remove();
                it24.remove();
                continue;
            }
            if (!pCls1.equals(classId)) continue;
            classesToDel.add(cls1);
        }
        if (classesToDel.size() > 0) {
            Iterator delIt = classesToDel.iterator();
            while (delIt.hasNext()) {
                this.removeFromClasses(delIt.next().toString());
            }
        }
    }

    public void addToClasses(Class_ cls, Boolean isReadOnly, String indent, ClassAssignmentProxy proxy, String nameFormat, boolean canDelete, boolean canCancel) {
        this.classLabels.add(cls.htmlLabel());
        this.classLabelIndents.add(indent);
        this.classIds.add(cls.getUniqueId().toString());
        this.subpartIds.add(cls.getSchedulingSubpart().getUniqueId().toString());
        this.itypes.add(cls.getSchedulingSubpart().getItype().getItype().toString());
        if (cls.getSchedulingSubpart().getChildSubparts() != null && cls.getSchedulingSubpart().getChildSubparts().size() > 0) {
            this.mustHaveChildClasses.add(new Boolean(true));
        } else {
            this.mustHaveChildClasses.add(new Boolean(false));
        }
        this.readOnlyClasses.add(isReadOnly.toString());
        this.classHasErrors.add(new Boolean(false).toString());
        this.enrollments.add(StudentClassEnrollment.sessionHasEnrollments(cls.getSessionId()) ? (cls.getEnrollment() == null ? "0" : cls.getEnrollment().toString()) : "");
        if (this.isInstrOffrConfigUnlimited()) {
            this.minClassLimits.add("0");
        } else {
            this.minClassLimits.add(cls.getExpectedCapacity().toString());
        }
        if (this.isInstrOffrConfigUnlimited()) {
            this.numberOfRooms.add("1");
        } else {
            this.numberOfRooms.add(cls.getNbrRooms().toString());
        }
        this.displayInstructors.add(cls.isDisplayInstructor().toString());
        this.enabledForStudentScheduling.add(cls.isEnabledForStudentScheduling().toString());
        if (this.isInstrOffrConfigUnlimited()) {
            this.maxClassLimits.add("0");
        } else if (cls.getMaxExpectedCapacity() != null) {
            this.maxClassLimits.add(cls.getMaxExpectedCapacity().toString());
        } else {
            this.maxClassLimits.add("");
        }
        if (this.isInstrOffrConfigUnlimited()) {
            this.roomRatios.add("1.0");
        } else if (cls.getRoomRatio() != null) {
            this.roomRatios.add(cls.getRoomRatio().toString());
        } else {
            this.roomRatios.add("");
        }
        if (cls.getParentClass() != null) {
            this.parentClassIds.add(cls.getParentClass().getUniqueId().toString());
        } else {
            this.parentClassIds.add("");
        }
        if (cls.getManagingDept() != null) {
            if (cls.getManagingDept().getUniqueId().equals(cls.getControllingDept().getUniqueId())) {
                this.departments.add("-1");
            } else {
                this.departments.add(cls.getManagingDept().getUniqueId().toString());
            }
        } else {
            this.departments.add("-1");
        }
        if (cls.getDatePattern() != null) {
            this.datePatterns.add(cls.getDatePattern().getUniqueId().toString());
        } else {
            this.datePatterns.add("");
        }
        if (!(cls.getExpectedCapacity() != null && cls.getMaxExpectedCapacity() != null && cls.getExpectedCapacity().equals(cls.getMaxExpectedCapacity()) || cls.getExpectedCapacity() == null && cls.getMaxExpectedCapacity() == null)) {
            this.setDisplayMaxLimit(new Boolean(true));
        }
        if (this.getDisplayMaxLimit().booleanValue()) {
            this.setDisplayOptionForMaxLimit(new Boolean(true));
        }
        this.times.add(cls.buildAssignedTimeHtml(proxy));
        this.rooms.add(cls.buildAssignedRoomHtml(proxy));
        this.instructors.add(cls.buildInstructorHtml(nameFormat));
        this.externalIds.add(cls.getClassSuffix() == null ? "" : cls.getClassSuffix());
        this.canDelete.add(canDelete ? "true" : "false");
        this.canCancel.add(canCancel ? "true" : "false");
        this.isCancelled.add(cls.isCancelled().toString());
    }

    private int indexOfLastChildClass(String classId) {
        int index;
        int clsIndex = this.getClassIds().indexOf(classId);
        for (index = clsIndex + 1; index < this.getClassIds().size() && !this.getClassLabelIndents().get(index).toString().equals(this.getClassLabelIndents().get(clsIndex).toString()) && this.getClassLabelIndents().get(index).toString().length() >= this.getClassLabelIndents().get(clsIndex).toString().length(); ++index) {
        }
        return --index;
    }

    public void shiftClass(String clsId) {
    }

    private HashMap buildOriginalListValuesMap() {
        HashMap<String, List> hm = new HashMap<String, List>();
        hm.put(CLASS_IDS_TOKEN, this.getClassIds());
        hm.put(SUBPART_IDS_TOKEN, this.getSubpartIds());
        hm.put(ITYPES_TOKEN, this.getItypes());
        hm.put(MUST_HAVE_CHILD_CLASSES_TOKEN, this.getMustHaveChildClasses());
        hm.put(CLASS_LABELS_TOKEN, this.getClassLabels());
        hm.put(CLASS_LABEL_INDENTS_TOKEN, this.getClassLabelIndents());
        hm.put(PARENT_CLASS_IDS_TOKEN, this.getParentClassIds());
        hm.put(READ_ONLY_CLASSES_TOKEN, this.getReadOnlyClasses());
        hm.put(ENROLLMENTS_TOKEN, this.getEnrollments());
        hm.put(MIN_CLASS_LIMITS_TOKEN, this.getMinClassLimits());
        hm.put(MAX_CLASS_LIMITS_TOKEN, this.getMaxClassLimits());
        hm.put(ROOM_RATIOS_TOKEN, this.getRoomRatios());
        hm.put(NUMBER_OF_ROOMS_TOKEN, this.getNumberOfRooms());
        hm.put(DEPARTMENTS_TOKEN, this.getDepartments());
        hm.put(DATE_PATTERNS_TOKEN, this.getDatePatterns());
        hm.put(DISPLAY_INSTRUCTORS_TOKEN, this.getDisplayInstructors());
        hm.put(ENABLED_FOR_STUDENT_SCHEDULING_TOKEN, this.getEnabledForStudentScheduling());
        hm.put(SUBTOTAL_INDEXES_TOKEN, this.getSubtotalIndexes());
        hm.put(TIMES_TOKEN, this.getTimes());
        hm.put(ROOMS_TOKEN, this.getRooms());
        hm.put(INSTRUCTORS_TOKEN, this.getInstructors());
        hm.put(EXTERNAL_IDS_TOKEN, this.getExternalIds());
        hm.put(CAN_DELETE_TOKEN, this.getCanDelete());
        hm.put(CAN_CANCEL_TOKEN, this.getCanCancel());
        hm.put(IS_CANCELLED_TOKEN, this.getIsCancelled());
        return hm;
    }

    private Object getObjectFromListMapAtIndex(HashMap hm, String key, int index) {
        if (hm == null || key == null || key.length() == 0 || index < 0) {
            return null;
        }
        List list = (List)hm.get(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        if (index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    private void addToClassesFromOrigClassesIndex(HashMap originalClassesMap, int classIndex) {
        this.getClassIds().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, CLASS_IDS_TOKEN, classIndex));
        this.getSubpartIds().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, SUBPART_IDS_TOKEN, classIndex));
        this.getItypes().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ITYPES_TOKEN, classIndex));
        this.getMustHaveChildClasses().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, MUST_HAVE_CHILD_CLASSES_TOKEN, classIndex));
        this.getClassLabels().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, CLASS_LABELS_TOKEN, classIndex));
        this.getClassLabelIndents().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, CLASS_LABEL_INDENTS_TOKEN, classIndex));
        this.getParentClassIds().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, PARENT_CLASS_IDS_TOKEN, classIndex));
        this.getReadOnlyClasses().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, READ_ONLY_CLASSES_TOKEN, classIndex));
        this.getEnrollments().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ENROLLMENTS_TOKEN, classIndex));
        this.getMinClassLimits().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, MIN_CLASS_LIMITS_TOKEN, classIndex));
        this.getMaxClassLimits().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, MAX_CLASS_LIMITS_TOKEN, classIndex));
        this.getRoomRatios().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ROOM_RATIOS_TOKEN, classIndex));
        this.getNumberOfRooms().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, NUMBER_OF_ROOMS_TOKEN, classIndex));
        this.getDepartments().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, DEPARTMENTS_TOKEN, classIndex));
        this.getDatePatterns().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, DATE_PATTERNS_TOKEN, classIndex));
        this.getDisplayInstructors().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, DISPLAY_INSTRUCTORS_TOKEN, classIndex));
        this.getEnabledForStudentScheduling().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ENABLED_FOR_STUDENT_SCHEDULING_TOKEN, classIndex));
        this.getSubtotalIndexes().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, SUBTOTAL_INDEXES_TOKEN, classIndex));
        this.getTimes().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, TIMES_TOKEN, classIndex));
        this.getRooms().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, ROOMS_TOKEN, classIndex));
        this.getInstructors().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, INSTRUCTORS_TOKEN, classIndex));
        this.getExternalIds().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, EXTERNAL_IDS_TOKEN, classIndex));
        this.getCanDelete().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, CAN_DELETE_TOKEN, classIndex));
        this.getCanCancel().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, CAN_CANCEL_TOKEN, classIndex));
        this.getIsCancelled().add((String)this.getObjectFromListMapAtIndex(originalClassesMap, IS_CANCELLED_TOKEN, classIndex));
    }

    public void addNewClassesBasedOnTemplate(String clsId) {
        int addNewAfterIndex = this.indexOfLastChildClass(clsId);
        int originalListSize = this.getClassIds().size();
        HashMap origListsMap = this.buildOriginalListValuesMap();
        this.resetLists();
        for (int i = 0; i <= addNewAfterIndex; ++i) {
            this.addToClassesFromOrigClassesIndex(origListsMap, i);
        }
        String parentClassId = this.getParentClassIds().get(this.getClassIds().indexOf(clsId.toString())).toString();
        this.addNewClassesBasedOnTemplate(clsId, this.nextTmpClassId((List)origListsMap.get(CLASS_IDS_TOKEN)).toString(), parentClassId.length() == 0 ? null : parentClassId);
        for (int i = addNewAfterIndex + 1; i < originalListSize; ++i) {
            this.addToClassesFromOrigClassesIndex(origListsMap, i);
        }
        this.initClassHasErrorsToFalse();
        this.setDirectionsClassesCanMove();
    }

    public void moveClassUp(String clsId) {
        int indexOfFirstClassToMove = this.getClassIds().indexOf(clsId);
        int indexOfLastClassToMove = this.indexOfLastChildClass(clsId);
        String newParentClassId = this.findNewParentClassId(clsId, DIRECTION_UP);
        if (newParentClassId != null) {
            int i;
            int indexOfClassToMoveAfter = this.indexOfLastChildClass(newParentClassId);
            int origListSize = this.getClassIds().size();
            this.getParentClassIds().set(indexOfFirstClassToMove, newParentClassId);
            HashMap origLists = this.buildOriginalListValuesMap();
            this.resetLists();
            for (i = 0; i <= indexOfClassToMoveAfter; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfFirstClassToMove; i <= indexOfLastClassToMove; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfClassToMoveAfter + 1; i < indexOfFirstClassToMove; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfLastClassToMove + 1; i < origListSize; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            this.initClassHasErrorsToFalse();
            this.setDirectionsClassesCanMove();
        }
    }

    public void moveClassDown(String clsId) {
        int indexOfFirstClassToMove = this.getClassIds().indexOf(clsId);
        int indexOfLastClassToMove = this.indexOfLastChildClass(clsId);
        String newParentClassId = this.findNewParentClassId(clsId, DIRECTION_DOWN);
        if (newParentClassId != null) {
            int i;
            int indexOfClassToMoveAfter = this.indexOfLastChildClass(newParentClassId);
            int origListSize = this.getClassIds().size();
            this.getParentClassIds().set(indexOfFirstClassToMove, newParentClassId);
            HashMap origLists = this.buildOriginalListValuesMap();
            this.resetLists();
            for (i = 0; i < indexOfFirstClassToMove; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfLastClassToMove + 1; i <= indexOfClassToMoveAfter; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfFirstClassToMove; i <= indexOfLastClassToMove; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            for (i = indexOfClassToMoveAfter + 1; i < origListSize; ++i) {
                this.addToClassesFromOrigClassesIndex(origLists, i);
            }
            this.initClassHasErrorsToFalse();
            this.setDirectionsClassesCanMove();
        }
    }

    private String findNewParentClassId(String clsId, String direction) {
        int clsIndex = this.getClassIds().indexOf(clsId);
        String clsParentId = (String)this.getParentClassIds().get(clsIndex);
        if (clsParentId == null || clsParentId.length() == 0) {
            return null;
        }
        int parentClassIndex = this.getClassIds().indexOf(clsParentId);
        String parentClassSubpartId = (String)this.getSubpartIds().get(parentClassIndex);
        if (parentClassSubpartId == null || parentClassSubpartId.length() == 0) {
            return null;
        }
        String subpartId = null;
        String parentId = null;
        if (direction.equals(DIRECTION_UP)) {
            int i;
            for (i = parentClassIndex - 1; i >= 0 && ((subpartId = (String)this.getSubpartIds().get(i)) == null || subpartId.length() <= 0 || !subpartId.equals(parentClassSubpartId) || (parentId = (String)this.getClassIds().get(i)) == null || parentId.length() <= 0 || parentId.equals(clsParentId)); --i) {
            }
            if (i >= 0) {
                return parentId;
            }
        } else if (direction.equals(DIRECTION_DOWN)) {
            int i;
            for (i = clsIndex + 1; i < this.getClassIds().size() && ((subpartId = (String)this.getSubpartIds().get(i)) == null || subpartId.length() <= 0 || !subpartId.equals(parentClassSubpartId) || (parentId = (String)this.getClassIds().get(i)) == null || parentId.length() <= 0 || parentId.equals(clsParentId)); ++i) {
            }
            if (i < this.getClassIds().size()) {
                return parentId;
            }
        }
        return null;
    }

    private void addNewClassesBasedOnTemplate(String clsId, String tmpClassId, String parentClassId) {
        int index = this.getClassIds().indexOf(clsId);
        String label = this.getClassLabels().get(index).toString();
        this.classLabels.add(label.substring(0, label.indexOf(" ")) + " New" + tmpClassId);
        this.classLabelIndents.add(this.getClassLabelIndents().get(index).toString());
        this.classIds.add(tmpClassId);
        this.subpartIds.add(this.getSubpartIds().get(index).toString());
        this.itypes.add(this.getItypes().get(index).toString());
        this.mustHaveChildClasses.add(this.getMustHaveChildClasses().get(index).toString());
        this.parentClassIds.add(parentClassId != null ? parentClassId.toString() : "");
        this.readOnlyClasses.add(new Boolean(false).toString());
        this.enrollments.add("");
        this.minClassLimits.add(this.getMinClassLimits().get(index));
        this.departments.add(this.getDepartments().get(index));
        this.datePatterns.add(this.getDatePatterns().get(index));
        this.numberOfRooms.add(this.getNumberOfRooms().get(index));
        this.maxClassLimits.add(this.getMaxClassLimits().get(index));
        this.roomRatios.add(this.getRoomRatios().get(index));
        this.displayInstructors.add(this.getDisplayInstructors().get(index));
        this.enabledForStudentScheduling.add(this.getEnabledForStudentScheduling().get(index));
        this.subtotalIndexes.add(this.getSubtotalIndexes().get(index));
        this.times.add("");
        this.rooms.add("");
        this.instructors.add("");
        this.externalIds.add("");
        ArrayList childClasses = new ArrayList();
        for (int i = index + 1; i < this.getClassIds().size(); ++i) {
            if (!this.getParentClassIds().get(i).toString().equals(clsId)) continue;
            childClasses.add(this.getClassIds().get(i));
        }
        Iterator it = childClasses.iterator();
        while (it.hasNext()) {
            this.addNewClassesBasedOnTemplate(it.next().toString(), this.nextTmpClassId(null).toString(), tmpClassId);
        }
        this.canDelete.add("true");
        this.canCancel.add("false");
        this.isCancelled.add("false");
    }

    private Long nextTmpClassId(List origClassIds) {
        long id;
        Iterator it;
        long nextId = -1L;
        if (origClassIds != null) {
            it = origClassIds.iterator();
            while (it.hasNext()) {
                id = Long.parseLong(it.next().toString());
                if (nextId < id) continue;
                nextId = id - 1L;
            }
        }
        it = this.classIds.iterator();
        while (it.hasNext()) {
            id = Long.parseLong(it.next().toString());
            if (nextId < id) continue;
            nextId = id - 1L;
        }
        return new Long(nextId);
    }

    public Long getDeletedClassId() {
        return this.deletedClassId;
    }

    public void setDeletedClassId(Long deletedClassId) {
        this.deletedClassId = deletedClassId;
    }

    public Integer getSubjectAreaId() {
        return this.subjectAreaId;
    }

    public void setSubjectAreaId(Integer subjectAreaId) {
        this.subjectAreaId = subjectAreaId;
    }

    public String getInstrOfferingName() {
        return this.instrOfferingName;
    }

    public void setInstrOfferingName(String instrOfferingName) {
        this.instrOfferingName = instrOfferingName;
    }

    public List getClassLabelIndents() {
        return this.classLabelIndents;
    }

    public void setClassLabelIndents(List classLabelIndents) {
        this.classLabelIndents = classLabelIndents;
    }

    public List getRoomRatios() {
        return this.roomRatios;
    }

    public void setRoomRatios(List roomRatios) {
        this.roomRatios = roomRatios;
    }

    public List getEnabledForStudentScheduling() {
        return this.enabledForStudentScheduling;
    }

    public void setEnabledForStudentScheduling(List enabledForStudentScheduling) {
        this.enabledForStudentScheduling = enabledForStudentScheduling;
    }

    public List getDisplayInstructors() {
        return this.displayInstructors;
    }

    public void setDisplayInstructors(List displayInstructors) {
        this.displayInstructors = displayInstructors;
    }

    public List getClassCanMoveDown() {
        return this.classCanMoveDown;
    }

    public void setClassCanMoveDown(List classCanMoveDown) {
        this.classCanMoveDown = classCanMoveDown;
    }

    public List getClassCanMoveUp() {
        return this.classCanMoveUp;
    }

    public void setClassCanMoveUp(List classCanMoveUp) {
        this.classCanMoveUp = classCanMoveUp;
    }

    public List getItypes() {
        return this.itypes;
    }

    public void setItypes(List itypes) {
        this.itypes = itypes;
    }

    public Long getMoveUpClassId() {
        return this.moveUpClassId;
    }

    public void setMoveUpClassId(Long moveUpClassId) {
        this.moveUpClassId = moveUpClassId;
    }

    public Long getMoveDownClassId() {
        return this.moveDownClassId;
    }

    public void setMoveDownClassId(Long moveDownClassId) {
        this.moveDownClassId = moveDownClassId;
    }

    public List getMustHaveChildClasses() {
        return this.mustHaveChildClasses;
    }

    public void setMustHaveChildClasses(List mustHaveChildClasses) {
        this.mustHaveChildClasses = mustHaveChildClasses;
    }

    public String getOrigSubparts() {
        return this.origSubparts;
    }

    public void setOrigSubparts(String origSubparts) {
        this.origSubparts = origSubparts;
    }

    public Boolean getDisplayMaxLimit() {
        return this.displayMaxLimit;
    }

    public void setDisplayMaxLimit(Boolean displayMaxLimit) {
        this.displayMaxLimit = displayMaxLimit;
    }

    public Boolean getDisplayOptionForMaxLimit() {
        return this.displayOptionForMaxLimit;
    }

    public void setDisplayOptionForMaxLimit(Boolean displayOptionForMaxLimit) {
        this.displayOptionForMaxLimit = displayOptionForMaxLimit;
    }

    public boolean maxLimitCanBeHidden() {
        Iterator it1 = this.getMinClassLimits().iterator();
        Iterator it2 = this.getMaxClassLimits().iterator();
        while (it1.hasNext() && it2.hasNext()) {
            String min = (String)it1.next();
            String max = (String)it2.next();
            if (min == null && max == null || min != null && max != null && min.equals(max)) continue;
            return false;
        }
        return true;
    }

    public List getSubtotalIndexes() {
        return this.subtotalIndexes;
    }

    public void setSubtotalIndexes(List subtotalIndexes) {
        this.subtotalIndexes = subtotalIndexes;
    }

    public List getSubtotalLabels() {
        return this.subtotalLabels;
    }

    public void setSubtotalLabels(List subtotalLabels) {
        this.subtotalLabels = subtotalLabels;
    }

    public List getSubtotalValues() {
        return this.subtotalValues;
    }

    public void setSubtotalValues(List subtotalValues) {
        this.subtotalValues = subtotalValues;
    }

    public String getEnableAllClassesForStudentScheduling() {
        return this.enableAllClassesForStudentScheduling;
    }

    public void setEnableAllClassesForStudentScheduling(String enableAllClassesForStudentScheduling) {
        this.enableAllClassesForStudentScheduling = enableAllClassesForStudentScheduling;
    }

    public String getDisplayAllClassesInstructors() {
        return this.displayAllClassesInstructors;
    }

    public void setDisplayAllClassesInstructors(String displayAllClassesInstructors) {
        this.displayAllClassesInstructors = displayAllClassesInstructors;
    }

    public List getEnableAllClassesForStudentSchedulingForSubpart() {
        return this.enableAllClassesForStudentSchedulingForSubpart;
    }

    public void setEnableAllClassesForStudentSchedulingForSubpart(List enableAllClassesForStudentSchedulingForSubpart) {
        this.enableAllClassesForStudentSchedulingForSubpart = enableAllClassesForStudentSchedulingForSubpart;
    }

    public List getDisplayAllClassesInstructorsForSubpart() {
        return this.displayAllClassesInstructorsForSubpart;
    }

    public void setDisplayAllClassesInstructorsForSubpart(List displayAllClassesInstructorsForSubpart) {
        this.displayAllClassesInstructorsForSubpart = displayAllClassesInstructorsForSubpart;
    }

    public List getReadOnlySubparts() {
        return this.readOnlySubparts;
    }

    public void setReadOnlySubparts(List readOnlySubparts) {
        this.readOnlySubparts = readOnlySubparts;
    }

    public List getEnrollments() {
        return this.enrollments;
    }

    public void setEnrollments(List enrollments) {
        this.enrollments = enrollments;
    }

    public Boolean getDisplayEnrollment() {
        return this.displayEnrollment;
    }

    public void setDisplayEnrollment(Boolean displayEnrollment) {
        this.displayEnrollment = displayEnrollment;
    }

    public List getTimes() {
        return this.times;
    }

    public void setTimes(List times) {
        this.times = times;
    }

    public List getRooms() {
        return this.rooms;
    }

    public void setRooms(List rooms) {
        this.rooms = rooms;
    }

    public List getInstructors() {
        return this.instructors;
    }

    public void setInstructors(List instructors) {
        this.instructors = instructors;
    }

    public Boolean getDisplayExternalId() {
        return this.displayExternalId;
    }

    public void setDisplayExternalId(Boolean displayExternalId) {
        this.displayExternalId = displayExternalId;
    }

    public Boolean getEditExternalId() {
        return this.editExternalId;
    }

    public void setEditExternalId(Boolean editExternalId) {
        this.editExternalId = editExternalId;
    }

    public Boolean getDisplayDisplayInstructors() {
        return this.displayDisplayInstructors;
    }

    public void setDisplayDisplayInstructors(Boolean displayDisplayInstructors) {
        this.displayDisplayInstructors = displayDisplayInstructors;
    }

    public Boolean getDisplayEnabledForStudentScheduling() {
        return this.displayEnabledForStudentScheduling;
    }

    public void setDisplayEnabledForStudentScheduling(Boolean displayEnabledForStudentScheduling) {
        this.displayEnabledForStudentScheduling = displayEnabledForStudentScheduling;
    }

    public List getExternalIds() {
        return this.externalIds;
    }

    public void setExternalIds(List externalIds) {
        this.externalIds = externalIds;
    }

    public List getCanDelete() {
        return this.canDelete;
    }

    public void setCanDelete(List canDelete) {
        this.canDelete = canDelete;
    }

    public List getCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(List canCancel) {
        this.canCancel = canCancel;
    }

    public List getIsCancelled() {
        return this.isCancelled;
    }

    public void setIsCancelled(List isCancelled) {
        this.isCancelled = isCancelled;
    }

    public void setCancelled(String classId, boolean cancelled) {
        int i;
        if (classId == null || classId.isEmpty()) {
            return;
        }
        if (cancelled && Long.valueOf(classId) < 0L) {
            this.removeFromClasses(classId);
            return;
        }
        for (i = 0; i < this.classIds.size(); ++i) {
            if (!classId.equals(this.classIds.get(i))) continue;
            boolean wasCancelled = "true".equals(this.isCancelled.get(i));
            this.isCancelled.set(i, cancelled ? "true" : "false");
            if (wasCancelled && !cancelled) {
                this.setCancelled((String)this.parentClassIds.get(i), false);
            }
            if (wasCancelled || !cancelled) continue;
            boolean allCancelled = true;
            for (int j = 0; j < this.subpartIds.size(); ++j) {
                if (i == j || !this.subpartIds.get(i).equals(this.subpartIds.get(j)) || !this.parentClassIds.get(i).equals(this.parentClassIds.get(j)) || "true".equals(this.isCancelled.get(j))) continue;
                allCancelled = false;
                break;
            }
            if (!allCancelled) continue;
            this.setCancelled((String)this.parentClassIds.get(i), true);
        }
        for (i = 0; i < this.parentClassIds.size(); ++i) {
            if (!classId.equals(this.parentClassIds.get(i))) continue;
            this.setCancelled((String)this.classIds.get(i), cancelled);
        }
    }

    public Long getInstructionalMethod() {
        return this.instructionalMethod;
    }

    public void setInstructionalMethod(Long instructionalMethod) {
        this.instructionalMethod = instructionalMethod;
    }

    public List<IdValue> getInstructionalMethods() {
        ArrayList<IdValue> ret = new ArrayList<IdValue>();
        for (InstructionalMethod type : InstructionalMethod.findAll()) {
            if (!type.isVisible().booleanValue() && !type.getUniqueId().equals(this.instructionalMethod)) continue;
            ret.add(new IdValue(type.getUniqueId(), type.getLabel()));
        }
        return ret;
    }
}

