/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class DistributionPrefsForm
extends ActionForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 6316876654471770646L;
    public static final String SUBJ_AREA_ATTR_LIST = "subjectAreaList";
    public static final String CRS_NUM_ATTR_LIST = "courseNbrList";
    public static final String ITYPE_ATTR_LIST = "itypeList";
    public static final String CLASS_NUM_ATTR_LIST = "classNumList";
    public static final String ALL_CLASSES_SELECT = "-1";
    public static final String LIST_SIZE_ATTR = "listSize";
    private String op;
    private String distType;
    private String prefLevel;
    private String owner;
    private String distPrefId;
    private List subjectArea;
    private List courseNbr;
    private List itype;
    private List classNumber;
    private String description;
    private String groupingDescription;
    private String grouping;
    private String filterSubjectAreaId;
    private Collection filterSubjectAreas;
    private String filterCourseNbr;
    protected DynamicListObjectFactory factoryDistObj = new DynamicListObjectFactory(){

        public Object create() {
            return "-";
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        MessageResources rsc = (MessageResources)super.getServlet().getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        if (this.distType == null || this.distType.equals("-")) {
            errors.add("distType", new ActionMessage("errors.generic", (Object)MSG.errorSelectDistributionType()));
        }
        if (this.prefLevel == null || this.prefLevel.equals("-")) {
            errors.add("prefLevel", new ActionMessage("errors.generic", (Object)MSG.errorSelectDistributionPreferenceLevel()));
        }
        if (!this.checkClasses()) {
            errors.add("classes", new ActionMessage("errors.generic", (Object)MSG.errorInvalidClassSelectionDP()));
        }
        if (this.op.equals(MSG.accessSaveNewDistributionPreference()) || this.op.equals(MSG.accessUpdateDistributionPreference())) {
            if (this.subjectArea.size() == 0) {
                errors.add("classes", new ActionMessage("errors.generic", (Object)MSG.errorInvalidClassSelectionDPSubpart()));
            }
            if (this.subjectArea.size() == 1 && !this.classNumber.get(0).toString().equals(ALL_CLASSES_SELECT)) {
                errors.add("classes", new ActionMessage("errors.generic", (Object)MSG.errorInvalidClassSelectionDPMinTwoClasses()));
            }
            if (this.subjectArea.size() > 1) {
                HashMap<String, String> mapSubparts = new HashMap<String, String>();
                HashMap<String, String> mapClasses = new HashMap<String, String>();
                for (int i = 0; i < this.subjectArea.size(); ++i) {
                    String subpart = this.itype.get(i).toString();
                    String classNum = this.classNumber.get(i).toString();
                    if (classNum.equals(ALL_CLASSES_SELECT)) {
                        if (mapClasses.get(subpart) != null) {
                            errors.add("classes", new ActionMessage("errors.generic", (Object)MSG.errorInvalidClassSelectionDPIndividualClass()));
                            break;
                        }
                        mapSubparts.put(subpart, classNum);
                        continue;
                    }
                    if (mapSubparts.get(subpart) != null) {
                        errors.add("classes", new ActionMessage("errors.generic", (Object)MSG.errorInvalidClassSelectionDPIndividualClass()));
                        break;
                    }
                    mapClasses.put(subpart, classNum);
                }
            }
        }
        return errors;
    }

    public boolean checkClasses() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.subjectArea.size(); ++i) {
            if (this.subjectArea.get(i) == null || this.subjectArea.get(i).toString().equals("-")) {
                return false;
            }
            if (this.courseNbr.get(i) == null || this.courseNbr.get(i).toString().equals("-")) {
                return false;
            }
            if (this.itype.get(i) == null || this.itype.get(i).toString().equals("-")) {
                return false;
            }
            if (this.classNumber.get(i) == null || this.classNumber.get(i).toString().equals("-")) {
                return false;
            }
            String str = this.subjectArea.get(i).toString() + this.courseNbr.get(i).toString() + this.itype.get(i).toString() + this.classNumber.get(i).toString();
            if (map.get(str) != null) {
                return false;
            }
            map.put(str, "1");
        }
        return true;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.op = "";
        this.distPrefId = "";
        this.distType = "-";
        this.prefLevel = "-";
        this.owner = "";
        this.description = "";
        this.groupingDescription = "";
        this.subjectArea = DynamicList.getInstance(new ArrayList(), this.factoryDistObj);
        this.courseNbr = DynamicList.getInstance(new ArrayList(), this.factoryDistObj);
        this.itype = DynamicList.getInstance(new ArrayList(), this.factoryDistObj);
        this.classNumber = DynamicList.getInstance(new ArrayList(), this.factoryDistObj);
        this.grouping = "-";
        this.filterSubjectAreaId = null;
        this.filterCourseNbr = null;
        this.filterSubjectAreas = new ArrayList();
    }

    public String getDistPrefId() {
        return this.distPrefId;
    }

    public void setDistPrefId(String distPrefId) {
        this.distPrefId = distPrefId;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getPrefLevel() {
        return this.prefLevel;
    }

    public void setPrefLevel(String prefLevel) {
        this.prefLevel = prefLevel;
    }

    public String getDistType() {
        return this.distType;
    }

    public void setDistType(String distType) {
        this.distType = distType;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List getSubjectArea() {
        return this.subjectArea;
    }

    public void setSubjectArea(List subjectArea) {
        this.subjectArea = subjectArea;
    }

    public String getSubjectArea(int key) {
        return this.subjectArea.get(key).toString();
    }

    public void setSubjectArea(int key, Object value) {
        this.subjectArea.set(key, value);
    }

    public void addToSubjectArea(String value) {
        this.subjectArea.add(value);
    }

    public List getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(List courseNbr) {
        this.courseNbr = courseNbr;
    }

    public String getCourseNbr(int key) {
        return this.courseNbr.get(key).toString();
    }

    public void setCourseNbr(int key, Object value) {
        this.courseNbr.set(key, value);
    }

    public void addToCourseNbr(String value) {
        this.courseNbr.add(value);
    }

    public List getItype() {
        return this.itype;
    }

    public void setItype(List itype) {
        this.itype = itype;
    }

    public String getItype(int key) {
        return this.itype.get(key).toString();
    }

    public void setItype(int key, Object value) {
        this.itype.set(key, value);
    }

    public void addToItype(String value) {
        this.itype.add(value);
    }

    public List getClassNumber() {
        return this.classNumber;
    }

    public void setClassNumber(List classNumber) {
        this.classNumber = classNumber;
    }

    public String getClassNumber(int key) {
        return this.classNumber.get(key).toString();
    }

    public void setClassNumber(int key, Object value) {
        this.classNumber.set(key, value);
    }

    public void addToClassNumber(String value) {
        this.classNumber.add(value);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroupingDescription() {
        return this.groupingDescription;
    }

    public void setGroupingDescription(String groupingDescription) {
        this.groupingDescription = groupingDescription;
    }

    public String getGrouping() {
        return this.grouping;
    }

    public DistributionPref.Structure getStructure() {
        for (DistributionPref.Structure structure : DistributionPref.Structure.values()) {
            if (!structure.getName().equals(this.grouping)) continue;
            return structure;
        }
        return DistributionPref.Structure.AllClasses;
    }

    public void setGrouping(String grouping) {
        this.grouping = grouping;
    }

    public void setStructure(DistributionPref.Structure structure) {
        this.grouping = structure == null ? DistributionPref.Structure.AllClasses.getName() : structure.getName();
    }

    public String[] getGroupings() {
        String[] ret = new String[DistributionPref.Structure.values().length];
        for (int i = 0; i < DistributionPref.Structure.values().length; ++i) {
            ret[i] = DistributionPref.Structure.values()[i].getName();
        }
        return ret;
    }

    public void addNewClass(String subjectAreaId) {
        if (subjectAreaId == null || subjectAreaId.trim().length() == 0) {
            this.addToSubjectArea("-");
        } else {
            this.addToSubjectArea(subjectAreaId);
        }
        this.addToCourseNbr("-");
        this.addToItype("-");
        this.addToClassNumber("-");
    }

    public void removeFromLists(int key) {
        this.subjectArea.remove(key);
        this.courseNbr.remove(key);
        this.itype.remove(key);
        this.classNumber.remove(key);
    }

    public void swap(int index, int index2) {
        Object objSa = this.subjectArea.get(index);
        Object objCo = this.courseNbr.get(index);
        Object objIt = this.itype.get(index);
        Object objCl = this.classNumber.get(index);
        Object objSa2 = this.subjectArea.get(index2);
        Object objCo2 = this.courseNbr.get(index2);
        Object objIt2 = this.itype.get(index2);
        Object objCl2 = this.classNumber.get(index2);
        this.subjectArea.set(index, objSa2);
        this.subjectArea.set(index2, objSa);
        this.courseNbr.set(index, objCo2);
        this.courseNbr.set(index2, objCo);
        this.itype.set(index, objIt2);
        this.itype.set(index2, objIt);
        this.classNumber.set(index, objCl2);
        this.classNumber.set(index2, objCl);
    }

    public String getFilterSubjectAreaId() {
        return this.filterSubjectAreaId;
    }

    public void setFilterSubjectAreaId(String filterSubjectAreaId) {
        this.filterSubjectAreaId = filterSubjectAreaId;
    }

    public String getFilterCourseNbr() {
        return this.filterCourseNbr;
    }

    public void setFilterCourseNbr(String filterCourseNbr) {
        this.filterCourseNbr = filterCourseNbr;
    }

    public Collection getFilterSubjectAreas() {
        return this.filterSubjectAreas;
    }

    public void setFilterSubjectAreas(Collection filterSubjectAreas) {
        this.filterSubjectAreas = filterSubjectAreas;
    }
}

