/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;

public class PDFPrinter
implements Exporter.Printer {
    private static Pattern sNumber = Pattern.compile("[+-]?[0-9]*\\.?[0-9]*[a-z]?");
    private OutputStream iOutput;
    private Object[] iLastLine = null;
    private boolean iCheckLast = false;
    private PdfPTable iTable = null;
    private float[] iMaxWidth = null;
    private Set<Integer> iHiddenColumns = new HashSet<Integer>();
    List<Element> iElements = new ArrayList<Element>();

    public PDFPrinter(OutputStream output, boolean checkLast) {
        this.iOutput = output;
        this.iCheckLast = checkLast;
    }

    public String getContentType() {
        return "application/pdf";
    }

    public void hideColumn(int col) {
        this.iHiddenColumns.add(col);
    }

    public void printHeader(String ... fields) {
        this.iTable = new PdfPTable(fields.length - this.iHiddenColumns.size());
        this.iMaxWidth = new float[fields.length];
        this.iTable.setHeaderRows(1);
        this.iTable.setWidthPercentage(100.0f);
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            String f = fields[idx];
            PdfPCell cell = new PdfPCell();
            cell.setBorder(2);
            cell.setVerticalAlignment(4);
            cell.setHorizontalAlignment(0);
            Font font = PdfFont.getFont(true);
            Paragraph ch = new Paragraph(f, font);
            ch.setLeading(0.0f, 1.0f);
            cell.addElement((Element)ch);
            this.iTable.addCell(cell);
            float width = 0.0f;
            if (f.indexOf(10) >= 0) {
                StringTokenizer s = new StringTokenizer(f, "\n");
                while (s.hasMoreTokens()) {
                    width = Math.max(width, font.getBaseFont().getWidthPoint(s.nextToken(), font.getSize()));
                }
            } else {
                width = Math.max(width, font.getBaseFont().getWidthPoint(f, font.getSize()));
            }
            this.iMaxWidth[idx] = width;
        }
    }

    public void printLine(String ... fields) {
        PdfPCellEvent setLineDashEvent = new PdfPCellEvent(){

            public void cellLayout(PdfPCell cell, Rectangle rect, PdfContentByte[] canvas) {
                PdfContentByte cb = canvas[2];
                cb.setLineDash(new float[]{2.0f, 2.0f}, 0.0f);
            }
        };
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            String f = fields[idx];
            if (f == null || f.isEmpty() || this.iCheckLast && f.equals(this.iLastLine == null || idx >= this.iLastLine.length ? null : this.iLastLine[idx])) {
                f = "";
            }
            boolean number = sNumber.matcher(f).matches();
            Font font = PdfFont.getFont();
            Phrase p = new Phrase(f, PdfFont.getSmallFont());
            PdfPCell cell = new PdfPCell(p);
            cell.setBorder(this.iLastLine == null ? 1 : 0);
            cell.setVerticalAlignment(4);
            cell.setHorizontalAlignment(number ? 2 : 0);
            cell.setPaddingBottom(4.0f);
            cell.setCellEvent(setLineDashEvent);
            if (number) {
                cell.setPaddingRight(10.0f);
            }
            this.iTable.addCell(cell);
            float width = 0.0f;
            if (f.indexOf(10) >= 0) {
                StringTokenizer s = new StringTokenizer(f, "\n");
                while (s.hasMoreTokens()) {
                    width = Math.max(width, font.getBaseFont().getWidthPoint(s.nextToken(), font.getSize()));
                }
            } else {
                width = Math.max(width, font.getBaseFont().getWidthPoint(f, font.getSize()));
            }
            this.iMaxWidth[idx] = Math.max(this.iMaxWidth[idx], width + (float)(number ? 10 : 0));
        }
        this.iLastLine = fields;
    }

    public void printLine(A ... fields) {
        PdfPCellEvent setLineDashEvent = new PdfPCellEvent(){

            public void cellLayout(PdfPCell cell, Rectangle rect, PdfContentByte[] canvas) {
                PdfContentByte cb = canvas[2];
                cb.setLineDash(new float[]{2.0f, 2.0f}, 0.0f);
            }
        };
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            A f = fields[idx];
            if (f == null || f.isEmpty() || this.iCheckLast && f.equals(this.iLastLine == null || idx >= this.iLastLine.length ? null : this.iLastLine[idx])) {
                f = new A();
            }
            PdfPCell cell = new PdfPCell();
            float rpad = 0.0f;
            cell.setBorder(this.iLastLine == null ? 1 : 0);
            cell.setVerticalAlignment(4);
            if (f.has(F.RIGHT)) {
                cell.setHorizontalAlignment(2);
                cell.setPaddingRight(10.0f);
                rpad = 10.0f;
            } else if (f.has(F.CENTER)) {
                cell.setHorizontalAlignment(1);
            } else {
                cell.setHorizontalAlignment(0);
            }
            cell.setPaddingBottom(4.0f);
            cell.setCellEvent(setLineDashEvent);
            if (f.hasImage()) {
                try {
                    cell.addElement((Element)new Chunk(f.getImage(), 0.0f, 0.0f));
                    this.iMaxWidth[idx] = Math.max(this.iMaxWidth[idx], f.getImage().getScaledWidth());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (f.hasText()) {
                Font font = PdfFont.getFont(f.has(F.BOLD), f.has(F.ITALIC));
                if (f.getColor() != null) {
                    font.setColor(f.getColor());
                }
                if (f.has(F.UNDERLINE)) {
                    font.setStyle(4);
                }
                Paragraph ch = new Paragraph(f.getText(), font);
                ch.setLeading(0.0f, 1.0f);
                cell.addElement((Element)ch);
                float width = f.getWidth(font);
                this.iMaxWidth[idx] = Math.max(this.iMaxWidth[idx], width + rpad);
            }
            if (f.hasChunks()) {
                boolean underline = false;
                for (A g : f.getChunks()) {
                    if (g.hasImage()) {
                        try {
                            cell.addElement((Element)new Chunk(g.getImage(), 0.0f, 0.0f));
                            this.iMaxWidth[idx] = Math.max(this.iMaxWidth[idx], g.getImage().getScaledWidth());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!g.hasText()) continue;
                    Font font = PdfFont.getFont(g.has(F.BOLD), g.has(F.ITALIC));
                    if (g.getColor() != null) {
                        font.setColor(g.getColor());
                    }
                    if (g.has(F.UNDERLINE)) {
                        font.setStyle(4);
                    }
                    Paragraph ch = new Paragraph(g.getText(), font);
                    ch.setLeading(0.0f, underline ? 1.4f : 1.0f);
                    cell.addElement((Element)ch);
                    float width = g.getWidth(font);
                    this.iMaxWidth[idx] = Math.max(this.iMaxWidth[idx], width + rpad);
                    underline = g.has(F.UNDERLINE);
                }
            }
            this.iTable.addCell(cell);
        }
        this.iLastLine = fields;
    }

    public void flush() {
        this.iLastLine = null;
    }

    public void close() throws IOException {
        try {
            float width = 0.0f;
            float[] w = new float[this.iMaxWidth.length - this.iHiddenColumns.size()];
            int wi = 0;
            for (int i = 0; i < this.iMaxWidth.length; ++i) {
                if (this.iHiddenColumns.contains(i)) continue;
                width += 15.0f + this.iMaxWidth[i];
                w[wi++] = this.iMaxWidth[i];
            }
            Document document = new Document(new Rectangle(60.0f + width, 60.0f + width * 0.75f), 30.0f, 30.0f, 30.0f, 30.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)this.iOutput);
            writer.setPageEvent((PdfPageEvent)new PdfEventHandler());
            document.open();
            this.iTable.setWidths(w);
            document.add((Element)this.iTable);
            document.close();
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum F {
        ITALIC,
        BOLD,
        UNDERLINE,
        RIGHT,
        CENTER;


        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags) {
            return this.in(flags) ? flags : flags + this.flag();
        }

        public int clear(int flags) {
            return this.in(flags) ? flags - this.flag() : flags;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class A {
        private List<A> iChunks = null;
        private String iText = null;
        private int iFlag = 0;
        private String iColor = null;
        private com.lowagie.text.Image iImage = null;
        private Float iMaxWidth = null;

        public A() {
        }

        public A(String text, F ... flags) {
            this.iText = text;
            for (F f : flags) {
                this.iFlag = f.set(this.iFlag);
            }
        }

        public A(A ... chunks) {
            this.iChunks = new ArrayList<A>();
            for (A ch : chunks) {
                this.iChunks.add(ch);
            }
        }

        public A(Image image) {
            try {
                this.iImage = com.lowagie.text.Image.getInstance((Image)image, (Color)Color.WHITE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public A(com.lowagie.text.Image image) {
            this.iImage = image;
        }

        public void setColor(String color) {
            if (color != null && color.startsWith("#")) {
                color = color.substring(1);
            }
            this.iColor = color;
        }

        public boolean hasColor() {
            return this.iColor != null && !this.iColor.isEmpty();
        }

        public Color getColor() {
            try {
                return this.hasColor() ? new Color(Integer.parseInt(this.iColor, 16)) : Color.BLACK;
            }
            catch (Exception e) {
                e.printStackTrace();
                return Color.BLACK;
            }
        }

        public String getText() {
            return this.iText == null ? "" : this.iText;
        }

        public boolean hasText() {
            return this.iText != null && !this.iText.isEmpty();
        }

        public boolean hasImage() {
            return this.iImage != null;
        }

        public com.lowagie.text.Image getImage() {
            return this.iImage;
        }

        public A add(A chunk) {
            if (this.iChunks == null) {
                this.iChunks = new ArrayList<A>();
            }
            this.iChunks.add(chunk);
            return this;
        }

        public List<A> getChunks() {
            return this.iChunks;
        }

        public boolean hasChunks() {
            return this.iChunks != null && !this.iChunks.isEmpty();
        }

        public int size() {
            return this.iChunks == null ? 0 : this.iChunks.size();
        }

        public A getChunk(int idx) {
            return this.iChunks.get(idx);
        }

        public boolean has(F flag) {
            return flag.in(this.iFlag);
        }

        public A set(F flag) {
            this.iFlag = flag.set(this.iFlag);
            return this;
        }

        public boolean isEmpty() {
            return !this.hasChunks() && !this.hasText() && !this.hasImage();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof A)) {
                return false;
            }
            A a = (A)o;
            if (this.size() != a.size() || !this.getText().equals(a.getText())) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.getChunk(i).equals(a.getChunk(i))) continue;
                return false;
            }
            return true;
        }

        public A bold() {
            this.set(F.BOLD);
            return this;
        }

        public A italic() {
            this.set(F.ITALIC);
            return this;
        }

        public A underline() {
            this.set(F.UNDERLINE);
            return this;
        }

        public A color(String color) {
            this.setColor(color);
            return this;
        }

        public A center() {
            this.set(F.CENTER);
            return this;
        }

        public A right() {
            this.set(F.RIGHT);
            return this;
        }

        public boolean hasMaxWidth() {
            return this.iMaxWidth != null;
        }

        public A maxWidth(Float maxWidth) {
            this.iMaxWidth = maxWidth;
            return this;
        }

        public Float getMaxWidth() {
            return this.iMaxWidth;
        }

        private float width(String text, Font font) {
            float ret = font.getBaseFont().getWidthPoint(text, font.getSize());
            return this.iMaxWidth == null ? ret : Math.min(this.iMaxWidth.floatValue(), ret);
        }

        public float getWidth(Font font) {
            if (this.hasText()) {
                if (this.getText().indexOf(10) >= 0) {
                    float width = 0.0f;
                    StringTokenizer s = new StringTokenizer(this.getText(), "\n");
                    while (s.hasMoreTokens()) {
                        width = Math.max(width, this.width(s.nextToken(), font));
                    }
                    return width;
                }
                return this.width(this.getText(), font);
            }
            return 0.0f;
        }
    }
}

