/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.export.Exporter;

public class CSVPrinter
implements Exporter.Printer {
    private PrintWriter iOut;
    private String[] iLastLine = null;
    private boolean iCheckLast = false;
    private Set<Integer> iHiddenColumns = new HashSet<Integer>();

    public CSVPrinter(PrintWriter writer, boolean checkLast) {
        this.iOut = writer;
        this.iCheckLast = checkLast;
    }

    public String getContentType() {
        return "text/csv";
    }

    public void hideColumn(int col) {
        this.iHiddenColumns.add(col);
    }

    public void printHeader(String ... fields) {
        this.printLine(fields);
    }

    public void printLine(String ... fields) {
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            String f = fields[idx];
            if (!(f == null || f.isEmpty() || this.iCheckLast && f.equals(this.iLastLine == null || idx >= this.iLastLine.length ? null : this.iLastLine[idx]))) {
                this.iOut.print("\"" + f.replace("\"", "\"\"") + "\"");
            }
            this.iOut.print(",");
        }
        this.iOut.println();
        this.iLastLine = fields;
    }

    public void flush() {
        this.iLastLine = null;
    }

    public void close() {
    }
}

