/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TravelTime;

public class TravelTimesImport
extends BaseImport {
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("traveltimes")) {
            throw new Exception("Given XML file is not a Travel Times load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            this.info("Deleting existing travel times...");
            this.getHibSession().createQuery("delete from TravelTime where session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).executeUpdate();
            this.info("Importing travel times...");
            Iterator i = root.elementIterator("from");
            while (i.hasNext()) {
                Element fromEl = (Element)i.next();
                Location from = this.findLocation(session.getUniqueId(), fromEl);
                if (from == null) continue;
                Iterator j = fromEl.elementIterator("to");
                while (j.hasNext()) {
                    Element toEl = (Element)j.next();
                    Location to = this.findLocation(session.getUniqueId(), toEl);
                    if (to == null) continue;
                    TravelTime time = new TravelTime();
                    time.setSession(session);
                    time.setLocation1Id(Math.min(from.getUniqueId(), to.getUniqueId()));
                    time.setLocation2Id(Math.max(from.getUniqueId(), to.getUniqueId()));
                    time.setDistance(Integer.parseInt(toEl.getTextTrim()));
                    this.getHibSession().saveOrUpdate((Object)time);
                }
            }
            this.info("All done.");
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    private Location findLocation(Long sessionId, Element element) {
        Room room;
        if (element.attributeValue("id") != null && (room = (Room)this.getHibSession().createQuery("select r from Room r where r.externalUniqueId=:externalId and r.building.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setString("externalId", element.attributeValue("id")).setCacheable(true).setMaxResults(1).uniqueResult()) != null) {
            return room;
        }
        if (element.attributeValue("building") != null && element.attributeValue("roomNbr") != null && (room = (Room)this.getHibSession().createQuery("select  r from Room r where r.roomNumber=:roomNbr and r.building.abbreviation = :building and r.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setString("building", element.attributeValue("building")).setString("roomNbr", element.attributeValue("roomNbr")).setCacheable(true).setMaxResults(1).uniqueResult()) != null) {
            return room;
        }
        if (element.attributeValue("name") != null) {
            room = (Room)this.getHibSession().createQuery("select  r from Room r where (r.building.abbreviation || ' ' || r.roomNumber) = :name and r.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setString("name", element.attributeValue("name")).setCacheable(true).setMaxResults(1).uniqueResult();
            if (room != null) {
                return room;
            }
            NonUniversityLocation location = (NonUniversityLocation)this.getHibSession().createQuery("select  r from NonUniversityLocation r where r.name = :name and r.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setString("name", element.attributeValue("name")).setCacheable(true).setMaxResults(1).uniqueResult();
            if (location != null) {
                return location;
            }
        }
        this.warn("Location " + element.asXML() + " not found.");
        return null;
    }
}

