/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Properties;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

public class StudentSectioningExport
extends BaseExport {
    protected static Formats.Format<Number> sTwoNumbersDF = Formats.getNumberFormat("00");

    /*
     * WARNING - void declaration
     */
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("request");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            document.addDocType("request", "-//UniTime//UniTime Student Sectioning DTD/EN", "http://www.unitime.org/interface/StudentSectioning.dtd");
            for (Student student : this.getHibSession().createQuery("select s from Student s where s.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                Element studentEl = root.addElement("student");
                studentEl.addAttribute("key", student.getExternalUniqueId() == null || student.getExternalUniqueId().isEmpty() ? student.getUniqueId().toString() : student.getExternalUniqueId());
                Element demographicsEl = studentEl.addElement("updateDemographics");
                Element nameEl = demographicsEl.addElement("name");
                if (student.getFirstName() != null) {
                    nameEl.addAttribute("first", student.getFirstName());
                }
                if (student.getMiddleName() != null) {
                    nameEl.addAttribute("middle", student.getMiddleName());
                }
                if (student.getLastName() != null) {
                    nameEl.addAttribute("last", student.getLastName());
                }
                for (AcademicAreaClassification academicAreaClassification : student.getAcademicAreaClassifications()) {
                    Element acadAreaEl = demographicsEl.addElement("acadArea");
                    acadAreaEl.addAttribute("abbv", academicAreaClassification.getAcademicArea().getAcademicAreaAbbreviation());
                    acadAreaEl.addAttribute("classification", academicAreaClassification.getAcademicClassification().getCode());
                    for (PosMajor posMajor : student.getPosMajors()) {
                        if (!posMajor.getAcademicAreas().contains(academicAreaClassification.getAcademicArea())) continue;
                        acadAreaEl.addElement("major").addAttribute("code", posMajor.getCode());
                    }
                    for (PosMinor posMinor : student.getPosMinors()) {
                        if (!posMinor.getAcademicAreas().contains(academicAreaClassification.getAcademicArea())) continue;
                        acadAreaEl.addElement("minor").addAttribute("code", posMinor.getCode());
                    }
                }
                for (PosMajor posMajor : student.getPosMajors()) {
                    if (!posMajor.getAcademicAreas().isEmpty()) continue;
                    demographicsEl.addElement("major").addAttribute("code", posMajor.getCode());
                }
                for (PosMinor posMinor : student.getPosMinors()) {
                    if (!posMinor.getAcademicAreas().isEmpty()) continue;
                    demographicsEl.addElement("minor").addAttribute("code", posMinor.getCode());
                }
                for (StudentGroup studentGroup : student.getGroups()) {
                    demographicsEl.addElement("groupAffiliation").addAttribute("code", studentGroup.getGroupAbbreviation());
                }
                for (StudentAccomodation studentAccomodation : student.getAccomodations()) {
                    demographicsEl.addElement("disability").addAttribute("code", studentAccomodation.getAbbreviation());
                }
                Element requestsEl = studentEl.addElement("updateCourseRequests").addAttribute("commit", "true");
                for (CourseDemand cd : new TreeSet<CourseDemand>(student.getCourseDemands())) {
                    if (cd.getFreeTime() != null) {
                        void var14_28;
                        Element freeTimeEl = requestsEl.addElement("freeTime");
                        String string = "";
                        for (int i = 0; i < Constants.DAY_NAMES_SHORT.length; ++i) {
                            if ((cd.getFreeTime().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                            String string2 = (String)var14_28 + Constants.DAY_NAMES_SHORT[i];
                        }
                        freeTimeEl.addAttribute("days", (String)var14_28);
                        freeTimeEl.addAttribute("startTime", StudentSectioningExport.startSlot2startTime(cd.getFreeTime().getStartSlot()));
                        freeTimeEl.addAttribute("endTime", StudentSectioningExport.startSlot2startTime(cd.getFreeTime().getStartSlot() + Constants.SLOT_LENGTH_MIN * cd.getFreeTime().getLength()));
                        freeTimeEl.addAttribute("length", String.valueOf(Constants.SLOT_LENGTH_MIN * cd.getFreeTime().getLength()));
                    }
                    if (cd.getCourseRequests().isEmpty()) continue;
                    Element courseOfferingEl = null;
                    boolean bl = true;
                    for (CourseRequest cr : new TreeSet<CourseRequest>(cd.getCourseRequests())) {
                        boolean bl2;
                        courseOfferingEl = courseOfferingEl == null ? requestsEl.addElement("courseOffering") : courseOfferingEl.addElement("alternative");
                        courseOfferingEl.addAttribute("subjectArea", cr.getCourseOffering().getSubjectAreaAbbv());
                        courseOfferingEl.addAttribute("courseNumber", cr.getCourseOffering().getCourseNbr());
                        if (bl2 && cd.isWaitlist().booleanValue()) {
                            courseOfferingEl.addAttribute("waitlist", "true");
                        }
                        if (bl2 && cd.isAlternative().booleanValue()) {
                            courseOfferingEl.addAttribute("alternative", "true");
                        }
                        if (cr.getCredit() != null && cr.getCredit() != 0) {
                            courseOfferingEl.addAttribute("credit", String.valueOf(cr.getCredit()));
                        }
                        for (StudentClassEnrollment enrollment : cr.getClassEnrollments()) {
                            Element classEl = courseOfferingEl.addElement("class");
                            Class_ clazz = enrollment.getClazz();
                            String extId = clazz.getExternalId(cr.getCourseOffering());
                            if (extId != null && !extId.isEmpty()) {
                                classEl.addAttribute("externalId", extId);
                            }
                            classEl.addAttribute("type", clazz.getSchedulingSubpart().getItypeDesc().trim());
                            classEl.addAttribute("suffix", clazz.getSectionNumberString());
                        }
                        bl2 = false;
                    }
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    private static String startSlot2startTime(int startSlot) {
        int minHrs = startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        return sTwoNumbersDF.format(minHrs / 60) + sTwoNumbersDF.format(minHrs % 60);
    }
}

