/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.dataexchange.ReservationExport;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;

public class ReservationImport
extends BaseImport {
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("reservations")) {
            throw new Exception("Given XML file is not reservations load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            String created = root.attributeValue("created");
            String dateFormat = root.attributeValue("dateFormat", ReservationExport.sDateFormat);
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            if (created != null) {
                ChangeLog.addChange(this.getHibSession(), this.getManager(), session, session, created, ChangeLog.Source.DATA_IMPORT_RESERVATIONS, ChangeLog.Operation.UPDATE, null, null);
            }
            this.info("Deleting existing reservations...");
            Iterator i = this.getHibSession().createQuery("select r from Reservation r where r.instructionalOffering.session=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list().iterator();
            while (i.hasNext()) {
                this.getHibSession().delete(i.next());
            }
            this.flush(false);
            this.info("Loading areas, majors, classifications, and student groups...");
            Hashtable<String, AcademicArea> areasByAbbv = new Hashtable<String, AcademicArea>();
            Hashtable<String, AcademicArea> areasByExtId = new Hashtable<String, AcademicArea>();
            for (AcademicArea area : this.getHibSession().createQuery("select a from AcademicArea a where a.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                areasByAbbv.put(area.getAcademicAreaAbbreviation(), area);
                if (area.getExternalUniqueId() == null) continue;
                areasByExtId.put(area.getExternalUniqueId(), area);
            }
            Hashtable<String, StudentGroup> groupsByCode = new Hashtable<String, StudentGroup>();
            Hashtable<String, StudentGroup> groupsByExtId = new Hashtable<String, StudentGroup>();
            for (StudentGroup group : this.getHibSession().createQuery("select a from StudentGroup a where a.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                groupsByCode.put(group.getGroupAbbreviation(), group);
                if (group.getExternalUniqueId() == null) continue;
                groupsByExtId.put(group.getExternalUniqueId(), group);
            }
            Hashtable<String, PosMajor> majorsByCode = new Hashtable<String, PosMajor>();
            Hashtable<String, PosMajor> majorsByExtId = new Hashtable<String, PosMajor>();
            for (PosMajor major : this.getHibSession().createQuery("select a from PosMajor a where a.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                for (AcademicArea area : major.getAcademicAreas()) {
                    majorsByCode.put(area.getAcademicAreaAbbreviation() + "|" + major.getCode(), major);
                }
                if (major.getExternalUniqueId() == null) continue;
                majorsByExtId.put(major.getExternalUniqueId(), major);
            }
            Hashtable<String, AcademicClassification> clasfsByCode = new Hashtable<String, AcademicClassification>();
            Hashtable<String, AcademicClassification> clasfsByExtId = new Hashtable<String, AcademicClassification>();
            for (AcademicClassification clasf : this.getHibSession().createQuery("select a from AcademicClassification a where a.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                clasfsByCode.put(clasf.getCode(), clasf);
                if (clasf.getExternalUniqueId() == null) continue;
                clasfsByExtId.put(clasf.getExternalUniqueId(), clasf);
            }
            this.info("Loading courses...");
            Hashtable<String, CourseOffering> corusesByExtId = new Hashtable<String, CourseOffering>();
            Hashtable<String, CourseOffering> corusesBySubjectCourseNbr = new Hashtable<String, CourseOffering>();
            for (CourseOffering course : this.getHibSession().createQuery("select a from CourseOffering a where a.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                corusesBySubjectCourseNbr.put(course.getSubjectArea().getSubjectAreaAbbreviation() + "|" + course.getCourseNbr(), course);
                if (course.getExternalUniqueId() == null) continue;
                corusesByExtId.put(course.getExternalUniqueId(), course);
            }
            SimpleDateFormat df = new SimpleDateFormat(dateFormat, Locale.US);
            this.info("Importing reservations...");
            Iterator i2 = root.elementIterator();
            while (i2.hasNext()) {
                String code;
                String extId;
                Student student;
                String studentId;
                Iterator j;
                String expire;
                Element reservationElement = (Element)i2.next();
                Reservation reservation = null;
                String type = reservationElement.attributeValue("type", "course");
                if ("individual".equals(type)) {
                    reservation = new IndividualReservation();
                } else if ("group".equals(type)) {
                    reservation = new StudentGroupReservation();
                } else if ("curriculum".equals(type)) {
                    reservation = new CurriculumReservation();
                } else if ("course".equals(type)) {
                    reservation = new CourseReservation();
                } else {
                    for (ReservationInterface.OverrideType t : ReservationInterface.OverrideType.values()) {
                        if (!t.getReference().equalsIgnoreCase(type)) continue;
                        reservation = new OverrideReservation();
                        ((OverrideReservation)reservation).setOverrideType(t);
                        break;
                    }
                    if (reservation == null) {
                        this.warn("Unknown reservation type " + type);
                        continue;
                    }
                }
                CourseOffering course = (CourseOffering)corusesBySubjectCourseNbr.get(reservationElement.attributeValue("subject") + "|" + reservationElement.attributeValue("courseNbr"));
                if (course == null || course.getInstructionalOffering() == null) {
                    this.warn("Unknown course " + reservationElement.attributeValue("subject") + " " + reservationElement.attributeValue("courseNbr"));
                    continue;
                }
                reservation.setInstructionalOffering(course.getInstructionalOffering());
                String limit = reservationElement.attributeValue("limit");
                if (limit != null) {
                    try {
                        reservation.setLimit(Integer.parseInt(limit));
                    }
                    catch (NumberFormatException e) {
                        this.warn("Unable to parse reservation limit " + limit);
                    }
                }
                if ((expire = reservationElement.attributeValue("expire")) != null) {
                    try {
                        reservation.setExpirationDate(df.parse(expire));
                    }
                    catch (Exception e) {
                        this.warn("Unable to parse reservation expiration date " + expire);
                    }
                }
                reservation.setConfigurations(new HashSet<InstrOfferingConfig>());
                Iterator j2 = reservationElement.elementIterator("configuration");
                while (j2.hasNext()) {
                    String name = ((Element)j2.next()).attributeValue("name");
                    InstrOfferingConfig config = null;
                    for (InstrOfferingConfig c : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                        if (!name.equals(c.getName())) continue;
                        config = c;
                        break;
                    }
                    if (config == null) {
                        this.warn("Unable to find configuration " + name + " of course " + course.getCourseName());
                        continue;
                    }
                    reservation.getConfigurations().add(config);
                }
                reservation.setClasses(new HashSet<Class_>());
                j2 = reservationElement.elementIterator("class");
                while (j2.hasNext()) {
                    Element classEl = (Element)j2.next();
                    String extId2 = classEl.attributeValue("externalId");
                    String itype = classEl.attributeValue("type");
                    String suffix = classEl.attributeValue("suffix");
                    Class_ clazz = null;
                    block18: for (InstrOfferingConfig c : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                        for (SchedulingSubpart s : c.getSchedulingSubparts()) {
                            if (itype != null && !itype.equals(s.getItypeDesc().trim())) continue;
                            for (Class_ z : s.getClasses()) {
                                if (extId2 != null && extId2.equals(z.getExternalUniqueId())) {
                                    clazz = z;
                                    break block18;
                                }
                                if (extId2 != null || !suffix.equals(z.getSectionNumberString(this.getHibSession()))) continue;
                                clazz = z;
                                break block18;
                            }
                        }
                    }
                    if (clazz == null) {
                        this.warn("Unable to find clazz " + (extId2 == null ? itype + " " + suffix : extId2) + " of course " + course.getCourseName());
                        continue;
                    }
                    reservation.getClasses().add(clazz);
                }
                if ("individual".equals(type)) {
                    IndividualReservation individual = (IndividualReservation)reservation;
                    individual.setStudents(new HashSet<Student>());
                    j = reservationElement.elementIterator("student");
                    while (j.hasNext()) {
                        studentId = ((Element)j.next()).attributeValue("externalId");
                        student = Student.findByExternalId(session.getUniqueId(), studentId);
                        if (student == null) {
                            this.warn("Unable to find student " + student);
                            continue;
                        }
                        individual.getStudents().add(student);
                    }
                    if (individual.getStudents().isEmpty()) {
                        this.warn("Individual reservation of course " + course.getCourseName() + " has no students.");
                        continue;
                    }
                } else if ("group".equals(type)) {
                    StudentGroupReservation group = (StudentGroupReservation)reservation;
                    j = reservationElement.elementIterator("studentGroup");
                    while (j.hasNext()) {
                        StudentGroup sg;
                        Element groupEl = (Element)j.next();
                        extId = groupEl.attributeValue("externalId");
                        code = groupEl.attributeValue("code");
                        StudentGroup studentGroup = sg = extId == null ? (StudentGroup)groupsByCode.get(code) : (StudentGroup)groupsByExtId.get(extId);
                        if (sg == null) {
                            this.warn("Unable to find student group " + (extId == null ? code : extId));
                            continue;
                        }
                        group.setGroup(sg);
                        break;
                    }
                    if (group.getGroup() == null) {
                        this.warn("Group reservation of course " + course.getCourseName() + " has no student group.");
                    }
                } else if ("curriculum".equals(type)) {
                    CurriculumReservation curriculum = (CurriculumReservation)reservation;
                    j = reservationElement.elementIterator("academicArea");
                    while (j.hasNext()) {
                        AcademicArea area;
                        Element areaEl = (Element)j.next();
                        extId = areaEl.attributeValue("externalId");
                        String abbv = areaEl.attributeValue("abbreviation");
                        AcademicArea academicArea = area = extId == null ? (AcademicArea)areasByAbbv.get(abbv) : (AcademicArea)areasByExtId.get(extId);
                        if (area == null) {
                            this.warn("Unable to find academic area " + (extId == null ? area : extId));
                            continue;
                        }
                        curriculum.setArea(area);
                        break;
                    }
                    if (curriculum.getArea() == null) {
                        this.warn("Curriculum reservation of course " + course.getCourseName() + " has no academic area.");
                    }
                    curriculum.setClassifications(new HashSet<AcademicClassification>());
                    j = reservationElement.elementIterator("academicClassification");
                    while (j.hasNext()) {
                        AcademicClassification clasf;
                        Element clasfEl = (Element)j.next();
                        extId = clasfEl.attributeValue("externalId");
                        code = clasfEl.attributeValue("code");
                        AcademicClassification academicClassification = clasf = extId == null ? (AcademicClassification)clasfsByCode.get(code) : (AcademicClassification)clasfsByExtId.get(extId);
                        if (clasf == null) {
                            this.warn("Unable to find academic classification " + (extId == null ? code : extId));
                            continue;
                        }
                        curriculum.getClassifications().add(clasf);
                    }
                    curriculum.setMajors(new HashSet<PosMajor>());
                    j = reservationElement.elementIterator("major");
                    while (j.hasNext()) {
                        PosMajor major;
                        Element majorEl = (Element)j.next();
                        extId = majorEl.attributeValue("externalId");
                        code = majorEl.attributeValue("code");
                        PosMajor posMajor = major = extId == null ? (PosMajor)majorsByCode.get(curriculum.getArea().getAcademicAreaAbbreviation() + "|" + code) : (PosMajor)majorsByExtId.get(extId);
                        if (major == null) {
                            this.warn("Unable to find major " + (extId == null ? curriculum.getArea().getAcademicAreaAbbreviation() + " " + code : extId));
                            continue;
                        }
                        curriculum.getMajors().add(major);
                    }
                } else if ("course".equals(type)) {
                    course.setReservation(reservation.getLimit());
                    reservation.setLimit(null);
                    this.getHibSession().saveOrUpdate((Object)course);
                    if (reservation.getConfigurations().isEmpty() && reservation.getClasses().isEmpty()) continue;
                    ((CourseReservation)reservation).setCourse(course);
                } else {
                    OverrideReservation override = (OverrideReservation)reservation;
                    override.setStudents(new HashSet<Student>());
                    j = reservationElement.elementIterator("student");
                    while (j.hasNext()) {
                        studentId = ((Element)j.next()).attributeValue("externalId");
                        student = Student.findByExternalId(session.getUniqueId(), studentId);
                        if (student == null) {
                            this.warn("Unable to find student " + student);
                            continue;
                        }
                        override.getStudents().add(student);
                    }
                    if (override.getStudents().isEmpty()) {
                        this.warn("Override reservation of course " + course.getCourseName() + " has no students.");
                        continue;
                    }
                }
                this.getHibSession().saveOrUpdate((Object)reservation);
            }
            this.info("All done.");
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

