/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructorSearchForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.InstructorListBuilder;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/instructorList")
public class InstructorListAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Department d;
        PdfWebTable table;
        this.sessionContext.checkPermission(Right.Instructors);
        InstructorSearchForm instructorSearchForm = (InstructorSearchForm)form;
        ActionMessages errors = new ActionMessages();
        String op = instructorSearchForm.getOp();
        String deptId = (String)request.getAttribute("deptId");
        if (deptId == null) {
            deptId = request.getParameter("deptId");
        }
        if (deptId != null) {
            instructorSearchForm.setDeptUniqueId(deptId);
        }
        if (this.sessionContext.getAttribute(SessionAttribute.DepartmentId) != null && (this.sessionContext.getAttribute(SessionAttribute.DepartmentId).equals(instructorSearchForm.getDeptUniqueId()) || instructorSearchForm.getDeptUniqueId().equalsIgnoreCase(""))) {
            instructorSearchForm.setDeptUniqueId(this.sessionContext.getAttribute(SessionAttribute.DepartmentId).toString());
        }
        if (!instructorSearchForm.getDeptUniqueId().equalsIgnoreCase("")) {
            this.sessionContext.setAttribute(SessionAttribute.DepartmentId, (Object)instructorSearchForm.getDeptUniqueId());
        }
        if (request.getAttribute(Department.DEPT_ATTR_NAME) != null) {
            request.setAttribute(Department.DEPT_ATTR_NAME, request.getAttribute(Department.DEPT_ATTR_NAME));
        } else {
            this.setupManagerDepartments(request);
        }
        errors = instructorSearchForm.validate(mapping, request);
        if (errors.size() > 0) {
            this.saveErrors(request, errors);
            return mapping.findForward("showInstructorSearch");
        }
        WebTable.setOrder(this.sessionContext, "instructorList.ord", request.getParameter("order"), 2);
        InstructorListBuilder ilb = new InstructorListBuilder();
        String backId = "PreferenceGroup".equals(request.getParameter("backType")) ? request.getParameter("backId") : null;
        String tblData = ilb.htmlTableForInstructor(this.sessionContext, instructorSearchForm.getDeptUniqueId(), WebTable.getOrder(this.sessionContext, "instructorList.ord"), backId);
        if (tblData == null || tblData.trim().isEmpty()) {
            errors.add("searchResult", new ActionMessage("errors.generic", (Object)MSG.errorNoInstructorsFoundInSearch()));
            this.saveErrors(request, errors);
        } else if (MSG.actionExportPdf().equals(op) && (table = ilb.pdfTableForInstructor(this.sessionContext, instructorSearchForm.getDeptUniqueId())) != null) {
            ExportUtils.exportPDF(table, WebTable.getOrder(this.sessionContext, "instructorList.ord"), response, "instructors");
            return null;
        }
        if (deptId != null) {
            d = (Department)new DepartmentDAO().get(Long.valueOf(deptId));
            if (d != null) {
                BackTracker.markForBack(request, "instructorList.do?deptId=" + d.getUniqueId(), MSG.backInstructors(d.getDeptCode() + " - " + d.getName()), true, true);
            }
        } else if (this.sessionContext.getAttribute(SessionAttribute.DepartmentId) != null) {
            d = (Department)new DepartmentDAO().get(Long.valueOf(this.sessionContext.getAttribute(SessionAttribute.DepartmentId).toString()));
            if (d != null) {
                BackTracker.markForBack(request, "instructorList.do?deptId=" + d.getUniqueId(), MSG.backInstructors(d.getDeptCode() + " - " + d.getName()), true, true);
            }
        } else {
            BackTracker.markForBack(request, "instructorList.do", MSG.backInstructors2(), true, true);
        }
        request.setAttribute("instructorList", (Object)tblData);
        this.saveErrors(request, errors);
        return mapping.findForward("showInstructorList");
    }

    private void setupManagerDepartments(HttpServletRequest request) throws Exception {
        Vector<LabelValueBean> labelValueDepts = new Vector<LabelValueBean>();
        for (Department d : Department.getUserDepartments(this.sessionContext.getUser())) {
            labelValueDepts.add(new LabelValueBean(d.getDeptCode() + "-" + d.getName(), d.getUniqueId().toString()));
        }
        if (labelValueDepts.size() == 1) {
            request.setAttribute("deptId", (Object)((LabelValueBean)labelValueDepts.get(0)).getValue());
        }
        request.setAttribute(Department.DEPT_ATTR_NAME, labelValueDepts);
    }
}

