/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.Email;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.backup.SessionBackupInterface;
import org.unitime.timetable.backup.SessionRestoreInterface;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.DataImportForm;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.queue.QueueItem;
import org.unitime.timetable.util.queue.QueueProcessor;

@Service(value="/dataImport")
public class DataImportAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        WebTable table;
        ActionErrors errors;
        DataImportForm myForm = (DataImportForm)form;
        String op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        this.sessionContext.checkPermission(Right.DataExchange);
        if (op == null) {
            myForm.setAddress(this.sessionContext.getUser().getEmail());
        }
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        if ("Import".equals(op)) {
            errors = myForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
                return mapping.findForward("display");
            }
            QueueProcessor.getInstance().add(new ImportQueItem(session, this.sessionContext.getUser(), myForm, request));
        }
        if ("Export".equals(op)) {
            errors = myForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
                return mapping.findForward("display");
            }
            QueueProcessor.getInstance().add(new ExportQueItem(session, this.sessionContext.getUser(), myForm, request));
        }
        if (request.getParameter("remove") != null) {
            QueueProcessor.getInstance().remove(Long.valueOf(request.getParameter("remove")));
        }
        if ((table = this.getQueueTable(request)) != null) {
            request.setAttribute("table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "dataImport.ord")));
        }
        return mapping.findForward("display");
    }

    private WebTable getQueueTable(HttpServletRequest request) {
        WebTable.setOrder(this.sessionContext, "dataImport.ord", request.getParameter("ord"), 1);
        String log = request.getParameter("log");
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        List<QueueItem> queue = QueueProcessor.getInstance().getItems(null, null, "Data Exchange");
        if (queue.isEmpty()) {
            return null;
        }
        WebTable table = new WebTable(9, "Data exchange in progress", "dataImport.do?ord=%%", new String[]{"Name", "Status", "Progress", "Owner", "Session", "Created", "Started", "Finished", "Output"}, new String[]{"left", "left", "right", "left", "left", "left", "left", "left", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        Date now = new Date();
        long timeToShow = 3600000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow || item.getSession() == null) continue;
            String name = item.name();
            if (name.length() > 60) {
                name = name.substring(0, 57) + "...";
            }
            String delete = null;
            if (this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId()) && (item.started() == null || item.finished() != null)) {
                delete = "<img src='images/action_delete.png' border='0' onClick=\"if (confirm('Do you really want to remove this data exchange?')) document.location='dataImport.do?remove=" + item.getId() + "'; event.cancelBubble=true;\">";
            }
            WebTable.WebTableLine line = table.addLine("onClick=\"document.location='dataImport.do?log=" + item.getId() + "';\"", new String[]{name + (delete == null ? "" : " " + delete), item.status(), item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%", item.getOwnerName(), item.getSession().getLabel(), df.format(item.created()), item.started() == null ? "" : df.format(item.started()), item.finished() == null ? "" : df.format(item.finished()), item.hasOutput() ? "<A href='temp/" + item.output().getName() + "'>" + item.output().getName().substring(item.output().getName().lastIndexOf(46) + 1).toUpperCase() + "</A>" : ""}, new Comparable[]{item.getId(), item.status(), Double.valueOf(item.progress()), item.getOwnerName(), item.getSession(), Long.valueOf(item.created().getTime()), Long.valueOf(item.started() == null ? Long.MAX_VALUE : item.started().getTime()), Long.valueOf(item.finished() == null ? Long.MAX_VALUE : item.finished().getTime()), null});
            if (log != null && log.equals(item.getId().toString())) {
                request.setAttribute("logname", (Object)name);
                request.setAttribute("logid", (Object)item.getId().toString());
                request.setAttribute("log", (Object)item.log());
                line.setBgColor("rgb(168,187,225)");
            }
            if (log != null || item.started() == null || item.finished() != null || !this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId())) continue;
            request.setAttribute("logname", (Object)name);
            request.setAttribute("logid", (Object)item.getId().toString());
            request.setAttribute("log", (Object)item.log());
            line.setBgColor("rgb(168,187,225)");
        }
        return table;
    }

    public class ExportQueItem
    extends DataExchangeQueueItem {
        public ExportQueItem(Session session, UserContext owner, DataImportForm form, HttpServletRequest request) {
            super(session, owner, form, request, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void executeDataExchange() throws Exception {
            block7: {
                DataImportForm.ExportType type = this.iForm.getExportType();
                if (type == DataImportForm.ExportType.SESSION) {
                    FileOutputStream out = new FileOutputStream(this.createOutput("session", "dat"));
                    try {
                        SessionBackupInterface backup = (SessionBackupInterface)Class.forName(ApplicationProperty.SessionBackupInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                        backup.backup(out, this.iProgress, this.getSessionId());
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        out.close();
                        throw throwable;
                    }
                    out.close();
                    {
                        break block7;
                    }
                }
                Properties params = new Properties();
                type.setOptions(params);
                Document document = DataExchangeHelper.exportDocument(type.getType(), this.getSession(), params, this);
                if (document == null) {
                    this.error("XML document not created: unknown reason.");
                } else {
                    FileOutputStream fos = new FileOutputStream(this.createOutput(type.getType(), "xml"));
                    try {
                        new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
                        fos.flush();
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                    {
                    }
                }
            }
        }
    }

    public class ImportQueItem
    extends DataExchangeQueueItem {
        public ImportQueItem(Session session, UserContext owner, DataImportForm form, HttpServletRequest request) {
            super(session, owner, form, request, true);
        }

        protected void executeDataExchange() throws Exception {
            if (this.iForm.getFile().getFileName().toLowerCase().endsWith(".dat")) {
                SessionRestoreInterface restore = (SessionRestoreInterface)Class.forName(ApplicationProperty.SessionRestoreInterface.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
                restore.restore(this.iForm.getFile().getInputStream(), this.iProgress);
            } else {
                DataExchangeHelper.importDocument(new SAXReader().read(this.iForm.getFile().getInputStream()), this.getOwnerId(), this);
            }
        }
    }

    public abstract class DataExchangeQueueItem
    extends QueueItem
    implements DataExchangeHelper.LogWriter {
        DataImportForm iForm;
        String iUrl;
        boolean iImport;
        String iSessionName;
        Progress iProgress;

        public DataExchangeQueueItem(Session session, UserContext owner, DataImportForm form, HttpServletRequest request, boolean isImport) {
            super(session, owner);
            this.iForm = (DataImportForm)((Object)form.clone());
            this.iUrl = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            this.iImport = isImport;
            this.iSessionName = session.getAcademicTerm() + session.getAcademicYear() + session.getAcademicInitiative();
            this.iProgress = Progress.getInstance((Object)this);
            this.iProgress.addProgressListener(new ProgressListener(){

                public void statusChanged(String status) {
                    DataExchangeQueueItem.this.log(status);
                }

                public void progressSaved() {
                }

                public void progressRestored() {
                }

                public void progressMessagePrinted(Progress.Message message) {
                    DataExchangeQueueItem.this.log(message.toHtmlString());
                }

                public void progressChanged(long currentProgress, long maxProgress) {
                }

                public void phaseChanged(String phase) {
                }
            });
        }

        public double progress() {
            double p = this.iProgress.getProgress();
            long m = this.iProgress.getProgressMax();
            return m <= 0L ? 0.0 : (p >= (double)m ? 1.0 : p / (double)m);
        }

        public String status() {
            String phase = this.iProgress.getPhase();
            return phase == null || phase.isEmpty() ? super.status() : phase;
        }

        public String type() {
            return "Data Exchange";
        }

        public String name() {
            return this.iImport ? "Import of " + this.iForm.getFile().getFileName() : "Export of " + this.iForm.getExportType().getLabel();
        }

        public void println(String message) {
            this.log(message);
        }

        abstract void executeDataExchange() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute() throws Exception {
            block9: {
                try {
                    try {
                        this.log(this.iImport ? "Importing " + this.iForm.getFile().getFileName() + " (" + this.iForm.getFile().getFileSize() + " bytes)..." : "Exporting " + this.iForm.getExportType().getType() + "...");
                        Long start = System.currentTimeMillis();
                        this.executeDataExchange();
                        Long stop = System.currentTimeMillis();
                        this.log((this.iImport ? "Import" : "Export") + " finished in " + new DecimalFormat("0.00").format((double)(stop - start) / 1000.0) + " seconds.");
                    }
                    catch (Exception e) {
                        this.error("Unable to " + (this.iImport ? "import " + this.iForm.getFile().getFileName() : "export") + ": " + e.getMessage());
                        Debug.error(e);
                        this.setError(e);
                        Object var4_6 = null;
                        Progress.removeInstance((Object)this);
                        break block9;
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    Progress.removeInstance((Object)this);
                    throw throwable;
                }
                Progress.removeInstance((Object)this);
            }
            if (!this.iForm.getEmail()) return;
            String address = this.iForm.getAddress();
            if (address == null || address.isEmpty()) {
                address = this.getOwnerEmail();
            }
            if (address == null) return;
            if (address.isEmpty()) return;
            try {
                Email mail = Email.createEmail();
                mail.setSubject("Data " + (this.iImport ? "import" : "export") + " finished.");
                mail.setHTML(this.log() + "<br><br>" + "This email was automatically generated at " + this.iUrl + ", by " + "UniTime " + Constants.getVersion() + " (Univesity Timetabling Application, http://www.unitime.org).");
                mail.addRecipient(address, this.getOwnerName());
                if (ApplicationProperty.EmailNotificationDataExchange.isTrue()) {
                    mail.addNotifyCC();
                }
                if (!this.iImport && this.hasOutput() && this.output().exists()) {
                    mail.addAttachment(this.output(), this.iSessionName + "_" + this.iForm.getExportType().getType() + "." + this.output().getName().substring(this.output().getName().lastIndexOf(46) + 1));
                }
                mail.send();
                return;
            }
            catch (Exception e) {
                this.error("Unable to send email: " + e.getMessage());
                Debug.error(e);
                this.setError(e);
            }
        }
    }
}

