/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.web.htmlgen;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class GeneralHtml {
    private String styleClass;
    private String style;
    private String title;
    private String id;
    private String dir;
    private String lang;
    private String tag;
    private ArrayList contents;

    public GeneralHtml() {
        this.setContents(new ArrayList());
    }

    public ArrayList getContents() {
        return this.contents;
    }

    public void setContents(ArrayList contents) {
        this.contents = contents;
    }

    public void addContent(Object obj) {
        this.getContents().add(obj);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTag() {
        return this.tag;
    }

    protected void setTag(String tag) {
        this.tag = tag;
    }

    public String startTagHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.getTag());
        sb.append(this.htmlForAttributes());
        sb.append(">\n");
        return sb.toString();
    }

    public String endTagHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("</");
        sb.append(this.getTag());
        sb.append(">\n");
        return sb.toString();
    }

    public String toHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.startTagHtml());
        sb.append(this.contentHtml());
        sb.append(this.endTagHtml());
        return sb.toString();
    }

    protected String htmlForAttributes() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.htmlForAttribute("class", this.getStyleClass()));
        sb.append(this.htmlForAttribute("style", this.getStyle()));
        sb.append(this.htmlForAttribute("id", this.getId()));
        sb.append(this.htmlForAttribute("title", this.getTitle()));
        sb.append(this.htmlForAttribute("dir", this.getDir()));
        sb.append(this.htmlForAttribute("lang", this.getLang()));
        return sb.toString();
    }

    protected String htmlForObject(Object obj) {
        StringBuffer sb = new StringBuffer();
        if (obj != null) {
            if (GeneralHtml.class.isInstance(obj)) {
                sb.append(((GeneralHtml)obj).toHtml());
            } else if (AbstractCollection.class.isInstance(obj)) {
                Iterator colIt = ((AbstractCollection)obj).iterator();
                while (colIt.hasNext()) {
                    sb.append(this.htmlForObject(colIt.next()));
                }
            } else {
                sb.append(obj.toString());
            }
        }
        return sb.toString();
    }

    protected String contentHtml() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.getContents().iterator();
        while (it.hasNext()) {
            sb.append(this.htmlForObject(it.next()));
        }
        return sb.toString();
    }

    protected String htmlForAttribute(String attributeName, String attributeValue) {
        StringBuffer sb = new StringBuffer();
        if (attributeName != null && attributeName.length() != 0 && attributeValue != null && attributeValue.length() != 0) {
            sb.append(" " + attributeName + "=" + "\"" + attributeValue + "\"");
        }
        return sb.toString();
    }

    protected String htmlForAttribute(String attributeName, boolean attributeValue) {
        StringBuffer sb = new StringBuffer();
        if (attributeName != null && attributeName.length() != 0 && attributeValue) {
            sb.append(" " + attributeName);
        }
        return sb.toString();
    }

    protected String htmlForAttribute(String attributeName, int attributeValue) {
        StringBuffer sb = new StringBuffer();
        if (attributeName != null && attributeName.length() != 0) {
            sb.append(" " + attributeName + "=" + "\"" + Integer.toString(attributeValue) + "\"");
        }
        return sb.toString();
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }
}

