/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class CourseLimit
extends GlobalConstraint<Request, Enrollment> {
    private static double sNominalWeight = 1.0E-5;
    private boolean iPreferDummyStudents = false;

    public CourseLimit(DataProperties cfg) {
        this.iPreferDummyStudents = cfg.getPropertyBoolean("CourseLimit.PreferDummyStudents", false);
    }

    public static double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Course course, Request request) {
        return course.getEnrollmentWeight(assignment, request) + request.getWeight() - Math.max(course.getMaxEnrollmentWeight(assignment), request.getWeight()) + sNominalWeight;
    }

    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return;
        }
        Course course = enrollment.getCourse();
        if (course == null) {
            return;
        }
        if (course.getLimit() < 0) {
            return;
        }
        double enrlWeight = CourseLimit.getEnrollmentWeight(assignment, course, enrollment.getRequest());
        if (enrlWeight <= (double)course.getLimit()) {
            return;
        }
        ArrayList<Enrollment> adepts = new ArrayList<Enrollment>(course.getEnrollments(assignment).size());
        for (Enrollment e : course.getEnrollments(assignment)) {
            if (e.getRequest().equals(enrollment.getRequest()) || e.getReservation() != null && e.getReservation().canBatchAssignOverLimit()) continue;
            if (conflicts.contains(e)) {
                enrlWeight -= e.getRequest().getWeight();
                continue;
            }
            adepts.add(e);
        }
        while (enrlWeight > (double)course.getLimit()) {
            if (adepts.isEmpty()) {
                conflicts.add(enrollment);
                break;
            }
            ArrayList<Enrollment> best = new ArrayList<Enrollment>();
            boolean bestDummy = false;
            double bestValue = 0.0;
            for (Enrollment adept : adepts) {
                boolean dummy = adept.getStudent().isDummy();
                double value = adept.toDouble(assignment, false);
                if (this.iPreferDummyStudents && dummy != bestDummy) {
                    if (!dummy) continue;
                    best.clear();
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    continue;
                }
                if (best.isEmpty() || value > bestValue) {
                    if (best.isEmpty()) {
                        best.clear();
                    }
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    continue;
                }
                if (bestValue != value) continue;
                best.add(adept);
            }
            Enrollment conflict = (Enrollment)ToolBox.random(best);
            adepts.remove(conflict);
            enrlWeight -= conflict.getRequest().getWeight();
            conflicts.add(conflict);
        }
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        if (enrollment.getReservation() != null && enrollment.getReservation().canBatchAssignOverLimit()) {
            return false;
        }
        Course course = enrollment.getCourse();
        if (course == null) {
            return false;
        }
        if (course.getLimit() < 0) {
            return false;
        }
        double enrlWeight = CourseLimit.getEnrollmentWeight(assignment, course, enrollment.getRequest());
        return enrlWeight > (double)course.getLimit();
    }

    public String toString() {
        return "CourseLimit";
    }
}

