/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import org.cpsolver.exam.criteria.InstructorBackToBackConflicts;
import org.cpsolver.exam.criteria.InstructorDistanceBackToBackConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamOwner;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;

public class ExamInstructorConflicts {
    private ExamModel iModel = null;

    public ExamInstructorConflicts(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("Instructor"), new CSVFile.CSVField("Type"), new CSVFile.CSVField("Section/Course"), new CSVFile.CSVField("Period"), new CSVFile.CSVField("Day"), new CSVFile.CSVField("Time"), new CSVFile.CSVField("Room"), new CSVFile.CSVField("Distance")});
        boolean isDayBreakBackToBack = ((InstructorBackToBackConflicts)this.iModel.getCriterion(InstructorBackToBackConflicts.class)).isDayBreakBackToBack();
        double backToBackDistance = ((InstructorDistanceBackToBackConflicts)this.iModel.getCriterion(InstructorDistanceBackToBackConflicts.class)).getBackToBackDistance();
        for (ExamInstructor instructor : this.iModel.getInstructors()) {
            for (ExamPeriod period : this.iModel.getPeriods()) {
                int nrExamsADay;
                String periodTimes;
                String periodDays;
                String periods;
                int nrExams = instructor.getExams(assignment, period).size();
                if (nrExams > 1) {
                    String sections = "";
                    String rooms = "";
                    periods = String.valueOf(period.getIndex() + 1);
                    periodDays = period.getDayStr();
                    periodTimes = period.getTimeStr();
                    for (Exam exam : instructor.getExams(assignment, period)) {
                        ExamPlacement placement = assignment.getValue(exam);
                        String roomsThisExam = "";
                        for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                            if (roomsThisExam.length() > 0) {
                                roomsThisExam = roomsThisExam + ", ";
                            }
                            roomsThisExam = roomsThisExam + room.getName();
                        }
                        boolean first = true;
                        for (ExamOwner owner : exam.getOwners(instructor)) {
                            if (sections.length() > 0) {
                                sections = sections + "\n";
                                rooms = rooms + "\n";
                                periods = periods + "\n";
                                periodDays = periodDays + "\n";
                                periodTimes = periodTimes + "\n";
                            }
                            sections = sections + owner.getName();
                            if (first) {
                                rooms = rooms + roomsThisExam;
                            }
                            first = false;
                        }
                        if (!exam.getOwners(instructor).isEmpty()) continue;
                        sections = sections + exam.getName();
                        rooms = rooms + roomsThisExam;
                    }
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(instructor.getName()), new CSVFile.CSVField("direct"), new CSVFile.CSVField(sections), new CSVFile.CSVField(periods), new CSVFile.CSVField(periodDays), new CSVFile.CSVField(periodTimes), new CSVFile.CSVField(rooms)});
                }
                if (!(nrExams <= 0 || period.next() == null || instructor.getExams(assignment, period.next()).isEmpty() || isDayBreakBackToBack && period.next().getDay() != period.getDay())) {
                    for (Exam ex1 : instructor.getExams(assignment, period)) {
                        for (Exam ex2 : instructor.getExams(assignment, period.next())) {
                            double dist;
                            ExamPlacement placement = assignment.getValue(ex1);
                            String sections = "";
                            String rooms = "";
                            String roomsThisExam = "";
                            String periods2 = String.valueOf(period.getIndex() + 1);
                            String periodDays2 = period.getDayStr();
                            String periodTimes2 = period.getTimeStr();
                            for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                                if (roomsThisExam.length() > 0) {
                                    roomsThisExam = roomsThisExam + ", ";
                                }
                                roomsThisExam = roomsThisExam + room.getName();
                            }
                            boolean first = true;
                            for (ExamOwner owner : ex1.getOwners(instructor)) {
                                if (sections.length() > 0) {
                                    sections = sections + "\n";
                                    rooms = rooms + "\n";
                                    periods2 = periods2 + "\n";
                                    periodDays2 = periodDays2 + "\n";
                                    periodTimes2 = periodTimes2 + "\n";
                                }
                                sections = sections + owner.getName();
                                if (first) {
                                    rooms = rooms + roomsThisExam;
                                }
                                first = false;
                            }
                            if (ex1.getOwners(instructor).isEmpty()) {
                                sections = sections + ex1.getName();
                                rooms = rooms + roomsThisExam;
                            }
                            placement = assignment.getValue(ex2);
                            roomsThisExam = "";
                            for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                                if (roomsThisExam.length() > 0) {
                                    roomsThisExam = roomsThisExam + ", ";
                                }
                                roomsThisExam = roomsThisExam + room.getName();
                            }
                            first = true;
                            for (ExamOwner owner : ex2.getOwners(instructor)) {
                                sections = sections + "\n";
                                rooms = rooms + "\n";
                                periods2 = periods2 + "\n";
                                periodDays2 = periodDays2 + "\n";
                                periodTimes2 = periodTimes2 + "\n";
                                sections = sections + owner.getName();
                                if (first) {
                                    rooms = rooms + roomsThisExam;
                                    periods2 = periods2 + String.valueOf(period.next().getIndex() + 1);
                                    periodDays2 = periodDays2 + period.next().getDayStr();
                                    periodTimes2 = periodTimes2 + period.next().getTimeStr();
                                }
                                first = false;
                            }
                            if (ex2.getOwners(instructor).isEmpty()) {
                                sections = sections + "\n";
                                rooms = rooms + "\n";
                                periods2 = periods2 + "\n";
                                periodDays2 = periodDays2 + "\n";
                                periodTimes2 = periodTimes2 + "\n";
                                sections = sections + ex2.getName();
                                rooms = rooms + roomsThisExam;
                                periods2 = periods2 + String.valueOf(period.next().getIndex() + 1);
                                periodDays2 = periodDays2 + period.next().getDayStr();
                                periodTimes2 = periodTimes2 + period.next().getTimeStr();
                            }
                            String distStr = "";
                            if (backToBackDistance >= 0.0 && (dist = assignment.getValue(ex1).getDistanceInMeters(assignment.getValue(ex2))) > 0.0) {
                                distStr = String.valueOf(dist);
                            }
                            csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(instructor.getName()), new CSVFile.CSVField("back-to-back"), new CSVFile.CSVField(sections), new CSVFile.CSVField(periods2), new CSVFile.CSVField(periodDays2), new CSVFile.CSVField(periodTimes2), new CSVFile.CSVField(rooms), new CSVFile.CSVField(distStr)});
                        }
                    }
                }
                if (period.next() != null && period.next().getDay() == period.getDay() || (nrExamsADay = instructor.getExamsADay(assignment, period.getDay()).size()) <= 2) continue;
                String sections = "";
                periods = "";
                periodDays = "";
                periodTimes = "";
                String rooms = "";
                for (Exam exam : instructor.getExamsADay(assignment, period.getDay())) {
                    ExamPlacement placement = assignment.getValue(exam);
                    String roomsThisExam = "";
                    for (ExamRoomPlacement room : placement.getRoomPlacements()) {
                        if (roomsThisExam.length() > 0) {
                            roomsThisExam = roomsThisExam + ", ";
                        }
                        roomsThisExam = roomsThisExam + room.getName();
                    }
                    boolean first = true;
                    for (ExamOwner owner : exam.getOwners(instructor)) {
                        if (sections.length() > 0) {
                            sections = sections + "\n";
                            rooms = rooms + "\n";
                            periods = periods + "\n";
                            periodDays = periodDays + "\n";
                            periodTimes = periodTimes + "\n";
                        }
                        sections = sections + owner.getName();
                        if (first) {
                            periods = periods + (placement.getPeriod().getIndex() + 1);
                            periodDays = periodDays + placement.getPeriod().getDayStr();
                            periodTimes = periodTimes + placement.getPeriod().getTimeStr();
                            rooms = rooms + roomsThisExam;
                        }
                        first = false;
                    }
                    if (!exam.getOwners(instructor).isEmpty()) continue;
                    if (sections.length() > 0) {
                        sections = sections + "\n";
                        rooms = rooms + "\n";
                        periods = periods + "\n";
                        periodDays = periodDays + "\n";
                        periodTimes = periodTimes + "\n";
                    }
                    sections = sections + exam.getName();
                    periods = periods + (placement.getPeriod().getIndex() + 1);
                    periodDays = periodDays + placement.getPeriod().getDayStr();
                    periodTimes = periodTimes + placement.getPeriod().getTimeStr();
                    rooms = rooms + roomsThisExam;
                }
                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(instructor.getName()), new CSVFile.CSVField("more-2-day"), new CSVFile.CSVField(sections), new CSVFile.CSVField(periods), new CSVFile.CSVField(periodDays), new CSVFile.CSVField(periodTimes), new CSVFile.CSVField(rooms)});
            }
        }
        return csv;
    }
}

