/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.StudentMoreThan2ADayConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class InstructorMoreThan2ADayConflicts
extends StudentMoreThan2ADayConflicts {
    @Override
    public String getWeightName() {
        return "Exams.InstructorMoreThanTwoADayWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "instructorMoreThanTwoADayWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 100.0;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        Map<ExamInstructor, Set<Exam>> instructors = ((ExamModel)this.getModel()).getInstructorsOfDay(assignment, value.getPeriod());
        for (ExamInstructor s : exam.getInstructors()) {
            int nrExams;
            Set<Exam> exams = instructors.get(s);
            if (exams == null || exams.size() < 2 || (nrExams = exams.size() + (exams.contains(exam) ? 0 : 1)) <= 2) continue;
            ++penalty;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Instructor More Than 2 A Day Conflicts";
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "iM2D:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

