/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DistanceMetric;

public class StudentConflict
extends TimetablingCriterion {
    protected boolean iIncludeConflicts = false;

    public StudentConflict() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.BeforeUnassignedBeforeAssigned);
    }

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        this.iIncludeConflicts = solver.getProperties().getPropertyBoolean("StudentConflict.IncludeConflicts", false);
        return super.init(solver);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return null;
    }

    public DistanceMetric getMetrics() {
        return this.getModel() == null ? null : ((TimetableModel)this.getModel()).getDistanceMetric();
    }

    public static boolean overlaps(Placement p1, Placement p2) {
        return p1 != null && p2 != null && p1.getTimeLocation().hasIntersection(p2.getTimeLocation()) && (!((Lecture)p1.variable()).isCommitted() || !((Lecture)p2.variable()).isCommitted());
    }

    protected double jointEnrollment(JenrlConstraint jenrl) {
        return jenrl.jenrl();
    }

    public static boolean distance(DistanceMetric m, Placement p1, Placement p2) {
        TimeLocation t2;
        if (m == null && p1 != null) {
            m = ((TimetableModel)((Lecture)p1.variable()).getModel()).getDistanceMetric();
        }
        if (m == null && p2 != null) {
            m = ((TimetableModel)((Lecture)p2.variable()).getModel()).getDistanceMetric();
        }
        if (p1 == null || p2 == null || m == null) {
            return false;
        }
        if (((Lecture)p1.variable()).isCommitted() && ((Lecture)p2.variable()).isCommitted()) {
            return false;
        }
        TimeLocation t1 = p1.getTimeLocation();
        if (!t1.shareDays(t2 = p2.getTimeLocation()) || !t1.shareWeeks(t2)) {
            return false;
        }
        if (m.doComputeDistanceConflictsBetweenNonBTBClasses()) {
            if (t1.getStartSlot() + t1.getLength() <= t2.getStartSlot()) {
                return Placement.getDistanceInMinutes(m, p1, p2) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - t1.getStartSlot() - t1.getLength());
            }
            if (t2.getStartSlot() + t2.getLength() <= t1.getStartSlot()) {
                return Placement.getDistanceInMinutes(m, p1, p2) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength());
            }
        } else {
            if (t1.getStartSlot() + t1.getLength() == t2.getStartSlot()) {
                return Placement.getDistanceInMinutes(m, p1, p2) > t1.getBreakTime();
            }
            if (t2.getStartSlot() + t2.getLength() == t1.getStartSlot()) {
                return Placement.getDistanceInMinutes(m, p1, p2) > t2.getBreakTime();
            }
        }
        return false;
    }

    public static boolean ignore(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && l1.isToIgnoreStudentConflictsWith(l2);
    }

    public static boolean committed(Lecture l1, Lecture l2) {
        return !(l1 == null || l2 == null || !l1.isCommitted() && !l2.isCommitted() || l1.isCommitted() && l2.isCommitted());
    }

    public static boolean uncommitted(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !l1.isCommitted() && !l2.isCommitted();
    }

    public static boolean applicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && (!l1.isCommitted() || !l2.isCommitted());
    }

    public static boolean hard(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && l1.isSingleSection() && l2.isSingleSection() && (!l1.isCommitted() || !l2.isCommitted());
    }

    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !StudentConflict.ignore(l1, l2) && StudentConflict.uncommitted(l1, l2);
    }

    public boolean inConflict(Placement p1, Placement p2) {
        return StudentConflict.overlaps(p1, p2) || StudentConflict.distance(this.getMetrics(), p1, p2);
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = 0.0;
        for (JenrlConstraint jenrl : ((Lecture)value.variable()).jenrlConstraints()) {
            Placement another;
            Lecture other = (Lecture)jenrl.another(value.variable());
            if (!this.isApplicable((Lecture)value.variable(), other) || (another = assignment.getValue(other)) == null || conflicts != null && conflicts.contains(another) || !this.inConflict(value, another)) continue;
            ret += this.jointEnrollment(jenrl);
        }
        if (this.iIncludeConflicts && conflicts != null) {
            for (Placement conflict : conflicts) {
                for (JenrlConstraint jenrl : ((Lecture)conflict.variable()).jenrlConstraints()) {
                    Placement another;
                    Lecture other = (Lecture)jenrl.another(conflict.variable());
                    if (!this.isApplicable((Lecture)conflict.variable(), other) || (another = assignment.getValue(other)) == null || ((Lecture)another.variable()).equals(value.variable()) || conflicts != null && conflicts.contains(another) || !this.inConflict(conflict, another)) continue;
                    ret -= this.jointEnrollment(jenrl);
                }
            }
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<JenrlConstraint> constraints = new HashSet<JenrlConstraint>();
        for (Lecture lect : variables) {
            Placement plac = assignment.getValue(lect);
            if (plac == null) continue;
            for (JenrlConstraint jenrl : lect.jenrlConstraints()) {
                Lecture other;
                if (!constraints.add(jenrl) || !(other = jenrl.another(lect)).isCommitted() && !variables.contains(other) || !this.isApplicable(lect, other) || !this.inConflict(plac, assignment.getValue(other))) continue;
                ret += this.jointEnrollment(jenrl);
            }
        }
        return ret;
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment) {
        double[] bounds = new double[]{0.0, 0.0};
        for (JenrlConstraint jenrl : ((TimetableModel)this.getModel()).getJenrlConstraints()) {
            if (!this.isApplicable((Lecture)jenrl.first(), (Lecture)jenrl.second())) continue;
            bounds[0] = bounds[0] + this.jointEnrollment(jenrl);
        }
        return bounds;
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        HashSet<JenrlConstraint> constraints = new HashSet<JenrlConstraint>();
        for (Lecture lect : variables) {
            if (assignment.getValue(lect) == null) continue;
            for (JenrlConstraint jenrl : lect.jenrlConstraints()) {
                if (!this.isApplicable((Lecture)jenrl.first(), (Lecture)jenrl.second()) || !constraints.add(jenrl) || !jenrl.another(lect).isCommitted() && !variables.contains(jenrl.another(lect))) continue;
                bounds[0] = bounds[0] + this.jointEnrollment(jenrl);
            }
        }
        return bounds;
    }

    public void incJenrl(Assignment<Lecture, Placement> assignment, JenrlConstraint jenrl, double studentWeight, Double conflictPriority, Student student) {
        if (this.isApplicable((Lecture)jenrl.first(), (Lecture)jenrl.second()) && this.inConflict(assignment.getValue((Lecture)jenrl.first()), assignment.getValue((Lecture)jenrl.second()))) {
            super.inc(assignment, studentWeight);
        }
    }

    @Override
    public void bestRestored(Assignment<Lecture, Placement> assignment) {
        super.bestRestored(assignment);
        ((AbstractCriterion.ValueContext)this.getContext((Assignment)assignment)).setTotal(this.getValue(assignment, (Collection<Lecture>)this.getModel().variables()));
    }
}

