/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class StudentCommittedConflict
extends StudentConflict {
    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.CommitedStudentConflictWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrCommitedStudConfsWeight";
    }

    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !StudentCommittedConflict.ignore(l1, l2) && StudentCommittedConflict.committed(l1, l2);
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double[] bounds = super.getBounds(assignment, variables);
        for (Lecture lecture : variables) {
            Double max = null;
            for (Placement placement : lecture.values(assignment)) {
                if (max == null) {
                    max = new Double(lecture.getCommitedConflicts(placement));
                    continue;
                }
                max = Math.max(max, (double)lecture.getCommitedConflicts(placement));
            }
            if (max == null) continue;
            bounds[0] = bounds[0] + max;
        }
        return bounds;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = super.getValue(assignment, value, conflicts);
        ret += (double)((Lecture)value.variable()).getCommitedConflicts(value);
        if (this.iIncludeConflicts && conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= (double)((Lecture)value.variable()).getCommitedConflicts(conflict);
            }
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = super.getValue(assignment, variables);
        for (Lecture lect : variables) {
            Placement plac = assignment.getValue(lect);
            if (plac == null) continue;
            ret += (double)lect.getCommitedConflicts(plac);
        }
        return Math.round(ret);
    }
}

