/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.DataModelConverter;
import biweekly.io.ICalTimeZone;
import biweekly.io.ParseContext;
import biweekly.io.ParseWarnings;
import biweekly.io.TimezoneInfo;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.property.Daylight;
import biweekly.property.ICalProperty;
import biweekly.property.Timezone;
import biweekly.property.TimezoneId;
import biweekly.util.ICalDate;
import biweekly.util.ICalDateFormat;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamReader
implements Closeable {
    protected final ParseWarnings warnings = new ParseWarnings();
    protected TimezoneInfo tzinfo;
    protected ScribeIndex index = new ScribeIndex();
    protected ParseContext context;

    public void registerScribe(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.index.register(scribe);
    }

    public void registerScribe(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<String> getWarnings() {
        return this.warnings.copy();
    }

    public TimezoneInfo getTimezoneInfo() {
        return this.tzinfo;
    }

    public List<ICalendar> readAll() throws IOException {
        ArrayList<ICalendar> icals = new ArrayList<ICalendar>();
        ICalendar ical = null;
        while ((ical = this.readNext()) != null) {
            icals.add(ical);
        }
        return icals;
    }

    public ICalendar readNext() throws IOException {
        this.warnings.clear();
        this.context = new ParseContext();
        this.tzinfo = new TimezoneInfo();
        ICalendar ical = this._readNext();
        if (ical == null) {
            return null;
        }
        ical.setVersion(this.context.getVersion());
        this.handleTimezones(ical);
        return ical;
    }

    protected abstract ICalendar _readNext() throws IOException;

    private void handleTimezones(ICalendar ical) {
        Timezone tz;
        List<Daylight> daylights = ical.getProperties(Daylight.class);
        VTimezone vcalComponent = DataModelConverter.convert(daylights, tz = ical.getProperty(Timezone.class));
        if (vcalComponent != null) {
            ICalTimeZone iCalTimeZone = new ICalTimeZone(vcalComponent);
            this.tzinfo.assign(vcalComponent, iCalTimeZone);
            this.tzinfo.setDefaultTimeZone(iCalTimeZone);
        }
        ical.removeProperties(Daylight.class);
        ical.removeProperties(Timezone.class);
        ArrayList<VTimezone> toKeep = new ArrayList<VTimezone>(0);
        for (VTimezone vTimezone : ical.getComponents(VTimezone.class)) {
            TimezoneId id = vTimezone.getTimezoneId();
            if (id == null || id.getValue() == null) {
                this.warnings.add(null, null, 39, new Object[0]);
                toKeep.add(vTimezone);
                continue;
            }
            ICalTimeZone timezone = new ICalTimeZone(vTimezone);
            this.tzinfo.assign(vTimezone, timezone);
        }
        if (toKeep.isEmpty()) {
            ical.removeComponents(VTimezone.class);
        } else {
            ical.getComponents().replace(VTimezone.class, toKeep);
        }
        if (vcalComponent != null) {
            TimeZone timezone = this.tzinfo.getTimeZoneByComponent(vcalComponent);
            for (ParseContext.TimezonedDate timezonedDate : this.context.getFloatingDates()) {
                ICalDate date = timezonedDate.getDate();
                Date realDate = date.getRawComponents().toDate(timezone);
                date.setTime(realDate.getTime());
            }
        } else {
            for (ParseContext.TimezonedDate timezonedDate : this.context.getFloatingDates()) {
                this.tzinfo.setFloating(timezonedDate.getProperty(), true);
            }
        }
        for (Map.Entry entry : this.context.getTimezonedDates()) {
            TimeZone timezone;
            String tzid = (String)entry.getKey();
            boolean solidus = tzid.startsWith("/");
            if (solidus) {
                timezone = ICalDateFormat.parseTimeZoneId(tzid.substring(1));
                if (timezone == null) {
                    this.warnings.add(null, null, 38, tzid);
                    continue;
                }
            } else {
                timezone = this.tzinfo.getTimeZoneById(tzid);
                if (timezone == null) {
                    timezone = ICalDateFormat.parseTimeZoneId(tzid);
                    if (timezone == null) {
                        this.warnings.add(null, null, 38, tzid);
                        continue;
                    }
                    this.warnings.add(null, null, 37, tzid);
                }
            }
            List timezonedDates = (List)entry.getValue();
            for (ParseContext.TimezonedDate timezonedDate : timezonedDates) {
                ICalProperty property = timezonedDate.getProperty();
                this.tzinfo.setTimeZoneReader(property, timezone, solidus);
                ICalDate date = timezonedDate.getDate();
                Date realDate = date.getRawComponents().toDate(timezone);
                date.setTime(realDate.getTime());
                property.getParameters().setTimezoneId(null);
            }
        }
    }
}

