/*
 * Licensed to The Apereo Foundation under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.
 *
 * The Apereo Foundation licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

use timetable;

set @saved_fk_checks=@@foreign_key_checks, foreign_key_checks=0;
set @saved_cs_client = @@character_set_client, character_set_client = utf8;

delete from `academic_area`;
delete from `academic_classification`;
delete from `application_config`;
delete from `assigned_instructors`;
delete from `assigned_rooms`;
delete from `assignment`;
delete from `building`;
delete from `building_pref`;
delete from `change_log`;
delete from `class_`;
delete from `class_instructor`;
delete from `class_waitlist`;
delete from `constraint_info`;
delete from `course_catalog`;
delete from `course_credit_type`;
delete from `course_credit_unit_config`;
delete from `course_credit_unit_type`;
delete from `course_demand`;
delete from `course_offering`;
delete from `course_request`;
delete from `course_request_option`;
delete from `course_subpart_credit`;
delete from `course_type`;
delete from `crse_credit_format`;
delete from `curriculum`;
delete from `curriculum_clasf`;
delete from `curriculum_course`;
delete from `curriculum_course_group`;
delete from `curriculum_group`;
delete from `curriculum_major`;
delete from `curriculum_rule`;
delete from `date_mapping`;
delete from `date_pattern`;
delete from `date_pattern_dept`;
delete from `date_pattern_parent`;
delete from `date_pattern_pref`;
delete from `demand_offr_type`;
delete from `department`;
delete from `departmental_instructor`;
delete from `dept_status_type`;
delete from `dept_to_tt_mgr`;
delete from `designator`;
delete from `dist_type_dept`;
delete from `distribution_object`;
delete from `distribution_pref`;
delete from `distribution_type`;
delete from `event`;
delete from `event_contact`;
delete from `event_join_event_contact`;
delete from `event_note`;
delete from `event_note_meeting`;
delete from `exact_time_mins`;
delete from `exam`;
delete from `exam_instructor`;
delete from `exam_location_pref`;
delete from `exam_owner`;
delete from `exam_period`;
delete from `exam_period_pref`;
delete from `exam_room_assignment`;
delete from `exam_type`;
delete from `external_building`;
delete from `external_room`;
delete from `external_room_department`;
delete from `external_room_feature`;
delete from `feature_type`;
delete from `free_time`;
delete from `hibernate_unique_key`;
delete from `history`;
delete from `instr_offering_config`;
delete from `instructional_offering`;
delete from `itype_desc`;
delete from `jenrl`;
delete from `lastlike_course_demand`;
delete from `manager_settings`;
delete from `meeting`;
delete from `message_log`;
delete from `non_university_location`;
delete from `offering_coordinator`;
delete from `offr_consent_type`;
delete from `offr_group`;
delete from `offr_group_offering`;
delete from `pos_acad_area_major`;
delete from `pos_acad_area_minor`;
delete from `pos_major`;
delete from `pos_minor`;
delete from `position_type`;
delete from `preference_level`;
delete from `query_log`;
delete from `related_course_info`;
delete from `reservation`;
delete from `reservation_clasf`;
delete from `reservation_class`;
delete from `reservation_config`;
delete from `reservation_major`;
delete from `reservation_student`;
delete from `rights`;
delete from `roles`;
delete from `room`;
delete from `room_dept`;
delete from `room_exam_type`;
delete from `room_feature`;
delete from `room_feature_pref`;
delete from `room_group`;
delete from `room_group_pref`;
delete from `room_group_room`;
delete from `room_join_room_feature`;
delete from `room_pref`;
delete from `room_type`;
delete from `room_type_option`;
delete from `saved_hql`;
delete from `scheduling_subpart`;
delete from `script`;
delete from `script_parameter`;
delete from `sectioning_course_types`;
delete from `sectioning_info`;
delete from `sectioning_log`;
delete from `sectioning_queue`;
delete from `sectioning_status`;
delete from `session_config`;
delete from `sessions`;
delete from `settings`;
delete from `solution`;
delete from `solver_gr_to_tt_mgr`;
delete from `solver_group`;
delete from `solver_info`;
delete from `solver_info_def`;
delete from `solver_parameter`;
delete from `solver_parameter_def`;
delete from `solver_parameter_group`;
delete from `solver_predef_setting`;
delete from `sponsoring_organization`;
delete from `staff`;
delete from `standard_event_note`;
delete from `student`;
delete from `student_acad_area`;
delete from `student_accomodation`;
delete from `student_class_enrl`;
delete from `student_enrl`;
delete from `student_enrl_msg`;
delete from `student_group`;
delete from `student_major`;
delete from `student_minor`;
delete from `student_sect_hist`;
delete from `student_to_acomodation`;
delete from `student_to_group`;
delete from `subject_area`;
delete from `time_pattern`;
delete from `time_pattern_days`;
delete from `time_pattern_dept`;
delete from `time_pattern_time`;
delete from `time_pref`;
delete from `timetable_manager`;
delete from `tmtbl_mgr_to_roles`;
delete from `travel_time`;
delete from `user_data`;
delete from `users`;
delete from `waitlist`;
delete from `xconflict`;
delete from `xconflict_exam`;
delete from `xconflict_instructor`;
delete from `xconflict_student`;

insert into `academic_area` values
	(142,231379,'A','The Woebegon\'s Only Academic Area','A'),
	(144,223206,'A','Area 1','A');

insert into `academic_classification` values
	(61,231379,'01','Junior Year','01'),
	(62,231379,'02','Senior Year','02'),
	(63,223206,'01','Junior Year','01'),
	(64,223206,'02','Senior Year','02');

insert into `application_config` values
	('tmtbl.access_level','all','Access Levels: all | {dept code}(:{dept code})*'),
	('tmtbl.db.version','123','Timetabling database version (please do not change -- this key is used by automatic database update)'),
	('tmtbl.system_message','Welcome to Woebegon College test suite.','Message displayed to users when they first log in to Timetabling');

insert into `assigned_instructors` values
	(142297,226242,NULL),
	(142299,226240,NULL),
	(142300,226240,NULL),
	(142301,226240,NULL),
	(142324,226240,NULL),
	(142325,226240,NULL),
	(142326,226240,NULL),
	(142327,226242,NULL),
	(142328,226242,NULL),
	(142329,226246,NULL),
	(142330,226244,NULL),
	(142331,226246,NULL),
	(142332,226244,NULL),
	(142333,226242,NULL),
	(142334,226242,NULL),
	(142335,226242,NULL),
	(142336,226238,NULL),
	(142337,226238,NULL),
	(142338,226238,NULL),
	(142339,226238,NULL),
	(142340,226238,NULL),
	(142341,226238,NULL),
	(142342,226238,NULL),
	(142343,226238,NULL),
	(142344,226238,NULL),
	(142345,226238,NULL),
	(142346,226238,NULL),
	(142347,226238,NULL),
	(142457,231388,NULL),
	(142459,231389,NULL),
	(142460,231389,NULL),
	(142461,231389,NULL),
	(142484,231389,NULL),
	(142485,231389,NULL),
	(142486,231389,NULL),
	(142487,231388,NULL),
	(142488,231388,NULL),
	(142493,231388,NULL),
	(142494,231388,NULL),
	(142495,231388,NULL),
	(142496,231385,NULL),
	(142497,231385,NULL),
	(142498,231385,NULL),
	(142499,231385,NULL),
	(142500,231385,NULL),
	(142501,231385,NULL),
	(142502,231385,NULL),
	(142503,231385,NULL),
	(142504,231385,NULL),
	(142505,231385,NULL),
	(142506,231385,NULL),
	(142507,231385,NULL);

insert into `assigned_rooms` values
	(142297,7987,NULL),
	(142298,7986,NULL),
	(142299,7986,NULL),
	(142300,7986,NULL),
	(142301,7986,NULL),
	(142302,7989,NULL),
	(142303,7989,NULL),
	(142304,7989,NULL),
	(142305,7989,NULL),
	(142306,7989,NULL),
	(142307,7989,NULL),
	(142308,7989,NULL),
	(142309,7989,NULL),
	(142310,7988,NULL),
	(142311,7989,NULL),
	(142312,7988,NULL),
	(142313,7992,NULL),
	(142314,7992,NULL),
	(142315,7992,NULL),
	(142316,7992,NULL),
	(142317,7992,NULL),
	(142318,7992,NULL),
	(142319,7992,NULL),
	(142320,7992,NULL),
	(142321,7992,NULL),
	(142322,7992,NULL),
	(142323,7992,NULL),
	(142324,7986,NULL),
	(142325,7986,NULL),
	(142326,7986,NULL),
	(142327,7987,NULL),
	(142328,7988,NULL),
	(142329,7993,NULL),
	(142330,7993,NULL),
	(142331,7993,NULL),
	(142332,7993,NULL),
	(142333,7986,NULL),
	(142334,7986,NULL),
	(142335,7986,NULL),
	(142336,7989,NULL),
	(142337,7989,NULL),
	(142338,7988,NULL),
	(142339,7988,NULL),
	(142340,7987,NULL),
	(142341,7988,NULL),
	(142342,7987,NULL),
	(142343,7987,NULL),
	(142344,7988,NULL),
	(142345,7988,NULL),
	(142346,7988,NULL),
	(142347,7989,NULL),
	(142348,7986,NULL),
	(142349,7986,NULL),
	(142350,7986,NULL),
	(142351,7991,NULL),
	(142352,7991,NULL),
	(142353,7991,NULL),
	(142354,7991,NULL),
	(142355,7991,NULL),
	(142356,7991,NULL),
	(142357,7991,NULL),
	(142358,7991,NULL),
	(142359,7991,NULL),
	(142360,7991,NULL),
	(142361,7991,NULL),
	(142362,7991,NULL),
	(142363,7989,NULL),
	(142364,7989,NULL),
	(142365,7989,NULL),
	(142366,7988,NULL),
	(142367,7989,NULL),
	(142368,7989,NULL),
	(142369,7989,NULL),
	(142370,7989,NULL),
	(142371,7988,NULL),
	(142372,7987,NULL),
	(142373,7988,NULL),
	(142374,7989,NULL),
	(142375,7988,NULL),
	(142376,7987,NULL),
	(142377,7989,NULL),
	(142378,7988,NULL),
	(142379,7987,NULL),
	(142380,7989,NULL),
	(142381,7988,NULL),
	(142382,7987,NULL),
	(142383,7987,NULL),
	(142384,7986,NULL),
	(142385,7987,NULL),
	(142386,7988,NULL),
	(142387,7988,NULL),
	(142388,7989,NULL),
	(142389,7988,NULL),
	(142390,7989,NULL),
	(142391,7989,NULL),
	(142392,7989,NULL),
	(142393,7989,NULL),
	(142394,7988,NULL),
	(142395,7993,NULL),
	(142396,7993,NULL),
	(142397,7993,NULL),
	(142398,7993,NULL),
	(142399,7993,NULL),
	(142400,7993,NULL),
	(142401,7993,NULL),
	(142402,7993,NULL),
	(142403,7993,NULL),
	(142404,7993,NULL),
	(142405,7986,NULL),
	(142406,7993,NULL),
	(142407,7993,NULL),
	(142408,7993,NULL),
	(142409,7988,NULL),
	(142410,7987,NULL),
	(142411,7993,NULL),
	(142412,7993,NULL),
	(142413,7993,NULL),
	(142414,7993,NULL),
	(142415,7987,NULL),
	(142416,7987,NULL),
	(142417,7988,NULL),
	(142418,7986,NULL),
	(142419,7992,NULL),
	(142420,7992,NULL),
	(142421,7992,NULL),
	(142422,7986,NULL),
	(142423,7987,NULL),
	(142424,7986,NULL),
	(142425,7988,NULL),
	(142426,7989,NULL),
	(142427,7989,NULL),
	(142428,7988,NULL),
	(142429,7989,NULL),
	(142430,7989,NULL),
	(142431,7993,NULL),
	(142432,7993,NULL),
	(142433,7993,NULL),
	(142434,7993,NULL),
	(142435,7993,NULL),
	(142436,7988,NULL),
	(142437,7987,NULL),
	(142438,7986,NULL),
	(142439,7987,NULL),
	(142440,7987,NULL),
	(142441,7987,NULL),
	(142442,7988,NULL),
	(142443,7993,NULL),
	(142444,7993,NULL),
	(142445,7993,NULL),
	(142446,7993,NULL),
	(142457,8019,NULL),
	(142458,8023,NULL),
	(142459,8023,NULL),
	(142460,8023,NULL),
	(142461,8023,NULL),
	(142462,8020,NULL),
	(142463,8020,NULL),
	(142464,8020,NULL),
	(142465,8020,NULL),
	(142466,8020,NULL),
	(142467,8020,NULL),
	(142468,8020,NULL),
	(142469,8024,NULL),
	(142470,8020,NULL),
	(142471,8024,NULL),
	(142472,8020,NULL),
	(142473,8015,NULL),
	(142474,8015,NULL),
	(142475,8015,NULL),
	(142476,8015,NULL),
	(142477,8015,NULL),
	(142478,8015,NULL),
	(142479,8015,NULL),
	(142480,8015,NULL),
	(142481,8015,NULL),
	(142482,8015,NULL),
	(142483,8015,NULL),
	(142484,8023,NULL),
	(142485,8023,NULL),
	(142486,8023,NULL),
	(142487,8024,NULL),
	(142488,8019,NULL),
	(142489,8016,NULL),
	(142490,8016,NULL),
	(142491,8016,NULL),
	(142492,8016,NULL),
	(142493,8023,NULL),
	(142494,8023,NULL),
	(142495,8023,NULL),
	(142496,8020,NULL),
	(142497,8020,NULL),
	(142498,8020,NULL),
	(142499,8024,NULL),
	(142500,8020,NULL),
	(142501,8020,NULL),
	(142502,8024,NULL),
	(142503,8020,NULL),
	(142504,8020,NULL),
	(142505,8020,NULL),
	(142506,8020,NULL),
	(142507,8020,NULL),
	(142508,8023,NULL),
	(142509,8023,NULL),
	(142510,8023,NULL),
	(142511,8022,NULL),
	(142512,8022,NULL),
	(142513,8019,NULL),
	(142514,8015,NULL),
	(142515,8022,NULL),
	(142516,8022,NULL),
	(142517,8022,NULL),
	(142518,8022,NULL),
	(142519,8015,NULL),
	(142520,8015,NULL),
	(142521,8022,NULL),
	(142522,8022,NULL),
	(142523,8019,NULL),
	(142524,8019,NULL),
	(142525,8024,NULL),
	(142526,8024,NULL),
	(142527,8020,NULL),
	(142528,8020,NULL),
	(142529,8020,NULL),
	(142530,8019,NULL),
	(142531,8020,NULL),
	(142532,8024,NULL),
	(142533,8024,NULL),
	(142534,8024,NULL),
	(142535,8020,NULL),
	(142536,8024,NULL),
	(142537,8024,NULL),
	(142538,8019,NULL),
	(142539,8020,NULL),
	(142540,8020,NULL),
	(142541,8024,NULL),
	(142542,8019,NULL),
	(142543,8024,NULL),
	(142544,8023,NULL),
	(142545,8020,NULL),
	(142546,8020,NULL),
	(142547,8024,NULL),
	(142548,8020,NULL),
	(142549,8024,NULL),
	(142550,8019,NULL),
	(142551,8024,NULL),
	(142552,8020,NULL),
	(142553,8024,NULL),
	(142554,8020,NULL),
	(142555,8016,NULL),
	(142556,8016,NULL),
	(142557,8016,NULL),
	(142558,8016,NULL),
	(142559,8016,NULL),
	(142560,8016,NULL),
	(142561,8016,NULL),
	(142562,8016,NULL),
	(142563,8016,NULL),
	(142564,8016,NULL),
	(142565,8023,NULL),
	(142566,8016,NULL),
	(142567,8016,NULL),
	(142568,8016,NULL),
	(142569,8019,NULL),
	(142570,8024,NULL),
	(142571,8016,NULL),
	(142572,8016,NULL),
	(142573,8016,NULL),
	(142574,8016,NULL),
	(142575,8019,NULL),
	(142576,8019,NULL),
	(142577,8019,NULL),
	(142578,8023,NULL),
	(142579,8015,NULL),
	(142580,8015,NULL),
	(142581,8015,NULL),
	(142582,8023,NULL),
	(142583,8019,NULL),
	(142584,8024,NULL),
	(142585,8023,NULL),
	(142586,8020,NULL),
	(142587,8020,NULL),
	(142588,8019,NULL),
	(142589,8020,NULL),
	(142590,8020,NULL),
	(142591,8016,NULL),
	(142592,8016,NULL),
	(142593,8016,NULL),
	(142594,8016,NULL),
	(142595,8016,NULL),
	(142596,8024,NULL),
	(142597,8019,NULL),
	(142598,8023,NULL),
	(142599,8019,NULL),
	(142600,8024,NULL),
	(142601,8019,NULL),
	(142602,8019,NULL),
	(142603,8016,NULL),
	(142604,8016,NULL),
	(142605,8016,NULL),
	(142606,8016,NULL);

insert into `assignment` values
	(142297,84,114,1371,807,223884,'ALG 101 Lec 1',NULL,49),
	(142298,124,186,1480,806,223249,'BAND 101 Lec 1',NULL,49),
	(142299,40,150,1373,806,223240,'BIOL 101 Lec 1',NULL,49),
	(142300,40,126,1373,806,223899,'BIOL 101 Lec 2',NULL,49),
	(142301,40,114,1373,806,223900,'BIOL 101 Lec 3',NULL,49),
	(142302,32,186,1377,807,223902,'BIOL 101 Rec 1',NULL,49),
	(142303,8,174,1377,807,223903,'BIOL 101 Rec 2',NULL,49),
	(142304,16,90,1377,807,223904,'BIOL 101 Rec 3',NULL,49),
	(142305,4,102,1377,807,223905,'BIOL 101 Rec 4',NULL,49),
	(142306,32,138,1377,807,223906,'BIOL 101 Rec 5',NULL,49),
	(142307,32,150,1377,807,223907,'BIOL 101 Rec 6',NULL,49),
	(142308,64,102,1377,807,223908,'BIOL 101 Rec 7',NULL,49),
	(142309,8,138,1377,807,223909,'BIOL 101 Rec 8',NULL,49),
	(142310,16,114,1377,807,223910,'BIOL 101 Rec 9',NULL,49),
	(142311,16,162,1377,807,223976,'BIOL 101 Rec 10',NULL,49),
	(142312,16,126,1377,807,223977,'BIOL 101 Rec 11',NULL,49),
	(142313,4,162,1378,807,223914,'BIOL 101 Lab 1',NULL,49),
	(142314,16,162,1378,807,223915,'BIOL 101 Lab 2',NULL,49),
	(142315,16,114,1378,807,223916,'BIOL 101 Lab 3',NULL,49),
	(142316,16,90,1378,807,223917,'BIOL 101 Lab 4',NULL,49),
	(142317,4,186,1378,807,223918,'BIOL 101 Lab 5',NULL,49),
	(142318,8,162,1378,807,223919,'BIOL 101 Lab 6',NULL,49),
	(142319,8,138,1378,807,223920,'BIOL 101 Lab 7',NULL,49),
	(142320,8,186,1378,807,223921,'BIOL 101 Lab 8',NULL,49),
	(142321,4,114,1378,807,223922,'BIOL 101 Lab 9',NULL,49),
	(142322,8,90,1378,807,223978,'BIOL 101 Lab 10',NULL,49),
	(142323,16,186,1378,807,223979,'BIOL 101 Lab 11',NULL,49),
	(142324,32,138,1377,806,223926,'BIOL 101 Pso 1',NULL,49),
	(142325,8,138,1377,806,223927,'BIOL 101 Pso 2',NULL,49),
	(142326,16,138,1377,806,223973,'BIOL 101 Pso 3',NULL,49),
	(142327,80,102,1373,807,223245,'C S 101 Lec 1',NULL,49),
	(142328,68,126,1373,807,223947,'C S 101 Lec 2',NULL,49),
	(142329,8,186,1378,807,223949,'C S 101 Lab 1',NULL,49),
	(142330,4,162,1378,807,223950,'C S 101 Lab 2',NULL,49),
	(142331,8,162,1378,807,223951,'C S 101 Lab 3',NULL,49),
	(142332,4,114,1378,807,223970,'C S 101 Lab 4',NULL,49),
	(142333,84,150,1371,806,223869,'CALC 101 Lec 1',NULL,49),
	(142334,84,174,1371,806,223956,'CALC 101 Lec 2',NULL,49),
	(142335,84,90,1371,806,223957,'CALC 101 Lec 3',NULL,49),
	(142336,8,126,1377,807,223870,'CALC 101 Rec 1',NULL,49),
	(142337,32,162,1377,807,223958,'CALC 101 Rec 2',NULL,49),
	(142338,8,114,1377,807,223959,'CALC 101 Rec 3',NULL,49),
	(142339,8,138,1377,807,223960,'CALC 101 Rec 4',NULL,49),
	(142340,4,102,1377,807,223961,'CALC 101 Rec 5',NULL,49),
	(142341,32,150,1377,807,223962,'CALC 101 Rec 6',NULL,49),
	(142342,16,150,1377,807,223963,'CALC 101 Rec 7',NULL,49),
	(142343,4,150,1377,807,223964,'CALC 101 Rec 8',NULL,49),
	(142344,32,102,1377,807,223965,'CALC 101 Rec 9',NULL,49),
	(142345,32,138,1377,807,223966,'CALC 101 Rec 10',NULL,49),
	(142346,32,126,1377,807,223967,'CALC 101 Rec 11',NULL,49),
	(142347,8,150,1377,807,223968,'CALC 101 Rec 12',NULL,49),
	(142348,20,126,1373,806,223256,'CHM 101 Lec 1',NULL,49),
	(142349,68,138,1373,806,223257,'CHM 101 Lec 2',NULL,49),
	(142350,80,114,1373,806,223258,'CHM 101 Lec 3',NULL,49),
	(142351,32,138,1379,807,223259,'CHM 101 Lab 1',NULL,49),
	(142352,8,138,1379,807,223260,'CHM 101 Lab 2',NULL,49),
	(142353,4,138,1379,807,223261,'CHM 101 Lab 3',NULL,49),
	(142354,32,180,1379,807,223263,'CHM 101 Lab 4',NULL,49),
	(142355,4,90,1379,807,223264,'CHM 101 Lab 5',NULL,49),
	(142356,32,90,1379,807,223265,'CHM 101 Lab 6',NULL,49),
	(142357,4,180,1379,807,223267,'CHM 101 Lab 7',NULL,49),
	(142358,16,90,1379,807,223268,'CHM 101 Lab 8',NULL,49),
	(142359,16,180,1379,807,223269,'CHM 101 Lab 9',NULL,49),
	(142360,8,180,1379,807,223817,'CHM 101 Lab 10',NULL,49),
	(142361,8,90,1379,807,223818,'CHM 101 Lab 11',NULL,49),
	(142362,16,138,1379,807,223819,'CHM 101 Lab 12',NULL,49),
	(142363,8,186,1377,807,223824,'CHM 101 Rec 1',NULL,49),
	(142364,16,186,1377,807,223825,'CHM 101 Rec 2',NULL,49),
	(142365,32,198,1377,807,223826,'CHM 101 Rec 3',NULL,49),
	(142366,32,90,1377,807,223827,'CHM 101 Rec 4',NULL,49),
	(142367,32,126,1377,807,223828,'CHM 101 Rec 5',NULL,49),
	(142368,16,102,1377,807,223829,'CHM 101 Rec 6',NULL,49),
	(142369,8,162,1377,807,223830,'CHM 101 Rec 7',NULL,49),
	(142370,4,162,1377,807,223831,'CHM 101 Rec 8',NULL,49),
	(142371,8,102,1377,807,223832,'CHM 101 Rec 9',NULL,49),
	(142372,64,150,1377,807,223833,'CHM 101 Rec 10',NULL,49),
	(142373,32,114,1377,807,223834,'CHM 101 Rec 11',NULL,49),
	(142374,64,186,1377,807,223835,'CHM 101 Rec 12',NULL,49),
	(142375,40,162,1374,807,223297,'COM 101 Lec 1',NULL,49),
	(142376,40,198,1374,807,223298,'COM 101 Lec 2',NULL,49),
	(142377,40,90,1374,807,223299,'COM 101 Lec 3',NULL,49),
	(142378,40,180,1374,807,223300,'COM 101 Lec 4',NULL,49),
	(142379,40,162,1374,807,223301,'COM 101 Lec 5',NULL,49),
	(142380,40,108,1374,807,223302,'COM 101 Lec 6',NULL,49),
	(142381,40,198,1374,807,223303,'COM 101 Lec 7',NULL,49),
	(142382,40,144,1374,807,223304,'COM 101 Lec 8',NULL,49),
	(142383,40,108,1374,807,223305,'COM 101 Lec 9',NULL,49),
	(142384,40,90,1374,806,223291,'ECON 101 Lec 1',NULL,49),
	(142385,84,198,1371,807,223310,'ENGL 101 Lec 1',NULL,49),
	(142386,84,90,1371,807,223311,'ENGL 101 Lec 2',NULL,49),
	(142387,84,186,1371,807,223312,'ENGL 101 Lec 3',NULL,49),
	(142388,84,150,1371,807,223313,'ENGL 101 Lec 4',NULL,49),
	(142389,84,102,1371,807,223314,'ENGL 101 Lec 5',NULL,49),
	(142390,84,126,1371,807,223315,'ENGL 101 Lec 6',NULL,49),
	(142391,84,114,1371,807,223316,'ENGL 101 Lec 7',NULL,49),
	(142392,84,138,1371,807,223317,'ENGL 101 Lec 8',NULL,49),
	(142393,84,174,1371,807,223318,'ENGL 101 Lec 9',NULL,49),
	(142394,84,162,1371,807,223319,'ENGL 101 Lec 10',NULL,49),
	(142395,16,102,1377,807,223851,'ENGL 101 Lab 1',NULL,49),
	(142396,8,114,1377,807,223852,'ENGL 101 Lab 2',NULL,49),
	(142397,4,150,1377,807,223853,'ENGL 101 Lab 3',NULL,49),
	(142398,4,138,1377,807,223854,'ENGL 101 Lab 4',NULL,49),
	(142399,32,174,1377,807,223855,'ENGL 101 Lab 5',NULL,49),
	(142400,16,114,1377,807,223856,'ENGL 101 Lab 6',NULL,49),
	(142401,16,162,1377,807,223857,'ENGL 101 Lab 7',NULL,49),
	(142402,8,150,1377,807,223858,'ENGL 101 Lab 8',NULL,49),
	(142403,16,126,1377,807,223859,'ENGL 101 Lab 9',NULL,49),
	(142404,32,90,1377,807,223860,'ENGL 101 Lab 10',NULL,49),
	(142405,40,174,1373,807,223996,'ENGR 101 Lec 1',NULL,49),
	(142406,8,90,1378,807,223998,'ENGR 101 Lab 1',NULL,49),
	(142407,64,114,1378,807,223999,'ENGR 101 Lab 2',NULL,49),
	(142408,32,138,1378,807,224000,'ENGR 101 Lab 3',NULL,49),
	(142409,84,138,1371,807,223324,'GER 101 Lec 1',NULL,49),
	(142410,84,186,1371,807,223325,'GER 101 Lec 2',NULL,49),
	(142411,64,102,1377,807,224005,'GER 101 Lab 1',NULL,49),
	(142412,16,174,1377,807,224006,'GER 101 Lab 2',NULL,49),
	(142413,64,90,1377,807,224007,'GER 101 Lab 3',NULL,49),
	(142414,16,90,1377,807,224008,'GER 101 Lab 4',NULL,49),
	(142415,40,90,1374,807,223330,'HIST 101 Lec 1',NULL,49),
	(142416,84,126,1371,807,223331,'HIST 101 Lec 2',NULL,49),
	(142417,84,198,1371,807,224017,'LING 101 Lec 1',NULL,49),
	(142418,20,102,1373,806,224057,'MBIO 101 Lec 1',NULL,49),
	(142419,64,186,1378,807,224059,'MBIO 101 Lab 1',NULL,49),
	(142420,64,162,1378,807,224060,'MBIO 101 Lab 2',NULL,49),
	(142421,64,114,1378,807,224061,'MBIO 101 Lab 3',NULL,49),
	(142422,64,102,1377,806,224022,'PHAR 101 Lec 1',NULL,49),
	(142423,40,126,1374,807,223344,'PHIL 101 Lec 1',NULL,49),
	(142424,40,162,1373,807,223350,'PHYS 101 Lec 1',NULL,49),
	(142425,68,114,1373,807,223351,'PHYS 101 Lec 2',NULL,49),
	(142426,64,162,1377,807,224032,'PHYS 101 Rec 1',NULL,49),
	(142427,4,186,1377,807,224033,'PHYS 101 Rec 2',NULL,49),
	(142428,8,90,1377,807,224034,'PHYS 101 Rec 3',NULL,49),
	(142429,8,198,1377,807,224035,'PHYS 101 Rec 4',NULL,49),
	(142430,32,174,1377,807,224036,'PHYS 101 Rec 5',NULL,49),
	(142431,4,90,1378,807,224038,'PHYS 101 Lab 1',NULL,49),
	(142432,32,114,1378,807,224039,'PHYS 101 Lab 2',NULL,49),
	(142433,64,138,1378,807,224040,'PHYS 101 Lab 3',NULL,49),
	(142434,64,162,1378,807,224041,'PHYS 101 Lab 4',NULL,49),
	(142435,16,138,1378,807,224042,'PHYS 101 Lab 5',NULL,49),
	(142436,84,150,1371,807,223356,'POL 101 Lec 1',NULL,49),
	(142437,84,162,1371,807,224028,'POL 101 Lec 2',NULL,49),
	(142438,84,162,1371,806,223363,'PSY 101 Lec 1',NULL,49),
	(142439,84,138,1371,807,223373,'SOC 101 Lec 1',NULL,49),
	(142440,84,90,1371,807,224050,'SOC 101 Lec 2',NULL,49),
	(142441,40,180,1374,807,223378,'SPAN 101 Lec 1',NULL,49),
	(142442,84,174,1371,807,223379,'SPAN 101 Lec 2',NULL,49),
	(142443,32,162,1377,807,223800,'SPAN 101 Lab 1',NULL,49),
	(142444,32,102,1377,807,223801,'SPAN 101 Lab 2',NULL,49),
	(142445,32,186,1377,807,223802,'SPAN 101 Lab 3',NULL,49),
	(142446,8,138,1377,807,223803,'SPAN 101 Lab 4',NULL,49),
	(142457,84,114,1539,826,231391,'ALG 101 Lec 1',NULL,853),
	(142458,124,186,1531,827,231393,'BAND 101 Lec 1',NULL,853),
	(142459,68,174,1548,827,231395,'BIOL 101 Lec 1',NULL,853),
	(142460,40,90,1548,827,231396,'BIOL 101 Lec 2',NULL,853),
	(142461,68,114,1548,827,231397,'BIOL 101 Lec 3',NULL,853),
	(142462,64,138,1558,826,231411,'BIOL 101 Rec 1',NULL,853),
	(142463,4,90,1558,826,231412,'BIOL 101 Rec 2',NULL,853),
	(142464,8,162,1558,826,231413,'BIOL 101 Rec 3',NULL,853),
	(142465,64,162,1558,826,231414,'BIOL 101 Rec 4',NULL,853),
	(142466,16,138,1558,826,231415,'BIOL 101 Rec 5',NULL,853),
	(142467,4,114,1558,826,231416,'BIOL 101 Rec 6',NULL,853),
	(142468,16,162,1558,826,231417,'BIOL 101 Rec 7',NULL,853),
	(142469,16,186,1558,826,231418,'BIOL 101 Rec 8',NULL,853),
	(142470,16,90,1558,826,231419,'BIOL 101 Rec 9',NULL,853),
	(142471,32,126,1558,826,231420,'BIOL 101 Rec 10',NULL,853),
	(142472,16,114,1558,826,231421,'BIOL 101 Rec 11',NULL,853),
	(142473,16,138,1562,826,231399,'BIOL 101 Lab 1',NULL,853),
	(142474,16,186,1562,826,231400,'BIOL 101 Lab 2',NULL,853),
	(142475,16,114,1562,826,231401,'BIOL 101 Lab 3',NULL,853),
	(142476,8,138,1562,826,231402,'BIOL 101 Lab 4',NULL,853),
	(142477,4,186,1562,826,231403,'BIOL 101 Lab 5',NULL,853),
	(142478,4,162,1562,826,231404,'BIOL 101 Lab 6',NULL,853),
	(142479,8,90,1562,826,231405,'BIOL 101 Lab 7',NULL,853),
	(142480,8,114,1562,826,231406,'BIOL 101 Lab 8',NULL,853),
	(142481,16,90,1562,826,231407,'BIOL 101 Lab 9',NULL,853),
	(142482,4,138,1562,826,231408,'BIOL 101 Lab 10',NULL,853),
	(142483,16,162,1562,826,231409,'BIOL 101 Lab 11',NULL,853),
	(142484,16,174,1558,827,231423,'BIOL 101 Pso 1',NULL,853),
	(142485,16,114,1558,827,231424,'BIOL 101 Pso 2',NULL,853),
	(142486,8,102,1558,827,231425,'BIOL 101 Pso 3',NULL,853),
	(142487,68,162,1548,826,231434,'C S 101 Lec 1',NULL,853),
	(142488,80,150,1548,826,231435,'C S 101 Lec 2',NULL,853),
	(142489,32,138,1562,826,231429,'C S 101 Lab 1',NULL,853),
	(142490,32,90,1562,826,231430,'C S 101 Lab 2',NULL,853),
	(142491,16,114,1562,826,231431,'C S 101 Lab 3',NULL,853),
	(142492,64,162,1562,826,231432,'C S 101 Lab 4',NULL,853),
	(142493,84,90,1539,827,231437,'CALC 101 Lec 1',NULL,853),
	(142494,84,126,1539,827,231438,'CALC 101 Lec 2',NULL,853),
	(142495,84,102,1539,827,231439,'CALC 101 Lec 3',NULL,853),
	(142496,4,126,1558,826,231441,'CALC 101 Rec 1',NULL,853),
	(142497,64,126,1558,826,231445,'CALC 101 Rec 2',NULL,853),
	(142498,32,186,1558,826,231449,'CALC 101 Rec 3',NULL,853),
	(142499,4,174,1558,826,231451,'CALC 101 Rec 4',NULL,853),
	(142500,32,174,1558,826,231443,'CALC 101 Rec 5',NULL,853),
	(142501,32,126,1558,826,231446,'CALC 101 Rec 6',NULL,853),
	(142502,16,174,1558,826,231448,'CALC 101 Rec 7',NULL,853),
	(142503,8,174,1558,826,231452,'CALC 101 Rec 8',NULL,853),
	(142504,4,162,1558,826,231442,'CALC 101 Rec 9',NULL,853),
	(142505,32,150,1558,826,231444,'CALC 101 Rec 10',NULL,853),
	(142506,8,150,1558,826,231447,'CALC 101 Rec 11',NULL,853),
	(142507,32,138,1558,826,231450,'CALC 101 Rec 12',NULL,853),
	(142508,80,150,1548,827,231456,'CHM 101 Lec 1',NULL,853),
	(142509,40,114,1548,827,231457,'CHM 101 Lec 2',NULL,853),
	(142510,40,138,1548,827,231458,'CHM 101 Lec 3',NULL,853),
	(142511,8,138,1564,826,231461,'CHM 101 Lab 1',NULL,853),
	(142512,4,180,1564,826,231466,'CHM 101 Lab 2',NULL,853),
	(142513,8,90,1564,826,231467,'CHM 101 Lab 3',NULL,853),
	(142514,32,180,1564,826,231468,'CHM 101 Lab 4',NULL,853),
	(142515,4,90,1564,826,231460,'CHM 101 Lab 5',NULL,853),
	(142516,16,90,1564,826,231462,'CHM 101 Lab 6',NULL,853),
	(142517,16,180,1564,826,231463,'CHM 101 Lab 7',NULL,853),
	(142518,32,138,1564,826,231465,'CHM 101 Lab 8',NULL,853),
	(142519,8,180,1564,826,231464,'CHM 101 Lab 9',NULL,853),
	(142520,32,90,1564,826,231469,'CHM 101 Lab 10',NULL,853),
	(142521,16,138,1564,826,231470,'CHM 101 Lab 11',NULL,853),
	(142522,4,138,1564,826,231471,'CHM 101 Lab 12',NULL,853),
	(142523,32,90,1558,826,231480,'CHM 101 Rec 1',NULL,853),
	(142524,32,102,1558,826,231477,'CHM 101 Rec 2',NULL,853),
	(142525,4,186,1558,826,231484,'CHM 101 Rec 3',NULL,853),
	(142526,64,174,1558,826,231479,'CHM 101 Rec 4',NULL,853),
	(142527,4,138,1558,826,231483,'CHM 101 Rec 5',NULL,853),
	(142528,8,138,1558,826,231473,'CHM 101 Rec 6',NULL,853),
	(142529,16,126,1558,826,231474,'CHM 101 Rec 7',NULL,853),
	(142530,4,150,1558,826,231478,'CHM 101 Rec 8',NULL,853),
	(142531,32,162,1558,826,231476,'CHM 101 Rec 9',NULL,853),
	(142532,8,126,1558,826,231475,'CHM 101 Rec 10',NULL,853),
	(142533,64,102,1558,826,231481,'CHM 101 Rec 11',NULL,853),
	(142534,16,162,1558,826,231482,'CHM 101 Rec 12',NULL,853),
	(142535,40,90,1549,826,231486,'COM 101 Lec 1',NULL,853),
	(142536,40,198,1549,826,231487,'COM 101 Lec 2',NULL,853),
	(142537,40,90,1549,826,231488,'COM 101 Lec 3',NULL,853),
	(142538,40,162,1549,826,231489,'COM 101 Lec 4',NULL,853),
	(142539,40,198,1549,826,231490,'COM 101 Lec 5',NULL,853),
	(142540,40,108,1549,826,231491,'COM 101 Lec 6',NULL,853),
	(142541,40,180,1549,826,231492,'COM 101 Lec 7',NULL,853),
	(142542,40,126,1549,826,231493,'COM 101 Lec 8',NULL,853),
	(142543,40,108,1549,826,231494,'COM 101 Lec 9',NULL,853),
	(142544,84,138,1539,827,231496,'ECON 101 Lec 1',NULL,853),
	(142545,84,198,1539,826,231498,'ENGL 101 Lec 1',NULL,853),
	(142546,84,186,1539,826,231499,'ENGL 101 Lec 2',NULL,853),
	(142547,84,126,1539,826,231500,'ENGL 101 Lec 3',NULL,853),
	(142548,84,174,1539,826,231501,'ENGL 101 Lec 4',NULL,853),
	(142549,84,138,1539,826,231502,'ENGL 101 Lec 5',NULL,853),
	(142550,84,162,1539,826,231503,'ENGL 101 Lec 6',NULL,853),
	(142551,84,114,1539,826,231504,'ENGL 101 Lec 7',NULL,853),
	(142552,84,102,1539,826,231505,'ENGL 101 Lec 8',NULL,853),
	(142553,84,90,1539,826,231506,'ENGL 101 Lec 9',NULL,853),
	(142554,84,150,1539,826,231507,'ENGL 101 Lec 10',NULL,853),
	(142555,8,174,1558,826,231511,'ENGL 101 Lab 1',NULL,853),
	(142556,8,198,1558,826,231515,'ENGL 101 Lab 2',NULL,853),
	(142557,8,138,1558,826,231518,'ENGL 101 Lab 3',NULL,853),
	(142558,64,138,1558,826,231516,'ENGL 101 Lab 4',NULL,853),
	(142559,4,198,1558,826,231512,'ENGL 101 Lab 5',NULL,853),
	(142560,64,186,1558,826,231513,'ENGL 101 Lab 6',NULL,853),
	(142561,32,114,1558,826,231509,'ENGL 101 Lab 7',NULL,853),
	(142562,8,150,1558,826,231510,'ENGL 101 Lab 8',NULL,853),
	(142563,32,198,1558,826,231514,'ENGL 101 Lab 9',NULL,853),
	(142564,32,174,1558,826,231517,'ENGL 101 Lab 10',NULL,853),
	(142565,40,174,1548,826,231524,'ENGR 101 Lec 1',NULL,853),
	(142566,4,114,1562,826,231520,'ENGR 101 Lab 1',NULL,853),
	(142567,64,114,1562,826,231521,'ENGR 101 Lab 2',NULL,853),
	(142568,16,90,1562,826,231522,'ENGR 101 Lab 3',NULL,853),
	(142569,84,90,1539,826,231526,'GER 101 Lec 1',NULL,853),
	(142570,84,150,1539,826,231527,'GER 101 Lec 2',NULL,853),
	(142571,4,186,1558,826,231531,'GER 101 Lab 1',NULL,853),
	(142572,4,102,1558,826,231532,'GER 101 Lab 2',NULL,853),
	(142573,32,126,1558,826,231529,'GER 101 Lab 3',NULL,853),
	(142574,32,162,1558,826,231530,'GER 101 Lab 4',NULL,853),
	(142575,84,186,1539,826,231534,'HIST 101 Lec 1',NULL,853),
	(142576,84,174,1539,826,231535,'HIST 101 Lec 2',NULL,853),
	(142577,84,198,1539,826,231537,'LING 101 Lec 1',NULL,853),
	(142578,40,126,1548,827,231539,'MBIO 101 Lec 1',NULL,853),
	(142579,64,138,1562,826,231541,'MBIO 101 Lab 1',NULL,853),
	(142580,64,186,1562,826,231542,'MBIO 101 Lab 2',NULL,853),
	(142581,64,162,1562,826,231543,'MBIO 101 Lab 3',NULL,853),
	(142582,32,102,1558,827,231545,'PHAR 101 Lec 1',NULL,853),
	(142583,84,126,1539,826,231547,'PHIL 101 Lec 1',NULL,853),
	(142584,40,150,1548,826,231549,'PHYS 101 Lec 1',NULL,853),
	(142585,40,162,1548,826,231550,'PHYS 101 Lec 2',NULL,853),
	(142586,8,126,1558,826,231553,'PHYS 101 Rec 1',NULL,853),
	(142587,8,186,1558,826,231556,'PHYS 101 Rec 2',NULL,853),
	(142588,32,114,1558,826,231552,'PHYS 101 Rec 3',NULL,853),
	(142589,64,90,1558,826,231554,'PHYS 101 Rec 4',NULL,853),
	(142590,64,114,1558,826,231555,'PHYS 101 Rec 5',NULL,853),
	(142591,4,162,1562,826,231560,'PHYS 101 Lab 1',NULL,853),
	(142592,16,162,1562,826,231562,'PHYS 101 Lab 2',NULL,853),
	(142593,8,90,1562,826,231559,'PHYS 101 Lab 3',NULL,853),
	(142594,4,138,1562,826,231561,'PHYS 101 Lab 4',NULL,853),
	(142595,8,114,1562,826,231558,'PHYS 101 Lab 5',NULL,853),
	(142596,40,162,1549,826,231564,'POL 101 Lec 1',NULL,853),
	(142597,40,144,1549,826,231565,'POL 101 Lec 2',NULL,853),
	(142598,84,162,1539,827,231567,'PSY 101 Lec 1',NULL,853),
	(142599,84,102,1539,826,231569,'SOC 101 Lec 1',NULL,853),
	(142600,84,198,1539,826,231570,'SOC 101 Lec 2',NULL,853),
	(142601,40,180,1549,826,231572,'SPAN 101 Lec 1',NULL,853),
	(142602,40,198,1549,826,231573,'SPAN 101 Lec 2',NULL,853),
	(142603,16,138,1558,826,231577,'SPAN 101 Lab 1',NULL,853),
	(142604,8,162,1558,826,231578,'SPAN 101 Lab 2',NULL,853),
	(142605,64,102,1558,826,231575,'SPAN 101 Lab 3',NULL,853),
	(142606,16,186,1558,826,231576,'SPAN 101 Lab 4',NULL,853);

insert into `building` values
	(1761,223206,'EDUC','Education Hall',1,1,NULL),
	(1762,223206,'THTR','Theater of Performing Arts',2,1,NULL),
	(1782,231379,'EDUC','Education Hall',1,1,NULL),
	(1783,231379,'THTR','Theater of Performing Arts',2,1,NULL);

insert into `building_pref` values
	(121515,226240,2,1761,NULL,NULL),
	(123256,231389,2,1782,NULL,NULL);

insert into `class_` values
	(223240,223239,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'003001',1,4,1,1,NULL,NULL,NULL,3),
	(223245,223244,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,1,NULL,NULL,NULL,2),
	(223249,223248,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'001001',1,4,1,1,NULL,NULL,NULL,3),
	(223256,223254,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'003001',1,4,1,1,NULL,NULL,NULL,4),
	(223257,223254,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'002001',1,4,1,2,NULL,NULL,NULL,4),
	(223258,223254,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'001001',1,4,1,3,NULL,NULL,NULL,4),
	(223259,223255,1,1,223256,NULL,NULL,NULL,NULL,223207,1,NULL,'009001',1,1,1,1,NULL,NULL,NULL,1),
	(223260,223255,1,1,223256,NULL,NULL,NULL,NULL,223207,1,NULL,'011001',1,1,1,2,NULL,NULL,NULL,1),
	(223261,223255,1,1,223256,NULL,NULL,NULL,NULL,223207,1,NULL,'012001',1,1,1,3,NULL,NULL,NULL,1),
	(223263,223255,1,1,223256,NULL,NULL,NULL,NULL,223207,1,NULL,'010001',1,1,1,4,NULL,NULL,NULL,1),
	(223264,223255,1,1,223257,NULL,NULL,NULL,NULL,223207,1,NULL,'007001',1,1,1,5,NULL,NULL,NULL,1),
	(223265,223255,1,1,223257,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,6,NULL,NULL,NULL,1),
	(223267,223255,1,1,223257,NULL,NULL,NULL,NULL,223207,1,NULL,'008001',1,1,1,7,NULL,NULL,NULL,1),
	(223268,223255,1,1,223257,NULL,NULL,NULL,NULL,223207,1,NULL,'006001',1,1,1,8,NULL,NULL,NULL,1),
	(223269,223255,1,1,223258,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,9,NULL,NULL,NULL,1),
	(223291,223290,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'001001',1,4,1,1,NULL,NULL,NULL,4),
	(223297,223296,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,1,NULL,NULL,NULL,1),
	(223298,223296,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'008001',1,1,1,2,NULL,NULL,NULL,1),
	(223299,223296,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,3,NULL,NULL,NULL,1),
	(223300,223296,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'007001',1,1,1,4,NULL,NULL,NULL,1),
	(223301,223296,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'006001',1,1,1,5,NULL,NULL,NULL,1),
	(223302,223296,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,6,NULL,NULL,NULL,1),
	(223303,223296,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'009001',1,1,1,7,NULL,NULL,NULL,1),
	(223304,223296,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,8,NULL,NULL,NULL,1),
	(223305,223296,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,9,NULL,NULL,NULL,0),
	(223310,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'010001',1,1,1,1,NULL,NULL,NULL,1),
	(223311,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,2,NULL,NULL,NULL,1),
	(223312,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'009001',1,1,1,3,NULL,NULL,NULL,1),
	(223313,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'006001',1,1,1,4,NULL,NULL,NULL,1),
	(223314,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,5,NULL,NULL,NULL,1),
	(223315,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,6,NULL,NULL,NULL,1),
	(223316,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,7,NULL,NULL,NULL,1),
	(223317,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,8,NULL,NULL,NULL,1),
	(223318,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'008001',1,1,1,9,NULL,NULL,NULL,1),
	(223319,223309,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'007001',1,1,1,10,NULL,NULL,NULL,1),
	(223324,223323,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,1,NULL,NULL,NULL,2),
	(223325,223323,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,2,1,2,NULL,NULL,NULL,2),
	(223330,223329,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,2,1,1,NULL,NULL,NULL,2),
	(223331,223329,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,2,NULL,NULL,NULL,1),
	(223344,223343,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,1,NULL,NULL,NULL,2),
	(223350,223349,3,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,3,1,1,NULL,NULL,NULL,3),
	(223351,223349,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,2,NULL,NULL,NULL,2),
	(223356,223355,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,1,NULL,NULL,NULL,2),
	(223363,223362,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'001001',1,4,1,1,NULL,NULL,NULL,4),
	(223373,223372,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,2,1,1,NULL,NULL,NULL,2),
	(223378,223377,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,2,1,1,NULL,NULL,NULL,2),
	(223379,223377,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,2,NULL,NULL,NULL,1),
	(223800,223799,1,1,223378,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,1,NULL,NULL,NULL,1),
	(223801,223799,1,1,223378,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,2,NULL,NULL,NULL,1),
	(223802,223799,1,1,223379,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,3,NULL,NULL,NULL,1),
	(223803,223799,1,1,223379,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,4,NULL,NULL,NULL,0),
	(223817,223255,1,1,223258,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,10,NULL,NULL,NULL,1),
	(223818,223255,1,1,223258,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,11,NULL,NULL,NULL,1),
	(223819,223255,1,1,223258,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,12,NULL,NULL,NULL,1),
	(223824,223815,1,1,223259,NULL,NULL,NULL,NULL,223207,1,NULL,'009001',1,1,1,1,NULL,NULL,NULL,1),
	(223825,223815,1,1,223260,NULL,NULL,NULL,NULL,223207,1,NULL,'011001',1,1,1,2,NULL,NULL,NULL,1),
	(223826,223815,1,1,223261,NULL,NULL,NULL,NULL,223207,1,NULL,'012001',1,1,1,3,NULL,NULL,NULL,1),
	(223827,223815,1,1,223263,NULL,NULL,NULL,NULL,223207,1,NULL,'010001',1,1,1,4,NULL,NULL,NULL,1),
	(223828,223815,1,1,223264,NULL,NULL,NULL,NULL,223207,1,NULL,'007001',1,1,1,5,NULL,NULL,NULL,1),
	(223829,223815,1,1,223265,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,6,NULL,NULL,NULL,1),
	(223830,223815,1,1,223267,NULL,NULL,NULL,NULL,223207,1,NULL,'008001',1,1,1,7,NULL,NULL,NULL,1),
	(223831,223815,1,1,223268,NULL,NULL,NULL,NULL,223207,1,NULL,'006001',1,1,1,8,NULL,NULL,NULL,1),
	(223832,223815,1,1,223269,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,9,NULL,NULL,NULL,1),
	(223833,223815,1,1,223817,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,10,NULL,NULL,NULL,1),
	(223834,223815,1,1,223818,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,11,NULL,NULL,NULL,1),
	(223835,223815,1,1,223819,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,12,NULL,NULL,NULL,1),
	(223851,223848,1,1,223310,NULL,NULL,NULL,NULL,223207,1,NULL,'010001',1,1,1,1,NULL,NULL,NULL,1),
	(223852,223848,1,1,223311,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,2,NULL,NULL,NULL,1),
	(223853,223848,1,1,223312,NULL,NULL,NULL,NULL,223207,1,NULL,'009001',1,1,1,3,NULL,NULL,NULL,1),
	(223854,223848,1,1,223313,NULL,NULL,NULL,NULL,223207,1,NULL,'006001',1,1,1,4,NULL,NULL,NULL,1),
	(223855,223848,1,1,223314,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,5,NULL,NULL,NULL,1),
	(223856,223848,1,1,223315,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,6,NULL,NULL,NULL,1),
	(223857,223848,1,1,223316,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,7,NULL,NULL,NULL,1),
	(223858,223848,1,1,223317,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,8,NULL,NULL,NULL,1),
	(223859,223848,1,1,223318,NULL,NULL,NULL,NULL,223207,1,NULL,'008001',1,1,1,9,NULL,NULL,NULL,1),
	(223860,223848,1,1,223319,NULL,NULL,NULL,NULL,223207,1,NULL,'007001',1,1,1,10,NULL,NULL,NULL,1),
	(223869,223867,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'002001',1,4,1,1,NULL,NULL,NULL,4),
	(223870,223868,1,1,223869,NULL,NULL,NULL,NULL,223207,1,NULL,'007001',1,1,1,1,NULL,NULL,NULL,1),
	(223884,223228,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,1,NULL,NULL,NULL,2),
	(223899,223239,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'002001',1,4,1,2,NULL,NULL,NULL,4),
	(223900,223239,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'001001',1,4,1,3,NULL,NULL,NULL,3),
	(223902,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,1,NULL,NULL,NULL,1),
	(223903,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'010001',1,1,1,2,NULL,NULL,NULL,1),
	(223904,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,3,NULL,NULL,NULL,1),
	(223905,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'011001',1,1,1,4,NULL,NULL,NULL,0),
	(223906,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,5,NULL,NULL,NULL,1),
	(223907,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,6,NULL,NULL,NULL,1),
	(223908,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,7,NULL,NULL,NULL,1),
	(223909,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'009001',1,1,1,8,NULL,NULL,NULL,1),
	(223910,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'006001',1,1,1,9,NULL,NULL,NULL,1),
	(223914,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'010001',1,1,1,1,NULL,NULL,NULL,1),
	(223915,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,2,NULL,NULL,NULL,1),
	(223916,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,3,NULL,NULL,NULL,1),
	(223917,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,4,NULL,NULL,NULL,1),
	(223918,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'011001',1,1,1,5,NULL,NULL,NULL,1),
	(223919,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'007001',1,1,1,6,NULL,NULL,NULL,0),
	(223920,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'006001',1,1,1,7,NULL,NULL,NULL,1),
	(223921,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'008001',1,1,1,8,NULL,NULL,NULL,1),
	(223922,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'009001',1,1,1,9,NULL,NULL,NULL,1),
	(223926,223925,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'001001',1,4,1,1,NULL,NULL,NULL,3),
	(223927,223925,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'003001',1,4,1,2,NULL,NULL,NULL,3),
	(223947,223244,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,2,1,2,NULL,NULL,NULL,2),
	(223949,223948,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,1,NULL,NULL,NULL,1),
	(223950,223948,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,2,NULL,NULL,NULL,1),
	(223951,223948,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,3,NULL,NULL,NULL,1),
	(223956,223867,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'003001',1,4,1,2,NULL,NULL,NULL,4),
	(223957,223867,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'001001',1,4,1,3,NULL,NULL,NULL,4),
	(223958,223868,1,1,223869,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,2,NULL,NULL,NULL,1),
	(223959,223868,1,1,223869,NULL,NULL,NULL,NULL,223207,1,NULL,'006001',1,1,1,3,NULL,NULL,NULL,1),
	(223960,223868,1,1,223869,NULL,NULL,NULL,NULL,223207,1,NULL,'008001',1,1,1,4,NULL,NULL,NULL,1),
	(223961,223868,1,1,223956,NULL,NULL,NULL,NULL,223207,1,NULL,'011001',1,1,1,5,NULL,NULL,NULL,1),
	(223962,223868,1,1,223956,NULL,NULL,NULL,NULL,223207,1,NULL,'009001',1,1,1,6,NULL,NULL,NULL,1),
	(223963,223868,1,1,223956,NULL,NULL,NULL,NULL,223207,1,NULL,'010001',1,1,1,7,NULL,NULL,NULL,1),
	(223964,223868,1,1,223956,NULL,NULL,NULL,NULL,223207,1,NULL,'012001',1,1,1,8,NULL,NULL,NULL,1),
	(223965,223868,1,1,223957,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,9,NULL,NULL,NULL,1),
	(223966,223868,1,1,223957,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,10,NULL,NULL,NULL,1),
	(223967,223868,1,1,223957,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,11,NULL,NULL,NULL,1),
	(223968,223868,1,1,223957,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,12,NULL,NULL,NULL,1),
	(223970,223948,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,4,NULL,NULL,NULL,1),
	(223973,223925,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'002001',1,4,1,3,NULL,NULL,NULL,4),
	(223976,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'008001',1,1,1,10,NULL,NULL,NULL,1),
	(223977,223901,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'007001',1,1,1,11,NULL,NULL,NULL,1),
	(223978,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,10,NULL,NULL,NULL,1),
	(223979,223913,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,11,NULL,NULL,NULL,1),
	(223996,223995,3,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,3,1,1,NULL,NULL,NULL,3),
	(223998,223997,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,1,NULL,NULL,NULL,1),
	(223999,223997,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,2,NULL,NULL,NULL,1),
	(224000,223997,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,3,NULL,NULL,NULL,1),
	(224005,224004,1,1,223324,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,1,NULL,NULL,NULL,1),
	(224006,224004,1,1,223324,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,2,NULL,NULL,NULL,1),
	(224007,224004,1,1,223325,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,3,NULL,NULL,NULL,1),
	(224008,224004,1,1,223325,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,4,NULL,NULL,NULL,1),
	(224017,224016,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,1,NULL,NULL,NULL,1),
	(224022,224021,4,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'001001',1,4,1,1,NULL,NULL,NULL,3),
	(224028,223355,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,2,1,2,NULL,NULL,NULL,2),
	(224032,224030,1,1,223350,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,1,NULL,NULL,NULL,1),
	(224033,224030,1,1,223350,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,2,NULL,NULL,NULL,1),
	(224034,224030,1,1,223350,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,3,NULL,NULL,NULL,1),
	(224035,224030,1,1,223351,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,4,NULL,NULL,NULL,1),
	(224036,224030,1,1,223351,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,5,NULL,NULL,NULL,1),
	(224038,224031,1,1,224032,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,1,NULL,NULL,NULL,1),
	(224039,224031,1,1,224033,NULL,NULL,NULL,NULL,223207,1,NULL,'005001',1,1,1,2,NULL,NULL,NULL,1),
	(224040,224031,1,1,224034,NULL,NULL,NULL,NULL,223207,1,NULL,'004001',1,1,1,3,NULL,NULL,NULL,1),
	(224041,224031,1,1,224035,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,4,NULL,NULL,NULL,1),
	(224042,224031,1,1,224036,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,5,NULL,NULL,NULL,1),
	(224050,223372,2,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,2,1,2,NULL,NULL,NULL,1),
	(224057,224056,3,1,NULL,NULL,NULL,NULL,NULL,226199,1,NULL,'001001',1,3,1,1,NULL,NULL,NULL,3),
	(224059,224058,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'003001',1,1,1,1,NULL,NULL,NULL,1),
	(224060,224058,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'002001',1,1,1,2,NULL,NULL,NULL,1),
	(224061,224058,1,1,NULL,NULL,NULL,NULL,NULL,223207,1,NULL,'001001',1,1,1,3,NULL,NULL,NULL,1),
	(231391,231390,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,223884,NULL,2),
	(231393,231392,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,1,NULL,223249,NULL,2),
	(231395,231394,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,1,NULL,223900,NULL,4),
	(231396,231394,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,2,NULL,223240,NULL,4),
	(231397,231394,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,3,NULL,223899,NULL,2),
	(231399,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223922,NULL,1),
	(231400,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223919,NULL,1),
	(231401,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223914,NULL,1),
	(231402,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223920,NULL,1),
	(231403,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,223915,NULL,1),
	(231404,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,6,NULL,223979,NULL,1),
	(231405,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,7,NULL,223916,NULL,1),
	(231406,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,8,NULL,223917,NULL,1),
	(231407,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,9,NULL,223921,NULL,0),
	(231408,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,10,NULL,223918,NULL,1),
	(231409,231398,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,11,NULL,223978,NULL,1),
	(231411,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223910,NULL,1),
	(231412,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223908,NULL,1),
	(231413,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223902,NULL,1),
	(231414,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223904,NULL,1),
	(231415,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,223977,NULL,1),
	(231416,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,6,NULL,223906,NULL,1),
	(231417,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,7,NULL,223903,NULL,1),
	(231418,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,8,NULL,223976,NULL,1),
	(231419,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,9,NULL,223907,NULL,1),
	(231420,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,10,NULL,223905,NULL,0),
	(231421,231410,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,11,NULL,223909,NULL,1),
	(231423,231422,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,1,NULL,223973,NULL,4),
	(231424,231422,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,2,NULL,223926,NULL,4),
	(231425,231422,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,3,NULL,223927,NULL,2),
	(231429,231428,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223949,NULL,1),
	(231430,231428,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223970,NULL,1),
	(231431,231428,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223951,NULL,1),
	(231432,231428,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223950,NULL,0),
	(231434,231433,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,223947,NULL,2),
	(231435,231433,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,2,NULL,223245,NULL,1),
	(231437,231436,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,1,NULL,223956,NULL,4),
	(231438,231436,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,2,NULL,223869,NULL,4),
	(231439,231436,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,3,NULL,223957,NULL,4),
	(231441,231440,1,1,231437,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223964,NULL,1),
	(231442,231440,1,1,231439,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,9,NULL,223967,NULL,1),
	(231443,231440,1,1,231438,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,223959,NULL,1),
	(231444,231440,1,1,231439,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,10,NULL,223966,NULL,1),
	(231445,231440,1,1,231437,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223963,NULL,1),
	(231446,231440,1,1,231438,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,6,NULL,223958,NULL,1),
	(231447,231440,1,1,231439,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,11,NULL,223968,NULL,1),
	(231448,231440,1,1,231438,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,7,NULL,223960,NULL,1),
	(231449,231440,1,1,231437,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223961,NULL,1),
	(231450,231440,1,1,231439,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,12,NULL,223965,NULL,1),
	(231451,231440,1,1,231437,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223962,NULL,1),
	(231452,231440,1,1,231438,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,8,NULL,223870,NULL,1),
	(231456,231455,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,1,NULL,223256,NULL,4),
	(231457,231455,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,2,NULL,223258,NULL,4),
	(231458,231455,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,3,NULL,223257,NULL,4),
	(231460,231459,1,1,231457,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,223818,NULL,1),
	(231461,231459,1,1,231456,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223261,NULL,1),
	(231462,231459,1,1,231457,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,6,NULL,223817,NULL,1),
	(231463,231459,1,1,231457,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,7,NULL,223819,NULL,1),
	(231464,231459,1,1,231458,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,9,NULL,223265,NULL,1),
	(231465,231459,1,1,231457,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,8,NULL,223269,NULL,1),
	(231466,231459,1,1,231456,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223263,NULL,1),
	(231467,231459,1,1,231456,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223260,NULL,1),
	(231468,231459,1,1,231456,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223259,NULL,1),
	(231469,231459,1,1,231458,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,10,NULL,223268,NULL,1),
	(231470,231459,1,1,231458,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,11,NULL,223267,NULL,1),
	(231471,231459,1,1,231458,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,12,NULL,223264,NULL,1),
	(231473,231472,1,1,231462,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,6,NULL,223833,NULL,1),
	(231474,231472,1,1,231463,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,7,NULL,223835,NULL,1),
	(231475,231472,1,1,231469,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,10,NULL,223831,NULL,1),
	(231476,231472,1,1,231464,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,9,NULL,223829,NULL,1),
	(231477,231472,1,1,231466,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223827,NULL,1),
	(231478,231472,1,1,231465,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,8,NULL,223832,NULL,1),
	(231479,231472,1,1,231468,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223824,NULL,1),
	(231480,231472,1,1,231461,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223826,NULL,1),
	(231481,231472,1,1,231470,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,11,NULL,223830,NULL,1),
	(231482,231472,1,1,231471,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,12,NULL,223828,NULL,1),
	(231483,231472,1,1,231460,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,223834,NULL,1),
	(231484,231472,1,1,231467,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223825,NULL,1),
	(231486,231485,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223303,NULL,1),
	(231487,231485,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223301,NULL,1),
	(231488,231485,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223304,NULL,1),
	(231489,231485,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223299,NULL,0),
	(231490,231485,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,223305,NULL,1),
	(231491,231485,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,6,NULL,223298,NULL,1),
	(231492,231485,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,7,NULL,223297,NULL,1),
	(231493,231485,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,8,NULL,223302,NULL,0),
	(231494,231485,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,9,NULL,223300,NULL,1),
	(231496,231495,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,1,NULL,223291,NULL,3),
	(231498,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223314,NULL,1),
	(231499,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223312,NULL,1),
	(231500,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223311,NULL,1),
	(231501,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223310,NULL,1),
	(231502,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,223318,NULL,1),
	(231503,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,6,NULL,223313,NULL,1),
	(231504,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,7,NULL,223317,NULL,1),
	(231505,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,8,NULL,223316,NULL,1),
	(231506,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,9,NULL,223319,NULL,1),
	(231507,231497,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,10,NULL,223315,NULL,1),
	(231509,231508,1,1,231504,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,7,NULL,223858,NULL,1),
	(231510,231508,1,1,231505,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,8,NULL,223857,NULL,1),
	(231511,231508,1,1,231498,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223855,NULL,1),
	(231512,231508,1,1,231502,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,223859,NULL,1),
	(231513,231508,1,1,231503,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,6,NULL,223854,NULL,1),
	(231514,231508,1,1,231506,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,9,NULL,223860,NULL,1),
	(231515,231508,1,1,231499,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223853,NULL,1),
	(231516,231508,1,1,231501,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223851,NULL,1),
	(231517,231508,1,1,231507,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,10,NULL,223856,NULL,1),
	(231518,231508,1,1,231500,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223852,NULL,1),
	(231520,231519,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223999,NULL,1),
	(231521,231519,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,224000,NULL,1),
	(231522,231519,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223998,NULL,1),
	(231524,231523,3,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,3,1,1,NULL,223996,NULL,3),
	(231526,231525,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,223325,NULL,2),
	(231527,231525,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,2,NULL,223324,NULL,2),
	(231529,231528,1,1,231527,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,224005,NULL,1),
	(231530,231528,1,1,231527,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,224006,NULL,1),
	(231531,231528,1,1,231526,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,224008,NULL,1),
	(231532,231528,1,1,231526,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,224007,NULL,1),
	(231534,231533,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,223330,NULL,1),
	(231535,231533,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,2,NULL,223331,NULL,2),
	(231537,231536,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,224017,NULL,1),
	(231539,231538,3,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,3,1,1,NULL,224057,NULL,3),
	(231541,231540,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,224061,NULL,1),
	(231542,231540,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,224059,NULL,1),
	(231543,231540,1,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,224060,NULL,1),
	(231545,231544,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,1,NULL,224022,NULL,3),
	(231547,231546,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,223344,NULL,2),
	(231549,231548,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,223351,NULL,2),
	(231550,231548,3,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,3,1,2,NULL,223350,NULL,3),
	(231552,231551,1,1,231550,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,224032,NULL,1),
	(231553,231551,1,1,231549,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,224036,NULL,1),
	(231554,231551,1,1,231550,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,224033,NULL,1),
	(231555,231551,1,1,231550,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,224034,NULL,1),
	(231556,231551,1,1,231549,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,224035,NULL,1),
	(231558,231557,1,1,231555,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,5,NULL,224040,NULL,1),
	(231559,231557,1,1,231552,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,224038,NULL,1),
	(231560,231557,1,1,231553,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,224042,NULL,1),
	(231561,231557,1,1,231554,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,224039,NULL,1),
	(231562,231557,1,1,231556,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,224041,NULL,1),
	(231564,231563,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,224028,NULL,2),
	(231565,231563,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,2,NULL,223356,NULL,1),
	(231567,231566,4,1,NULL,NULL,NULL,NULL,NULL,231382,1,NULL,NULL,1,4,1,1,NULL,223363,NULL,4),
	(231569,231568,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,224050,NULL,1),
	(231570,231568,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,2,NULL,223373,NULL,1),
	(231572,231571,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,1,NULL,223379,NULL,2),
	(231573,231571,2,1,NULL,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,2,1,2,NULL,223378,NULL,1),
	(231575,231574,1,1,231573,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,3,NULL,223801,NULL,0),
	(231576,231574,1,1,231573,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,4,NULL,223800,NULL,1),
	(231577,231574,1,1,231572,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,1,NULL,223802,NULL,1),
	(231578,231574,1,1,231572,NULL,NULL,NULL,NULL,231383,1,NULL,NULL,1,1,1,2,NULL,223803,NULL,1);

insert into `class_instructor` values
	(38068,223884,226242,100,1,NULL),
	(38069,223245,226242,100,1,NULL),
	(38070,223947,226242,100,1,NULL),
	(38071,223949,226246,100,1,NULL),
	(38072,223950,226244,100,1,NULL),
	(38073,223951,226246,100,1,NULL),
	(38074,223970,226244,100,1,NULL),
	(38078,223240,226240,100,1,NULL),
	(38079,223899,226240,100,1,NULL),
	(38080,223900,226240,100,1,NULL),
	(38081,223926,226240,100,1,NULL),
	(38082,223927,226240,100,1,NULL),
	(38083,223973,226240,100,1,NULL),
	(38084,223869,226242,100,1,NULL),
	(38085,223870,226238,100,1,NULL),
	(38086,223958,226238,100,1,NULL),
	(38087,223959,226238,100,1,NULL),
	(38088,223960,226238,100,1,NULL),
	(38089,223956,226242,100,1,NULL),
	(38090,223961,226238,100,1,NULL),
	(38091,223962,226238,100,1,NULL),
	(38092,223963,226238,100,1,NULL),
	(38093,223964,226238,100,1,NULL),
	(38094,223957,226242,100,1,NULL),
	(38095,223965,226238,100,1,NULL),
	(38096,223966,226238,100,1,NULL),
	(38097,223967,226238,100,1,NULL),
	(38098,223968,226238,100,1,NULL),
	(38108,231391,231388,100,1,NULL),
	(38109,231396,231389,100,1,NULL),
	(38110,231423,231389,100,1,NULL),
	(38111,231424,231389,100,1,NULL),
	(38112,231425,231389,100,1,NULL),
	(38113,231395,231389,100,1,NULL),
	(38114,231397,231389,100,1,NULL),
	(38115,231435,231388,100,1,NULL),
	(38116,231434,231388,100,1,NULL),
	(38117,231451,231385,100,1,NULL),
	(38118,231448,231385,100,1,NULL),
	(38119,231438,231388,100,1,NULL),
	(38120,231439,231388,100,1,NULL),
	(38121,231446,231385,100,1,NULL),
	(38122,231442,231385,100,1,NULL),
	(38123,231452,231385,100,1,NULL),
	(38124,231444,231385,100,1,NULL),
	(38125,231437,231388,100,1,NULL),
	(38126,231441,231385,100,1,NULL),
	(38127,231450,231385,100,1,NULL),
	(38128,231443,231385,100,1,NULL),
	(38129,231445,231385,100,1,NULL),
	(38130,231447,231385,100,1,NULL),
	(38131,231449,231385,100,1,NULL);

insert into `class_waitlist` values
	(226169,223384,226168,223884,1,'2007-04-25 11:53:22'),
	(226173,223384,226172,223297,1,'2007-04-25 11:53:22'),
	(226174,223384,226172,223301,1,'2007-04-25 11:53:22'),
	(226178,223384,226177,223363,1,'2007-04-25 11:53:22'),
	(226182,223384,226181,223291,1,'2007-04-25 11:53:22'),
	(226186,223384,226185,223373,1,'2007-04-25 11:53:22');

insert into `constraint_info` values
	(142333,274933),
	(142333,274934),
	(142333,274935),
	(142333,274936),
	(142334,274937),
	(142334,274938),
	(142334,274939),
	(142334,274940),
	(142335,274941),
	(142335,274942),
	(142335,274943),
	(142335,274944),
	(142336,274933),
	(142337,274934),
	(142338,274935),
	(142339,274936),
	(142340,274937),
	(142341,274938),
	(142342,274939),
	(142343,274940),
	(142344,274941),
	(142345,274942),
	(142346,274943),
	(142347,274944),
	(142348,274945),
	(142348,274946),
	(142348,274947),
	(142348,274948),
	(142349,274949),
	(142349,274950),
	(142349,274951),
	(142349,274952),
	(142350,274953),
	(142350,274954),
	(142350,274955),
	(142350,274956),
	(142351,274945),
	(142352,274946),
	(142353,274947),
	(142354,274948),
	(142355,274949),
	(142356,274950),
	(142357,274951),
	(142358,274952),
	(142359,274953),
	(142360,274954),
	(142361,274955),
	(142362,274956),
	(142363,274945),
	(142364,274946),
	(142365,274947),
	(142366,274948),
	(142367,274949),
	(142368,274950),
	(142369,274951),
	(142370,274952),
	(142371,274953),
	(142372,274954),
	(142373,274955),
	(142374,274956),
	(142385,274957),
	(142386,274958),
	(142387,274959),
	(142388,274960),
	(142389,274961),
	(142390,274962),
	(142391,274963),
	(142392,274964),
	(142393,274965),
	(142394,274966),
	(142395,274957),
	(142396,274958),
	(142397,274959),
	(142398,274960),
	(142399,274961),
	(142400,274962),
	(142401,274963),
	(142402,274964),
	(142403,274965),
	(142404,274966),
	(142405,274967),
	(142405,274968),
	(142405,274969),
	(142406,274967),
	(142407,274968),
	(142408,274969),
	(142409,274970),
	(142409,274971),
	(142410,274972),
	(142410,274973),
	(142411,274970),
	(142412,274971),
	(142413,274972),
	(142414,274973),
	(142418,274974),
	(142418,274975),
	(142418,274976),
	(142419,274974),
	(142420,274975),
	(142421,274976),
	(142424,274977),
	(142424,274978),
	(142424,274979),
	(142425,274980),
	(142425,274981),
	(142426,274977),
	(142427,274978),
	(142428,274979),
	(142429,274980),
	(142430,274981),
	(142431,274977),
	(142432,274978),
	(142433,274979),
	(142434,274980),
	(142435,274981),
	(142441,274982),
	(142441,274983),
	(142442,274984),
	(142442,274985),
	(142443,274982),
	(142444,274983),
	(142445,274984),
	(142446,274985),
	(142493,275153),
	(142493,275154),
	(142493,275155),
	(142493,275156),
	(142494,275157),
	(142494,275158),
	(142494,275159),
	(142494,275160),
	(142495,275161),
	(142495,275162),
	(142495,275163),
	(142495,275164),
	(142496,275153),
	(142497,275154),
	(142498,275155),
	(142499,275156),
	(142500,275157),
	(142501,275158),
	(142502,275159),
	(142503,275160),
	(142504,275161),
	(142505,275162),
	(142506,275163),
	(142507,275164),
	(142508,275165),
	(142508,275166),
	(142508,275167),
	(142508,275168),
	(142509,275169),
	(142509,275170),
	(142509,275171),
	(142509,275172),
	(142510,275173),
	(142510,275174),
	(142510,275175),
	(142510,275176),
	(142511,275165),
	(142512,275166),
	(142513,275167),
	(142514,275168),
	(142515,275169),
	(142516,275170),
	(142517,275171),
	(142518,275172),
	(142519,275173),
	(142520,275174),
	(142521,275175),
	(142522,275176),
	(142523,275165),
	(142524,275166),
	(142525,275167),
	(142526,275168),
	(142527,275169),
	(142528,275170),
	(142529,275171),
	(142530,275172),
	(142531,275173),
	(142532,275174),
	(142533,275175),
	(142534,275176),
	(142545,275177),
	(142546,275178),
	(142547,275179),
	(142548,275180),
	(142549,275181),
	(142550,275182),
	(142551,275183),
	(142552,275184),
	(142553,275185),
	(142554,275186),
	(142555,275177),
	(142556,275178),
	(142557,275179),
	(142558,275180),
	(142559,275181),
	(142560,275182),
	(142561,275183),
	(142562,275184),
	(142563,275185),
	(142564,275186),
	(142565,275187),
	(142565,275188),
	(142565,275189),
	(142566,275187),
	(142567,275188),
	(142568,275189),
	(142569,275190),
	(142569,275191),
	(142570,275192),
	(142570,275193),
	(142571,275190),
	(142572,275191),
	(142573,275192),
	(142574,275193),
	(142578,275194),
	(142578,275195),
	(142578,275196),
	(142579,275194),
	(142580,275195),
	(142581,275196),
	(142584,275197),
	(142584,275198),
	(142585,275199),
	(142585,275200),
	(142585,275201),
	(142586,275197),
	(142587,275198),
	(142588,275199),
	(142589,275200),
	(142590,275201),
	(142591,275197),
	(142592,275198),
	(142593,275199),
	(142594,275200),
	(142595,275201),
	(142601,275202),
	(142601,275203),
	(142602,275204),
	(142602,275205),
	(142603,275202),
	(142604,275203),
	(142605,275204),
	(142606,275205);

insert into `course_credit_type` values
	(238,'collegiate','Collegiate Credit',NULL,' '),
	(239,'continuingEdUnits','Continuing Education Units','CEU','Q'),
	(240,'equivalent','Equivalent Credit','EQV','E'),
	(241,'mastersCredit','Masters Credit','MS','M'),
	(242,'phdThesisCredit','Phd Thesis Credit','PhD','T');

insert into `course_credit_unit_config` values
	(27602,'fixedUnit',NULL,238,248,1,3,NULL,NULL,NULL,132313,NULL),
	(27604,'fixedUnit',223228,238,248,0,3,NULL,NULL,NULL,NULL,NULL),
	(27621,'fixedUnit',NULL,238,248,1,3,NULL,NULL,NULL,132351,NULL),
	(27622,'fixedUnit',231390,238,248,0,3,NULL,NULL,NULL,NULL,NULL);

insert into `course_credit_unit_type` values
	(248,'semesterHours','Semester Hours',NULL);

insert into `course_demand` values
	(225476,223385,0,0,0,'2007-04-25 10:31:02',NULL,NULL),
	(225479,223385,1,0,0,'2007-04-25 10:31:02',NULL,NULL),
	(225482,223385,2,0,0,'2007-04-25 10:31:02',NULL,NULL),
	(225485,223385,3,0,0,'2007-04-25 10:31:02',NULL,NULL),
	(225488,223385,4,0,0,'2007-04-25 10:31:02',NULL,NULL),
	(225492,223386,0,0,0,'2007-04-25 10:31:04',NULL,NULL),
	(225496,223386,1,0,0,'2007-04-25 10:31:04',NULL,NULL),
	(225500,223386,2,0,0,'2007-04-25 10:31:04',NULL,NULL),
	(225503,223386,3,0,0,'2007-04-25 10:31:04',NULL,NULL),
	(225506,223386,4,0,0,'2007-04-25 10:31:04',NULL,NULL),
	(225510,223387,0,0,0,'2007-04-25 10:31:05',NULL,NULL),
	(225516,223387,1,0,0,'2007-04-25 10:31:05',NULL,NULL),
	(225521,223387,2,0,0,'2007-04-25 10:31:05',NULL,NULL),
	(225525,223387,3,0,0,'2007-04-25 10:31:05',NULL,NULL),
	(225528,223387,4,0,0,'2007-04-25 10:31:05',NULL,NULL),
	(225532,223388,0,0,0,'2007-04-25 10:31:06',NULL,NULL),
	(225538,223388,1,0,0,'2007-04-25 10:31:06',NULL,NULL),
	(225543,223388,2,0,0,'2007-04-25 10:31:06',NULL,NULL),
	(225547,223388,3,0,0,'2007-04-25 10:31:06',NULL,NULL),
	(225550,223388,4,0,0,'2007-04-25 10:31:06',NULL,NULL),
	(225554,223389,0,0,0,'2007-04-25 10:31:07',NULL,NULL),
	(225560,223389,1,0,0,'2007-04-25 10:31:07',NULL,NULL),
	(225565,223389,2,0,0,'2007-04-25 10:31:07',NULL,NULL),
	(225569,223389,3,0,0,'2007-04-25 10:31:07',NULL,NULL),
	(225572,223389,4,0,0,'2007-04-25 10:31:07',NULL,NULL),
	(225576,223390,0,0,0,'2007-04-25 10:31:08',NULL,NULL),
	(225581,223390,1,0,0,'2007-04-25 10:31:08',NULL,NULL),
	(225586,223390,2,0,0,'2007-04-25 10:31:08',NULL,NULL),
	(225590,223390,3,0,0,'2007-04-25 10:31:08',NULL,NULL),
	(225594,223390,4,0,0,'2007-04-25 10:31:08',NULL,NULL),
	(225597,223390,5,0,0,'2007-04-25 10:31:08',NULL,NULL),
	(225600,223391,0,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225605,223391,1,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225611,223391,2,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225615,223391,3,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225619,223391,4,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225622,223392,0,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225627,223392,1,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225632,223392,2,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225636,223392,3,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225640,223392,4,0,0,'2007-04-25 10:31:09',NULL,NULL),
	(225644,223393,0,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225649,223393,1,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225654,223393,2,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225658,223393,3,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225662,223393,4,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225666,223394,0,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225672,223394,1,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225675,223394,2,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225678,223394,3,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225681,223394,4,0,0,'2007-04-25 10:31:10',NULL,NULL),
	(225685,223395,0,0,0,'2007-04-25 10:31:11',NULL,NULL),
	(225688,223395,1,0,0,'2007-04-25 10:31:11',NULL,NULL),
	(225692,223395,2,0,0,'2007-04-25 10:31:11',NULL,NULL),
	(225696,223395,3,0,0,'2007-04-25 10:31:11',NULL,NULL),
	(225699,223395,4,0,0,'2007-04-25 10:31:11',NULL,NULL),
	(225702,223395,5,0,0,'2007-04-25 10:31:11',NULL,NULL),
	(225705,223396,0,0,0,'2007-04-25 10:31:12',NULL,NULL),
	(225708,223396,1,0,0,'2007-04-25 10:31:12',NULL,NULL),
	(225711,223396,2,0,0,'2007-04-25 10:31:12',NULL,NULL),
	(225714,223396,3,0,0,'2007-04-25 10:31:12',NULL,NULL),
	(225717,223396,4,0,0,'2007-04-25 10:31:12',NULL,NULL),
	(225722,223397,0,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225728,223397,1,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225732,223397,2,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225737,223397,3,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225741,223397,4,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225745,223398,0,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225751,223398,1,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225755,223398,2,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225760,223398,3,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225764,223398,4,0,0,'2007-04-25 10:31:13',NULL,NULL),
	(225768,223399,0,0,0,'2007-04-25 10:31:14',NULL,NULL),
	(225774,223399,1,0,0,'2007-04-25 10:31:14',NULL,NULL),
	(225778,223399,2,0,0,'2007-04-25 10:31:14',NULL,NULL),
	(225780,223399,3,0,0,'2007-04-25 10:31:14',NULL,NULL),
	(225784,223399,4,0,0,'2007-04-25 10:31:14',NULL,NULL),
	(225788,223400,0,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225791,223400,1,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225797,223400,2,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225802,223400,3,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225806,223400,4,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225810,223401,0,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225813,223401,1,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225819,223401,2,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225824,223401,3,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225828,223401,4,0,0,'2007-04-25 10:31:15',NULL,NULL),
	(225832,223402,0,0,0,'2007-04-25 10:31:16',NULL,NULL),
	(225836,223402,1,0,0,'2007-04-25 10:31:16',NULL,NULL),
	(225841,223402,2,0,0,'2007-04-25 10:31:16',NULL,NULL),
	(225843,223402,3,0,0,'2007-04-25 10:31:16',NULL,NULL),
	(225846,223402,4,0,0,'2007-04-25 10:31:16',NULL,NULL),
	(226167,223384,0,0,0,'2007-04-25 11:53:22',NULL,NULL),
	(226171,223384,1,0,0,'2007-04-25 11:53:22',NULL,NULL),
	(226176,223384,2,0,0,'2007-04-25 11:53:22',NULL,NULL),
	(226180,223384,3,0,0,'2007-04-25 11:53:22',NULL,NULL),
	(226184,223384,4,0,0,'2007-04-25 11:53:22',NULL,NULL),
	(237788,231849,0,0,0,'2010-09-22 16:25:20',NULL,NULL),
	(237790,231849,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237792,231849,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237794,231849,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237796,231849,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237799,232436,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237801,232436,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237803,232436,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237805,232436,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237807,232436,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237810,232448,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237812,232448,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237814,232448,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237816,232448,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237818,232448,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237821,232460,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237823,232460,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237825,232460,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237827,232460,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237829,232460,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237832,232472,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237834,232472,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237836,232472,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237838,232472,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237840,232472,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237843,232484,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237845,232484,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237847,232484,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237849,232484,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237851,232484,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237854,232496,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237856,232496,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237858,232496,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237860,232496,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237862,232496,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237864,232496,5,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237867,232510,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237869,232510,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237871,232510,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237873,232510,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237875,232510,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237878,232522,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237880,232522,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237882,232522,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237884,232522,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237886,232522,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237889,232534,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237891,232534,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237893,232534,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237895,232534,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237897,232534,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237900,232546,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237902,232546,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237904,232546,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237906,232546,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237908,232546,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237911,232558,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237913,232558,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237915,232558,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237917,232558,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237919,232558,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237921,232558,5,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237924,232572,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237926,232572,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237928,232572,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237930,232572,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237932,232572,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237935,232584,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237937,232584,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237939,232584,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237941,232584,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237943,232584,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237946,232596,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237948,232596,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237950,232596,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237952,232596,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237954,232596,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237957,232608,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237959,232608,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237961,232608,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237963,232608,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237965,232608,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237968,232620,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237970,232620,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237972,232620,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237974,232620,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237976,232620,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237979,232632,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237981,232632,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237983,232632,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237985,232632,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237987,232632,4,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237990,232644,0,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237992,232644,1,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237994,232644,2,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237996,232644,3,0,0,'2010-09-22 16:25:21',NULL,NULL),
	(237998,232644,4,0,0,'2010-09-22 16:25:21',NULL,NULL);

insert into `course_offering` values
	(135715,'101',1,NULL,0,132313,761,'Algebra I',NULL,NULL,NULL,0,NULL,NULL,NULL,2,2,2,NULL,NULL),
	(135716,'101',1,NULL,0,132314,762,'Introduction to Biology',NULL,NULL,NULL,0,NULL,NULL,NULL,11,10,NULL,NULL,NULL),
	(135717,'101',1,NULL,0,132315,763,'Introductory Computing',NULL,NULL,NULL,0,NULL,NULL,NULL,4,4,NULL,NULL,NULL),
	(135718,'101',1,NULL,0,132316,764,'Band',NULL,NULL,NULL,0,NULL,NULL,NULL,4,3,NULL,NULL,NULL),
	(135719,'101',1,NULL,0,132317,765,'Chemistry I',NULL,NULL,NULL,0,NULL,NULL,NULL,12,12,NULL,NULL,NULL),
	(135720,'101',1,NULL,0,132318,766,'Micoeconomics',NULL,NULL,NULL,0,NULL,NULL,NULL,4,4,NULL,NULL,NULL),
	(135721,'101',1,NULL,0,132319,767,'Communications I',NULL,NULL,NULL,0,NULL,NULL,NULL,9,8,NULL,NULL,NULL),
	(135722,'101',1,NULL,0,132320,768,'English',NULL,NULL,NULL,0,NULL,NULL,NULL,10,10,NULL,NULL,NULL),
	(135723,'101',1,NULL,0,132321,769,'German',NULL,NULL,NULL,0,NULL,NULL,NULL,4,4,NULL,NULL,NULL),
	(135724,'101',1,NULL,0,132322,770,'History of the World',NULL,NULL,NULL,0,NULL,NULL,NULL,4,3,NULL,NULL,NULL),
	(135726,'101',1,NULL,0,132324,772,'Philosophy',NULL,NULL,NULL,0,NULL,NULL,NULL,2,2,NULL,NULL,NULL),
	(135727,'101',1,NULL,0,132325,773,'Physics',NULL,NULL,NULL,0,NULL,NULL,NULL,5,5,NULL,NULL,NULL),
	(135728,'101',1,NULL,0,132326,774,'Political Science',NULL,NULL,NULL,0,NULL,NULL,NULL,4,4,NULL,NULL,NULL),
	(135729,'101',1,NULL,0,132327,775,'Psychology',NULL,NULL,NULL,0,NULL,NULL,NULL,4,4,NULL,NULL,NULL),
	(135730,'201',1,NULL,0,132328,776,'Advanced Chinese',NULL,NULL,NULL,0,NULL,NULL,NULL,0,0,NULL,NULL,NULL),
	(135731,'101',1,NULL,0,132329,777,'Sociology',NULL,NULL,NULL,0,NULL,NULL,NULL,4,3,NULL,NULL,NULL),
	(135732,'101',1,NULL,0,132330,778,'Spanish',NULL,NULL,NULL,0,NULL,NULL,NULL,4,3,NULL,NULL,NULL),
	(135733,'101',1,NULL,0,132331,771,'Calculus',NULL,NULL,NULL,0,NULL,NULL,NULL,12,12,NULL,NULL,NULL),
	(135735,'201',1,NULL,0,132334,762,'Principles of Microbiology',NULL,NULL,NULL,0,NULL,NULL,NULL,0,0,NULL,NULL,NULL),
	(135736,'101',1,NULL,0,132335,779,'Freshman Engineering',NULL,NULL,NULL,0,NULL,NULL,NULL,3,3,NULL,NULL,NULL),
	(135737,'101',1,NULL,0,132336,780,'Introduction to Linguistics',NULL,NULL,NULL,0,NULL,NULL,NULL,1,1,NULL,NULL,NULL),
	(135738,'101',1,NULL,0,132337,781,'Seminars in Pharmacy',NULL,NULL,NULL,0,NULL,NULL,NULL,3,3,NULL,NULL,NULL),
	(135739,'101',1,NULL,0,132338,782,'Principles of Microbiology',NULL,NULL,NULL,0,NULL,NULL,NULL,3,3,NULL,NULL,NULL),
	(135753,'101',1,NULL,NULL,132351,799,'Algebra I',NULL,NULL,NULL,0,NULL,NULL,135715,2,NULL,NULL,NULL,NULL),
	(135754,'101',1,NULL,NULL,132352,800,'Band',NULL,NULL,NULL,0,NULL,NULL,135718,3,NULL,NULL,NULL,NULL),
	(135755,'101',1,NULL,NULL,132353,801,'Introduction to Biology',NULL,NULL,NULL,0,NULL,NULL,135716,10,NULL,NULL,NULL,NULL),
	(135756,'201',1,NULL,NULL,132354,801,'Principles of Microbiology',NULL,NULL,NULL,0,NULL,NULL,135735,0,NULL,NULL,NULL,NULL),
	(135757,'101',1,NULL,NULL,132355,802,'Introductory Computing',NULL,NULL,NULL,0,NULL,NULL,135717,4,NULL,NULL,NULL,NULL),
	(135758,'101',1,NULL,NULL,132356,803,'Calculus',NULL,NULL,NULL,0,NULL,NULL,135733,12,NULL,NULL,NULL,NULL),
	(135759,'201',1,NULL,NULL,132357,804,'Advanced Chinese',NULL,NULL,NULL,0,NULL,NULL,135730,0,NULL,NULL,NULL,NULL),
	(135760,'101',1,NULL,NULL,132358,805,'Chemistry I',NULL,NULL,NULL,0,NULL,NULL,135719,12,NULL,NULL,NULL,NULL),
	(135761,'101',1,NULL,NULL,132359,806,'Communications I',NULL,NULL,NULL,0,NULL,NULL,135721,8,NULL,NULL,NULL,NULL),
	(135762,'101',1,NULL,NULL,132360,807,'Micoeconomics',NULL,NULL,NULL,0,NULL,NULL,135720,4,NULL,NULL,NULL,NULL),
	(135763,'101',1,NULL,NULL,132361,808,'English',NULL,NULL,NULL,0,NULL,NULL,135722,10,NULL,NULL,NULL,NULL),
	(135764,'101',1,NULL,NULL,132362,809,'Freshman Engineering',NULL,NULL,NULL,0,NULL,NULL,135736,3,NULL,NULL,NULL,NULL),
	(135765,'101',1,NULL,NULL,132363,810,'German',NULL,NULL,NULL,0,NULL,NULL,135723,4,NULL,NULL,NULL,NULL),
	(135766,'101',1,NULL,NULL,132364,811,'History of the World',NULL,NULL,NULL,0,NULL,NULL,135724,3,NULL,NULL,NULL,NULL),
	(135767,'101',1,NULL,NULL,132365,812,'Introduction to Linguistics',NULL,NULL,NULL,0,NULL,NULL,135737,1,NULL,NULL,NULL,NULL),
	(135768,'101',1,NULL,NULL,132366,813,'Principles of Microbiology',NULL,NULL,NULL,0,NULL,NULL,135739,3,NULL,NULL,NULL,NULL),
	(135769,'101',1,NULL,NULL,132367,814,'Seminars in Pharmacy',NULL,NULL,NULL,0,NULL,NULL,135738,3,NULL,NULL,NULL,NULL),
	(135770,'101',1,NULL,NULL,132368,815,'Philosophy',NULL,NULL,NULL,0,NULL,NULL,135726,2,NULL,NULL,NULL,NULL),
	(135771,'101',1,NULL,NULL,132369,816,'Physics',NULL,NULL,NULL,0,NULL,NULL,135727,5,NULL,NULL,NULL,NULL),
	(135772,'101',1,NULL,NULL,132370,817,'Political Science',NULL,NULL,NULL,0,NULL,NULL,135728,4,NULL,NULL,NULL,NULL),
	(135773,'101',1,NULL,NULL,132371,818,'Psychology',NULL,NULL,NULL,0,NULL,NULL,135729,4,NULL,NULL,NULL,NULL),
	(135774,'101',1,NULL,NULL,132372,819,'Sociology',NULL,NULL,NULL,0,NULL,NULL,135731,3,NULL,NULL,NULL,NULL),
	(135775,'101',1,NULL,NULL,132373,820,'Spanish',NULL,NULL,NULL,0,NULL,NULL,135732,3,NULL,NULL,NULL,NULL);

insert into `course_request` values
	(225477,225476,135715,0,0,-1),
	(225480,225479,135721,0,0,-1),
	(225483,225482,135729,0,0,-1),
	(225486,225485,135720,0,0,-1),
	(225489,225488,135723,0,0,-1),
	(225493,225492,135733,0,0,-1),
	(225497,225496,135722,0,0,-1),
	(225501,225500,135729,0,0,-1),
	(225504,225503,135720,0,0,-1),
	(225507,225506,135717,0,0,-1),
	(225511,225510,135716,0,0,-1),
	(225517,225516,135719,0,0,-1),
	(225522,225521,135733,0,0,-1),
	(225526,225525,135738,0,0,-1),
	(225529,225528,135722,0,0,-1),
	(225533,225532,135716,0,0,-1),
	(225539,225538,135719,0,0,-1),
	(225544,225543,135733,0,0,-1),
	(225548,225547,135738,0,0,-1),
	(225551,225550,135722,0,0,-1),
	(225555,225554,135716,0,0,-1),
	(225561,225560,135719,0,0,-1),
	(225566,225565,135733,0,0,-1),
	(225570,225569,135738,0,0,-1),
	(225573,225572,135722,0,0,-1),
	(225577,225576,135719,0,0,-1),
	(225582,225581,135727,0,0,-1),
	(225587,225586,135736,0,0,-1),
	(225591,225590,135733,0,0,-1),
	(225595,225594,135721,0,0,-1),
	(225598,225597,135718,0,0,-1),
	(225601,225600,135719,0,0,-1),
	(225606,225605,135716,0,0,-1),
	(225612,225611,135736,0,0,-1),
	(225616,225615,135733,0,0,-1),
	(225620,225619,135721,0,0,-1),
	(225623,225622,135719,0,0,-1),
	(225628,225627,135727,0,0,-1),
	(225633,225632,135736,0,0,-1),
	(225637,225636,135733,0,0,-1),
	(225641,225640,135722,0,0,-1),
	(225645,225644,135719,0,0,-1),
	(225650,225649,135727,0,0,-1),
	(225655,225654,135717,0,0,-1),
	(225659,225658,135733,0,0,-1),
	(225663,225662,135722,0,0,-1),
	(225667,225666,135716,0,0,-1),
	(225673,225672,135721,0,0,-1),
	(225676,225675,135728,0,0,-1),
	(225679,225678,135729,0,0,-1),
	(225682,225681,135732,0,0,-1),
	(225686,225685,135721,0,0,-1),
	(225689,225688,135722,0,0,-1),
	(225693,225692,135723,0,0,-1),
	(225697,225696,135726,0,0,-1),
	(225700,225699,135724,0,0,-1),
	(225703,225702,135718,0,0,-1),
	(225706,225705,135731,0,0,-1),
	(225709,225708,135724,0,0,-1),
	(225712,225711,135737,0,0,-1),
	(225715,225714,135726,0,0,-1),
	(225718,225717,135727,0,0,-1),
	(225723,225722,135716,0,0,-1),
	(225729,225728,135739,0,0,-1),
	(225733,225732,135719,0,0,-1),
	(225738,225737,135733,0,0,-1),
	(225742,225741,135722,0,0,-1),
	(225746,225745,135716,0,0,-1),
	(225752,225751,135739,0,0,-1),
	(225756,225755,135719,0,0,-1),
	(225761,225760,135733,0,0,-1),
	(225765,225764,135723,0,0,-1),
	(225769,225768,135716,0,0,-1),
	(225775,225774,135739,0,0,-1),
	(225779,225778,135719,0,0,-1),
	(225781,225780,135733,0,0,-1),
	(225785,225784,135732,0,0,-1),
	(225789,225788,135728,0,0,-1),
	(225792,225791,135716,0,0,-1),
	(225798,225797,135719,0,0,-1),
	(225803,225802,135722,0,0,-1),
	(225807,225806,135732,0,0,-1),
	(225811,225810,135724,0,0,-1),
	(225814,225813,135716,0,0,-1),
	(225820,225819,135719,0,0,-1),
	(225825,225824,135722,0,0,-1),
	(225829,225828,135723,0,0,-1),
	(225833,225832,135717,0,0,-1),
	(225837,225836,135727,0,0,-1),
	(225842,225841,135733,0,0,-1),
	(225844,225843,135721,0,0,-1),
	(225847,225846,135728,0,0,-1),
	(226168,226167,135715,0,0,-1),
	(226172,226171,135721,0,0,-1),
	(226177,226176,135729,0,0,-1),
	(226181,226180,135720,0,0,-1),
	(226185,226184,135731,0,0,-1),
	(237789,237788,135753,0,0,0),
	(237791,237790,135761,0,0,0),
	(237793,237792,135773,0,0,0),
	(237795,237794,135762,0,0,0),
	(237797,237796,135774,0,0,0),
	(237800,237799,135753,0,0,0),
	(237802,237801,135761,0,0,0),
	(237804,237803,135773,0,0,0),
	(237806,237805,135762,0,0,0),
	(237808,237807,135765,0,0,0),
	(237811,237810,135758,0,0,0),
	(237813,237812,135763,0,0,0),
	(237815,237814,135773,0,0,0),
	(237817,237816,135762,0,0,0),
	(237819,237818,135757,0,0,0),
	(237822,237821,135755,0,0,0),
	(237824,237823,135760,0,0,0),
	(237826,237825,135758,0,0,0),
	(237828,237827,135769,0,0,0),
	(237830,237829,135763,0,0,0),
	(237833,237832,135755,0,0,0),
	(237835,237834,135760,0,0,0),
	(237837,237836,135758,0,0,0),
	(237839,237838,135769,0,0,0),
	(237841,237840,135763,0,0,0),
	(237844,237843,135755,0,0,0),
	(237846,237845,135760,0,0,0),
	(237848,237847,135758,0,0,0),
	(237850,237849,135769,0,0,0),
	(237852,237851,135763,0,0,0),
	(237855,237854,135760,0,0,0),
	(237857,237856,135771,0,0,0),
	(237859,237858,135764,0,0,0),
	(237861,237860,135758,0,0,0),
	(237863,237862,135761,0,0,0),
	(237865,237864,135754,0,0,0),
	(237868,237867,135760,0,0,0),
	(237870,237869,135755,0,0,0),
	(237872,237871,135764,0,0,0),
	(237874,237873,135758,0,0,0),
	(237876,237875,135761,0,0,0),
	(237879,237878,135760,0,0,0),
	(237881,237880,135771,0,0,0),
	(237883,237882,135764,0,0,0),
	(237885,237884,135758,0,0,0),
	(237887,237886,135763,0,0,0),
	(237890,237889,135760,0,0,0),
	(237892,237891,135771,0,0,0),
	(237894,237893,135757,0,0,0),
	(237896,237895,135758,0,0,0),
	(237898,237897,135763,0,0,0),
	(237901,237900,135755,0,0,0),
	(237903,237902,135761,0,0,0),
	(237905,237904,135772,0,0,0),
	(237907,237906,135773,0,0,0),
	(237909,237908,135775,0,0,0),
	(237912,237911,135761,0,0,0),
	(237914,237913,135763,0,0,0),
	(237916,237915,135765,0,0,0),
	(237918,237917,135770,0,0,0),
	(237920,237919,135766,0,0,0),
	(237922,237921,135754,0,0,0),
	(237925,237924,135774,0,0,0),
	(237927,237926,135766,0,0,0),
	(237929,237928,135767,0,0,0),
	(237931,237930,135770,0,0,0),
	(237933,237932,135771,0,0,0),
	(237936,237935,135755,0,0,0),
	(237938,237937,135768,0,0,0),
	(237940,237939,135760,0,0,0),
	(237942,237941,135758,0,0,0),
	(237944,237943,135763,0,0,0),
	(237947,237946,135755,0,0,0),
	(237949,237948,135768,0,0,0),
	(237951,237950,135760,0,0,0),
	(237953,237952,135758,0,0,0),
	(237955,237954,135765,0,0,0),
	(237958,237957,135755,0,0,0),
	(237960,237959,135768,0,0,0),
	(237962,237961,135760,0,0,0),
	(237964,237963,135758,0,0,0),
	(237966,237965,135775,0,0,0),
	(237969,237968,135772,0,0,0),
	(237971,237970,135755,0,0,0),
	(237973,237972,135760,0,0,0),
	(237975,237974,135763,0,0,0),
	(237977,237976,135775,0,0,0),
	(237980,237979,135766,0,0,0),
	(237982,237981,135755,0,0,0),
	(237984,237983,135760,0,0,0),
	(237986,237985,135763,0,0,0),
	(237988,237987,135765,0,0,0),
	(237991,237990,135757,0,0,0),
	(237993,237992,135771,0,0,0),
	(237995,237994,135758,0,0,0),
	(237997,237996,135761,0,0,0),
	(237999,237998,135772,0,0,0);

insert into `crse_credit_format` values
	(243,'arrangeHours','Arrange Hours','AH'),
	(244,'fixedUnit','Fixed Unit',NULL),
	(245,'variableMinMax','Variable Min/Max',NULL),
	(246,'variableRange','Variable Range',NULL);

insert into `curriculum` values
	(238619,'A/M3','The Woebegon\'s Only Academic Area / Major 3',142,231383),
	(238634,'A/M2','The Woebegon\'s Only Academic Area / Major 2',142,231383),
	(238654,'A/M1','The Woebegon\'s Only Academic Area / Major 1',142,231383);

insert into `curriculum_clasf` values
	(238620,238619,'02',62,2,1,NULL),
	(238627,238619,'01',61,2,0,NULL),
	(238635,238634,'02',62,2,1,NULL),
	(238644,238634,'01',61,4,0,NULL),
	(238655,238654,'01',61,5,0,NULL),
	(238665,238654,'02',62,4,1,NULL);

insert into `curriculum_course` values
	(238621,135762,238620,1,3),
	(238622,135761,238620,1,2),
	(238623,135753,238620,1,1),
	(238624,135765,238620,0.5,0),
	(238625,135774,238620,0.5,5),
	(238626,135773,238620,1,4),
	(238628,135768,238627,1,3),
	(238629,135758,238627,1,1),
	(238630,135760,238627,1,2),
	(238631,135765,238627,0.5,4),
	(238632,135755,238627,1,0),
	(238633,135775,238627,0.5,5),
	(238636,135763,238635,0.5,3),
	(238637,135771,238635,0.5,1),
	(238638,135773,238635,0.5,7),
	(238639,135761,238635,0.5,2),
	(238640,135757,238635,1,4),
	(238641,135758,238635,1,0),
	(238642,135762,238635,0.5,5),
	(238643,135772,238635,0.5,6),
	(238645,135761,238644,0.5,4),
	(238646,135754,238644,0.25,7),
	(238647,135755,238644,0.25,8),
	(238648,135757,238644,0.25,6),
	(238649,135760,238644,1,1),
	(238650,135763,238644,0.5,5),
	(238651,135758,238644,1,0),
	(238652,135764,238644,0.75,3),
	(238653,135771,238644,0.75,2),
	(238656,135775,238655,0.2,8),
	(238657,135760,238655,1,2),
	(238658,135772,238655,0.2,7),
	(238659,135755,238655,1,0),
	(238660,135758,238655,0.6,3),
	(238661,135765,238655,0.2,6),
	(238662,135763,238655,1,1),
	(238663,135769,238655,0.6,4),
	(238664,135766,238655,0.2,5),
	(238666,135773,238665,0.25,14),
	(238667,135760,238665,0.25,2),
	(238668,135770,238665,0.5,9),
	(238669,135761,238665,0.5,8),
	(238670,135754,238665,0.25,10),
	(238671,135766,238665,0.5,4),
	(238672,135774,238665,0.25,15),
	(238673,135772,238665,0.25,6),
	(238674,135767,238665,0.25,11),
	(238675,135758,238665,0.25,3),
	(238676,135765,238665,0.25,5),
	(238677,135768,238665,0.25,12),
	(238678,135763,238665,0.5,1),
	(238679,135775,238665,0.25,7),
	(238680,135771,238665,0.25,13),
	(238681,135755,238665,0.5,0);

insert into `curriculum_major` values
	(238654,1201),
	(238634,1204),
	(238619,1205);

insert into `date_pattern` values
	(49,'Full Term','111111011111100111110111111011111101111110111111000111101111110111111011111101111110111111011000001111110111111',0,0,1,223206),
	(51,'Week 2-15','11111100111110111111011111101111110111111000111101111110111111011111101111110111111011000001111110111111',-7,2,1,223206),
	(52,'Week 1-10','111111011111100111110111111011111101111110111111000111101111110111111011',0,0,1,223206),
	(53,'Week 6-15','1111110111111000111101111110111111011111101111110111111011000001111110111111',-35,0,1,223206),
	(54,'Week 1-8','1111110111111001111101111110111111011111101111110001111011',0,0,1,223206),
	(55,'Week 9-15','11110111111011111101111110111111011000001111110111111',-58,0,1,223206),
	(56,'Week 1-5','1111110111111001111101111110111111',0,0,1,223206),
	(57,'Week 6-10','1111110111111000111101111110111111011',-35,0,1,223206),
	(58,'Week 11-15','111101111110111111011000001111110111111',-72,0,1,223206),
	(59,'Odd Wks','111111000000000111110000000011111100000000111111000000000011110110000000111101100000001111011000000000000111111',0,1,1,223206),
	(60,'Even Wks','1111110000000011111100000000111111000000000011110110000000111101100000001111011000000000000111111',-7,1,1,223206),
	(61,'Week 1','1111111',0,2,1,223206),
	(62,'Week 2','1111111',-7,2,1,223206),
	(63,'Week 3','111111',-15,2,1,223206),
	(64,'Week 4','1111111',-21,2,1,223206),
	(65,'Week 5','1111111',-28,2,1,223206),
	(66,'Week 6','1111111',-35,2,1,223206),
	(67,'Week 7','1111111',-42,2,1,223206),
	(68,'Week 8','1111111',-51,2,1,223206),
	(69,'Week 9','1111111',-58,2,1,223206),
	(70,'Week 10','1111111',-65,2,1,223206),
	(71,'Week 11','1111111',-72,2,1,223206),
	(72,'Week 12','1111111',-79,2,1,223206),
	(73,'Week 13','1111111',-86,2,1,223206),
	(74,'Week 14','1111111',-98,2,1,223206),
	(75,'Week 15','1111111',-105,2,1,223206),
	(369,'Week -1','1111111',7,2,1,223206),
	(853,'Full Term','111111011111100111110111111011111101111110111111000111101111110111111011111101111110111111011000001111110111111',0,0,1,231379),
	(854,'Week 1-10','111111011111100111110111111011111101111110111111000111101111110111111011',0,0,1,231379),
	(855,'Week 6-15','1111110111111000111101111110111111011111101111110111111011000001111110111111',-35,0,1,231379),
	(856,'Week 1-8','1111110111111001111101111110111111011111101111110001111011',0,0,1,231379),
	(857,'Week 9-15','11110111111011111101111110111111011000001111110111111',-58,0,1,231379),
	(858,'Week 1-5','1111110111111001111101111110111111',0,0,1,231379),
	(859,'Week 6-10','1111110111111000111101111110111111011',-35,0,1,231379),
	(860,'Week 11-15','111101111110111111011000001111110111111',-72,0,1,231379),
	(861,'Odd Wks','111111000000000111110000000011111100000000111111000000000011110110000000111101100000001111011000000000000111111',0,1,1,231379),
	(862,'Even Wks','1111110000000011111100000000111111000000000011110110000000111101100000001111011000000000000111111',-7,1,1,231379),
	(863,'Week -1','1111111',7,2,1,231379),
	(864,'Week 1','1111111',0,2,1,231379),
	(865,'Week 2','1111111',-7,2,1,231379),
	(866,'Week 2-15','11111100111110111111011111101111110111111000111101111110111111011111101111110111111011000001111110111111',-7,2,1,231379),
	(867,'Week 3','111111',-15,2,1,231379),
	(868,'Week 4','1111111',-21,2,1,231379),
	(869,'Week 5','1111111',-28,2,1,231379),
	(870,'Week 6','1111111',-35,2,1,231379),
	(871,'Week 7','1111111',-42,2,1,231379),
	(872,'Week 8','1111111',-51,2,1,231379),
	(873,'Week 9','1111111',-58,2,1,231379),
	(874,'Week 10','1111111',-65,2,1,231379),
	(875,'Week 11','1111111',-72,2,1,231379),
	(876,'Week 12','1111111',-79,2,1,231379),
	(877,'Week 13','1111111',-86,2,1,231379),
	(878,'Week 14','1111111',-98,2,1,231379),
	(879,'Week 15','1111111',-105,2,1,231379);

insert into `department` values
	(223207,223206,'Instr','Student Instructional Planning','0101','Woebegon Dept 0101','f032f0',0,NULL,NULL,344,NULL,0,0,0,NULL,0,1),
	(226199,223206,'Centr','Central Office','0100',NULL,'32f0f0',1,'Large Lecture Room','LLR',345,271,-1,0,0,NULL,0,1),
	(226216,223206,'Adm','Admission Office','0102',NULL,'f032f0',0,NULL,NULL,NULL,NULL,0,0,0,NULL,0,1),
	(231382,231379,'Centr','Central Office','0100',NULL,'f032f0',1,'Large Lecture Room','LLR',365,NULL,-1,0,0,NULL,0,1),
	(231383,231379,'Instr','Student Instructional Planning','0101','Woebegon Dept 0101','32f0f0',0,NULL,NULL,366,NULL,0,0,0,NULL,0,1),
	(231384,231379,'Adm','Admission Office','0102',NULL,NULL,0,NULL,NULL,NULL,NULL,0,0,0,NULL,0,1);

insert into `departmental_instructor` values
	(226238,'102',NULL,'SMITH','JOHN','WILLIAM',1,NULL,223207,0,NULL,NULL,NULL),
	(226240,'101',NULL,'NEWMAN','GEORGE',NULL,2,NULL,223207,0,NULL,NULL,NULL),
	(226242,'100',NULL,'DOE','JOE',NULL,6,NULL,223207,0,NULL,NULL,NULL),
	(226244,NULL,NULL,'STUDENT','JOHN',NULL,11,NULL,223207,0,NULL,NULL,NULL),
	(226246,NULL,NULL,'STUDENT','STEVEN',NULL,19,NULL,223207,0,NULL,NULL,NULL),
	(231385,'102',NULL,'SMITH','JOHN','WILLIAM',1,NULL,231383,0,NULL,NULL,NULL),
	(231386,NULL,NULL,'STUDENT','STEVEN',NULL,19,NULL,231383,0,NULL,NULL,NULL),
	(231387,NULL,NULL,'STUDENT','JOHN',NULL,11,NULL,231383,0,NULL,NULL,NULL),
	(231388,'100',NULL,'DOE','JOE',NULL,6,NULL,231383,0,NULL,NULL,NULL),
	(231389,'101',NULL,'NEWMAN','GEORGE',NULL,2,NULL,231383,0,NULL,NULL,NULL);

insert into `dept_status_type` values
	(265,'initial','Initial Data Load',0,1,0),
	(266,'input','Input Data Entry',1721,1,1),
	(267,'timetabling','Timetabling',4025,1,2),
	(268,'publish','Timetable Published',61961,1,4),
	(269,'finished','Session Finished',521,1,5),
	(270,'dept_input','External Mgr. Input Data Entry',135,2,7),
	(271,'dept_timetabling','External Mgr. Timetabling',423,2,8),
	(272,'dept_publish','External Mgr. Timetable Published',1,2,10),
	(325,'dept_readonly','Department Read Only',9,2,11),
	(326,'dept_edit','Department Allow Edit',441,2,12),
	(385,'dept_readonly_ni','External Mgr. Timetabling (No Instructor Assignments)',391,2,9),
	(414,'exams','Examination Timetabling',3593,1,3),
	(445,'demo','Demo (All Enabled)',65535,1,6);

insert into `dept_to_tt_mgr` values
	(473,223207),
	(510,223207),
	(470,226199),
	(472,226199),
	(510,226199),
	(471,226216),
	(510,226216),
	(470,231382),
	(472,231382),
	(510,231382),
	(473,231383),
	(510,231383),
	(530,231383),
	(471,231384),
	(510,231384);

insert into `distribution_object` values
	(5732,121720,1,230634,NULL),
	(5733,121720,2,230623,NULL),
	(5734,121721,1,230684,NULL),
	(5735,121721,2,230687,NULL),
	(5736,121722,3,230620,NULL),
	(5737,121722,2,230617,NULL),
	(5738,121722,1,230614,NULL),
	(5739,121723,2,230604,NULL),
	(5740,121723,1,230597,NULL),
	(5752,123392,1,231698,NULL),
	(5753,123392,2,231733,NULL),
	(5754,123394,2,231736,NULL),
	(5755,123394,1,231727,NULL),
	(5756,123394,3,231688,NULL),
	(5757,123395,1,231722,NULL),
	(5758,123395,2,231702,NULL),
	(5759,123396,2,231694,NULL),
	(5760,123396,1,231690,NULL);

insert into `distribution_pref` values
	(121720,223206,2,407,-1,NULL,NULL),
	(121721,223206,1,406,-1,NULL,NULL),
	(121722,223206,7,405,-1,NULL,NULL),
	(121723,223206,1,406,-1,NULL,NULL),
	(123392,231379,1,406,-1,NULL,NULL),
	(123393,231379,7,405,-1,NULL,NULL),
	(123394,231379,7,405,-1,NULL,NULL),
	(123395,231379,2,407,-1,NULL,NULL),
	(123396,231379,1,406,-1,NULL,NULL);

insert into `distribution_type` values
	(61,'BTB','Back-To-Back & Same Room','0',1,'P43210R','Classes must be offered in adjacent time segments and must be placed in the same room. Given classes must also be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes cannot be back-to-back. There must be at least half-hour between these classes, and they must be taught on the same days and in the same room.','BTB Same Room',1,0),
	(62,'BTB_TIME','Back-To-Back','0',2,'P43210R','Classes must be offered in adjacent time segments but may be placed in different rooms. Given classes must also be taught on the same days.<BR>When prohibited or (strongly) discouraged: no pair of classes can be taught back-to-back. They may not overlap in time, but must be taught on the same days. This means that there must be at least half-hour between these classes. ','BTB',1,0),
	(63,'SAME_TIME','Same Time','0',3,'P43210R','Given classes must be taught at the same time of day (independent of the actual day the classes meet). For the classes of the same length, this is the same constraint as <i>same start</i>. For classes of different length, the shorter one cannot start before, nor end after, the longer one.<BR>When prohibited or (strongly) discouraged: one class may not meet on any day at a time of day that overlaps with that of the other. For example, one class can not meet M 7:30 while the other meets F 7:30. Note the difference here from the <i>different time</i> constraint that only prohibits the actual class meetings from overlapping.','Same Time',0,0),
	(64,'SAME_DAYS','Same Days','0',4,'P43210R','Given classes must be taught on the same days. In case of classes of different time patterns, a class with fewer meetings must meet on a subset of the days used by the class with more meetings. For example, if one class pattern is 3x50, all others given in the constraint can only be taught on Monday, Wednesday, or Friday. For a 2x100 class MW, MF, WF is allowed but TTh is prohibited.<BR>When prohibited or (strongly) discouraged: any pair of classes classes cannot be taught on the same days (cannot overlap in days). For instance, if one class is MFW, the second has to be TTh.','Same Days',1,0),
	(65,'NHB(1)','1 Hour Between','0',5,'P43210R','Given classes must have exactly 1 hour in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 1 hour in between. They may not overlap in time but must be taught on the same days.','1h Btw',0,0),
	(66,'NHB(2)','2 Hours Between','0',6,'P43210R','Given classes must have exactly 2 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 2 hours in between. They may not overlap in time but must be taught on the same days.','2h Btw',0,0),
	(67,'NHB(3)','3 Hours Between','0',7,'P43210R','Given classes must have exactly 3 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 3 hours in between. They may not overlap in time but must be taught on the same days.','3h Btw',0,0),
	(68,'NHB(4)','4 Hours Between','0',8,'P43210R','Given classes must have exactly 4 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 4 hours in between. They may not overlap in time but must be taught on the same days.','4h Btw',0,0),
	(69,'NHB(5)','5 Hours Between','0',9,'P43210R','Given classes must have exactly 5 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 5 hours in between. They may not overlap in time but must be taught on the same days.','5h Btw',0,0),
	(70,'NHB(6)','6 Hours Between','0',10,'P43210R','Given classes must have exactly 6 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 6 hours in between. They may not overlap in time but must be taught on the same days.','6h Btw',0,0),
	(71,'NHB(7)','7 Hours Between','0',11,'P43210R','Given classes must have exactly 7 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 7 hours in between. They may not overlap in time but must be taught on the same days.','7h Btw',0,0),
	(72,'NHB(8)','8 Hours Between','0',12,'P43210R','Given classes must have exactly 8 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 8 hours in between. They may not overlap in time but must be taught on the same days.','8h Btw',0,0),
	(73,'DIFF_TIME','Different Time','0',13,'P43210R','Given classes cannot overlap in time. They may be taught at the same time of day if they are on different days. For instance, MF 7:30 is compatible with TTh 7:30.<BR>When prohibited or (strongly) discouraged: every pair of classes in the constraint must overlap in time.','Diff Time',0,0),
	(74,'NHB(1.5)','90 Minutes Between','0',14,'P43210R','Given classes must have exactly 90 minutes in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 90 minutes in between. They may not overlap in time but must be taught on the same days.','90min Btw',0,0),
	(75,'NHB(4.5)','4.5 Hours Between','0',15,'P43210R','Given classes must have exactly 4.5 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 4.5 hours in between. They may not overlap in time but must be taught on the same days.','4.5h Btw',0,0),
	(101,'SAME_ROOM','Same Room','0',17,'P43210R','Given classes must be taught in the same room.<BR>When prohibited or (strongly) discouraged: any pair of classes in the constraint cannot be taught in the same room.','Same Room',1,0),
	(102,'NHB_GTE(1)','At Least 1 Hour Between','0',18,'P43210R','Given classes have to have 1 hour or more in between.<BR>When prohibited or (strongly) discouraged: given classes have to have less than 1 hour in between.','>=1h Btw',1,0),
	(103,'SAME_START','Same Start Time','0',16,'P43210R','Given classes must start during the same half-hour period of a day (independent of the actual day the classes meet). For instance, MW 7:30 is compatible with TTh 7:30 but not with MWF 8:00.<BR>When prohibited or (strongly) discouraged: any pair of classes in the given constraint cannot start during the same half-hour period of any day of the week.','Same Start',0,0),
	(104,'NHB_LT(6)','Less Than 6 Hours Between','0',19,'P43210R','Given classes must have less than 6 hours from end of first class to the beginning of the next.  Given classes must also be taught on the same days.<BR>When prohibited or (strongly) discouraged: given classes must have 6 or more hours between. This constraint does not carry over from classes taught at the end of one day to the beginning of the next.','<6h Btw',1,0),
	(161,'SAME_STUDENTS','Same Students','0',20,'210R','Given classes are treated as they are attended by the same students, i.e., they cannot overlap in time and if they are back-to-back the assigned rooms cannot be too far (student limit is used).','Same Students',0,0),
	(162,'SAME_INSTR','Same Instructor','0',21,'210R','Given classes are treated as they are taught by the same instructor, i.e., they cannot overlap in time and if they are back-to-back the assigned rooms cannot be too far (instructor limit is used).<BR>If the constraint is required and the classes are back-to-back, discouraged and strongly discouraged distances between assigned rooms are also considered.','Same Instr',0,0),
	(163,'CAN_SHARE_ROOM','Can Share Room','0',22,'2R','Given classes can share the room (use the room in the same time) if the room is big enough.','Share Room',0,0),
	(164,'SPREAD','Spread In Time','0',23,'2R','Given classes have to be spread in time (overlapping of the classes in time needs to be minimized).','Time Spread',0,0),
	(165,'PRECEDENCE','Precedence','1',24,'P43210R','Given classes have to be taught in the given order (the first meeting of the first class has to end before the first meeting of the second class etc.)<BR>When prohibited or (strongly) discouraged: classes have to be taught in the order reverse to the given one','Precede',0,0),
	(185,'MIN_ROOM_USE','Minimize Number Of Rooms Used','0',25,'P43210R','Minimize number of rooms used by the given set of classes.','Min Rooms',1,0),
	(205,'BTB_DAY','Back-To-Back Day','0',26,'P43210R','Classes must be offered on adjacent days and may be placed in different rooms.<BR>When prohibited or (strongly) discouraged: classes can not be taught on adjacent days. They also can not be taught on the same days. This means that there must be at least one day between these classes.','BTB Day',0,0),
	(206,'MIN_GRUSE(10x1h)','Minimize Use Of 1h Groups','0',27,'P43210R','Minimize number of groups of time that are used by the given classes. The time is spread into the following 10 groups of one hour: 7:30a-8:30a, 8:30a-9:30a, 9:30a-10:30a, ... 4:30p-5:30p.','Min 1h Groups',0,0),
	(207,'MIN_GRUSE(5x2h)','Minimize Use Of 2h Groups','0',28,'P43210R','Minimize number of groups of time that are used by the given classes. The time is spread into the following 5 groups of two hours: 7:30a-9:30a, 9:30a-11:30a, 11:30a-1:30p, 1:30p-3:30p, 3:30p-5:30p.','Min 2h Groups',0,0),
	(208,'MIN_GRUSE(3x3h)','Minimize Use Of 3h Groups','0',29,'P43210R','Minimize number of groups of time that are used by the given classes. The time is spread into the following 3 groups: 7:30a-10:30a, 10:30a-2:30p, 2:30p-5:30p.','Min 3h Groups',0,0),
	(209,'MIN_GRUSE(2x5h)','Minimize Use Of 5h Groups','0',30,'P43210R','Minimize number of groups of time that are used by the given classes. The time is spread into the following 2 groups: 7:30a-12:30a, 12:30a-5:30p.','Min 5h Groups',0,0),
	(305,'NDB_GT_1','More Than 1 Day Between','0',32,'P43210R','Given classes must have two or more days in between.<br>When prohibited or (strongly) discouraged: given classes must be offered on adjacent days or with at most one day in between.','>1d Btw',0,0),
	(345,'CH_NOTOVERLAP','Children Cannot Overlap','0',33,'210R','If parent classes do not overlap in time, children classes can not overlap in time as well.<br>Note: This constraint only needs to be put on the parent classes. Preferred configurations are Required All Classes or Pairwise (Strongly) Preferred.','Ch No Ovlap',0,0),
	(365,'FOLLOWING_DAY','Next Day','1',34,'P43210R','The second class has to be placed on the following day of the first class (if the first class is on Friday, second class have to be on Monday).<br> When prohibited or (strongly) discouraged: The second class has to be placed on the previous day of the first class (if the first class is on Monday, second class have to be on Friday).<br> Note: This constraint works only between pairs of classes.','Next Day',0,0),
	(366,'EVERY_OTHER_DAY','Two Days After','1',35,'P43210R','The second class has to be placed two days after the first class (Monday &rarr; Wednesday, Tuesday &rarr; Thurday, Wednesday &rarr; Friday, Thursday &rarr; Monday, Friday &rarr; Tuesday).<br> When prohibited or (strongly) discouraged: The second class has to be placed two days before the first class (Monday &rarr; Thursday, Tuesday &rarr; Friday, Wednesday &rarr; Monday, Thursday &rarr; Tuesday, Friday &rarr; Wednesday).<br> Note: This constraint works only between pairs of classes.','2d After',0,0),
	(367,'MEET_WITH','Meet Together','0',31,'2R','Given classes are meeting together (same as if the given classes require constraints Can Share Room, Same Room, Same Time and Same Days all together).','Meet Together',0,0),
	(405,'EX_SAME_PER','Same Period','0',36,'P43210R','Exams are to be placed at the same period. <BR>When prohibited or (strongly) discouraged: exams are to be placed at different periods.','Same Per',0,1),
	(406,'EX_SAME_ROOM','Same Room','0',37,'P43210R','Exams are to be placed at the same room(s). <BR>When prohibited or (strongly) discouraged: exams are to be placed at different rooms.','Same Room',0,1),
	(407,'EX_PRECEDENCE','Precedence','1',38,'P43210R','Exams are to be placed in the given order. <BR>When prohibited or (strongly) discouraged: exams are to be placed in the order reverse to the given one.','Precede',0,1),
	(1179612,'MAX_HRS_DAY(6)','At Most 6 Hours A Day','0',39,'210R','Classes are to be placed in a way that there is no more than six hours in any day.','At Most 6 Hrs',1,0),
	(1179613,'MAX_HRS_DAY(7)','At Most 7 Hours A Day','0',40,'210R','Classes are to be placed in a way that there is no more than seven hours in any day.','At Most 7 Hrs',1,0),
	(1179614,'MAX_HRS_DAY(8)','At Most 8 Hours A Day','0',41,'210R','Classes are to be placed in a way that there is no more than eight hours in any day.','At Most 8 Hrs',1,0),
	(1277913,'LINKED_SECTIONS','Linked Classes','0',42,'R','Classes (of different courses) are to be attended by the same students. For instance, if class A1 (of a course A) and class B1 (of a course B) are linked, a student requesting both courses must attend A1 if and only if he also attends B1. This is a student sectioning constraint that is interpreted as Same Students constraint during course timetabling.','Linked',0,0),
	(1376214,'MAX_HRS_DAY(5)','At Most 5 Hours A Day','0',43,'210R','Classes are to be placed in a way that there is no more than five hours in any day.','At Most 5 Hrs',1,0),
	(1376215,'BTB_PRECEDENCE','Back-To-Back Precedence','0',44,'P43210R','Given classes have to be taught in the given order, on the same days, and in adjacent time segments.<br>When prohibited or (strongly) discouraged: Given classes have to be taught in the given order, on the same days, but cannot be back-to-back.','BTB Precede',0,0),
	(1376216,'SAME_D_T','Same Days-Time','0',45,'P43210R','Given classes must be taught at the same time of day and on the same days.<br>This constraint combines Same Days and Same Time distribution preferences.<br>When prohibited or (strongly) discouraged: Any pair of classes classes cannot be taught on the same days during the same time.','Same Days-Time',0,0),
	(1376217,'SAME_D_R_T','Same Days-Room-Time','0',46,'P43210R','Given classes must be taught at the same time of day, on the same days and in the same room.<br>Note that this constraint is the same as Meet Together constraint, except it does not allow for room sharing. In other words, it is only useful when these classes are taught during non-overlapping date patterns.<br>When prohibited or (strongly) discouraged: Any pair of classes classes cannot be taught on the same days during the same time in the same room.','Same Days-Room-Time',0,0),
	(1376218,'SAME_WEEKS','Same Weeks','0',47,'P43210R','Given classes must be taught during the same weeks (i.e., must have the same date pattern).<br>When prohibited or (strongly) discouraged: any two classes must have non overlapping date patterns.','Same Weeks',0,0),
	(1474515,'EX_SHARE_ROOM','Can Share Room','0',48,'2R','Given examinations can share a room (use the same room during the same period) if the room is big enough.  If examinations of different seating type are sharing a room, the more restrictive seating type is used to check the room size.','Share Room',0,1),
	(1572816,'NO_CONFLICT','Ignore Student Conflicts','0',49,'2R','All student conflicts between the given classes are to be ignored.','No Conflicts',0,0);

insert into `event` values
	(226646,'BIOL 101 Pso 3',4,4,NULL,226645,223973,NULL,0,NULL,NULL,NULL,NULL),
	(226663,'BIOL 101 Lec 3',4,4,NULL,226645,223900,NULL,0,NULL,NULL,NULL,NULL),
	(226695,'BIOL 101 Lec 2',4,4,NULL,226645,223899,NULL,0,NULL,NULL,NULL,NULL),
	(226727,'BIOL 101 Pso 2',4,4,NULL,226645,223927,NULL,0,NULL,NULL,NULL,NULL),
	(226744,'CALC 101 Lec 2',4,4,NULL,226645,223956,NULL,0,NULL,NULL,NULL,NULL),
	(226790,'BIOL 101 Pso 1',4,4,NULL,226645,223926,NULL,0,NULL,NULL,NULL,NULL),
	(226807,'CALC 101 Lec 1',4,4,NULL,226645,223869,NULL,0,NULL,NULL,NULL,NULL),
	(226853,'CHM 101 Lec 1',4,4,NULL,226645,223256,NULL,0,NULL,NULL,NULL,NULL),
	(226885,'CALC 101 Lec 3',4,4,NULL,226645,223957,NULL,0,NULL,NULL,NULL,NULL),
	(226931,'CHM 101 Lec 2',4,4,NULL,226645,223257,NULL,0,NULL,NULL,NULL,NULL),
	(226962,'BIOL 101 Lec 1',4,4,NULL,226645,223240,NULL,0,NULL,NULL,NULL,NULL),
	(226994,'PHAR 101 Lec 1',4,4,NULL,226645,224022,NULL,0,NULL,NULL,NULL,NULL),
	(227010,'BAND 101 Lec 1',4,4,NULL,226645,223249,NULL,0,NULL,NULL,NULL,NULL),
	(227086,'CHM 101 Lec 3',4,4,NULL,226645,223258,NULL,0,NULL,NULL,NULL,NULL),
	(227117,'MBIO 101 Lec 1',3,3,NULL,226645,224057,NULL,0,NULL,NULL,NULL,NULL),
	(227149,'PSY 101 Lec 1',4,4,NULL,226645,223363,NULL,0,NULL,NULL,NULL,NULL),
	(227195,'ECON 101 Lec 1',4,4,NULL,226645,223291,NULL,0,NULL,NULL,NULL,NULL),
	(227227,'ENGL 101 Lec 7',1,1,NULL,226645,223316,NULL,0,NULL,NULL,NULL,NULL),
	(227273,'ENGL 101 Lec 8',1,1,NULL,226645,223317,NULL,0,NULL,NULL,NULL,NULL),
	(227319,'BIOL 101 Rec 8',1,1,NULL,226645,223909,NULL,0,NULL,NULL,NULL,NULL),
	(227336,'ENGL 101 Lec 9',1,1,NULL,226645,223318,NULL,0,NULL,NULL,NULL,NULL),
	(227382,'BIOL 101 Rec 7',1,1,NULL,226645,223908,NULL,0,NULL,NULL,NULL,NULL),
	(227398,'ENGL 101 Lec 10',1,1,NULL,226645,223319,NULL,0,NULL,NULL,NULL,NULL),
	(227444,'BIOL 101 Rec 6',1,1,NULL,226645,223907,NULL,0,NULL,NULL,NULL,NULL),
	(227461,'BIOL 101 Rec 5',1,1,NULL,226645,223906,NULL,0,NULL,NULL,NULL,NULL),
	(227478,'BIOL 101 Rec 4',1,1,NULL,226645,223905,NULL,0,NULL,NULL,NULL,NULL),
	(227495,'BIOL 101 Rec 3',1,1,NULL,226645,223904,NULL,0,NULL,NULL,NULL,NULL),
	(227512,'ENGL 101 Lec 6',1,1,NULL,226645,223315,NULL,0,NULL,NULL,NULL,NULL),
	(227558,'BIOL 101 Rec 2',1,1,NULL,226645,223903,NULL,0,NULL,NULL,NULL,NULL),
	(227575,'BIOL 101 Rec 1',1,1,NULL,226645,223902,NULL,0,NULL,NULL,NULL,NULL),
	(227592,'ENGL 101 Lec 5',1,1,NULL,226645,223314,NULL,0,NULL,NULL,NULL,NULL),
	(227638,'ENGL 101 Lec 4',1,1,NULL,226645,223313,NULL,0,NULL,NULL,NULL,NULL),
	(227684,'ENGL 101 Lec 1',1,1,NULL,226645,223310,NULL,0,NULL,NULL,NULL,NULL),
	(227730,'ENGL 101 Lec 3',1,1,NULL,226645,223312,NULL,0,NULL,NULL,NULL,NULL),
	(227776,'ENGL 101 Lec 2',1,1,NULL,226645,223311,NULL,0,NULL,NULL,NULL,NULL),
	(227822,'BIOL 101 Lab 7',1,1,NULL,226645,223920,NULL,0,NULL,NULL,NULL,NULL),
	(227839,'BIOL 101 Lab 4',1,1,NULL,226645,223917,NULL,0,NULL,NULL,NULL,NULL),
	(227856,'BIOL 101 Lab 3',1,1,NULL,226645,223916,NULL,0,NULL,NULL,NULL,NULL),
	(227873,'BIOL 101 Lab 6',1,1,NULL,226645,223919,NULL,0,NULL,NULL,NULL,NULL),
	(227890,'BIOL 101 Lab 5',1,1,NULL,226645,223918,NULL,0,NULL,NULL,NULL,NULL),
	(227907,'BIOL 101 Rec 11',1,1,NULL,226645,223977,NULL,0,NULL,NULL,NULL,NULL),
	(227924,'BIOL 101 Rec 10',1,1,NULL,226645,223976,NULL,0,NULL,NULL,NULL,NULL),
	(227941,'BIOL 101 Lab 2',1,1,NULL,226645,223915,NULL,0,NULL,NULL,NULL,NULL),
	(227958,'BIOL 101 Lab 1',1,1,NULL,226645,223914,NULL,0,NULL,NULL,NULL,NULL),
	(227975,'BIOL 101 Rec 9',1,1,NULL,226645,223910,NULL,0,NULL,NULL,NULL,NULL),
	(227992,'ALG 101 Lec 1',2,2,NULL,226645,223884,NULL,0,NULL,NULL,NULL,NULL),
	(228038,'ENGL 101 Lab 5',1,1,NULL,226645,223855,NULL,0,NULL,NULL,NULL,NULL),
	(228055,'ENGL 101 Lab 4',1,1,NULL,226645,223854,NULL,0,NULL,NULL,NULL,NULL),
	(228072,'ENGL 101 Lab 3',1,1,NULL,226645,223853,NULL,0,NULL,NULL,NULL,NULL),
	(228089,'ENGL 101 Lab 2',1,1,NULL,226645,223852,NULL,0,NULL,NULL,NULL,NULL),
	(228106,'ENGL 101 Lab 1',1,1,NULL,226645,223851,NULL,0,NULL,NULL,NULL,NULL),
	(228123,'C S 101 Lab 1',1,1,NULL,226645,223949,NULL,0,NULL,NULL,NULL,NULL),
	(228140,'C S 101 Lec 2',2,2,NULL,226645,223947,NULL,0,NULL,NULL,NULL,NULL),
	(228171,'C S 101 Lec 1',2,2,NULL,226645,223245,NULL,0,NULL,NULL,NULL,NULL),
	(228202,'BIOL 101 Lab 9',1,1,NULL,226645,223922,NULL,0,NULL,NULL,NULL,NULL),
	(228219,'BIOL 101 Lab 8',1,1,NULL,226645,223921,NULL,0,NULL,NULL,NULL,NULL),
	(228236,'BIOL 101 Lab 11',1,1,NULL,226645,223979,NULL,0,NULL,NULL,NULL,NULL),
	(228253,'BIOL 101 Lab 10',1,1,NULL,226645,223978,NULL,0,NULL,NULL,NULL,NULL),
	(228270,'CALC 101 Rec 3',1,1,NULL,226645,223959,NULL,0,NULL,NULL,NULL,NULL),
	(228287,'CALC 101 Rec 2',1,1,NULL,226645,223958,NULL,0,NULL,NULL,NULL,NULL),
	(228304,'CALC 101 Rec 4',1,1,NULL,226645,223960,NULL,0,NULL,NULL,NULL,NULL),
	(228321,'C S 101 Lab 2',1,1,NULL,226645,223950,NULL,0,NULL,NULL,NULL,NULL),
	(228338,'C S 101 Lab 4',1,1,NULL,226645,223970,NULL,0,NULL,NULL,NULL,NULL),
	(228355,'C S 101 Lab 3',1,1,NULL,226645,223951,NULL,0,NULL,NULL,NULL,NULL),
	(228372,'CALC 101 Rec 1',1,1,NULL,226645,223870,NULL,0,NULL,NULL,NULL,NULL),
	(228389,'CALC 101 Rec 11',1,1,NULL,226645,223967,NULL,0,NULL,NULL,NULL,NULL),
	(228406,'CALC 101 Rec 12',1,1,NULL,226645,223968,NULL,0,NULL,NULL,NULL,NULL),
	(228423,'CALC 101 Rec 9',1,1,NULL,226645,223965,NULL,0,NULL,NULL,NULL,NULL),
	(228440,'CALC 101 Rec 10',1,1,NULL,226645,223966,NULL,0,NULL,NULL,NULL,NULL),
	(228457,'CALC 101 Rec 7',1,1,NULL,226645,223963,NULL,0,NULL,NULL,NULL,NULL),
	(228474,'CALC 101 Rec 8',1,1,NULL,226645,223964,NULL,0,NULL,NULL,NULL,NULL),
	(228491,'CALC 101 Rec 5',1,1,NULL,226645,223961,NULL,0,NULL,NULL,NULL,NULL),
	(228508,'CALC 101 Rec 6',1,1,NULL,226645,223962,NULL,0,NULL,NULL,NULL,NULL),
	(228525,'PHYS 101 Lab 4',1,1,NULL,226645,224041,NULL,0,NULL,NULL,NULL,NULL),
	(228541,'PHYS 101 Lab 5',1,1,NULL,226645,224042,NULL,0,NULL,NULL,NULL,NULL),
	(228558,'PHYS 101 Lab 2',1,1,NULL,226645,224039,NULL,0,NULL,NULL,NULL,NULL),
	(228575,'PHYS 101 Lab 3',1,1,NULL,226645,224040,NULL,0,NULL,NULL,NULL,NULL),
	(228591,'PHYS 101 Rec 5',1,1,NULL,226645,224036,NULL,0,NULL,NULL,NULL,NULL),
	(228608,'PHYS 101 Lab 1',1,1,NULL,226645,224038,NULL,0,NULL,NULL,NULL,NULL),
	(228625,'SOC 101 Lec 1',2,2,NULL,226645,223373,NULL,0,NULL,NULL,NULL,NULL),
	(228671,'POL 101 Lec 1',2,2,NULL,226645,223356,NULL,0,NULL,NULL,NULL,NULL),
	(228717,'POL 101 Lec 2',2,2,NULL,226645,224028,NULL,0,NULL,NULL,NULL,NULL),
	(228763,'CHM 101 Lab 5',1,1,NULL,226645,223264,NULL,0,NULL,NULL,NULL,NULL),
	(228780,'CHM 101 Lab 6',1,1,NULL,226645,223265,NULL,0,NULL,NULL,NULL,NULL),
	(228797,'CHM 101 Lab 7',1,1,NULL,226645,223267,NULL,0,NULL,NULL,NULL,NULL),
	(228814,'CHM 101 Lab 8',1,1,NULL,226645,223268,NULL,0,NULL,NULL,NULL,NULL),
	(228831,'CHM 101 Lab 1',1,1,NULL,226645,223259,NULL,0,NULL,NULL,NULL,NULL),
	(228848,'CHM 101 Lab 2',1,1,NULL,226645,223260,NULL,0,NULL,NULL,NULL,NULL),
	(228865,'CHM 101 Lab 3',1,1,NULL,226645,223261,NULL,0,NULL,NULL,NULL,NULL),
	(228882,'CHM 101 Lab 4',1,1,NULL,226645,223263,NULL,0,NULL,NULL,NULL,NULL),
	(228899,'CHM 101 Lab 9',1,1,NULL,226645,223269,NULL,0,NULL,NULL,NULL,NULL),
	(228916,'MBIO 101 Lab 3',1,1,NULL,226645,224061,NULL,0,NULL,NULL,NULL,NULL),
	(228932,'PHIL 101 Lec 1',2,2,NULL,226645,223344,NULL,0,NULL,NULL,NULL,NULL),
	(228964,'PHYS 101 Lec 1',3,3,NULL,226645,223350,NULL,0,NULL,NULL,NULL,NULL),
	(228996,'MBIO 101 Lab 2',1,1,NULL,226645,224060,NULL,0,NULL,NULL,NULL,NULL),
	(229012,'PHYS 101 Rec 4',1,1,NULL,226645,224035,NULL,0,NULL,NULL,NULL,NULL),
	(229029,'CHM 101 Lab 11',1,1,NULL,226645,223818,NULL,0,NULL,NULL,NULL,NULL),
	(229046,'CHM 101 Lab 10',1,1,NULL,226645,223817,NULL,0,NULL,NULL,NULL,NULL),
	(229063,'PHYS 101 Lec 2',2,2,NULL,226645,223351,NULL,0,NULL,NULL,NULL,NULL),
	(229094,'PHYS 101 Rec 1',1,1,NULL,226645,224032,NULL,0,NULL,NULL,NULL,NULL),
	(229110,'PHYS 101 Rec 2',1,1,NULL,226645,224033,NULL,0,NULL,NULL,NULL,NULL),
	(229127,'PHYS 101 Rec 3',1,1,NULL,226645,224034,NULL,0,NULL,NULL,NULL,NULL),
	(229144,'CHM 101 Rec 2',1,1,NULL,226645,223825,NULL,0,NULL,NULL,NULL,NULL),
	(229161,'CHM 101 Rec 3',1,1,NULL,226645,223826,NULL,0,NULL,NULL,NULL,NULL),
	(229178,'CHM 101 Lab 12',1,1,NULL,226645,223819,NULL,0,NULL,NULL,NULL,NULL),
	(229195,'CHM 101 Rec 1',1,1,NULL,226645,223824,NULL,0,NULL,NULL,NULL,NULL),
	(229212,'CHM 101 Rec 6',1,1,NULL,226645,223829,NULL,0,NULL,NULL,NULL,NULL),
	(229229,'CHM 101 Rec 7',1,1,NULL,226645,223830,NULL,0,NULL,NULL,NULL,NULL),
	(229246,'CHM 101 Rec 4',1,1,NULL,226645,223827,NULL,0,NULL,NULL,NULL,NULL),
	(229263,'CHM 101 Rec 5',1,1,NULL,226645,223828,NULL,0,NULL,NULL,NULL,NULL),
	(229280,'GER 101 Lab 2',1,1,NULL,226645,224006,NULL,0,NULL,NULL,NULL,NULL),
	(229297,'GER 101 Lab 3',1,1,NULL,226645,224007,NULL,0,NULL,NULL,NULL,NULL),
	(229313,'GER 101 Lec 2',2,2,NULL,226645,223325,NULL,0,NULL,NULL,NULL,NULL),
	(229359,'GER 101 Lab 1',1,1,NULL,226645,224005,NULL,0,NULL,NULL,NULL,NULL),
	(229375,'MBIO 101 Lab 1',1,1,NULL,226645,224059,NULL,0,NULL,NULL,NULL,NULL),
	(229391,'HIST 101 Lec 2',2,2,NULL,226645,223331,NULL,0,NULL,NULL,NULL,NULL),
	(229437,'CHM 101 Rec 10',1,1,NULL,226645,223833,NULL,0,NULL,NULL,NULL,NULL),
	(229453,'LING 101 Lec 1',2,2,NULL,226645,224017,NULL,0,NULL,NULL,NULL,NULL),
	(229499,'CHM 101 Rec 9',1,1,NULL,226645,223832,NULL,0,NULL,NULL,NULL,NULL),
	(229516,'GER 101 Lab 4',1,1,NULL,226645,224008,NULL,0,NULL,NULL,NULL,NULL),
	(229533,'CHM 101 Rec 8',1,1,NULL,226645,223831,NULL,0,NULL,NULL,NULL,NULL),
	(229550,'HIST 101 Lec 1',2,2,NULL,226645,223330,NULL,0,NULL,NULL,NULL,NULL),
	(229582,'CHM 101 Rec 11',1,1,NULL,226645,223834,NULL,0,NULL,NULL,NULL,NULL),
	(229599,'CHM 101 Rec 12',1,1,NULL,226645,223835,NULL,0,NULL,NULL,NULL,NULL),
	(229615,'COM 101 Lec 1',1,1,NULL,226645,223297,NULL,0,NULL,NULL,NULL,NULL),
	(229647,'COM 101 Lec 2',1,1,NULL,226645,223298,NULL,0,NULL,NULL,NULL,NULL),
	(229679,'COM 101 Lec 3',1,1,NULL,226645,223299,NULL,0,NULL,NULL,NULL,NULL),
	(229711,'COM 101 Lec 4',1,1,NULL,226645,223300,NULL,0,NULL,NULL,NULL,NULL),
	(229743,'COM 101 Lec 5',1,1,NULL,226645,223301,NULL,0,NULL,NULL,NULL,NULL),
	(229775,'SOC 101 Lec 2',2,2,NULL,226645,224050,NULL,0,NULL,NULL,NULL,NULL),
	(229821,'ENGL 101 Lab 6',1,1,NULL,226645,223856,NULL,0,NULL,NULL,NULL,NULL),
	(229838,'SPAN 101 Lec 1',2,2,NULL,226645,223378,NULL,0,NULL,NULL,NULL,NULL),
	(229870,'ENGL 101 Lab 7',1,1,NULL,226645,223857,NULL,0,NULL,NULL,NULL,NULL),
	(229887,'SPAN 101 Lec 2',2,2,NULL,226645,223379,NULL,0,NULL,NULL,NULL,NULL),
	(229933,'ENGL 101 Lab 8',1,1,NULL,226645,223858,NULL,0,NULL,NULL,NULL,NULL),
	(229950,'SPAN 101 Lab 1',1,1,NULL,226645,223800,NULL,0,NULL,NULL,NULL,NULL),
	(229967,'SPAN 101 Lab 2',1,1,NULL,226645,223801,NULL,0,NULL,NULL,NULL,NULL),
	(229984,'SPAN 101 Lab 3',1,1,NULL,226645,223802,NULL,0,NULL,NULL,NULL,NULL),
	(230001,'SPAN 101 Lab 4',1,1,NULL,226645,223803,NULL,0,NULL,NULL,NULL,NULL),
	(230018,'ENGR 101 Lab 2',1,1,NULL,226645,223999,NULL,0,NULL,NULL,NULL,NULL),
	(230034,'ENGR 101 Lab 3',1,1,NULL,226645,224000,NULL,0,NULL,NULL,NULL,NULL),
	(230051,'GER 101 Lec 1',2,2,NULL,226645,223324,NULL,0,NULL,NULL,NULL,NULL),
	(230097,'COM 101 Lec 7',1,1,NULL,226645,223303,NULL,0,NULL,NULL,NULL,NULL),
	(230129,'ENGL 101 Lab 9',1,1,NULL,226645,223859,NULL,0,NULL,NULL,NULL,NULL),
	(230146,'COM 101 Lec 6',1,1,NULL,226645,223302,NULL,0,NULL,NULL,NULL,NULL),
	(230178,'ENGL 101 Lab 10',1,1,NULL,226645,223860,NULL,0,NULL,NULL,NULL,NULL),
	(230195,'COM 101 Lec 9',1,1,NULL,226645,223305,NULL,0,NULL,NULL,NULL,NULL),
	(230227,'ENGR 101 Lec 1',3,3,NULL,226645,223996,NULL,0,NULL,NULL,NULL,NULL),
	(230259,'COM 101 Lec 8',1,1,NULL,226645,223304,NULL,0,NULL,NULL,NULL,NULL),
	(230291,'ENGR 101 Lab 1',1,1,NULL,226645,223998,NULL,0,NULL,NULL,NULL,NULL),
	(231209,'ALG 101',2,2,NULL,230841,NULL,230331,1,NULL,NULL,NULL,NULL),
	(231211,'BAND 101',3,3,NULL,230841,NULL,230335,1,NULL,NULL,NULL,NULL),
	(231213,'BIOL 101 Lec 1',3,3,NULL,230841,NULL,230338,1,NULL,NULL,NULL,NULL),
	(231216,'BIOL 101 Lec 3',3,3,NULL,230841,NULL,230342,1,NULL,NULL,NULL,NULL),
	(231219,'BIOL 101 Lec 2',4,4,NULL,230841,NULL,230584,1,NULL,NULL,NULL,NULL),
	(231222,'C S 101',4,4,NULL,230841,NULL,230597,1,NULL,NULL,NULL,NULL),
	(231224,'CALC 101 Lec 1, 2',8,8,NULL,230841,NULL,230604,1,NULL,NULL,NULL,NULL),
	(231227,'CALC 101 Lec 3',4,4,NULL,230841,NULL,230611,1,NULL,NULL,NULL,NULL),
	(231229,'CHM 101 Lec 1',4,4,NULL,230841,NULL,230614,1,NULL,NULL,NULL,NULL),
	(231231,'CHM 101 Lec 2',4,4,NULL,230841,NULL,230617,1,NULL,NULL,NULL,NULL),
	(231233,'CHM 101 Lec 3',4,4,NULL,230841,NULL,230620,1,NULL,NULL,NULL,NULL),
	(231235,'COM 101 Lec 3, 4, 5, 6',4,4,NULL,230841,NULL,230623,1,NULL,NULL,NULL,NULL),
	(231238,'COM 101 Lec 1, 2, 7, 8',4,4,NULL,230841,NULL,230634,1,NULL,NULL,NULL,NULL),
	(231241,'ECON 101',4,4,NULL,230841,NULL,230650,1,NULL,NULL,NULL,NULL),
	(231243,'ENGL 101',10,10,NULL,230841,NULL,230653,1,NULL,NULL,NULL,NULL),
	(231247,'POL 101 Lec 1',2,2,NULL,230841,NULL,230684,1,NULL,NULL,NULL,NULL),
	(231249,'PHIL 101 Lec 1; SOC 101 Lec 1',3,3,NULL,230841,NULL,230670,1,NULL,NULL,NULL,NULL),
	(231251,'SOC 101 Lec 2',1,1,NULL,230841,NULL,230678,1,NULL,NULL,NULL,NULL),
	(231253,'PSY 101',4,4,NULL,230841,NULL,230681,1,NULL,NULL,NULL,NULL),
	(231255,'POL 101 Lec 2',2,2,NULL,230841,NULL,230687,1,NULL,NULL,NULL,NULL),
	(231257,'ENGR 101 Lec 1',3,3,NULL,230841,NULL,230690,1,NULL,NULL,NULL,NULL),
	(231259,'GER 101 Lec 1; SPAN 101 Lec 2',3,3,NULL,230841,NULL,230693,1,NULL,NULL,NULL,NULL),
	(231261,'GER 101 Lec 2; SPAN 101 Lec 1',4,4,NULL,230841,NULL,230697,1,NULL,NULL,NULL,NULL),
	(231263,'MBIO 101 Lec 1',3,3,NULL,230841,NULL,230701,1,NULL,NULL,NULL,NULL),
	(231265,'PHYS 101 Lec 1',3,3,NULL,230841,NULL,230704,1,NULL,NULL,NULL,NULL),
	(231267,'PHYS 101 Lec 2',2,2,NULL,230841,NULL,230707,1,NULL,NULL,NULL,NULL),
	(231315,'Performances',NULL,NULL,NULL,231314,NULL,NULL,4,NULL,NULL,NULL,NULL),
	(231343,'ALG 101',2,2,NULL,226645,NULL,231055,2,NULL,NULL,NULL,NULL),
	(231345,'ALG 101',2,2,NULL,226645,NULL,231058,2,NULL,NULL,NULL,NULL),
	(231347,'ALG 101',2,2,NULL,226645,NULL,231061,2,NULL,NULL,NULL,NULL),
	(231349,'ENGL 101',10,10,NULL,226645,NULL,231070,2,NULL,NULL,NULL,NULL),
	(231352,'ENGL 101',10,10,NULL,226645,NULL,231073,2,NULL,NULL,NULL,NULL),
	(231355,'BIOL 101',11,11,NULL,226645,NULL,231095,2,NULL,NULL,NULL,NULL),
	(231359,'SOC 101; SPAN 101',8,8,NULL,226645,NULL,231086,2,NULL,NULL,NULL,NULL),
	(231361,'SOC 101; SPAN 101',8,8,NULL,226645,NULL,231090,2,NULL,NULL,NULL,NULL),
	(231363,'CALC 101',12,12,NULL,226645,NULL,231098,2,NULL,NULL,NULL,NULL),
	(231367,'CALC 101',12,12,NULL,226645,NULL,231101,2,NULL,NULL,NULL,NULL),
	(233325,'CHM 101 Lab 4',1,1,NULL,226645,231468,NULL,0,NULL,NULL,NULL,NULL),
	(233341,'CHM 101 Lab 5',1,1,NULL,226645,231460,NULL,0,NULL,NULL,NULL,NULL),
	(233357,'CHM 101 Lab 2',1,1,NULL,226645,231466,NULL,0,NULL,NULL,NULL,NULL),
	(233373,'CHM 101 Lab 3',1,1,NULL,226645,231467,NULL,0,NULL,NULL,NULL,NULL),
	(233389,'CHM 101 Lab 8',1,1,NULL,226645,231465,NULL,0,NULL,NULL,NULL,NULL),
	(233405,'CHM 101 Lab 9',1,1,NULL,226645,231464,NULL,0,NULL,NULL,NULL,NULL),
	(233421,'CHM 101 Lab 6',1,1,NULL,226645,231462,NULL,0,NULL,NULL,NULL,NULL),
	(233437,'CHM 101 Lab 7',1,1,NULL,226645,231463,NULL,0,NULL,NULL,NULL,NULL),
	(233453,'CHM 101 Lab 12',1,1,NULL,226645,231471,NULL,0,NULL,NULL,NULL,NULL),
	(233469,'CHM 101 Rec 1',1,1,NULL,226645,231480,NULL,0,NULL,NULL,NULL,NULL),
	(233485,'CHM 101 Lab 10',1,1,NULL,226645,231469,NULL,0,NULL,NULL,NULL,NULL),
	(233501,'CHM 101 Lab 11',1,1,NULL,226645,231470,NULL,0,NULL,NULL,NULL,NULL),
	(233517,'CHM 101 Rec 4',1,1,NULL,226645,231479,NULL,0,NULL,NULL,NULL,NULL),
	(233532,'CHM 101 Rec 5',1,1,NULL,226645,231483,NULL,0,NULL,NULL,NULL,NULL),
	(233548,'CHM 101 Rec 2',1,1,NULL,226645,231477,NULL,0,NULL,NULL,NULL,NULL),
	(233564,'CHM 101 Rec 3',1,1,NULL,226645,231484,NULL,0,NULL,NULL,NULL,NULL),
	(233580,'CALC 101 Rec 4',1,1,NULL,226645,231451,NULL,0,NULL,NULL,NULL,NULL),
	(233596,'CALC 101 Rec 3',1,1,NULL,226645,231449,NULL,0,NULL,NULL,NULL,NULL),
	(233612,'CALC 101 Rec 2',1,1,NULL,226645,231445,NULL,0,NULL,NULL,NULL,NULL),
	(233627,'CALC 101 Rec 1',1,1,NULL,226645,231441,NULL,0,NULL,NULL,NULL,NULL),
	(233643,'CALC 101 Rec 8',1,1,NULL,226645,231452,NULL,0,NULL,NULL,NULL,NULL),
	(233659,'CALC 101 Rec 7',1,1,NULL,226645,231448,NULL,0,NULL,NULL,NULL,NULL),
	(233675,'CALC 101 Rec 6',1,1,NULL,226645,231446,NULL,0,NULL,NULL,NULL,NULL),
	(233691,'CALC 101 Rec 5',1,1,NULL,226645,231443,NULL,0,NULL,NULL,NULL,NULL),
	(233707,'CALC 101 Rec 12',1,1,NULL,226645,231450,NULL,0,NULL,NULL,NULL,NULL),
	(233723,'CALC 101 Rec 11',1,1,NULL,226645,231447,NULL,0,NULL,NULL,NULL,NULL),
	(233739,'CALC 101 Rec 10',1,1,NULL,226645,231444,NULL,0,NULL,NULL,NULL,NULL),
	(233755,'CALC 101 Rec 9',1,1,NULL,226645,231442,NULL,0,NULL,NULL,NULL,NULL),
	(233771,'CHM 101 Lab 1',1,1,NULL,226645,231461,NULL,0,NULL,NULL,NULL,NULL),
	(233787,'BIOL 101 Lab 8',1,1,NULL,226645,231406,NULL,0,NULL,NULL,NULL,NULL),
	(233803,'BIOL 101 Lab 9',1,1,NULL,226645,231407,NULL,0,NULL,NULL,NULL,NULL),
	(233819,'BIOL 101 Lab 10',1,1,NULL,226645,231408,NULL,0,NULL,NULL,NULL,NULL),
	(233835,'BIOL 101 Lab 11',1,1,NULL,226645,231409,NULL,0,NULL,NULL,NULL,NULL),
	(233851,'C S 101 Lec 1',2,2,NULL,226645,231434,NULL,0,NULL,NULL,NULL,NULL),
	(233881,'C S 101 Lec 2',2,2,NULL,226645,231435,NULL,0,NULL,NULL,NULL,NULL),
	(233911,'C S 101 Lab 1',1,1,NULL,226645,231429,NULL,0,NULL,NULL,NULL,NULL),
	(233927,'C S 101 Lab 2',1,1,NULL,226645,231430,NULL,0,NULL,NULL,NULL,NULL),
	(233943,'C S 101 Lab 3',1,1,NULL,226645,231431,NULL,0,NULL,NULL,NULL,NULL),
	(233959,'C S 101 Lab 4',1,1,NULL,226645,231432,NULL,0,NULL,NULL,NULL,NULL),
	(233974,'BIOL 101 Rec 4',1,1,NULL,226645,231414,NULL,0,NULL,NULL,NULL,NULL),
	(233989,'BIOL 101 Rec 3',1,1,NULL,226645,231413,NULL,0,NULL,NULL,NULL,NULL),
	(234005,'BIOL 101 Rec 6',1,1,NULL,226645,231416,NULL,0,NULL,NULL,NULL,NULL),
	(234021,'BIOL 101 Rec 5',1,1,NULL,226645,231415,NULL,0,NULL,NULL,NULL,NULL),
	(234037,'BIOL 101 Rec 8',1,1,NULL,226645,231418,NULL,0,NULL,NULL,NULL,NULL),
	(234053,'BIOL 101 Rec 7',1,1,NULL,226645,231417,NULL,0,NULL,NULL,NULL,NULL),
	(234069,'BIOL 101 Rec 10',1,1,NULL,226645,231420,NULL,0,NULL,NULL,NULL,NULL),
	(234085,'BIOL 101 Rec 9',1,1,NULL,226645,231419,NULL,0,NULL,NULL,NULL,NULL),
	(234101,'BIOL 101 Lab 1',1,1,NULL,226645,231399,NULL,0,NULL,NULL,NULL,NULL),
	(234117,'BIOL 101 Rec 11',1,1,NULL,226645,231421,NULL,0,NULL,NULL,NULL,NULL),
	(234133,'BIOL 101 Lab 3',1,1,NULL,226645,231401,NULL,0,NULL,NULL,NULL,NULL),
	(234149,'BIOL 101 Lab 2',1,1,NULL,226645,231400,NULL,0,NULL,NULL,NULL,NULL),
	(234165,'BIOL 101 Lab 5',1,1,NULL,226645,231403,NULL,0,NULL,NULL,NULL,NULL),
	(234181,'BIOL 101 Lab 4',1,1,NULL,226645,231402,NULL,0,NULL,NULL,NULL,NULL),
	(234197,'BIOL 101 Lab 7',1,1,NULL,226645,231405,NULL,0,NULL,NULL,NULL,NULL),
	(234213,'BIOL 101 Lab 6',1,1,NULL,226645,231404,NULL,0,NULL,NULL,NULL,NULL),
	(234229,'PHIL 101 Lec 1',2,2,NULL,226645,231547,NULL,0,NULL,NULL,NULL,NULL),
	(234274,'MBIO 101 Lab 2',1,1,NULL,226645,231542,NULL,0,NULL,NULL,NULL,NULL),
	(234289,'MBIO 101 Lab 3',1,1,NULL,226645,231543,NULL,0,NULL,NULL,NULL,NULL),
	(234304,'MBIO 101 Lab 1',1,1,NULL,226645,231541,NULL,0,NULL,NULL,NULL,NULL),
	(234319,'HIST 101 Lec 2',2,2,NULL,226645,231535,NULL,0,NULL,NULL,NULL,NULL),
	(234364,'LING 101 Lec 1',2,2,NULL,226645,231537,NULL,0,NULL,NULL,NULL,NULL),
	(234409,'PHYS 101 Rec 5',1,1,NULL,226645,231555,NULL,0,NULL,NULL,NULL,NULL),
	(234424,'PHYS 101 Lab 1',1,1,NULL,226645,231560,NULL,0,NULL,NULL,NULL,NULL),
	(234440,'PHYS 101 Rec 3',1,1,NULL,226645,231552,NULL,0,NULL,NULL,NULL,NULL),
	(234456,'PHYS 101 Rec 4',1,1,NULL,226645,231554,NULL,0,NULL,NULL,NULL,NULL),
	(234471,'PHYS 101 Rec 1',1,1,NULL,226645,231553,NULL,0,NULL,NULL,NULL,NULL),
	(234487,'PHYS 101 Rec 2',1,1,NULL,226645,231556,NULL,0,NULL,NULL,NULL,NULL),
	(234503,'PHYS 101 Lec 1',2,2,NULL,226645,231549,NULL,0,NULL,NULL,NULL,NULL),
	(234534,'PHYS 101 Lec 2',3,3,NULL,226645,231550,NULL,0,NULL,NULL,NULL,NULL),
	(234565,'ENGR 101 Lab 2',1,1,NULL,226645,231521,NULL,0,NULL,NULL,NULL,NULL),
	(234580,'ENGR 101 Lab 1',1,1,NULL,226645,231520,NULL,0,NULL,NULL,NULL,NULL),
	(234596,'ENGR 101 Lec 1',3,3,NULL,226645,231524,NULL,0,NULL,NULL,NULL,NULL),
	(234627,'ENGL 101 Lab 10',1,1,NULL,226645,231517,NULL,0,NULL,NULL,NULL,NULL),
	(234643,'ENGL 101 Lab 9',1,1,NULL,226645,231514,NULL,0,NULL,NULL,NULL,NULL),
	(234659,'ENGL 101 Lab 8',1,1,NULL,226645,231510,NULL,0,NULL,NULL,NULL,NULL),
	(234675,'ENGL 101 Lab 7',1,1,NULL,226645,231509,NULL,0,NULL,NULL,NULL,NULL),
	(234691,'ENGL 101 Lab 6',1,1,NULL,226645,231513,NULL,0,NULL,NULL,NULL,NULL),
	(234706,'HIST 101 Lec 1',2,2,NULL,226645,231534,NULL,0,NULL,NULL,NULL,NULL),
	(234751,'GER 101 Lab 4',1,1,NULL,226645,231530,NULL,0,NULL,NULL,NULL,NULL),
	(234767,'GER 101 Lab 3',1,1,NULL,226645,231529,NULL,0,NULL,NULL,NULL,NULL),
	(234783,'GER 101 Lab 2',1,1,NULL,226645,231532,NULL,0,NULL,NULL,NULL,NULL),
	(234799,'GER 101 Lab 1',1,1,NULL,226645,231531,NULL,0,NULL,NULL,NULL,NULL),
	(234815,'GER 101 Lec 2',2,2,NULL,226645,231527,NULL,0,NULL,NULL,NULL,NULL),
	(234860,'GER 101 Lec 1',2,2,NULL,226645,231526,NULL,0,NULL,NULL,NULL,NULL),
	(234905,'ENGR 101 Lab 3',1,1,NULL,226645,231522,NULL,0,NULL,NULL,NULL,NULL),
	(234921,'ENGL 101 Lec 4',1,1,NULL,226645,231501,NULL,0,NULL,NULL,NULL,NULL),
	(234966,'ENGL 101 Lec 5',1,1,NULL,226645,231502,NULL,0,NULL,NULL,NULL,NULL),
	(235011,'ENGL 101 Lec 6',1,1,NULL,226645,231503,NULL,0,NULL,NULL,NULL,NULL),
	(235056,'ENGL 101 Lec 7',1,1,NULL,226645,231504,NULL,0,NULL,NULL,NULL,NULL),
	(235101,'ENGL 101 Lec 1',1,1,NULL,226645,231498,NULL,0,NULL,NULL,NULL,NULL),
	(235146,'ENGL 101 Lec 2',1,1,NULL,226645,231499,NULL,0,NULL,NULL,NULL,NULL),
	(235191,'ENGL 101 Lec 3',1,1,NULL,226645,231500,NULL,0,NULL,NULL,NULL,NULL),
	(235236,'ENGL 101 Lab 2',1,1,NULL,226645,231515,NULL,0,NULL,NULL,NULL,NULL),
	(235252,'ENGL 101 Lab 3',1,1,NULL,226645,231518,NULL,0,NULL,NULL,NULL,NULL),
	(235268,'ENGL 101 Lab 4',1,1,NULL,226645,231516,NULL,0,NULL,NULL,NULL,NULL),
	(235283,'ENGL 101 Lab 5',1,1,NULL,226645,231512,NULL,0,NULL,NULL,NULL,NULL),
	(235299,'ENGL 101 Lec 8',1,1,NULL,226645,231505,NULL,0,NULL,NULL,NULL,NULL),
	(235344,'ENGL 101 Lec 9',1,1,NULL,226645,231506,NULL,0,NULL,NULL,NULL,NULL),
	(235389,'ENGL 101 Lec 10',1,1,NULL,226645,231507,NULL,0,NULL,NULL,NULL,NULL),
	(235434,'ENGL 101 Lab 1',1,1,NULL,226645,231511,NULL,0,NULL,NULL,NULL,NULL),
	(235450,'CHM 101 Rec 11',1,1,NULL,226645,231481,NULL,0,NULL,NULL,NULL,NULL),
	(235465,'CHM 101 Rec 10',1,1,NULL,226645,231475,NULL,0,NULL,NULL,NULL,NULL),
	(235481,'COM 101 Lec 1',1,1,NULL,226645,231486,NULL,0,NULL,NULL,NULL,NULL),
	(235512,'CHM 101 Rec 12',1,1,NULL,226645,231482,NULL,0,NULL,NULL,NULL,NULL),
	(235528,'CHM 101 Rec 7',1,1,NULL,226645,231474,NULL,0,NULL,NULL,NULL,NULL),
	(235544,'CHM 101 Rec 6',1,1,NULL,226645,231473,NULL,0,NULL,NULL,NULL,NULL),
	(235560,'CHM 101 Rec 9',1,1,NULL,226645,231476,NULL,0,NULL,NULL,NULL,NULL),
	(235576,'CHM 101 Rec 8',1,1,NULL,226645,231478,NULL,0,NULL,NULL,NULL,NULL),
	(235592,'COM 101 Lec 7',1,1,NULL,226645,231492,NULL,0,NULL,NULL,NULL,NULL),
	(235623,'COM 101 Lec 6',1,1,NULL,226645,231491,NULL,0,NULL,NULL,NULL,NULL),
	(235654,'COM 101 Lec 9',1,1,NULL,226645,231494,NULL,0,NULL,NULL,NULL,NULL),
	(235685,'COM 101 Lec 8',1,1,NULL,226645,231493,NULL,0,NULL,NULL,NULL,NULL),
	(235716,'COM 101 Lec 3',1,1,NULL,226645,231488,NULL,0,NULL,NULL,NULL,NULL),
	(235747,'COM 101 Lec 2',1,1,NULL,226645,231487,NULL,0,NULL,NULL,NULL,NULL),
	(235778,'COM 101 Lec 5',1,1,NULL,226645,231490,NULL,0,NULL,NULL,NULL,NULL),
	(235809,'COM 101 Lec 4',1,1,NULL,226645,231489,NULL,0,NULL,NULL,NULL,NULL),
	(235840,'SPAN 101 Lec 2',2,2,NULL,226645,231573,NULL,0,NULL,NULL,NULL,NULL),
	(235871,'SPAN 101 Lab 1',1,1,NULL,226645,231577,NULL,0,NULL,NULL,NULL,NULL),
	(235887,'SOC 101 Lec 2',2,2,NULL,226645,231570,NULL,0,NULL,NULL,NULL,NULL),
	(235932,'SPAN 101 Lec 1',2,2,NULL,226645,231572,NULL,0,NULL,NULL,NULL,NULL),
	(235963,'SPAN 101 Lab 4',1,1,NULL,226645,231576,NULL,0,NULL,NULL,NULL,NULL),
	(235979,'SPAN 101 Lab 2',1,1,NULL,226645,231578,NULL,0,NULL,NULL,NULL,NULL),
	(235995,'SPAN 101 Lab 3',1,1,NULL,226645,231575,NULL,0,NULL,NULL,NULL,NULL),
	(236010,'PHYS 101 Lab 4',1,1,NULL,226645,231561,NULL,0,NULL,NULL,NULL,NULL),
	(236026,'PHYS 101 Lab 5',1,1,NULL,226645,231558,NULL,0,NULL,NULL,NULL,NULL),
	(236042,'PHYS 101 Lab 2',1,1,NULL,226645,231562,NULL,0,NULL,NULL,NULL,NULL),
	(236058,'PHYS 101 Lab 3',1,1,NULL,226645,231559,NULL,0,NULL,NULL,NULL,NULL),
	(236074,'SOC 101 Lec 1',2,2,NULL,226645,231569,NULL,0,NULL,NULL,NULL,NULL),
	(236119,'POL 101 Lec 1',2,2,NULL,226645,231564,NULL,0,NULL,NULL,NULL,NULL),
	(236150,'POL 101 Lec 2',2,2,NULL,226645,231565,NULL,0,NULL,NULL,NULL,NULL),
	(236181,'BIOL 101 Rec 2',1,1,NULL,226645,231412,NULL,0,NULL,NULL,NULL,NULL),
	(236197,'BIOL 101 Rec 1',1,1,NULL,226645,231411,NULL,0,NULL,NULL,NULL,NULL),
	(236212,'ALG 101 Lec 1',2,2,NULL,226645,231391,NULL,0,NULL,NULL,NULL,NULL),
	(236257,'PHAR 101 Lec 1',4,4,NULL,226645,231545,NULL,0,NULL,NULL,NULL,NULL),
	(236273,'BIOL 101 Lec 3',4,4,NULL,226645,231397,NULL,0,NULL,NULL,NULL,NULL),
	(236303,'BIOL 101 Lec 2',4,4,NULL,226645,231396,NULL,0,NULL,NULL,NULL,NULL),
	(236334,'MBIO 101 Lec 1',3,3,NULL,226645,231539,NULL,0,NULL,NULL,NULL,NULL),
	(236365,'ECON 101 Lec 1',4,4,NULL,226645,231496,NULL,0,NULL,NULL,NULL,NULL),
	(236410,'BIOL 101 Lec 1',4,4,NULL,226645,231395,NULL,0,NULL,NULL,NULL,NULL),
	(236440,'BIOL 101 Pso 1',4,4,NULL,226645,231423,NULL,0,NULL,NULL,NULL,NULL),
	(236456,'BAND 101 Lec 1',4,4,NULL,226645,231393,NULL,0,NULL,NULL,NULL,NULL),
	(236531,'BIOL 101 Pso 2',4,4,NULL,226645,231424,NULL,0,NULL,NULL,NULL,NULL),
	(236547,'BIOL 101 Pso 3',4,4,NULL,226645,231425,NULL,0,NULL,NULL,NULL,NULL),
	(236563,'PSY 101 Lec 1',4,4,NULL,226645,231567,NULL,0,NULL,NULL,NULL,NULL),
	(236608,'CALC 101 Lec 1',4,4,NULL,226645,231437,NULL,0,NULL,NULL,NULL,NULL),
	(236653,'CALC 101 Lec 2',4,4,NULL,226645,231438,NULL,0,NULL,NULL,NULL,NULL),
	(236698,'CALC 101 Lec 3',4,4,NULL,226645,231439,NULL,0,NULL,NULL,NULL,NULL),
	(236743,'CHM 101 Lec 3',4,4,NULL,226645,231458,NULL,0,NULL,NULL,NULL,NULL),
	(236774,'CHM 101 Lec 2',4,4,NULL,226645,231457,NULL,0,NULL,NULL,NULL,NULL),
	(236805,'CHM 101 Lec 1',4,4,NULL,226645,231456,NULL,0,NULL,NULL,NULL,NULL),
	(239012,'BIOL 101 ',4,4,NULL,226645,NULL,231676,1,NULL,NULL,NULL,NULL),
	(239014,'GER 101 Lec 2; SPAN 101 Lec 1',4,4,NULL,226645,NULL,231678,1,NULL,NULL,NULL,NULL),
	(239016,'BIOL 101 ',4,4,NULL,226645,NULL,231681,1,NULL,NULL,NULL,NULL),
	(239019,'ENGR 101 Lec 1',3,3,NULL,226645,NULL,231683,1,NULL,NULL,NULL,NULL),
	(239021,'GER 101 Lec 1; SPAN 101 Lec 2',3,3,NULL,226645,NULL,231685,1,NULL,NULL,NULL,NULL),
	(239023,'CHM 101 Lec 3',4,4,NULL,226645,NULL,231688,1,NULL,NULL,NULL,NULL),
	(239025,'POL 101 Lec 1',2,2,NULL,226645,NULL,231690,1,NULL,NULL,NULL,NULL),
	(239027,'ALG 101',2,2,NULL,226645,NULL,231692,1,NULL,NULL,NULL,NULL),
	(239029,'POL 101 Lec 2',1,1,NULL,226645,NULL,231694,1,NULL,NULL,NULL,NULL),
	(239031,'ECON 101',3,3,NULL,226645,NULL,231696,1,NULL,NULL,NULL,NULL),
	(239033,'C S 101',3,3,NULL,226645,NULL,231698,1,NULL,NULL,NULL,NULL),
	(239035,'BIOL 101 ',2,2,NULL,226645,NULL,231700,1,NULL,NULL,NULL,NULL),
	(239037,'COM 101 Lec 2, 4, 8, 9',2,2,NULL,226645,NULL,231702,1,NULL,NULL,NULL,NULL),
	(239039,'ENGL 101',10,10,NULL,226645,NULL,231707,1,NULL,NULL,NULL,NULL),
	(239043,'CALC 101 Lec 3',4,4,NULL,226645,NULL,231709,1,NULL,NULL,NULL,NULL),
	(239046,'MBIO 101 Lec 1',3,3,NULL,226645,NULL,231711,1,NULL,NULL,NULL,NULL),
	(239048,'BAND 101',2,2,NULL,226645,NULL,231713,1,NULL,NULL,NULL,NULL),
	(239050,'PHIL 101 Lec 1; SOC 101 Lec 2',3,3,NULL,226645,NULL,231715,1,NULL,NULL,NULL,NULL),
	(239052,'SOC 101 Lec 1',1,1,NULL,226645,NULL,231718,1,NULL,NULL,NULL,NULL),
	(239054,'PSY 101',4,4,NULL,226645,NULL,231720,1,NULL,NULL,NULL,NULL),
	(239056,'COM 101 Lec 1, 3, 6, 7',4,4,NULL,226645,NULL,231722,1,NULL,NULL,NULL,NULL),
	(239059,'CHM 101 Lec 1',4,4,NULL,226645,NULL,231727,1,NULL,NULL,NULL,NULL),
	(239061,'PHYS 101 Lec 2',3,3,NULL,226645,NULL,231729,1,NULL,NULL,NULL,NULL),
	(239063,'PHYS 101 Lec 1',2,2,NULL,226645,NULL,231731,1,NULL,NULL,NULL,NULL),
	(239065,'CALC 101 Lec 1, 2',8,8,NULL,226645,NULL,231733,1,NULL,NULL,NULL,NULL),
	(239068,'CHM 101 Lec 2',4,4,NULL,226645,NULL,231736,1,NULL,NULL,NULL,NULL),
	(239108,'ALG 101',2,2,NULL,226645,NULL,231654,2,NULL,NULL,NULL,NULL),
	(239110,'CALC 101',12,12,NULL,226645,NULL,231656,2,NULL,NULL,NULL,NULL),
	(239114,'SOC 101; SPAN 101',8,8,NULL,226645,NULL,231658,2,NULL,NULL,NULL,NULL),
	(239116,'ALG 101',2,2,NULL,226645,NULL,231661,2,NULL,NULL,NULL,NULL),
	(239118,'SOC 101; SPAN 101',8,8,NULL,226645,NULL,231663,2,NULL,NULL,NULL,NULL),
	(239120,'CALC 101',12,12,NULL,226645,NULL,231666,2,NULL,NULL,NULL,NULL),
	(239124,'ENGL 101',10,10,NULL,226645,NULL,231668,2,NULL,NULL,NULL,NULL),
	(239127,'ENGL 101',10,10,NULL,226645,NULL,231670,2,NULL,NULL,NULL,NULL),
	(239130,'BIOL 101',11,11,NULL,226645,NULL,231672,2,NULL,NULL,NULL,NULL),
	(239134,'ALG 101',2,2,NULL,226645,NULL,231674,2,NULL,NULL,NULL,NULL),
	(239136,'Performances',NULL,NULL,NULL,231314,NULL,NULL,4,NULL,NULL,NULL,NULL);

insert into `event_contact` values
	(226645,'1','test-admin@unitime.org','unknown','Abraham',NULL,'Root'),
	(230841,'5','demo-exam@unitime.org','unknown','Manager',NULL,'Exam'),
	(231314,'null','test-event@unitime.org',NULL,'Event',NULL,'Manager');

insert into `event_note` values
	(231316,231315,NULL,'2010-09-22 14:13:09',0,NULL,NULL,NULL,NULL,NULL,NULL),
	(239153,239136,NULL,'2010-09-22 17:10:14',0,'A. Root','M 08/23 - 09/20 8:00a THTR 101\nM 09/27 - 12/06 8:00a THTR 101',NULL,NULL,NULL,NULL),
	(239171,239136,NULL,'2010-09-22 17:10:19',2,'A. Root','M 08/23 - 09/20 8:00a THTR 101\nM 09/27 - 12/06 8:00a THTR 101',NULL,NULL,NULL,NULL);

insert into `exact_time_mins` values
	(214405,0,0,0,0),
	(214406,1,5,1,0),
	(214407,6,10,2,0),
	(214408,11,15,4,0),
	(214409,16,20,5,0),
	(214410,21,25,6,0),
	(214411,26,30,7,0),
	(214412,31,35,8,15),
	(214413,36,40,10,15),
	(214414,41,45,11,15),
	(214415,46,50,12,10),
	(214416,51,55,13,15),
	(214417,56,60,14,10),
	(214418,61,65,16,15),
	(214419,66,70,17,15),
	(214420,71,75,18,15),
	(214421,76,80,19,15),
	(214422,81,85,20,15),
	(214423,86,90,21,15),
	(214424,91,95,23,15),
	(214425,96,100,24,10),
	(214426,101,105,25,15),
	(214427,106,110,26,15),
	(214428,111,115,28,15),
	(214429,116,120,29,15),
	(214430,121,125,30,15),
	(214431,126,130,31,15),
	(214432,131,135,32,15),
	(214433,136,140,34,15),
	(214434,141,145,35,15),
	(214435,146,150,36,10),
	(214436,151,155,37,15),
	(214437,156,160,38,15),
	(214438,161,165,40,15),
	(214439,166,170,41,15),
	(214440,171,175,42,15),
	(214441,176,180,43,15),
	(214442,181,185,44,15),
	(214443,186,190,46,15),
	(214444,191,195,47,15),
	(214445,196,200,48,10),
	(214446,201,205,49,15),
	(214447,206,210,50,15),
	(214448,211,215,52,15),
	(214449,216,220,53,15),
	(214450,221,225,54,15),
	(214451,226,230,55,15),
	(214452,231,235,56,15),
	(214453,236,240,58,15),
	(214454,241,245,59,15),
	(214455,246,250,60,10),
	(214456,251,255,61,15),
	(214457,256,260,62,15),
	(214458,261,265,64,15),
	(214459,266,270,65,15),
	(214460,271,275,66,15),
	(214461,276,280,67,15),
	(214462,281,285,68,15),
	(214463,286,290,70,15),
	(214464,291,295,71,15),
	(214465,296,300,72,10),
	(214466,301,305,73,15),
	(214467,306,310,74,15),
	(214468,311,315,76,15),
	(214469,316,320,77,15),
	(214470,321,325,78,15),
	(214471,326,330,79,15),
	(214472,331,335,80,15),
	(214473,336,340,82,15),
	(214474,341,345,83,15),
	(214475,346,350,84,10),
	(214476,351,355,85,15),
	(214477,356,360,86,15),
	(214478,361,365,88,15),
	(214479,366,370,89,15),
	(214480,371,375,90,15),
	(214481,376,380,91,5),
	(214482,381,385,92,15),
	(214483,386,390,94,15),
	(214484,391,395,95,15),
	(214485,396,400,96,10),
	(214486,401,405,97,15),
	(214487,406,410,98,15),
	(214488,411,415,100,15),
	(214489,416,420,101,15),
	(214490,421,425,102,15),
	(214491,426,430,103,15),
	(214492,431,435,104,15),
	(214493,436,440,106,15),
	(214494,441,445,107,15),
	(214495,446,450,108,10),
	(214496,451,455,109,15),
	(214497,456,460,110,15),
	(214498,461,465,112,15),
	(214499,466,470,113,15),
	(214500,471,475,114,15),
	(214501,476,480,115,15),
	(214502,481,485,116,15),
	(214503,486,490,118,15),
	(214504,491,495,119,15),
	(214505,496,500,120,10),
	(214506,501,505,121,15),
	(214507,506,510,122,15),
	(214508,511,515,124,15),
	(214509,516,520,125,15),
	(214510,521,525,126,15),
	(214511,526,530,127,15),
	(214512,531,535,128,15),
	(214513,536,540,130,15),
	(214514,541,545,131,15),
	(214515,546,550,132,10),
	(214516,551,555,133,15),
	(214517,556,560,134,15),
	(214518,561,565,136,15),
	(214519,566,570,137,15),
	(214520,571,575,138,15),
	(214521,576,580,139,15),
	(214522,581,585,140,15),
	(214523,586,590,142,15),
	(214524,591,595,143,15),
	(214525,596,600,144,10),
	(214526,601,605,145,15),
	(214527,606,610,146,15),
	(214528,611,615,148,15),
	(214529,616,620,149,15),
	(214530,621,625,150,15),
	(214531,626,630,151,15),
	(214532,631,635,152,15),
	(214533,636,640,154,15),
	(214534,641,645,155,15),
	(214535,646,650,156,10),
	(214536,651,655,157,15),
	(214537,656,660,158,15),
	(214538,661,665,160,15),
	(214539,666,670,161,15),
	(214540,671,675,162,15),
	(214541,676,680,163,15),
	(214542,681,685,164,15),
	(214543,686,690,166,15),
	(214544,691,695,167,15),
	(214545,696,700,168,10),
	(214546,701,705,169,15),
	(214547,706,710,170,15),
	(214548,711,715,172,15),
	(214549,716,720,173,15);

insert into `exam` values
	(230331,223206,'ALG 101',NULL,120,2,1,226566,'0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230335,223206,'BAND 101',NULL,60,1,0,226562,'0:0:-4',NULL,NULL,NULL,NULL,1540049),
	(230338,223206,NULL,NULL,180,4,1,230774,'1:0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230342,223206,NULL,NULL,180,4,1,226564,'0:0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230584,223206,NULL,NULL,180,4,1,226564,'0:0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230597,223206,'C S 101',NULL,60,1,0,226568,'0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230604,223206,NULL,NULL,60,2,0,230772,'0:0:-4:0',NULL,NULL,NULL,NULL,1540049),
	(230611,223206,NULL,NULL,60,2,1,226562,'-2:0:0',NULL,NULL,NULL,NULL,1540049),
	(230614,223206,NULL,NULL,120,1,0,226570,'0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230617,223206,NULL,NULL,120,1,0,226566,'0:0:-4',NULL,NULL,NULL,NULL,1540049),
	(230620,223206,NULL,NULL,120,1,0,226560,'0:0:-4',NULL,NULL,NULL,NULL,1540049),
	(230623,223206,'COM 101 Lec 3, 4, 5, 6',NULL,60,2,1,226570,'0:2:-4:-4',NULL,NULL,NULL,NULL,1540049),
	(230634,223206,'COM 101 Lec 1, 2, 7, 8',NULL,60,2,1,226574,'0:2:-4:-4',NULL,NULL,NULL,NULL,1540049),
	(230650,223206,'ECON 101',NULL,120,1,0,230770,'2:0:0',NULL,NULL,NULL,NULL,1540049),
	(230653,223206,'ENGL 101',NULL,60,4,0,226576,'0:0:0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230670,223206,'PHIL 101 Lec 1; SOC 101 Lec 1',NULL,120,1,1,226560,'0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230678,223206,'SOC 101 Lec 2',NULL,120,1,1,226566,'0:0:-4',NULL,NULL,NULL,NULL,1540049),
	(230681,223206,'PSY 101',NULL,120,2,1,226564,'0:0:-100',NULL,NULL,NULL,NULL,1540049),
	(230684,223206,'POL 101 Lec 1',NULL,120,1,0,226560,'-2:0:0',NULL,NULL,NULL,NULL,1540049),
	(230687,223206,'POL 101 Lec 2',NULL,120,1,0,230774,'0:0:-4',NULL,NULL,NULL,NULL,1540049),
	(230690,223206,'ENGR 101 Lec 1',NULL,120,1,1,226570,'0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230693,223206,'GER 101 Lec 1; SPAN 101 Lec 2',NULL,60,1,1,230770,'2:0:0',NULL,NULL,NULL,NULL,1540049),
	(230697,223206,'GER 101 Lec 2; SPAN 101 Lec 1',NULL,60,1,1,226574,'2:0:0',NULL,NULL,NULL,NULL,1540049),
	(230701,223206,'MBIO 101 Lec 1',NULL,120,1,1,226566,'0:0:0',NULL,NULL,NULL,NULL,1540049),
	(230704,223206,'PHYS 101 Lec 1',NULL,120,1,1,230774,'1:0:0',NULL,NULL,NULL,NULL,1540049),
	(230707,223206,'PHYS 101 Lec 2',NULL,120,1,1,226574,'0:0:0',NULL,NULL,NULL,NULL,1540049),
	(231055,223206,'ALG 101',NULL,60,1,1,226583,'-2:0:-100',NULL,NULL,NULL,NULL,1540050),
	(231058,223206,'ALG 101',NULL,60,1,1,226593,'-2:0:-100',NULL,NULL,NULL,NULL,1540050),
	(231061,223206,'ALG 101',NULL,120,1,1,226636,'-2:0:-100',NULL,NULL,NULL,NULL,1540050),
	(231070,223206,'ENGL 101',NULL,120,4,1,226594,'-1:2:0:0',NULL,NULL,NULL,NULL,1540050),
	(231073,223206,'ENGL 101',NULL,120,4,1,226638,'-1:2:0:0',NULL,NULL,NULL,NULL,1540050),
	(231086,223206,'SOC 101; SPAN 101',NULL,120,1,1,226596,'0:0:0',NULL,NULL,NULL,NULL,1540050),
	(231090,223206,'SOC 101; SPAN 101',NULL,120,1,1,226626,'0:0:0',NULL,NULL,NULL,NULL,1540050),
	(231095,223206,'BIOL 101',NULL,120,4,1,226624,'0:0:0:0:0',NULL,NULL,NULL,NULL,1540050),
	(231098,223206,'CALC 101',NULL,120,4,1,226588,'0:0:0:0:0',NULL,NULL,NULL,NULL,1540050),
	(231101,223206,'CALC 101',NULL,120,4,1,226618,'0:0:0:0:0',NULL,NULL,NULL,NULL,1540050),
	(231654,231379,'ALG 101',NULL,120,1,1,231643,'0:0:-100',55,231061,NULL,NULL,1540050),
	(231656,231379,'CALC 101',NULL,120,4,1,231597,'0:0:0:0:0',37,231101,NULL,NULL,1540050),
	(231658,231379,'SOC 101; SPAN 101',NULL,120,1,1,231617,'-1:0:0',15,231086,NULL,NULL,1540050),
	(231661,231379,'ALG 101',NULL,60,1,1,231614,'-2:0:-100',12,231058,NULL,NULL,1540050),
	(231663,231379,'SOC 101; SPAN 101',NULL,120,1,1,231637,'-1:0:0',45,231090,NULL,NULL,1540050),
	(231666,231379,'CALC 101',NULL,120,4,1,231631,'0:0:0:0:0',7,231098,NULL,NULL,1540050),
	(231668,231379,'ENGL 101',NULL,120,4,1,231599,'-1:0:0:0',13,231070,NULL,NULL,1540050),
	(231670,231379,'ENGL 101',NULL,120,4,1,231613,'R:0:0:0',57,231073,NULL,NULL,1540050),
	(231672,231379,'BIOL 101',NULL,120,4,1,231633,'0:0:0:0:0',43,231095,NULL,NULL,1540050),
	(231674,231379,'ALG 101',NULL,60,1,1,231632,'-2:0:-100',2,231055,NULL,NULL,1540050),
	(231676,231379,'BIOL 101 ',NULL,180,4,1,231581,'0:0:0',8,230338,NULL,NULL,1540049),
	(231678,231379,'GER 101 Lec 2; SPAN 101 Lec 1',NULL,60,1,1,231588,'2:0:0',9,230693,NULL,NULL,1540049),
	(231681,231379,'BIOL 101 ',NULL,180,4,1,231581,'0:0:-4:0',2,230342,NULL,NULL,1540049),
	(231683,231379,'ENGR 101 Lec 1',NULL,120,1,1,231579,'0:0:0',5,230690,NULL,NULL,1540049),
	(231685,231379,'GER 101 Lec 1; SPAN 101 Lec 2',NULL,60,1,1,231583,'0:0:0',6,230697,NULL,NULL,1540049),
	(231688,231379,'CHM 101 Lec 3',NULL,120,1,0,231584,'0:0:-4',3,230617,NULL,NULL,1540049),
	(231690,231379,'POL 101 Lec 1',NULL,120,1,0,231579,'-2:0:-4',8,230687,NULL,NULL,1540049),
	(231692,231379,'ALG 101',NULL,120,2,1,231584,'0:0:0',3,230331,NULL,NULL,1540049),
	(231694,231379,'POL 101 Lec 2',NULL,120,1,0,231585,'-2:0:-4',0,230684,NULL,NULL,1540049),
	(231696,231379,'ECON 101',NULL,120,1,0,231579,'0:0:0',9,230650,NULL,NULL,1540049),
	(231698,231379,'C S 101',NULL,60,1,0,231580,'0:0:0',4,230597,NULL,NULL,1540049),
	(231700,231379,'BIOL 101 ',NULL,180,4,1,231581,'0:0:0',2,230584,NULL,NULL,1540049),
	(231702,231379,'COM 101 Lec 2, 4, 8, 9',NULL,60,2,1,231585,'0:0:-4',5,230623,NULL,NULL,1540049),
	(231707,231379,'ENGL 101',NULL,60,4,0,231586,'0:0:0:0:0',7,230653,NULL,NULL,1540049),
	(231709,231379,'CALC 101 Lec 3',NULL,60,2,1,231582,'0:0:-4:0',1,230611,NULL,NULL,1540049),
	(231711,231379,'MBIO 101 Lec 1',NULL,120,1,1,231584,'0:0:0',3,230701,NULL,NULL,1540049),
	(231713,231379,'BAND 101',NULL,60,1,0,231582,'0:0:0',1,230335,NULL,NULL,1540049),
	(231715,231379,'PHIL 101 Lec 1; SOC 101 Lec 2',NULL,120,1,1,231585,'0:0:0',0,230670,NULL,NULL,1540049),
	(231718,231379,'SOC 101 Lec 1',NULL,120,1,1,231579,'0:0:-4',3,230678,NULL,NULL,1540049),
	(231720,231379,'PSY 101',NULL,120,2,1,231582,'0:0:-100',2,230681,NULL,NULL,1540049),
	(231722,231379,'COM 101 Lec 1, 3, 6, 7',NULL,60,2,1,231580,'0:0:-4:-4',6,230634,NULL,NULL,1540049),
	(231727,231379,'CHM 101 Lec 1',NULL,120,1,0,231588,'2:0:-4',5,230614,NULL,NULL,1540049),
	(231729,231379,'PHYS 101 Lec 2',NULL,120,1,1,231587,'1:0:0',8,230704,NULL,NULL,1540049),
	(231731,231379,'PHYS 101 Lec 1',NULL,120,1,1,231584,'0:0:0',6,230707,NULL,NULL,1540049),
	(231733,231379,'CALC 101 Lec 1, 2',NULL,60,2,0,231589,'0:0:-4:0',10,230604,NULL,NULL,1540049),
	(231736,231379,'CHM 101 Lec 2',NULL,120,1,0,231585,'0:0:-4',0,230620,NULL,NULL,1540049);

insert into `exam_instructor` values
	(230611,226238),
	(231098,226238),
	(231101,226238),
	(230338,226240),
	(230584,226240),
	(231095,226240),
	(230331,226242),
	(230597,226242),
	(230604,226242),
	(231055,226242),
	(231058,226242),
	(231061,226242),
	(230342,226244),
	(230342,226246),
	(231656,231385),
	(231666,231385),
	(231709,231385),
	(231700,231386),
	(231700,231387),
	(231654,231388),
	(231661,231388),
	(231674,231388),
	(231692,231388),
	(231698,231388),
	(231733,231388),
	(231672,231389),
	(231676,231389),
	(231681,231389);

insert into `exam_location_pref` values
	(123200,7986,6,230774),
	(123201,7986,6,226570),
	(123202,7986,6,226564),
	(123203,7986,7,226587),
	(123204,7986,7,226588),
	(123205,7986,7,226589),
	(123206,7986,7,226590),
	(123207,7986,7,226591),
	(123208,7986,7,226592),
	(123209,7986,7,226593),
	(123210,7986,7,226594),
	(123211,7986,7,226595),
	(123212,7986,7,226596),
	(123213,7986,7,226597),
	(123214,7986,7,226598),
	(123215,7986,7,226599),
	(123216,7986,7,226600),
	(123217,7986,7,226601),
	(123218,7986,7,226602),
	(123219,7986,7,226603),
	(123220,7986,7,226604),
	(123221,7986,7,226605),
	(123222,7986,7,226606),
	(123223,7986,7,226607),
	(123224,7986,7,226608),
	(123225,7987,7,230772),
	(123226,7987,7,230770),
	(123227,7989,7,226633),
	(123228,7989,7,226634),
	(123229,7989,7,226635),
	(123230,7989,7,226636),
	(123231,7989,7,226637),
	(123232,7989,7,226638),
	(123233,7989,7,226639),
	(123234,7989,7,226640),
	(123235,7989,7,226641),
	(123236,7989,7,226642),
	(123237,7989,7,226643),
	(123238,7989,7,226644),
	(123335,8020,7,231642),
	(123336,8020,7,231643),
	(123337,8020,7,231644),
	(123338,8020,7,231645),
	(123339,8020,7,231646),
	(123340,8020,7,231650),
	(123341,8020,7,231649),
	(123342,8020,7,231648),
	(123343,8020,7,231647),
	(123344,8020,7,231653),
	(123345,8020,7,231652),
	(123346,8020,7,231651),
	(123347,8024,7,231589),
	(123348,8024,7,231588),
	(123349,8023,7,231602),
	(123350,8023,7,231601),
	(123351,8023,7,231604),
	(123352,8023,7,231603),
	(123353,8023,7,231606),
	(123354,8023,7,231605),
	(123355,8023,7,231608),
	(123356,8023,7,231607),
	(123357,8023,6,231584),
	(123358,8023,6,231587),
	(123359,8023,7,231596),
	(123360,8023,6,231581),
	(123361,8023,7,231598),
	(123362,8023,7,231597),
	(123363,8023,7,231600),
	(123364,8023,7,231599),
	(123365,8023,7,231617),
	(123366,8023,7,231609),
	(123367,8023,7,231610),
	(123368,8023,7,231611),
	(123369,8023,7,231612),
	(123370,8023,7,231613),
	(123371,8023,7,231614),
	(123372,8023,7,231615),
	(123373,8023,7,231616);

insert into `exam_owner` values
	(230364,230335,135718,1,135718),
	(230582,230338,223240,3,135716),
	(230591,230331,132313,0,135715),
	(230593,230584,223899,3,135716),
	(230671,230670,223344,3,135726),
	(230672,230670,223373,3,135731),
	(230679,230678,224050,3,135731),
	(230691,230690,223996,3,135736),
	(230702,230701,224057,3,135739),
	(230705,230704,223350,3,135727),
	(230708,230707,223351,3,135727),
	(230723,230681,135729,1,135729),
	(230725,230693,223379,3,135732),
	(230726,230693,223324,3,135723),
	(230728,230697,223378,3,135732),
	(230729,230697,223325,3,135723),
	(230740,230614,223256,3,135719),
	(230742,230620,223258,3,135719),
	(230744,230617,223257,3,135719),
	(230746,230623,223302,3,135721),
	(230747,230623,223299,3,135721),
	(230748,230623,223301,3,135721),
	(230749,230623,223300,3,135721),
	(230751,230634,223304,3,135721),
	(230752,230634,223298,3,135721),
	(230753,230634,223303,3,135721),
	(230754,230634,223297,3,135721),
	(230758,230650,135720,1,135720),
	(230762,230653,135722,1,135722),
	(230784,230342,223900,3,135716),
	(230786,230597,135717,1,135717),
	(230942,230684,223356,3,135728),
	(230944,230687,224028,3,135728),
	(230946,230604,223956,3,135733),
	(230947,230604,223869,3,135733),
	(230949,230611,223957,3,135733),
	(231179,231055,135715,1,135715),
	(231181,231058,135715,1,135715),
	(231183,231061,135715,1,135715),
	(231185,231095,135716,1,135716),
	(231187,231098,135733,1,135733),
	(231189,231101,135733,1,135733),
	(231191,231070,135722,1,135722),
	(231193,231073,135722,1,135722),
	(231195,231086,135731,1,135731),
	(231196,231086,135732,1,135732),
	(231198,231090,135732,1,135732),
	(231199,231090,135731,1,135731),
	(238905,231692,132351,0,135753),
	(238907,231713,135754,1,135754),
	(238909,231681,231395,3,135755),
	(238911,231676,231396,3,135755),
	(238913,231700,231397,3,135755),
	(238915,231698,135757,1,135757),
	(238920,231733,231438,3,135758),
	(238921,231733,231437,3,135758),
	(238925,231709,231439,3,135758),
	(238927,231727,231456,3,135760),
	(238929,231736,231457,3,135760),
	(238931,231688,231458,3,135760),
	(238933,231722,231488,3,135761),
	(238934,231722,231486,3,135761),
	(238935,231722,231491,3,135761),
	(238936,231722,231492,3,135761),
	(238938,231702,231489,3,135761),
	(238939,231702,231487,3,135761),
	(238940,231702,231493,3,135761),
	(238941,231702,231494,3,135761),
	(238943,231696,135762,1,135762),
	(238945,231707,135763,1,135763),
	(238947,231683,231524,3,135764),
	(238949,231685,231573,3,135775),
	(238950,231685,231526,3,135765),
	(238952,231678,231572,3,135775),
	(238953,231678,231527,3,135765),
	(238955,231711,231539,3,135768),
	(238957,231715,231570,3,135774),
	(238958,231715,231547,3,135770),
	(238960,231731,231549,3,135771),
	(238962,231729,231550,3,135771),
	(238964,231690,231564,3,135772),
	(238966,231694,231565,3,135772),
	(238968,231720,135773,1,135773),
	(238970,231718,231569,3,135774),
	(239076,231661,135753,1,135753),
	(239078,231674,135753,1,135753),
	(239080,231654,135753,1,135753),
	(239082,231672,135755,1,135755),
	(239084,231656,135758,1,135758),
	(239086,231666,135758,1,135758),
	(239088,231668,135763,1,135763),
	(239090,231670,135763,1,135763),
	(239092,231658,135774,1,135774),
	(239093,231658,135775,1,135775),
	(239095,231663,135775,1,135775),
	(239096,231663,135774,1,135774);

insert into `exam_period` values
	(226560,223206,0,96,24,4,0,0,1540049),
	(226562,223206,0,138,12,4,0,0,1540049),
	(226564,223206,0,156,36,4,0,0,1540049),
	(226566,223206,1,96,24,4,0,0,1540049),
	(226568,223206,1,138,12,4,0,0,1540049),
	(226570,223206,1,156,36,4,0,0,1540049),
	(226574,223206,2,96,24,4,0,0,1540049),
	(226576,223206,2,138,12,4,0,0,1540049),
	(226581,223206,-105,222,12,4,0,0,1540050),
	(226582,223206,-105,240,24,4,0,0,1540050),
	(226583,223206,-104,222,12,4,0,0,1540050),
	(226584,223206,-104,240,24,4,0,0,1540050),
	(226585,223206,-103,222,12,4,0,0,1540050),
	(226586,223206,-103,240,24,4,0,0,1540050),
	(226587,223206,-96,222,12,4,0,0,1540050),
	(226588,223206,-96,240,24,4,0,0,1540050),
	(226589,223206,-95,222,12,4,0,0,1540050),
	(226590,223206,-95,240,24,4,0,0,1540050),
	(226591,223206,-91,222,12,4,0,0,1540050),
	(226592,223206,-91,240,24,4,0,0,1540050),
	(226593,223206,-90,222,12,4,0,0,1540050),
	(226594,223206,-90,240,24,4,0,0,1540050),
	(226595,223206,-89,222,12,4,0,0,1540050),
	(226596,223206,-89,240,24,4,0,0,1540050),
	(226597,223206,-84,222,12,4,0,0,1540050),
	(226598,223206,-84,240,24,4,0,0,1540050),
	(226599,223206,-83,222,12,4,0,0,1540050),
	(226600,223206,-83,240,24,4,0,0,1540050),
	(226601,223206,-82,222,12,4,0,0,1540050),
	(226602,223206,-82,240,24,4,0,0,1540050),
	(226603,223206,-77,222,12,4,0,0,1540050),
	(226604,223206,-77,240,24,4,0,0,1540050),
	(226605,223206,-76,222,12,4,0,0,1540050),
	(226606,223206,-76,240,24,4,0,0,1540050),
	(226607,223206,-75,222,12,4,0,0,1540050),
	(226608,223206,-75,240,24,4,0,0,1540050),
	(226609,223206,-70,222,12,4,0,0,1540050),
	(226610,223206,-70,240,24,4,0,0,1540050),
	(226611,223206,-69,222,12,4,0,0,1540050),
	(226612,223206,-69,240,24,4,0,0,1540050),
	(226613,223206,-68,222,12,4,0,0,1540050),
	(226614,223206,-68,240,24,4,0,0,1540050),
	(226615,223206,-56,222,12,4,0,0,1540050),
	(226616,223206,-56,240,24,4,0,0,1540050),
	(226617,223206,-55,222,12,4,0,0,1540050),
	(226618,223206,-55,240,24,4,0,0,1540050),
	(226619,223206,-54,222,12,4,0,0,1540050),
	(226620,223206,-54,240,24,4,0,0,1540050),
	(226621,223206,-49,222,12,4,0,0,1540050),
	(226622,223206,-49,240,24,4,0,0,1540050),
	(226623,223206,-48,222,12,4,0,0,1540050),
	(226624,223206,-48,240,24,4,0,0,1540050),
	(226625,223206,-47,222,12,4,0,0,1540050),
	(226626,223206,-47,240,24,4,0,0,1540050),
	(226627,223206,-42,222,12,4,0,0,1540050),
	(226628,223206,-42,240,24,4,0,0,1540050),
	(226629,223206,-41,222,12,4,0,0,1540050),
	(226630,223206,-41,240,24,4,0,0,1540050),
	(226631,223206,-40,222,12,4,0,0,1540050),
	(226632,223206,-40,240,24,4,0,0,1540050),
	(226633,223206,-35,222,12,4,0,0,1540050),
	(226634,223206,-35,240,24,4,0,0,1540050),
	(226635,223206,-34,222,12,4,0,0,1540050),
	(226636,223206,-34,240,24,4,0,0,1540050),
	(226637,223206,-33,222,12,4,0,0,1540050),
	(226638,223206,-33,240,24,4,0,0,1540050),
	(226639,223206,-28,222,12,4,0,0,1540050),
	(226640,223206,-28,240,24,4,0,0,1540050),
	(226641,223206,-27,222,12,4,0,0,1540050),
	(226642,223206,-27,240,24,4,0,0,1540050),
	(226643,223206,-26,222,12,4,0,0,1540050),
	(226644,223206,-26,240,24,4,0,0,1540050),
	(230770,223206,3,96,24,6,0,0,1540049),
	(230772,223206,3,138,12,6,0,0,1540049),
	(230774,223206,2,156,36,5,0,0,1540049),
	(231579,231379,0,96,24,4,0,0,1540049),
	(231580,231379,0,138,12,4,0,0,1540049),
	(231581,231379,0,156,36,4,0,0,1540049),
	(231582,231379,1,96,24,4,0,0,1540049),
	(231583,231379,1,138,12,4,0,0,1540049),
	(231584,231379,1,156,36,4,0,0,1540049),
	(231585,231379,2,96,24,4,0,0,1540049),
	(231586,231379,2,138,12,4,0,0,1540049),
	(231587,231379,2,156,36,5,0,0,1540049),
	(231588,231379,3,96,24,6,0,0,1540049),
	(231589,231379,3,138,12,6,0,0,1540049),
	(231590,231379,-105,222,12,4,0,0,1540050),
	(231591,231379,-105,240,24,4,0,0,1540050),
	(231592,231379,-104,222,12,4,0,0,1540050),
	(231593,231379,-104,240,24,4,0,0,1540050),
	(231594,231379,-103,222,12,4,0,0,1540050),
	(231595,231379,-103,240,24,4,0,0,1540050),
	(231596,231379,-96,222,12,4,0,0,1540050),
	(231597,231379,-96,240,24,4,0,0,1540050),
	(231598,231379,-95,222,12,4,0,0,1540050),
	(231599,231379,-95,240,24,4,0,0,1540050),
	(231600,231379,-91,222,12,4,0,0,1540050),
	(231601,231379,-91,240,24,4,0,0,1540050),
	(231602,231379,-90,222,12,4,0,0,1540050),
	(231603,231379,-90,240,24,4,0,0,1540050),
	(231604,231379,-89,222,12,4,0,0,1540050),
	(231605,231379,-89,240,24,4,0,0,1540050),
	(231606,231379,-84,222,12,4,0,0,1540050),
	(231607,231379,-84,240,24,4,0,0,1540050),
	(231608,231379,-83,222,12,4,0,0,1540050),
	(231609,231379,-83,240,24,4,0,0,1540050),
	(231610,231379,-82,222,12,4,0,0,1540050),
	(231611,231379,-82,240,24,4,0,0,1540050),
	(231612,231379,-77,222,12,4,0,0,1540050),
	(231613,231379,-77,240,24,4,0,0,1540050),
	(231614,231379,-76,222,12,4,0,0,1540050),
	(231615,231379,-76,240,24,4,0,0,1540050),
	(231616,231379,-75,222,12,4,0,0,1540050),
	(231617,231379,-75,240,24,4,0,0,1540050),
	(231618,231379,-70,222,12,4,0,0,1540050),
	(231619,231379,-70,240,24,4,0,0,1540050),
	(231620,231379,-69,222,12,4,0,0,1540050),
	(231621,231379,-69,240,24,4,0,0,1540050),
	(231622,231379,-68,222,12,4,0,0,1540050),
	(231623,231379,-68,240,24,4,0,0,1540050),
	(231624,231379,-56,222,12,4,0,0,1540050),
	(231625,231379,-56,240,24,4,0,0,1540050),
	(231626,231379,-55,222,12,4,0,0,1540050),
	(231627,231379,-55,240,24,4,0,0,1540050),
	(231628,231379,-54,222,12,4,0,0,1540050),
	(231629,231379,-54,240,24,4,0,0,1540050),
	(231630,231379,-49,222,12,4,0,0,1540050),
	(231631,231379,-49,240,24,4,0,0,1540050),
	(231632,231379,-48,222,12,4,0,0,1540050),
	(231633,231379,-48,240,24,4,0,0,1540050),
	(231634,231379,-47,222,12,4,0,0,1540050),
	(231635,231379,-47,240,24,4,0,0,1540050),
	(231636,231379,-42,222,12,4,0,0,1540050),
	(231637,231379,-42,240,24,4,0,0,1540050),
	(231638,231379,-41,222,12,4,0,0,1540050),
	(231639,231379,-41,240,24,4,0,0,1540050),
	(231640,231379,-40,222,12,4,0,0,1540050),
	(231641,231379,-40,240,24,4,0,0,1540050),
	(231642,231379,-35,222,12,4,0,0,1540050),
	(231643,231379,-35,240,24,4,0,0,1540050),
	(231644,231379,-34,222,12,4,0,0,1540050),
	(231645,231379,-34,240,24,4,0,0,1540050),
	(231646,231379,-33,222,12,4,0,0,1540050),
	(231647,231379,-33,240,24,4,0,0,1540050),
	(231648,231379,-28,222,12,4,0,0,1540050),
	(231649,231379,-28,240,24,4,0,0,1540050),
	(231650,231379,-27,222,12,4,0,0,1540050),
	(231651,231379,-27,240,24,4,0,0,1540050),
	(231652,231379,-26,222,12,4,0,0,1540050),
	(231653,231379,-26,240,24,4,0,0,1540050);

insert into `exam_period_pref` values
	(121605,230331,3,226564),
	(121607,230331,3,226560),
	(121608,230331,3,226562),
	(121657,230693,6,226574),
	(121659,230693,7,226576),
	(121660,230697,6,226574),
	(121662,230697,7,226576),
	(121678,230650,7,226576),
	(121681,230650,7,226574),
	(121724,230684,2,226560),
	(121726,230687,3,230774),
	(121728,230687,3,226576),
	(121729,230687,2,226574),
	(121730,230604,2,230772),
	(121733,230611,2,226562),
	(123160,231055,4,226584),
	(123161,231055,3,226585),
	(123162,231055,4,226586),
	(123163,231055,2,226583),
	(123164,231055,3,226581),
	(123166,231055,4,226582),
	(123167,231058,2,226593),
	(123168,231058,3,226595),
	(123169,231058,4,226596),
	(123171,231058,4,226594),
	(123172,231058,4,226592),
	(123173,231058,3,226591),
	(123174,231061,4,226634),
	(123175,231061,4,226638),
	(123177,231061,2,226636),
	(123178,231095,4,226626),
	(123179,231095,4,226624),
	(123180,231095,4,226622),
	(123181,231098,4,226590),
	(123182,231098,4,226588),
	(123183,231101,4,226620),
	(123184,231101,4,226616),
	(123185,231101,4,226618),
	(123186,231070,3,226596),
	(123187,231070,4,226592),
	(123188,231070,3,226594),
	(123189,231073,3,226638),
	(123190,231073,4,226636),
	(123191,231073,4,226634),
	(123192,231086,4,226592),
	(123193,231086,4,226594),
	(123194,231086,4,226596),
	(123195,231090,4,226624),
	(123196,231090,4,226626),
	(123197,231090,4,226622),
	(123397,231692,3,231581),
	(123398,231692,3,231580),
	(123400,231692,3,231579),
	(123408,231733,2,231589),
	(123412,231709,2,231580),
	(123422,231696,7,231586),
	(123423,231696,7,231585),
	(123426,231685,7,231586),
	(123427,231685,6,231585),
	(123430,231678,6,231585),
	(123431,231678,7,231586),
	(123437,231690,2,231579),
	(123438,231694,2,231585),
	(123439,231694,3,231587),
	(123440,231694,3,231586),
	(123465,231661,3,231616),
	(123466,231661,4,231617),
	(123467,231661,4,231613),
	(123468,231661,2,231614),
	(123470,231661,4,231615),
	(123471,231661,3,231612),
	(123472,231674,3,231630),
	(123473,231674,3,231634),
	(123474,231674,2,231632),
	(123475,231674,4,231635),
	(123476,231674,4,231633),
	(123478,231674,4,231631),
	(123479,231654,3,231646),
	(123481,231654,4,231647),
	(123482,231654,4,231643),
	(123483,231654,4,231645),
	(123484,231654,3,231642),
	(123485,231654,2,231644),
	(123486,231672,4,231631),
	(123487,231672,4,231635),
	(123488,231672,4,231633),
	(123489,231656,4,231599),
	(123490,231656,4,231597),
	(123491,231666,4,231633),
	(123492,231666,4,231631),
	(123493,231666,4,231635),
	(123494,231668,3,231599),
	(123495,231668,4,231597),
	(123496,231670,4,231613),
	(123497,231658,3,231617),
	(123498,231658,4,231615),
	(123499,231658,4,231613),
	(123500,231663,4,231641),
	(123501,231663,4,231639),
	(123502,231663,3,231637);

insert into `exam_room_assignment` values
	(230331,7988),
	(230335,7986),
	(230338,7986),
	(230338,7988),
	(230342,7987),
	(230342,7989),
	(230584,7986),
	(230584,7988),
	(230597,7994),
	(230604,7986),
	(230604,7994),
	(230611,7994),
	(230614,7986),
	(230617,7986),
	(230620,7986),
	(230623,7987),
	(230623,7988),
	(230634,7987),
	(230634,7988),
	(230650,7986),
	(230653,7986),
	(230653,7988),
	(230653,7994),
	(230670,7994),
	(230678,7987),
	(230681,7994),
	(230684,7987),
	(230687,7987),
	(230690,7994),
	(230693,7994),
	(230697,7994),
	(230701,7994),
	(230704,7994),
	(230707,7986),
	(231055,7987),
	(231058,7987),
	(231061,7987),
	(231070,7987),
	(231070,7994),
	(231073,7986),
	(231073,7994),
	(231086,7994),
	(231090,7994),
	(231095,7986),
	(231095,7989),
	(231095,7994),
	(231098,7987),
	(231098,7988),
	(231098,7994),
	(231101,7987),
	(231101,7988),
	(231101,7994),
	(231654,8024),
	(231656,8017),
	(231656,8019),
	(231656,8024),
	(231658,8017),
	(231661,8024),
	(231663,8017),
	(231666,8017),
	(231666,8019),
	(231666,8024),
	(231668,8017),
	(231668,8024),
	(231670,8017),
	(231670,8024),
	(231672,8017),
	(231672,8020),
	(231672,8023),
	(231674,8024),
	(231676,8017),
	(231678,8017),
	(231681,8023),
	(231681,8024),
	(231683,8017),
	(231685,8017),
	(231688,8023),
	(231690,8019),
	(231692,8024),
	(231694,8019),
	(231696,8023),
	(231698,8017),
	(231700,8019),
	(231702,8024),
	(231707,8017),
	(231707,8023),
	(231707,8024),
	(231709,8019),
	(231709,8023),
	(231711,8017),
	(231713,8024),
	(231715,8017),
	(231718,8024),
	(231720,8017),
	(231722,8019),
	(231722,8024),
	(231727,8023),
	(231729,8017),
	(231731,8019),
	(231733,8017),
	(231733,8023),
	(231736,8023);

insert into `exam_type` values
	(1540049,'final','Final',0),
	(1540050,'midterm','Midterm',1);

insert into `hibernate_unique_key` values
	(54);

insert into `instr_offering_config` values
	(36948,2,132313,0,'1',NULL,NULL),
	(36949,11,132314,0,'1',NULL,NULL),
	(36950,4,132315,0,'1',NULL,NULL),
	(36951,4,132316,0,'1',NULL,NULL),
	(36952,12,132317,0,'1',NULL,NULL),
	(36953,4,132318,0,'1',NULL,NULL),
	(36954,9,132319,0,'1',NULL,NULL),
	(36955,10,132320,0,'1',NULL,NULL),
	(36956,4,132321,0,'1',NULL,NULL),
	(36957,4,132322,0,'1',NULL,NULL),
	(36959,2,132324,0,'1',NULL,NULL),
	(36960,5,132325,0,'1',NULL,NULL),
	(36961,4,132326,0,'1',NULL,NULL),
	(36962,4,132327,0,'1',NULL,NULL),
	(36963,2,132328,0,'1',NULL,NULL),
	(36964,4,132329,0,'1',NULL,NULL),
	(36965,4,132330,0,'1',NULL,NULL),
	(36966,12,132331,0,'1',NULL,NULL),
	(36967,3,132334,0,'1',NULL,NULL),
	(36968,3,132335,0,'1',NULL,NULL),
	(36969,2,132336,0,'1',NULL,NULL),
	(36970,4,132337,0,'1',NULL,NULL),
	(36971,3,132338,0,'1',NULL,NULL),
	(36986,2,132351,0,'1',NULL,36948),
	(36987,4,132352,0,'1',NULL,36951),
	(36988,11,132353,0,'1',NULL,36949),
	(36989,3,132354,0,'1',NULL,36967),
	(36990,4,132355,0,'1',NULL,36950),
	(36991,12,132356,0,'1',NULL,36966),
	(36992,2,132357,0,'1',NULL,36963),
	(36993,12,132358,0,'1',NULL,36952),
	(36994,9,132359,0,'1',NULL,36954),
	(36995,4,132360,0,'1',NULL,36953),
	(36996,10,132361,0,'1',NULL,36955),
	(36997,3,132362,0,'1',NULL,36968),
	(36998,4,132363,0,'1',NULL,36956),
	(36999,4,132364,0,'1',NULL,36957),
	(37000,2,132365,0,'1',NULL,36969),
	(37001,3,132366,0,'1',NULL,36971),
	(37002,4,132367,0,'1',NULL,36970),
	(37003,2,132368,0,'1',NULL,36959),
	(37004,5,132369,0,'1',NULL,36960),
	(37005,4,132370,0,'1',NULL,36961),
	(37006,4,132371,0,'1',NULL,36962),
	(37007,4,132372,0,'1',NULL,36964),
	(37008,4,132373,0,'1',NULL,36965);

insert into `instructional_offering` values
	(132313,223206,1,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132314,223206,2,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132315,223206,3,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132316,223206,4,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132317,223206,5,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132318,223206,6,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132319,223206,7,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132320,223206,8,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132321,223206,9,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132322,223206,10,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132324,223206,12,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132325,223206,13,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132326,223206,14,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132327,223206,15,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132328,223206,16,1,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132329,223206,17,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132330,223206,18,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132331,223206,166800,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132334,223206,166801,1,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132335,223206,166802,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132336,223206,166803,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132337,223206,166804,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132338,223206,166805,0,NULL,0,NULL,NULL,NULL,0,NULL,NULL,NULL),
	(132351,231379,1,0,NULL,0,NULL,132313,NULL,0,NULL,NULL,NULL),
	(132352,231379,4,0,NULL,0,NULL,132316,NULL,0,NULL,NULL,NULL),
	(132353,231379,2,0,NULL,0,NULL,132314,NULL,0,NULL,NULL,NULL),
	(132354,231379,166801,1,NULL,0,NULL,132334,NULL,0,NULL,NULL,NULL),
	(132355,231379,3,0,NULL,0,NULL,132315,NULL,0,NULL,NULL,NULL),
	(132356,231379,166800,0,NULL,0,NULL,132331,NULL,0,NULL,NULL,NULL),
	(132357,231379,16,1,NULL,0,NULL,132328,NULL,0,NULL,NULL,NULL),
	(132358,231379,5,0,NULL,0,NULL,132317,NULL,0,NULL,NULL,NULL),
	(132359,231379,7,0,NULL,0,NULL,132319,NULL,0,NULL,NULL,NULL),
	(132360,231379,6,0,NULL,0,NULL,132318,NULL,0,NULL,NULL,NULL),
	(132361,231379,8,0,NULL,0,NULL,132320,NULL,0,NULL,NULL,NULL),
	(132362,231379,166802,0,NULL,0,NULL,132335,NULL,0,NULL,NULL,NULL),
	(132363,231379,9,0,NULL,0,NULL,132321,NULL,0,NULL,NULL,NULL),
	(132364,231379,10,0,NULL,0,NULL,132322,NULL,0,NULL,NULL,NULL),
	(132365,231379,166803,0,NULL,0,NULL,132336,NULL,0,NULL,NULL,NULL),
	(132366,231379,166805,0,NULL,0,NULL,132338,NULL,0,NULL,NULL,NULL),
	(132367,231379,166804,0,NULL,0,NULL,132337,NULL,0,NULL,NULL,NULL),
	(132368,231379,12,0,NULL,0,NULL,132324,NULL,0,NULL,NULL,NULL),
	(132369,231379,13,0,NULL,0,NULL,132325,NULL,0,NULL,NULL,NULL),
	(132370,231379,14,0,NULL,0,NULL,132326,NULL,0,NULL,NULL,NULL),
	(132371,231379,15,0,NULL,0,NULL,132327,NULL,0,NULL,NULL,NULL),
	(132372,231379,17,0,NULL,0,NULL,132329,NULL,0,NULL,NULL,NULL),
	(132373,231379,18,0,NULL,0,NULL,132330,NULL,0,NULL,NULL,NULL);

insert into `itype_desc` values
	(10,'Lec  ','Lecture','lec',1,NULL,1),
	(11,'Lec 1','Lecture 1','lec',0,10,1),
	(12,'Lec 2','Lecture 2','lec',0,10,1),
	(13,'Lec 3','Lecture 3','lec',0,10,1),
	(14,'Lec 4','Lecture 4','lec',0,10,1),
	(15,'Lec 5','Lecture 5','lec',0,10,1),
	(16,'Lec 6','Lecture 6','lec',0,10,1),
	(17,'Lec 7','Lecture 7','lec',0,10,1),
	(18,'Lec 8','Lecture 8','lec',0,10,1),
	(19,'Lec 9','Lecture 9','lec',0,10,1),
	(20,'Rec  ','Recitation','rec',1,NULL,1),
	(21,'Rec 1','Recitation 1','rec',0,20,1),
	(22,'Rec 2','Recitation 2','rec',0,20,1),
	(23,'Rec 3','Recitation 3','rec',0,20,1),
	(24,'Rec 4','Recitation 4','rec',0,20,1),
	(25,'Prsn ','Presentation','prsn',1,NULL,1),
	(26,'Prsn1','Presentation 1','prsn',0,25,1),
	(27,'Prsn2','Presentation 2','prsn',0,25,1),
	(28,'Prsn3','Presentation 3 ','prsn',0,25,1),
	(29,'Prsn4','Presentation 4','prsn',0,25,1),
	(30,'Lab  ','Laboratory','lab',1,NULL,1),
	(31,'Lab 1','Laboratory 1','lab',0,30,1),
	(32,'Lab 2','Laboratory 2','lab',0,30,1),
	(33,'Lab 3','Laboratory 3','lab',0,30,1),
	(34,'Lab 4','Laboratory 4','lab',0,30,1),
	(35,'LabP ','Laboratory Preparation','labP',1,NULL,1),
	(36,'LabP1','Laboratory Preparation 1','labP',0,35,1),
	(37,'LabP2','Laboratory Preparation 2','labP',0,35,1),
	(38,'LabP3','Laboratory Preparation 3','labP',0,35,1),
	(39,'LabP4','Laboratory Preparation 4','labP',0,35,1),
	(40,'Stdo ','Studio','stdo',1,NULL,1),
	(41,'Stdo1','Studio 1','stdo',0,40,1),
	(42,'Stdo2','Studio 2','stdo',0,40,1),
	(43,'Stdo3','Studio 3','stdo',0,40,1),
	(44,'Stdo4','Studio 4','stdo',0,40,1),
	(45,'Dist ','Distance Learning','dist',1,NULL,0),
	(46,'Dist1','Distance Learning 1','dist',0,45,0),
	(47,'Dist2','Distance Learning 2','dist',0,45,0),
	(48,'Dist3','Distance Learning 3','dist',0,45,0),
	(49,'Dist4','Distance Learning 4','dist',0,45,0),
	(50,'Clin ','Clinic','clin',1,NULL,0),
	(51,'Clin1','Clinic 1','clin',0,50,0),
	(52,'Clin2','Clinic 2','clin',0,50,0),
	(53,'Clin3','Clinic 3','clin',0,50,0),
	(54,'Clin4','Clinic 4','clin',0,50,0),
	(55,'Clin5','Clinic 5','clin',0,50,0),
	(56,'Clin6','Clinic 6','clin',0,50,0),
	(57,'Clin7','Clinic 7','clin',0,50,0),
	(58,'Clin8','Clinic 8','clin',0,50,0),
	(59,'Clin9','Clinic 9','clin',0,50,0),
	(60,'Expr ','Experiential','expr',1,NULL,0),
	(61,'Expr1','Experiential 1','expr',0,60,0),
	(62,'Expr2','Experiential 2','expr',0,60,0),
	(63,'Expr3','Experiential 3','expr',0,60,0),
	(64,'Expr4','Experiential 4','expr',0,60,0),
	(65,'Expr5','Experiential 5','expr',0,60,0),
	(66,'Expr6','Experiential 6','expr',0,60,0),
	(67,'Expr7','Experiential 7','expr',0,60,0),
	(68,'Expr8','Experiential 8','expr',0,60,0),
	(69,'Expr9','Experiential 9','expr',0,60,0),
	(70,'Res  ','Research','res',1,NULL,0),
	(71,'Res 1','Research 1','res',0,70,0),
	(72,'Res 2','Research 2','res',0,70,0),
	(73,'Res 3','Research 3','res',0,70,0),
	(74,'Res 4','Research 4','res',0,70,0),
	(75,'Res 5','Research 5','res',0,70,0),
	(76,'Res 6','Research 6','res',0,70,0),
	(77,'Res 7','Research 7','res',0,70,0),
	(78,'Res 8','Research 8','res',0,70,0),
	(79,'Res 9','Research 9','res',0,70,0),
	(80,'Ind  ','Individual Study','ind',1,NULL,0),
	(81,'Ind 1','Individual Study 1','ind',0,80,0),
	(82,'Ind 2','Individual Study 2','ind',0,80,0),
	(83,'Ind 3','Individual Study 3','ind',0,80,0),
	(84,'Ind 4','Individual Study 4','ind',0,80,0),
	(85,'Ind 5','Individual Study 5','ind',0,80,0),
	(86,'Ind 6','Individual Study 6','ind',0,80,0),
	(87,'Ind 7','Individual Study 7','ind',0,80,0),
	(88,'Ind 8','Individual Study 8','ind',0,80,0),
	(89,'Ind 9','Individual Study 9','ind',0,80,0),
	(90,'Pso  ','Practice Study Observation','pso',1,NULL,0),
	(91,'Pso 1','Practice Study Observation 1','pso',0,90,0),
	(92,'Pso 2','Practice Study Observation 2','pso',0,90,0),
	(93,'Pso 3','Practice Study Observation 3','pso',0,90,0),
	(94,'Pso 4','Practice Study Observation 4','pso',0,90,0),
	(95,'Pso 5','Practice Study Observation 5','pso',0,90,0),
	(96,'Pso 6','Practice Study Observation 6','pso',0,90,0),
	(97,'Pso 7','Practice Study Observation 7','pso',0,90,0),
	(98,'Pso 8','Practice Study Observation 8','pso',0,90,0),
	(99,'Pso 9','Practice Study Observation 9','pso',0,90,0);

insert into `lastlike_course_demand` values
	(224760,223384,767,'101',1,NULL),
	(224761,223384,775,'101',2,NULL),
	(224762,223384,766,'101',3,NULL),
	(224763,223384,777,'101',4,NULL),
	(224764,223384,761,'101',0,NULL),
	(224765,223385,761,'101',0,NULL),
	(224766,223385,767,'101',1,NULL),
	(224767,223385,775,'101',2,NULL),
	(224768,223385,766,'101',3,NULL),
	(224769,223385,769,'101',4,NULL),
	(224770,223386,768,'101',1,NULL),
	(224771,223386,775,'101',2,NULL),
	(224772,223386,766,'101',3,NULL),
	(224773,223386,763,'101',4,NULL),
	(224774,223386,771,'101',0,NULL),
	(224775,223387,762,'101',1,NULL),
	(224776,223387,765,'101',2,NULL),
	(224777,223387,771,'101',3,NULL),
	(224778,223387,781,'101',4,NULL),
	(224779,223387,768,'101',5,NULL),
	(224780,223388,762,'101',1,NULL),
	(224781,223388,765,'101',2,NULL),
	(224782,223388,771,'101',3,NULL),
	(224783,223388,781,'101',4,NULL),
	(224784,223388,768,'101',5,NULL),
	(224785,223389,762,'101',1,NULL),
	(224786,223389,765,'101',2,NULL),
	(224787,223389,771,'101',3,NULL),
	(224788,223389,781,'101',4,NULL),
	(224789,223389,768,'101',5,NULL),
	(224790,223390,765,'101',0,NULL),
	(224791,223390,773,'101',1,NULL),
	(224792,223390,779,'101',2,NULL),
	(224793,223390,771,'101',3,NULL),
	(224794,223390,767,'101',4,NULL),
	(224795,223390,764,'101',5,NULL),
	(224796,223391,765,'101',1,NULL),
	(224797,223391,762,'101',2,NULL),
	(224798,223391,779,'101',3,NULL),
	(224799,223391,771,'101',4,NULL),
	(224800,223391,767,'101',5,NULL),
	(224801,223392,765,'101',1,NULL),
	(224802,223392,773,'101',2,NULL),
	(224803,223392,779,'101',3,NULL),
	(224804,223392,771,'101',4,NULL),
	(224805,223392,768,'101',5,NULL),
	(224806,223393,765,'101',1,NULL),
	(224807,223393,773,'101',2,NULL),
	(224808,223393,763,'101',3,NULL),
	(224809,223393,771,'101',4,NULL),
	(224810,223393,768,'101',5,NULL),
	(224811,223394,762,'101',1,NULL),
	(224812,223394,767,'101',2,NULL),
	(224813,223394,774,'101',3,NULL),
	(224814,223394,775,'101',4,NULL),
	(224815,223394,778,'101',5,NULL),
	(224816,223395,768,'101',1,NULL),
	(224817,223395,769,'101',2,NULL),
	(224818,223395,772,'101',3,NULL),
	(224819,223395,770,'101',4,NULL),
	(224820,223395,764,'101',5,NULL),
	(224821,223395,767,'101',0,NULL),
	(224822,223396,777,'101',1,NULL),
	(224823,223396,770,'101',2,NULL),
	(224824,223396,780,'101',3,NULL),
	(224825,223396,772,'101',4,NULL),
	(224826,223396,773,'101',5,NULL),
	(224827,223397,762,'101',1,NULL),
	(224828,223397,782,'101',2,NULL),
	(224829,223397,765,'101',3,NULL),
	(224830,223397,771,'101',4,NULL),
	(224831,223397,768,'101',5,NULL),
	(224832,223398,762,'101',1,NULL),
	(224833,223398,782,'101',2,NULL),
	(224834,223398,765,'101',3,NULL),
	(224835,223398,771,'101',4,NULL),
	(224836,223398,769,'101',5,NULL),
	(224837,223399,762,'101',1,NULL),
	(224838,223399,782,'101',2,NULL),
	(224839,223399,765,'101',3,NULL),
	(224840,223399,771,'101',4,NULL),
	(224841,223399,778,'101',5,NULL),
	(224842,223400,774,'101',0,NULL),
	(224843,223400,762,'101',1,NULL),
	(224844,223400,765,'101',2,NULL),
	(224845,223400,768,'101',3,NULL),
	(224846,223400,778,'101',4,NULL),
	(224847,223401,770,'101',1,NULL),
	(224848,223401,762,'101',2,NULL),
	(224849,223401,765,'101',3,NULL),
	(224850,223401,768,'101',4,NULL),
	(224851,223401,769,'101',5,NULL),
	(224852,223402,763,'101',1,NULL),
	(224853,223402,773,'101',2,NULL),
	(224854,223402,771,'101',3,NULL),
	(224855,223402,767,'101',4,NULL),
	(224856,223402,774,'101',5,NULL),
	(231738,223384,807,'101',3,NULL),
	(231739,223385,807,'101',3,NULL),
	(231740,223386,802,'101',4,NULL),
	(231741,223389,805,'101',2,NULL),
	(231742,223391,801,'101',2,NULL),
	(231743,223392,816,'101',2,NULL),
	(231744,223399,805,'101',3,NULL),
	(231745,223399,820,'101',5,NULL),
	(231746,223401,811,'101',1,NULL),
	(231747,223384,806,'101',1,NULL),
	(231748,223385,799,'101',0,NULL),
	(231749,223388,805,'101',2,NULL),
	(231750,223392,803,'101',4,NULL),
	(231751,223394,820,'101',5,NULL),
	(231752,223395,811,'101',4,NULL),
	(231753,223398,803,'101',4,NULL),
	(231754,223401,805,'101',3,NULL),
	(231755,223402,806,'101',4,NULL),
	(231756,223384,799,'101',0,NULL),
	(231757,223384,818,'101',2,NULL),
	(231758,223384,819,'101',4,NULL),
	(231759,223386,818,'101',2,NULL),
	(231760,223387,814,'101',4,NULL),
	(231761,223390,803,'101',3,NULL),
	(231762,223390,805,'101',0,NULL),
	(231763,223391,805,'101',1,NULL),
	(231764,223392,808,'101',5,NULL),
	(231765,223393,816,'101',2,NULL),
	(231766,223395,810,'101',2,NULL),
	(231767,223398,801,'101',1,NULL),
	(231768,223399,801,'101',1,NULL),
	(231769,223400,820,'101',4,NULL),
	(231770,223401,801,'101',2,NULL),
	(231771,223401,810,'101',5,NULL),
	(231772,223402,817,'101',5,NULL),
	(231773,223385,806,'101',1,NULL),
	(231774,223387,805,'101',2,NULL),
	(231775,223388,803,'101',3,NULL),
	(231776,223388,808,'101',5,NULL),
	(231777,223389,801,'101',1,NULL),
	(231778,223390,809,'101',2,NULL),
	(231779,223393,805,'101',1,NULL),
	(231780,223395,808,'101',1,NULL),
	(231781,223396,815,'101',4,NULL),
	(231782,223396,816,'101',5,NULL),
	(231783,223397,808,'101',5,NULL),
	(231784,223398,813,'101',2,NULL),
	(231785,223400,817,'101',0,NULL),
	(231786,223385,810,'101',4,NULL),
	(231787,223387,801,'101',1,NULL),
	(231788,223387,803,'101',3,NULL),
	(231789,223390,800,'101',5,NULL),
	(231790,223391,806,'101',5,NULL),
	(231791,223391,809,'101',3,NULL),
	(231792,223392,805,'101',1,NULL),
	(231793,223393,808,'101',5,NULL),
	(231794,223394,806,'101',2,NULL),
	(231795,223395,800,'101',5,NULL),
	(231796,223397,813,'101',2,NULL),
	(231797,223400,805,'101',2,NULL),
	(231798,223402,803,'101',3,NULL),
	(231801,223385,818,'101',2,NULL),
	(231802,223386,803,'101',0,NULL),
	(231803,223386,807,'101',3,NULL),
	(231804,223386,808,'101',1,NULL),
	(231805,223388,801,'101',1,NULL),
	(231806,223389,808,'101',5,NULL),
	(231807,223390,816,'101',1,NULL),
	(231808,223391,803,'101',4,NULL),
	(231809,223392,809,'101',3,NULL),
	(231810,223393,803,'101',4,NULL),
	(231811,223395,806,'101',0,NULL),
	(231812,223396,811,'101',2,NULL),
	(231813,223397,801,'101',1,NULL),
	(231814,223397,803,'101',4,NULL),
	(231815,223399,803,'101',4,NULL),
	(231816,223400,801,'101',1,NULL),
	(231817,223402,816,'101',2,NULL),
	(231820,223394,801,'101',1,NULL),
	(231821,223395,815,'101',3,NULL),
	(231822,223396,812,'101',3,NULL),
	(231823,223397,805,'101',3,NULL),
	(231824,223399,813,'101',2,NULL),
	(231825,223401,808,'101',4,NULL),
	(231826,223387,808,'101',5,NULL),
	(231827,223388,814,'101',4,NULL),
	(231828,223389,803,'101',3,NULL),
	(231829,223389,814,'101',4,NULL),
	(231830,223390,806,'101',4,NULL),
	(231831,223393,802,'101',3,NULL),
	(231832,223394,817,'101',3,NULL),
	(231833,223394,818,'101',4,NULL),
	(231834,223396,819,'101',1,NULL),
	(231835,223398,805,'101',3,NULL),
	(231836,223398,810,'101',5,NULL),
	(231837,223400,808,'101',3,NULL),
	(231838,223402,802,'101',1,NULL);

insert into `meeting` values
	(226648,226646,'2007-10-17 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226649,226646,'2007-09-05 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226650,226646,'2007-11-28 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226651,226646,'2007-12-05 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226652,226646,'2007-08-29 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226653,226646,'2007-11-14 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226654,226646,'2007-10-03 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226655,226646,'2007-08-22 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226656,226646,'2007-10-31 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226657,226646,'2007-11-07 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226658,226646,'2007-09-19 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226659,226646,'2007-10-10 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226660,226646,'2007-09-12 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226661,226646,'2007-09-26 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226662,226646,'2007-10-24 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226665,226663,'2007-12-06 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226666,226663,'2007-10-04 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226667,226663,'2007-09-11 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226668,226663,'2007-11-08 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226669,226663,'2007-10-02 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226670,226663,'2007-10-23 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226671,226663,'2007-10-16 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226672,226663,'2007-10-18 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226673,226663,'2007-09-25 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226674,226663,'2007-11-13 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226675,226663,'2007-09-04 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226676,226663,'2007-11-27 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226677,226663,'2007-10-11 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226678,226663,'2007-11-29 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226679,226663,'2007-12-04 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226680,226663,'2007-11-06 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226681,226663,'2007-09-06 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226682,226663,'2007-09-18 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226683,226663,'2007-11-20 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226684,226663,'2007-10-30 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226685,226663,'2007-09-13 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226686,226663,'2007-08-23 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226687,226663,'2007-08-28 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226688,226663,'2007-09-20 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226689,226663,'2007-11-01 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226690,226663,'2007-08-30 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226691,226663,'2007-08-21 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226692,226663,'2007-10-25 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226693,226663,'2007-09-27 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226694,226663,'2007-11-15 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(226697,226695,'2007-12-04 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226698,226695,'2007-10-11 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226699,226695,'2007-10-04 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226700,226695,'2007-09-13 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226701,226695,'2007-10-30 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226702,226695,'2007-11-20 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226703,226695,'2007-11-01 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226704,226695,'2007-08-23 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226705,226695,'2007-10-02 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226706,226695,'2007-08-21 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226707,226695,'2007-10-23 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226708,226695,'2007-09-06 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226709,226695,'2007-11-13 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226710,226695,'2007-08-30 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226711,226695,'2007-11-06 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226712,226695,'2007-09-18 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226713,226695,'2007-09-11 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226714,226695,'2007-12-06 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226715,226695,'2007-11-29 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226716,226695,'2007-10-18 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226717,226695,'2007-09-25 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226718,226695,'2007-11-15 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226719,226695,'2007-09-20 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226720,226695,'2007-09-27 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226721,226695,'2007-09-04 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226722,226695,'2007-11-08 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226723,226695,'2007-10-16 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226724,226695,'2007-10-25 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226725,226695,'2007-08-28 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226726,226695,'2007-11-27 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226729,226727,'2007-12-06 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226730,226727,'2007-10-11 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226731,226727,'2007-09-27 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226732,226727,'2007-09-13 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226733,226727,'2007-09-20 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226734,226727,'2007-10-18 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226735,226727,'2007-10-25 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226736,226727,'2007-09-06 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226737,226727,'2007-11-15 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226738,226727,'2007-08-23 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226739,226727,'2007-10-04 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226740,226727,'2007-11-29 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226741,226727,'2007-11-01 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226742,226727,'2007-11-08 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226743,226727,'2007-08-30 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226746,226744,'2007-10-29 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226747,226744,'2007-09-24 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226748,226744,'2007-11-02 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226749,226744,'2007-10-01 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226750,226744,'2007-09-10 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226751,226744,'2007-09-26 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226752,226744,'2007-12-03 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226753,226744,'2007-10-22 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226754,226744,'2007-10-19 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226755,226744,'2007-11-19 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226756,226744,'2007-11-16 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226757,226744,'2007-09-17 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226758,226744,'2007-10-24 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226759,226744,'2007-10-31 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226760,226744,'2007-12-05 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226761,226744,'2007-11-09 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226762,226744,'2007-11-05 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226763,226744,'2007-09-21 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226764,226744,'2007-11-28 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226765,226744,'2007-08-24 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226766,226744,'2007-10-15 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226767,226744,'2007-11-26 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226768,226744,'2007-08-20 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226769,226744,'2007-12-07 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226770,226744,'2007-10-26 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226771,226744,'2007-08-29 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226772,226744,'2007-09-07 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226773,226744,'2007-08-22 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226774,226744,'2007-10-17 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226775,226744,'2007-09-14 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226776,226744,'2007-10-03 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226777,226744,'2007-08-27 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226778,226744,'2007-10-05 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226779,226744,'2007-11-07 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226780,226744,'2007-09-12 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226781,226744,'2007-11-30 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226782,226744,'2007-09-28 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226783,226744,'2007-09-19 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226784,226744,'2007-11-14 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226785,226744,'2007-11-12 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226786,226744,'2007-08-31 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226787,226744,'2007-10-10 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226788,226744,'2007-10-12 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226789,226744,'2007-09-05 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(226792,226790,'2007-09-25 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226793,226790,'2007-10-30 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226794,226790,'2007-10-02 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226795,226790,'2007-08-21 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226796,226790,'2007-10-23 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226797,226790,'2007-08-28 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226798,226790,'2007-12-04 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226799,226790,'2007-09-11 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226800,226790,'2007-11-20 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226801,226790,'2007-09-04 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226802,226790,'2007-09-18 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226803,226790,'2007-11-13 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226804,226790,'2007-10-16 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226805,226790,'2007-11-06 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226806,226790,'2007-11-27 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226809,226807,'2007-10-24 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226810,226807,'2007-09-24 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226811,226807,'2007-09-28 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226812,226807,'2007-09-14 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226813,226807,'2007-10-10 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226814,226807,'2007-11-07 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226815,226807,'2007-10-31 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226816,226807,'2007-10-01 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226817,226807,'2007-11-02 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226818,226807,'2007-10-19 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226819,226807,'2007-08-31 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226820,226807,'2007-10-12 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226821,226807,'2007-11-12 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226822,226807,'2007-08-22 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226823,226807,'2007-11-14 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226824,226807,'2007-08-20 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226825,226807,'2007-10-15 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226826,226807,'2007-09-12 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226827,226807,'2007-11-09 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226828,226807,'2007-11-16 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226829,226807,'2007-12-07 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226830,226807,'2007-10-03 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226831,226807,'2007-09-10 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226832,226807,'2007-12-03 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226833,226807,'2007-10-05 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226834,226807,'2007-11-26 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226835,226807,'2007-11-19 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226836,226807,'2007-09-26 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226837,226807,'2007-08-27 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226838,226807,'2007-08-29 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226839,226807,'2007-09-19 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226840,226807,'2007-09-17 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226841,226807,'2007-08-24 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226842,226807,'2007-11-05 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226843,226807,'2007-10-29 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226844,226807,'2007-09-07 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226845,226807,'2007-12-05 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226846,226807,'2007-11-30 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226847,226807,'2007-09-05 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226848,226807,'2007-10-22 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226849,226807,'2007-10-17 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226850,226807,'2007-10-26 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226851,226807,'2007-11-28 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226852,226807,'2007-09-21 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226855,226853,'2007-11-16 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226856,226853,'2007-10-10 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226857,226853,'2007-08-24 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226858,226853,'2007-09-26 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226859,226853,'2007-10-24 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226860,226853,'2007-11-07 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226861,226853,'2007-09-28 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226862,226853,'2007-09-14 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226863,226853,'2007-10-03 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226864,226853,'2007-10-05 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226865,226853,'2007-10-12 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226866,226853,'2007-11-14 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226867,226853,'2007-09-21 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226868,226853,'2007-08-31 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226869,226853,'2007-09-05 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226870,226853,'2007-11-30 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226871,226853,'2007-11-28 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226872,226853,'2007-09-12 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226873,226853,'2007-10-31 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226874,226853,'2007-08-29 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226875,226853,'2007-10-17 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226876,226853,'2007-12-05 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226877,226853,'2007-09-07 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226878,226853,'2007-10-26 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226879,226853,'2007-09-19 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226880,226853,'2007-11-02 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226881,226853,'2007-12-07 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226882,226853,'2007-08-22 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226883,226853,'2007-10-19 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226884,226853,'2007-11-09 00:00:00',126,0,138,-10,1,0,'2008-05-07',1),
	(226887,226885,'2007-10-26 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226888,226885,'2007-08-31 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226889,226885,'2007-09-14 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226890,226885,'2007-10-19 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226891,226885,'2007-11-19 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226892,226885,'2007-09-24 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226893,226885,'2007-11-28 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226894,226885,'2007-08-24 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226895,226885,'2007-10-05 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226896,226885,'2007-11-07 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226897,226885,'2007-09-28 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226898,226885,'2007-10-24 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226899,226885,'2007-08-22 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226900,226885,'2007-12-03 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226901,226885,'2007-09-10 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226902,226885,'2007-09-05 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226903,226885,'2007-10-12 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226904,226885,'2007-08-20 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226905,226885,'2007-10-03 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226906,226885,'2007-09-12 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226907,226885,'2007-11-30 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226908,226885,'2007-10-17 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226909,226885,'2007-11-05 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226910,226885,'2007-11-02 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226911,226885,'2007-11-16 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226912,226885,'2007-10-31 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226913,226885,'2007-11-14 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226914,226885,'2007-09-19 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226915,226885,'2007-10-29 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226916,226885,'2007-09-07 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226917,226885,'2007-09-17 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226918,226885,'2007-09-21 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226919,226885,'2007-09-26 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226920,226885,'2007-12-07 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226921,226885,'2007-08-29 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226922,226885,'2007-08-27 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226923,226885,'2007-11-26 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226924,226885,'2007-11-12 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226925,226885,'2007-10-01 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226926,226885,'2007-12-05 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226927,226885,'2007-11-09 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226928,226885,'2007-10-22 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226929,226885,'2007-10-15 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226930,226885,'2007-10-10 00:00:00',90,0,102,-10,1,0,'2008-05-07',1),
	(226933,226931,'2007-11-30 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226934,226931,'2007-12-03 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226935,226931,'2007-09-07 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226936,226931,'2007-11-26 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226937,226931,'2007-09-28 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226938,226931,'2007-11-05 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226939,226931,'2007-08-20 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226940,226931,'2007-09-17 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226941,226931,'2007-11-16 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226942,226931,'2007-11-02 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226943,226931,'2007-11-12 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226944,226931,'2007-09-14 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226945,226931,'2007-10-19 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226946,226931,'2007-10-22 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226947,226931,'2007-10-01 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226948,226931,'2007-11-09 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226949,226931,'2007-09-24 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226950,226931,'2007-10-05 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226951,226931,'2007-10-15 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226952,226931,'2007-08-27 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226953,226931,'2007-11-19 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226954,226931,'2007-12-07 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226955,226931,'2007-08-31 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226956,226931,'2007-09-21 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226957,226931,'2007-10-29 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226958,226931,'2007-08-24 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226959,226931,'2007-09-10 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226960,226931,'2007-10-12 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226961,226931,'2007-10-26 00:00:00',138,0,150,-10,1,0,'2008-05-07',1),
	(226964,226962,'2007-11-29 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226965,226962,'2007-09-06 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226966,226962,'2007-09-20 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226967,226962,'2007-09-25 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226968,226962,'2007-10-04 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226969,226962,'2007-11-06 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226970,226962,'2007-08-23 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226971,226962,'2007-10-16 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226972,226962,'2007-09-18 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226973,226962,'2007-08-30 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226974,226962,'2007-08-28 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226975,226962,'2007-10-18 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226976,226962,'2007-11-13 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226977,226962,'2007-11-08 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226978,226962,'2007-12-04 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226979,226962,'2007-12-06 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226980,226962,'2007-09-27 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226981,226962,'2007-10-02 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226982,226962,'2007-10-11 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226983,226962,'2007-10-30 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226984,226962,'2007-09-04 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226985,226962,'2007-11-27 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226986,226962,'2007-09-11 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226987,226962,'2007-10-23 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226988,226962,'2007-08-21 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226989,226962,'2007-09-13 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226990,226962,'2007-11-15 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226991,226962,'2007-11-20 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226992,226962,'2007-10-25 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226993,226962,'2007-11-01 00:00:00',150,0,162,-10,1,0,'2008-05-07',1),
	(226996,226994,'2007-10-15 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(226997,226994,'2007-12-03 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(226998,226994,'2007-10-22 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(226999,226994,'2007-11-12 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227000,226994,'2007-09-17 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227001,226994,'2007-08-20 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227002,226994,'2007-09-10 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227003,226994,'2007-10-29 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227004,226994,'2007-10-01 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227005,226994,'2007-08-27 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227006,226994,'2007-09-24 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227007,226994,'2007-11-19 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227008,226994,'2007-11-05 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227009,226994,'2007-11-26 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227012,227010,'2007-12-04 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227013,227010,'2007-11-27 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227014,227010,'2007-08-27 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227015,227010,'2007-09-10 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227016,227010,'2007-09-06 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227017,227010,'2007-10-25 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227018,227010,'2007-11-15 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227019,227010,'2007-08-31 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227020,227010,'2007-08-20 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227021,227010,'2007-08-23 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227022,227010,'2007-11-09 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227023,227010,'2007-11-13 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227024,227010,'2007-09-12 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227025,227010,'2007-11-14 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227026,227010,'2007-11-02 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227027,227010,'2007-11-05 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227028,227010,'2007-12-03 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227029,227010,'2007-09-28 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227030,227010,'2007-09-25 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227031,227010,'2007-12-07 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227032,227010,'2007-08-22 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227033,227010,'2007-10-01 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227034,227010,'2007-10-12 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227035,227010,'2007-09-18 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227036,227010,'2007-10-11 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227037,227010,'2007-11-30 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227038,227010,'2007-11-28 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227039,227010,'2007-09-05 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227040,227010,'2007-10-04 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227041,227010,'2007-09-07 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227042,227010,'2007-10-26 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227043,227010,'2007-08-21 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227044,227010,'2007-10-23 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227045,227010,'2007-11-08 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227046,227010,'2007-09-14 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227047,227010,'2007-11-26 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227048,227010,'2007-10-05 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227049,227010,'2007-10-15 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227050,227010,'2007-11-19 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227051,227010,'2007-08-29 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227052,227010,'2007-09-13 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227053,227010,'2007-11-07 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227054,227010,'2007-11-20 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227055,227010,'2007-10-24 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227056,227010,'2007-11-06 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227057,227010,'2007-10-31 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227058,227010,'2007-10-19 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227059,227010,'2007-10-22 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227060,227010,'2007-09-20 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227061,227010,'2007-08-30 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227062,227010,'2007-10-16 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227063,227010,'2007-10-30 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227064,227010,'2007-10-18 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227065,227010,'2007-08-24 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227066,227010,'2007-09-04 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227067,227010,'2007-09-26 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227068,227010,'2007-10-29 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227069,227010,'2007-12-06 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227070,227010,'2007-11-16 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227071,227010,'2007-10-10 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227072,227010,'2007-12-05 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227073,227010,'2007-09-27 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227074,227010,'2007-09-21 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227075,227010,'2007-09-19 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227076,227010,'2007-11-12 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227077,227010,'2007-10-03 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227078,227010,'2007-10-17 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227079,227010,'2007-09-11 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227080,227010,'2007-08-28 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227081,227010,'2007-11-29 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227082,227010,'2007-09-17 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227083,227010,'2007-11-01 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227084,227010,'2007-10-02 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227085,227010,'2007-09-24 00:00:00',186,0,210,-10,1,0,'2008-05-07',1),
	(227088,227086,'2007-11-05 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227089,227086,'2007-11-12 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227090,227086,'2007-09-24 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227091,227086,'2007-11-19 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227092,227086,'2007-10-01 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227093,227086,'2007-08-27 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227094,227086,'2007-10-29 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227095,227086,'2007-09-26 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227096,227086,'2007-10-10 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227097,227086,'2007-09-10 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227098,227086,'2007-11-14 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227099,227086,'2007-08-20 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227100,227086,'2007-11-28 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227101,227086,'2007-12-05 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227102,227086,'2007-09-19 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227103,227086,'2007-09-05 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227104,227086,'2007-10-17 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227105,227086,'2007-11-26 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227106,227086,'2007-08-29 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227107,227086,'2007-11-07 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227108,227086,'2007-09-12 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227109,227086,'2007-08-22 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227110,227086,'2007-10-24 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227111,227086,'2007-10-15 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227112,227086,'2007-10-31 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227113,227086,'2007-09-17 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227114,227086,'2007-10-22 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227115,227086,'2007-10-03 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227116,227086,'2007-12-03 00:00:00',114,0,126,-10,1,0,'2008-05-07',1),
	(227119,227117,'2007-10-26 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227120,227117,'2007-11-02 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227121,227117,'2007-10-24 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227122,227117,'2007-10-19 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227123,227117,'2007-09-26 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227124,227117,'2007-09-12 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227125,227117,'2007-09-28 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227126,227117,'2007-10-31 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227127,227117,'2007-10-05 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227128,227117,'2007-09-14 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227129,227117,'2007-10-10 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227130,227117,'2007-09-21 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227131,227117,'2007-11-16 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227132,227117,'2007-11-07 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227133,227117,'2007-12-07 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227134,227117,'2007-10-12 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227135,227117,'2007-10-17 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227136,227117,'2007-08-31 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227137,227117,'2007-11-14 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227138,227117,'2007-09-05 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227139,227117,'2007-09-19 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227140,227117,'2007-12-05 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227141,227117,'2007-08-24 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227142,227117,'2007-11-28 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227143,227117,'2007-10-03 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227144,227117,'2007-11-30 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227145,227117,'2007-11-09 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227146,227117,'2007-08-29 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227147,227117,'2007-08-22 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227148,227117,'2007-09-07 00:00:00',102,0,114,-10,1,0,'2008-05-07',1),
	(227151,227149,'2007-11-26 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227152,227149,'2007-09-21 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227153,227149,'2007-09-05 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227154,227149,'2007-08-22 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227155,227149,'2007-11-16 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227156,227149,'2007-09-26 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227157,227149,'2007-08-24 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227158,227149,'2007-09-10 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227159,227149,'2007-08-29 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227160,227149,'2007-10-19 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227161,227149,'2007-09-24 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227162,227149,'2007-08-20 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227163,227149,'2007-10-31 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227164,227149,'2007-10-24 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227165,227149,'2007-10-03 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227166,227149,'2007-11-09 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227167,227149,'2007-11-02 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227168,227149,'2007-10-17 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227169,227149,'2007-11-28 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227170,227149,'2007-11-07 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227171,227149,'2007-10-29 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227172,227149,'2007-10-05 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227173,227149,'2007-10-26 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227174,227149,'2007-09-17 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227175,227149,'2007-08-31 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227176,227149,'2007-10-01 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227177,227149,'2007-09-19 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227178,227149,'2007-10-12 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227179,227149,'2007-11-05 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227180,227149,'2007-09-28 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227181,227149,'2007-09-07 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227182,227149,'2007-11-14 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227183,227149,'2007-11-19 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227184,227149,'2007-10-22 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227185,227149,'2007-08-27 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227186,227149,'2007-12-07 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227187,227149,'2007-09-14 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227188,227149,'2007-10-10 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227189,227149,'2007-12-03 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227190,227149,'2007-09-12 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227191,227149,'2007-10-15 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227192,227149,'2007-12-05 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227193,227149,'2007-11-12 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227194,227149,'2007-11-30 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(227197,227195,'2007-10-16 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227198,227195,'2007-08-21 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227199,227195,'2007-12-04 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227200,227195,'2007-11-13 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227201,227195,'2007-09-18 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227202,227195,'2007-09-13 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227203,227195,'2007-09-27 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227204,227195,'2007-08-23 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227205,227195,'2007-11-29 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227206,227195,'2007-11-27 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227207,227195,'2007-09-20 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227208,227195,'2007-09-06 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227209,227195,'2007-09-04 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227210,227195,'2007-08-28 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227211,227195,'2007-11-08 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227212,227195,'2007-10-30 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227213,227195,'2007-10-02 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227214,227195,'2007-10-25 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227215,227195,'2007-10-11 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227216,227195,'2007-09-25 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227217,227195,'2007-11-01 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227218,227195,'2007-11-15 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227219,227195,'2007-11-20 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227220,227195,'2007-10-18 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227221,227195,'2007-10-23 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227222,227195,'2007-11-06 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227223,227195,'2007-09-11 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227224,227195,'2007-08-30 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227225,227195,'2007-10-04 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227226,227195,'2007-12-06 00:00:00',90,0,108,-15,1,0,'2008-05-07',1),
	(227229,227227,'2007-10-17 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227230,227227,'2007-09-24 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227231,227227,'2007-09-21 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227232,227227,'2007-08-31 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227233,227227,'2007-11-14 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227234,227227,'2007-09-14 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227235,227227,'2007-08-27 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227236,227227,'2007-08-20 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227237,227227,'2007-09-28 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227238,227227,'2007-10-12 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227239,227227,'2007-08-22 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227240,227227,'2007-08-29 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227241,227227,'2007-11-07 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227242,227227,'2007-10-22 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227243,227227,'2007-10-10 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227244,227227,'2007-09-05 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227245,227227,'2007-11-26 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227246,227227,'2007-11-02 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227247,227227,'2007-09-07 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227248,227227,'2007-12-05 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227249,227227,'2007-10-26 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227250,227227,'2007-09-19 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227251,227227,'2007-11-05 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227252,227227,'2007-10-15 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227253,227227,'2007-11-19 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227254,227227,'2007-10-24 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227255,227227,'2007-09-26 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227256,227227,'2007-11-12 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227257,227227,'2007-09-12 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227258,227227,'2007-11-09 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227259,227227,'2007-09-17 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227260,227227,'2007-10-19 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227261,227227,'2007-10-31 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227262,227227,'2007-10-29 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227263,227227,'2007-11-28 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227264,227227,'2007-10-01 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227265,227227,'2007-10-03 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227266,227227,'2007-11-30 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227267,227227,'2007-10-05 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227268,227227,'2007-11-16 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227269,227227,'2007-08-24 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227270,227227,'2007-12-03 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227271,227227,'2007-09-10 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227272,227227,'2007-12-07 00:00:00',114,0,126,-10,4,0,'2008-05-07',1),
	(227275,227273,'2007-10-10 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227276,227273,'2007-10-29 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227277,227273,'2007-12-07 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227278,227273,'2007-08-22 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227279,227273,'2007-09-26 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227280,227273,'2007-09-05 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227281,227273,'2007-11-14 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227282,227273,'2007-09-21 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227283,227273,'2007-09-19 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227284,227273,'2007-09-17 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227285,227273,'2007-11-28 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227286,227273,'2007-11-30 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227287,227273,'2007-12-03 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227288,227273,'2007-11-16 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227289,227273,'2007-08-24 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227290,227273,'2007-08-20 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227291,227273,'2007-11-02 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227292,227273,'2007-10-15 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227293,227273,'2007-11-05 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227294,227273,'2007-10-19 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227295,227273,'2007-09-24 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227296,227273,'2007-11-07 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227297,227273,'2007-09-28 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227298,227273,'2007-09-10 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227299,227273,'2007-11-19 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227300,227273,'2007-10-17 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227301,227273,'2007-10-24 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227302,227273,'2007-10-26 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227303,227273,'2007-09-12 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227304,227273,'2007-09-14 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227305,227273,'2007-08-27 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227306,227273,'2007-11-26 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227307,227273,'2007-11-12 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227308,227273,'2007-11-09 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227309,227273,'2007-10-12 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227310,227273,'2007-08-31 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227311,227273,'2007-10-03 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227312,227273,'2007-10-22 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227313,227273,'2007-09-07 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227314,227273,'2007-10-01 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227315,227273,'2007-12-05 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227316,227273,'2007-10-05 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227317,227273,'2007-08-29 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227318,227273,'2007-10-31 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227321,227319,'2007-09-13 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227322,227319,'2007-08-23 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227323,227319,'2007-10-18 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227324,227319,'2007-11-08 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227325,227319,'2007-10-04 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227326,227319,'2007-09-06 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227327,227319,'2007-11-29 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227328,227319,'2007-09-27 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227329,227319,'2007-12-06 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227330,227319,'2007-09-20 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227331,227319,'2007-10-11 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227332,227319,'2007-11-01 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227333,227319,'2007-08-30 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227334,227319,'2007-10-25 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227335,227319,'2007-11-15 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227338,227336,'2007-10-26 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227339,227336,'2007-09-12 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227340,227336,'2007-09-07 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227341,227336,'2007-10-31 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227342,227336,'2007-10-29 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227343,227336,'2007-11-07 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227344,227336,'2007-10-24 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227345,227336,'2007-08-22 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227346,227336,'2007-09-24 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227347,227336,'2007-11-14 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227348,227336,'2007-09-28 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227349,227336,'2007-11-05 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227350,227336,'2007-09-21 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227351,227336,'2007-10-19 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227352,227336,'2007-09-26 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227353,227336,'2007-09-17 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227354,227336,'2007-08-20 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227355,227336,'2007-11-19 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227356,227336,'2007-11-02 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227357,227336,'2007-10-10 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227358,227336,'2007-10-05 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227359,227336,'2007-08-24 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227360,227336,'2007-10-17 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227361,227336,'2007-09-10 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227362,227336,'2007-08-31 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227363,227336,'2007-11-09 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227364,227336,'2007-12-03 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227365,227336,'2007-08-27 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227366,227336,'2007-12-07 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227367,227336,'2007-09-19 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227368,227336,'2007-10-03 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227369,227336,'2007-11-12 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227370,227336,'2007-08-29 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227371,227336,'2007-10-15 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227372,227336,'2007-11-28 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227373,227336,'2007-11-26 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227374,227336,'2007-09-14 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227375,227336,'2007-09-05 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227376,227336,'2007-10-01 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227377,227336,'2007-11-16 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227378,227336,'2007-10-22 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227379,227336,'2007-10-12 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227380,227336,'2007-11-30 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227381,227336,'2007-12-05 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227384,227382,'2007-08-20 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227385,227382,'2007-10-01 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227386,227382,'2007-10-22 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227387,227382,'2007-11-05 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227388,227382,'2007-11-26 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227389,227382,'2007-09-17 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227390,227382,'2007-09-24 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227391,227382,'2007-09-10 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227392,227382,'2007-12-03 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227393,227382,'2007-11-19 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227394,227382,'2007-08-27 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227395,227382,'2007-10-29 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227396,227382,'2007-10-15 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227397,227382,'2007-11-12 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227400,227398,'2007-09-19 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227401,227398,'2007-10-12 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227402,227398,'2007-11-19 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227403,227398,'2007-11-05 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227404,227398,'2007-12-03 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227405,227398,'2007-08-24 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227406,227398,'2007-10-03 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227407,227398,'2007-10-19 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227408,227398,'2007-11-14 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227409,227398,'2007-09-28 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227410,227398,'2007-11-26 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227411,227398,'2007-10-17 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227412,227398,'2007-09-26 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227413,227398,'2007-08-22 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227414,227398,'2007-09-17 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227415,227398,'2007-11-07 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227416,227398,'2007-09-12 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227417,227398,'2007-11-12 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227418,227398,'2007-09-14 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227419,227398,'2007-08-27 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227420,227398,'2007-09-10 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227421,227398,'2007-10-01 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227422,227398,'2007-08-31 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227423,227398,'2007-11-16 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227424,227398,'2007-10-24 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227425,227398,'2007-11-30 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227426,227398,'2007-10-22 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227427,227398,'2007-09-24 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227428,227398,'2007-08-20 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227429,227398,'2007-10-26 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227430,227398,'2007-11-09 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227431,227398,'2007-11-02 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227432,227398,'2007-12-05 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227433,227398,'2007-12-07 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227434,227398,'2007-09-05 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227435,227398,'2007-08-29 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227436,227398,'2007-09-07 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227437,227398,'2007-10-10 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227438,227398,'2007-10-31 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227439,227398,'2007-09-21 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227440,227398,'2007-10-15 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227441,227398,'2007-11-28 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227442,227398,'2007-10-29 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227443,227398,'2007-10-05 00:00:00',162,0,174,-10,3,0,'2008-05-07',1),
	(227446,227444,'2007-09-11 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227447,227444,'2007-10-02 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227448,227444,'2007-11-13 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227449,227444,'2007-10-23 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227450,227444,'2007-09-25 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227451,227444,'2007-09-18 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227452,227444,'2007-12-04 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227453,227444,'2007-10-30 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227454,227444,'2007-09-04 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227455,227444,'2007-11-27 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227456,227444,'2007-08-21 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227457,227444,'2007-10-16 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227458,227444,'2007-11-20 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227459,227444,'2007-08-28 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227460,227444,'2007-11-06 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227463,227461,'2007-08-21 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227464,227461,'2007-10-16 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227465,227461,'2007-09-04 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227466,227461,'2007-08-28 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227467,227461,'2007-09-25 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227468,227461,'2007-11-27 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227469,227461,'2007-11-20 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227470,227461,'2007-12-04 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227471,227461,'2007-10-23 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227472,227461,'2007-11-13 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227473,227461,'2007-11-06 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227474,227461,'2007-10-30 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227475,227461,'2007-09-11 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227476,227461,'2007-10-02 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227477,227461,'2007-09-18 00:00:00',138,0,150,-10,4,0,'2008-05-07',1),
	(227480,227478,'2007-10-05 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227481,227478,'2007-08-31 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227482,227478,'2007-11-30 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227483,227478,'2007-09-21 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227484,227478,'2007-09-14 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227485,227478,'2007-10-26 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227486,227478,'2007-09-07 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227487,227478,'2007-12-07 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227488,227478,'2007-10-12 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227489,227478,'2007-10-19 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227490,227478,'2007-11-09 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227491,227478,'2007-09-28 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227492,227478,'2007-08-24 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227493,227478,'2007-11-16 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227494,227478,'2007-11-02 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(227497,227495,'2007-11-28 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227498,227495,'2007-08-22 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227499,227495,'2007-10-10 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227500,227495,'2007-08-29 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227501,227495,'2007-10-24 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227502,227495,'2007-09-05 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227503,227495,'2007-09-19 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227504,227495,'2007-09-26 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227505,227495,'2007-11-07 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227506,227495,'2007-11-14 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227507,227495,'2007-09-12 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227508,227495,'2007-10-31 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227509,227495,'2007-10-03 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227510,227495,'2007-10-17 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227511,227495,'2007-12-05 00:00:00',90,0,102,-10,4,0,'2008-05-07',1),
	(227514,227512,'2007-10-05 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227515,227512,'2007-11-12 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227516,227512,'2007-09-24 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227517,227512,'2007-11-02 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227518,227512,'2007-11-09 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227519,227512,'2007-10-15 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227520,227512,'2007-10-24 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227521,227512,'2007-08-31 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227522,227512,'2007-10-29 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227523,227512,'2007-09-12 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227524,227512,'2007-10-31 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227525,227512,'2007-08-20 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227526,227512,'2007-09-07 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227527,227512,'2007-09-05 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227528,227512,'2007-08-27 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227529,227512,'2007-11-19 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227530,227512,'2007-10-10 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227531,227512,'2007-10-12 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227532,227512,'2007-12-03 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227533,227512,'2007-11-16 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227534,227512,'2007-08-24 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227535,227512,'2007-09-26 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227536,227512,'2007-12-05 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227537,227512,'2007-09-21 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227538,227512,'2007-10-19 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227539,227512,'2007-11-07 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227540,227512,'2007-12-07 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227541,227512,'2007-10-17 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227542,227512,'2007-09-14 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227543,227512,'2007-08-22 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227544,227512,'2007-11-28 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227545,227512,'2007-10-26 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227546,227512,'2007-11-14 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227547,227512,'2007-11-05 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227548,227512,'2007-09-28 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227549,227512,'2007-10-03 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227550,227512,'2007-09-19 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227551,227512,'2007-09-10 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227552,227512,'2007-10-22 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227553,227512,'2007-08-29 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227554,227512,'2007-11-26 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227555,227512,'2007-11-30 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227556,227512,'2007-10-01 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227557,227512,'2007-09-17 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(227560,227558,'2007-11-15 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227561,227558,'2007-08-23 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227562,227558,'2007-10-04 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227563,227558,'2007-09-13 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227564,227558,'2007-09-27 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227565,227558,'2007-12-06 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227566,227558,'2007-09-06 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227567,227558,'2007-10-25 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227568,227558,'2007-10-18 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227569,227558,'2007-11-29 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227570,227558,'2007-10-11 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227571,227558,'2007-09-20 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227572,227558,'2007-11-01 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227573,227558,'2007-11-08 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227574,227558,'2007-08-30 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(227577,227575,'2007-11-20 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227578,227575,'2007-10-02 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227579,227575,'2007-08-28 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227580,227575,'2007-11-27 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227581,227575,'2007-12-04 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227582,227575,'2007-09-04 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227583,227575,'2007-09-18 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227584,227575,'2007-09-11 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227585,227575,'2007-09-25 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227586,227575,'2007-10-23 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227587,227575,'2007-11-13 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227588,227575,'2007-10-30 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227589,227575,'2007-10-16 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227590,227575,'2007-11-06 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227591,227575,'2007-08-21 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(227594,227592,'2007-10-24 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227595,227592,'2007-09-12 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227596,227592,'2007-09-07 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227597,227592,'2007-09-21 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227598,227592,'2007-11-30 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227599,227592,'2007-11-09 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227600,227592,'2007-10-19 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227601,227592,'2007-09-19 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227602,227592,'2007-12-03 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227603,227592,'2007-10-26 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227604,227592,'2007-09-17 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227605,227592,'2007-08-29 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227606,227592,'2007-10-22 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227607,227592,'2007-11-14 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227608,227592,'2007-10-29 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227609,227592,'2007-11-28 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227610,227592,'2007-12-07 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227611,227592,'2007-11-05 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227612,227592,'2007-11-02 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227613,227592,'2007-08-20 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227614,227592,'2007-10-31 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227615,227592,'2007-09-05 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227616,227592,'2007-10-15 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227617,227592,'2007-10-10 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227618,227592,'2007-10-05 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227619,227592,'2007-08-24 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227620,227592,'2007-12-05 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227621,227592,'2007-11-16 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227622,227592,'2007-09-10 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227623,227592,'2007-10-17 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227624,227592,'2007-11-07 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227625,227592,'2007-10-03 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227626,227592,'2007-08-22 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227627,227592,'2007-11-19 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227628,227592,'2007-08-31 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227629,227592,'2007-10-01 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227630,227592,'2007-11-26 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227631,227592,'2007-09-24 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227632,227592,'2007-11-12 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227633,227592,'2007-09-14 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227634,227592,'2007-09-28 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227635,227592,'2007-08-27 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227636,227592,'2007-09-26 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227637,227592,'2007-10-12 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(227640,227638,'2007-09-05 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227641,227638,'2007-12-05 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227642,227638,'2007-08-20 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227643,227638,'2007-09-26 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227644,227638,'2007-11-19 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227645,227638,'2007-10-19 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227646,227638,'2007-11-07 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227647,227638,'2007-11-14 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227648,227638,'2007-09-19 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227649,227638,'2007-10-17 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227650,227638,'2007-11-26 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227651,227638,'2007-11-16 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227652,227638,'2007-12-07 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227653,227638,'2007-08-22 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227654,227638,'2007-10-24 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227655,227638,'2007-10-03 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227656,227638,'2007-10-26 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227657,227638,'2007-09-28 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227658,227638,'2007-09-21 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227659,227638,'2007-10-01 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227660,227638,'2007-09-17 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227661,227638,'2007-09-10 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227662,227638,'2007-08-24 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227663,227638,'2007-10-05 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227664,227638,'2007-10-22 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227665,227638,'2007-12-03 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227666,227638,'2007-10-31 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227667,227638,'2007-09-14 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227668,227638,'2007-09-12 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227669,227638,'2007-09-07 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227670,227638,'2007-08-31 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227671,227638,'2007-10-12 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227672,227638,'2007-11-30 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227673,227638,'2007-11-28 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227674,227638,'2007-10-10 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227675,227638,'2007-10-15 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227676,227638,'2007-11-05 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227677,227638,'2007-08-29 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227678,227638,'2007-09-24 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227679,227638,'2007-11-02 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227680,227638,'2007-11-09 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227681,227638,'2007-10-29 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227682,227638,'2007-08-27 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227683,227638,'2007-11-12 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(227686,227684,'2007-10-29 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227687,227684,'2007-09-19 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227688,227684,'2007-08-29 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227689,227684,'2007-09-10 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227690,227684,'2007-08-20 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227691,227684,'2007-11-12 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227692,227684,'2007-12-07 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227693,227684,'2007-08-31 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227694,227684,'2007-10-17 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227695,227684,'2007-10-24 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227696,227684,'2007-11-02 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227697,227684,'2007-10-31 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227698,227684,'2007-09-12 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227699,227684,'2007-10-26 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227700,227684,'2007-11-05 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227701,227684,'2007-11-09 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227702,227684,'2007-09-21 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227703,227684,'2007-10-10 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227704,227684,'2007-11-30 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227705,227684,'2007-11-26 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227706,227684,'2007-10-22 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227707,227684,'2007-09-24 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227708,227684,'2007-10-12 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227709,227684,'2007-10-03 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227710,227684,'2007-09-26 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227711,227684,'2007-12-03 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227712,227684,'2007-08-27 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227713,227684,'2007-11-14 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227714,227684,'2007-10-15 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227715,227684,'2007-09-17 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227716,227684,'2007-09-28 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227717,227684,'2007-09-14 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227718,227684,'2007-12-05 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227719,227684,'2007-08-24 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227720,227684,'2007-11-07 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227721,227684,'2007-10-05 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227722,227684,'2007-11-19 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227723,227684,'2007-11-16 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227724,227684,'2007-10-01 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227725,227684,'2007-09-05 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227726,227684,'2007-09-07 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227727,227684,'2007-08-22 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227728,227684,'2007-11-28 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227729,227684,'2007-10-19 00:00:00',198,0,210,-10,2,0,'2008-05-07',1),
	(227732,227730,'2007-09-07 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227733,227730,'2007-09-26 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227734,227730,'2007-10-31 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227735,227730,'2007-09-14 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227736,227730,'2007-11-12 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227737,227730,'2007-11-16 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227738,227730,'2007-08-22 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227739,227730,'2007-10-01 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227740,227730,'2007-09-19 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227741,227730,'2007-08-27 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227742,227730,'2007-10-29 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227743,227730,'2007-10-15 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227744,227730,'2007-10-19 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227745,227730,'2007-09-05 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227746,227730,'2007-12-07 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227747,227730,'2007-11-07 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227748,227730,'2007-09-24 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227749,227730,'2007-08-24 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227750,227730,'2007-11-28 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227751,227730,'2007-11-02 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227752,227730,'2007-09-28 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227753,227730,'2007-10-03 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227754,227730,'2007-11-05 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227755,227730,'2007-10-05 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227756,227730,'2007-11-30 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227757,227730,'2007-09-12 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227758,227730,'2007-08-20 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227759,227730,'2007-10-24 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227760,227730,'2007-08-31 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227761,227730,'2007-11-09 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227762,227730,'2007-10-22 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227763,227730,'2007-10-10 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227764,227730,'2007-11-26 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227765,227730,'2007-08-29 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227766,227730,'2007-11-19 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227767,227730,'2007-10-26 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227768,227730,'2007-12-03 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227769,227730,'2007-09-21 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227770,227730,'2007-09-17 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227771,227730,'2007-09-10 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227772,227730,'2007-12-05 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227773,227730,'2007-11-14 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227774,227730,'2007-10-17 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227775,227730,'2007-10-12 00:00:00',186,0,198,-10,3,0,'2008-05-07',1),
	(227778,227776,'2007-10-22 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227779,227776,'2007-11-05 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227780,227776,'2007-12-07 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227781,227776,'2007-08-22 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227782,227776,'2007-10-03 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227783,227776,'2007-10-05 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227784,227776,'2007-10-19 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227785,227776,'2007-08-24 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227786,227776,'2007-09-28 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227787,227776,'2007-10-24 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227788,227776,'2007-09-07 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227789,227776,'2007-10-15 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227790,227776,'2007-12-03 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227791,227776,'2007-11-12 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227792,227776,'2007-10-31 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227793,227776,'2007-09-05 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227794,227776,'2007-08-20 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227795,227776,'2007-10-01 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227796,227776,'2007-09-14 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227797,227776,'2007-11-28 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227798,227776,'2007-10-29 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227799,227776,'2007-12-05 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227800,227776,'2007-11-16 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227801,227776,'2007-11-09 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227802,227776,'2007-10-10 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227803,227776,'2007-11-30 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227804,227776,'2007-11-19 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227805,227776,'2007-08-29 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227806,227776,'2007-09-26 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227807,227776,'2007-09-19 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227808,227776,'2007-10-12 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227809,227776,'2007-10-17 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227810,227776,'2007-09-21 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227811,227776,'2007-09-10 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227812,227776,'2007-11-02 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227813,227776,'2007-09-12 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227814,227776,'2007-11-26 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227815,227776,'2007-09-17 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227816,227776,'2007-09-24 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227817,227776,'2007-11-14 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227818,227776,'2007-10-26 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227819,227776,'2007-11-07 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227820,227776,'2007-08-27 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227821,227776,'2007-08-31 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(227824,227822,'2007-10-04 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227825,227822,'2007-11-08 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227826,227822,'2007-12-06 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227827,227822,'2007-10-11 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227828,227822,'2007-09-27 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227829,227822,'2007-10-18 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227830,227822,'2007-09-20 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227831,227822,'2007-09-06 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227832,227822,'2007-11-15 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227833,227822,'2007-10-25 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227834,227822,'2007-08-30 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227835,227822,'2007-11-29 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227836,227822,'2007-09-13 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227837,227822,'2007-11-01 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227838,227822,'2007-08-23 00:00:00',138,0,162,-10,7,0,'2008-05-07',1),
	(227841,227839,'2007-08-29 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227842,227839,'2007-09-26 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227843,227839,'2007-08-22 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227844,227839,'2007-09-19 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227845,227839,'2007-09-12 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227846,227839,'2007-10-31 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227847,227839,'2007-11-14 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227848,227839,'2007-12-05 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227849,227839,'2007-10-17 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227850,227839,'2007-10-03 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227851,227839,'2007-10-24 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227852,227839,'2007-11-28 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227853,227839,'2007-09-05 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227854,227839,'2007-10-10 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227855,227839,'2007-11-07 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(227858,227856,'2007-10-17 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227859,227856,'2007-09-12 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227860,227856,'2007-09-26 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227861,227856,'2007-11-14 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227862,227856,'2007-08-29 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227863,227856,'2007-08-22 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227864,227856,'2007-11-07 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227865,227856,'2007-09-05 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227866,227856,'2007-10-31 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227867,227856,'2007-10-10 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227868,227856,'2007-11-28 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227869,227856,'2007-09-19 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227870,227856,'2007-10-24 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227871,227856,'2007-12-05 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227872,227856,'2007-10-03 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(227875,227873,'2007-09-20 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227876,227873,'2007-12-06 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227877,227873,'2007-09-13 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227878,227873,'2007-11-01 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227879,227873,'2007-11-29 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227880,227873,'2007-08-30 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227881,227873,'2007-09-27 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227882,227873,'2007-10-04 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227883,227873,'2007-10-25 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227884,227873,'2007-10-18 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227885,227873,'2007-10-11 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227886,227873,'2007-11-15 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227887,227873,'2007-08-23 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227888,227873,'2007-11-08 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227889,227873,'2007-09-06 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227892,227890,'2007-09-21 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227893,227890,'2007-12-07 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227894,227890,'2007-11-30 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227895,227890,'2007-10-19 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227896,227890,'2007-11-02 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227897,227890,'2007-08-31 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227898,227890,'2007-08-24 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227899,227890,'2007-10-12 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227900,227890,'2007-09-14 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227901,227890,'2007-10-26 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227902,227890,'2007-11-16 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227903,227890,'2007-11-09 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227904,227890,'2007-09-28 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227905,227890,'2007-09-07 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227906,227890,'2007-10-05 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(227909,227907,'2007-09-12 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227910,227907,'2007-09-05 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227911,227907,'2007-11-14 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227912,227907,'2007-10-24 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227913,227907,'2007-09-26 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227914,227907,'2007-11-28 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227915,227907,'2007-10-10 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227916,227907,'2007-11-07 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227917,227907,'2007-08-29 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227918,227907,'2007-09-19 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227919,227907,'2007-10-31 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227920,227907,'2007-12-05 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227921,227907,'2007-10-17 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227922,227907,'2007-08-22 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227923,227907,'2007-10-03 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(227926,227924,'2007-11-28 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227927,227924,'2007-10-24 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227928,227924,'2007-11-14 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227929,227924,'2007-12-05 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227930,227924,'2007-09-26 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227931,227924,'2007-09-19 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227932,227924,'2007-08-29 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227933,227924,'2007-09-12 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227934,227924,'2007-08-22 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227935,227924,'2007-11-07 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227936,227924,'2007-10-03 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227937,227924,'2007-10-10 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227938,227924,'2007-10-17 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227939,227924,'2007-09-05 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227940,227924,'2007-10-31 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(227943,227941,'2007-12-05 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227944,227941,'2007-10-17 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227945,227941,'2007-10-31 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227946,227941,'2007-08-22 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227947,227941,'2007-10-10 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227948,227941,'2007-09-12 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227949,227941,'2007-09-19 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227950,227941,'2007-09-26 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227951,227941,'2007-10-24 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227952,227941,'2007-09-05 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227953,227941,'2007-11-07 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227954,227941,'2007-08-29 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227955,227941,'2007-11-28 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227956,227941,'2007-11-14 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227957,227941,'2007-10-03 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227960,227958,'2007-11-30 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227961,227958,'2007-08-31 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227962,227958,'2007-11-02 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227963,227958,'2007-10-12 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227964,227958,'2007-09-07 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227965,227958,'2007-09-21 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227966,227958,'2007-11-09 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227967,227958,'2007-11-16 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227968,227958,'2007-09-28 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227969,227958,'2007-10-26 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227970,227958,'2007-12-07 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227971,227958,'2007-10-05 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227972,227958,'2007-09-14 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227973,227958,'2007-10-19 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227974,227958,'2007-08-24 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(227977,227975,'2007-09-26 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227978,227975,'2007-10-10 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227979,227975,'2007-11-14 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227980,227975,'2007-12-05 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227981,227975,'2007-09-05 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227982,227975,'2007-10-17 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227983,227975,'2007-09-19 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227984,227975,'2007-08-22 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227985,227975,'2007-11-07 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227986,227975,'2007-11-28 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227987,227975,'2007-09-12 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227988,227975,'2007-08-29 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227989,227975,'2007-10-31 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227990,227975,'2007-10-03 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227991,227975,'2007-10-24 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(227994,227992,'2007-09-17 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(227995,227992,'2007-11-28 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(227996,227992,'2007-10-03 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(227997,227992,'2007-10-15 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(227998,227992,'2007-11-26 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(227999,227992,'2007-09-10 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228000,227992,'2007-08-31 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228001,227992,'2007-10-12 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228002,227992,'2007-10-10 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228003,227992,'2007-12-05 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228004,227992,'2007-11-14 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228005,227992,'2007-12-07 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228006,227992,'2007-12-03 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228007,227992,'2007-11-16 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228008,227992,'2007-09-12 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228009,227992,'2007-10-17 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228010,227992,'2007-10-22 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228011,227992,'2007-09-05 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228012,227992,'2007-08-24 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228013,227992,'2007-11-12 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228014,227992,'2007-09-26 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228015,227992,'2007-09-24 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228016,227992,'2007-11-09 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228017,227992,'2007-10-01 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228018,227992,'2007-08-27 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228019,227992,'2007-09-21 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228020,227992,'2007-10-19 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228021,227992,'2007-10-29 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228022,227992,'2007-09-19 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228023,227992,'2007-09-14 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228024,227992,'2007-08-20 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228025,227992,'2007-11-30 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228026,227992,'2007-11-05 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228027,227992,'2007-08-29 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228028,227992,'2007-11-07 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228029,227992,'2007-10-26 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228030,227992,'2007-11-19 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228031,227992,'2007-11-02 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228032,227992,'2007-10-05 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228033,227992,'2007-09-07 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228034,227992,'2007-10-31 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228035,227992,'2007-08-22 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228036,227992,'2007-09-28 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228037,227992,'2007-10-24 00:00:00',114,0,126,-10,2,0,'2008-05-07',1),
	(228040,228038,'2007-11-20 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228041,228038,'2007-09-18 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228042,228038,'2007-08-28 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228043,228038,'2007-10-23 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228044,228038,'2007-11-13 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228045,228038,'2007-10-16 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228046,228038,'2007-10-30 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228047,228038,'2007-11-06 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228048,228038,'2007-09-04 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228049,228038,'2007-11-27 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228050,228038,'2007-12-04 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228051,228038,'2007-09-11 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228052,228038,'2007-09-25 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228053,228038,'2007-10-02 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228054,228038,'2007-08-21 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(228057,228055,'2007-10-19 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228058,228055,'2007-11-30 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228059,228055,'2007-10-05 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228060,228055,'2007-09-14 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228061,228055,'2007-10-12 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228062,228055,'2007-09-07 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228063,228055,'2007-08-31 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228064,228055,'2007-09-28 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228065,228055,'2007-12-07 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228066,228055,'2007-08-24 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228067,228055,'2007-11-16 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228068,228055,'2007-09-21 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228069,228055,'2007-11-02 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228070,228055,'2007-10-26 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228071,228055,'2007-11-09 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(228074,228072,'2007-10-05 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228075,228072,'2007-09-14 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228076,228072,'2007-11-09 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228077,228072,'2007-09-21 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228078,228072,'2007-09-28 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228079,228072,'2007-08-31 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228080,228072,'2007-09-07 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228081,228072,'2007-10-19 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228082,228072,'2007-11-16 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228083,228072,'2007-11-30 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228084,228072,'2007-08-24 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228085,228072,'2007-10-26 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228086,228072,'2007-12-07 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228087,228072,'2007-11-02 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228088,228072,'2007-10-12 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(228091,228089,'2007-08-30 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228092,228089,'2007-11-15 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228093,228089,'2007-12-06 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228094,228089,'2007-11-29 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228095,228089,'2007-09-20 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228096,228089,'2007-10-04 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228097,228089,'2007-10-18 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228098,228089,'2007-11-08 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228099,228089,'2007-09-13 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228100,228089,'2007-08-23 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228101,228089,'2007-11-01 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228102,228089,'2007-09-27 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228103,228089,'2007-10-11 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228104,228089,'2007-09-06 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228105,228089,'2007-10-25 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(228108,228106,'2007-09-05 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228109,228106,'2007-10-10 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228110,228106,'2007-11-07 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228111,228106,'2007-10-24 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228112,228106,'2007-08-29 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228113,228106,'2007-09-26 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228114,228106,'2007-11-28 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228115,228106,'2007-09-12 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228116,228106,'2007-08-22 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228117,228106,'2007-12-05 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228118,228106,'2007-09-19 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228119,228106,'2007-10-03 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228120,228106,'2007-10-17 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228121,228106,'2007-10-31 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228122,228106,'2007-11-14 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(228125,228123,'2007-08-30 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228126,228123,'2007-09-06 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228127,228123,'2007-12-06 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228128,228123,'2007-10-11 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228129,228123,'2007-11-29 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228130,228123,'2007-10-18 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228131,228123,'2007-10-04 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228132,228123,'2007-11-08 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228133,228123,'2007-11-01 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228134,228123,'2007-09-13 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228135,228123,'2007-08-23 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228136,228123,'2007-09-20 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228137,228123,'2007-09-27 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228138,228123,'2007-11-15 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228139,228123,'2007-10-25 00:00:00',186,0,210,-10,8,0,'2008-05-07',1),
	(228142,228140,'2007-08-20 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228143,228140,'2007-10-29 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228144,228140,'2007-09-28 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228145,228140,'2007-11-30 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228146,228140,'2007-10-12 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228147,228140,'2007-10-01 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228148,228140,'2007-09-14 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228149,228140,'2007-12-03 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228150,228140,'2007-11-12 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228151,228140,'2007-11-16 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228152,228140,'2007-09-24 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228153,228140,'2007-08-24 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228154,228140,'2007-09-10 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228155,228140,'2007-09-21 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228156,228140,'2007-11-09 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228157,228140,'2007-12-07 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228158,228140,'2007-08-31 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228159,228140,'2007-11-02 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228160,228140,'2007-11-05 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228161,228140,'2007-08-27 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228162,228140,'2007-10-05 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228163,228140,'2007-11-19 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228164,228140,'2007-10-19 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228165,228140,'2007-10-15 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228166,228140,'2007-11-26 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228167,228140,'2007-10-26 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228168,228140,'2007-09-07 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228169,228140,'2007-09-17 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228170,228140,'2007-10-22 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228173,228171,'2007-09-19 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228174,228171,'2007-08-22 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228175,228171,'2007-11-26 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228176,228171,'2007-11-05 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228177,228171,'2007-08-27 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228178,228171,'2007-08-20 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228179,228171,'2007-12-03 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228180,228171,'2007-09-17 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228181,228171,'2007-10-10 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228182,228171,'2007-12-05 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228183,228171,'2007-10-15 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228184,228171,'2007-09-10 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228185,228171,'2007-11-14 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228186,228171,'2007-11-19 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228187,228171,'2007-10-24 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228188,228171,'2007-08-29 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228189,228171,'2007-10-17 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228190,228171,'2007-10-03 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228191,228171,'2007-10-29 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228192,228171,'2007-10-31 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228193,228171,'2007-10-22 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228194,228171,'2007-11-12 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228195,228171,'2007-11-28 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228196,228171,'2007-09-05 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228197,228171,'2007-09-26 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228198,228171,'2007-09-24 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228199,228171,'2007-09-12 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228200,228171,'2007-10-01 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228201,228171,'2007-11-07 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228204,228202,'2007-09-21 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228205,228202,'2007-11-02 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228206,228202,'2007-09-14 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228207,228202,'2007-11-30 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228208,228202,'2007-10-19 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228209,228202,'2007-10-26 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228210,228202,'2007-08-31 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228211,228202,'2007-11-16 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228212,228202,'2007-09-28 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228213,228202,'2007-10-12 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228214,228202,'2007-08-24 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228215,228202,'2007-12-07 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228216,228202,'2007-11-09 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228217,228202,'2007-10-05 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228218,228202,'2007-09-07 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228221,228219,'2007-11-08 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228222,228219,'2007-08-23 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228223,228219,'2007-08-30 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228224,228219,'2007-11-01 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228225,228219,'2007-09-13 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228226,228219,'2007-10-04 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228227,228219,'2007-10-25 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228228,228219,'2007-11-15 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228229,228219,'2007-09-20 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228230,228219,'2007-12-06 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228231,228219,'2007-09-27 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228232,228219,'2007-09-06 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228233,228219,'2007-10-11 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228234,228219,'2007-11-29 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228235,228219,'2007-10-18 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228238,228236,'2007-11-07 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228239,228236,'2007-08-29 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228240,228236,'2007-09-12 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228241,228236,'2007-12-05 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228242,228236,'2007-11-14 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228243,228236,'2007-09-05 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228244,228236,'2007-10-03 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228245,228236,'2007-10-10 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228246,228236,'2007-10-31 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228247,228236,'2007-10-24 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228248,228236,'2007-08-22 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228249,228236,'2007-09-19 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228250,228236,'2007-09-26 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228251,228236,'2007-10-17 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228252,228236,'2007-11-28 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(228255,228253,'2007-11-29 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228256,228253,'2007-09-20 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228257,228253,'2007-12-06 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228258,228253,'2007-08-30 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228259,228253,'2007-09-06 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228260,228253,'2007-10-04 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228261,228253,'2007-10-18 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228262,228253,'2007-10-11 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228263,228253,'2007-11-01 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228264,228253,'2007-10-25 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228265,228253,'2007-09-13 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228266,228253,'2007-09-27 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228267,228253,'2007-11-08 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228268,228253,'2007-11-15 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228269,228253,'2007-08-23 00:00:00',90,0,114,-10,7,0,'2008-05-07',1),
	(228272,228270,'2007-12-06 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228273,228270,'2007-08-23 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228274,228270,'2007-10-04 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228275,228270,'2007-10-25 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228276,228270,'2007-10-18 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228277,228270,'2007-11-08 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228278,228270,'2007-08-30 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228279,228270,'2007-11-01 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228280,228270,'2007-11-29 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228281,228270,'2007-09-13 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228282,228270,'2007-09-06 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228283,228270,'2007-09-20 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228284,228270,'2007-09-27 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228285,228270,'2007-11-15 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228286,228270,'2007-10-11 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(228289,228287,'2007-10-30 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228290,228287,'2007-11-20 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228291,228287,'2007-11-13 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228292,228287,'2007-09-11 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228293,228287,'2007-11-27 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228294,228287,'2007-10-02 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228295,228287,'2007-10-23 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228296,228287,'2007-08-28 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228297,228287,'2007-10-16 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228298,228287,'2007-09-04 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228299,228287,'2007-12-04 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228300,228287,'2007-09-25 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228301,228287,'2007-09-18 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228302,228287,'2007-11-06 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228303,228287,'2007-08-21 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(228306,228304,'2007-11-29 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228307,228304,'2007-10-04 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228308,228304,'2007-10-25 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228309,228304,'2007-12-06 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228310,228304,'2007-09-27 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228311,228304,'2007-11-01 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228312,228304,'2007-09-06 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228313,228304,'2007-08-30 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228314,228304,'2007-10-11 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228315,228304,'2007-08-23 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228316,228304,'2007-09-13 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228317,228304,'2007-10-18 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228318,228304,'2007-11-15 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228319,228304,'2007-11-08 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228320,228304,'2007-09-20 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228323,228321,'2007-12-07 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228324,228321,'2007-08-24 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228325,228321,'2007-11-30 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228326,228321,'2007-11-02 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228327,228321,'2007-09-28 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228328,228321,'2007-10-19 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228329,228321,'2007-10-05 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228330,228321,'2007-10-12 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228331,228321,'2007-11-16 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228332,228321,'2007-09-14 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228333,228321,'2007-09-21 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228334,228321,'2007-08-31 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228335,228321,'2007-09-07 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228336,228321,'2007-10-26 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228337,228321,'2007-11-09 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228340,228338,'2007-09-28 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228341,228338,'2007-10-05 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228342,228338,'2007-10-12 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228343,228338,'2007-09-21 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228344,228338,'2007-09-07 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228345,228338,'2007-10-26 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228346,228338,'2007-08-31 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228347,228338,'2007-08-24 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228348,228338,'2007-09-14 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228349,228338,'2007-11-16 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228350,228338,'2007-11-30 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228351,228338,'2007-10-19 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228352,228338,'2007-12-07 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228353,228338,'2007-11-09 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228354,228338,'2007-11-02 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228357,228355,'2007-10-18 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228358,228355,'2007-09-13 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228359,228355,'2007-09-06 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228360,228355,'2007-11-08 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228361,228355,'2007-11-15 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228362,228355,'2007-10-11 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228363,228355,'2007-11-01 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228364,228355,'2007-08-23 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228365,228355,'2007-10-04 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228366,228355,'2007-10-25 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228367,228355,'2007-12-06 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228368,228355,'2007-08-30 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228369,228355,'2007-09-20 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228370,228355,'2007-11-29 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228371,228355,'2007-09-27 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228374,228372,'2007-09-20 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228375,228372,'2007-10-11 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228376,228372,'2007-08-23 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228377,228372,'2007-08-30 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228378,228372,'2007-11-29 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228379,228372,'2007-12-06 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228380,228372,'2007-09-06 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228381,228372,'2007-11-08 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228382,228372,'2007-11-15 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228383,228372,'2007-10-25 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228384,228372,'2007-09-27 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228385,228372,'2007-10-04 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228386,228372,'2007-10-18 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228387,228372,'2007-11-01 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228388,228372,'2007-09-13 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(228391,228389,'2007-08-21 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228392,228389,'2007-10-23 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228393,228389,'2007-08-28 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228394,228389,'2007-09-18 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228395,228389,'2007-09-11 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228396,228389,'2007-10-02 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228397,228389,'2007-11-13 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228398,228389,'2007-10-30 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228399,228389,'2007-09-04 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228400,228389,'2007-10-16 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228401,228389,'2007-11-20 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228402,228389,'2007-11-06 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228403,228389,'2007-11-27 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228404,228389,'2007-09-25 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228405,228389,'2007-12-04 00:00:00',126,0,138,-10,3,0,'2008-05-07',1),
	(228408,228406,'2007-10-25 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228409,228406,'2007-12-06 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228410,228406,'2007-11-29 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228411,228406,'2007-08-30 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228412,228406,'2007-11-15 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228413,228406,'2007-09-06 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228414,228406,'2007-10-11 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228415,228406,'2007-10-18 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228416,228406,'2007-09-13 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228417,228406,'2007-09-27 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228418,228406,'2007-11-08 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228419,228406,'2007-09-20 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228420,228406,'2007-11-01 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228421,228406,'2007-08-23 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228422,228406,'2007-10-04 00:00:00',150,0,162,-10,4,0,'2008-05-07',1),
	(228425,228423,'2007-10-30 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228426,228423,'2007-11-27 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228427,228423,'2007-08-21 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228428,228423,'2007-10-02 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228429,228423,'2007-11-13 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228430,228423,'2007-09-25 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228431,228423,'2007-08-28 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228432,228423,'2007-12-04 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228433,228423,'2007-11-20 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228434,228423,'2007-11-06 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228435,228423,'2007-09-18 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228436,228423,'2007-09-04 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228437,228423,'2007-09-11 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228438,228423,'2007-10-16 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228439,228423,'2007-10-23 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(228442,228440,'2007-11-06 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228443,228440,'2007-12-04 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228444,228440,'2007-09-11 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228445,228440,'2007-09-04 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228446,228440,'2007-08-28 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228447,228440,'2007-09-25 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228448,228440,'2007-10-16 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228449,228440,'2007-08-21 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228450,228440,'2007-10-23 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228451,228440,'2007-11-27 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228452,228440,'2007-10-02 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228453,228440,'2007-10-30 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228454,228440,'2007-11-20 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228455,228440,'2007-11-13 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228456,228440,'2007-09-18 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(228459,228457,'2007-09-12 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228460,228457,'2007-12-05 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228461,228457,'2007-10-10 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228462,228457,'2007-10-31 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228463,228457,'2007-10-03 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228464,228457,'2007-11-14 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228465,228457,'2007-08-29 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228466,228457,'2007-11-07 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228467,228457,'2007-11-28 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228468,228457,'2007-08-22 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228469,228457,'2007-09-19 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228470,228457,'2007-09-05 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228471,228457,'2007-09-26 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228472,228457,'2007-10-24 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228473,228457,'2007-10-17 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228476,228474,'2007-09-28 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228477,228474,'2007-11-30 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228478,228474,'2007-10-26 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228479,228474,'2007-08-24 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228480,228474,'2007-09-14 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228481,228474,'2007-10-12 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228482,228474,'2007-11-16 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228483,228474,'2007-11-09 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228484,228474,'2007-08-31 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228485,228474,'2007-09-21 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228486,228474,'2007-11-02 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228487,228474,'2007-12-07 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228488,228474,'2007-10-19 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228489,228474,'2007-10-05 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228490,228474,'2007-09-07 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(228493,228491,'2007-11-02 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228494,228491,'2007-10-05 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228495,228491,'2007-09-21 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228496,228491,'2007-11-16 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228497,228491,'2007-09-28 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228498,228491,'2007-10-26 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228499,228491,'2007-09-14 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228500,228491,'2007-10-19 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228501,228491,'2007-08-31 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228502,228491,'2007-09-07 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228503,228491,'2007-10-12 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228504,228491,'2007-12-07 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228505,228491,'2007-08-24 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228506,228491,'2007-11-30 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228507,228491,'2007-11-09 00:00:00',102,0,114,-10,2,0,'2008-05-07',1),
	(228510,228508,'2007-11-20 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228511,228508,'2007-09-18 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228512,228508,'2007-10-02 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228513,228508,'2007-11-06 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228514,228508,'2007-08-21 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228515,228508,'2007-10-30 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228516,228508,'2007-10-16 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228517,228508,'2007-10-23 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228518,228508,'2007-11-13 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228519,228508,'2007-08-28 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228520,228508,'2007-09-25 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228521,228508,'2007-09-11 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228522,228508,'2007-11-27 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228523,228508,'2007-12-04 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228524,228508,'2007-09-04 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228527,228525,'2007-10-29 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228528,228525,'2007-09-24 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228529,228525,'2007-11-05 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228530,228525,'2007-10-22 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228531,228525,'2007-10-01 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228532,228525,'2007-10-15 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228533,228525,'2007-12-03 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228534,228525,'2007-08-27 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228535,228525,'2007-11-12 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228536,228525,'2007-11-19 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228537,228525,'2007-11-26 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228538,228525,'2007-09-10 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228539,228525,'2007-08-20 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228540,228525,'2007-09-17 00:00:00',162,0,186,-10,8,0,'2008-05-07',1),
	(228543,228541,'2007-09-19 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228544,228541,'2007-09-26 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228545,228541,'2007-10-24 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228546,228541,'2007-11-07 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228547,228541,'2007-09-05 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228548,228541,'2007-09-12 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228549,228541,'2007-11-28 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228550,228541,'2007-11-14 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228551,228541,'2007-08-29 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228552,228541,'2007-10-31 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228553,228541,'2007-08-22 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228554,228541,'2007-10-17 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228555,228541,'2007-12-05 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228556,228541,'2007-10-03 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228557,228541,'2007-10-10 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228560,228558,'2007-09-11 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228561,228558,'2007-09-18 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228562,228558,'2007-12-04 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228563,228558,'2007-11-20 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228564,228558,'2007-11-13 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228565,228558,'2007-10-02 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228566,228558,'2007-09-04 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228567,228558,'2007-10-16 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228568,228558,'2007-11-27 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228569,228558,'2007-10-30 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228570,228558,'2007-08-21 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228571,228558,'2007-11-06 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228572,228558,'2007-10-23 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228573,228558,'2007-08-28 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228574,228558,'2007-09-25 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(228577,228575,'2007-12-03 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228578,228575,'2007-11-12 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228579,228575,'2007-08-27 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228580,228575,'2007-10-15 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228581,228575,'2007-10-01 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228582,228575,'2007-08-20 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228583,228575,'2007-10-29 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228584,228575,'2007-11-19 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228585,228575,'2007-10-22 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228586,228575,'2007-11-05 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228587,228575,'2007-09-24 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228588,228575,'2007-11-26 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228589,228575,'2007-09-10 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228590,228575,'2007-09-17 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(228593,228591,'2007-08-21 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228594,228591,'2007-10-23 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228595,228591,'2007-11-06 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228596,228591,'2007-09-18 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228597,228591,'2007-10-30 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228598,228591,'2007-09-25 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228599,228591,'2007-12-04 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228600,228591,'2007-09-04 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228601,228591,'2007-11-13 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228602,228591,'2007-11-20 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228603,228591,'2007-11-27 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228604,228591,'2007-10-16 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228605,228591,'2007-10-02 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228606,228591,'2007-08-28 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228607,228591,'2007-09-11 00:00:00',174,0,186,-10,4,0,'2008-05-07',1),
	(228610,228608,'2007-09-21 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228611,228608,'2007-09-14 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228612,228608,'2007-10-05 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228613,228608,'2007-11-16 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228614,228608,'2007-08-31 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228615,228608,'2007-09-07 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228616,228608,'2007-08-24 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228617,228608,'2007-10-19 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228618,228608,'2007-10-12 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228619,228608,'2007-12-07 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228620,228608,'2007-11-09 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228621,228608,'2007-11-30 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228622,228608,'2007-10-26 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228623,228608,'2007-11-02 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228624,228608,'2007-09-28 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(228627,228625,'2007-10-19 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228628,228625,'2007-10-24 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228629,228625,'2007-11-16 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228630,228625,'2007-08-29 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228631,228625,'2007-11-30 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228632,228625,'2007-08-24 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228633,228625,'2007-09-21 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228634,228625,'2007-11-02 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228635,228625,'2007-09-07 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228636,228625,'2007-08-22 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228637,228625,'2007-12-07 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228638,228625,'2007-12-03 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228639,228625,'2007-11-07 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228640,228625,'2007-09-28 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228641,228625,'2007-10-17 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228642,228625,'2007-10-29 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228643,228625,'2007-10-01 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228644,228625,'2007-10-12 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228645,228625,'2007-11-28 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228646,228625,'2007-11-09 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228647,228625,'2007-10-03 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228648,228625,'2007-10-15 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228649,228625,'2007-09-26 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228650,228625,'2007-10-22 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228651,228625,'2007-09-19 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228652,228625,'2007-11-19 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228653,228625,'2007-09-12 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228654,228625,'2007-10-05 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228655,228625,'2007-09-17 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228656,228625,'2007-11-26 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228657,228625,'2007-10-10 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228658,228625,'2007-09-14 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228659,228625,'2007-10-31 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228660,228625,'2007-11-05 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228661,228625,'2007-09-10 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228662,228625,'2007-08-20 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228663,228625,'2007-09-24 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228664,228625,'2007-11-12 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228665,228625,'2007-08-31 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228666,228625,'2007-08-27 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228667,228625,'2007-11-14 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228668,228625,'2007-09-05 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228669,228625,'2007-12-05 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228670,228625,'2007-10-26 00:00:00',138,0,150,-10,2,0,'2008-05-07',1),
	(228673,228671,'2007-10-31 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228674,228671,'2007-09-05 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228675,228671,'2007-10-29 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228676,228671,'2007-11-30 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228677,228671,'2007-12-05 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228678,228671,'2007-11-28 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228679,228671,'2007-08-20 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228680,228671,'2007-08-27 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228681,228671,'2007-10-01 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228682,228671,'2007-11-16 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228683,228671,'2007-09-14 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228684,228671,'2007-08-31 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228685,228671,'2007-11-12 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228686,228671,'2007-08-29 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228687,228671,'2007-09-07 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228688,228671,'2007-09-17 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228689,228671,'2007-11-19 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228690,228671,'2007-08-24 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228691,228671,'2007-08-22 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228692,228671,'2007-10-03 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228693,228671,'2007-12-03 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228694,228671,'2007-09-19 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228695,228671,'2007-11-26 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228696,228671,'2007-10-15 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228697,228671,'2007-10-24 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228698,228671,'2007-09-12 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228699,228671,'2007-10-19 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228700,228671,'2007-11-14 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228701,228671,'2007-11-09 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228702,228671,'2007-09-26 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228703,228671,'2007-10-26 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228704,228671,'2007-10-12 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228705,228671,'2007-10-10 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228706,228671,'2007-09-24 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228707,228671,'2007-12-07 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228708,228671,'2007-11-02 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228709,228671,'2007-11-07 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228710,228671,'2007-09-10 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228711,228671,'2007-10-17 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228712,228671,'2007-11-05 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228713,228671,'2007-09-21 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228714,228671,'2007-10-22 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228715,228671,'2007-10-05 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228716,228671,'2007-09-28 00:00:00',150,0,162,-10,3,0,'2008-05-07',1),
	(228719,228717,'2007-11-28 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228720,228717,'2007-10-22 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228721,228717,'2007-09-14 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228722,228717,'2007-10-15 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228723,228717,'2007-09-28 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228724,228717,'2007-12-05 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228725,228717,'2007-10-03 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228726,228717,'2007-10-01 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228727,228717,'2007-10-10 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228728,228717,'2007-09-26 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228729,228717,'2007-11-07 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228730,228717,'2007-10-17 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228731,228717,'2007-08-20 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228732,228717,'2007-09-19 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228733,228717,'2007-10-26 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228734,228717,'2007-11-16 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228735,228717,'2007-09-05 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228736,228717,'2007-10-19 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228737,228717,'2007-10-24 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228738,228717,'2007-09-07 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228739,228717,'2007-11-02 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228740,228717,'2007-11-30 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228741,228717,'2007-10-31 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228742,228717,'2007-11-19 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228743,228717,'2007-08-27 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228744,228717,'2007-10-05 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228745,228717,'2007-11-05 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228746,228717,'2007-09-10 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228747,228717,'2007-08-22 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228748,228717,'2007-09-21 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228749,228717,'2007-10-12 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228750,228717,'2007-11-09 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228751,228717,'2007-12-03 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228752,228717,'2007-08-24 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228753,228717,'2007-12-07 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228754,228717,'2007-09-17 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228755,228717,'2007-09-24 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228756,228717,'2007-11-14 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228757,228717,'2007-10-29 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228758,228717,'2007-08-31 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228759,228717,'2007-09-12 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228760,228717,'2007-08-29 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228761,228717,'2007-11-26 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228762,228717,'2007-11-12 00:00:00',162,0,174,-10,2,0,'2008-05-07',1),
	(228765,228763,'2007-09-21 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228766,228763,'2007-09-07 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228767,228763,'2007-11-16 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228768,228763,'2007-12-07 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228769,228763,'2007-10-05 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228770,228763,'2007-11-02 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228771,228763,'2007-11-09 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228772,228763,'2007-10-26 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228773,228763,'2007-11-30 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228774,228763,'2007-08-31 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228775,228763,'2007-10-12 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228776,228763,'2007-09-14 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228777,228763,'2007-08-24 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228778,228763,'2007-09-28 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228779,228763,'2007-10-19 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228782,228780,'2007-08-28 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228783,228780,'2007-10-30 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228784,228780,'2007-12-04 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228785,228780,'2007-11-20 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228786,228780,'2007-11-27 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228787,228780,'2007-11-06 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228788,228780,'2007-09-11 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228789,228780,'2007-09-25 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228790,228780,'2007-10-23 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228791,228780,'2007-10-16 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228792,228780,'2007-08-21 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228793,228780,'2007-09-18 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228794,228780,'2007-11-13 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228795,228780,'2007-09-04 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228796,228780,'2007-10-02 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228799,228797,'2007-08-31 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228800,228797,'2007-09-07 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228801,228797,'2007-09-21 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228802,228797,'2007-10-19 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228803,228797,'2007-11-09 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228804,228797,'2007-08-24 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228805,228797,'2007-10-12 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228806,228797,'2007-10-26 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228807,228797,'2007-09-28 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228808,228797,'2007-11-02 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228809,228797,'2007-11-16 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228810,228797,'2007-11-30 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228811,228797,'2007-12-07 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228812,228797,'2007-09-14 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228813,228797,'2007-10-05 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228816,228814,'2007-11-07 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228817,228814,'2007-10-10 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228818,228814,'2007-10-24 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228819,228814,'2007-08-22 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228820,228814,'2007-09-26 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228821,228814,'2007-09-05 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228822,228814,'2007-12-05 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228823,228814,'2007-09-12 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228824,228814,'2007-08-29 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228825,228814,'2007-11-14 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228826,228814,'2007-10-03 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228827,228814,'2007-10-17 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228828,228814,'2007-10-31 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228829,228814,'2007-11-28 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228830,228814,'2007-09-19 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(228833,228831,'2007-11-20 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228834,228831,'2007-10-02 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228835,228831,'2007-09-04 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228836,228831,'2007-10-30 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228837,228831,'2007-12-04 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228838,228831,'2007-08-28 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228839,228831,'2007-11-27 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228840,228831,'2007-09-25 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228841,228831,'2007-10-16 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228842,228831,'2007-10-23 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228843,228831,'2007-11-06 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228844,228831,'2007-08-21 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228845,228831,'2007-09-11 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228846,228831,'2007-09-18 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228847,228831,'2007-11-13 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228850,228848,'2007-10-18 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228851,228848,'2007-11-08 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228852,228848,'2007-10-04 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228853,228848,'2007-11-29 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228854,228848,'2007-09-06 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228855,228848,'2007-10-11 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228856,228848,'2007-10-25 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228857,228848,'2007-08-30 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228858,228848,'2007-11-15 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228859,228848,'2007-12-06 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228860,228848,'2007-09-27 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228861,228848,'2007-11-01 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228862,228848,'2007-09-20 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228863,228848,'2007-08-23 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228864,228848,'2007-09-13 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228867,228865,'2007-09-14 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228868,228865,'2007-10-12 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228869,228865,'2007-11-09 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228870,228865,'2007-12-07 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228871,228865,'2007-11-02 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228872,228865,'2007-10-19 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228873,228865,'2007-10-26 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228874,228865,'2007-11-16 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228875,228865,'2007-10-05 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228876,228865,'2007-11-30 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228877,228865,'2007-09-28 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228878,228865,'2007-08-24 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228879,228865,'2007-08-31 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228880,228865,'2007-09-21 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228881,228865,'2007-09-07 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(228884,228882,'2007-09-25 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228885,228882,'2007-11-06 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228886,228882,'2007-08-28 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228887,228882,'2007-09-11 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228888,228882,'2007-10-23 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228889,228882,'2007-11-20 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228890,228882,'2007-11-13 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228891,228882,'2007-11-27 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228892,228882,'2007-12-04 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228893,228882,'2007-10-16 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228894,228882,'2007-10-02 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228895,228882,'2007-10-30 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228896,228882,'2007-08-21 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228897,228882,'2007-09-04 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228898,228882,'2007-09-18 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228901,228899,'2007-09-12 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228902,228899,'2007-10-31 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228903,228899,'2007-12-05 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228904,228899,'2007-09-05 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228905,228899,'2007-09-19 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228906,228899,'2007-08-22 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228907,228899,'2007-09-26 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228908,228899,'2007-10-17 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228909,228899,'2007-11-14 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228910,228899,'2007-11-28 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228911,228899,'2007-10-10 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228912,228899,'2007-10-03 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228913,228899,'2007-08-29 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228914,228899,'2007-10-24 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228915,228899,'2007-11-07 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(228918,228916,'2007-09-24 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228919,228916,'2007-10-22 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228920,228916,'2007-08-27 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228921,228916,'2007-11-19 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228922,228916,'2007-10-01 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228923,228916,'2007-09-10 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228924,228916,'2007-09-17 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228925,228916,'2007-11-12 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228926,228916,'2007-11-05 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228927,228916,'2007-10-29 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228928,228916,'2007-10-15 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228929,228916,'2007-11-26 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228930,228916,'2007-12-03 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228931,228916,'2007-08-20 00:00:00',114,0,138,-10,7,0,'2008-05-07',1),
	(228934,228932,'2007-09-04 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228935,228932,'2007-10-23 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228936,228932,'2007-11-27 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228937,228932,'2007-11-15 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228938,228932,'2007-10-04 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228939,228932,'2007-10-11 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228940,228932,'2007-08-28 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228941,228932,'2007-10-30 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228942,228932,'2007-12-04 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228943,228932,'2007-12-06 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228944,228932,'2007-11-29 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228945,228932,'2007-09-13 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228946,228932,'2007-09-20 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228947,228932,'2007-10-16 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228948,228932,'2007-10-25 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228949,228932,'2007-09-27 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228950,228932,'2007-09-25 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228951,228932,'2007-09-06 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228952,228932,'2007-11-13 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228953,228932,'2007-08-23 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228954,228932,'2007-11-06 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228955,228932,'2007-11-01 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228956,228932,'2007-11-08 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228957,228932,'2007-09-11 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228958,228932,'2007-08-21 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228959,228932,'2007-10-18 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228960,228932,'2007-10-02 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228961,228932,'2007-09-18 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228962,228932,'2007-08-30 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228963,228932,'2007-11-20 00:00:00',126,0,144,-15,2,0,'2008-05-07',1),
	(228966,228964,'2007-10-30 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228967,228964,'2007-09-06 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228968,228964,'2007-08-23 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228969,228964,'2007-12-04 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228970,228964,'2007-10-23 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228971,228964,'2007-09-13 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228972,228964,'2007-12-06 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228973,228964,'2007-11-01 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228974,228964,'2007-11-27 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228975,228964,'2007-10-02 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228976,228964,'2007-09-27 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228977,228964,'2007-08-28 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228978,228964,'2007-10-11 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228979,228964,'2007-09-11 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228980,228964,'2007-11-08 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228981,228964,'2007-11-15 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228982,228964,'2007-09-20 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228983,228964,'2007-10-04 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228984,228964,'2007-10-25 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228985,228964,'2007-10-18 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228986,228964,'2007-09-25 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228987,228964,'2007-08-21 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228988,228964,'2007-09-04 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228989,228964,'2007-11-06 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228990,228964,'2007-11-29 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228991,228964,'2007-11-20 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228992,228964,'2007-10-16 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228993,228964,'2007-08-30 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228994,228964,'2007-11-13 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228995,228964,'2007-09-18 00:00:00',162,0,174,-10,1,0,'2008-05-07',1),
	(228998,228996,'2007-12-03 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(228999,228996,'2007-11-26 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229000,228996,'2007-10-22 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229001,228996,'2007-10-15 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229002,228996,'2007-11-12 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229003,228996,'2007-11-05 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229004,228996,'2007-08-27 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229005,228996,'2007-08-20 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229006,228996,'2007-09-10 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229007,228996,'2007-09-17 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229008,228996,'2007-10-29 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229009,228996,'2007-11-19 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229010,228996,'2007-10-01 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229011,228996,'2007-09-24 00:00:00',162,0,186,-10,7,0,'2008-05-07',1),
	(229014,229012,'2007-08-30 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229015,229012,'2007-10-11 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229016,229012,'2007-11-29 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229017,229012,'2007-10-25 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229018,229012,'2007-09-13 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229019,229012,'2007-10-04 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229020,229012,'2007-08-23 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229021,229012,'2007-12-06 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229022,229012,'2007-10-18 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229023,229012,'2007-09-27 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229024,229012,'2007-09-06 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229025,229012,'2007-11-01 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229026,229012,'2007-11-08 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229027,229012,'2007-11-15 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229028,229012,'2007-09-20 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229031,229029,'2007-09-06 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229032,229029,'2007-11-15 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229033,229029,'2007-09-13 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229034,229029,'2007-10-18 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229035,229029,'2007-11-01 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229036,229029,'2007-08-23 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229037,229029,'2007-11-08 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229038,229029,'2007-09-27 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229039,229029,'2007-10-25 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229040,229029,'2007-09-20 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229041,229029,'2007-10-11 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229042,229029,'2007-08-30 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229043,229029,'2007-11-29 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229044,229029,'2007-10-04 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229045,229029,'2007-12-06 00:00:00',90,0,126,-10,6,0,'2008-05-07',1),
	(229048,229046,'2007-10-18 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229049,229046,'2007-11-29 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229050,229046,'2007-08-23 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229051,229046,'2007-09-13 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229052,229046,'2007-10-11 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229053,229046,'2007-08-30 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229054,229046,'2007-11-15 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229055,229046,'2007-10-25 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229056,229046,'2007-10-04 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229057,229046,'2007-09-27 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229058,229046,'2007-09-06 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229059,229046,'2007-12-06 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229060,229046,'2007-09-20 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229061,229046,'2007-11-01 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229062,229046,'2007-11-08 00:00:00',180,0,216,-10,6,0,'2008-05-07',1),
	(229065,229063,'2007-11-26 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229066,229063,'2007-08-27 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229067,229063,'2007-11-05 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229068,229063,'2007-11-30 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229069,229063,'2007-10-15 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229070,229063,'2007-09-21 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229071,229063,'2007-10-12 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229072,229063,'2007-09-28 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229073,229063,'2007-08-20 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229074,229063,'2007-08-31 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229075,229063,'2007-10-29 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229076,229063,'2007-11-19 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229077,229063,'2007-10-05 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229078,229063,'2007-12-03 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229079,229063,'2007-09-10 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229080,229063,'2007-10-22 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229081,229063,'2007-09-17 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229082,229063,'2007-09-07 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229083,229063,'2007-11-09 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229084,229063,'2007-11-16 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229085,229063,'2007-08-24 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229086,229063,'2007-10-01 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229087,229063,'2007-10-19 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229088,229063,'2007-11-12 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229089,229063,'2007-09-14 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229090,229063,'2007-09-24 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229091,229063,'2007-11-02 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229092,229063,'2007-12-07 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229093,229063,'2007-10-26 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229096,229094,'2007-09-24 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229097,229094,'2007-10-01 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229098,229094,'2007-10-29 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229099,229094,'2007-11-05 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229100,229094,'2007-11-26 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229101,229094,'2007-12-03 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229102,229094,'2007-09-10 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229103,229094,'2007-09-17 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229104,229094,'2007-08-27 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229105,229094,'2007-11-12 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229106,229094,'2007-10-15 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229107,229094,'2007-11-19 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229108,229094,'2007-08-20 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229109,229094,'2007-10-22 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229112,229110,'2007-10-12 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229113,229110,'2007-08-24 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229114,229110,'2007-09-07 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229115,229110,'2007-09-28 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229116,229110,'2007-11-02 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229117,229110,'2007-11-09 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229118,229110,'2007-10-05 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229119,229110,'2007-10-26 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229120,229110,'2007-12-07 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229121,229110,'2007-09-21 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229122,229110,'2007-11-16 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229123,229110,'2007-09-14 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229124,229110,'2007-08-31 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229125,229110,'2007-11-30 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229126,229110,'2007-10-19 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229129,229127,'2007-09-20 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229130,229127,'2007-10-04 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229131,229127,'2007-09-13 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229132,229127,'2007-11-08 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229133,229127,'2007-12-06 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229134,229127,'2007-08-30 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229135,229127,'2007-11-01 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229136,229127,'2007-09-06 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229137,229127,'2007-11-29 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229138,229127,'2007-08-23 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229139,229127,'2007-10-18 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229140,229127,'2007-09-27 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229141,229127,'2007-11-15 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229142,229127,'2007-10-25 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229143,229127,'2007-10-11 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229146,229144,'2007-09-19 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229147,229144,'2007-08-22 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229148,229144,'2007-10-03 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229149,229144,'2007-10-31 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229150,229144,'2007-11-07 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229151,229144,'2007-12-05 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229152,229144,'2007-10-17 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229153,229144,'2007-09-26 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229154,229144,'2007-08-29 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229155,229144,'2007-10-24 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229156,229144,'2007-09-05 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229157,229144,'2007-09-12 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229158,229144,'2007-11-28 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229159,229144,'2007-10-10 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229160,229144,'2007-11-14 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229163,229161,'2007-08-28 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229164,229161,'2007-11-27 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229165,229161,'2007-09-25 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229166,229161,'2007-10-02 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229167,229161,'2007-09-18 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229168,229161,'2007-11-06 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229169,229161,'2007-09-11 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229170,229161,'2007-10-16 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229171,229161,'2007-12-04 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229172,229161,'2007-11-20 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229173,229161,'2007-08-21 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229174,229161,'2007-10-30 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229175,229161,'2007-11-13 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229176,229161,'2007-09-04 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229177,229161,'2007-10-23 00:00:00',198,0,210,-10,4,0,'2008-05-07',1),
	(229180,229178,'2007-09-05 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229181,229178,'2007-12-05 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229182,229178,'2007-10-10 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229183,229178,'2007-11-07 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229184,229178,'2007-11-28 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229185,229178,'2007-08-29 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229186,229178,'2007-11-14 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229187,229178,'2007-09-26 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229188,229178,'2007-09-12 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229189,229178,'2007-08-22 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229190,229178,'2007-09-19 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229191,229178,'2007-10-03 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229192,229178,'2007-10-24 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229193,229178,'2007-10-31 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229194,229178,'2007-10-17 00:00:00',138,0,174,-10,6,0,'2008-05-07',1),
	(229197,229195,'2007-08-30 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229198,229195,'2007-10-25 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229199,229195,'2007-10-11 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229200,229195,'2007-09-06 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229201,229195,'2007-11-15 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229202,229195,'2007-11-29 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229203,229195,'2007-09-20 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229204,229195,'2007-11-01 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229205,229195,'2007-11-08 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229206,229195,'2007-09-13 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229207,229195,'2007-10-04 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229208,229195,'2007-10-18 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229209,229195,'2007-09-27 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229210,229195,'2007-12-06 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229211,229195,'2007-08-23 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229214,229212,'2007-10-03 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229215,229212,'2007-10-31 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229216,229212,'2007-09-12 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229217,229212,'2007-10-17 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229218,229212,'2007-09-05 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229219,229212,'2007-10-24 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229220,229212,'2007-12-05 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229221,229212,'2007-08-29 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229222,229212,'2007-08-22 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229223,229212,'2007-09-19 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229224,229212,'2007-11-07 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229225,229212,'2007-11-28 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229226,229212,'2007-10-10 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229227,229212,'2007-11-14 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229228,229212,'2007-09-26 00:00:00',102,0,114,-10,4,0,'2008-05-07',1),
	(229231,229229,'2007-11-08 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229232,229229,'2007-11-29 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229233,229229,'2007-09-13 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229234,229229,'2007-11-15 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229235,229229,'2007-10-04 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229236,229229,'2007-09-06 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229237,229229,'2007-09-20 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229238,229229,'2007-09-27 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229239,229229,'2007-08-30 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229240,229229,'2007-11-01 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229241,229229,'2007-12-06 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229242,229229,'2007-08-23 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229243,229229,'2007-10-11 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229244,229229,'2007-10-25 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229245,229229,'2007-10-18 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229248,229246,'2007-08-21 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229249,229246,'2007-11-27 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229250,229246,'2007-09-25 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229251,229246,'2007-10-30 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229252,229246,'2007-10-02 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229253,229246,'2007-11-20 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229254,229246,'2007-10-23 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229255,229246,'2007-08-28 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229256,229246,'2007-09-18 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229257,229246,'2007-11-13 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229258,229246,'2007-11-06 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229259,229246,'2007-09-04 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229260,229246,'2007-12-04 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229261,229246,'2007-09-11 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229262,229246,'2007-10-16 00:00:00',90,0,102,-10,3,0,'2008-05-07',1),
	(229265,229263,'2007-12-04 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229266,229263,'2007-11-27 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229267,229263,'2007-10-30 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229268,229263,'2007-08-21 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229269,229263,'2007-09-11 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229270,229263,'2007-09-04 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229271,229263,'2007-08-28 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229272,229263,'2007-09-25 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229273,229263,'2007-11-13 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229274,229263,'2007-10-23 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229275,229263,'2007-11-20 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229276,229263,'2007-10-02 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229277,229263,'2007-09-18 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229278,229263,'2007-10-16 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229279,229263,'2007-11-06 00:00:00',126,0,138,-10,4,0,'2008-05-07',1),
	(229282,229280,'2007-09-26 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229283,229280,'2007-09-12 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229284,229280,'2007-10-24 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229285,229280,'2007-11-28 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229286,229280,'2007-11-14 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229287,229280,'2007-10-17 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229288,229280,'2007-08-22 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229289,229280,'2007-08-29 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229290,229280,'2007-10-10 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229291,229280,'2007-12-05 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229292,229280,'2007-09-05 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229293,229280,'2007-09-19 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229294,229280,'2007-10-03 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229295,229280,'2007-11-07 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229296,229280,'2007-10-31 00:00:00',174,0,186,-10,8,0,'2008-05-07',1),
	(229299,229297,'2007-09-17 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229300,229297,'2007-11-12 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229301,229297,'2007-10-29 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229302,229297,'2007-12-03 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229303,229297,'2007-09-10 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229304,229297,'2007-10-22 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229305,229297,'2007-11-26 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229306,229297,'2007-09-24 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229307,229297,'2007-08-20 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229308,229297,'2007-08-27 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229309,229297,'2007-11-05 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229310,229297,'2007-11-19 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229311,229297,'2007-10-01 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229312,229297,'2007-10-15 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229315,229313,'2007-09-10 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229316,229313,'2007-10-31 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229317,229313,'2007-10-17 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229318,229313,'2007-10-29 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229319,229313,'2007-09-21 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229320,229313,'2007-11-26 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229321,229313,'2007-08-22 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229322,229313,'2007-08-31 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229323,229313,'2007-10-15 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229324,229313,'2007-09-19 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229325,229313,'2007-10-10 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229326,229313,'2007-10-12 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229327,229313,'2007-08-20 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229328,229313,'2007-09-26 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229329,229313,'2007-10-19 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229330,229313,'2007-10-01 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229331,229313,'2007-09-17 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229332,229313,'2007-12-03 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229333,229313,'2007-11-07 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229334,229313,'2007-10-22 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229335,229313,'2007-08-24 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229336,229313,'2007-09-14 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229337,229313,'2007-10-26 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229338,229313,'2007-09-12 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229339,229313,'2007-10-24 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229340,229313,'2007-09-07 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229341,229313,'2007-12-05 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229342,229313,'2007-09-05 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229343,229313,'2007-11-28 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229344,229313,'2007-11-14 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229345,229313,'2007-11-19 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229346,229313,'2007-10-03 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229347,229313,'2007-11-12 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229348,229313,'2007-09-24 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229349,229313,'2007-11-16 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229350,229313,'2007-12-07 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229351,229313,'2007-11-09 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229352,229313,'2007-11-05 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229353,229313,'2007-09-28 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229354,229313,'2007-10-05 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229355,229313,'2007-11-30 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229356,229313,'2007-08-27 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229357,229313,'2007-11-02 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229358,229313,'2007-08-29 00:00:00',186,0,198,-10,2,0,'2008-05-07',1),
	(229361,229359,'2007-10-22 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229362,229359,'2007-09-17 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229363,229359,'2007-10-29 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229364,229359,'2007-12-03 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229365,229359,'2007-08-27 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229366,229359,'2007-11-26 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229367,229359,'2007-11-19 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229368,229359,'2007-11-12 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229369,229359,'2007-08-20 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229370,229359,'2007-09-10 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229371,229359,'2007-10-15 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229372,229359,'2007-11-05 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229373,229359,'2007-10-01 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229374,229359,'2007-09-24 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229377,229375,'2007-09-17 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229378,229375,'2007-10-22 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229379,229375,'2007-10-29 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229380,229375,'2007-11-12 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229381,229375,'2007-11-05 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229382,229375,'2007-08-20 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229383,229375,'2007-10-01 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229384,229375,'2007-11-19 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229385,229375,'2007-09-10 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229386,229375,'2007-11-26 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229387,229375,'2007-08-27 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229388,229375,'2007-09-24 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229389,229375,'2007-12-03 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229390,229375,'2007-10-15 00:00:00',186,0,210,-10,7,0,'2008-05-07',1),
	(229393,229391,'2007-11-28 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229394,229391,'2007-11-09 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229395,229391,'2007-09-07 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229396,229391,'2007-08-31 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229397,229391,'2007-09-17 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229398,229391,'2007-12-07 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229399,229391,'2007-10-26 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229400,229391,'2007-09-24 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229401,229391,'2007-10-01 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229402,229391,'2007-08-27 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229403,229391,'2007-11-26 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229404,229391,'2007-10-29 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229405,229391,'2007-10-03 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229406,229391,'2007-10-05 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229407,229391,'2007-10-17 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229408,229391,'2007-12-05 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229409,229391,'2007-08-20 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229410,229391,'2007-10-24 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229411,229391,'2007-09-14 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229412,229391,'2007-09-05 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229413,229391,'2007-10-15 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229414,229391,'2007-11-30 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229415,229391,'2007-11-07 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229416,229391,'2007-09-10 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229417,229391,'2007-09-19 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229418,229391,'2007-08-24 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229419,229391,'2007-09-26 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229420,229391,'2007-09-28 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229421,229391,'2007-10-22 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229422,229391,'2007-11-14 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229423,229391,'2007-10-10 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229424,229391,'2007-10-19 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229425,229391,'2007-09-12 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229426,229391,'2007-11-12 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229427,229391,'2007-11-16 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229428,229391,'2007-10-31 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229429,229391,'2007-11-02 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229430,229391,'2007-10-12 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229431,229391,'2007-11-05 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229432,229391,'2007-09-21 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229433,229391,'2007-11-19 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229434,229391,'2007-12-03 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229435,229391,'2007-08-22 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229436,229391,'2007-08-29 00:00:00',126,0,138,-10,2,0,'2008-05-07',1),
	(229439,229437,'2007-09-17 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229440,229437,'2007-11-26 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229441,229437,'2007-12-03 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229442,229437,'2007-10-29 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229443,229437,'2007-08-27 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229444,229437,'2007-11-12 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229445,229437,'2007-10-01 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229446,229437,'2007-08-20 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229447,229437,'2007-09-24 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229448,229437,'2007-09-10 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229449,229437,'2007-11-19 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229450,229437,'2007-11-05 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229451,229437,'2007-10-22 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229452,229437,'2007-10-15 00:00:00',150,0,162,-10,2,0,'2008-05-07',1),
	(229455,229453,'2007-11-12 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229456,229453,'2007-09-10 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229457,229453,'2007-10-26 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229458,229453,'2007-09-24 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229459,229453,'2007-09-26 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229460,229453,'2007-11-28 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229461,229453,'2007-11-16 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229462,229453,'2007-11-09 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229463,229453,'2007-09-05 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229464,229453,'2007-08-24 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229465,229453,'2007-11-07 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229466,229453,'2007-11-02 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229467,229453,'2007-08-29 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229468,229453,'2007-09-14 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229469,229453,'2007-11-14 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229470,229453,'2007-10-31 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229471,229453,'2007-08-27 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229472,229453,'2007-12-03 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229473,229453,'2007-11-30 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229474,229453,'2007-12-07 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229475,229453,'2007-09-17 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229476,229453,'2007-10-19 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229477,229453,'2007-12-05 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229478,229453,'2007-11-19 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229479,229453,'2007-10-15 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229480,229453,'2007-10-12 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229481,229453,'2007-10-03 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229482,229453,'2007-09-12 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229483,229453,'2007-08-22 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229484,229453,'2007-09-28 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229485,229453,'2007-08-20 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229486,229453,'2007-10-22 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229487,229453,'2007-11-05 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229488,229453,'2007-09-21 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229489,229453,'2007-10-05 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229490,229453,'2007-10-01 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229491,229453,'2007-10-29 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229492,229453,'2007-08-31 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229493,229453,'2007-09-19 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229494,229453,'2007-11-26 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229495,229453,'2007-10-10 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229496,229453,'2007-09-07 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229497,229453,'2007-10-24 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229498,229453,'2007-10-17 00:00:00',198,0,210,-10,3,0,'2008-05-07',1),
	(229501,229499,'2007-08-30 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229502,229499,'2007-11-08 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229503,229499,'2007-09-27 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229504,229499,'2007-10-04 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229505,229499,'2007-10-18 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229506,229499,'2007-10-25 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229507,229499,'2007-11-15 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229508,229499,'2007-11-01 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229509,229499,'2007-09-20 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229510,229499,'2007-09-06 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229511,229499,'2007-09-13 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229512,229499,'2007-11-29 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229513,229499,'2007-12-06 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229514,229499,'2007-10-11 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229515,229499,'2007-08-23 00:00:00',102,0,114,-10,3,0,'2008-05-07',1),
	(229518,229516,'2007-08-22 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229519,229516,'2007-10-03 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229520,229516,'2007-09-26 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229521,229516,'2007-11-07 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229522,229516,'2007-08-29 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229523,229516,'2007-10-17 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229524,229516,'2007-10-31 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229525,229516,'2007-11-14 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229526,229516,'2007-09-19 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229527,229516,'2007-09-05 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229528,229516,'2007-11-28 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229529,229516,'2007-12-05 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229530,229516,'2007-09-12 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229531,229516,'2007-10-10 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229532,229516,'2007-10-24 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(229535,229533,'2007-08-24 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229536,229533,'2007-09-07 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229537,229533,'2007-12-07 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229538,229533,'2007-10-26 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229539,229533,'2007-11-02 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229540,229533,'2007-10-05 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229541,229533,'2007-09-21 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229542,229533,'2007-09-14 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229543,229533,'2007-10-19 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229544,229533,'2007-11-30 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229545,229533,'2007-10-12 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229546,229533,'2007-08-31 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229547,229533,'2007-09-28 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229548,229533,'2007-11-16 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229549,229533,'2007-11-09 00:00:00',162,0,174,-10,4,0,'2008-05-07',1),
	(229552,229550,'2007-08-23 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229553,229550,'2007-11-20 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229554,229550,'2007-09-27 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229555,229550,'2007-09-04 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229556,229550,'2007-11-29 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229557,229550,'2007-08-28 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229558,229550,'2007-12-04 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229559,229550,'2007-10-02 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229560,229550,'2007-10-30 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229561,229550,'2007-11-01 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229562,229550,'2007-11-15 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229563,229550,'2007-09-13 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229564,229550,'2007-09-18 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229565,229550,'2007-09-11 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229566,229550,'2007-10-18 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229567,229550,'2007-09-06 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229568,229550,'2007-10-16 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229569,229550,'2007-08-21 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229570,229550,'2007-10-23 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229571,229550,'2007-11-08 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229572,229550,'2007-10-11 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229573,229550,'2007-08-30 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229574,229550,'2007-11-06 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229575,229550,'2007-12-06 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229576,229550,'2007-11-13 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229577,229550,'2007-11-27 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229578,229550,'2007-09-25 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229579,229550,'2007-10-25 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229580,229550,'2007-09-20 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229581,229550,'2007-10-04 00:00:00',90,0,108,-15,2,0,'2008-05-07',1),
	(229584,229582,'2007-11-27 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229585,229582,'2007-10-23 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229586,229582,'2007-11-06 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229587,229582,'2007-08-21 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229588,229582,'2007-08-28 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229589,229582,'2007-09-18 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229590,229582,'2007-09-11 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229591,229582,'2007-10-02 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229592,229582,'2007-11-13 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229593,229582,'2007-10-16 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229594,229582,'2007-11-20 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229595,229582,'2007-09-04 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229596,229582,'2007-10-30 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229597,229582,'2007-12-04 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229598,229582,'2007-09-25 00:00:00',114,0,126,-10,3,0,'2008-05-07',1),
	(229601,229599,'2007-12-03 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229602,229599,'2007-09-24 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229603,229599,'2007-10-15 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229604,229599,'2007-11-12 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229605,229599,'2007-11-19 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229606,229599,'2007-10-01 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229607,229599,'2007-09-10 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229608,229599,'2007-11-05 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229609,229599,'2007-09-17 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229610,229599,'2007-08-20 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229611,229599,'2007-10-22 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229612,229599,'2007-10-29 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229613,229599,'2007-11-26 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229614,229599,'2007-08-27 00:00:00',186,0,198,-10,4,0,'2008-05-07',1),
	(229617,229615,'2007-10-16 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229618,229615,'2007-11-08 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229619,229615,'2007-09-11 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229620,229615,'2007-10-23 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229621,229615,'2007-10-02 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229622,229615,'2007-12-04 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229623,229615,'2007-11-06 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229624,229615,'2007-09-18 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229625,229615,'2007-12-06 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229626,229615,'2007-11-27 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229627,229615,'2007-09-06 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229628,229615,'2007-10-25 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229629,229615,'2007-08-28 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229630,229615,'2007-08-23 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229631,229615,'2007-10-18 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229632,229615,'2007-11-13 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229633,229615,'2007-09-27 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229634,229615,'2007-09-13 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229635,229615,'2007-11-20 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229636,229615,'2007-09-20 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229637,229615,'2007-10-11 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229638,229615,'2007-10-30 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229639,229615,'2007-08-21 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229640,229615,'2007-09-25 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229641,229615,'2007-11-29 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229642,229615,'2007-09-04 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229643,229615,'2007-11-01 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229644,229615,'2007-11-15 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229645,229615,'2007-10-04 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229646,229615,'2007-08-30 00:00:00',162,0,180,-15,3,0,'2008-05-07',1),
	(229649,229647,'2007-12-06 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229650,229647,'2007-10-30 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229651,229647,'2007-10-04 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229652,229647,'2007-11-06 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229653,229647,'2007-09-25 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229654,229647,'2007-09-11 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229655,229647,'2007-09-20 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229656,229647,'2007-10-23 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229657,229647,'2007-08-23 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229658,229647,'2007-10-18 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229659,229647,'2007-10-02 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229660,229647,'2007-10-16 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229661,229647,'2007-08-30 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229662,229647,'2007-10-25 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229663,229647,'2007-11-08 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229664,229647,'2007-10-11 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229665,229647,'2007-09-27 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229666,229647,'2007-09-13 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229667,229647,'2007-09-06 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229668,229647,'2007-11-15 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229669,229647,'2007-11-01 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229670,229647,'2007-11-27 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229671,229647,'2007-09-18 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229672,229647,'2007-12-04 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229673,229647,'2007-08-28 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229674,229647,'2007-08-21 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229675,229647,'2007-11-13 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229676,229647,'2007-11-29 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229677,229647,'2007-09-04 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229678,229647,'2007-11-20 00:00:00',198,0,216,-15,2,0,'2008-05-07',1),
	(229681,229679,'2007-08-28 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229682,229679,'2007-10-04 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229683,229679,'2007-10-25 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229684,229679,'2007-11-13 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229685,229679,'2007-08-23 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229686,229679,'2007-09-06 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229687,229679,'2007-09-25 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229688,229679,'2007-09-11 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229689,229679,'2007-10-18 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229690,229679,'2007-10-11 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229691,229679,'2007-10-30 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229692,229679,'2007-08-30 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229693,229679,'2007-11-27 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229694,229679,'2007-10-23 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229695,229679,'2007-11-08 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229696,229679,'2007-11-06 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229697,229679,'2007-10-16 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229698,229679,'2007-10-02 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229699,229679,'2007-09-20 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229700,229679,'2007-08-21 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229701,229679,'2007-09-27 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229702,229679,'2007-11-29 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229703,229679,'2007-11-15 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229704,229679,'2007-12-06 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229705,229679,'2007-09-04 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229706,229679,'2007-09-13 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229707,229679,'2007-09-18 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229708,229679,'2007-11-01 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229709,229679,'2007-12-04 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229710,229679,'2007-11-20 00:00:00',90,0,108,-15,4,0,'2008-05-07',1),
	(229713,229711,'2007-09-18 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229714,229711,'2007-08-28 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229715,229711,'2007-10-04 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229716,229711,'2007-09-27 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229717,229711,'2007-11-08 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229718,229711,'2007-10-11 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229719,229711,'2007-09-11 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229720,229711,'2007-09-25 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229721,229711,'2007-12-06 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229722,229711,'2007-08-23 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229723,229711,'2007-10-23 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229724,229711,'2007-11-20 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229725,229711,'2007-09-20 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229726,229711,'2007-08-21 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229727,229711,'2007-10-02 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229728,229711,'2007-11-27 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229729,229711,'2007-11-06 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229730,229711,'2007-10-18 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229731,229711,'2007-08-30 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229732,229711,'2007-11-01 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229733,229711,'2007-09-13 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229734,229711,'2007-11-13 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229735,229711,'2007-11-15 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229736,229711,'2007-09-06 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229737,229711,'2007-11-29 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229738,229711,'2007-10-16 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229739,229711,'2007-10-30 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229740,229711,'2007-12-04 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229741,229711,'2007-09-04 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229742,229711,'2007-10-25 00:00:00',180,0,198,-15,3,0,'2008-05-07',1),
	(229745,229743,'2007-09-06 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229746,229743,'2007-10-30 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229747,229743,'2007-09-25 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229748,229743,'2007-11-27 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229749,229743,'2007-08-21 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229750,229743,'2007-10-23 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229751,229743,'2007-11-01 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229752,229743,'2007-10-18 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229753,229743,'2007-09-11 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229754,229743,'2007-11-08 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229755,229743,'2007-09-18 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229756,229743,'2007-11-29 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229757,229743,'2007-10-16 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229758,229743,'2007-10-04 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229759,229743,'2007-11-15 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229760,229743,'2007-11-06 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229761,229743,'2007-08-23 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229762,229743,'2007-11-20 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229763,229743,'2007-12-04 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229764,229743,'2007-09-20 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229765,229743,'2007-09-13 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229766,229743,'2007-09-04 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229767,229743,'2007-12-06 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229768,229743,'2007-09-27 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229769,229743,'2007-10-25 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229770,229743,'2007-08-28 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229771,229743,'2007-11-13 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229772,229743,'2007-10-02 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229773,229743,'2007-08-30 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229774,229743,'2007-10-11 00:00:00',162,0,180,-15,2,0,'2008-05-07',1),
	(229777,229775,'2007-08-20 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229778,229775,'2007-09-26 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229779,229775,'2007-09-17 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229780,229775,'2007-08-27 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229781,229775,'2007-12-07 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229782,229775,'2007-12-03 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229783,229775,'2007-09-07 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229784,229775,'2007-10-10 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229785,229775,'2007-11-26 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229786,229775,'2007-09-12 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229787,229775,'2007-09-05 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229788,229775,'2007-11-28 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229789,229775,'2007-09-24 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229790,229775,'2007-11-09 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229791,229775,'2007-11-16 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229792,229775,'2007-09-14 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229793,229775,'2007-09-28 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229794,229775,'2007-09-19 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229795,229775,'2007-11-19 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229796,229775,'2007-11-07 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229797,229775,'2007-11-12 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229798,229775,'2007-10-19 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229799,229775,'2007-10-17 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229800,229775,'2007-11-30 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229801,229775,'2007-12-05 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229802,229775,'2007-11-05 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229803,229775,'2007-10-22 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229804,229775,'2007-09-10 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229805,229775,'2007-10-31 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229806,229775,'2007-10-24 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229807,229775,'2007-09-21 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229808,229775,'2007-10-05 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229809,229775,'2007-10-01 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229810,229775,'2007-11-02 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229811,229775,'2007-10-15 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229812,229775,'2007-11-14 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229813,229775,'2007-10-26 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229814,229775,'2007-10-03 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229815,229775,'2007-08-31 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229816,229775,'2007-08-29 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229817,229775,'2007-10-12 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229818,229775,'2007-08-24 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229819,229775,'2007-10-29 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229820,229775,'2007-08-22 00:00:00',90,0,102,-10,2,0,'2008-05-07',1),
	(229823,229821,'2007-08-29 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229824,229821,'2007-09-12 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229825,229821,'2007-09-26 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229826,229821,'2007-10-10 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229827,229821,'2007-10-24 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229828,229821,'2007-11-28 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229829,229821,'2007-09-05 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229830,229821,'2007-10-31 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229831,229821,'2007-11-14 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229832,229821,'2007-08-22 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229833,229821,'2007-10-03 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229834,229821,'2007-12-05 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229835,229821,'2007-11-07 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229836,229821,'2007-10-17 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229837,229821,'2007-09-19 00:00:00',114,0,126,-10,8,0,'2008-05-07',1),
	(229840,229838,'2007-08-23 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229841,229838,'2007-11-15 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229842,229838,'2007-10-18 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229843,229838,'2007-10-25 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229844,229838,'2007-09-13 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229845,229838,'2007-11-29 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229846,229838,'2007-10-02 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229847,229838,'2007-11-20 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229848,229838,'2007-12-06 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229849,229838,'2007-09-20 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229850,229838,'2007-09-25 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229851,229838,'2007-10-04 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229852,229838,'2007-11-06 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229853,229838,'2007-11-13 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229854,229838,'2007-10-23 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229855,229838,'2007-10-11 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229856,229838,'2007-11-01 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229857,229838,'2007-09-11 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229858,229838,'2007-10-16 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229859,229838,'2007-08-30 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229860,229838,'2007-12-04 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229861,229838,'2007-11-27 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229862,229838,'2007-08-21 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229863,229838,'2007-09-27 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229864,229838,'2007-09-18 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229865,229838,'2007-09-04 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229866,229838,'2007-11-08 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229867,229838,'2007-08-28 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229868,229838,'2007-09-06 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229869,229838,'2007-10-30 00:00:00',180,0,198,-15,2,0,'2008-05-07',1),
	(229872,229870,'2007-10-03 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229873,229870,'2007-10-17 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229874,229870,'2007-11-07 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229875,229870,'2007-08-29 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229876,229870,'2007-11-28 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229877,229870,'2007-09-19 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229878,229870,'2007-10-24 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229879,229870,'2007-11-14 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229880,229870,'2007-12-05 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229881,229870,'2007-09-26 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229882,229870,'2007-08-22 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229883,229870,'2007-09-12 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229884,229870,'2007-10-10 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229885,229870,'2007-09-05 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229886,229870,'2007-10-31 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229889,229887,'2007-10-31 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229890,229887,'2007-09-26 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229891,229887,'2007-08-24 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229892,229887,'2007-10-03 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229893,229887,'2007-11-14 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229894,229887,'2007-10-29 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229895,229887,'2007-09-07 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229896,229887,'2007-10-10 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229897,229887,'2007-10-26 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229898,229887,'2007-09-10 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229899,229887,'2007-09-05 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229900,229887,'2007-11-02 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229901,229887,'2007-10-19 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229902,229887,'2007-09-28 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229903,229887,'2007-10-17 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229904,229887,'2007-09-19 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229905,229887,'2007-08-22 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229906,229887,'2007-11-07 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229907,229887,'2007-09-24 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229908,229887,'2007-11-30 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229909,229887,'2007-08-20 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229910,229887,'2007-11-05 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229911,229887,'2007-09-14 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229912,229887,'2007-11-19 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229913,229887,'2007-10-22 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229914,229887,'2007-12-07 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229915,229887,'2007-10-15 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229916,229887,'2007-11-26 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229917,229887,'2007-10-05 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229918,229887,'2007-11-16 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229919,229887,'2007-11-28 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229920,229887,'2007-10-01 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229921,229887,'2007-11-09 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229922,229887,'2007-08-31 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229923,229887,'2007-10-12 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229924,229887,'2007-08-29 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229925,229887,'2007-09-17 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229926,229887,'2007-09-12 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229927,229887,'2007-09-21 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229928,229887,'2007-12-05 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229929,229887,'2007-11-12 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229930,229887,'2007-10-24 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229931,229887,'2007-12-03 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229932,229887,'2007-08-27 00:00:00',174,0,186,-10,3,0,'2008-05-07',1),
	(229935,229933,'2007-11-29 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229936,229933,'2007-10-11 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229937,229933,'2007-09-13 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229938,229933,'2007-10-25 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229939,229933,'2007-08-30 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229940,229933,'2007-11-15 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229941,229933,'2007-12-06 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229942,229933,'2007-11-01 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229943,229933,'2007-09-27 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229944,229933,'2007-08-23 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229945,229933,'2007-11-08 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229946,229933,'2007-10-18 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229947,229933,'2007-09-06 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229948,229933,'2007-10-04 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229949,229933,'2007-09-20 00:00:00',150,0,162,-10,8,0,'2008-05-07',1),
	(229952,229950,'2007-12-04 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229953,229950,'2007-11-27 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229954,229950,'2007-11-06 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229955,229950,'2007-09-18 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229956,229950,'2007-08-21 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229957,229950,'2007-09-25 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229958,229950,'2007-11-13 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229959,229950,'2007-10-16 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229960,229950,'2007-09-11 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229961,229950,'2007-10-23 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229962,229950,'2007-10-02 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229963,229950,'2007-11-20 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229964,229950,'2007-08-28 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229965,229950,'2007-09-04 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229966,229950,'2007-10-30 00:00:00',162,0,174,-10,8,0,'2008-05-07',1),
	(229969,229967,'2007-10-16 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229970,229967,'2007-11-06 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229971,229967,'2007-09-18 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229972,229967,'2007-11-13 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229973,229967,'2007-08-21 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229974,229967,'2007-10-02 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229975,229967,'2007-10-23 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229976,229967,'2007-09-25 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229977,229967,'2007-10-30 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229978,229967,'2007-11-27 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229979,229967,'2007-09-04 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229980,229967,'2007-12-04 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229981,229967,'2007-09-11 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229982,229967,'2007-11-20 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229983,229967,'2007-08-28 00:00:00',102,0,114,-10,8,0,'2008-05-07',1),
	(229986,229984,'2007-09-04 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229987,229984,'2007-10-30 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229988,229984,'2007-10-02 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229989,229984,'2007-08-21 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229990,229984,'2007-10-16 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229991,229984,'2007-12-04 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229992,229984,'2007-11-27 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229993,229984,'2007-11-06 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229994,229984,'2007-09-25 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229995,229984,'2007-10-23 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229996,229984,'2007-08-28 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229997,229984,'2007-11-13 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229998,229984,'2007-09-11 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(229999,229984,'2007-09-18 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(230000,229984,'2007-11-20 00:00:00',186,0,198,-10,8,0,'2008-05-07',1),
	(230003,230001,'2007-09-13 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230004,230001,'2007-10-25 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230005,230001,'2007-11-29 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230006,230001,'2007-11-01 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230007,230001,'2007-11-08 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230008,230001,'2007-08-30 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230009,230001,'2007-09-20 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230010,230001,'2007-08-23 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230011,230001,'2007-10-04 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230012,230001,'2007-10-11 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230013,230001,'2007-11-15 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230014,230001,'2007-09-27 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230015,230001,'2007-09-06 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230016,230001,'2007-12-06 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230017,230001,'2007-10-18 00:00:00',138,0,150,-10,8,0,'2008-05-07',1),
	(230020,230018,'2007-12-03 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230021,230018,'2007-08-27 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230022,230018,'2007-11-12 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230023,230018,'2007-08-20 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230024,230018,'2007-10-15 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230025,230018,'2007-09-24 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230026,230018,'2007-09-17 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230027,230018,'2007-11-26 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230028,230018,'2007-10-01 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230029,230018,'2007-11-19 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230030,230018,'2007-09-10 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230031,230018,'2007-10-29 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230032,230018,'2007-10-22 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230033,230018,'2007-11-05 00:00:00',114,0,138,-10,8,0,'2008-05-07',1),
	(230036,230034,'2007-10-16 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230037,230034,'2007-10-02 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230038,230034,'2007-08-21 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230039,230034,'2007-11-27 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230040,230034,'2007-09-25 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230041,230034,'2007-11-20 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230042,230034,'2007-09-18 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230043,230034,'2007-12-04 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230044,230034,'2007-09-04 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230045,230034,'2007-11-06 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230046,230034,'2007-09-11 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230047,230034,'2007-08-28 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230048,230034,'2007-11-13 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230049,230034,'2007-10-23 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230050,230034,'2007-10-30 00:00:00',138,0,162,-10,8,0,'2008-05-07',1),
	(230053,230051,'2007-10-03 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230054,230051,'2007-09-24 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230055,230051,'2007-11-07 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230056,230051,'2007-08-24 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230057,230051,'2007-08-27 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230058,230051,'2007-11-26 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230059,230051,'2007-09-21 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230060,230051,'2007-09-05 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230061,230051,'2007-11-14 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230062,230051,'2007-10-10 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230063,230051,'2007-08-22 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230064,230051,'2007-11-05 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230065,230051,'2007-10-31 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230066,230051,'2007-10-12 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230067,230051,'2007-09-07 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230068,230051,'2007-08-31 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230069,230051,'2007-10-17 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230070,230051,'2007-12-03 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230071,230051,'2007-09-26 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230072,230051,'2007-09-10 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230073,230051,'2007-11-19 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230074,230051,'2007-11-16 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230075,230051,'2007-10-15 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230076,230051,'2007-11-28 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230077,230051,'2007-12-07 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230078,230051,'2007-10-29 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230079,230051,'2007-11-02 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230080,230051,'2007-09-12 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230081,230051,'2007-09-19 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230082,230051,'2007-09-17 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230083,230051,'2007-10-01 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230084,230051,'2007-08-20 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230085,230051,'2007-09-28 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230086,230051,'2007-11-30 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230087,230051,'2007-10-19 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230088,230051,'2007-11-12 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230089,230051,'2007-12-05 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230090,230051,'2007-10-22 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230091,230051,'2007-10-24 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230092,230051,'2007-10-26 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230093,230051,'2007-08-29 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230094,230051,'2007-11-09 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230095,230051,'2007-09-14 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230096,230051,'2007-10-05 00:00:00',138,0,150,-10,3,0,'2008-05-07',1),
	(230099,230097,'2007-12-04 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230100,230097,'2007-11-20 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230101,230097,'2007-08-28 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230102,230097,'2007-10-04 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230103,230097,'2007-11-08 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230104,230097,'2007-09-04 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230105,230097,'2007-10-25 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230106,230097,'2007-10-18 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230107,230097,'2007-11-06 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230108,230097,'2007-09-25 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230109,230097,'2007-08-21 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230110,230097,'2007-10-11 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230111,230097,'2007-11-27 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230112,230097,'2007-10-16 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230113,230097,'2007-10-30 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230114,230097,'2007-09-06 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230115,230097,'2007-09-27 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230116,230097,'2007-09-13 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230117,230097,'2007-11-29 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230118,230097,'2007-09-20 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230119,230097,'2007-08-23 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230120,230097,'2007-11-01 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230121,230097,'2007-11-15 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230122,230097,'2007-12-06 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230123,230097,'2007-10-02 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230124,230097,'2007-10-23 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230125,230097,'2007-08-30 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230126,230097,'2007-11-13 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230127,230097,'2007-09-11 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230128,230097,'2007-09-18 00:00:00',198,0,216,-15,3,0,'2008-05-07',1),
	(230131,230129,'2007-09-05 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230132,230129,'2007-09-19 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230133,230129,'2007-11-07 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230134,230129,'2007-09-26 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230135,230129,'2007-09-12 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230136,230129,'2007-11-28 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230137,230129,'2007-08-29 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230138,230129,'2007-10-24 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230139,230129,'2007-10-10 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230140,230129,'2007-10-31 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230141,230129,'2007-11-14 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230142,230129,'2007-12-05 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230143,230129,'2007-10-17 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230144,230129,'2007-10-03 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230145,230129,'2007-08-22 00:00:00',126,0,138,-10,8,0,'2008-05-07',1),
	(230148,230146,'2007-08-30 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230149,230146,'2007-09-27 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230150,230146,'2007-09-25 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230151,230146,'2007-08-28 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230152,230146,'2007-10-23 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230153,230146,'2007-09-13 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230154,230146,'2007-09-06 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230155,230146,'2007-11-29 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230156,230146,'2007-11-13 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230157,230146,'2007-10-30 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230158,230146,'2007-11-27 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230159,230146,'2007-09-11 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230160,230146,'2007-11-06 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230161,230146,'2007-08-23 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230162,230146,'2007-11-08 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230163,230146,'2007-10-02 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230164,230146,'2007-11-15 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230165,230146,'2007-09-20 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230166,230146,'2007-09-18 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230167,230146,'2007-08-21 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230168,230146,'2007-10-25 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230169,230146,'2007-12-04 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230170,230146,'2007-12-06 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230171,230146,'2007-10-18 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230172,230146,'2007-11-01 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230173,230146,'2007-09-04 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230174,230146,'2007-10-16 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230175,230146,'2007-10-04 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230176,230146,'2007-10-11 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230177,230146,'2007-11-20 00:00:00',108,0,126,-15,4,0,'2008-05-07',1),
	(230180,230178,'2007-10-02 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230181,230178,'2007-08-21 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230182,230178,'2007-08-28 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230183,230178,'2007-11-20 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230184,230178,'2007-11-27 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230185,230178,'2007-10-16 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230186,230178,'2007-11-06 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230187,230178,'2007-10-30 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230188,230178,'2007-09-25 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230189,230178,'2007-09-04 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230190,230178,'2007-09-11 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230191,230178,'2007-09-18 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230192,230178,'2007-12-04 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230193,230178,'2007-11-13 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230194,230178,'2007-10-23 00:00:00',90,0,102,-10,8,0,'2008-05-07',1),
	(230197,230195,'2007-11-20 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230198,230195,'2007-08-23 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230199,230195,'2007-10-25 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230200,230195,'2007-09-25 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230201,230195,'2007-09-06 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230202,230195,'2007-08-30 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230203,230195,'2007-08-28 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230204,230195,'2007-10-18 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230205,230195,'2007-08-21 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230206,230195,'2007-12-06 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230207,230195,'2007-10-04 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230208,230195,'2007-11-06 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230209,230195,'2007-10-16 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230210,230195,'2007-11-15 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230211,230195,'2007-09-04 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230212,230195,'2007-11-27 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230213,230195,'2007-10-23 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230214,230195,'2007-09-27 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230215,230195,'2007-11-08 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230216,230195,'2007-09-13 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230217,230195,'2007-11-29 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230218,230195,'2007-11-13 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230219,230195,'2007-09-20 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230220,230195,'2007-11-01 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230221,230195,'2007-10-02 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230222,230195,'2007-10-11 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230223,230195,'2007-12-04 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230224,230195,'2007-09-11 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230225,230195,'2007-09-18 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230226,230195,'2007-10-30 00:00:00',108,0,126,-15,2,0,'2008-05-07',1),
	(230229,230227,'2007-09-27 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230230,230227,'2007-09-11 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230231,230227,'2007-10-04 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230232,230227,'2007-10-25 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230233,230227,'2007-10-16 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230234,230227,'2007-10-18 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230235,230227,'2007-11-27 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230236,230227,'2007-11-15 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230237,230227,'2007-09-25 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230238,230227,'2007-11-29 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230239,230227,'2007-10-11 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230240,230227,'2007-11-06 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230241,230227,'2007-08-21 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230242,230227,'2007-12-06 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230243,230227,'2007-11-01 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230244,230227,'2007-09-06 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230245,230227,'2007-08-30 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230246,230227,'2007-09-13 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230247,230227,'2007-08-23 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230248,230227,'2007-08-28 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230249,230227,'2007-11-20 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230250,230227,'2007-10-02 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230251,230227,'2007-09-04 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230252,230227,'2007-11-13 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230253,230227,'2007-12-04 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230254,230227,'2007-09-18 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230255,230227,'2007-10-23 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230256,230227,'2007-09-20 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230257,230227,'2007-11-08 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230258,230227,'2007-10-30 00:00:00',174,0,186,-10,1,0,'2008-05-07',1),
	(230261,230259,'2007-11-20 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230262,230259,'2007-10-23 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230263,230259,'2007-11-08 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230264,230259,'2007-11-27 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230265,230259,'2007-08-28 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230266,230259,'2007-10-30 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230267,230259,'2007-09-25 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230268,230259,'2007-11-01 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230269,230259,'2007-10-11 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230270,230259,'2007-08-30 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230271,230259,'2007-11-29 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230272,230259,'2007-09-20 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230273,230259,'2007-11-13 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230274,230259,'2007-09-18 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230275,230259,'2007-10-04 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230276,230259,'2007-09-27 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230277,230259,'2007-11-06 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230278,230259,'2007-12-04 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230279,230259,'2007-08-21 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230280,230259,'2007-08-23 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230281,230259,'2007-10-02 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230282,230259,'2007-11-15 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230283,230259,'2007-09-11 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230284,230259,'2007-09-04 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230285,230259,'2007-12-06 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230286,230259,'2007-09-13 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230287,230259,'2007-10-25 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230288,230259,'2007-09-06 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230289,230259,'2007-10-16 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230290,230259,'2007-10-18 00:00:00',144,0,162,-15,2,0,'2008-05-07',1),
	(230293,230291,'2007-09-27 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230294,230291,'2007-10-04 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230295,230291,'2007-11-01 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230296,230291,'2007-09-13 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230297,230291,'2007-11-15 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230298,230291,'2007-09-20 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230299,230291,'2007-10-11 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230300,230291,'2007-08-30 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230301,230291,'2007-11-08 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230302,230291,'2007-08-23 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230303,230291,'2007-10-25 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230304,230291,'2007-11-29 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230305,230291,'2007-12-06 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230306,230291,'2007-09-06 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(230307,230291,'2007-10-18 00:00:00',90,0,114,-10,8,0,'2008-05-07',1),
	(231210,231209,'2007-12-11 00:00:00',96,0,120,0,3,0,'2008-05-16',1),
	(231212,231211,'2007-12-10 00:00:00',138,0,150,0,1,0,'2008-05-16',1),
	(231214,231213,'2007-12-12 00:00:00',156,0,192,0,1,0,'2008-05-16',1),
	(231215,231213,'2007-12-12 00:00:00',156,0,192,0,3,0,'2008-05-16',1),
	(231217,231216,'2007-12-10 00:00:00',156,0,192,0,4,0,'2008-05-16',1),
	(231218,231216,'2007-12-10 00:00:00',156,0,192,0,2,0,'2008-05-16',1),
	(231220,231219,'2007-12-10 00:00:00',156,0,192,0,3,0,'2008-05-16',1),
	(231221,231219,'2007-12-10 00:00:00',156,0,192,0,1,0,'2008-05-16',1),
	(231223,231222,'2007-12-11 00:00:00',138,0,150,0,9,0,'2008-05-16',1),
	(231225,231224,'2007-12-13 00:00:00',138,0,150,0,1,0,'2008-05-16',1),
	(231226,231224,'2007-12-13 00:00:00',138,0,150,0,9,0,'2008-05-16',1),
	(231228,231227,'2007-12-10 00:00:00',138,0,150,0,9,0,'2008-05-16',1),
	(231230,231229,'2007-12-11 00:00:00',156,0,192,-60,1,0,'2008-05-16',1),
	(231232,231231,'2007-12-11 00:00:00',96,0,120,0,1,0,'2008-05-16',1),
	(231234,231233,'2007-12-10 00:00:00',96,0,120,0,1,0,'2008-05-16',1),
	(231236,231235,'2007-12-11 00:00:00',156,0,192,-120,3,0,'2008-05-16',1),
	(231237,231235,'2007-12-11 00:00:00',156,0,192,-120,2,0,'2008-05-16',1),
	(231239,231238,'2007-12-12 00:00:00',96,0,120,-60,2,0,'2008-05-16',1),
	(231240,231238,'2007-12-12 00:00:00',96,0,120,-60,3,0,'2008-05-16',1),
	(231242,231241,'2007-12-13 00:00:00',96,0,120,0,1,0,'2008-05-16',1),
	(231244,231243,'2007-12-12 00:00:00',138,0,150,0,1,0,'2008-05-16',1),
	(231245,231243,'2007-12-12 00:00:00',138,0,150,0,9,0,'2008-05-16',1),
	(231246,231243,'2007-12-12 00:00:00',138,0,150,0,3,0,'2008-05-16',1),
	(231248,231247,'2007-12-10 00:00:00',96,0,120,0,2,0,'2008-05-16',1),
	(231250,231249,'2007-12-10 00:00:00',96,0,120,0,9,0,'2008-05-16',1),
	(231252,231251,'2007-12-11 00:00:00',96,0,120,0,2,0,'2008-05-16',1),
	(231254,231253,'2007-12-10 00:00:00',156,0,192,-60,9,0,'2008-05-16',1),
	(231256,231255,'2007-12-12 00:00:00',156,0,192,-60,2,0,'2008-05-16',1),
	(231258,231257,'2007-12-11 00:00:00',156,0,192,-60,9,0,'2008-05-16',1),
	(231260,231259,'2007-12-13 00:00:00',96,0,120,-60,9,0,'2008-05-16',1),
	(231262,231261,'2007-12-12 00:00:00',96,0,120,-60,9,0,'2008-05-16',1),
	(231264,231263,'2007-12-11 00:00:00',96,0,120,0,9,0,'2008-05-16',1),
	(231266,231265,'2007-12-12 00:00:00',156,0,192,-60,9,0,'2008-05-16',1),
	(231268,231267,'2007-12-12 00:00:00',96,0,120,0,1,0,'2008-05-16',1),
	(231317,231315,'2007-08-06 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231318,231315,'2007-08-13 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231319,231315,'2007-08-20 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231320,231315,'2007-08-27 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231321,231315,'2007-09-03 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231322,231315,'2007-09-10 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231323,231315,'2007-09-17 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231324,231315,'2007-09-24 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231325,231315,'2007-10-01 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231326,231315,'2007-10-08 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231327,231315,'2007-10-15 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231328,231315,'2007-10-22 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231329,231315,'2007-10-29 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231330,231315,'2007-11-05 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231331,231315,'2007-11-12 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231332,231315,'2007-11-19 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231333,231315,'2007-11-26 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231334,231315,'2007-12-03 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231335,231315,'2007-12-10 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231336,231315,'2007-12-17 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231337,231315,'2007-12-24 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231338,231315,'2007-12-31 00:00:00',240,NULL,264,NULL,9,1,'2007-07-22',1),
	(231344,231343,'2007-08-28 00:00:00',222,0,234,0,2,0,'2008-07-22',1),
	(231346,231345,'2007-09-11 00:00:00',222,0,234,0,2,0,'2008-07-22',1),
	(231348,231347,'2007-11-06 00:00:00',240,0,264,0,2,0,'2008-07-22',1),
	(231350,231349,'2007-09-11 00:00:00',240,0,264,0,9,0,'2008-07-22',1),
	(231351,231349,'2007-09-11 00:00:00',240,0,264,0,2,0,'2008-07-22',1),
	(231353,231352,'2007-11-07 00:00:00',240,0,264,0,9,0,'2008-07-22',1),
	(231354,231352,'2007-11-07 00:00:00',240,0,264,0,1,0,'2008-07-22',1),
	(231356,231355,'2007-10-23 00:00:00',240,0,264,0,4,0,'2008-07-22',1),
	(231357,231355,'2007-10-23 00:00:00',240,0,264,0,1,0,'2008-07-22',1),
	(231358,231355,'2007-10-23 00:00:00',240,0,264,0,9,0,'2008-07-22',1),
	(231360,231359,'2007-09-12 00:00:00',240,0,264,0,9,0,'2008-07-22',1),
	(231362,231361,'2007-10-24 00:00:00',240,0,264,0,9,0,'2008-07-22',1),
	(231364,231363,'2007-09-05 00:00:00',240,0,264,0,9,0,'2008-07-22',1),
	(231365,231363,'2007-09-05 00:00:00',240,0,264,0,3,0,'2008-07-22',1),
	(231366,231363,'2007-09-05 00:00:00',240,0,264,0,2,0,'2008-07-22',1),
	(231368,231367,'2007-10-16 00:00:00',240,0,264,0,3,0,'2008-07-22',1),
	(231369,231367,'2007-10-16 00:00:00',240,0,264,0,9,0,'2008-07-22',1),
	(231370,231367,'2007-10-16 00:00:00',240,0,264,0,2,0,'2008-07-22',1),
	(233326,233325,'2010-11-30 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233327,233325,'2010-11-16 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233328,233325,'2010-11-02 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233329,233325,'2010-11-23 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233330,233325,'2010-11-09 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233331,233325,'2010-08-31 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233332,233325,'2010-12-07 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233333,233325,'2010-09-14 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233334,233325,'2010-09-28 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233335,233325,'2010-08-24 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233336,233325,'2010-09-21 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233337,233325,'2010-10-26 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233338,233325,'2010-10-05 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233339,233325,'2010-10-19 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233340,233325,'2010-09-07 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233342,233341,'2010-10-08 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233343,233341,'2010-12-03 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233344,233341,'2010-10-01 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233345,233341,'2010-09-03 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233346,233341,'2010-09-10 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233347,233341,'2010-09-24 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233348,233341,'2010-10-15 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233349,233341,'2010-11-19 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233350,233341,'2010-09-17 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233351,233341,'2010-11-12 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233352,233341,'2010-10-22 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233353,233341,'2010-11-05 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233354,233341,'2010-12-10 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233355,233341,'2010-08-27 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233356,233341,'2010-10-29 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233358,233357,'2010-12-03 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233359,233357,'2010-09-10 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233360,233357,'2010-11-05 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233361,233357,'2010-11-19 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233362,233357,'2010-10-15 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233363,233357,'2010-10-01 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233364,233357,'2010-09-03 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233365,233357,'2010-09-17 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233366,233357,'2010-11-12 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233367,233357,'2010-10-22 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233368,233357,'2010-08-27 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233369,233357,'2010-10-08 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233370,233357,'2010-12-10 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233371,233357,'2010-10-29 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233372,233357,'2010-09-24 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233374,233373,'2010-12-09 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233375,233373,'2010-10-07 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233376,233373,'2010-12-02 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233377,233373,'2010-10-14 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233378,233373,'2010-11-04 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233379,233373,'2010-11-18 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233380,233373,'2010-09-09 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233381,233373,'2010-11-11 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233382,233373,'2010-09-16 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233383,233373,'2010-09-23 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233384,233373,'2010-09-02 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233385,233373,'2010-09-30 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233386,233373,'2010-08-26 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233387,233373,'2010-10-28 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233388,233373,'2010-10-21 00:00:00',90,0,126,-10,3,0,'2010-09-22',1),
	(233390,233389,'2010-08-24 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233391,233389,'2010-11-30 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233392,233389,'2010-11-23 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233393,233389,'2010-09-28 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233394,233389,'2010-09-21 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233395,233389,'2010-08-31 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233396,233389,'2010-09-14 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233397,233389,'2010-12-07 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233398,233389,'2010-10-05 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233399,233389,'2010-10-26 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233400,233389,'2010-11-09 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233401,233389,'2010-11-16 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233402,233389,'2010-09-07 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233403,233389,'2010-11-02 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233404,233389,'2010-10-19 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233406,233405,'2010-12-09 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233407,233405,'2010-10-07 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233408,233405,'2010-11-18 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233409,233405,'2010-09-23 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233410,233405,'2010-09-16 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233411,233405,'2010-11-11 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233412,233405,'2010-09-02 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233413,233405,'2010-09-09 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233414,233405,'2010-11-04 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233415,233405,'2010-09-30 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233416,233405,'2010-08-26 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233417,233405,'2010-10-28 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233418,233405,'2010-12-02 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233419,233405,'2010-10-14 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233420,233405,'2010-10-21 00:00:00',180,0,216,-10,7,0,'2010-09-22',1),
	(233422,233421,'2010-12-08 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233423,233421,'2010-10-06 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233424,233421,'2010-08-25 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233425,233421,'2010-09-08 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233426,233421,'2010-09-15 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233427,233421,'2010-09-29 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233428,233421,'2010-10-20 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233429,233421,'2010-10-27 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233430,233421,'2010-12-01 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233431,233421,'2010-11-17 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233432,233421,'2010-09-22 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233433,233421,'2010-11-10 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233434,233421,'2010-09-01 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233435,233421,'2010-11-03 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233436,233421,'2010-10-13 00:00:00',90,0,126,-10,6,0,'2010-09-22',1),
	(233438,233437,'2010-12-08 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233439,233437,'2010-10-20 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233440,233437,'2010-09-01 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233441,233437,'2010-11-10 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233442,233437,'2010-11-03 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233443,233437,'2010-10-27 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233444,233437,'2010-09-22 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233445,233437,'2010-09-29 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233446,233437,'2010-12-01 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233447,233437,'2010-08-25 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233448,233437,'2010-09-08 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233449,233437,'2010-10-06 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233450,233437,'2010-11-17 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233451,233437,'2010-10-13 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233452,233437,'2010-09-15 00:00:00',180,0,216,-10,6,0,'2010-09-22',1),
	(233454,233453,'2010-10-08 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233455,233453,'2010-10-01 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233456,233453,'2010-12-10 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233457,233453,'2010-09-03 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233458,233453,'2010-10-22 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233459,233453,'2010-09-10 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233460,233453,'2010-09-24 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233461,233453,'2010-10-15 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233462,233453,'2010-12-03 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233463,233453,'2010-10-29 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233464,233453,'2010-09-17 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233465,233453,'2010-11-12 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233466,233453,'2010-11-19 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233467,233453,'2010-08-27 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233468,233453,'2010-11-05 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233470,233469,'2010-09-21 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233471,233469,'2010-11-02 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233472,233469,'2010-10-19 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233473,233469,'2010-12-07 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233474,233469,'2010-08-31 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233475,233469,'2010-09-07 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233476,233469,'2010-11-23 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233477,233469,'2010-09-14 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233478,233469,'2010-09-28 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233479,233469,'2010-10-05 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233480,233469,'2010-10-26 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233481,233469,'2010-11-16 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233482,233469,'2010-08-24 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233483,233469,'2010-11-09 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233484,233469,'2010-11-30 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(233486,233485,'2010-10-19 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233487,233485,'2010-11-23 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233488,233485,'2010-11-30 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233489,233485,'2010-08-31 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233490,233485,'2010-11-16 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233491,233485,'2010-08-24 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233492,233485,'2010-09-28 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233493,233485,'2010-10-05 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233494,233485,'2010-11-02 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233495,233485,'2010-10-26 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233496,233485,'2010-09-21 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233497,233485,'2010-12-07 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233498,233485,'2010-09-14 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233499,233485,'2010-09-07 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233500,233485,'2010-11-09 00:00:00',90,0,126,-10,7,0,'2010-09-22',1),
	(233502,233501,'2010-12-01 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233503,233501,'2010-11-10 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233504,233501,'2010-11-17 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233505,233501,'2010-12-08 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233506,233501,'2010-09-01 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233507,233501,'2010-11-03 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233508,233501,'2010-09-08 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233509,233501,'2010-09-22 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233510,233501,'2010-10-20 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233511,233501,'2010-08-25 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233512,233501,'2010-09-29 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233513,233501,'2010-09-15 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233514,233501,'2010-10-06 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233515,233501,'2010-10-13 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233516,233501,'2010-10-27 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233518,233517,'2010-12-06 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233519,233517,'2010-11-15 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233520,233517,'2010-11-08 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233521,233517,'2010-09-20 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233522,233517,'2010-11-01 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233523,233517,'2010-09-13 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233524,233517,'2010-10-18 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233525,233517,'2010-09-27 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233526,233517,'2010-10-25 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233527,233517,'2010-08-30 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233528,233517,'2010-11-29 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233529,233517,'2010-08-23 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233530,233517,'2010-11-22 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233531,233517,'2010-10-04 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233533,233532,'2010-11-05 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233534,233532,'2010-09-03 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233535,233532,'2010-10-29 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233536,233532,'2010-09-24 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233537,233532,'2010-10-01 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233538,233532,'2010-10-15 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233539,233532,'2010-12-10 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233540,233532,'2010-10-08 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233541,233532,'2010-10-22 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233542,233532,'2010-09-17 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233543,233532,'2010-11-12 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233544,233532,'2010-11-19 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233545,233532,'2010-12-03 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233546,233532,'2010-09-10 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233547,233532,'2010-08-27 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233549,233548,'2010-09-21 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233550,233548,'2010-11-09 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233551,233548,'2010-12-07 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233552,233548,'2010-09-07 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233553,233548,'2010-10-26 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233554,233548,'2010-11-02 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233555,233548,'2010-08-24 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233556,233548,'2010-08-31 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233557,233548,'2010-09-28 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233558,233548,'2010-11-30 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233559,233548,'2010-11-16 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233560,233548,'2010-09-14 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233561,233548,'2010-10-05 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233562,233548,'2010-11-23 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233563,233548,'2010-10-19 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(233565,233564,'2010-08-27 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233566,233564,'2010-10-15 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233567,233564,'2010-12-10 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233568,233564,'2010-11-19 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233569,233564,'2010-09-10 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233570,233564,'2010-09-24 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233571,233564,'2010-10-22 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233572,233564,'2010-10-29 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233573,233564,'2010-10-08 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233574,233564,'2010-12-03 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233575,233564,'2010-10-01 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233576,233564,'2010-11-05 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233577,233564,'2010-11-12 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233578,233564,'2010-09-17 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233579,233564,'2010-09-03 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(233581,233580,'2010-12-10 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233582,233580,'2010-09-03 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233583,233580,'2010-11-05 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233584,233580,'2010-12-03 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233585,233580,'2010-08-27 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233586,233580,'2010-10-01 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233587,233580,'2010-10-22 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233588,233580,'2010-11-19 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233589,233580,'2010-10-15 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233590,233580,'2010-09-10 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233591,233580,'2010-09-17 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233592,233580,'2010-10-08 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233593,233580,'2010-10-29 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233594,233580,'2010-09-24 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233595,233580,'2010-11-12 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233597,233596,'2010-11-16 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233598,233596,'2010-09-14 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233599,233596,'2010-10-19 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233600,233596,'2010-12-07 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233601,233596,'2010-11-23 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233602,233596,'2010-08-31 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233603,233596,'2010-10-26 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233604,233596,'2010-11-02 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233605,233596,'2010-11-09 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233606,233596,'2010-09-07 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233607,233596,'2010-09-21 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233608,233596,'2010-09-28 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233609,233596,'2010-08-24 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233610,233596,'2010-11-30 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233611,233596,'2010-10-05 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(233613,233612,'2010-12-06 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233614,233612,'2010-11-29 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233615,233612,'2010-08-30 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233616,233612,'2010-11-01 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233617,233612,'2010-09-20 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233618,233612,'2010-08-23 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233619,233612,'2010-09-27 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233620,233612,'2010-10-25 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233621,233612,'2010-09-13 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233622,233612,'2010-11-22 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233623,233612,'2010-11-08 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233624,233612,'2010-10-18 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233625,233612,'2010-10-04 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233626,233612,'2010-11-15 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233628,233627,'2010-11-05 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233629,233627,'2010-10-01 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233630,233627,'2010-09-17 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233631,233627,'2010-12-03 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233632,233627,'2010-09-10 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233633,233627,'2010-12-10 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233634,233627,'2010-09-03 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233635,233627,'2010-10-15 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233636,233627,'2010-08-27 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233637,233627,'2010-10-29 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233638,233627,'2010-11-12 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233639,233627,'2010-10-08 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233640,233627,'2010-10-22 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233641,233627,'2010-11-19 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233642,233627,'2010-09-24 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233644,233643,'2010-08-26 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233645,233643,'2010-11-11 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233646,233643,'2010-12-02 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233647,233643,'2010-09-02 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233648,233643,'2010-09-16 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233649,233643,'2010-12-09 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233650,233643,'2010-10-28 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233651,233643,'2010-09-23 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233652,233643,'2010-10-07 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233653,233643,'2010-09-30 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233654,233643,'2010-10-14 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233655,233643,'2010-10-21 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233656,233643,'2010-11-04 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233657,233643,'2010-09-09 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233658,233643,'2010-11-18 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233660,233659,'2010-12-01 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233661,233659,'2010-10-06 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233662,233659,'2010-09-29 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233663,233659,'2010-10-13 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233664,233659,'2010-09-01 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233665,233659,'2010-11-10 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233666,233659,'2010-09-22 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233667,233659,'2010-10-27 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233668,233659,'2010-10-20 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233669,233659,'2010-11-17 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233670,233659,'2010-09-15 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233671,233659,'2010-09-08 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233672,233659,'2010-12-08 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233673,233659,'2010-11-03 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233674,233659,'2010-08-25 00:00:00',174,0,186,-10,2,0,'2010-09-22',1),
	(233676,233675,'2010-09-14 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233677,233675,'2010-12-07 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233678,233675,'2010-08-24 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233679,233675,'2010-09-07 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233680,233675,'2010-10-26 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233681,233675,'2010-11-09 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233682,233675,'2010-11-23 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233683,233675,'2010-08-31 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233684,233675,'2010-09-28 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233685,233675,'2010-09-21 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233686,233675,'2010-11-02 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233687,233675,'2010-10-19 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233688,233675,'2010-11-16 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233689,233675,'2010-11-30 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233690,233675,'2010-10-05 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(233692,233691,'2010-10-05 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233693,233691,'2010-11-16 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233694,233691,'2010-08-31 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233695,233691,'2010-11-23 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233696,233691,'2010-09-28 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233697,233691,'2010-08-24 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233698,233691,'2010-09-14 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233699,233691,'2010-12-07 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233700,233691,'2010-10-26 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233701,233691,'2010-11-09 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233702,233691,'2010-10-19 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233703,233691,'2010-11-30 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233704,233691,'2010-09-21 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233705,233691,'2010-11-02 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233706,233691,'2010-09-07 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(233708,233707,'2010-08-24 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233709,233707,'2010-09-28 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233710,233707,'2010-11-16 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233711,233707,'2010-11-30 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233712,233707,'2010-11-09 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233713,233707,'2010-10-26 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233714,233707,'2010-10-19 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233715,233707,'2010-11-02 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233716,233707,'2010-10-05 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233717,233707,'2010-09-07 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233718,233707,'2010-08-31 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233719,233707,'2010-09-14 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233720,233707,'2010-11-23 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233721,233707,'2010-12-07 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233722,233707,'2010-09-21 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(233724,233723,'2010-12-02 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233725,233723,'2010-10-21 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233726,233723,'2010-11-18 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233727,233723,'2010-10-28 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233728,233723,'2010-10-14 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233729,233723,'2010-09-16 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233730,233723,'2010-09-09 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233731,233723,'2010-09-23 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233732,233723,'2010-09-02 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233733,233723,'2010-10-07 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233734,233723,'2010-08-26 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233735,233723,'2010-11-11 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233736,233723,'2010-12-09 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233737,233723,'2010-09-30 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233738,233723,'2010-11-04 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233740,233739,'2010-11-23 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233741,233739,'2010-12-07 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233742,233739,'2010-11-09 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233743,233739,'2010-11-16 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233744,233739,'2010-11-02 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233745,233739,'2010-09-28 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233746,233739,'2010-09-21 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233747,233739,'2010-08-31 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233748,233739,'2010-09-07 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233749,233739,'2010-09-14 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233750,233739,'2010-10-26 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233751,233739,'2010-10-05 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233752,233739,'2010-10-19 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233753,233739,'2010-11-30 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233754,233739,'2010-08-24 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(233756,233755,'2010-09-10 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233757,233755,'2010-09-17 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233758,233755,'2010-11-05 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233759,233755,'2010-10-15 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233760,233755,'2010-08-27 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233761,233755,'2010-10-01 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233762,233755,'2010-11-19 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233763,233755,'2010-09-24 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233764,233755,'2010-11-12 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233765,233755,'2010-10-08 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233766,233755,'2010-12-10 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233767,233755,'2010-10-22 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233768,233755,'2010-10-29 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233769,233755,'2010-12-03 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233770,233755,'2010-09-03 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233772,233771,'2010-09-23 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233773,233771,'2010-11-11 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233774,233771,'2010-12-09 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233775,233771,'2010-08-26 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233776,233771,'2010-10-21 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233777,233771,'2010-11-04 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233778,233771,'2010-09-09 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233779,233771,'2010-10-07 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233780,233771,'2010-10-14 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233781,233771,'2010-10-28 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233782,233771,'2010-12-02 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233783,233771,'2010-09-30 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233784,233771,'2010-11-18 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233785,233771,'2010-09-02 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233786,233771,'2010-09-16 00:00:00',138,0,174,-10,6,0,'2010-09-22',1),
	(233788,233787,'2010-09-02 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233789,233787,'2010-12-09 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233790,233787,'2010-08-26 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233791,233787,'2010-10-07 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233792,233787,'2010-11-18 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233793,233787,'2010-09-09 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233794,233787,'2010-09-23 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233795,233787,'2010-10-14 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233796,233787,'2010-10-28 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233797,233787,'2010-12-02 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233798,233787,'2010-11-04 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233799,233787,'2010-09-16 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233800,233787,'2010-11-11 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233801,233787,'2010-09-30 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233802,233787,'2010-10-21 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(233804,233803,'2010-10-06 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233805,233803,'2010-10-27 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233806,233803,'2010-11-17 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233807,233803,'2010-09-15 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233808,233803,'2010-11-03 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233809,233803,'2010-09-22 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233810,233803,'2010-12-08 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233811,233803,'2010-08-25 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233812,233803,'2010-09-29 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233813,233803,'2010-09-08 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233814,233803,'2010-11-10 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233815,233803,'2010-09-01 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233816,233803,'2010-12-01 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233817,233803,'2010-10-13 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233818,233803,'2010-10-20 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(233820,233819,'2010-09-10 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233821,233819,'2010-11-19 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233822,233819,'2010-09-03 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233823,233819,'2010-11-12 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233824,233819,'2010-10-01 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233825,233819,'2010-11-05 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233826,233819,'2010-09-17 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233827,233819,'2010-10-08 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233828,233819,'2010-10-15 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233829,233819,'2010-12-10 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233830,233819,'2010-10-29 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233831,233819,'2010-08-27 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233832,233819,'2010-09-24 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233833,233819,'2010-12-03 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233834,233819,'2010-10-22 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(233836,233835,'2010-09-15 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233837,233835,'2010-08-25 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233838,233835,'2010-11-03 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233839,233835,'2010-09-08 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233840,233835,'2010-12-01 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233841,233835,'2010-10-13 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233842,233835,'2010-10-06 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233843,233835,'2010-12-08 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233844,233835,'2010-10-20 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233845,233835,'2010-09-01 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233846,233835,'2010-10-27 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233847,233835,'2010-09-29 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233848,233835,'2010-09-22 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233849,233835,'2010-11-17 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233850,233835,'2010-11-10 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(233852,233851,'2010-09-20 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233853,233851,'2010-09-27 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233854,233851,'2010-09-24 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233855,233851,'2010-11-29 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233856,233851,'2010-10-29 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233857,233851,'2010-09-13 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233858,233851,'2010-10-15 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233859,233851,'2010-10-25 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233860,233851,'2010-11-12 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233861,233851,'2010-10-08 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233862,233851,'2010-12-06 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233863,233851,'2010-10-01 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233864,233851,'2010-12-10 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233865,233851,'2010-10-18 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233866,233851,'2010-09-17 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233867,233851,'2010-11-01 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233868,233851,'2010-11-08 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233869,233851,'2010-11-15 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233870,233851,'2010-09-10 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233871,233851,'2010-10-22 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233872,233851,'2010-08-27 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233873,233851,'2010-09-03 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233874,233851,'2010-10-04 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233875,233851,'2010-08-30 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233876,233851,'2010-11-05 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233877,233851,'2010-11-19 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233878,233851,'2010-11-22 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233879,233851,'2010-12-03 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233880,233851,'2010-08-23 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(233882,233881,'2010-11-22 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233883,233881,'2010-11-29 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233884,233881,'2010-09-15 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233885,233881,'2010-10-13 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233886,233881,'2010-10-25 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233887,233881,'2010-12-08 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233888,233881,'2010-09-29 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233889,233881,'2010-09-13 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233890,233881,'2010-08-30 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233891,233881,'2010-10-04 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233892,233881,'2010-09-08 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233893,233881,'2010-10-06 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233894,233881,'2010-09-01 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233895,233881,'2010-11-08 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233896,233881,'2010-09-27 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233897,233881,'2010-11-01 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233898,233881,'2010-11-03 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233899,233881,'2010-11-17 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233900,233881,'2010-11-10 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233901,233881,'2010-10-27 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233902,233881,'2010-11-15 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233903,233881,'2010-08-25 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233904,233881,'2010-10-18 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233905,233881,'2010-09-22 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233906,233881,'2010-12-06 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233907,233881,'2010-08-23 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233908,233881,'2010-10-20 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233909,233881,'2010-09-20 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233910,233881,'2010-12-01 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(233912,233911,'2010-11-30 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233913,233911,'2010-09-21 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233914,233911,'2010-11-16 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233915,233911,'2010-10-05 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233916,233911,'2010-12-07 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233917,233911,'2010-10-19 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233918,233911,'2010-10-26 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233919,233911,'2010-11-09 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233920,233911,'2010-09-28 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233921,233911,'2010-08-31 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233922,233911,'2010-11-02 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233923,233911,'2010-08-24 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233924,233911,'2010-09-07 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233925,233911,'2010-11-23 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233926,233911,'2010-09-14 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(233928,233927,'2010-08-24 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233929,233927,'2010-12-07 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233930,233927,'2010-08-31 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233931,233927,'2010-09-07 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233932,233927,'2010-10-05 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233933,233927,'2010-11-23 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233934,233927,'2010-11-09 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233935,233927,'2010-10-19 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233936,233927,'2010-10-26 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233937,233927,'2010-09-14 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233938,233927,'2010-09-28 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233939,233927,'2010-11-02 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233940,233927,'2010-11-30 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233941,233927,'2010-09-21 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233942,233927,'2010-11-16 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(233944,233943,'2010-10-13 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233945,233943,'2010-12-08 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233946,233943,'2010-11-17 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233947,233943,'2010-10-27 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233948,233943,'2010-10-20 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233949,233943,'2010-08-25 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233950,233943,'2010-11-10 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233951,233943,'2010-11-03 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233952,233943,'2010-09-29 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233953,233943,'2010-09-01 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233954,233943,'2010-09-08 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233955,233943,'2010-12-01 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233956,233943,'2010-09-15 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233957,233943,'2010-10-06 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233958,233943,'2010-09-22 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(233960,233959,'2010-10-25 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233961,233959,'2010-08-30 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233962,233959,'2010-09-13 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233963,233959,'2010-08-23 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233964,233959,'2010-09-20 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233965,233959,'2010-12-06 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233966,233959,'2010-11-22 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233967,233959,'2010-10-18 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233968,233959,'2010-09-27 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233969,233959,'2010-11-29 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233970,233959,'2010-11-15 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233971,233959,'2010-10-04 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233972,233959,'2010-11-08 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233973,233959,'2010-11-01 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(233975,233974,'2010-09-27 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233976,233974,'2010-08-23 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233977,233974,'2010-10-18 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233978,233974,'2010-11-22 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233979,233974,'2010-11-29 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233980,233974,'2010-08-30 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233981,233974,'2010-12-06 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233982,233974,'2010-10-25 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233983,233974,'2010-09-20 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233984,233974,'2010-11-15 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233985,233974,'2010-10-04 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233986,233974,'2010-11-01 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233987,233974,'2010-11-08 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233988,233974,'2010-09-13 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233990,233989,'2010-11-11 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233991,233989,'2010-09-30 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233992,233989,'2010-09-09 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233993,233989,'2010-10-14 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233994,233989,'2010-10-28 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233995,233989,'2010-08-26 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233996,233989,'2010-09-02 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233997,233989,'2010-12-09 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233998,233989,'2010-12-02 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(233999,233989,'2010-09-23 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234000,233989,'2010-09-16 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234001,233989,'2010-10-21 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234002,233989,'2010-10-07 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234003,233989,'2010-11-18 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234004,233989,'2010-11-04 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234006,234005,'2010-08-27 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234007,234005,'2010-10-01 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234008,234005,'2010-10-29 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234009,234005,'2010-11-12 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234010,234005,'2010-09-03 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234011,234005,'2010-11-05 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234012,234005,'2010-09-24 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234013,234005,'2010-10-08 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234014,234005,'2010-12-03 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234015,234005,'2010-09-10 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234016,234005,'2010-12-10 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234017,234005,'2010-10-22 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234018,234005,'2010-11-19 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234019,234005,'2010-10-15 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234020,234005,'2010-09-17 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234022,234021,'2010-09-08 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234023,234021,'2010-11-03 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234024,234021,'2010-09-22 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234025,234021,'2010-09-29 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234026,234021,'2010-12-08 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234027,234021,'2010-11-17 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234028,234021,'2010-12-01 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234029,234021,'2010-10-20 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234030,234021,'2010-11-10 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234031,234021,'2010-09-15 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234032,234021,'2010-09-01 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234033,234021,'2010-10-06 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234034,234021,'2010-08-25 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234035,234021,'2010-10-27 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234036,234021,'2010-10-13 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(234038,234037,'2010-09-01 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234039,234037,'2010-08-25 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234040,234037,'2010-12-08 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234041,234037,'2010-10-13 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234042,234037,'2010-09-22 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234043,234037,'2010-09-29 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234044,234037,'2010-10-06 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234045,234037,'2010-11-03 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234046,234037,'2010-12-01 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234047,234037,'2010-11-10 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234048,234037,'2010-11-17 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234049,234037,'2010-09-15 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234050,234037,'2010-10-27 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234051,234037,'2010-10-20 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234052,234037,'2010-09-08 00:00:00',186,0,198,-10,2,0,'2010-09-22',1),
	(234054,234053,'2010-09-15 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234055,234053,'2010-09-08 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234056,234053,'2010-09-29 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234057,234053,'2010-11-03 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234058,234053,'2010-09-01 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234059,234053,'2010-12-01 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234060,234053,'2010-10-27 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234061,234053,'2010-09-22 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234062,234053,'2010-11-17 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234063,234053,'2010-08-25 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234064,234053,'2010-12-08 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234065,234053,'2010-10-13 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234066,234053,'2010-11-10 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234067,234053,'2010-10-06 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234068,234053,'2010-10-20 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(234070,234069,'2010-09-14 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234071,234069,'2010-11-02 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234072,234069,'2010-09-28 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234073,234069,'2010-08-31 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234074,234069,'2010-10-05 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234075,234069,'2010-11-30 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234076,234069,'2010-10-26 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234077,234069,'2010-09-21 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234078,234069,'2010-08-24 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234079,234069,'2010-12-07 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234080,234069,'2010-11-23 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234081,234069,'2010-11-09 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234082,234069,'2010-09-07 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234083,234069,'2010-11-16 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234084,234069,'2010-10-19 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(234086,234085,'2010-11-17 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234087,234085,'2010-08-25 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234088,234085,'2010-09-08 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234089,234085,'2010-11-03 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234090,234085,'2010-11-10 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234091,234085,'2010-09-29 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234092,234085,'2010-12-01 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234093,234085,'2010-09-01 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234094,234085,'2010-09-22 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234095,234085,'2010-10-27 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234096,234085,'2010-10-06 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234097,234085,'2010-10-20 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234098,234085,'2010-12-08 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234099,234085,'2010-10-13 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234100,234085,'2010-09-15 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234102,234101,'2010-09-01 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234103,234101,'2010-10-20 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234104,234101,'2010-12-08 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234105,234101,'2010-10-06 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234106,234101,'2010-11-17 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234107,234101,'2010-12-01 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234108,234101,'2010-09-15 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234109,234101,'2010-10-27 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234110,234101,'2010-11-03 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234111,234101,'2010-09-08 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234112,234101,'2010-08-25 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234113,234101,'2010-10-13 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234114,234101,'2010-09-29 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234115,234101,'2010-09-22 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234116,234101,'2010-11-10 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234118,234117,'2010-11-10 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234119,234117,'2010-12-08 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234120,234117,'2010-09-29 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234121,234117,'2010-10-27 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234122,234117,'2010-10-20 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234123,234117,'2010-09-22 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234124,234117,'2010-10-06 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234125,234117,'2010-12-01 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234126,234117,'2010-10-13 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234127,234117,'2010-09-15 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234128,234117,'2010-08-25 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234129,234117,'2010-11-03 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234130,234117,'2010-11-17 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234131,234117,'2010-09-01 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234132,234117,'2010-09-08 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234134,234133,'2010-12-08 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234135,234133,'2010-11-03 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234136,234133,'2010-10-06 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234137,234133,'2010-09-15 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234138,234133,'2010-10-20 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234139,234133,'2010-09-22 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234140,234133,'2010-11-10 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234141,234133,'2010-08-25 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234142,234133,'2010-09-29 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234143,234133,'2010-09-01 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234144,234133,'2010-09-08 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234145,234133,'2010-10-27 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234146,234133,'2010-10-13 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234147,234133,'2010-11-17 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234148,234133,'2010-12-01 00:00:00',114,0,138,-10,7,0,'2010-09-22',1),
	(234150,234149,'2010-09-01 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234151,234149,'2010-12-01 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234152,234149,'2010-11-17 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234153,234149,'2010-12-08 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234154,234149,'2010-09-08 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234155,234149,'2010-10-06 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234156,234149,'2010-10-13 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234157,234149,'2010-09-15 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234158,234149,'2010-10-20 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234159,234149,'2010-08-25 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234160,234149,'2010-10-27 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234161,234149,'2010-11-10 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234162,234149,'2010-09-22 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234163,234149,'2010-11-03 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234164,234149,'2010-09-29 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234166,234165,'2010-09-17 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234167,234165,'2010-11-19 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234168,234165,'2010-11-12 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234169,234165,'2010-09-24 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234170,234165,'2010-12-10 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234171,234165,'2010-10-15 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234172,234165,'2010-11-05 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234173,234165,'2010-10-22 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234174,234165,'2010-09-10 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234175,234165,'2010-10-29 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234176,234165,'2010-10-08 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234177,234165,'2010-12-03 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234178,234165,'2010-09-03 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234179,234165,'2010-10-01 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234180,234165,'2010-08-27 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234182,234181,'2010-08-26 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234183,234181,'2010-09-30 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234184,234181,'2010-09-16 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234185,234181,'2010-10-28 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234186,234181,'2010-10-07 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234187,234181,'2010-09-02 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234188,234181,'2010-11-11 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234189,234181,'2010-11-18 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234190,234181,'2010-12-09 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234191,234181,'2010-10-14 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234192,234181,'2010-11-04 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234193,234181,'2010-10-21 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234194,234181,'2010-12-02 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234195,234181,'2010-09-09 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234196,234181,'2010-09-23 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234198,234197,'2010-10-28 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234199,234197,'2010-10-07 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234200,234197,'2010-11-04 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234201,234197,'2010-10-14 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234202,234197,'2010-09-02 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234203,234197,'2010-08-26 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234204,234197,'2010-12-02 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234205,234197,'2010-09-23 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234206,234197,'2010-10-21 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234207,234197,'2010-12-09 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234208,234197,'2010-11-18 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234209,234197,'2010-09-09 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234210,234197,'2010-09-16 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234211,234197,'2010-09-30 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234212,234197,'2010-11-11 00:00:00',90,0,114,-10,7,0,'2010-09-22',1),
	(234214,234213,'2010-12-03 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234215,234213,'2010-10-08 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234216,234213,'2010-10-29 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234217,234213,'2010-09-03 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234218,234213,'2010-08-27 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234219,234213,'2010-11-19 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234220,234213,'2010-09-17 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234221,234213,'2010-11-05 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234222,234213,'2010-11-12 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234223,234213,'2010-09-24 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234224,234213,'2010-10-15 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234225,234213,'2010-09-10 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234226,234213,'2010-10-01 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234227,234213,'2010-12-10 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234228,234213,'2010-10-22 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234230,234229,'2010-10-27 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234231,234229,'2010-10-04 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234232,234229,'2010-11-10 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234233,234229,'2010-10-25 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234234,234229,'2010-09-29 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234235,234229,'2010-09-17 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234236,234229,'2010-11-15 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234237,234229,'2010-10-08 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234238,234229,'2010-10-18 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234239,234229,'2010-10-01 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234240,234229,'2010-10-20 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234241,234229,'2010-09-08 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234242,234229,'2010-12-06 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234243,234229,'2010-12-01 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234244,234229,'2010-11-12 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234245,234229,'2010-11-01 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234246,234229,'2010-10-29 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234247,234229,'2010-12-03 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234248,234229,'2010-11-05 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234249,234229,'2010-09-24 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234250,234229,'2010-10-13 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234251,234229,'2010-10-06 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234252,234229,'2010-11-03 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234253,234229,'2010-09-13 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234254,234229,'2010-08-23 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234255,234229,'2010-09-27 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234256,234229,'2010-10-15 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234257,234229,'2010-10-22 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234258,234229,'2010-09-15 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234259,234229,'2010-09-03 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234260,234229,'2010-12-08 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234261,234229,'2010-11-29 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234262,234229,'2010-09-22 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234263,234229,'2010-08-25 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234264,234229,'2010-11-17 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234265,234229,'2010-11-19 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234266,234229,'2010-08-27 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234267,234229,'2010-09-20 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234268,234229,'2010-09-01 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234269,234229,'2010-11-22 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234270,234229,'2010-11-08 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234271,234229,'2010-12-10 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234272,234229,'2010-09-10 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234273,234229,'2010-08-30 00:00:00',126,0,138,-10,3,0,'2010-09-22',1),
	(234275,234274,'2010-09-20 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234276,234274,'2010-08-30 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234277,234274,'2010-09-13 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234278,234274,'2010-10-04 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234279,234274,'2010-11-01 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234280,234274,'2010-08-23 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234281,234274,'2010-11-29 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234282,234274,'2010-12-06 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234283,234274,'2010-11-08 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234284,234274,'2010-10-25 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234285,234274,'2010-10-18 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234286,234274,'2010-11-15 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234287,234274,'2010-09-27 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234288,234274,'2010-11-22 00:00:00',186,0,210,-10,7,0,'2010-09-22',1),
	(234290,234289,'2010-11-29 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234291,234289,'2010-08-30 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234292,234289,'2010-10-04 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234293,234289,'2010-11-22 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234294,234289,'2010-09-13 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234295,234289,'2010-11-01 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234296,234289,'2010-08-23 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234297,234289,'2010-11-08 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234298,234289,'2010-09-20 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234299,234289,'2010-10-25 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234300,234289,'2010-09-27 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234301,234289,'2010-10-18 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234302,234289,'2010-12-06 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234303,234289,'2010-11-15 00:00:00',162,0,186,-10,7,0,'2010-09-22',1),
	(234305,234304,'2010-09-27 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234306,234304,'2010-08-30 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234307,234304,'2010-12-06 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234308,234304,'2010-10-18 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234309,234304,'2010-11-01 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234310,234304,'2010-09-20 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234311,234304,'2010-10-25 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234312,234304,'2010-11-29 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234313,234304,'2010-11-15 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234314,234304,'2010-08-23 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234315,234304,'2010-11-22 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234316,234304,'2010-10-04 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234317,234304,'2010-09-13 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234318,234304,'2010-11-08 00:00:00',138,0,162,-10,7,0,'2010-09-22',1),
	(234320,234319,'2010-11-19 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234321,234319,'2010-10-01 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234322,234319,'2010-10-18 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234323,234319,'2010-10-08 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234324,234319,'2010-09-27 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234325,234319,'2010-08-30 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234326,234319,'2010-12-01 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234327,234319,'2010-11-05 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234328,234319,'2010-10-06 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234329,234319,'2010-10-29 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234330,234319,'2010-11-29 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234331,234319,'2010-10-22 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234332,234319,'2010-09-15 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234333,234319,'2010-09-24 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234334,234319,'2010-10-04 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234335,234319,'2010-11-17 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234336,234319,'2010-11-10 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234337,234319,'2010-11-03 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234338,234319,'2010-08-23 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234339,234319,'2010-10-25 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234340,234319,'2010-09-20 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234341,234319,'2010-08-27 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234342,234319,'2010-12-06 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234343,234319,'2010-11-12 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234344,234319,'2010-09-01 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234345,234319,'2010-12-08 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234346,234319,'2010-11-22 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234347,234319,'2010-11-15 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234348,234319,'2010-11-08 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234349,234319,'2010-09-17 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234350,234319,'2010-09-08 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234351,234319,'2010-09-22 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234352,234319,'2010-12-03 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234353,234319,'2010-08-25 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234354,234319,'2010-10-13 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234355,234319,'2010-10-20 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234356,234319,'2010-10-27 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234357,234319,'2010-11-01 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234358,234319,'2010-09-03 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234359,234319,'2010-09-13 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234360,234319,'2010-09-29 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234361,234319,'2010-12-10 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234362,234319,'2010-09-10 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234363,234319,'2010-10-15 00:00:00',174,0,186,-10,3,0,'2010-09-22',1),
	(234365,234364,'2010-09-22 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234366,234364,'2010-08-25 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234367,234364,'2010-09-27 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234368,234364,'2010-11-08 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234369,234364,'2010-09-08 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234370,234364,'2010-12-08 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234371,234364,'2010-09-20 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234372,234364,'2010-11-01 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234373,234364,'2010-10-29 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234374,234364,'2010-12-01 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234375,234364,'2010-11-17 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234376,234364,'2010-12-03 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234377,234364,'2010-11-10 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234378,234364,'2010-10-18 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234379,234364,'2010-09-15 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234380,234364,'2010-12-10 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234381,234364,'2010-11-19 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234382,234364,'2010-11-03 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234383,234364,'2010-08-23 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234384,234364,'2010-10-04 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234385,234364,'2010-10-20 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234386,234364,'2010-11-22 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234387,234364,'2010-09-13 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234388,234364,'2010-11-15 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234389,234364,'2010-10-13 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234390,234364,'2010-09-29 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234391,234364,'2010-12-06 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234392,234364,'2010-09-10 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234393,234364,'2010-10-15 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234394,234364,'2010-11-29 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234395,234364,'2010-10-27 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234396,234364,'2010-10-08 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234397,234364,'2010-08-30 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234398,234364,'2010-11-05 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234399,234364,'2010-09-17 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234400,234364,'2010-09-03 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234401,234364,'2010-10-22 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234402,234364,'2010-11-12 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234403,234364,'2010-09-01 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234404,234364,'2010-10-01 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234405,234364,'2010-08-27 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234406,234364,'2010-09-24 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234407,234364,'2010-10-06 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234408,234364,'2010-10-25 00:00:00',198,0,210,-10,3,0,'2010-09-22',1),
	(234410,234409,'2010-12-06 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234411,234409,'2010-11-08 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234412,234409,'2010-09-13 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234413,234409,'2010-09-20 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234414,234409,'2010-10-04 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234415,234409,'2010-08-30 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234416,234409,'2010-10-18 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234417,234409,'2010-11-29 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234418,234409,'2010-11-15 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234419,234409,'2010-08-23 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234420,234409,'2010-11-22 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234421,234409,'2010-11-01 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234422,234409,'2010-10-25 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234423,234409,'2010-09-27 00:00:00',114,0,126,-10,4,0,'2010-09-22',1),
	(234425,234424,'2010-09-17 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234426,234424,'2010-11-19 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234427,234424,'2010-11-05 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234428,234424,'2010-09-24 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234429,234424,'2010-10-01 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234430,234424,'2010-10-29 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234431,234424,'2010-08-27 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234432,234424,'2010-12-03 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234433,234424,'2010-12-10 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234434,234424,'2010-10-15 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234435,234424,'2010-10-22 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234436,234424,'2010-11-12 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234437,234424,'2010-09-03 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234438,234424,'2010-09-10 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234439,234424,'2010-10-08 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(234441,234440,'2010-11-09 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234442,234440,'2010-11-16 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234443,234440,'2010-09-14 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234444,234440,'2010-08-31 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234445,234440,'2010-10-19 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234446,234440,'2010-12-07 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234447,234440,'2010-09-28 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234448,234440,'2010-10-05 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234449,234440,'2010-09-21 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234450,234440,'2010-11-02 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234451,234440,'2010-11-30 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234452,234440,'2010-10-26 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234453,234440,'2010-11-23 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234454,234440,'2010-08-24 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234455,234440,'2010-09-07 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(234457,234456,'2010-08-23 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234458,234456,'2010-11-29 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234459,234456,'2010-12-06 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234460,234456,'2010-09-13 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234461,234456,'2010-09-20 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234462,234456,'2010-08-30 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234463,234456,'2010-09-27 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234464,234456,'2010-11-08 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234465,234456,'2010-11-15 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234466,234456,'2010-10-18 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234467,234456,'2010-11-22 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234468,234456,'2010-10-25 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234469,234456,'2010-11-01 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234470,234456,'2010-10-04 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(234472,234471,'2010-10-07 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234473,234471,'2010-11-04 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234474,234471,'2010-09-02 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234475,234471,'2010-10-28 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234476,234471,'2010-11-11 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234477,234471,'2010-09-09 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234478,234471,'2010-12-09 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234479,234471,'2010-08-26 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234480,234471,'2010-09-16 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234481,234471,'2010-10-21 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234482,234471,'2010-09-30 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234483,234471,'2010-09-23 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234484,234471,'2010-12-02 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234485,234471,'2010-10-14 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234486,234471,'2010-11-18 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(234488,234487,'2010-11-11 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234489,234487,'2010-09-16 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234490,234487,'2010-11-04 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234491,234487,'2010-09-02 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234492,234487,'2010-10-07 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234493,234487,'2010-12-02 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234494,234487,'2010-09-23 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234495,234487,'2010-09-30 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234496,234487,'2010-10-28 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234497,234487,'2010-10-14 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234498,234487,'2010-12-09 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234499,234487,'2010-08-26 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234500,234487,'2010-10-21 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234501,234487,'2010-11-18 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234502,234487,'2010-09-09 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(234504,234503,'2010-11-11 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234505,234503,'2010-11-02 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234506,234503,'2010-11-23 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234507,234503,'2010-11-30 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234508,234503,'2010-10-19 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234509,234503,'2010-10-07 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234510,234503,'2010-09-28 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234511,234503,'2010-11-04 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234512,234503,'2010-09-02 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234513,234503,'2010-12-09 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234514,234503,'2010-09-14 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234515,234503,'2010-09-23 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234516,234503,'2010-09-30 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234517,234503,'2010-09-21 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234518,234503,'2010-11-18 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234519,234503,'2010-09-16 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234520,234503,'2010-12-07 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234521,234503,'2010-11-16 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234522,234503,'2010-09-09 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234523,234503,'2010-08-24 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234524,234503,'2010-12-02 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234525,234503,'2010-08-26 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234526,234503,'2010-10-26 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234527,234503,'2010-08-31 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234528,234503,'2010-10-05 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234529,234503,'2010-09-07 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234530,234503,'2010-10-28 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234531,234503,'2010-11-09 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234532,234503,'2010-10-21 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234533,234503,'2010-10-14 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234535,234534,'2010-10-26 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234536,234534,'2010-11-18 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234537,234534,'2010-08-31 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234538,234534,'2010-12-02 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234539,234534,'2010-11-23 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234540,234534,'2010-09-02 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234541,234534,'2010-10-14 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234542,234534,'2010-10-07 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234543,234534,'2010-10-28 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234544,234534,'2010-09-16 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234545,234534,'2010-10-05 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234546,234534,'2010-09-30 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234547,234534,'2010-11-02 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234548,234534,'2010-11-30 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234549,234534,'2010-11-04 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234550,234534,'2010-12-07 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234551,234534,'2010-09-09 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234552,234534,'2010-11-11 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234553,234534,'2010-09-28 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234554,234534,'2010-11-09 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234555,234534,'2010-09-23 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234556,234534,'2010-12-09 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234557,234534,'2010-09-21 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234558,234534,'2010-09-14 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234559,234534,'2010-08-26 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234560,234534,'2010-10-21 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234561,234534,'2010-08-24 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234562,234534,'2010-09-07 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234563,234534,'2010-11-16 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234564,234534,'2010-10-19 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(234566,234565,'2010-12-06 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234567,234565,'2010-09-13 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234568,234565,'2010-11-22 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234569,234565,'2010-11-15 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234570,234565,'2010-11-29 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234571,234565,'2010-08-30 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234572,234565,'2010-11-08 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234573,234565,'2010-10-25 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234574,234565,'2010-11-01 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234575,234565,'2010-10-04 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234576,234565,'2010-09-20 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234577,234565,'2010-08-23 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234578,234565,'2010-10-18 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234579,234565,'2010-09-27 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234581,234580,'2010-12-03 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234582,234580,'2010-10-29 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234583,234580,'2010-11-19 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234584,234580,'2010-12-10 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234585,234580,'2010-10-08 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234586,234580,'2010-09-17 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234587,234580,'2010-09-24 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234588,234580,'2010-11-05 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234589,234580,'2010-08-27 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234590,234580,'2010-10-15 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234591,234580,'2010-11-12 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234592,234580,'2010-09-03 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234593,234580,'2010-10-01 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234594,234580,'2010-10-22 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234595,234580,'2010-09-10 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(234597,234596,'2010-09-14 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234598,234596,'2010-08-26 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234599,234596,'2010-10-28 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234600,234596,'2010-10-21 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234601,234596,'2010-12-09 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234602,234596,'2010-09-16 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234603,234596,'2010-09-02 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234604,234596,'2010-11-02 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234605,234596,'2010-12-02 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234606,234596,'2010-09-07 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234607,234596,'2010-12-07 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234608,234596,'2010-10-19 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234609,234596,'2010-11-30 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234610,234596,'2010-10-05 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234611,234596,'2010-09-09 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234612,234596,'2010-11-23 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234613,234596,'2010-11-16 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234614,234596,'2010-11-18 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234615,234596,'2010-08-31 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234616,234596,'2010-10-26 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234617,234596,'2010-09-23 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234618,234596,'2010-08-24 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234619,234596,'2010-09-28 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234620,234596,'2010-11-04 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234621,234596,'2010-09-21 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234622,234596,'2010-11-11 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234623,234596,'2010-10-14 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234624,234596,'2010-09-30 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234625,234596,'2010-10-07 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234626,234596,'2010-11-09 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(234628,234627,'2010-09-21 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234629,234627,'2010-12-07 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234630,234627,'2010-10-19 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234631,234627,'2010-09-14 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234632,234627,'2010-08-24 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234633,234627,'2010-09-07 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234634,234627,'2010-11-30 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234635,234627,'2010-11-02 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234636,234627,'2010-11-16 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234637,234627,'2010-08-31 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234638,234627,'2010-10-26 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234639,234627,'2010-09-28 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234640,234627,'2010-10-05 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234641,234627,'2010-11-09 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234642,234627,'2010-11-23 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(234644,234643,'2010-12-07 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234645,234643,'2010-09-21 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234646,234643,'2010-09-28 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234647,234643,'2010-11-09 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234648,234643,'2010-10-05 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234649,234643,'2010-09-14 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234650,234643,'2010-10-26 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234651,234643,'2010-08-24 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234652,234643,'2010-10-19 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234653,234643,'2010-11-23 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234654,234643,'2010-11-30 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234655,234643,'2010-08-31 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234656,234643,'2010-09-07 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234657,234643,'2010-11-16 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234658,234643,'2010-11-02 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(234660,234659,'2010-09-30 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234661,234659,'2010-11-04 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234662,234659,'2010-09-02 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234663,234659,'2010-10-14 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234664,234659,'2010-11-18 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234665,234659,'2010-10-28 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234666,234659,'2010-12-09 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234667,234659,'2010-12-02 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234668,234659,'2010-09-16 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234669,234659,'2010-11-11 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234670,234659,'2010-10-07 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234671,234659,'2010-10-21 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234672,234659,'2010-09-09 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234673,234659,'2010-09-23 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234674,234659,'2010-08-26 00:00:00',150,0,162,-10,8,0,'2010-09-22',1),
	(234676,234675,'2010-09-14 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234677,234675,'2010-11-09 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234678,234675,'2010-11-16 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234679,234675,'2010-08-31 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234680,234675,'2010-08-24 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234681,234675,'2010-12-07 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234682,234675,'2010-09-28 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234683,234675,'2010-10-19 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234684,234675,'2010-10-05 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234685,234675,'2010-10-26 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234686,234675,'2010-11-30 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234687,234675,'2010-09-21 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234688,234675,'2010-11-23 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234689,234675,'2010-09-07 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234690,234675,'2010-11-02 00:00:00',114,0,126,-10,8,0,'2010-09-22',1),
	(234692,234691,'2010-11-01 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234693,234691,'2010-09-27 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234694,234691,'2010-11-29 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234695,234691,'2010-12-06 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234696,234691,'2010-10-18 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234697,234691,'2010-08-30 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234698,234691,'2010-11-08 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234699,234691,'2010-11-22 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234700,234691,'2010-09-13 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234701,234691,'2010-11-15 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234702,234691,'2010-09-20 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234703,234691,'2010-08-23 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234704,234691,'2010-10-04 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234705,234691,'2010-10-25 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234707,234706,'2010-09-24 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234708,234706,'2010-09-13 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234709,234706,'2010-10-13 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234710,234706,'2010-09-08 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234711,234706,'2010-10-20 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234712,234706,'2010-10-06 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234713,234706,'2010-11-19 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234714,234706,'2010-11-22 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234715,234706,'2010-09-15 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234716,234706,'2010-12-06 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234717,234706,'2010-08-25 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234718,234706,'2010-08-30 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234719,234706,'2010-08-23 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234720,234706,'2010-10-04 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234721,234706,'2010-10-15 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234722,234706,'2010-11-15 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234723,234706,'2010-11-05 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234724,234706,'2010-09-22 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234725,234706,'2010-12-03 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234726,234706,'2010-09-10 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234727,234706,'2010-11-03 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234728,234706,'2010-10-29 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234729,234706,'2010-09-01 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234730,234706,'2010-10-08 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234731,234706,'2010-09-17 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234732,234706,'2010-10-18 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234733,234706,'2010-12-01 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234734,234706,'2010-09-27 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234735,234706,'2010-11-17 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234736,234706,'2010-11-08 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234737,234706,'2010-10-01 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234738,234706,'2010-09-20 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234739,234706,'2010-09-29 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234740,234706,'2010-11-29 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234741,234706,'2010-11-01 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234742,234706,'2010-10-27 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234743,234706,'2010-10-22 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234744,234706,'2010-11-12 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234745,234706,'2010-12-08 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234746,234706,'2010-11-10 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234747,234706,'2010-09-03 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234748,234706,'2010-08-27 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234749,234706,'2010-10-25 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234750,234706,'2010-12-10 00:00:00',186,0,198,-10,3,0,'2010-09-22',1),
	(234752,234751,'2010-11-09 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234753,234751,'2010-09-28 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234754,234751,'2010-08-24 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234755,234751,'2010-10-19 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234756,234751,'2010-11-02 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234757,234751,'2010-09-07 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234758,234751,'2010-11-23 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234759,234751,'2010-11-30 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234760,234751,'2010-10-26 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234761,234751,'2010-12-07 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234762,234751,'2010-09-21 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234763,234751,'2010-08-31 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234764,234751,'2010-11-16 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234765,234751,'2010-09-14 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234766,234751,'2010-10-05 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(234768,234767,'2010-12-07 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234769,234767,'2010-09-14 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234770,234767,'2010-10-19 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234771,234767,'2010-10-26 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234772,234767,'2010-11-02 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234773,234767,'2010-09-28 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234774,234767,'2010-08-31 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234775,234767,'2010-09-07 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234776,234767,'2010-11-09 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234777,234767,'2010-11-30 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234778,234767,'2010-08-24 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234779,234767,'2010-10-05 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234780,234767,'2010-11-23 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234781,234767,'2010-09-21 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234782,234767,'2010-11-16 00:00:00',126,0,138,-10,8,0,'2010-09-22',1),
	(234784,234783,'2010-10-29 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234785,234783,'2010-12-03 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234786,234783,'2010-12-10 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234787,234783,'2010-11-05 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234788,234783,'2010-09-10 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234789,234783,'2010-10-01 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234790,234783,'2010-08-27 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234791,234783,'2010-11-19 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234792,234783,'2010-11-12 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234793,234783,'2010-10-22 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234794,234783,'2010-09-03 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234795,234783,'2010-10-08 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234796,234783,'2010-09-17 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234797,234783,'2010-09-24 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234798,234783,'2010-10-15 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(234800,234799,'2010-09-17 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234801,234799,'2010-09-24 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234802,234799,'2010-10-29 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234803,234799,'2010-10-01 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234804,234799,'2010-10-15 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234805,234799,'2010-08-27 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234806,234799,'2010-10-22 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234807,234799,'2010-11-12 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234808,234799,'2010-12-03 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234809,234799,'2010-12-10 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234810,234799,'2010-09-03 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234811,234799,'2010-10-08 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234812,234799,'2010-09-10 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234813,234799,'2010-11-19 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234814,234799,'2010-11-05 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(234816,234815,'2010-08-27 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234817,234815,'2010-11-12 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234818,234815,'2010-11-01 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234819,234815,'2010-12-06 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234820,234815,'2010-11-22 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234821,234815,'2010-10-27 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234822,234815,'2010-10-20 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234823,234815,'2010-10-01 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234824,234815,'2010-09-17 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234825,234815,'2010-11-29 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234826,234815,'2010-09-20 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234827,234815,'2010-08-30 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234828,234815,'2010-10-25 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234829,234815,'2010-10-15 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234830,234815,'2010-10-06 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234831,234815,'2010-10-18 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234832,234815,'2010-09-03 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234833,234815,'2010-11-10 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234834,234815,'2010-11-08 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234835,234815,'2010-10-22 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234836,234815,'2010-11-03 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234837,234815,'2010-12-08 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234838,234815,'2010-08-25 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234839,234815,'2010-10-08 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234840,234815,'2010-09-29 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234841,234815,'2010-10-04 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234842,234815,'2010-09-01 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234843,234815,'2010-11-17 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234844,234815,'2010-12-03 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234845,234815,'2010-09-22 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234846,234815,'2010-09-10 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234847,234815,'2010-09-24 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234848,234815,'2010-09-13 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234849,234815,'2010-12-01 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234850,234815,'2010-11-19 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234851,234815,'2010-09-15 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234852,234815,'2010-10-13 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234853,234815,'2010-11-05 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234854,234815,'2010-10-29 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234855,234815,'2010-12-10 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234856,234815,'2010-11-15 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234857,234815,'2010-09-08 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234858,234815,'2010-08-23 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234859,234815,'2010-09-27 00:00:00',150,0,162,-10,2,0,'2010-09-22',1),
	(234861,234860,'2010-10-18 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234862,234860,'2010-08-30 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234863,234860,'2010-10-15 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234864,234860,'2010-09-29 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234865,234860,'2010-10-01 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234866,234860,'2010-11-08 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234867,234860,'2010-10-22 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234868,234860,'2010-12-10 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234869,234860,'2010-11-15 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234870,234860,'2010-09-20 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234871,234860,'2010-11-12 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234872,234860,'2010-09-17 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234873,234860,'2010-10-13 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234874,234860,'2010-11-17 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234875,234860,'2010-08-27 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234876,234860,'2010-09-01 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234877,234860,'2010-09-15 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234878,234860,'2010-09-13 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234879,234860,'2010-12-01 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234880,234860,'2010-11-10 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234881,234860,'2010-11-01 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234882,234860,'2010-11-22 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234883,234860,'2010-12-03 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234884,234860,'2010-11-05 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234885,234860,'2010-08-23 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234886,234860,'2010-10-08 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234887,234860,'2010-09-10 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234888,234860,'2010-10-25 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234889,234860,'2010-10-29 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234890,234860,'2010-10-27 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234891,234860,'2010-10-04 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234892,234860,'2010-09-24 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234893,234860,'2010-11-29 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234894,234860,'2010-09-08 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234895,234860,'2010-10-06 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234896,234860,'2010-11-19 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234897,234860,'2010-12-08 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234898,234860,'2010-09-03 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234899,234860,'2010-12-06 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234900,234860,'2010-09-27 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234901,234860,'2010-11-03 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234902,234860,'2010-10-20 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234903,234860,'2010-08-25 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234904,234860,'2010-09-22 00:00:00',90,0,102,-10,3,0,'2010-09-22',1),
	(234906,234905,'2010-08-25 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234907,234905,'2010-09-15 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234908,234905,'2010-12-01 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234909,234905,'2010-12-08 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234910,234905,'2010-09-01 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234911,234905,'2010-10-27 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234912,234905,'2010-10-06 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234913,234905,'2010-10-13 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234914,234905,'2010-09-22 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234915,234905,'2010-11-10 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234916,234905,'2010-11-17 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234917,234905,'2010-11-03 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234918,234905,'2010-10-20 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234919,234905,'2010-09-08 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234920,234905,'2010-09-29 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(234922,234921,'2010-12-01 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234923,234921,'2010-08-25 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234924,234921,'2010-09-29 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234925,234921,'2010-12-06 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234926,234921,'2010-09-10 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234927,234921,'2010-09-27 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234928,234921,'2010-09-13 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234929,234921,'2010-08-30 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234930,234921,'2010-09-24 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234931,234921,'2010-11-01 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234932,234921,'2010-11-22 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234933,234921,'2010-10-18 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234934,234921,'2010-11-17 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234935,234921,'2010-10-25 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234936,234921,'2010-11-05 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234937,234921,'2010-10-01 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234938,234921,'2010-10-29 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234939,234921,'2010-10-27 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234940,234921,'2010-12-03 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234941,234921,'2010-10-13 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234942,234921,'2010-10-04 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234943,234921,'2010-11-10 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234944,234921,'2010-09-01 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234945,234921,'2010-11-29 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234946,234921,'2010-09-20 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234947,234921,'2010-08-27 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234948,234921,'2010-10-20 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234949,234921,'2010-10-08 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234950,234921,'2010-11-15 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234951,234921,'2010-09-17 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234952,234921,'2010-09-22 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234953,234921,'2010-09-15 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234954,234921,'2010-12-10 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234955,234921,'2010-09-03 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234956,234921,'2010-10-06 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234957,234921,'2010-11-08 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234958,234921,'2010-09-08 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234959,234921,'2010-11-03 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234960,234921,'2010-10-22 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234961,234921,'2010-11-19 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234962,234921,'2010-10-15 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234963,234921,'2010-12-08 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234964,234921,'2010-08-23 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234965,234921,'2010-11-12 00:00:00',174,0,186,-10,4,0,'2010-09-22',1),
	(234967,234966,'2010-12-03 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234968,234966,'2010-09-29 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234969,234966,'2010-11-03 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234970,234966,'2010-11-01 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234971,234966,'2010-09-03 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234972,234966,'2010-09-10 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234973,234966,'2010-10-15 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234974,234966,'2010-10-18 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234975,234966,'2010-12-06 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234976,234966,'2010-09-01 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234977,234966,'2010-10-25 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234978,234966,'2010-10-04 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234979,234966,'2010-11-29 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234980,234966,'2010-12-10 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234981,234966,'2010-10-08 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234982,234966,'2010-10-13 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234983,234966,'2010-11-15 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234984,234966,'2010-09-24 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234985,234966,'2010-10-27 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234986,234966,'2010-10-06 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234987,234966,'2010-09-20 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234988,234966,'2010-08-23 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234989,234966,'2010-11-05 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234990,234966,'2010-10-29 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234991,234966,'2010-09-27 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234992,234966,'2010-09-22 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234993,234966,'2010-09-13 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234994,234966,'2010-08-27 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234995,234966,'2010-08-30 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234996,234966,'2010-12-08 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234997,234966,'2010-12-01 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234998,234966,'2010-09-15 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(234999,234966,'2010-08-25 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235000,234966,'2010-09-17 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235001,234966,'2010-10-22 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235002,234966,'2010-09-08 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235003,234966,'2010-11-12 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235004,234966,'2010-11-08 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235005,234966,'2010-11-17 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235006,234966,'2010-11-19 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235007,234966,'2010-11-10 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235008,234966,'2010-10-20 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235009,234966,'2010-11-22 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235010,234966,'2010-10-01 00:00:00',138,0,150,-10,2,0,'2010-09-22',1),
	(235012,235011,'2010-11-03 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235013,235011,'2010-12-01 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235014,235011,'2010-09-15 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235015,235011,'2010-09-24 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235016,235011,'2010-11-08 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235017,235011,'2010-08-23 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235018,235011,'2010-09-03 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235019,235011,'2010-11-29 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235020,235011,'2010-12-03 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235021,235011,'2010-10-04 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235022,235011,'2010-11-15 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235023,235011,'2010-12-08 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235024,235011,'2010-11-05 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235025,235011,'2010-08-30 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235026,235011,'2010-10-27 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235027,235011,'2010-11-17 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235028,235011,'2010-10-22 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235029,235011,'2010-10-13 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235030,235011,'2010-10-01 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235031,235011,'2010-09-22 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235032,235011,'2010-08-25 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235033,235011,'2010-10-08 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235034,235011,'2010-10-06 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235035,235011,'2010-10-18 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235036,235011,'2010-09-27 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235037,235011,'2010-10-20 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235038,235011,'2010-11-01 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235039,235011,'2010-10-15 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235040,235011,'2010-09-01 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235041,235011,'2010-09-29 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235042,235011,'2010-09-13 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235043,235011,'2010-09-08 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235044,235011,'2010-11-12 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235045,235011,'2010-11-10 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235046,235011,'2010-08-27 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235047,235011,'2010-09-10 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235048,235011,'2010-11-19 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235049,235011,'2010-10-29 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235050,235011,'2010-11-22 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235051,235011,'2010-12-10 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235052,235011,'2010-10-25 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235053,235011,'2010-09-17 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235054,235011,'2010-12-06 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235055,235011,'2010-09-20 00:00:00',162,0,174,-10,3,0,'2010-09-22',1),
	(235057,235056,'2010-09-01 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235058,235056,'2010-09-08 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235059,235056,'2010-10-20 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235060,235056,'2010-09-13 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235061,235056,'2010-09-03 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235062,235056,'2010-10-22 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235063,235056,'2010-08-27 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235064,235056,'2010-10-18 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235065,235056,'2010-10-13 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235066,235056,'2010-11-01 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235067,235056,'2010-12-03 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235068,235056,'2010-11-05 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235069,235056,'2010-11-17 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235070,235056,'2010-08-25 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235071,235056,'2010-12-10 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235072,235056,'2010-09-20 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235073,235056,'2010-11-15 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235074,235056,'2010-12-08 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235075,235056,'2010-11-22 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235076,235056,'2010-10-25 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235077,235056,'2010-10-06 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235078,235056,'2010-11-08 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235079,235056,'2010-11-03 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235080,235056,'2010-10-15 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235081,235056,'2010-09-17 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235082,235056,'2010-11-19 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235083,235056,'2010-09-10 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235084,235056,'2010-11-12 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235085,235056,'2010-09-22 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235086,235056,'2010-09-15 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235087,235056,'2010-08-23 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235088,235056,'2010-10-08 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235089,235056,'2010-10-27 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235090,235056,'2010-11-29 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235091,235056,'2010-08-30 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235092,235056,'2010-10-04 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235093,235056,'2010-12-01 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235094,235056,'2010-12-06 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235095,235056,'2010-10-01 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235096,235056,'2010-11-10 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235097,235056,'2010-10-29 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235098,235056,'2010-09-29 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235099,235056,'2010-09-27 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235100,235056,'2010-09-24 00:00:00',114,0,126,-10,2,0,'2010-09-22',1),
	(235102,235101,'2010-09-01 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235103,235101,'2010-10-04 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235104,235101,'2010-11-08 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235105,235101,'2010-10-15 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235106,235101,'2010-11-05 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235107,235101,'2010-11-10 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235108,235101,'2010-08-30 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235109,235101,'2010-10-25 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235110,235101,'2010-11-12 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235111,235101,'2010-10-01 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235112,235101,'2010-09-10 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235113,235101,'2010-11-03 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235114,235101,'2010-10-20 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235115,235101,'2010-10-08 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235116,235101,'2010-10-22 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235117,235101,'2010-10-27 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235118,235101,'2010-11-17 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235119,235101,'2010-10-06 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235120,235101,'2010-12-01 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235121,235101,'2010-11-29 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235122,235101,'2010-10-13 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235123,235101,'2010-12-08 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235124,235101,'2010-09-29 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235125,235101,'2010-09-15 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235126,235101,'2010-08-27 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235127,235101,'2010-09-20 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235128,235101,'2010-11-15 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235129,235101,'2010-12-03 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235130,235101,'2010-09-17 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235131,235101,'2010-09-03 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235132,235101,'2010-11-01 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235133,235101,'2010-11-19 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235134,235101,'2010-09-27 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235135,235101,'2010-11-22 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235136,235101,'2010-09-13 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235137,235101,'2010-12-06 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235138,235101,'2010-09-24 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235139,235101,'2010-10-29 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235140,235101,'2010-10-18 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235141,235101,'2010-09-22 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235142,235101,'2010-08-25 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235143,235101,'2010-08-23 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235144,235101,'2010-12-10 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235145,235101,'2010-09-08 00:00:00',198,0,210,-10,4,0,'2010-09-22',1),
	(235147,235146,'2010-09-24 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235148,235146,'2010-10-20 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235149,235146,'2010-12-08 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235150,235146,'2010-10-06 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235151,235146,'2010-11-19 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235152,235146,'2010-11-01 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235153,235146,'2010-09-15 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235154,235146,'2010-09-03 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235155,235146,'2010-11-22 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235156,235146,'2010-11-08 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235157,235146,'2010-09-29 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235158,235146,'2010-11-12 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235159,235146,'2010-09-27 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235160,235146,'2010-12-01 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235161,235146,'2010-09-13 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235162,235146,'2010-10-18 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235163,235146,'2010-10-01 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235164,235146,'2010-09-01 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235165,235146,'2010-11-17 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235166,235146,'2010-10-29 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235167,235146,'2010-10-15 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235168,235146,'2010-12-06 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235169,235146,'2010-10-08 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235170,235146,'2010-11-29 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235171,235146,'2010-08-25 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235172,235146,'2010-09-17 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235173,235146,'2010-08-27 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235174,235146,'2010-11-05 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235175,235146,'2010-10-25 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235176,235146,'2010-09-22 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235177,235146,'2010-11-03 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235178,235146,'2010-08-23 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235179,235146,'2010-10-04 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235180,235146,'2010-09-20 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235181,235146,'2010-12-03 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235182,235146,'2010-12-10 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235183,235146,'2010-11-10 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235184,235146,'2010-10-13 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235185,235146,'2010-09-08 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235186,235146,'2010-10-27 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235187,235146,'2010-11-15 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235188,235146,'2010-09-10 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235189,235146,'2010-08-30 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235190,235146,'2010-10-22 00:00:00',186,0,198,-10,4,0,'2010-09-22',1),
	(235192,235191,'2010-10-01 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235193,235191,'2010-08-23 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235194,235191,'2010-09-17 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235195,235191,'2010-11-10 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235196,235191,'2010-11-12 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235197,235191,'2010-12-03 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235198,235191,'2010-09-27 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235199,235191,'2010-10-06 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235200,235191,'2010-08-25 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235201,235191,'2010-09-22 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235202,235191,'2010-08-30 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235203,235191,'2010-09-10 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235204,235191,'2010-10-25 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235205,235191,'2010-10-04 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235206,235191,'2010-10-20 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235207,235191,'2010-10-22 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235208,235191,'2010-11-22 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235209,235191,'2010-11-15 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235210,235191,'2010-11-08 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235211,235191,'2010-11-29 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235212,235191,'2010-11-19 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235213,235191,'2010-09-29 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235214,235191,'2010-09-24 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235215,235191,'2010-12-10 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235216,235191,'2010-09-08 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235217,235191,'2010-12-08 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235218,235191,'2010-10-08 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235219,235191,'2010-12-01 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235220,235191,'2010-10-29 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235221,235191,'2010-12-06 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235222,235191,'2010-11-17 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235223,235191,'2010-10-27 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235224,235191,'2010-08-27 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235225,235191,'2010-09-20 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235226,235191,'2010-09-13 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235227,235191,'2010-10-18 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235228,235191,'2010-11-03 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235229,235191,'2010-09-03 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235230,235191,'2010-10-13 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235231,235191,'2010-09-01 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235232,235191,'2010-10-15 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235233,235191,'2010-09-15 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235234,235191,'2010-11-05 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235235,235191,'2010-11-01 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235237,235236,'2010-10-07 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235238,235236,'2010-09-09 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235239,235236,'2010-09-16 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235240,235236,'2010-10-28 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235241,235236,'2010-11-18 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235242,235236,'2010-12-09 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235243,235236,'2010-09-30 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235244,235236,'2010-09-23 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235245,235236,'2010-10-21 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235246,235236,'2010-12-02 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235247,235236,'2010-11-04 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235248,235236,'2010-11-11 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235249,235236,'2010-10-14 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235250,235236,'2010-09-02 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235251,235236,'2010-08-26 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235253,235252,'2010-11-04 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235254,235252,'2010-10-14 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235255,235252,'2010-09-16 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235256,235252,'2010-11-18 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235257,235252,'2010-09-23 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235258,235252,'2010-12-09 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235259,235252,'2010-09-02 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235260,235252,'2010-08-26 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235261,235252,'2010-10-28 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235262,235252,'2010-11-11 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235263,235252,'2010-10-07 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235264,235252,'2010-09-30 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235265,235252,'2010-12-02 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235266,235252,'2010-10-21 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235267,235252,'2010-09-09 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235269,235268,'2010-10-25 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235270,235268,'2010-11-22 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235271,235268,'2010-11-29 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235272,235268,'2010-11-15 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235273,235268,'2010-12-06 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235274,235268,'2010-08-23 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235275,235268,'2010-10-04 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235276,235268,'2010-11-01 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235277,235268,'2010-09-20 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235278,235268,'2010-09-13 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235279,235268,'2010-08-30 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235280,235268,'2010-10-18 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235281,235268,'2010-11-08 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235282,235268,'2010-09-27 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235284,235283,'2010-10-15 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235285,235283,'2010-09-10 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235286,235283,'2010-10-08 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235287,235283,'2010-10-22 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235288,235283,'2010-12-10 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235289,235283,'2010-08-27 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235290,235283,'2010-10-01 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235291,235283,'2010-09-03 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235292,235283,'2010-11-05 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235293,235283,'2010-10-29 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235294,235283,'2010-11-12 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235295,235283,'2010-09-24 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235296,235283,'2010-12-03 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235297,235283,'2010-11-19 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235298,235283,'2010-09-17 00:00:00',198,0,210,-10,8,0,'2010-09-22',1),
	(235300,235299,'2010-09-24 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235301,235299,'2010-08-25 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235302,235299,'2010-11-15 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235303,235299,'2010-09-20 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235304,235299,'2010-12-08 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235305,235299,'2010-11-03 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235306,235299,'2010-11-10 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235307,235299,'2010-11-08 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235308,235299,'2010-12-01 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235309,235299,'2010-09-03 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235310,235299,'2010-10-15 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235311,235299,'2010-10-27 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235312,235299,'2010-08-23 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235313,235299,'2010-12-10 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235314,235299,'2010-11-05 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235315,235299,'2010-10-29 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235316,235299,'2010-10-18 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235317,235299,'2010-09-10 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235318,235299,'2010-11-01 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235319,235299,'2010-11-12 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235320,235299,'2010-09-29 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235321,235299,'2010-10-13 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235322,235299,'2010-09-01 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235323,235299,'2010-11-17 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235324,235299,'2010-09-15 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235325,235299,'2010-09-17 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235326,235299,'2010-09-08 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235327,235299,'2010-08-30 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235328,235299,'2010-11-29 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235329,235299,'2010-11-22 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235330,235299,'2010-09-27 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235331,235299,'2010-10-22 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235332,235299,'2010-09-22 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235333,235299,'2010-10-08 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235334,235299,'2010-10-06 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235335,235299,'2010-12-03 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235336,235299,'2010-10-25 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235337,235299,'2010-08-27 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235338,235299,'2010-10-20 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235339,235299,'2010-11-19 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235340,235299,'2010-10-04 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235341,235299,'2010-09-13 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235342,235299,'2010-10-01 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235343,235299,'2010-12-06 00:00:00',102,0,114,-10,4,0,'2010-09-22',1),
	(235345,235344,'2010-11-19 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235346,235344,'2010-10-04 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235347,235344,'2010-10-15 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235348,235344,'2010-11-03 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235349,235344,'2010-10-29 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235350,235344,'2010-09-17 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235351,235344,'2010-09-10 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235352,235344,'2010-10-18 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235353,235344,'2010-12-06 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235354,235344,'2010-11-01 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235355,235344,'2010-09-24 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235356,235344,'2010-12-03 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235357,235344,'2010-08-27 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235358,235344,'2010-10-22 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235359,235344,'2010-11-05 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235360,235344,'2010-10-06 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235361,235344,'2010-11-15 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235362,235344,'2010-11-08 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235363,235344,'2010-09-01 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235364,235344,'2010-11-10 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235365,235344,'2010-09-08 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235366,235344,'2010-09-29 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235367,235344,'2010-09-13 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235368,235344,'2010-10-01 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235369,235344,'2010-09-22 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235370,235344,'2010-11-22 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235371,235344,'2010-08-30 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235372,235344,'2010-10-20 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235373,235344,'2010-10-08 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235374,235344,'2010-10-25 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235375,235344,'2010-11-29 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235376,235344,'2010-11-12 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235377,235344,'2010-10-13 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235378,235344,'2010-10-27 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235379,235344,'2010-12-10 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235380,235344,'2010-11-17 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235381,235344,'2010-09-27 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235382,235344,'2010-09-03 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235383,235344,'2010-09-15 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235384,235344,'2010-09-20 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235385,235344,'2010-08-25 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235386,235344,'2010-12-08 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235387,235344,'2010-12-01 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235388,235344,'2010-08-23 00:00:00',90,0,102,-10,2,0,'2010-09-22',1),
	(235390,235389,'2010-12-08 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235391,235389,'2010-09-20 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235392,235389,'2010-09-10 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235393,235389,'2010-11-22 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235394,235389,'2010-10-08 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235395,235389,'2010-12-01 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235396,235389,'2010-10-13 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235397,235389,'2010-08-30 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235398,235389,'2010-11-15 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235399,235389,'2010-09-22 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235400,235389,'2010-11-01 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235401,235389,'2010-09-17 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235402,235389,'2010-09-27 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235403,235389,'2010-09-15 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235404,235389,'2010-09-08 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235405,235389,'2010-10-15 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235406,235389,'2010-09-29 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235407,235389,'2010-10-04 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235408,235389,'2010-12-10 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235409,235389,'2010-11-29 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235410,235389,'2010-11-03 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235411,235389,'2010-08-27 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235412,235389,'2010-09-13 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235413,235389,'2010-08-25 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235414,235389,'2010-11-10 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235415,235389,'2010-11-05 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235416,235389,'2010-11-12 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235417,235389,'2010-12-03 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235418,235389,'2010-10-29 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235419,235389,'2010-09-24 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235420,235389,'2010-08-23 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235421,235389,'2010-11-08 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235422,235389,'2010-10-18 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235423,235389,'2010-10-27 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235424,235389,'2010-09-01 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235425,235389,'2010-12-06 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235426,235389,'2010-11-19 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235427,235389,'2010-09-03 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235428,235389,'2010-10-20 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235429,235389,'2010-11-17 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235430,235389,'2010-10-01 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235431,235389,'2010-10-25 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235432,235389,'2010-10-22 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235433,235389,'2010-10-06 00:00:00',150,0,162,-10,4,0,'2010-09-22',1),
	(235435,235434,'2010-09-09 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235436,235434,'2010-11-18 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235437,235434,'2010-12-09 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235438,235434,'2010-10-14 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235439,235434,'2010-10-28 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235440,235434,'2010-11-11 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235441,235434,'2010-12-02 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235442,235434,'2010-10-21 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235443,235434,'2010-09-23 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235444,235434,'2010-09-02 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235445,235434,'2010-10-07 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235446,235434,'2010-08-26 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235447,235434,'2010-11-04 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235448,235434,'2010-09-16 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235449,235434,'2010-09-30 00:00:00',174,0,186,-10,8,0,'2010-09-22',1),
	(235451,235450,'2010-11-01 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235452,235450,'2010-11-15 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235453,235450,'2010-10-18 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235454,235450,'2010-10-25 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235455,235450,'2010-10-04 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235456,235450,'2010-11-08 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235457,235450,'2010-09-20 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235458,235450,'2010-08-23 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235459,235450,'2010-09-13 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235460,235450,'2010-12-06 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235461,235450,'2010-11-22 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235462,235450,'2010-08-30 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235463,235450,'2010-11-29 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235464,235450,'2010-09-27 00:00:00',102,0,114,-10,2,0,'2010-09-22',1),
	(235466,235465,'2010-10-14 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235467,235465,'2010-12-02 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235468,235465,'2010-11-18 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235469,235465,'2010-09-02 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235470,235465,'2010-09-23 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235471,235465,'2010-12-09 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235472,235465,'2010-09-30 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235473,235465,'2010-10-28 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235474,235465,'2010-09-16 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235475,235465,'2010-10-21 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235476,235465,'2010-11-04 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235477,235465,'2010-11-11 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235478,235465,'2010-09-09 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235479,235465,'2010-08-26 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235480,235465,'2010-10-07 00:00:00',126,0,138,-10,2,0,'2010-09-22',1),
	(235482,235481,'2010-08-31 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235483,235481,'2010-10-26 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235484,235481,'2010-09-21 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235485,235481,'2010-10-07 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235486,235481,'2010-09-30 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235487,235481,'2010-11-16 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235488,235481,'2010-10-19 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235489,235481,'2010-09-09 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235490,235481,'2010-11-11 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235491,235481,'2010-12-02 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235492,235481,'2010-09-23 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235493,235481,'2010-10-21 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235494,235481,'2010-09-02 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235495,235481,'2010-12-09 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235496,235481,'2010-08-26 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235497,235481,'2010-09-16 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235498,235481,'2010-09-07 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235499,235481,'2010-11-04 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235500,235481,'2010-09-14 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235501,235481,'2010-11-23 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235502,235481,'2010-12-07 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235503,235481,'2010-08-24 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235504,235481,'2010-11-18 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235505,235481,'2010-11-09 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235506,235481,'2010-09-28 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235507,235481,'2010-11-02 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235508,235481,'2010-11-30 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235509,235481,'2010-10-05 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235510,235481,'2010-10-14 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235511,235481,'2010-10-28 00:00:00',90,0,108,-15,4,0,'2010-09-22',1),
	(235513,235512,'2010-10-06 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235514,235512,'2010-10-13 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235515,235512,'2010-10-27 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235516,235512,'2010-11-10 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235517,235512,'2010-10-20 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235518,235512,'2010-11-17 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235519,235512,'2010-09-01 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235520,235512,'2010-09-29 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235521,235512,'2010-11-03 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235522,235512,'2010-12-01 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235523,235512,'2010-09-22 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235524,235512,'2010-08-25 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235525,235512,'2010-09-08 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235526,235512,'2010-12-08 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235527,235512,'2010-09-15 00:00:00',162,0,174,-10,2,0,'2010-09-22',1),
	(235529,235528,'2010-09-01 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235530,235528,'2010-11-17 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235531,235528,'2010-10-27 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235532,235528,'2010-11-03 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235533,235528,'2010-11-10 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235534,235528,'2010-09-08 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235535,235528,'2010-09-29 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235536,235528,'2010-08-25 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235537,235528,'2010-10-20 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235538,235528,'2010-12-08 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235539,235528,'2010-09-15 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235540,235528,'2010-10-06 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235541,235528,'2010-10-13 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235542,235528,'2010-09-22 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235543,235528,'2010-12-01 00:00:00',126,0,138,-10,4,0,'2010-09-22',1),
	(235545,235544,'2010-12-02 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235546,235544,'2010-10-28 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235547,235544,'2010-09-09 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235548,235544,'2010-09-02 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235549,235544,'2010-09-16 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235550,235544,'2010-12-09 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235551,235544,'2010-10-14 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235552,235544,'2010-11-04 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235553,235544,'2010-10-07 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235554,235544,'2010-10-21 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235555,235544,'2010-11-18 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235556,235544,'2010-09-23 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235557,235544,'2010-11-11 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235558,235544,'2010-08-26 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235559,235544,'2010-09-30 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(235561,235560,'2010-11-30 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235562,235560,'2010-09-07 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235563,235560,'2010-09-14 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235564,235560,'2010-11-02 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235565,235560,'2010-11-16 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235566,235560,'2010-09-28 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235567,235560,'2010-12-07 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235568,235560,'2010-08-24 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235569,235560,'2010-10-19 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235570,235560,'2010-10-05 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235571,235560,'2010-11-09 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235572,235560,'2010-09-21 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235573,235560,'2010-08-31 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235574,235560,'2010-10-26 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235575,235560,'2010-11-23 00:00:00',162,0,174,-10,4,0,'2010-09-22',1),
	(235577,235576,'2010-09-24 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235578,235576,'2010-10-29 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235579,235576,'2010-11-19 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235580,235576,'2010-09-17 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235581,235576,'2010-11-12 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235582,235576,'2010-12-03 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235583,235576,'2010-08-27 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235584,235576,'2010-09-03 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235585,235576,'2010-10-15 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235586,235576,'2010-10-22 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235587,235576,'2010-12-10 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235588,235576,'2010-10-08 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235589,235576,'2010-09-10 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235590,235576,'2010-11-05 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235591,235576,'2010-10-01 00:00:00',150,0,162,-10,3,0,'2010-09-22',1),
	(235593,235592,'2010-09-28 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235594,235592,'2010-09-30 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235595,235592,'2010-09-21 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235596,235592,'2010-10-07 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235597,235592,'2010-10-05 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235598,235592,'2010-12-09 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235599,235592,'2010-09-02 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235600,235592,'2010-09-16 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235601,235592,'2010-10-26 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235602,235592,'2010-11-09 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235603,235592,'2010-09-23 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235604,235592,'2010-09-14 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235605,235592,'2010-10-19 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235606,235592,'2010-11-23 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235607,235592,'2010-09-07 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235608,235592,'2010-11-30 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235609,235592,'2010-11-02 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235610,235592,'2010-10-21 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235611,235592,'2010-10-28 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235612,235592,'2010-11-11 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235613,235592,'2010-11-18 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235614,235592,'2010-12-02 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235615,235592,'2010-12-07 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235616,235592,'2010-11-16 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235617,235592,'2010-09-09 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235618,235592,'2010-08-24 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235619,235592,'2010-10-14 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235620,235592,'2010-08-26 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235621,235592,'2010-11-04 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235622,235592,'2010-08-31 00:00:00',180,0,198,-15,2,0,'2010-09-22',1),
	(235624,235623,'2010-12-02 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235625,235623,'2010-11-02 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235626,235623,'2010-11-09 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235627,235623,'2010-11-04 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235628,235623,'2010-09-21 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235629,235623,'2010-12-07 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235630,235623,'2010-11-18 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235631,235623,'2010-11-16 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235632,235623,'2010-09-09 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235633,235623,'2010-10-19 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235634,235623,'2010-10-21 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235635,235623,'2010-11-23 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235636,235623,'2010-12-09 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235637,235623,'2010-11-11 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235638,235623,'2010-08-26 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235639,235623,'2010-09-07 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235640,235623,'2010-09-16 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235641,235623,'2010-08-31 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235642,235623,'2010-09-28 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235643,235623,'2010-10-14 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235644,235623,'2010-09-23 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235645,235623,'2010-09-02 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235646,235623,'2010-10-28 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235647,235623,'2010-09-30 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235648,235623,'2010-08-24 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235649,235623,'2010-10-07 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235650,235623,'2010-11-30 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235651,235623,'2010-09-14 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235652,235623,'2010-10-26 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235653,235623,'2010-10-05 00:00:00',108,0,126,-15,4,0,'2010-09-22',1),
	(235655,235654,'2010-11-11 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235656,235654,'2010-11-30 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235657,235654,'2010-10-05 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235658,235654,'2010-10-21 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235659,235654,'2010-09-07 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235660,235654,'2010-11-16 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235661,235654,'2010-10-14 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235662,235654,'2010-10-28 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235663,235654,'2010-12-02 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235664,235654,'2010-11-18 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235665,235654,'2010-11-23 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235666,235654,'2010-08-26 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235667,235654,'2010-09-14 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235668,235654,'2010-08-31 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235669,235654,'2010-12-09 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235670,235654,'2010-09-21 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235671,235654,'2010-11-02 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235672,235654,'2010-09-02 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235673,235654,'2010-08-24 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235674,235654,'2010-11-09 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235675,235654,'2010-10-26 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235676,235654,'2010-12-07 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235677,235654,'2010-11-04 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235678,235654,'2010-09-09 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235679,235654,'2010-10-19 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235680,235654,'2010-09-23 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235681,235654,'2010-10-07 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235682,235654,'2010-09-16 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235683,235654,'2010-09-28 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235684,235654,'2010-09-30 00:00:00',108,0,126,-15,2,0,'2010-09-22',1),
	(235686,235685,'2010-10-07 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235687,235685,'2010-11-04 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235688,235685,'2010-09-16 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235689,235685,'2010-08-26 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235690,235685,'2010-11-16 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235691,235685,'2010-12-02 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235692,235685,'2010-08-31 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235693,235685,'2010-09-07 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235694,235685,'2010-08-24 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235695,235685,'2010-11-18 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235696,235685,'2010-10-21 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235697,235685,'2010-09-14 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235698,235685,'2010-09-30 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235699,235685,'2010-09-21 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235700,235685,'2010-10-14 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235701,235685,'2010-11-11 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235702,235685,'2010-10-19 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235703,235685,'2010-09-28 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235704,235685,'2010-09-09 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235705,235685,'2010-10-28 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235706,235685,'2010-12-09 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235707,235685,'2010-11-23 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235708,235685,'2010-09-23 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235709,235685,'2010-11-30 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235710,235685,'2010-11-02 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235711,235685,'2010-10-05 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235712,235685,'2010-12-07 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235713,235685,'2010-09-02 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235714,235685,'2010-10-26 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235715,235685,'2010-11-09 00:00:00',126,0,144,-15,3,0,'2010-09-22',1),
	(235717,235716,'2010-08-31 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235718,235716,'2010-11-11 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235719,235716,'2010-11-16 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235720,235716,'2010-10-26 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235721,235716,'2010-08-24 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235722,235716,'2010-09-23 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235723,235716,'2010-12-02 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235724,235716,'2010-11-04 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235725,235716,'2010-11-09 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235726,235716,'2010-11-02 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235727,235716,'2010-09-30 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235728,235716,'2010-10-07 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235729,235716,'2010-10-05 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235730,235716,'2010-09-14 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235731,235716,'2010-09-16 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235732,235716,'2010-10-14 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235733,235716,'2010-11-23 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235734,235716,'2010-10-19 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235735,235716,'2010-09-02 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235736,235716,'2010-12-07 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235737,235716,'2010-08-26 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235738,235716,'2010-12-09 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235739,235716,'2010-11-30 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235740,235716,'2010-10-28 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235741,235716,'2010-11-18 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235742,235716,'2010-09-21 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235743,235716,'2010-09-09 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235744,235716,'2010-10-21 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235745,235716,'2010-09-07 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235746,235716,'2010-09-28 00:00:00',90,0,108,-15,2,0,'2010-09-22',1),
	(235748,235747,'2010-10-07 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235749,235747,'2010-08-26 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235750,235747,'2010-08-31 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235751,235747,'2010-10-28 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235752,235747,'2010-11-11 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235753,235747,'2010-11-04 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235754,235747,'2010-09-30 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235755,235747,'2010-10-05 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235756,235747,'2010-10-26 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235757,235747,'2010-08-24 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235758,235747,'2010-09-09 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235759,235747,'2010-09-07 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235760,235747,'2010-11-30 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235761,235747,'2010-09-21 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235762,235747,'2010-10-19 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235763,235747,'2010-10-21 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235764,235747,'2010-11-16 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235765,235747,'2010-12-07 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235766,235747,'2010-11-02 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235767,235747,'2010-09-16 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235768,235747,'2010-12-09 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235769,235747,'2010-11-09 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235770,235747,'2010-09-02 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235771,235747,'2010-11-18 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235772,235747,'2010-09-28 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235773,235747,'2010-12-02 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235774,235747,'2010-09-23 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235775,235747,'2010-09-14 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235776,235747,'2010-10-14 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235777,235747,'2010-11-23 00:00:00',198,0,216,-15,2,0,'2010-09-22',1),
	(235779,235778,'2010-08-26 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235780,235778,'2010-12-09 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235781,235778,'2010-12-02 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235782,235778,'2010-11-23 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235783,235778,'2010-11-02 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235784,235778,'2010-10-07 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235785,235778,'2010-11-18 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235786,235778,'2010-10-14 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235787,235778,'2010-10-19 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235788,235778,'2010-11-16 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235789,235778,'2010-11-30 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235790,235778,'2010-09-14 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235791,235778,'2010-11-04 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235792,235778,'2010-09-07 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235793,235778,'2010-09-30 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235794,235778,'2010-09-16 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235795,235778,'2010-10-05 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235796,235778,'2010-12-07 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235797,235778,'2010-09-21 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235798,235778,'2010-11-11 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235799,235778,'2010-09-28 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235800,235778,'2010-10-26 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235801,235778,'2010-09-02 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235802,235778,'2010-09-09 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235803,235778,'2010-10-21 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235804,235778,'2010-09-23 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235805,235778,'2010-10-28 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235806,235778,'2010-08-24 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235807,235778,'2010-08-31 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235808,235778,'2010-11-09 00:00:00',198,0,216,-15,4,0,'2010-09-22',1),
	(235810,235809,'2010-09-30 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235811,235809,'2010-08-24 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235812,235809,'2010-11-02 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235813,235809,'2010-12-07 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235814,235809,'2010-12-02 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235815,235809,'2010-09-21 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235816,235809,'2010-09-23 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235817,235809,'2010-09-28 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235818,235809,'2010-11-04 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235819,235809,'2010-11-11 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235820,235809,'2010-08-31 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235821,235809,'2010-10-26 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235822,235809,'2010-10-05 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235823,235809,'2010-09-07 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235824,235809,'2010-10-07 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235825,235809,'2010-08-26 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235826,235809,'2010-10-19 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235827,235809,'2010-09-14 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235828,235809,'2010-11-23 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235829,235809,'2010-11-09 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235830,235809,'2010-09-16 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235831,235809,'2010-11-30 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235832,235809,'2010-12-09 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235833,235809,'2010-11-18 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235834,235809,'2010-10-14 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235835,235809,'2010-09-02 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235836,235809,'2010-11-16 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235837,235809,'2010-09-09 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235838,235809,'2010-10-28 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235839,235809,'2010-10-21 00:00:00',162,0,180,-15,3,0,'2010-09-22',1),
	(235841,235840,'2010-10-14 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235842,235840,'2010-11-09 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235843,235840,'2010-09-30 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235844,235840,'2010-09-02 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235845,235840,'2010-09-16 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235846,235840,'2010-11-04 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235847,235840,'2010-12-09 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235848,235840,'2010-09-14 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235849,235840,'2010-11-23 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235850,235840,'2010-09-28 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235851,235840,'2010-09-21 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235852,235840,'2010-09-09 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235853,235840,'2010-09-07 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235854,235840,'2010-11-11 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235855,235840,'2010-11-02 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235856,235840,'2010-10-19 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235857,235840,'2010-10-21 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235858,235840,'2010-10-07 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235859,235840,'2010-11-18 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235860,235840,'2010-12-07 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235861,235840,'2010-10-28 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235862,235840,'2010-08-24 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235863,235840,'2010-10-26 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235864,235840,'2010-11-16 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235865,235840,'2010-09-23 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235866,235840,'2010-11-30 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235867,235840,'2010-12-02 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235868,235840,'2010-08-31 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235869,235840,'2010-10-05 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235870,235840,'2010-08-26 00:00:00',198,0,216,-15,3,0,'2010-09-22',1),
	(235872,235871,'2010-12-08 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235873,235871,'2010-09-22 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235874,235871,'2010-09-01 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235875,235871,'2010-08-25 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235876,235871,'2010-11-17 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235877,235871,'2010-11-10 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235878,235871,'2010-10-20 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235879,235871,'2010-11-03 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235880,235871,'2010-10-27 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235881,235871,'2010-12-01 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235882,235871,'2010-09-15 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235883,235871,'2010-09-29 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235884,235871,'2010-10-06 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235885,235871,'2010-09-08 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235886,235871,'2010-10-13 00:00:00',138,0,150,-10,8,0,'2010-09-22',1),
	(235888,235887,'2010-09-08 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235889,235887,'2010-10-20 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235890,235887,'2010-12-03 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235891,235887,'2010-08-23 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235892,235887,'2010-12-01 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235893,235887,'2010-11-01 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235894,235887,'2010-10-18 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235895,235887,'2010-10-27 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235896,235887,'2010-12-10 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235897,235887,'2010-10-22 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235898,235887,'2010-09-27 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235899,235887,'2010-10-25 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235900,235887,'2010-08-25 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235901,235887,'2010-10-06 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235902,235887,'2010-09-13 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235903,235887,'2010-09-20 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235904,235887,'2010-11-03 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235905,235887,'2010-10-29 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235906,235887,'2010-11-12 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235907,235887,'2010-12-06 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235908,235887,'2010-11-29 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235909,235887,'2010-09-15 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235910,235887,'2010-10-01 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235911,235887,'2010-11-22 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235912,235887,'2010-09-01 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235913,235887,'2010-11-08 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235914,235887,'2010-09-24 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235915,235887,'2010-11-05 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235916,235887,'2010-10-04 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235917,235887,'2010-08-30 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235918,235887,'2010-10-15 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235919,235887,'2010-12-08 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235920,235887,'2010-11-17 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235921,235887,'2010-09-29 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235922,235887,'2010-09-22 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235923,235887,'2010-11-10 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235924,235887,'2010-09-10 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235925,235887,'2010-11-15 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235926,235887,'2010-09-03 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235927,235887,'2010-08-27 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235928,235887,'2010-10-08 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235929,235887,'2010-09-17 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235930,235887,'2010-11-19 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235931,235887,'2010-10-13 00:00:00',198,0,210,-10,2,0,'2010-09-22',1),
	(235933,235932,'2010-11-23 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235934,235932,'2010-12-09 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235935,235932,'2010-08-31 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235936,235932,'2010-09-16 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235937,235932,'2010-12-07 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235938,235932,'2010-11-04 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235939,235932,'2010-10-28 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235940,235932,'2010-11-30 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235941,235932,'2010-09-14 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235942,235932,'2010-11-16 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235943,235932,'2010-09-21 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235944,235932,'2010-08-24 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235945,235932,'2010-09-30 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235946,235932,'2010-12-02 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235947,235932,'2010-11-18 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235948,235932,'2010-08-26 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235949,235932,'2010-09-23 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235950,235932,'2010-09-07 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235951,235932,'2010-11-09 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235952,235932,'2010-09-28 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235953,235932,'2010-10-26 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235954,235932,'2010-09-09 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235955,235932,'2010-11-11 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235956,235932,'2010-10-07 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235957,235932,'2010-09-02 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235958,235932,'2010-10-21 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235959,235932,'2010-10-05 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235960,235932,'2010-10-19 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235961,235932,'2010-10-14 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235962,235932,'2010-11-02 00:00:00',180,0,198,-15,3,0,'2010-09-22',1),
	(235964,235963,'2010-09-22 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235965,235963,'2010-11-17 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235966,235963,'2010-10-20 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235967,235963,'2010-10-13 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235968,235963,'2010-10-06 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235969,235963,'2010-11-03 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235970,235963,'2010-12-08 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235971,235963,'2010-09-15 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235972,235963,'2010-12-01 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235973,235963,'2010-10-27 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235974,235963,'2010-08-25 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235975,235963,'2010-11-10 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235976,235963,'2010-09-01 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235977,235963,'2010-09-29 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235978,235963,'2010-09-08 00:00:00',186,0,198,-10,8,0,'2010-09-22',1),
	(235980,235979,'2010-09-30 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235981,235979,'2010-09-16 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235982,235979,'2010-08-26 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235983,235979,'2010-09-02 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235984,235979,'2010-10-28 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235985,235979,'2010-11-11 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235986,235979,'2010-12-09 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235987,235979,'2010-11-04 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235988,235979,'2010-09-09 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235989,235979,'2010-09-23 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235990,235979,'2010-10-21 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235991,235979,'2010-11-18 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235992,235979,'2010-10-14 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235993,235979,'2010-10-07 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235994,235979,'2010-12-02 00:00:00',162,0,174,-10,8,0,'2010-09-22',1),
	(235996,235995,'2010-09-20 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(235997,235995,'2010-09-13 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(235998,235995,'2010-11-01 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(235999,235995,'2010-08-30 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236000,235995,'2010-10-25 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236001,235995,'2010-08-23 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236002,235995,'2010-10-18 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236003,235995,'2010-10-04 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236004,235995,'2010-11-08 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236005,235995,'2010-11-22 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236006,235995,'2010-11-15 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236007,235995,'2010-12-06 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236008,235995,'2010-11-29 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236009,235995,'2010-09-27 00:00:00',102,0,114,-10,8,0,'2010-09-22',1),
	(236011,236010,'2010-09-17 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236012,236010,'2010-11-19 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236013,236010,'2010-12-03 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236014,236010,'2010-10-08 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236015,236010,'2010-10-22 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236016,236010,'2010-09-10 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236017,236010,'2010-10-15 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236018,236010,'2010-11-12 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236019,236010,'2010-10-29 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236020,236010,'2010-08-27 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236021,236010,'2010-09-24 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236022,236010,'2010-11-05 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236023,236010,'2010-10-01 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236024,236010,'2010-09-03 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236025,236010,'2010-12-10 00:00:00',138,0,162,-10,8,0,'2010-09-22',1),
	(236027,236026,'2010-10-14 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236028,236026,'2010-09-23 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236029,236026,'2010-10-28 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236030,236026,'2010-09-30 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236031,236026,'2010-08-26 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236032,236026,'2010-09-16 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236033,236026,'2010-09-02 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236034,236026,'2010-09-09 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236035,236026,'2010-12-02 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236036,236026,'2010-12-09 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236037,236026,'2010-10-07 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236038,236026,'2010-11-11 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236039,236026,'2010-11-04 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236040,236026,'2010-10-21 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236041,236026,'2010-11-18 00:00:00',114,0,138,-10,8,0,'2010-09-22',1),
	(236043,236042,'2010-10-06 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236044,236042,'2010-09-15 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236045,236042,'2010-10-20 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236046,236042,'2010-10-27 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236047,236042,'2010-12-08 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236048,236042,'2010-11-03 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236049,236042,'2010-10-13 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236050,236042,'2010-11-10 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236051,236042,'2010-09-29 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236052,236042,'2010-12-01 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236053,236042,'2010-09-08 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236054,236042,'2010-09-01 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236055,236042,'2010-11-17 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236056,236042,'2010-09-22 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236057,236042,'2010-08-25 00:00:00',162,0,186,-10,8,0,'2010-09-22',1),
	(236059,236058,'2010-10-28 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236060,236058,'2010-08-26 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236061,236058,'2010-12-09 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236062,236058,'2010-10-21 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236063,236058,'2010-11-18 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236064,236058,'2010-09-30 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236065,236058,'2010-10-14 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236066,236058,'2010-09-09 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236067,236058,'2010-10-07 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236068,236058,'2010-09-02 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236069,236058,'2010-09-23 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236070,236058,'2010-12-02 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236071,236058,'2010-09-16 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236072,236058,'2010-11-04 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236073,236058,'2010-11-11 00:00:00',90,0,114,-10,8,0,'2010-09-22',1),
	(236075,236074,'2010-12-01 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236076,236074,'2010-11-01 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236077,236074,'2010-12-03 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236078,236074,'2010-12-10 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236079,236074,'2010-08-27 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236080,236074,'2010-08-25 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236081,236074,'2010-08-23 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236082,236074,'2010-09-24 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236083,236074,'2010-12-08 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236084,236074,'2010-09-20 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236085,236074,'2010-09-27 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236086,236074,'2010-11-10 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236087,236074,'2010-09-08 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236088,236074,'2010-11-08 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236089,236074,'2010-09-17 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236090,236074,'2010-10-29 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236091,236074,'2010-09-10 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236092,236074,'2010-11-12 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236093,236074,'2010-10-08 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236094,236074,'2010-11-22 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236095,236074,'2010-09-15 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236096,236074,'2010-12-06 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236097,236074,'2010-11-03 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236098,236074,'2010-10-04 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236099,236074,'2010-09-22 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236100,236074,'2010-10-20 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236101,236074,'2010-10-01 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236102,236074,'2010-09-29 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236103,236074,'2010-11-15 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236104,236074,'2010-11-19 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236105,236074,'2010-11-17 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236106,236074,'2010-09-01 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236107,236074,'2010-09-13 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236108,236074,'2010-10-25 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236109,236074,'2010-11-29 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236110,236074,'2010-11-05 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236111,236074,'2010-10-18 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236112,236074,'2010-10-22 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236113,236074,'2010-08-30 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236114,236074,'2010-10-06 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236115,236074,'2010-09-03 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236116,236074,'2010-10-27 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236117,236074,'2010-10-13 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236118,236074,'2010-10-15 00:00:00',102,0,114,-10,3,0,'2010-09-22',1),
	(236120,236119,'2010-08-24 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236121,236119,'2010-11-23 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236122,236119,'2010-08-31 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236123,236119,'2010-08-26 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236124,236119,'2010-10-26 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236125,236119,'2010-12-02 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236126,236119,'2010-11-02 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236127,236119,'2010-11-16 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236128,236119,'2010-12-07 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236129,236119,'2010-11-30 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236130,236119,'2010-09-23 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236131,236119,'2010-09-16 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236132,236119,'2010-11-18 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236133,236119,'2010-09-30 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236134,236119,'2010-11-11 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236135,236119,'2010-10-14 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236136,236119,'2010-09-09 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236137,236119,'2010-09-21 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236138,236119,'2010-12-09 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236139,236119,'2010-10-05 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236140,236119,'2010-09-28 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236141,236119,'2010-11-04 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236142,236119,'2010-09-14 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236143,236119,'2010-10-07 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236144,236119,'2010-10-21 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236145,236119,'2010-10-28 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236146,236119,'2010-09-02 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236147,236119,'2010-11-09 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236148,236119,'2010-10-19 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236149,236119,'2010-09-07 00:00:00',162,0,180,-15,2,0,'2010-09-22',1),
	(236151,236150,'2010-12-02 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236152,236150,'2010-11-11 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236153,236150,'2010-10-21 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236154,236150,'2010-10-05 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236155,236150,'2010-10-14 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236156,236150,'2010-11-04 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236157,236150,'2010-12-07 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236158,236150,'2010-09-30 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236159,236150,'2010-10-26 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236160,236150,'2010-11-23 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236161,236150,'2010-09-16 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236162,236150,'2010-09-21 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236163,236150,'2010-09-28 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236164,236150,'2010-09-02 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236165,236150,'2010-08-26 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236166,236150,'2010-12-09 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236167,236150,'2010-09-09 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236168,236150,'2010-09-14 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236169,236150,'2010-11-16 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236170,236150,'2010-11-30 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236171,236150,'2010-10-28 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236172,236150,'2010-11-02 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236173,236150,'2010-09-23 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236174,236150,'2010-11-09 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236175,236150,'2010-08-31 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236176,236150,'2010-10-19 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236177,236150,'2010-11-18 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236178,236150,'2010-10-07 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236179,236150,'2010-08-24 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236180,236150,'2010-09-07 00:00:00',144,0,162,-15,3,0,'2010-09-22',1),
	(236182,236181,'2010-09-03 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236183,236181,'2010-09-17 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236184,236181,'2010-10-22 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236185,236181,'2010-09-10 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236186,236181,'2010-10-01 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236187,236181,'2010-08-27 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236188,236181,'2010-12-03 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236189,236181,'2010-11-05 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236190,236181,'2010-10-08 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236191,236181,'2010-12-10 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236192,236181,'2010-09-24 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236193,236181,'2010-10-15 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236194,236181,'2010-10-29 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236195,236181,'2010-11-19 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236196,236181,'2010-11-12 00:00:00',90,0,102,-10,4,0,'2010-09-22',1),
	(236198,236197,'2010-09-20 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236199,236197,'2010-09-13 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236200,236197,'2010-11-22 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236201,236197,'2010-11-29 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236202,236197,'2010-11-01 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236203,236197,'2010-11-08 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236204,236197,'2010-09-27 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236205,236197,'2010-10-18 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236206,236197,'2010-10-25 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236207,236197,'2010-12-06 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236208,236197,'2010-08-30 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236209,236197,'2010-10-04 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236210,236197,'2010-11-15 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236211,236197,'2010-08-23 00:00:00',138,0,150,-10,4,0,'2010-09-22',1),
	(236213,236212,'2010-11-08 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236214,236212,'2010-11-03 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236215,236212,'2010-09-22 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236216,236212,'2010-10-13 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236217,236212,'2010-09-03 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236218,236212,'2010-10-22 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236219,236212,'2010-11-19 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236220,236212,'2010-11-29 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236221,236212,'2010-11-10 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236222,236212,'2010-10-20 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236223,236212,'2010-11-01 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236224,236212,'2010-08-25 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236225,236212,'2010-09-10 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236226,236212,'2010-12-06 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236227,236212,'2010-12-03 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236228,236212,'2010-09-08 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236229,236212,'2010-09-15 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236230,236212,'2010-12-08 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236231,236212,'2010-08-23 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236232,236212,'2010-10-04 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236233,236212,'2010-12-10 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236234,236212,'2010-11-12 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236235,236212,'2010-10-25 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236236,236212,'2010-09-29 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236237,236212,'2010-09-01 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236238,236212,'2010-08-30 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236239,236212,'2010-10-01 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236240,236212,'2010-09-13 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236241,236212,'2010-10-15 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236242,236212,'2010-11-15 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236243,236212,'2010-10-08 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236244,236212,'2010-09-20 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236245,236212,'2010-11-05 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236246,236212,'2010-08-27 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236247,236212,'2010-10-27 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236248,236212,'2010-11-17 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236249,236212,'2010-11-22 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236250,236212,'2010-09-27 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236251,236212,'2010-12-01 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236252,236212,'2010-10-29 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236253,236212,'2010-09-17 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236254,236212,'2010-09-24 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236255,236212,'2010-10-06 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236256,236212,'2010-10-18 00:00:00',114,0,126,-10,3,0,'2010-09-22',1),
	(236258,236257,'2010-12-07 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236259,236257,'2010-09-28 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236260,236257,'2010-11-02 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236261,236257,'2010-10-05 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236262,236257,'2010-09-07 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236263,236257,'2010-11-16 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236264,236257,'2010-08-31 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236265,236257,'2010-09-21 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236266,236257,'2010-11-23 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236267,236257,'2010-10-26 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236268,236257,'2010-09-14 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236269,236257,'2010-11-30 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236270,236257,'2010-11-09 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236271,236257,'2010-10-19 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236272,236257,'2010-08-24 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236274,236273,'2010-09-20 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236275,236273,'2010-08-30 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236276,236273,'2010-08-27 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236277,236273,'2010-12-06 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236278,236273,'2010-10-04 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236279,236273,'2010-11-08 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236280,236273,'2010-11-12 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236281,236273,'2010-09-13 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236282,236273,'2010-11-19 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236283,236273,'2010-09-03 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236284,236273,'2010-10-08 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236285,236273,'2010-11-01 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236286,236273,'2010-11-15 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236287,236273,'2010-09-17 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236288,236273,'2010-12-10 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236289,236273,'2010-10-15 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236290,236273,'2010-11-29 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236291,236273,'2010-10-18 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236292,236273,'2010-12-03 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236293,236273,'2010-11-05 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236294,236273,'2010-10-01 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236295,236273,'2010-08-23 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236296,236273,'2010-10-25 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236297,236273,'2010-11-22 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236298,236273,'2010-09-27 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236299,236273,'2010-09-10 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236300,236273,'2010-10-22 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236301,236273,'2010-09-24 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236302,236273,'2010-10-29 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236304,236303,'2010-10-05 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236305,236303,'2010-12-07 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236306,236303,'2010-09-14 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236307,236303,'2010-08-31 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236308,236303,'2010-09-30 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236309,236303,'2010-09-23 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236310,236303,'2010-11-23 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236311,236303,'2010-11-09 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236312,236303,'2010-09-16 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236313,236303,'2010-11-16 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236314,236303,'2010-09-28 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236315,236303,'2010-11-18 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236316,236303,'2010-12-09 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236317,236303,'2010-10-19 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236318,236303,'2010-08-26 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236319,236303,'2010-11-04 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236320,236303,'2010-11-30 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236321,236303,'2010-09-21 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236322,236303,'2010-10-07 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236323,236303,'2010-08-24 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236324,236303,'2010-10-14 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236325,236303,'2010-09-02 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236326,236303,'2010-09-09 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236327,236303,'2010-11-11 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236328,236303,'2010-10-26 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236329,236303,'2010-11-02 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236330,236303,'2010-09-07 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236331,236303,'2010-10-28 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236332,236303,'2010-12-02 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236333,236303,'2010-10-21 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236335,236334,'2010-10-14 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236336,236334,'2010-08-24 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236337,236334,'2010-10-05 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236338,236334,'2010-09-02 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236339,236334,'2010-11-09 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236340,236334,'2010-08-31 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236341,236334,'2010-09-09 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236342,236334,'2010-11-16 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236343,236334,'2010-10-19 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236344,236334,'2010-12-02 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236345,236334,'2010-10-26 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236346,236334,'2010-09-30 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236347,236334,'2010-09-21 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236348,236334,'2010-11-11 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236349,236334,'2010-09-16 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236350,236334,'2010-09-07 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236351,236334,'2010-11-18 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236352,236334,'2010-09-28 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236353,236334,'2010-10-21 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236354,236334,'2010-12-07 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236355,236334,'2010-09-23 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236356,236334,'2010-11-23 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236357,236334,'2010-08-26 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236358,236334,'2010-11-02 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236359,236334,'2010-11-04 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236360,236334,'2010-12-09 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236361,236334,'2010-11-30 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236362,236334,'2010-10-07 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236363,236334,'2010-10-28 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236364,236334,'2010-09-14 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236366,236365,'2010-12-03 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236367,236365,'2010-09-15 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236368,236365,'2010-10-22 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236369,236365,'2010-11-05 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236370,236365,'2010-09-20 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236371,236365,'2010-10-15 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236372,236365,'2010-11-10 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236373,236365,'2010-11-08 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236374,236365,'2010-11-01 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236375,236365,'2010-10-29 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236376,236365,'2010-10-06 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236377,236365,'2010-12-08 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236378,236365,'2010-09-10 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236379,236365,'2010-11-03 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236380,236365,'2010-09-24 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236381,236365,'2010-10-01 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236382,236365,'2010-08-23 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236383,236365,'2010-08-30 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236384,236365,'2010-09-03 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236385,236365,'2010-12-10 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236386,236365,'2010-11-19 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236387,236365,'2010-11-29 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236388,236365,'2010-11-22 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236389,236365,'2010-10-20 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236390,236365,'2010-09-13 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236391,236365,'2010-09-29 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236392,236365,'2010-10-27 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236393,236365,'2010-10-08 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236394,236365,'2010-09-22 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236395,236365,'2010-08-27 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236396,236365,'2010-09-17 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236397,236365,'2010-08-25 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236398,236365,'2010-09-01 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236399,236365,'2010-11-12 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236400,236365,'2010-12-06 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236401,236365,'2010-09-27 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236402,236365,'2010-11-15 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236403,236365,'2010-10-13 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236404,236365,'2010-10-25 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236405,236365,'2010-12-01 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236406,236365,'2010-09-08 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236407,236365,'2010-11-17 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236408,236365,'2010-10-18 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236409,236365,'2010-10-04 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236411,236410,'2010-12-03 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236412,236410,'2010-10-15 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236413,236410,'2010-08-23 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236414,236410,'2010-10-25 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236415,236410,'2010-11-19 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236416,236410,'2010-10-18 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236417,236410,'2010-11-08 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236418,236410,'2010-08-27 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236419,236410,'2010-09-13 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236420,236410,'2010-11-05 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236421,236410,'2010-10-22 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236422,236410,'2010-11-22 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236423,236410,'2010-11-29 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236424,236410,'2010-09-20 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236425,236410,'2010-09-10 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236426,236410,'2010-08-30 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236427,236410,'2010-10-08 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236428,236410,'2010-11-01 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236429,236410,'2010-12-06 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236430,236410,'2010-10-01 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236431,236410,'2010-11-12 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236432,236410,'2010-10-04 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236433,236410,'2010-09-17 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236434,236410,'2010-11-15 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236435,236410,'2010-09-27 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236436,236410,'2010-12-10 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236437,236410,'2010-09-03 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236438,236410,'2010-09-24 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236439,236410,'2010-10-29 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236441,236440,'2010-12-08 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236442,236440,'2010-08-25 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236443,236440,'2010-09-15 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236444,236440,'2010-09-08 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236445,236440,'2010-11-03 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236446,236440,'2010-10-27 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236447,236440,'2010-11-17 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236448,236440,'2010-10-20 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236449,236440,'2010-09-01 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236450,236440,'2010-10-06 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236451,236440,'2010-09-29 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236452,236440,'2010-09-22 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236453,236440,'2010-10-13 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236454,236440,'2010-12-01 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236455,236440,'2010-11-10 00:00:00',174,0,186,-10,1,0,'2010-09-22',1),
	(236457,236456,'2010-08-26 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236458,236456,'2010-09-09 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236459,236456,'2010-12-06 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236460,236456,'2010-08-30 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236461,236456,'2010-09-30 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236462,236456,'2010-10-20 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236463,236456,'2010-12-10 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236464,236456,'2010-11-05 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236465,236456,'2010-10-19 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236466,236456,'2010-10-08 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236467,236456,'2010-10-27 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236468,236456,'2010-11-16 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236469,236456,'2010-10-26 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236470,236456,'2010-08-27 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236471,236456,'2010-11-17 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236472,236456,'2010-11-15 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236473,236456,'2010-09-22 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236474,236456,'2010-08-25 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236475,236456,'2010-09-07 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236476,236456,'2010-11-23 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236477,236456,'2010-11-04 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236478,236456,'2010-09-10 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236479,236456,'2010-11-03 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236480,236456,'2010-11-09 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236481,236456,'2010-10-28 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236482,236456,'2010-10-29 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236483,236456,'2010-11-10 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236484,236456,'2010-11-30 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236485,236456,'2010-09-28 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236486,236456,'2010-10-04 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236487,236456,'2010-11-22 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236488,236456,'2010-11-11 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236489,236456,'2010-12-03 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236490,236456,'2010-08-24 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236491,236456,'2010-10-07 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236492,236456,'2010-10-01 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236493,236456,'2010-12-07 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236494,236456,'2010-09-20 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236495,236456,'2010-09-02 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236496,236456,'2010-11-02 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236497,236456,'2010-12-02 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236498,236456,'2010-12-08 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236499,236456,'2010-10-14 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236500,236456,'2010-09-17 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236501,236456,'2010-09-27 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236502,236456,'2010-10-13 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236503,236456,'2010-09-01 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236504,236456,'2010-10-21 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236505,236456,'2010-11-08 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236506,236456,'2010-11-29 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236507,236456,'2010-09-21 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236508,236456,'2010-08-23 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236509,236456,'2010-10-05 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236510,236456,'2010-09-13 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236511,236456,'2010-08-31 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236512,236456,'2010-10-25 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236513,236456,'2010-09-08 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236514,236456,'2010-11-01 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236515,236456,'2010-09-29 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236516,236456,'2010-10-15 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236517,236456,'2010-11-19 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236518,236456,'2010-11-18 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236519,236456,'2010-12-09 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236520,236456,'2010-09-14 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236521,236456,'2010-09-15 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236522,236456,'2010-10-06 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236523,236456,'2010-12-01 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236524,236456,'2010-10-18 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236525,236456,'2010-11-12 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236526,236456,'2010-09-16 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236527,236456,'2010-09-24 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236528,236456,'2010-10-22 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236529,236456,'2010-09-23 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236530,236456,'2010-09-03 00:00:00',186,0,210,-10,1,0,'2010-09-22',1),
	(236532,236531,'2010-09-22 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236533,236531,'2010-10-06 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236534,236531,'2010-08-25 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236535,236531,'2010-11-17 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236536,236531,'2010-09-15 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236537,236531,'2010-09-29 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236538,236531,'2010-10-13 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236539,236531,'2010-12-01 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236540,236531,'2010-12-08 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236541,236531,'2010-11-03 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236542,236531,'2010-09-08 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236543,236531,'2010-10-27 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236544,236531,'2010-09-01 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236545,236531,'2010-10-20 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236546,236531,'2010-11-10 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236548,236547,'2010-12-09 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236549,236547,'2010-09-16 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236550,236547,'2010-12-02 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236551,236547,'2010-11-11 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236552,236547,'2010-10-21 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236553,236547,'2010-11-18 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236554,236547,'2010-09-02 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236555,236547,'2010-10-07 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236556,236547,'2010-09-30 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236557,236547,'2010-11-04 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236558,236547,'2010-09-09 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236559,236547,'2010-09-23 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236560,236547,'2010-08-26 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236561,236547,'2010-10-28 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236562,236547,'2010-10-14 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236564,236563,'2010-11-05 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236565,236563,'2010-10-15 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236566,236563,'2010-08-30 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236567,236563,'2010-10-13 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236568,236563,'2010-08-23 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236569,236563,'2010-10-04 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236570,236563,'2010-11-29 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236571,236563,'2010-09-20 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236572,236563,'2010-10-20 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236573,236563,'2010-10-18 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236574,236563,'2010-12-03 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236575,236563,'2010-12-01 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236576,236563,'2010-12-06 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236577,236563,'2010-08-27 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236578,236563,'2010-09-01 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236579,236563,'2010-10-01 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236580,236563,'2010-12-10 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236581,236563,'2010-11-19 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236582,236563,'2010-11-08 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236583,236563,'2010-10-22 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236584,236563,'2010-11-15 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236585,236563,'2010-11-01 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236586,236563,'2010-09-24 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236587,236563,'2010-09-08 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236588,236563,'2010-10-29 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236589,236563,'2010-10-25 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236590,236563,'2010-11-17 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236591,236563,'2010-12-08 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236592,236563,'2010-09-10 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236593,236563,'2010-09-17 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236594,236563,'2010-09-29 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236595,236563,'2010-11-03 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236596,236563,'2010-09-22 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236597,236563,'2010-09-03 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236598,236563,'2010-09-27 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236599,236563,'2010-11-22 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236600,236563,'2010-09-13 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236601,236563,'2010-10-06 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236602,236563,'2010-11-10 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236603,236563,'2010-09-15 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236604,236563,'2010-10-27 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236605,236563,'2010-11-12 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236606,236563,'2010-08-25 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236607,236563,'2010-10-08 00:00:00',162,0,174,-10,1,0,'2010-09-22',1),
	(236609,236608,'2010-11-01 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236610,236608,'2010-11-29 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236611,236608,'2010-08-25 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236612,236608,'2010-10-18 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236613,236608,'2010-09-10 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236614,236608,'2010-08-23 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236615,236608,'2010-09-22 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236616,236608,'2010-10-06 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236617,236608,'2010-11-17 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236618,236608,'2010-11-15 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236619,236608,'2010-10-29 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236620,236608,'2010-10-04 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236621,236608,'2010-09-27 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236622,236608,'2010-09-03 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236623,236608,'2010-10-08 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236624,236608,'2010-11-10 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236625,236608,'2010-11-08 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236626,236608,'2010-11-22 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236627,236608,'2010-10-01 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236628,236608,'2010-09-24 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236629,236608,'2010-12-10 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236630,236608,'2010-11-19 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236631,236608,'2010-09-08 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236632,236608,'2010-12-08 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236633,236608,'2010-10-25 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236634,236608,'2010-09-15 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236635,236608,'2010-09-13 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236636,236608,'2010-08-30 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236637,236608,'2010-11-05 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236638,236608,'2010-09-01 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236639,236608,'2010-09-29 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236640,236608,'2010-10-13 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236641,236608,'2010-11-03 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236642,236608,'2010-10-27 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236643,236608,'2010-09-20 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236644,236608,'2010-10-15 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236645,236608,'2010-10-20 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236646,236608,'2010-11-12 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236647,236608,'2010-08-27 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236648,236608,'2010-12-03 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236649,236608,'2010-09-17 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236650,236608,'2010-12-06 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236651,236608,'2010-10-22 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236652,236608,'2010-12-01 00:00:00',90,0,102,-10,1,0,'2010-09-22',1),
	(236654,236653,'2010-10-18 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236655,236653,'2010-10-15 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236656,236653,'2010-11-15 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236657,236653,'2010-11-03 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236658,236653,'2010-11-29 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236659,236653,'2010-09-29 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236660,236653,'2010-09-22 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236661,236653,'2010-10-08 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236662,236653,'2010-10-29 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236663,236653,'2010-09-17 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236664,236653,'2010-09-13 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236665,236653,'2010-09-10 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236666,236653,'2010-09-20 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236667,236653,'2010-10-25 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236668,236653,'2010-11-17 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236669,236653,'2010-11-05 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236670,236653,'2010-12-08 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236671,236653,'2010-10-01 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236672,236653,'2010-12-01 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236673,236653,'2010-09-01 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236674,236653,'2010-09-24 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236675,236653,'2010-10-13 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236676,236653,'2010-11-22 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236677,236653,'2010-11-19 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236678,236653,'2010-10-27 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236679,236653,'2010-08-25 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236680,236653,'2010-10-06 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236681,236653,'2010-11-01 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236682,236653,'2010-08-27 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236683,236653,'2010-12-03 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236684,236653,'2010-09-08 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236685,236653,'2010-09-27 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236686,236653,'2010-10-22 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236687,236653,'2010-11-12 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236688,236653,'2010-12-10 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236689,236653,'2010-09-03 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236690,236653,'2010-09-15 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236691,236653,'2010-08-30 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236692,236653,'2010-08-23 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236693,236653,'2010-11-10 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236694,236653,'2010-10-20 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236695,236653,'2010-12-06 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236696,236653,'2010-11-08 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236697,236653,'2010-10-04 00:00:00',126,0,138,-10,1,0,'2010-09-22',1),
	(236699,236698,'2010-08-25 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236700,236698,'2010-10-04 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236701,236698,'2010-11-03 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236702,236698,'2010-10-27 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236703,236698,'2010-11-22 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236704,236698,'2010-11-29 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236705,236698,'2010-09-17 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236706,236698,'2010-08-30 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236707,236698,'2010-12-10 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236708,236698,'2010-12-06 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236709,236698,'2010-10-08 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236710,236698,'2010-11-15 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236711,236698,'2010-09-03 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236712,236698,'2010-10-20 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236713,236698,'2010-11-19 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236714,236698,'2010-12-08 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236715,236698,'2010-12-03 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236716,236698,'2010-10-06 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236717,236698,'2010-10-18 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236718,236698,'2010-11-12 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236719,236698,'2010-09-29 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236720,236698,'2010-08-27 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236721,236698,'2010-09-13 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236722,236698,'2010-09-10 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236723,236698,'2010-11-08 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236724,236698,'2010-10-25 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236725,236698,'2010-09-15 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236726,236698,'2010-11-17 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236727,236698,'2010-09-01 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236728,236698,'2010-09-08 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236729,236698,'2010-10-22 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236730,236698,'2010-11-05 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236731,236698,'2010-11-01 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236732,236698,'2010-09-27 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236733,236698,'2010-10-01 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236734,236698,'2010-09-22 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236735,236698,'2010-09-20 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236736,236698,'2010-10-15 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236737,236698,'2010-12-01 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236738,236698,'2010-09-24 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236739,236698,'2010-08-23 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236740,236698,'2010-11-10 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236741,236698,'2010-10-29 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236742,236698,'2010-10-13 00:00:00',102,0,114,-10,1,0,'2010-09-22',1),
	(236744,236743,'2010-12-02 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236745,236743,'2010-08-31 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236746,236743,'2010-11-11 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236747,236743,'2010-10-14 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236748,236743,'2010-10-19 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236749,236743,'2010-09-16 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236750,236743,'2010-11-09 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236751,236743,'2010-11-18 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236752,236743,'2010-10-05 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236753,236743,'2010-09-28 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236754,236743,'2010-10-26 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236755,236743,'2010-09-30 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236756,236743,'2010-09-14 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236757,236743,'2010-10-21 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236758,236743,'2010-08-24 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236759,236743,'2010-11-16 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236760,236743,'2010-09-09 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236761,236743,'2010-09-23 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236762,236743,'2010-11-30 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236763,236743,'2010-09-02 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236764,236743,'2010-10-07 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236765,236743,'2010-08-26 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236766,236743,'2010-09-07 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236767,236743,'2010-12-07 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236768,236743,'2010-11-02 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236769,236743,'2010-12-09 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236770,236743,'2010-11-04 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236771,236743,'2010-11-23 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236772,236743,'2010-09-21 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236773,236743,'2010-10-28 00:00:00',138,0,150,-10,1,0,'2010-09-22',1),
	(236775,236774,'2010-12-02 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236776,236774,'2010-08-31 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236777,236774,'2010-09-21 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236778,236774,'2010-09-23 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236779,236774,'2010-10-28 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236780,236774,'2010-11-04 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236781,236774,'2010-08-24 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236782,236774,'2010-09-30 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236783,236774,'2010-09-02 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236784,236774,'2010-10-26 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236785,236774,'2010-11-02 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236786,236774,'2010-09-16 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236787,236774,'2010-10-14 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236788,236774,'2010-10-21 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236789,236774,'2010-08-26 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236790,236774,'2010-11-30 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236791,236774,'2010-10-07 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236792,236774,'2010-12-09 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236793,236774,'2010-09-14 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236794,236774,'2010-10-19 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236795,236774,'2010-11-16 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236796,236774,'2010-09-09 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236797,236774,'2010-11-18 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236798,236774,'2010-11-23 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236799,236774,'2010-09-28 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236800,236774,'2010-09-07 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236801,236774,'2010-11-09 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236802,236774,'2010-12-07 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236803,236774,'2010-10-05 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236804,236774,'2010-11-11 00:00:00',114,0,126,-10,1,0,'2010-09-22',1),
	(236806,236805,'2010-08-23 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236807,236805,'2010-11-29 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236808,236805,'2010-12-06 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236809,236805,'2010-10-13 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236810,236805,'2010-09-20 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236811,236805,'2010-09-15 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236812,236805,'2010-09-01 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236813,236805,'2010-10-04 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236814,236805,'2010-10-27 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236815,236805,'2010-09-13 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236816,236805,'2010-11-15 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236817,236805,'2010-11-10 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236818,236805,'2010-09-22 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236819,236805,'2010-10-25 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236820,236805,'2010-10-06 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236821,236805,'2010-09-08 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236822,236805,'2010-12-08 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236823,236805,'2010-08-30 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236824,236805,'2010-11-01 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236825,236805,'2010-11-03 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236826,236805,'2010-10-18 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236827,236805,'2010-10-20 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236828,236805,'2010-09-27 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236829,236805,'2010-11-17 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236830,236805,'2010-12-01 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236831,236805,'2010-09-29 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236832,236805,'2010-11-08 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236833,236805,'2010-11-22 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(236834,236805,'2010-08-25 00:00:00',150,0,162,-10,1,0,'2010-09-22',1),
	(239013,239012,'2010-12-13 00:00:00',156,0,192,0,9,0,'2010-09-22',1),
	(239015,239014,'2010-12-16 00:00:00',96,0,120,-60,9,0,'2010-09-22',1),
	(239017,239016,'2010-12-13 00:00:00',156,0,192,0,2,0,'2010-09-22',1),
	(239018,239016,'2010-12-13 00:00:00',156,0,192,0,1,0,'2010-09-22',1),
	(239020,239019,'2010-12-13 00:00:00',96,0,120,0,9,0,'2010-09-22',1),
	(239022,239021,'2010-12-14 00:00:00',138,0,150,0,9,0,'2010-09-22',1),
	(239024,239023,'2010-12-14 00:00:00',156,0,192,-60,1,0,'2010-09-22',1),
	(239026,239025,'2010-12-13 00:00:00',96,0,120,0,3,0,'2010-09-22',1),
	(239028,239027,'2010-12-14 00:00:00',156,0,192,-60,2,0,'2010-09-22',1),
	(239030,239029,'2010-12-15 00:00:00',96,0,120,0,3,0,'2010-09-22',1),
	(239032,239031,'2010-12-13 00:00:00',96,0,120,0,1,0,'2010-09-22',1),
	(239034,239033,'2010-12-13 00:00:00',138,0,150,0,9,0,'2010-09-22',1),
	(239036,239035,'2010-12-13 00:00:00',156,0,192,0,3,0,'2010-09-22',1),
	(239038,239037,'2010-12-15 00:00:00',96,0,120,-60,2,0,'2010-09-22',1),
	(239040,239039,'2010-12-15 00:00:00',138,0,150,0,1,0,'2010-09-22',1),
	(239041,239039,'2010-12-15 00:00:00',138,0,150,0,9,0,'2010-09-22',1),
	(239042,239039,'2010-12-15 00:00:00',138,0,150,0,2,0,'2010-09-22',1),
	(239044,239043,'2010-12-14 00:00:00',96,0,120,-60,3,0,'2010-09-22',1),
	(239045,239043,'2010-12-14 00:00:00',96,0,120,-60,1,0,'2010-09-22',1),
	(239047,239046,'2010-12-14 00:00:00',156,0,192,-60,9,0,'2010-09-22',1),
	(239049,239048,'2010-12-14 00:00:00',96,0,120,-60,2,0,'2010-09-22',1),
	(239051,239050,'2010-12-15 00:00:00',96,0,120,0,9,0,'2010-09-22',1),
	(239053,239052,'2010-12-13 00:00:00',96,0,120,0,2,0,'2010-09-22',1),
	(239055,239054,'2010-12-14 00:00:00',96,0,120,0,9,0,'2010-09-22',1),
	(239057,239056,'2010-12-13 00:00:00',138,0,150,0,3,0,'2010-09-22',1),
	(239058,239056,'2010-12-13 00:00:00',138,0,150,0,2,0,'2010-09-22',1),
	(239060,239059,'2010-12-16 00:00:00',96,0,120,0,1,0,'2010-09-22',1),
	(239062,239061,'2010-12-15 00:00:00',156,0,192,-60,9,0,'2010-09-22',1),
	(239064,239063,'2010-12-14 00:00:00',156,0,192,-60,3,0,'2010-09-22',1),
	(239066,239065,'2010-12-16 00:00:00',138,0,150,0,1,0,'2010-09-22',1),
	(239067,239065,'2010-12-16 00:00:00',138,0,150,0,9,0,'2010-09-22',1),
	(239069,239068,'2010-12-15 00:00:00',96,0,120,0,1,0,'2010-09-22',1),
	(239109,239108,'2010-11-08 00:00:00',240,0,264,0,2,0,'2010-09-22',1),
	(239111,239110,'2010-09-08 00:00:00',240,0,264,0,9,0,'2010-09-22',1),
	(239112,239110,'2010-09-08 00:00:00',240,0,264,0,3,0,'2010-09-22',1),
	(239113,239110,'2010-09-08 00:00:00',240,0,264,0,2,0,'2010-09-22',1),
	(239115,239114,'2010-09-29 00:00:00',240,0,264,0,9,0,'2010-09-22',1),
	(239117,239116,'2010-09-28 00:00:00',222,0,234,0,2,0,'2010-09-22',1),
	(239119,239118,'2010-11-01 00:00:00',240,0,264,0,9,0,'2010-09-22',1),
	(239121,239120,'2010-10-25 00:00:00',240,0,264,0,2,0,'2010-09-22',1),
	(239122,239120,'2010-10-25 00:00:00',240,0,264,0,9,0,'2010-09-22',1),
	(239123,239120,'2010-10-25 00:00:00',240,0,264,0,3,0,'2010-09-22',1),
	(239125,239124,'2010-09-09 00:00:00',240,0,264,0,9,0,'2010-09-22',1),
	(239126,239124,'2010-09-09 00:00:00',240,0,264,0,2,0,'2010-09-22',1),
	(239128,239127,'2010-09-27 00:00:00',240,0,264,0,9,0,'2010-09-22',1),
	(239129,239127,'2010-09-27 00:00:00',240,0,264,0,2,0,'2010-09-22',1),
	(239131,239130,'2010-10-26 00:00:00',240,0,264,0,1,0,'2010-09-22',1),
	(239132,239130,'2010-10-26 00:00:00',240,0,264,0,9,0,'2010-09-22',1),
	(239133,239130,'2010-10-26 00:00:00',240,0,264,0,4,0,'2010-09-22',1),
	(239135,239134,'2010-10-26 00:00:00',222,0,234,0,2,0,'2010-09-22',1),
	(239137,239136,'2010-08-23 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239138,239136,'2010-08-30 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239139,239136,'2010-09-06 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239140,239136,'2010-09-13 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239141,239136,'2010-09-20 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239142,239136,'2010-09-27 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239143,239136,'2010-10-04 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239144,239136,'2010-10-11 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239145,239136,'2010-10-18 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239146,239136,'2010-10-25 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239147,239136,'2010-11-01 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239148,239136,'2010-11-08 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239149,239136,'2010-11-15 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239150,239136,'2010-11-22 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239151,239136,'2010-11-29 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1),
	(239152,239136,'2010-12-06 00:00:00',96,NULL,120,NULL,9,1,'2010-09-22',1);

insert into `non_university_location` values
	(7995,223206,'MALL',10,NULL,NULL,0,'226216','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,5,21,429,226216,NULL,NULL,NULL,NULL,NULL,NULL,NULL),
	(8018,231379,'MALL',10,NULL,NULL,0,'231384','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,5,21,429,231384,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

insert into `offr_consent_type` values
	(225,'IN','Consent of Instructor','Instructor'),
	(226,'DP','Consent of Department','Department');

insert into `pos_acad_area_major` values
	(142,1201),
	(142,1204),
	(142,1205),
	(144,1207),
	(144,1208),
	(144,1209);

insert into `pos_major` values
	(1201,'M1','Major 1','M1',231379),
	(1204,'M2','Major 2','M2',231379),
	(1205,'M3','Major 3','M3',231379),
	(1207,'M1','Major 1','M1',223206),
	(1208,'M2','Major 2','M2',223206),
	(1209,'M3','Major 3','M3',223206);

insert into `position_type` values
	(1,'PROF','Professor',100),
	(2,'ASSOC_PROF','Associate Professor',200),
	(3,'ASST_PROF','Assistant Professor',300),
	(4,'INSTRUCTOR','Instructor',800),
	(5,'CLIN_PROF','Clinical / Professional',500),
	(6,'CONT_LEC','Continuing Lecturer',600),
	(7,'LTD_LEC','Limited-Term Lecturer',700),
	(8,'VISIT_FAC','Visiting Faculty',400),
	(9,'POST_DOC','Post Doctoral',1500),
	(10,'ADJUNCT_FAC','Adjunct Faculty',1000),
	(11,'GRAD_TEACH_ASST','Graduate Teaching Assistant',1200),
	(12,'GRAD_LEC','Graduate Lecturer',1100),
	(13,'CLERICAL_STAFF','Clerical Staff',1600),
	(14,'SERVICE_STAFF','Service Staff',1700),
	(15,'FELLOWSHIP','Fellowship',1800),
	(16,'EMERITUS','Emeritus Faculty',900),
	(17,'OTHER','Other',2000),
	(18,'ADMIN_STAFF','Administrative/Professional Staff',1300),
	(19,'UNDRGRD_TEACH_ASST','Undergrad Teaching Assistant',1400);

insert into `preference_level` values
	(1,'R','Required',1),
	(2,'-2','Strongly Preferred',2),
	(3,'-1','Preferred',3),
	(4,'0','Neutral',4),
	(5,'1','Discouraged',5),
	(6,'2','Strongly Discouraged',6),
	(7,'P','Prohibited',7);

insert into `rights` values
	(1,'AcademicAreaEdit'),
	(1,'AcademicAreas'),
	(1,'AcademicClassificationEdit'),
	(1,'AcademicClassifications'),
	(1,'AcademicSessionAdd'),
	(1,'AcademicSessionDelete'),
	(1,'AcademicSessionEdit'),
	(1,'AcademicSessions'),
	(1,'AddCourseOffering'),
	(1,'AddNonUnivLocation'),
	(1,'AddRoom'),
	(1,'AddSpecialUseRoom'),
	(1,'AddSpecialUseRoomExternalRoom'),
	(1,'AllowTestSessions'),
	(1,'ApplicationConfig'),
	(1,'AssignInstructors'),
	(1,'AssignInstructorsClass'),
	(1,'AssignedClasses'),
	(1,'AssignedExaminations'),
	(1,'AssignmentHistory'),
	(1,'BuildingAdd'),
	(1,'BuildingDelete'),
	(1,'BuildingEdit'),
	(1,'BuildingExportPdf'),
	(1,'BuildingList'),
	(1,'BuildingUpdateData'),
	(1,'CanSelectSolverServer'),
	(1,'CanUseHardDistributionPrefs'),
	(1,'CanUseHardPeriodPrefs'),
	(1,'CanUseHardRoomPrefs'),
	(1,'CanUseHardTimePrefs'),
	(1,'Chameleon'),
	(1,'ChangePassword'),
	(1,'ClassAssignment'),
	(1,'ClassAssignments'),
	(1,'ClassAssignmentsExportCsv'),
	(1,'ClassAssignmentsExportPdf'),
	(1,'ClassDetail'),
	(1,'ClassEdit'),
	(1,'ClassEditClearPreferences'),
	(1,'Classes'),
	(1,'ClassesExportPDF'),
	(1,'ClearHibernateCache'),
	(1,'ConflictStatistics'),
	(1,'ConsentApproval'),
	(1,'CourseCreditFormatEdit'),
	(1,'CourseCreditFormats'),
	(1,'CourseCreditTypeEdit'),
	(1,'CourseCreditTypes'),
	(1,'CourseCreditUnitEdit'),
	(1,'CourseCreditUnits'),
	(1,'CourseRequests'),
	(1,'CourseTimetabling'),
	(1,'CourseTimetablingAudit'),
	(1,'CourseTypeEdit'),
	(1,'CourseTypes'),
	(1,'CurriculumAdd'),
	(1,'CurriculumAdmin'),
	(1,'CurriculumDelete'),
	(1,'CurriculumDetail'),
	(1,'CurriculumEdit'),
	(1,'CurriculumMerge'),
	(1,'CurriculumProjectionRulesDetail'),
	(1,'CurriculumProjectionRulesEdit'),
	(1,'CurriculumView'),
	(1,'DataExchange'),
	(1,'DatePatterns'),
	(1,'DepartmenalRoomFeatureDelete'),
	(1,'DepartmenalRoomFeatureEdit'),
	(1,'DepartmenalRoomGroupDelete'),
	(1,'DepartmenalRoomGroupEdit'),
	(1,'DepartmentAdd'),
	(1,'DepartmentDelete'),
	(1,'DepartmentEdit'),
	(1,'DepartmentEditChangeExternalManager'),
	(1,'DepartmentIndependent'),
	(1,'DepartmentRoomFeatureAdd'),
	(1,'DepartmentRoomGroupAdd'),
	(1,'Departments'),
	(1,'DistributionPreferenceAdd'),
	(1,'DistributionPreferenceClass'),
	(1,'DistributionPreferenceDelete'),
	(1,'DistributionPreferenceDetail'),
	(1,'DistributionPreferenceEdit'),
	(1,'DistributionPreferenceExam'),
	(1,'DistributionPreferenceSubpart'),
	(1,'DistributionPreferences'),
	(1,'DistributionTypeEdit'),
	(1,'DistributionTypes'),
	(1,'EditCourseOffering'),
	(1,'EditCourseOfferingCoordinators'),
	(1,'EditRoomDepartments'),
	(1,'EditRoomDepartmentsExams'),
	(1,'EditRoomDepartmentsFinalExams'),
	(1,'EditRoomDepartmentsMidtermExams'),
	(1,'EnrollmentAuditPDFReports'),
	(1,'EventAddCourseRelated'),
	(1,'EventAddSpecial'),
	(1,'EventAddUnavailable'),
	(1,'EventAnyLocation'),
	(1,'EventApprovePast'),
	(1,'EventDate'),
	(1,'EventDetail'),
	(1,'EventEdit'),
	(1,'EventLocation'),
	(1,'EventLocationApprove'),
	(1,'EventLocationOverbook'),
	(1,'EventLocationUnavailable'),
	(1,'EventLookupContact'),
	(1,'EventLookupSchedule'),
	(1,'EventMeetingApprove'),
	(1,'EventMeetingCancel'),
	(1,'EventMeetingDelete'),
	(1,'EventMeetingEdit'),
	(1,'EventMeetingInquire'),
	(1,'EventRoomTypeEdit'),
	(1,'EventRoomTypes'),
	(1,'EventStatusEdit'),
	(1,'EventStatuses'),
	(1,'Events'),
	(1,'ExactTimes'),
	(1,'ExamTypeEdit'),
	(1,'ExamTypes'),
	(1,'ExaminationAdd'),
	(1,'ExaminationAssignment'),
	(1,'ExaminationAssignmentChanges'),
	(1,'ExaminationClone'),
	(1,'ExaminationConflictStatistics'),
	(1,'ExaminationDelete'),
	(1,'ExaminationDetail'),
	(1,'ExaminationDistributionPreferenceAdd'),
	(1,'ExaminationDistributionPreferenceDelete'),
	(1,'ExaminationDistributionPreferenceDetail'),
	(1,'ExaminationDistributionPreferenceEdit'),
	(1,'ExaminationDistributionPreferences'),
	(1,'ExaminationEdit'),
	(1,'ExaminationEditClearPreferences'),
	(1,'ExaminationPdfReports'),
	(1,'ExaminationPeriods'),
	(1,'ExaminationReports'),
	(1,'ExaminationSchedule'),
	(1,'ExaminationSolver'),
	(1,'ExaminationSolverLog'),
	(1,'ExaminationTimetable'),
	(1,'ExaminationTimetabling'),
	(1,'Examinations'),
	(1,'ExtendedDatePatterns'),
	(1,'ExtendedTimePatterns'),
	(1,'GlobalRoomFeatureAdd'),
	(1,'GlobalRoomFeatureDelete'),
	(1,'GlobalRoomFeatureEdit'),
	(1,'GlobalRoomGroupAdd'),
	(1,'GlobalRoomGroupDelete'),
	(1,'GlobalRoomGroupEdit'),
	(1,'GlobalRoomGroupEditSetDefault'),
	(1,'HQLReportAdd'),
	(1,'HQLReportDelete'),
	(1,'HQLReportEdit'),
	(1,'HQLReports'),
	(1,'HQLReportsAdminOnly'),
	(1,'HQLReportsAdministration'),
	(1,'HQLReportsCourses'),
	(1,'HQLReportsEvents'),
	(1,'HQLReportsExaminations'),
	(1,'HQLReportsStudents'),
	(1,'HasRole'),
	(1,'HibernateStatistics'),
	(1,'Inquiry'),
	(1,'InstrOfferingConfigAdd'),
	(1,'InstrOfferingConfigDelete'),
	(1,'InstrOfferingConfigEdit'),
	(1,'InstrOfferingConfigEditDepartment'),
	(1,'InstrOfferingConfigEditSubpart'),
	(1,'InstructionalOfferingCrossLists'),
	(1,'InstructionalOfferingDetail'),
	(1,'InstructionalOfferings'),
	(1,'InstructionalOfferingsExportPDF'),
	(1,'InstructionalOfferingsWorksheetPDF'),
	(1,'InstructionalTypeAdd'),
	(1,'InstructionalTypeDelete'),
	(1,'InstructionalTypeEdit'),
	(1,'InstructionalTypes'),
	(1,'InstructorAdd'),
	(1,'InstructorDelete'),
	(1,'InstructorDetail'),
	(1,'InstructorEdit'),
	(1,'InstructorEditClearPreferences'),
	(1,'InstructorPreferences'),
	(1,'InstructorRoleEdit'),
	(1,'InstructorRoles'),
	(1,'Instructors'),
	(1,'InstructorsExportPdf'),
	(1,'IsAdmin'),
	(1,'LastChanges'),
	(1,'MajorEdit'),
	(1,'Majors'),
	(1,'ManageInstructors'),
	(1,'ManageSolvers'),
	(1,'MinorEdit'),
	(1,'Minors'),
	(1,'MultipleClassSetup'),
	(1,'MultipleClassSetupClass'),
	(1,'MultipleClassSetupDepartment'),
	(1,'NonUniversityLocationDelete'),
	(1,'NonUniversityLocationEdit'),
	(1,'NotAssignedClasses'),
	(1,'NotAssignedExaminations'),
	(1,'OfferingCanLock'),
	(1,'OfferingCanUnlock'),
	(1,'OfferingConsentTypeEdit'),
	(1,'OfferingConsentTypes'),
	(1,'OfferingDelete'),
	(1,'OfferingEnrollments'),
	(1,'OfferingMakeNotOffered'),
	(1,'OfferingMakeOffered'),
	(1,'PageStatistics'),
	(1,'PermissionEdit'),
	(1,'Permissions'),
	(1,'PersonalSchedule'),
	(1,'PersonalScheduleLookup'),
	(1,'PositionTypeEdit'),
	(1,'PositionTypes'),
	(1,'Registration'),
	(1,'ReservationAdd'),
	(1,'ReservationDelete'),
	(1,'ReservationEdit'),
	(1,'ReservationOffering'),
	(1,'Reservations'),
	(1,'RoleEdit'),
	(1,'Roles'),
	(1,'RoomAvailability'),
	(1,'RoomDelete'),
	(1,'RoomDepartments'),
	(1,'RoomDetail'),
	(1,'RoomDetailAvailability'),
	(1,'RoomDetailEventAvailability'),
	(1,'RoomDetailPeriodPreferences'),
	(1,'RoomEdit'),
	(1,'RoomEditAvailability'),
	(1,'RoomEditChangeCapacity'),
	(1,'RoomEditChangeControll'),
	(1,'RoomEditChangeEventProperties'),
	(1,'RoomEditChangeExaminationStatus'),
	(1,'RoomEditChangeExternalId'),
	(1,'RoomEditChangeRoomProperties'),
	(1,'RoomEditChangeType'),
	(1,'RoomEditEventAvailability'),
	(1,'RoomEditFeatures'),
	(1,'RoomEditGlobalFeatures'),
	(1,'RoomEditGlobalGroups'),
	(1,'RoomEditGroups'),
	(1,'RoomEditPreference'),
	(1,'RoomFeatureTypeEdit'),
	(1,'RoomFeatureTypes'),
	(1,'RoomFeatures'),
	(1,'RoomFeaturesExportPdf'),
	(1,'RoomGroups'),
	(1,'RoomGroupsExportPdf'),
	(1,'RoomTypes'),
	(1,'Rooms'),
	(1,'RoomsExportCsv'),
	(1,'RoomsExportPdf'),
	(1,'SchedulingAssistant'),
	(1,'SchedulingDashboard'),
	(1,'SchedulingSubpartDetail'),
	(1,'SchedulingSubpartDetailClearClassPreferences'),
	(1,'SchedulingSubpartEdit'),
	(1,'SchedulingSubpartEditClearPreferences'),
	(1,'ScriptEdit'),
	(1,'Scripts'),
	(1,'SessionDefaultCurrent'),
	(1,'SessionIndependent'),
	(1,'SessionRollForward'),
	(1,'SettingsAdmin'),
	(1,'SettingsUser'),
	(1,'SolutionChanges'),
	(1,'SolutionReports'),
	(1,'Solver'),
	(1,'SolverConfigurations'),
	(1,'SolverGroups'),
	(1,'SolverLog'),
	(1,'SolverParameterGroups'),
	(1,'SolverParameters'),
	(1,'SolverSolutionExportCsv'),
	(1,'SolverSolutionExportXml'),
	(1,'SolverSolutionSave'),
	(1,'SponsoringOrganizationAdd'),
	(1,'SponsoringOrganizationDelete'),
	(1,'SponsoringOrganizationEdit'),
	(1,'SponsoringOrganizations'),
	(1,'StandardEventNotes'),
	(1,'StandardEventNotesDepartmentEdit'),
	(1,'StandardEventNotesGlobalEdit'),
	(1,'StandardEventNotesSessionEdit'),
	(1,'StatusIndependent'),
	(1,'StatusTypes'),
	(1,'StudentEnrollments'),
	(1,'StudentGroupEdit'),
	(1,'StudentGroups'),
	(1,'StudentScheduling'),
	(1,'StudentSchedulingAdmin'),
	(1,'StudentSchedulingAdvisor'),
	(1,'StudentSchedulingStatusTypeEdit'),
	(1,'StudentSchedulingStatusTypes'),
	(1,'StudentSectioningSolver'),
	(1,'StudentSectioningSolverDashboard'),
	(1,'StudentSectioningSolverLog'),
	(1,'SubjectAreaAdd'),
	(1,'SubjectAreaChangeDepartment'),
	(1,'SubjectAreaDelete'),
	(1,'SubjectAreaEdit'),
	(1,'SubjectAreas'),
	(1,'Suggestions'),
	(1,'TestHQL'),
	(1,'TimePatterns'),
	(1,'TimetableGrid'),
	(1,'TimetableManagerAdd'),
	(1,'TimetableManagerDelete'),
	(1,'TimetableManagerEdit'),
	(1,'TimetableManagers'),
	(1,'Timetables'),
	(1,'TimetablesSolutionChangeNote'),
	(1,'TimetablesSolutionCommit'),
	(1,'TimetablesSolutionDelete'),
	(1,'TimetablesSolutionExportCsv'),
	(1,'TimetablesSolutionLoad'),
	(1,'TimetablesSolutionLoadEmpty'),
	(1,'TravelTimesLoad'),
	(1,'TravelTimesSave'),
	(1,'Users'),
	(21,'AddCourseOffering'),
	(21,'AddNonUnivLocation'),
	(21,'AddSpecialUseRoom'),
	(21,'AddSpecialUseRoomExternalRoom'),
	(21,'AssignInstructors'),
	(21,'AssignInstructorsClass'),
	(21,'AssignedClasses'),
	(21,'AssignmentHistory'),
	(21,'CanUseHardDistributionPrefs'),
	(21,'CanUseHardPeriodPrefs'),
	(21,'CanUseHardRoomPrefs'),
	(21,'CanUseHardTimePrefs'),
	(21,'ChangePassword'),
	(21,'ClassAssignments'),
	(21,'ClassAssignmentsExportCsv'),
	(21,'ClassAssignmentsExportPdf'),
	(21,'ClassDetail'),
	(21,'ClassEdit'),
	(21,'ClassEditClearPreferences'),
	(21,'Classes'),
	(21,'ClassesExportPDF'),
	(21,'ConflictStatistics'),
	(21,'ConsentApproval'),
	(21,'CourseTimetabling'),
	(21,'CourseTimetablingAudit'),
	(21,'CurriculumAdd'),
	(21,'CurriculumDelete'),
	(21,'CurriculumDetail'),
	(21,'CurriculumEdit'),
	(21,'CurriculumProjectionRulesDetail'),
	(21,'CurriculumView'),
	(21,'DepartmenalRoomFeatureDelete'),
	(21,'DepartmenalRoomFeatureEdit'),
	(21,'DepartmenalRoomGroupDelete'),
	(21,'DepartmenalRoomGroupEdit'),
	(21,'DepartmentRoomFeatureAdd'),
	(21,'DepartmentRoomGroupAdd'),
	(21,'DistributionPreferenceAdd'),
	(21,'DistributionPreferenceClass'),
	(21,'DistributionPreferenceDelete'),
	(21,'DistributionPreferenceDetail'),
	(21,'DistributionPreferenceEdit'),
	(21,'DistributionPreferenceExam'),
	(21,'DistributionPreferenceSubpart'),
	(21,'DistributionPreferences'),
	(21,'EditCourseOffering'),
	(21,'EditCourseOfferingCoordinators'),
	(21,'EditRoomDepartments'),
	(21,'EventAddCourseRelated'),
	(21,'EventAddSpecial'),
	(21,'EventDate'),
	(21,'EventDetail'),
	(21,'EventEdit'),
	(21,'EventLocation'),
	(21,'EventLookupSchedule'),
	(21,'EventMeetingCancel'),
	(21,'EventMeetingDelete'),
	(21,'EventMeetingEdit'),
	(21,'Events'),
	(21,'ExaminationAdd'),
	(21,'ExaminationClone'),
	(21,'ExaminationDelete'),
	(21,'ExaminationDetail'),
	(21,'ExaminationDistributionPreferenceAdd'),
	(21,'ExaminationDistributionPreferenceDelete'),
	(21,'ExaminationDistributionPreferenceDetail'),
	(21,'ExaminationDistributionPreferenceEdit'),
	(21,'ExaminationDistributionPreferences'),
	(21,'ExaminationEdit'),
	(21,'ExaminationEditClearPreferences'),
	(21,'ExaminationPdfReports'),
	(21,'ExaminationSchedule'),
	(21,'Examinations'),
	(21,'HQLReports'),
	(21,'HQLReportsCourses'),
	(21,'HasRole'),
	(21,'Inquiry'),
	(21,'InstrOfferingConfigAdd'),
	(21,'InstrOfferingConfigDelete'),
	(21,'InstrOfferingConfigEdit'),
	(21,'InstrOfferingConfigEditDepartment'),
	(21,'InstrOfferingConfigEditSubpart'),
	(21,'InstructionalOfferingCrossLists'),
	(21,'InstructionalOfferingDetail'),
	(21,'InstructionalOfferings'),
	(21,'InstructionalOfferingsExportPDF'),
	(21,'InstructionalOfferingsWorksheetPDF'),
	(21,'InstructorAdd'),
	(21,'InstructorDelete'),
	(21,'InstructorDetail'),
	(21,'InstructorEdit'),
	(21,'InstructorEditClearPreferences'),
	(21,'InstructorPreferences'),
	(21,'Instructors'),
	(21,'InstructorsExportPdf'),
	(21,'ManageInstructors'),
	(21,'MultipleClassSetup'),
	(21,'MultipleClassSetupClass'),
	(21,'MultipleClassSetupDepartment'),
	(21,'NonUniversityLocationDelete'),
	(21,'NonUniversityLocationEdit'),
	(21,'NotAssignedClasses'),
	(21,'OfferingCanLock'),
	(21,'OfferingCanUnlock'),
	(21,'OfferingEnrollments'),
	(21,'OfferingMakeNotOffered'),
	(21,'OfferingMakeOffered'),
	(21,'PersonalSchedule'),
	(21,'PersonalScheduleLookup'),
	(21,'ReservationAdd'),
	(21,'ReservationDelete'),
	(21,'ReservationEdit'),
	(21,'ReservationOffering'),
	(21,'Reservations'),
	(21,'RoomAvailability'),
	(21,'RoomDepartments'),
	(21,'RoomDetail'),
	(21,'RoomDetailAvailability'),
	(21,'RoomEditAvailability'),
	(21,'RoomEditChangeCapacity'),
	(21,'RoomEditChangeExternalId'),
	(21,'RoomEditChangeRoomProperties'),
	(21,'RoomEditChangeType'),
	(21,'RoomEditFeatures'),
	(21,'RoomEditGroups'),
	(21,'RoomEditPreference'),
	(21,'RoomFeatures'),
	(21,'RoomFeaturesExportPdf'),
	(21,'RoomGroups'),
	(21,'RoomGroupsExportPdf'),
	(21,'Rooms'),
	(21,'RoomsExportCsv'),
	(21,'RoomsExportPdf'),
	(21,'SchedulingAssistant'),
	(21,'SchedulingDashboard'),
	(21,'SchedulingSubpartDetail'),
	(21,'SchedulingSubpartDetailClearClassPreferences'),
	(21,'SchedulingSubpartEdit'),
	(21,'SchedulingSubpartEditClearPreferences'),
	(21,'SessionDefaultFirstFuture'),
	(21,'SettingsUser'),
	(21,'SolutionChanges'),
	(21,'SolutionReports'),
	(21,'Solver'),
	(21,'SolverLog'),
	(21,'SolverSolutionExportCsv'),
	(21,'SolverSolutionSave'),
	(21,'StudentEnrollments'),
	(21,'Suggestions'),
	(21,'TimetableGrid'),
	(21,'Timetables'),
	(21,'TimetablesSolutionChangeNote'),
	(21,'TimetablesSolutionCommit'),
	(21,'TimetablesSolutionDelete'),
	(21,'TimetablesSolutionExportCsv'),
	(21,'TimetablesSolutionLoad'),
	(21,'TimetablesSolutionLoadEmpty'),
	(41,'CanUseHardDistributionPrefs'),
	(41,'CanUseHardPeriodPrefs'),
	(41,'CanUseHardRoomPrefs'),
	(41,'CanUseHardTimePrefs'),
	(41,'ChangePassword'),
	(41,'ClassAssignments'),
	(41,'ClassAssignmentsExportCsv'),
	(41,'ClassAssignmentsExportPdf'),
	(41,'ClassDetail'),
	(41,'Classes'),
	(41,'ClassesExportPDF'),
	(41,'CurriculumDetail'),
	(41,'CurriculumProjectionRulesDetail'),
	(41,'CurriculumView'),
	(41,'DepartmentIndependent'),
	(41,'DistributionPreferenceDetail'),
	(41,'DistributionPreferences'),
	(41,'EventAddSpecial'),
	(41,'EventDate'),
	(41,'EventDetail'),
	(41,'EventEdit'),
	(41,'EventLocation'),
	(41,'EventMeetingCancel'),
	(41,'EventMeetingDelete'),
	(41,'EventMeetingEdit'),
	(41,'Events'),
	(41,'ExaminationDetail'),
	(41,'ExaminationDistributionPreferenceDetail'),
	(41,'ExaminationDistributionPreferences'),
	(41,'ExaminationPdfReports'),
	(41,'ExaminationSchedule'),
	(41,'Examinations'),
	(41,'HasRole'),
	(41,'Inquiry'),
	(41,'InstructionalOfferingDetail'),
	(41,'InstructionalOfferings'),
	(41,'InstructionalOfferingsExportPDF'),
	(41,'InstructionalOfferingsWorksheetPDF'),
	(41,'InstructorDetail'),
	(41,'Instructors'),
	(41,'InstructorsExportPdf'),
	(41,'OfferingEnrollments'),
	(41,'RoomAvailability'),
	(41,'RoomDetail'),
	(41,'RoomDetailAvailability'),
	(41,'RoomDetailPeriodPreferences'),
	(41,'RoomFeatures'),
	(41,'RoomFeaturesExportPdf'),
	(41,'RoomGroups'),
	(41,'RoomGroupsExportPdf'),
	(41,'Rooms'),
	(41,'RoomsExportCsv'),
	(41,'RoomsExportPdf'),
	(41,'SchedulingAssistant'),
	(41,'SchedulingDashboard'),
	(41,'SchedulingSubpartDetail'),
	(41,'SessionDefaultCurrent'),
	(41,'SessionIndependentIfNoSessionGiven'),
	(41,'SettingsUser'),
	(41,'StudentEnrollments'),
	(61,'AssignedExaminations'),
	(61,'CanUseHardDistributionPrefs'),
	(61,'CanUseHardPeriodPrefs'),
	(61,'CanUseHardRoomPrefs'),
	(61,'CanUseHardTimePrefs'),
	(61,'ChangePassword'),
	(61,'ClassAssignments'),
	(61,'ClassAssignmentsExportCsv'),
	(61,'ClassAssignmentsExportPdf'),
	(61,'DepartmentIndependent'),
	(61,'DistributionPreferenceExam'),
	(61,'EditRoomDepartmentsExams'),
	(61,'EditRoomDepartmentsFinalExams'),
	(61,'EditRoomDepartmentsMidtermExams'),
	(61,'EventAddSpecial'),
	(61,'EventDate'),
	(61,'EventDetail'),
	(61,'EventEdit'),
	(61,'EventLocation'),
	(61,'EventMeetingCancel'),
	(61,'EventMeetingDelete'),
	(61,'EventMeetingEdit'),
	(61,'Events'),
	(61,'ExaminationAdd'),
	(61,'ExaminationAssignment'),
	(61,'ExaminationAssignmentChanges'),
	(61,'ExaminationClone'),
	(61,'ExaminationConflictStatistics'),
	(61,'ExaminationDelete'),
	(61,'ExaminationDetail'),
	(61,'ExaminationDistributionPreferenceAdd'),
	(61,'ExaminationDistributionPreferenceDelete'),
	(61,'ExaminationDistributionPreferenceDetail'),
	(61,'ExaminationDistributionPreferenceEdit'),
	(61,'ExaminationDistributionPreferences'),
	(61,'ExaminationEdit'),
	(61,'ExaminationEditClearPreferences'),
	(61,'ExaminationPdfReports'),
	(61,'ExaminationReports'),
	(61,'ExaminationSchedule'),
	(61,'ExaminationSolver'),
	(61,'ExaminationSolverLog'),
	(61,'ExaminationTimetable'),
	(61,'ExaminationTimetabling'),
	(61,'Examinations'),
	(61,'HQLReports'),
	(61,'HQLReportsExaminations'),
	(61,'HasRole'),
	(61,'Inquiry'),
	(61,'InstructorDetail'),
	(61,'Instructors'),
	(61,'InstructorsExportPdf'),
	(61,'NotAssignedExaminations'),
	(61,'RoomDetail'),
	(61,'RoomDetailPeriodPreferences'),
	(61,'RoomEdit'),
	(61,'RoomEditChangeExaminationStatus'),
	(61,'RoomFeatures'),
	(61,'RoomFeaturesExportPdf'),
	(61,'RoomGroups'),
	(61,'RoomGroupsExportPdf'),
	(61,'Rooms'),
	(61,'RoomsExportCsv'),
	(61,'RoomsExportPdf'),
	(61,'SessionDefaultFirstExamination'),
	(61,'SettingsUser'),
	(81,'AddNonUnivLocation'),
	(81,'AddSpecialUseRoom'),
	(81,'AddSpecialUseRoomExternalRoom'),
	(81,'CanUseHardDistributionPrefs'),
	(81,'CanUseHardPeriodPrefs'),
	(81,'CanUseHardRoomPrefs'),
	(81,'CanUseHardTimePrefs'),
	(81,'ChangePassword'),
	(81,'EventAddCourseRelated'),
	(81,'EventAddSpecial'),
	(81,'EventAddUnavailable'),
	(81,'EventDate'),
	(81,'EventDetail'),
	(81,'EventEdit'),
	(81,'EventLocation'),
	(81,'EventLocationApprove'),
	(81,'EventLocationOverbook'),
	(81,'EventLocationUnavailable'),
	(81,'EventLookupContact'),
	(81,'EventMeetingApprove'),
	(81,'EventMeetingCancel'),
	(81,'EventMeetingDelete'),
	(81,'EventMeetingEdit'),
	(81,'EventMeetingInquire'),
	(81,'EventRoomTypeEdit'),
	(81,'EventRoomTypes'),
	(81,'EventStatusEdit'),
	(81,'EventStatuses'),
	(81,'Events'),
	(81,'ExaminationSchedule'),
	(81,'HQLReports'),
	(81,'HQLReportsEvents'),
	(81,'HasRole'),
	(81,'Inquiry'),
	(81,'InstructorRoleEdit'),
	(81,'InstructorRoles'),
	(81,'NonUniversityLocationDelete'),
	(81,'NonUniversityLocationEdit'),
	(81,'RoomDetail'),
	(81,'RoomDetailEventAvailability'),
	(81,'RoomEditChangeCapacity'),
	(81,'RoomEditChangeEventProperties'),
	(81,'RoomEditChangeExternalId'),
	(81,'RoomEditChangeRoomProperties'),
	(81,'RoomEditChangeType'),
	(81,'RoomEditEventAvailability'),
	(81,'RoomFeatures'),
	(81,'RoomFeaturesExportPdf'),
	(81,'RoomGroups'),
	(81,'RoomGroupsExportPdf'),
	(81,'Rooms'),
	(81,'RoomsExportCsv'),
	(81,'RoomsExportPdf'),
	(81,'SessionDefaultCurrent'),
	(81,'SettingsUser'),
	(81,'StandardEventNotes'),
	(81,'StandardEventNotesDepartmentEdit'),
	(101,'CanUseHardDistributionPrefs'),
	(101,'CanUseHardPeriodPrefs'),
	(101,'CanUseHardRoomPrefs'),
	(101,'CanUseHardTimePrefs'),
	(101,'ChangePassword'),
	(101,'CurriculumAdd'),
	(101,'CurriculumAdmin'),
	(101,'CurriculumDelete'),
	(101,'CurriculumDetail'),
	(101,'CurriculumEdit'),
	(101,'CurriculumMerge'),
	(101,'CurriculumProjectionRulesDetail'),
	(101,'CurriculumProjectionRulesEdit'),
	(101,'CurriculumView'),
	(101,'DepartmentIndependent'),
	(101,'EventAddSpecial'),
	(101,'EventDate'),
	(101,'EventDetail'),
	(101,'EventEdit'),
	(101,'EventLocation'),
	(101,'EventMeetingCancel'),
	(101,'EventMeetingDelete'),
	(101,'EventMeetingEdit'),
	(101,'Events'),
	(101,'ExaminationSchedule'),
	(101,'HasRole'),
	(101,'Inquiry'),
	(101,'RoomAvailability'),
	(101,'SessionDefaultCurrent'),
	(101,'SettingsUser'),
	(1310680,'CanUseHardDistributionPrefs'),
	(1310680,'CanUseHardPeriodPrefs'),
	(1310680,'CanUseHardRoomPrefs'),
	(1310680,'CanUseHardTimePrefs'),
	(1310680,'ChangePassword'),
	(1310680,'CourseRequests'),
	(1310680,'DepartmentIndependent'),
	(1310680,'EventAddSpecial'),
	(1310680,'EventDate'),
	(1310680,'EventDetail'),
	(1310680,'EventEdit'),
	(1310680,'EventLocation'),
	(1310680,'EventLookupSchedule'),
	(1310680,'EventMeetingCancel'),
	(1310680,'EventMeetingDelete'),
	(1310680,'EventMeetingEdit'),
	(1310680,'Events'),
	(1310680,'ExaminationSchedule'),
	(1310680,'HasRole'),
	(1310680,'Inquiry'),
	(1310680,'OfferingEnrollments'),
	(1310680,'PersonalSchedule'),
	(1310680,'PersonalScheduleLookup'),
	(1310680,'SchedulingAssistant'),
	(1310680,'SchedulingDashboard'),
	(1310680,'SessionDefaultCurrent'),
	(1310680,'SettingsUser'),
	(1310680,'StudentEnrollments'),
	(1310680,'StudentSchedulingAdvisor'),
	(1408981,'ChangePassword'),
	(1408981,'EventAddSpecial'),
	(1408981,'EventDate'),
	(1408981,'EventDetail'),
	(1408981,'EventEdit'),
	(1408981,'EventLocation'),
	(1408981,'EventMeetingCancel'),
	(1408981,'EventMeetingDelete'),
	(1408981,'EventMeetingEdit'),
	(1408981,'Events'),
	(1408981,'Inquiry'),
	(1408981,'SchedulingAssistant'),
	(1408982,'ChangePassword'),
	(1408982,'CourseRequests'),
	(1408982,'EventAddSpecial'),
	(1408982,'EventDate'),
	(1408982,'EventDetail'),
	(1408982,'EventEdit'),
	(1408982,'EventLocation'),
	(1408982,'EventMeetingCancel'),
	(1408982,'EventMeetingDelete'),
	(1408982,'EventMeetingEdit'),
	(1408982,'Events'),
	(1408982,'Inquiry'),
	(1408982,'PersonalSchedule'),
	(1408982,'SchedulingAssistant'),
	(1408982,'SessionDefaultCurrent'),
	(1408982,'StudentEnrollments'),
	(1408983,'ChangePassword'),
	(1408983,'ConsentApproval'),
	(1408983,'EventAddSpecial'),
	(1408983,'EventDate'),
	(1408983,'EventDetail'),
	(1408983,'EventEdit'),
	(1408983,'EventLocation'),
	(1408983,'EventMeetingCancel'),
	(1408983,'EventMeetingDelete'),
	(1408983,'EventMeetingEdit'),
	(1408983,'Events'),
	(1408983,'Inquiry'),
	(1408983,'OfferingEnrollments'),
	(1408983,'PersonalSchedule'),
	(1408983,'SchedulingAssistant'),
	(1408983,'SchedulingDashboard'),
	(1408983,'SessionDefaultCurrent'),
	(1441748,'AcademicAreaEdit'),
	(1441748,'AcademicAreas'),
	(1441748,'AcademicClassificationEdit'),
	(1441748,'AcademicClassifications'),
	(1441748,'AcademicSessionEdit'),
	(1441748,'AcademicSessions'),
	(1441748,'AddCourseOffering'),
	(1441748,'AddNonUnivLocation'),
	(1441748,'AddRoom'),
	(1441748,'AddSpecialUseRoom'),
	(1441748,'AddSpecialUseRoomExternalRoom'),
	(1441748,'AssignInstructors'),
	(1441748,'AssignInstructorsClass'),
	(1441748,'AssignedClasses'),
	(1441748,'AssignedExaminations'),
	(1441748,'AssignmentHistory'),
	(1441748,'BuildingAdd'),
	(1441748,'BuildingDelete'),
	(1441748,'BuildingEdit'),
	(1441748,'BuildingExportPdf'),
	(1441748,'BuildingList'),
	(1441748,'BuildingUpdateData'),
	(1441748,'CanSelectSolverServer'),
	(1441748,'CanUseHardDistributionPrefs'),
	(1441748,'CanUseHardPeriodPrefs'),
	(1441748,'CanUseHardRoomPrefs'),
	(1441748,'CanUseHardTimePrefs'),
	(1441748,'ChangePassword'),
	(1441748,'ClassAssignment'),
	(1441748,'ClassAssignments'),
	(1441748,'ClassAssignmentsExportCsv'),
	(1441748,'ClassAssignmentsExportPdf'),
	(1441748,'ClassDetail'),
	(1441748,'ClassEdit'),
	(1441748,'ClassEditClearPreferences'),
	(1441748,'Classes'),
	(1441748,'ClassesExportPDF'),
	(1441748,'ConflictStatistics'),
	(1441748,'ConsentApproval'),
	(1441748,'CourseCreditFormats'),
	(1441748,'CourseCreditTypes'),
	(1441748,'CourseCreditUnits'),
	(1441748,'CourseRequests'),
	(1441748,'CourseTimetabling'),
	(1441748,'CourseTimetablingAudit'),
	(1441748,'CourseTypes'),
	(1441748,'CurriculumAdd'),
	(1441748,'CurriculumAdmin'),
	(1441748,'CurriculumDelete'),
	(1441748,'CurriculumDetail'),
	(1441748,'CurriculumEdit'),
	(1441748,'CurriculumMerge'),
	(1441748,'CurriculumProjectionRulesDetail'),
	(1441748,'CurriculumProjectionRulesEdit'),
	(1441748,'CurriculumView'),
	(1441748,'DatePatterns'),
	(1441748,'DepartmenalRoomFeatureDelete'),
	(1441748,'DepartmenalRoomFeatureEdit'),
	(1441748,'DepartmenalRoomGroupDelete'),
	(1441748,'DepartmenalRoomGroupEdit'),
	(1441748,'DepartmentAdd'),
	(1441748,'DepartmentDelete'),
	(1441748,'DepartmentEdit'),
	(1441748,'DepartmentEditChangeExternalManager'),
	(1441748,'DepartmentIndependent'),
	(1441748,'DepartmentRoomFeatureAdd'),
	(1441748,'DepartmentRoomGroupAdd'),
	(1441748,'Departments'),
	(1441748,'DistributionPreferenceAdd'),
	(1441748,'DistributionPreferenceClass'),
	(1441748,'DistributionPreferenceDelete'),
	(1441748,'DistributionPreferenceDetail'),
	(1441748,'DistributionPreferenceEdit'),
	(1441748,'DistributionPreferenceExam'),
	(1441748,'DistributionPreferenceSubpart'),
	(1441748,'DistributionPreferences'),
	(1441748,'DistributionTypes'),
	(1441748,'EditCourseOffering'),
	(1441748,'EditCourseOfferingCoordinators'),
	(1441748,'EditRoomDepartments'),
	(1441748,'EditRoomDepartmentsExams'),
	(1441748,'EditRoomDepartmentsFinalExams'),
	(1441748,'EditRoomDepartmentsMidtermExams'),
	(1441748,'EnrollmentAuditPDFReports'),
	(1441748,'EventAddCourseRelated'),
	(1441748,'EventAddSpecial'),
	(1441748,'EventAddUnavailable'),
	(1441748,'EventAnyLocation'),
	(1441748,'EventApprovePast'),
	(1441748,'EventDate'),
	(1441748,'EventDetail'),
	(1441748,'EventEdit'),
	(1441748,'EventLocation'),
	(1441748,'EventLocationApprove'),
	(1441748,'EventLocationOverbook'),
	(1441748,'EventLocationUnavailable'),
	(1441748,'EventLookupContact'),
	(1441748,'EventLookupSchedule'),
	(1441748,'EventMeetingApprove'),
	(1441748,'EventMeetingCancel'),
	(1441748,'EventMeetingDelete'),
	(1441748,'EventMeetingEdit'),
	(1441748,'EventMeetingInquire'),
	(1441748,'EventRoomTypeEdit'),
	(1441748,'EventRoomTypes'),
	(1441748,'EventStatusEdit'),
	(1441748,'EventStatuses'),
	(1441748,'Events'),
	(1441748,'ExamTypes'),
	(1441748,'ExaminationAdd'),
	(1441748,'ExaminationAssignment'),
	(1441748,'ExaminationAssignmentChanges'),
	(1441748,'ExaminationClone'),
	(1441748,'ExaminationConflictStatistics'),
	(1441748,'ExaminationDelete'),
	(1441748,'ExaminationDetail'),
	(1441748,'ExaminationDistributionPreferenceAdd'),
	(1441748,'ExaminationDistributionPreferenceDelete'),
	(1441748,'ExaminationDistributionPreferenceDetail'),
	(1441748,'ExaminationDistributionPreferenceEdit'),
	(1441748,'ExaminationDistributionPreferences'),
	(1441748,'ExaminationEdit'),
	(1441748,'ExaminationEditClearPreferences'),
	(1441748,'ExaminationPdfReports'),
	(1441748,'ExaminationPeriods'),
	(1441748,'ExaminationReports'),
	(1441748,'ExaminationSchedule'),
	(1441748,'ExaminationSolver'),
	(1441748,'ExaminationSolverLog'),
	(1441748,'ExaminationTimetable'),
	(1441748,'ExaminationTimetabling'),
	(1441748,'Examinations'),
	(1441748,'ExtendedDatePatterns'),
	(1441748,'ExtendedTimePatterns'),
	(1441748,'GlobalRoomFeatureAdd'),
	(1441748,'GlobalRoomFeatureDelete'),
	(1441748,'GlobalRoomFeatureEdit'),
	(1441748,'GlobalRoomGroupAdd'),
	(1441748,'GlobalRoomGroupDelete'),
	(1441748,'GlobalRoomGroupEdit'),
	(1441748,'GlobalRoomGroupEditSetDefault'),
	(1441748,'HQLReports'),
	(1441748,'HQLReportsAdminOnly'),
	(1441748,'HQLReportsAdministration'),
	(1441748,'HQLReportsCourses'),
	(1441748,'HQLReportsEvents'),
	(1441748,'HQLReportsExaminations'),
	(1441748,'HQLReportsStudents'),
	(1441748,'HasRole'),
	(1441748,'Inquiry'),
	(1441748,'InstrOfferingConfigAdd'),
	(1441748,'InstrOfferingConfigDelete'),
	(1441748,'InstrOfferingConfigEdit'),
	(1441748,'InstrOfferingConfigEditDepartment'),
	(1441748,'InstrOfferingConfigEditSubpart'),
	(1441748,'InstructionalOfferingCrossLists'),
	(1441748,'InstructionalOfferingDetail'),
	(1441748,'InstructionalOfferings'),
	(1441748,'InstructionalOfferingsExportPDF'),
	(1441748,'InstructionalOfferingsWorksheetPDF'),
	(1441748,'InstructionalTypes'),
	(1441748,'InstructorAdd'),
	(1441748,'InstructorDelete'),
	(1441748,'InstructorDetail'),
	(1441748,'InstructorEdit'),
	(1441748,'InstructorEditClearPreferences'),
	(1441748,'InstructorPreferences'),
	(1441748,'InstructorRoleEdit'),
	(1441748,'InstructorRoles'),
	(1441748,'Instructors'),
	(1441748,'InstructorsExportPdf'),
	(1441748,'IsAdmin'),
	(1441748,'LastChanges'),
	(1441748,'MajorEdit'),
	(1441748,'Majors'),
	(1441748,'ManageInstructors'),
	(1441748,'ManageSolvers'),
	(1441748,'MinorEdit'),
	(1441748,'Minors'),
	(1441748,'MultipleClassSetup'),
	(1441748,'MultipleClassSetupClass'),
	(1441748,'MultipleClassSetupDepartment'),
	(1441748,'NonUniversityLocationDelete'),
	(1441748,'NonUniversityLocationEdit'),
	(1441748,'NotAssignedClasses'),
	(1441748,'NotAssignedExaminations'),
	(1441748,'OfferingCanLock'),
	(1441748,'OfferingCanUnlock'),
	(1441748,'OfferingConsentTypes'),
	(1441748,'OfferingDelete'),
	(1441748,'OfferingEnrollments'),
	(1441748,'OfferingMakeNotOffered'),
	(1441748,'OfferingMakeOffered'),
	(1441748,'Permissions'),
	(1441748,'PersonalSchedule'),
	(1441748,'PersonalScheduleLookup'),
	(1441748,'PositionTypes'),
	(1441748,'ReservationAdd'),
	(1441748,'ReservationDelete'),
	(1441748,'ReservationEdit'),
	(1441748,'ReservationOffering'),
	(1441748,'Reservations'),
	(1441748,'Roles'),
	(1441748,'RoomAvailability'),
	(1441748,'RoomDelete'),
	(1441748,'RoomDepartments'),
	(1441748,'RoomDetail'),
	(1441748,'RoomDetailAvailability'),
	(1441748,'RoomDetailEventAvailability'),
	(1441748,'RoomDetailPeriodPreferences'),
	(1441748,'RoomEdit'),
	(1441748,'RoomEditAvailability'),
	(1441748,'RoomEditChangeCapacity'),
	(1441748,'RoomEditChangeControll'),
	(1441748,'RoomEditChangeEventProperties'),
	(1441748,'RoomEditChangeExaminationStatus'),
	(1441748,'RoomEditChangeExternalId'),
	(1441748,'RoomEditChangeRoomProperties'),
	(1441748,'RoomEditChangeType'),
	(1441748,'RoomEditEventAvailability'),
	(1441748,'RoomEditFeatures'),
	(1441748,'RoomEditGlobalFeatures'),
	(1441748,'RoomEditGlobalGroups'),
	(1441748,'RoomEditGroups'),
	(1441748,'RoomEditPreference'),
	(1441748,'RoomFeatureTypes'),
	(1441748,'RoomFeatures'),
	(1441748,'RoomFeaturesExportPdf'),
	(1441748,'RoomGroups'),
	(1441748,'RoomGroupsExportPdf'),
	(1441748,'Rooms'),
	(1441748,'RoomsExportCsv'),
	(1441748,'RoomsExportPdf'),
	(1441748,'SchedulingAssistant'),
	(1441748,'SchedulingDashboard'),
	(1441748,'SchedulingSubpartDetail'),
	(1441748,'SchedulingSubpartDetailClearClassPreferences'),
	(1441748,'SchedulingSubpartEdit'),
	(1441748,'SchedulingSubpartEditClearPreferences'),
	(1441748,'Scripts'),
	(1441748,'SessionDefaultCurrent'),
	(1441748,'SettingsUser'),
	(1441748,'SolutionChanges'),
	(1441748,'SolutionReports'),
	(1441748,'Solver'),
	(1441748,'SolverGroups'),
	(1441748,'SolverLog'),
	(1441748,'SolverSolutionExportCsv'),
	(1441748,'SolverSolutionExportXml'),
	(1441748,'SolverSolutionSave'),
	(1441748,'SponsoringOrganizations'),
	(1441748,'StandardEventNotes'),
	(1441748,'StandardEventNotesDepartmentEdit'),
	(1441748,'StandardEventNotesSessionEdit'),
	(1441748,'StatusIndependent'),
	(1441748,'StudentEnrollments'),
	(1441748,'StudentGroupEdit'),
	(1441748,'StudentGroups'),
	(1441748,'StudentScheduling'),
	(1441748,'StudentSchedulingAdmin'),
	(1441748,'StudentSchedulingAdvisor'),
	(1441748,'StudentSchedulingStatusTypes'),
	(1441748,'StudentSectioningSolver'),
	(1441748,'StudentSectioningSolverDashboard'),
	(1441748,'StudentSectioningSolverLog'),
	(1441748,'SubjectAreaAdd'),
	(1441748,'SubjectAreaChangeDepartment'),
	(1441748,'SubjectAreaDelete'),
	(1441748,'SubjectAreaEdit'),
	(1441748,'SubjectAreas'),
	(1441748,'Suggestions'),
	(1441748,'TimePatterns'),
	(1441748,'TimetableGrid'),
	(1441748,'TimetableManagerAdd'),
	(1441748,'TimetableManagerDelete'),
	(1441748,'TimetableManagerEdit'),
	(1441748,'TimetableManagers'),
	(1441748,'Timetables'),
	(1441748,'TimetablesSolutionChangeNote'),
	(1441748,'TimetablesSolutionCommit'),
	(1441748,'TimetablesSolutionDelete'),
	(1441748,'TimetablesSolutionExportCsv'),
	(1441748,'TimetablesSolutionLoad'),
	(1441748,'TimetablesSolutionLoadEmpty'),
	(1441748,'TravelTimesLoad'),
	(1441748,'TravelTimesSave'),
	(1507282,'Events'),
	(1507282,'SchedulingAssistant');

insert into `roles` values
	(1,'Sysadmin','System Administrator',1,1,0),
	(21,'Dept Sched Mgr','Department Schedule Manager',1,1,0),
	(41,'View All','View All User',1,1,0),
	(61,'Exam Mgr','Examination Timetabling Manager',1,1,0),
	(81,'Event Mgr','Event Manager',1,1,0),
	(101,'Curriculum Mgr','Curriculum Manager',1,1,0),
	(1310680,'Advisor','Student Advisor',1,1,0),
	(1408981,'No Role','No Role',0,1,0),
	(1408982,'Student','Student',0,1,0),
	(1408983,'Instructor','Instructor',0,1,0),
	(1441748,'Administrator','Session Administrator',1,1,0),
	(1507282,'Anonymous','Anonymous',0,1,0);

insert into `room` values
	(7986,NULL,223206,1761,'101',4,1,1,0,'226199,223207','***************0000000000000000000000**************************0000000000001111000000**************************0000000000000000000000**************************0000000000001111000000**************************0000000000000000000000***********************************************************************************************************',0,NULL,NULL,2,1,425,226199,NULL,NULL,NULL,NULL,NULL,NULL),
	(7987,NULL,223206,1761,'102',2,1,1,0,'223207','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,2,2,425,223207,NULL,NULL,NULL,NULL,NULL,NULL),
	(7988,NULL,223206,1761,'103',2,1,1,0,'223207','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,2,3,425,223207,NULL,NULL,NULL,NULL,NULL,NULL),
	(7989,NULL,223206,1761,'104',1,1,1,0,'223207','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,4,425,223207,NULL,NULL,NULL,NULL,NULL,NULL),
	(7990,NULL,223206,1761,'105',1,1,1,0,'223207','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,5,425,223207,NULL,NULL,NULL,NULL,NULL,NULL),
	(7991,NULL,223206,1761,'106',1,1,1,0,'223207','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,6,426,223207,NULL,NULL,NULL,NULL,NULL,NULL),
	(7992,NULL,223206,1761,'107',1,1,1,0,'223207','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,7,427,223207,NULL,NULL,NULL,NULL,NULL,NULL),
	(7993,NULL,223206,1761,'108',1,1,1,0,'223207','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,8,427,223207,NULL,NULL,NULL,NULL,NULL,NULL),
	(7994,NULL,223206,1762,'101',4,1,1,0,'226199,223207','***************###########111110000##**************************###########111110000##**************************###########111110000##**************************###########111110000##**************************###########111110000##***********************************************************************************************************',0,NULL,NULL,8,9,428,226199,NULL,NULL,NULL,NULL,NULL,NULL),
	(8015,NULL,231379,1782,'107',1,1,1,0,'231383','************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,7,427,231383,NULL,NULL,NULL,NULL,NULL,NULL),
	(8016,NULL,231379,1782,'108',1,1,1,0,'231383','************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,8,427,231383,NULL,NULL,NULL,NULL,NULL,NULL),
	(8017,NULL,231379,1783,'101',4,1,1,0,'231382,231383','***************###########111110000##**************************###########111110000##**************************###########111110000##**************************###########111110000##**************************###########111110000##***********************************************************************************************************',0,NULL,NULL,8,9,428,231382,NULL,NULL,NULL,NULL,NULL,NULL),
	(8019,NULL,231379,1782,'103',2,1,1,0,'231383','************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,2,3,425,231383,NULL,NULL,NULL,NULL,NULL,NULL),
	(8020,NULL,231379,1782,'104',1,1,1,0,'231383','************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,4,425,231383,NULL,NULL,NULL,NULL,NULL,NULL),
	(8021,NULL,231379,1782,'105',1,1,1,0,'231383','************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,5,425,231383,NULL,NULL,NULL,NULL,NULL,NULL),
	(8022,NULL,231379,1782,'106',1,1,1,0,'231383','************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,1,6,426,231383,NULL,NULL,NULL,NULL,NULL,NULL),
	(8023,NULL,231379,1782,'101',4,1,1,0,'231382,231383','******************************************************************************************000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000************************************************************************************************************************************************************000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111000000000000000000000000000000000000************************************************************************************************************************************************************000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000************************************************************************************************************************************************************000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111000000000000000000000000000000000000************************************************************************************************************************************************************000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,2,1,425,231382,NULL,NULL,NULL,NULL,NULL,NULL),
	(8024,NULL,231379,1782,'102',2,1,1,0,'231383','************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************',0,NULL,NULL,2,2,425,231383,NULL,NULL,NULL,NULL,NULL,NULL);

insert into `room_dept` values
	(12600,7988,223207,1),
	(12601,7989,223207,1),
	(12603,7991,223207,1),
	(12606,7994,223207,0),
	(12607,7986,226199,1),
	(12608,7994,226199,1),
	(12609,7986,223207,0),
	(12628,7995,226216,1),
	(12647,8015,231383,1),
	(12648,8016,231383,1),
	(12649,8017,231382,1),
	(12650,8017,231383,0),
	(12651,8018,231384,1),
	(12652,8019,231383,1),
	(12653,8020,231383,1),
	(12654,8021,231383,1),
	(12655,8022,231383,1),
	(12656,8023,231383,0),
	(12657,8023,231382,1),
	(12658,8024,231383,1),
	(223697,7987,223207,1),
	(223700,7990,223207,1),
	(223702,7992,223207,1),
	(223703,7993,223207,1);

insert into `room_exam_type` values
	(7986,1540049),
	(7987,1540049),
	(7988,1540049),
	(7989,1540049),
	(7990,1540049),
	(7994,1540049),
	(8017,1540049),
	(8019,1540049),
	(8020,1540049),
	(8021,1540049),
	(8023,1540049),
	(8024,1540049),
	(7986,1540050),
	(7987,1540050),
	(7988,1540050),
	(7989,1540050),
	(7994,1540050),
	(8017,1540050),
	(8019,1540050),
	(8020,1540050),
	(8023,1540050),
	(8024,1540050);

insert into `room_feature` values
	(123,'global','Audio Recording','audioRecording',NULL,NULL,'AudRec',223206,NULL),
	(125,'global','Computer','puccComputer',NULL,NULL,'Comp',223206,NULL),
	(437,'global','Fixed Seating','fixedSeating',NULL,NULL,'FixSeat',223206,NULL),
	(438,'global','Computer Projection','computerProjection',NULL,NULL,'CompPr',223206,NULL),
	(440,'global','Tables and Chairs','seatingType','tablesAndChairs',NULL,'Tbls&Chrs',223206,NULL),
	(441,'global','Tablet Arm Chairs','seatingType','tabletArmChairs',NULL,'TblArmChr',223206,NULL),
	(442,'global','Theater Seats','seatingType','theaterSeats',NULL,'ThtrSeat',223206,NULL),
	(468,'global','Chalkboard < 20 Ft.','feetOfChalkboard','< 20',NULL,'Ch<20F',223206,NULL),
	(469,'global','Chalkboard >= 20 Ft.','feetOfChalkboard','>= 20',NULL,'Ch>=20F',223206,NULL),
	(1245147,'global','Audio Recording','audioRecording',NULL,NULL,'AudRec',231379,NULL),
	(1245148,'global','Computer','puccComputer',NULL,NULL,'Comp',231379,NULL),
	(1245149,'global','Fixed Seating','fixedSeating',NULL,NULL,'FixSeat',231379,NULL),
	(1245150,'global','Computer Projection','computerProjection',NULL,NULL,'CompPr',231379,NULL),
	(1245151,'global','Tables and Chairs','seatingType','tablesAndChairs',NULL,'Tbls&Chrs',231379,NULL),
	(1245152,'global','Tablet Arm Chairs','seatingType','tabletArmChairs',NULL,'TblArmChr',231379,NULL),
	(1245153,'global','Theater Seats','seatingType','theaterSeats',NULL,'ThtrSeat',231379,NULL),
	(1245154,'global','Chalkboard < 20 Ft.','feetOfChalkboard','< 20',NULL,'Ch<20F',231379,NULL),
	(1245155,'global','Chalkboard >= 20 Ft.','feetOfChalkboard','>= 20',NULL,'Ch>=20F',231379,NULL);

insert into `room_feature_pref` values
	(121508,226242,2,125,NULL),
	(121514,226240,7,442,NULL),
	(121606,230331,1,437,NULL),
	(121656,230681,1,442,NULL),
	(121679,230650,2,442,NULL),
	(121680,230650,1,438,NULL),
	(121713,230597,7,437,NULL),
	(123253,231388,2,1245148,NULL),
	(123255,231389,7,1245153,NULL),
	(123399,231692,1,1245149,NULL),
	(123405,231698,7,1245149,NULL),
	(123421,231696,2,1245153,NULL),
	(123424,231696,1,1245150,NULL),
	(123442,231720,1,1245153,NULL);

insert into `room_group` values
	(6223,223206,'Chemistry Labs','Chemistry Laboratories',1,0,NULL,'Chem Labs'),
	(6224,223206,'Classroom',NULL,1,1,NULL,'Classroom'),
	(6225,223206,'Biology Labs',NULL,0,0,223207,'Biol Labs'),
	(6226,223206,'Computing Labs',NULL,0,0,223207,'Comp Labs'),
	(6227,223206,'Hall of Music',NULL,1,0,NULL,'Hall of Music'),
	(6229,231379,'Biology Labs',NULL,0,0,231383,'Biol Labs'),
	(6230,231379,'Computing Labs',NULL,0,0,231383,'Comp Labs'),
	(1245147,231379,'Chemistry Labs','Chemistry Laboratories',1,0,NULL,'Chem Labs'),
	(1245148,231379,'Classroom',NULL,1,1,NULL,'Classroom'),
	(1245149,231379,'Hall of Music',NULL,1,0,NULL,'Hall of Music');

insert into `room_group_pref` values
	(121329,223367,1,6224,NULL),
	(121330,223790,1,6224,NULL),
	(121335,223377,1,6224,NULL),
	(121343,223372,1,6224,NULL),
	(121345,223355,1,6224,NULL),
	(121352,223815,1,6224,NULL),
	(121372,223868,1,6224,NULL),
	(121386,223901,1,6224,NULL),
	(121393,223937,1,6224,NULL),
	(121395,223939,1,6224,NULL),
	(121397,223244,1,6224,NULL),
	(121407,223848,1,6226,NULL),
	(121408,223309,1,6224,NULL),
	(121412,223997,1,6226,NULL),
	(121415,223995,1,6224,NULL),
	(121418,223323,1,6224,NULL),
	(121420,224004,1,6226,NULL),
	(121422,223329,1,6224,NULL),
	(121425,224016,1,6224,NULL),
	(121430,223343,1,6224,NULL),
	(121436,224031,1,6226,NULL),
	(121438,224030,1,6224,NULL),
	(121440,223349,1,6224,NULL),
	(121448,224058,1,6225,NULL),
	(121449,223913,1,6225,NULL),
	(121451,223948,1,6226,NULL),
	(121453,223799,1,6226,NULL),
	(121461,223296,1,6224,NULL),
	(121480,223255,1,6223,NULL),
	(121522,223228,1,6224,NULL),
	(123259,231390,1,1245148,NULL),
	(123264,231398,1,6229,NULL),
	(123266,231410,1,1245148,NULL),
	(123269,231426,1,1245148,NULL),
	(123271,231427,1,1245148,NULL),
	(123273,231428,1,6230,NULL),
	(123274,231433,1,1245148,NULL),
	(123278,231440,1,1245148,NULL),
	(123280,231453,1,1245148,NULL),
	(123282,231454,1,1245148,NULL),
	(123287,231472,1,1245148,NULL),
	(123288,231485,1,1245148,NULL),
	(123293,231497,1,1245148,NULL),
	(123295,231508,1,6230,NULL),
	(123297,231519,1,6230,NULL),
	(123298,231523,1,1245148,NULL),
	(123300,231525,1,1245148,NULL),
	(123303,231528,1,6230,NULL),
	(123305,231533,1,1245148,NULL),
	(123308,231536,1,1245148,NULL),
	(123311,231540,1,6229,NULL),
	(123314,231546,1,1245148,NULL),
	(123317,231548,1,1245148,NULL),
	(123318,231551,1,1245148,NULL),
	(123321,231557,1,6230,NULL),
	(123323,231563,1,1245148,NULL),
	(123328,231568,1,1245148,NULL),
	(123331,231571,1,1245148,NULL),
	(123334,231574,1,6230,NULL);

insert into `room_group_room` values
	(6223,7991),
	(6224,7986),
	(6224,7987),
	(6224,7988),
	(6224,7989),
	(6224,7990),
	(6225,7992),
	(6226,7993),
	(6227,7994),
	(6229,8015),
	(6230,8016),
	(1245147,8022),
	(1245148,8019),
	(1245148,8020),
	(1245148,8021),
	(1245148,8023),
	(1245148,8024),
	(1245149,8017);

insert into `room_join_room_feature` values
	(7986,125),
	(7986,437),
	(7986,438),
	(7986,469),
	(7987,125),
	(7987,437),
	(7987,468),
	(7988,125),
	(7988,437),
	(7988,438),
	(7988,468),
	(7989,125),
	(7989,440),
	(7989,468),
	(7990,125),
	(7990,438),
	(7990,440),
	(7990,468),
	(7991,125),
	(7991,440),
	(7991,468),
	(7992,125),
	(7992,440),
	(7992,468),
	(7993,125),
	(7993,441),
	(7993,468),
	(7994,123),
	(7994,442),
	(7994,468),
	(8015,1245148),
	(8015,1245151),
	(8015,1245154),
	(8016,1245148),
	(8016,1245152),
	(8016,1245154),
	(8017,1245147),
	(8017,1245153),
	(8017,1245154),
	(8019,1245148),
	(8019,1245149),
	(8019,1245150),
	(8019,1245154),
	(8020,1245148),
	(8020,1245151),
	(8020,1245154),
	(8021,1245148),
	(8021,1245150),
	(8021,1245151),
	(8021,1245154),
	(8022,1245148),
	(8022,1245151),
	(8022,1245154),
	(8023,1245148),
	(8023,1245149),
	(8023,1245150),
	(8023,1245155),
	(8024,1245148),
	(8024,1245149),
	(8024,1245154);

insert into `room_pref` values
	(121471,223207,7,7990,NULL),
	(121474,223207,4,7988,NULL),
	(121502,223207,6,7994,NULL),
	(121503,226199,7,7994,NULL),
	(121504,223207,4,7986,NULL),
	(121505,226199,4,7986,NULL),
	(121600,230335,2,7986,NULL),
	(121601,230338,2,7986,NULL),
	(121609,230584,2,7986,NULL),
	(121640,230670,2,7987,NULL),
	(121643,230678,2,7987,NULL),
	(121646,230690,2,7986,NULL),
	(121649,230701,2,7986,NULL),
	(121650,230704,2,7986,NULL),
	(121651,230707,2,7988,NULL),
	(121658,230693,2,7988,NULL),
	(121661,230697,2,7988,NULL),
	(121671,230614,2,7986,NULL),
	(121672,230620,2,7986,NULL),
	(121673,230617,2,7986,NULL),
	(121674,230623,2,7988,NULL),
	(121675,230623,2,7987,NULL),
	(121676,230634,2,7987,NULL),
	(121677,230634,2,7988,NULL),
	(121712,230342,2,7986,NULL),
	(121725,230684,2,7988,NULL),
	(121727,230687,2,7987,NULL),
	(121731,230604,2,7986,NULL),
	(121732,230611,2,7986,NULL),
	(123165,231055,1,7987,NULL),
	(123170,231058,1,7987,NULL),
	(123176,231061,1,7987,NULL),
	(123240,231383,4,8015,NULL),
	(123241,231383,4,8016,NULL),
	(123242,231382,7,8017,NULL),
	(123243,231383,6,8017,NULL),
	(123244,231384,4,8018,NULL),
	(123245,231383,4,8019,NULL),
	(123246,231383,4,8020,NULL),
	(123247,231383,7,8021,NULL),
	(123248,231383,4,8022,NULL),
	(123249,231383,4,8023,NULL),
	(123250,231382,4,8023,NULL),
	(123251,231383,4,8024,NULL),
	(123401,231713,2,8023,NULL),
	(123402,231681,2,8023,NULL),
	(123403,231676,2,8023,NULL),
	(123404,231700,2,8023,NULL),
	(123409,231733,2,8023,NULL),
	(123413,231709,2,8023,NULL),
	(123414,231727,2,8023,NULL),
	(123415,231736,2,8023,NULL),
	(123416,231688,2,8023,NULL),
	(123417,231722,2,8019,NULL),
	(123418,231722,2,8024,NULL),
	(123419,231702,2,8019,NULL),
	(123420,231702,2,8024,NULL),
	(123425,231683,2,8023,NULL),
	(123428,231685,2,8019,NULL),
	(123429,231678,2,8019,NULL),
	(123432,231711,2,8023,NULL),
	(123433,231715,2,8024,NULL),
	(123434,231731,2,8023,NULL),
	(123435,231729,2,8019,NULL),
	(123436,231690,2,8019,NULL),
	(123441,231694,2,8019,NULL),
	(123443,231718,2,8024,NULL),
	(123469,231661,1,8024,NULL),
	(123477,231674,1,8024,NULL),
	(123480,231654,1,8024,NULL);

insert into `room_type` values
	(425,'genClassroom','Classrooms',0,1),
	(426,'computingLab','Computing Laboratories',1,1),
	(427,'departmental','Additional Instructional Rooms',2,1),
	(428,'specialUse','Special Use Rooms',3,1),
	(429,'nonUniversity','Outside Locations',4,0);

insert into `room_type_option` values
	(425,1,NULL,0,223207),
	(425,1,NULL,0,226199),
	(425,1,NULL,0,231382),
	(425,1,NULL,0,231383),
	(426,1,NULL,0,223207),
	(426,1,NULL,0,231383),
	(427,1,NULL,0,223207),
	(427,1,NULL,0,231383),
	(428,1,NULL,0,226199),
	(428,1,NULL,0,231382),
	(429,1,NULL,0,226216),
	(429,1,NULL,0,231384);

insert into `saved_hql` values
	(1146845,'Not-assigned Classes','List all classes with a time pattern (i.e., classes that should not be Arrange Hours) which do not have a committed assignment.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, co.title as Title from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where c.uniqueId in ( select x.uniqueId from Class_ x, TimePref p where (p.owner = x or p.owner = x.schedulingSubpart) and p.prefLevel.prefProlog = \'R\' ) and co.subjectArea.uniqueId in %SUBJECTS% and c.committedAssignment is null order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146846,'Multi/No Room Classes','List all classes that either:<ul><li>either require more than one room</li><li>or require no room</li><li>or have zero room ratio</li></ul>','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, c.nbrRooms as Nbr_Rooms, c.roomRatio as Room_Ratio from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId in %SUBJECTS% and (c.nbrRooms != 1 or c.roomRatio = 0.0) order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146847,'Schedule Note Classes','List of all classes that has something entered in Student Schedule Note.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, c.schedulePrintNote as Student_Schedule_Note from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId in %SUBJECTS% and c.schedulePrintNote is not null order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146848,'Request Notes Classes','List of all classes that has something entered in Requests / Notes to Schedule Manager.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, c.notes as Notes_to_Schedule_Manager from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId in %SUBJECTS% and c.notes is not null order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146849,'Schedule Book Note Courses','List of all courses that has something entered in Schedule Book Note.','select co.instructionalOffering.uniqueId as __Offering, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, co.scheduleBookNote as Schedule_Book_Note from CourseOffering co where co.subjectArea.uniqueId in %SUBJECTS% and co.scheduleBookNote is not null order by co.subjectAreaAbbv, co.courseNbr',1),
	(1146850,'New Courses','List of all courses that do not have external unique id and courses that have no title.','select co.instructionalOffering.uniqueId as __Offering, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, co.title as Title from CourseOffering co where co.subjectArea.uniqueId in %SUBJECTS% and (co.externalUniqueId is null or co.title is null) order by co.subjectAreaAbbv, co.courseNbr',1),
	(1146851,'Arrange Hours Classes','List all classes that do not have a time pattern.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, co.title as Title from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where c.uniqueId not in ( select x.uniqueId from Class_ x, TimePref p where (p.owner = x or p.owner = x.schedulingSubpart) and p.prefLevel.prefProlog = \'R\' ) and co.subjectArea.uniqueId in %SUBJECTS% order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146852,'Cross-listed Courses','List all courses of a given subject area (or subject areas) that are cross-listed.','select co.instructionalOffering.uniqueId as __Offering, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, co.title as Course_Title, ctr.subjectAreaAbbv || \' \' || ctr.courseNbr as Controlling, ctr.title as Controlling_Title from CourseOffering co, CourseOffering ctr where co.subjectArea in %SUBJECTS% and co.isControl is false and co.instructionalOffering = ctr.instructionalOffering and ctr.isControl is true order by co.subjectAreaAbbv, co.courseNbr',1),
	(1146853,'No-conflict Instructors','List of instructors (and their classes) that are not checked for instructor conflicts.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, i.instructor.lastName || \', \' || i.instructor.firstName || \' \' || i.instructor.middleName as Instructor, i.instructor.externalUniqueId as External_Id from ClassInstructor i inner join i.classInstructing c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where i.lead = false and co.subjectArea.uniqueId in %SUBJECTS% order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache, i.instructor.lastName',1),
	(1146854,'Small Room Classes','List all classes that require (or prefer) a room that is too small for the class to fit in.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, p.room.building.abbreviation || \' \' || p.room.roomNumber as Room, p.room.capacity as Size, case c.roomRatio when 1.0 then (c.expectedCapacity || \'\') else (floor(c.expectedCapacity * c.roomRatio) || \' (\' || c.roomRatio || \' x \' || c.expectedCapacity || \')\') end as Needed, p.prefLevel.prefName as Preference from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co, RoomPref p where co.subjectArea.uniqueId in %SUBJECTS% and (p.owner = c or p.owner = s) and floor(c.expectedCapacity * c.roomRatio) > p.room.capacity and p.prefLevel.prefProlog in (\'R\', \'-1\', \'-2\') and c.nbrRooms > 0 order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1638350,'Message Log','Display message log','select\n  timeStamp as Time,\n  (case level when 50000 then \'<font color=\"red\">Fatal</font>\' when 40000 then \'<font color=\"red\">Error</font>\' when 30000 then \'<font color=\"orange\">Warning</font>\' when 20000 then \'Info\' when 10000 then \'Debug\' else \'Other\' end) as Level,\n  logger as Logger,\n  (case when exception is null then message when message is null then exception else (message || \'\\\\n\' || exception) end) as Message,\n  (case when ndc is null then thread else (thread || \'\\\\n\' || ndc) end) as Context\nfrom MessageLog order by timeStamp desc',16),
	(1638351,'Query Log','Display query log','select\n  m.lastName || \' \' || m.firstName as User,\n  case\n    when q.uri like \'%.gwt: %\' then substring(q.uri, instr(q.uri, \':\') + 1)\n    else q.uri end as Query,\n  case\n    when q.uri like \'%.gwt: %\' and length(q.query) <= 165 + instr(q.query, \'org.unitime.timetable.gwt.services.\')\n      then substring(q.query, instr(q.query, \'org.unitime.timetable.gwt.services.\') + 35)\n    when q.uri like \'%.gwt: %\'\n      then (substring(substring(q.query, instr(q.query, \'org.unitime.timetable.gwt.services.\') + 35), 1, 130) || \'...\')\n    when q.query is null or length(q.query) < 130 then q.query\n    else (substring(q.query, 1, 130) || \'...\') end as Parameters,\n  q.timeStamp as Time_Stamp,\n  q.timeSpent / 1000.0 as Time\nfrom QueryLog q, TimetableManager m\nwhere \n  q.uid = m.externalUniqueId and q.uri not like \'menu.gwt%\'\norder by q.timeStamp desc',16);

insert into `scheduling_subpart` values
	(223228,150,NULL,36948,10,NULL,1,'-',0,NULL,NULL),
	(223239,100,NULL,36949,10,NULL,1,'-',0,NULL,NULL),
	(223244,100,NULL,36950,10,NULL,1,'-',0,NULL,NULL),
	(223248,500,NULL,36951,10,NULL,1,'-',0,NULL,NULL),
	(223254,100,NULL,36952,10,NULL,1,'-',0,NULL,NULL),
	(223255,150,223254,36952,30,NULL,1,'-',0,NULL,NULL),
	(223290,150,NULL,36953,10,NULL,1,'-',0,NULL,NULL),
	(223296,150,NULL,36954,10,NULL,1,'-',0,NULL,NULL),
	(223309,150,NULL,36955,10,NULL,1,'-',0,NULL,NULL),
	(223323,150,NULL,36956,10,NULL,1,'-',0,NULL,NULL),
	(223329,150,NULL,36957,10,NULL,1,'-',0,NULL,NULL),
	(223343,150,NULL,36959,10,NULL,1,'-',0,NULL,NULL),
	(223349,100,NULL,36960,10,NULL,1,'-',0,NULL,NULL),
	(223355,150,NULL,36961,10,NULL,1,'-',0,NULL,NULL),
	(223362,150,NULL,36962,10,NULL,1,'-',0,NULL,NULL),
	(223367,150,NULL,36963,10,NULL,1,'-',0,NULL,NULL),
	(223372,150,NULL,36964,10,NULL,1,'-',0,NULL,NULL),
	(223377,150,NULL,36965,10,NULL,1,'-',0,NULL,NULL),
	(223790,50,223367,36963,30,NULL,1,'-',0,NULL,NULL),
	(223799,50,223377,36965,30,NULL,1,'-',0,NULL,NULL),
	(223815,50,223255,36952,20,NULL,1,'-',0,NULL,NULL),
	(223848,50,223309,36955,30,NULL,1,'-',0,NULL,NULL),
	(223867,150,NULL,36966,10,NULL,1,'-',0,NULL,NULL),
	(223868,50,223867,36966,20,NULL,1,'-',0,NULL,NULL),
	(223901,50,NULL,36949,20,NULL,1,'-',0,NULL,NULL),
	(223913,100,NULL,36949,30,NULL,1,'-',0,NULL,NULL),
	(223925,50,NULL,36949,90,NULL,1,'-',0,NULL,NULL),
	(223937,100,NULL,36967,10,NULL,1,'-',0,NULL,NULL),
	(223939,100,NULL,36967,30,NULL,1,'-',0,NULL,NULL),
	(223948,100,NULL,36950,30,NULL,1,'-',0,NULL,NULL),
	(223995,100,NULL,36968,10,NULL,1,'-',0,NULL,NULL),
	(223997,100,NULL,36968,30,NULL,1,'-',0,NULL,NULL),
	(224004,50,223323,36956,30,NULL,1,'-',0,NULL,NULL),
	(224016,150,NULL,36969,10,NULL,1,'-',0,NULL,NULL),
	(224021,50,NULL,36970,10,NULL,1,'-',0,NULL,NULL),
	(224030,50,223349,36960,20,NULL,1,'-',0,NULL,NULL),
	(224031,100,224030,36960,30,NULL,1,'-',0,NULL,NULL),
	(224056,100,NULL,36971,10,NULL,1,'-',0,NULL,NULL),
	(224058,100,NULL,36971,30,NULL,1,'-',0,NULL,NULL),
	(231390,150,NULL,36986,10,NULL,1,'-',0,NULL,223228),
	(231392,500,NULL,36987,10,NULL,1,'-',0,NULL,223248),
	(231394,100,NULL,36988,10,NULL,1,'-',0,NULL,223239),
	(231398,100,NULL,36988,30,NULL,1,'-',0,NULL,223913),
	(231410,50,NULL,36988,20,NULL,1,'-',0,NULL,223901),
	(231422,50,NULL,36988,90,NULL,1,'-',0,NULL,223925),
	(231426,100,NULL,36989,10,NULL,1,NULL,0,NULL,223937),
	(231427,100,NULL,36989,30,NULL,1,NULL,0,NULL,223939),
	(231428,100,NULL,36990,30,NULL,1,'-',0,NULL,223948),
	(231433,100,NULL,36990,10,NULL,1,'-',0,NULL,223244),
	(231436,150,NULL,36991,10,NULL,1,'-',0,NULL,223867),
	(231440,50,231436,36991,20,NULL,1,'-',0,NULL,223868),
	(231453,150,NULL,36992,10,NULL,1,NULL,0,NULL,223367),
	(231454,50,231453,36992,30,NULL,1,NULL,0,NULL,223790),
	(231455,100,NULL,36993,10,NULL,1,'-',0,NULL,223254),
	(231459,150,231455,36993,30,NULL,1,'-',0,NULL,223255),
	(231472,50,231459,36993,20,NULL,1,'-',0,NULL,223815),
	(231485,150,NULL,36994,10,NULL,1,'-',0,NULL,223296),
	(231495,150,NULL,36995,10,NULL,1,'-',0,NULL,223290),
	(231497,150,NULL,36996,10,NULL,1,'-',0,NULL,223309),
	(231508,50,231497,36996,30,NULL,1,'-',0,NULL,223848),
	(231519,100,NULL,36997,30,NULL,1,'-',0,NULL,223997),
	(231523,100,NULL,36997,10,NULL,1,'-',0,NULL,223995),
	(231525,150,NULL,36998,10,NULL,1,'-',0,NULL,223323),
	(231528,50,231525,36998,30,NULL,1,'-',0,NULL,224004),
	(231533,150,NULL,36999,10,NULL,1,'-',0,NULL,223329),
	(231536,150,NULL,37000,10,NULL,1,'-',0,NULL,224016),
	(231538,100,NULL,37001,10,NULL,1,'-',0,NULL,224056),
	(231540,100,NULL,37001,30,NULL,1,'-',0,NULL,224058),
	(231544,50,NULL,37002,10,NULL,1,'-',0,NULL,224021),
	(231546,150,NULL,37003,10,NULL,1,'-',0,NULL,223343),
	(231548,100,NULL,37004,10,NULL,1,'-',0,NULL,223349),
	(231551,50,231548,37004,20,NULL,1,'-',0,NULL,224030),
	(231557,100,231551,37004,30,NULL,1,'-',0,NULL,224031),
	(231563,150,NULL,37005,10,NULL,1,'-',0,NULL,223355),
	(231566,150,NULL,37006,10,NULL,1,'-',0,NULL,223362),
	(231568,150,NULL,37007,10,NULL,1,'-',0,NULL,223372),
	(231571,150,NULL,37008,10,NULL,1,'-',0,NULL,223377),
	(231574,50,231571,37008,30,NULL,1,'-',0,NULL,223799);

insert into `script` values
	(1736704,'Example script','This scripts shows a few perks that are available.','ECMAScript','Script Edit','// Logging\nif (name != null) {\n  log.info(greeting + \' \' + name + \'!\');\n} else {\n  log.info(greeting + \'!\');\n  log.warn(\'No name was given.\');\n}\n\n// Reading an input (text) file\nif (file != null) {\n  var lines = file.getString(\'utf-8\').split(\'\\n\');\n  for (var i = 0; i < lines.length; i++) {\n    log.debug((1 + i) + \': \' + lines[i]);\n  }\n} else {\n  log.error(\'No file to read.\', null);\n}\n\n// Writing an output file\nimportPackage(java.io);\nvar file = log.createOutput(\'test\', \'txt\');\nvar out = new PrintWriter(new FileWriter(file));\nout.println(\'This is a test.\');\nout.println(\'Žlutoucký kun úpel dábelské ódy.\');\nout.flush(); out.close();\n\n// Special parameters\nlog.info(\'Current academic session: \' + session.getLabel());\nif (dept != null) {\n  log.info(\'Selected department: \' + dept.getDeptCode() + \' - \' + dept.getLabel());\n}\nif (subjects != null) {\n  log.info(\'Selected subject areas:\');\n  for (var i = 0; i < subjects.size(); i++) {\n    var subject = subjects.get(i);\n    log.info(\'&nbsp;&nbsp;&nbsp;\' + subject.getSubjectAreaAbbreviation() + \' - \' + subject.getTitle());\n  }\n}\nif (type != null) {\n  var t = hibSession.createQuery(\'from RoomType where reference = :reference\').setString(\'reference\', type).uniqueResult();\n  log.info(\'Room type: \' + t.getLabel() + \' (\' + t.countRooms(session.getUniqueId()) + \' rooms in \' + session.getLabel() + \')\');\n}\n\n// Progress\nlog.setStatus(\'Counting to ten. Slowly.\', 10);\nimportClass(java.lang.Thread);\nfor (var i = 0; i < 9; i++) {\n  Thread.sleep(i * 1000);\n  log.incProgress();\n  log.debug(\'-- \' + (1 + i));\n}');

insert into `script_parameter` values
	(1736704,'dept','Department','department',NULL),
	(1736704,'file','Input file','file',NULL),
	(1736704,'greeting','Select greeting','enum(Ahoj,Hello,Hola,Bonjour,Guten Tag)','Hello'),
	(1736704,'name','Enter your name','string',NULL),
	(1736704,'subjects','Subject area(s)','subjects',NULL),
	(1736704,'type','Room type','reference(RoomType)',NULL);

insert into `sectioning_info` values
	(224879,223965,0,0),
	(224880,223966,0,0),
	(224881,223979,0,0),
	(224882,224034,0,0),
	(224883,223249,0,0),
	(224884,224035,0,0),
	(224885,224040,0,0),
	(224886,224060,0,0),
	(224887,223964,0,0),
	(224888,224006,0,0),
	(224889,223851,0,0),
	(224890,223963,0,0),
	(224891,223869,0,0),
	(224892,223951,0,0),
	(224893,223977,0,0),
	(224894,223314,0,0),
	(224895,224061,0,0),
	(224896,223826,0,0),
	(224897,224038,0,0),
	(224898,224017,0,0),
	(224899,223855,0,0),
	(224900,223922,0,0),
	(224901,223917,0,0),
	(224902,223998,0,0),
	(224903,224007,0,0),
	(224904,224005,0,0),
	(224905,223905,0,0),
	(224906,223313,0,0),
	(224907,223300,0,0),
	(224908,223859,0,0),
	(224909,223904,0,0),
	(224910,223999,0,0),
	(224911,223927,0,0),
	(224912,223956,0,0),
	(224913,223261,0,0),
	(224914,223829,0,0),
	(224915,223317,0,0),
	(224916,223268,0,0),
	(224917,224000,0,0),
	(224918,223258,0,0),
	(224919,223919,0,0),
	(224920,223801,0,0),
	(224921,223950,0,0),
	(224922,223305,0,0),
	(224923,223265,0,0),
	(224924,223825,0,0),
	(224925,223269,0,0),
	(224926,223260,0,0),
	(224927,223379,0,0),
	(224928,223828,0,0),
	(224929,223856,0,0),
	(224930,223835,0,0),
	(224931,223316,0,0),
	(224932,223962,0,0),
	(224933,223908,0,0),
	(224934,223854,0,0),
	(224935,223907,0,0),
	(224936,223852,0,0),
	(224937,223324,0,0),
	(224938,223976,0,0),
	(224939,224028,0,0),
	(224940,224059,0,0),
	(224941,223331,0,0),
	(224942,224022,0,0),
	(224943,223926,0,0),
	(224944,223800,0,0),
	(224945,223297,0,0),
	(224946,223947,0,0),
	(224947,223378,0,0),
	(224948,223350,0,0),
	(224949,223918,0,0),
	(224950,223914,0,0),
	(224951,223958,0,0),
	(224952,223858,0,0),
	(224953,223363,0,0),
	(224954,223312,0,0),
	(224955,223817,0,0),
	(224956,223957,0,0),
	(224957,223298,0,0),
	(224958,223356,0,0),
	(224959,223959,0,0),
	(224960,223830,0,0),
	(224961,223827,0,0),
	(224962,223259,0,0),
	(224963,223921,0,0),
	(224964,223832,0,0),
	(224965,223978,0,0),
	(224966,223344,0,0),
	(224967,223819,0,0),
	(224968,223831,0,0),
	(224969,224008,0,0),
	(224970,223860,0,0),
	(224971,223899,0,0),
	(224972,223291,0,0),
	(224973,223915,0,0),
	(224974,224041,0,0),
	(224975,223857,0,0),
	(224976,223906,0,0),
	(224977,223920,0,0),
	(224978,223302,0,0),
	(224979,223900,0,0),
	(224980,223824,0,0),
	(224981,223870,0,0),
	(224982,223903,0,0),
	(224983,223910,0,0),
	(224984,223853,0,0),
	(224985,223916,0,0),
	(224986,223909,0,0),
	(224987,223960,0,0),
	(224988,224033,0,0),
	(224989,223949,0,0),
	(224990,223318,0,0),
	(224991,223803,0,0),
	(224992,223996,0,0),
	(224993,223330,0,0),
	(224994,223311,0,0),
	(224995,223264,0,0),
	(224996,223325,0,0),
	(224997,223961,0,0),
	(224998,224032,0,0),
	(224999,223834,0,0),
	(225000,223245,0,0),
	(225001,223884,0,0),
	(225002,223304,0,0),
	(225003,224057,0,0),
	(225004,223319,0,0),
	(225005,223267,0,0),
	(225006,223967,0,0),
	(225007,223310,0,0),
	(225008,223299,0,0),
	(225009,223973,0,0),
	(225010,224050,0,0),
	(225011,223970,0,0),
	(225012,223373,0,0),
	(225013,223303,0,0),
	(225014,223802,0,0),
	(225015,223240,0,0),
	(225016,224042,0,0),
	(225017,223315,0,0),
	(225018,224036,0,0),
	(225019,224039,0,0),
	(225020,223902,0,0),
	(225021,223833,0,0),
	(225022,223818,0,0),
	(225023,223263,0,0),
	(225024,223351,0,0),
	(225025,223301,0,0),
	(225026,223968,0,0),
	(225027,223257,0,0),
	(225028,223256,0,0),
	(237026,231391,0,0),
	(237027,231393,2,2),
	(237028,231395,0,0),
	(237029,231396,0,0),
	(237030,231397,0,0),
	(237031,231411,0,0),
	(237032,231412,0,0),
	(237033,231413,0,0),
	(237034,231414,0,0),
	(237035,231415,0,0),
	(237036,231416,0,0),
	(237037,231417,0,0),
	(237038,231418,0,0),
	(237039,231419,0,0),
	(237040,231420,0,0),
	(237041,231421,0,0),
	(237042,231399,0,0),
	(237043,231400,0,0),
	(237044,231401,0,0),
	(237045,231402,0,0),
	(237046,231403,0,0),
	(237047,231404,0,0),
	(237048,231405,0,0),
	(237049,231406,0,0),
	(237050,231407,0,0),
	(237051,231408,0,0),
	(237052,231409,0,0),
	(237053,231423,0,0),
	(237054,231424,0,0),
	(237055,231425,0,0),
	(237056,231434,0.4,0),
	(237057,231435,0.6000000000000001,1),
	(237058,231429,0,0),
	(237059,231430,0.4,0),
	(237060,231431,0.4,0),
	(237061,231432,0.2,1),
	(237062,231437,0,0),
	(237063,231438,0,0),
	(237064,231439,0,0),
	(237065,231441,0,0),
	(237066,231442,0,0),
	(237067,231443,0,0),
	(237068,231444,0,0),
	(237069,231445,0,0),
	(237070,231446,0,0),
	(237071,231447,0,0),
	(237072,231448,0,0),
	(237073,231449,0,0),
	(237074,231450,0,0),
	(237075,231451,0,0),
	(237076,231452,0,0),
	(237077,231456,0,0),
	(237078,231457,0,0),
	(237079,231458,0,0),
	(237080,231460,0,0),
	(237081,231461,0,0),
	(237082,231462,0,0),
	(237083,231463,0,0),
	(237084,231464,0,0),
	(237085,231465,0,0),
	(237086,231466,0,0),
	(237087,231467,0,0),
	(237088,231468,0,0),
	(237089,231469,0,0),
	(237090,231470,0,0),
	(237091,231471,0,0),
	(237092,231473,0,0),
	(237093,231474,0,0),
	(237094,231475,0,0),
	(237095,231476,0,0),
	(237096,231477,0,0),
	(237097,231478,0,0),
	(237098,231479,0,0),
	(237099,231480,0,0),
	(237100,231481,0,0),
	(237101,231482,0,0),
	(237102,231483,0,0),
	(237103,231484,0,0),
	(237104,231486,0.3333333333333333,0),
	(237105,231487,0,0),
	(237106,231488,0.3333333333333333,0),
	(237107,231489,0.3333333333333333,2),
	(237108,231490,0,0),
	(237109,231491,0.3333333333333333,0),
	(237110,231492,0,0),
	(237111,231493,0.3333333333333333,0),
	(237112,231494,0.3333333333333333,0),
	(237113,231496,1,1),
	(237114,231498,0,0),
	(237115,231499,0,0),
	(237116,231500,0,0),
	(237117,231501,0,0),
	(237118,231502,0,0),
	(237119,231503,0,0),
	(237120,231504,0,0),
	(237121,231505,0,0),
	(237122,231506,0,0),
	(237123,231507,0,0),
	(237124,231509,0,0),
	(237125,231510,0,0),
	(237126,231511,0,0),
	(237127,231512,0,0),
	(237128,231513,0,0),
	(237129,231514,0,0),
	(237130,231515,0,0),
	(237131,231516,0,0),
	(237132,231517,0,0),
	(237133,231518,0,0),
	(237134,231524,0,0),
	(237135,231520,0,0),
	(237136,231521,0,0),
	(237137,231522,0,0),
	(237138,231526,0,0),
	(237139,231527,0,0),
	(237140,231529,0,0),
	(237141,231530,0,0),
	(237142,231531,0,0),
	(237143,231532,0,0),
	(237144,231534,0,0),
	(237145,231535,0,0),
	(237146,231537,0,0),
	(237147,231539,0,0),
	(237148,231541,0,0),
	(237149,231542,0,0),
	(237150,231543,0,0),
	(237151,231545,0,0),
	(237152,231547,0,0),
	(237153,231549,0,0),
	(237154,231550,0,0),
	(237155,231552,0,0),
	(237156,231553,0,0),
	(237157,231554,0,0),
	(237158,231555,0,0),
	(237159,231556,0,0),
	(237160,231558,0,0),
	(237161,231559,0,0),
	(237162,231560,0,0),
	(237163,231561,0,0),
	(237164,231562,0,0),
	(237165,231564,0,0),
	(237166,231565,1,1),
	(237167,231567,0,0),
	(237168,231569,2,2),
	(237169,231570,0,0),
	(237170,231572,0,0),
	(237171,231573,0,0),
	(237172,231575,0,0),
	(237173,231576,0,0),
	(237174,231577,0,0),
	(237175,231578,0,0);

insert into `sectioning_queue` values
	(231381,231379,2,'2010-09-22 14:16:29',NULL),
	(231842,223206,2,'2010-09-22 14:20:01',NULL),
	(231844,231379,2,'2010-09-22 14:20:06',NULL),
	(231846,231379,2,'2010-09-22 14:22:05',NULL),
	(231848,231379,2,'2010-09-22 14:22:56',NULL),
	(239173,231379,2,'2010-09-22 17:24:53',NULL),
	(239175,231379,2,'2010-09-22 17:27:04',NULL),
	(239177,231379,2,'2010-09-22 17:28:23',NULL),
	(239179,223206,2,'2010-09-22 17:28:29',NULL);

insert into `sectioning_status` values
	(1343447,'Enabled','Access enabled',7,NULL),
	(1343448,'Disabled','Access disabled',4,NULL),
	(1343449,'Not Available','Temporarily not available',6,'Access is temporarily disabled. Please try again later...'),
	(1343450,'No Email','Access enabled, no email notification',3,NULL);

insert into `sessions` values
	('woebegon','2007-08-20 00:00:00','2007-12-08 00:00:00','2007-12-15 00:00:00',223206,'00000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000022000000000000000000000000000000000000000000222200000000000000000000000000000000000000000000000000000000000000000000',49,269,NULL,'2007','Fal','2007-12-10 00:00:00','2007-07-20 00:00:00','2008-01-15 00:00:00',NULL,1,1,1),
	('woebegon','2010-08-23 00:00:00','2010-12-12 00:00:00','2010-12-19 00:00:00',231379,'00000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000022000000000000000000000000000000000000000000222200000000000000000000000000000000000000000000000000000000000000000',853,445,NULL,'2010','Fal','2010-12-13 00:00:00','2010-07-19 00:00:00','2011-01-16 00:00:00',NULL,1,1,1);

insert into `settings` values
	(42,'timeGrid','vertical','horizontal,vertical,text','Time grid display format'),
	(85,'name','last-initial','last-first,first-last,initial-last,last-initial,first-middle-last,short','Instructor name display format'),
	(86,'cfgAutoCalc','yes','yes,no','Automatically calculate number of classes and room size when editing configuration'),
	(87,'timeGridSize','Workdays x Daytime','Workdays x Daytime,All Week x Daytime,Workdays x Evening,All Week x Evening,All Week x All Times','Time grid default selection'),
	(88,'jsConfirm','yes','yes,no','Display confirmation dialogs'),
	(89,'inheritInstrPref','never','ask,always,never','Inherit instructor preferences on a class'),
	(108,'showVarLimits','no','yes,no','Show the option to set variable class limits'),
	(128,'keepSort','no','yes,no','Sort classes on detail pages'),
	(148,'roomFeaturesInOneColumn','yes','yes,no','Display Room Features In One Column'),
	(168,'roomFeaturesInOneColumn','yes','yes,no','Display Room Features In One Column'),
	(188,'printNoteDisplay','icon','icon,shortened text,full text','Display an icon or shortened text when a class has a schedule print note.'),
	(189,'crsOffrNoteDisplay','icon','icon,shortened text,full text','Display an icon or shortened text when a course offering has a schedule note.'),
	(190,'mgrNoteDisplay','icon','icon,shortened text,full text','Display an icon or shortened text when a class has a note to the schedule manager.'),
	(208,'unitime.menu.style','Dynamic On Top','Dynamic On Top,Static On Top,Tree On Side,Stack On Side','Menu style');

insert into `solution` values
	(806,'2008-05-07 08:39:38',1,1,'2008-05-07 08:40:01',NULL,'IFS Timetable Solver v1.1 build-1, Unknown',345,NULL),
	(807,'2008-05-07 08:39:53',1,1,'2008-05-07 08:40:04',NULL,'IFS Timetable Solver v1.1 build-1, Unknown',344,NULL),
	(826,'2010-09-22 16:09:22',1,1,'2010-09-22 16:09:27',NULL,'IFS Timetable Solver v1.2 build-1, Unknown',366,NULL),
	(827,'2010-09-22 16:09:23',1,1,'2010-09-22 16:09:29',NULL,'IFS Timetable Solver v1.2 build-1, Unknown',365,NULL);

insert into `solver_gr_to_tt_mgr` values
	(345,472),
	(365,472),
	(344,473),
	(366,473);

insert into `solver_group` values
	(344,'Instructional Planning','Instr Plan',223206),
	(345,'Large Lecture Room','LLR',223206),
	(365,'Large Lecture Room','LLR',231379),
	(366,'Instructional Planning','Instr Plan',231379);

insert into `solver_info` values
	(274779,1,0x1F8B080000000000000095935F6BC23014C5DFF7292E85C1C6D6980E379D6865630C7C90C9A64F630F697BADC19848FEC8FCF6BBD50D1422C39736A5E77773CF3D497FF8BD52B041EBA4D18324633C01D4A5A9A4AE07C96CFA9A7693617ED137B666414B2F57C89A87178542E68C229405C926D6ACD17A896EA4E7E6A06092F7517BBB85256E07C9185786D6C1891A93FCA1CD1EDBE37E6B2738D24D8D8142D6608D59B924E78CF34BB8E2D731ED9373B2D658C14658D9B44540C67F91ACD3CA3A516CE690A40E1642CDD3850976B7CF7D03DDC10DB4A3D0C8A3159E9C9136F67F423308B6D8495C0FA6C60B056BD442F9EDDE468C7A2797B0B638474BB33FEA3F6EF95994CBD49BB4A03748EDBC0DA537F6AC1A534AF10490B69BC5496A6F041C9631C51B652F94023A1BA11903C5A2023169C659F7DFA11D86F8D73EA5116FE645927359ECB739E19DC5D10F1F2AFA84D2E8B992A56FB683CF8A0A0AAAD0E3B7742E6CD5E35F5158D0E85C28D6C27A28842284AECB899C5BE75D9DFC073376D4CC92030000,NULL,1,806,NULL),
	(274780,1,0x1F8B08000000000000009593CB4AC3401486F73EC52120289AE934DAD09636A288E042146D57E262929CA68393993217B16FEF498BD0C20471911BF9BFFF5C6776F3DD2AF842EBA4D1F364C87802A82B534BDDCC93E5E2211D2737C5C9CCD886052DBD6C9175372F4A85CC1945280B92BD58B341EB25BA47BD320786493143EDED163E713B4F9EB035F41E9C683029F211E3F9D36CB0131CE916C640291BB0C6B42E29462CCB4FE12C1B9FC7C4B7CEC946630D5FC2CA2E2F22869C33CE89195E5D0DE88A824B872476B0166A95AE4DB00472769D1196C3055CE751EAD1A3159EAA2371ECFF0BF521D87227715358182F146C500BE5B79D3F8F52AF54296C2CAED052FF8F4A48875934913B517DA6DEA4253D416AE76DA8BCB13D2E3CEAB1A0591E039309E3D93E2A81BDD0BE127058C514CFB4004229A005095D1F68342A10938ED8F8CFA61DCEF137791A473C977B4975CB721FA5A7721647DF7CA8E9132AA3574A56BE0B07EF35190A7298F24B5A0C5B4FF9471416D43817CA8DB01E4AA108A123D333E7C1FF8E4FF10390021F4396030000,NULL,1,807,NULL),
	(274781,1,0x1F8B0800000000000000B3B1AFC8CD51284B2D2ACECCCFB35532D433505248CD4BCE4FC9CC4BB7550A0D71D3B550B2B7E3B2C92F4AD72BCDCB2CC9CC4DD5031125894939A97AC5F93940AD7AA5997A6E9939A99E7969F948462929E425E6A6DA2A393B058364E2832D0CCCF4AA80D629E9DB01007D0D957E77000000,NULL,2,806,NULL),
	(274782,1,0x1F8B0800000000000000B3B1AFC8CD51284B2D2ACECCCFB35532D433505248CD4BCE4FC9CC4BB7550A0D71D3B550B2B7E3B2C92F4AD72BCDCB2CC9CC4DD5031125894939A97AC5F93940AD7AA5997A6E9939A99E7969F948462929E425E6A6DA2A393B058364E2832D0CCCF5AA80D629E9DB01003E19EE6977000000,NULL,2,807,NULL),
	(274783,2,0x1F8B08000000000000009D934D6FDB300C86EFFB1586CFADED7E004D0746459BAC4886AD2896163B2B31E30990C44092876EBF7EA213274A9CD32E06DF978F289192E1E1C3E8EC373AAFC88EF3ABA2CA33B42BAA956DC6F9FBDBF3E5287F109F805C53B4560565B0E04F904B8D85271D9716AD2A1EBD578D3568C3ABC335BA5803E7764D87D2B7B9004BCEBCC5D5CC88CB5151417964C1127D781942031BC21EB885722FC011198E32558FF3BBFBD15DDE01BDBDDDE047AF38756480758BD0D6B18B09D9B5E0E31D19313F93AE1E30A766E426648C0A3864CF25223F553EC838B4017F2E11791EC5375A891133BD883EF7C2E10DFBBDE0BEA4C1AE4F2D572F94B437F4777437EC33F4891FE9532ACD2EC3726E7D70DD7CF92A530DCACFF951492D826B11CA830665D5F65189EF3F9FB3FBCF3795CCBE4CDF27D955759D4D092FB2AF91DF43F04BF2DAFE80BB7A27660271CF03A83361832EBCA2953AFC11153FBFD48040F4A41A6E6517815176A1FEA2B886B20FA1F5A8D1FB99D4EB19B5CE333FF0A0C64D78923A5EEF76A34483911FD3241D6B1F19D0386A3771C671969C4D25F88D43596F6BEE62AEB748EC8384F27F7F6EF10F861A3E563E040000,NULL,3,NULL,142297),
	(274784,2,0x1F8B08000000000000009D934F6FE23010C5EFFB29A2DC0941ADB6DDD5E0AA85AD40DAADAA02EAD99021B5E43F91ED54DD7EFA8E43420CE1D44BE4F7DECFE3CCC481BB0F259377B44E183D4D27599E26A877A610BA9CA69BF5E3E836BD633FC0D832ABB5F04261161E9E6F2566CE48DA9AD522BB774E945AA1F6CF16F768A9062EF5DEF4A5AF5306DA58B5A6DD8161A3EB3CCB617CE2C1169D7FBA400D7CF03D01E3A3006B8C0AAB4414D3F4E6D7EDCF948D263955E882C3192F9D6A6B1F3568BBF275418DCC8C6EE25383F205B7C5803937899B19A584C7217B29207E2E9CE734B7017F29203ECCE2AFD9B14903758A82D04C1304BF13A131AEB06954F2DD9389FA1BFA2DDD8CFB027DE6137D4EC5E9D66F97DA797B1C78AC41B865B8585C326F6B8471AF416871B858ECDFFA75FDF6985CFDBECAABE4CF7C334B2639B5D703F0C6C3BEEEE5DA5A676604857E0750634285D63FA3E6D2FF67CDE58B0DF0C63C8832B4D1AE4009BD129FC8E81E764BA81D4A746EC1E57E616AEB023FF0A0C0CA3F7049DFF67050A441F18F791453ED13034A6BEA8AE64B730C692CC155167971A8D9AE43BD5564F712C6DFFDB9D917D8099CE23E040000,NULL,3,NULL,142298),
	(274785,2,0x1F8B08000000000000009D93DD8ED3301085EF798A28D76C7EA082054DBD625BA09550B5A2DD07709B69D6927F22DB8185A7679C34A9DBF48A9B6ACE399F2799890B0FAF4A26BFD03A61F43C2DB3224D501F4C25743D4F9F77DFEEEED307F6068CADB3560B2F1466E1C7F3BDC4CC194947B356645F9C13B556A8FD93C5235AEA816B7D34E7D6B394813656EDE87460589115905F38B047E7371366E2821F73C8C71AAC312A5489A8E6E9C74FF71F52765716840C41FF809F833AB51E3568BBF56D45332C8CEEE24B83F215B7D584B936895B18A584C7297B2B207E299CE7B4B2097F2B203EACE28739B059070D8A82304C28CBE00F220CC61576834A7ED89868BEA97FA2BB6DDFA0AF7CA2AFA938DDFBFD5A3B6FC785C71A845B873BC525F3B645C8CF1A8416FD9D62BBDD4B52BEFBFCBE6892AFCBE745521665B2C1DF8AEBB7C9773A3382F0C2C3F9E1254F3DAFCC080A734FA0CE8406AD7F42CDA5FFD3DFC1D8006FCCA3A8BBCBD757A084DE8ABFC866900F25B40E253AB7E2F2B832AD75819F785061E31FB9A46FDC3F28D2A0F8EB328AA9F78501B5356D437BA67D863496E01A8BBCEA7B9EEAD06F1BD96709F9FFFEBFD93FB085D07841040000,NULL,3,NULL,142299),
	(274786,2,0x1F8B08000000000000009D93DD6EDA401085EFFB1496AF1BFFA8A84DA361A306DA8054A128900758F0E0ACB43F68779DA67DFACEDAD82C98ABDCA039E77C3BF68C17B87F57327943EB84D1D3B4CC8A3441BD3395D0F5347DD9FCBAB94DEFD92730B6CE1A2DBC5098851FCFB7123367241DCD1A91FD704ED45AA1F64F16F768A9072EF5DE9C5A4F5206DA58B5A1D381614556407EE6C0169D5F8D98910B7EC8211F6AB0C6A85025A29AA6DFBEDF7E4DD94D5910D207DD039E7B756C3D68D076ED9B8A669819DDC6E706E50B6EAB1173691237334A098F63F65A40FC5C38CF696523FE5A407C58C56FB3639316EA150561985096C1EF45188C2B6C07957CB732D17C63FF48B7DBBE425FF8445F5271BAF5DBA576DE0E0B8F3508B70C778A4BE66D83909F34082DBA3BC5369BD7A42CEEBE143CF9397F99515D262BFCA3B8FE9C3CD2990184571ECEF72F79EC79614650987B04B5261CD0FA27D45CFABFDD1D8C0DF0C63C88BABD7C5D054AE8B5F8876C02795F42E350A2730B2EF70BD35817F89107151EFC0397F48DBB07451A147F9F4731F53E33A0B6A639D09E699F218D25B883455E753D8F75E8B78EEC9384FCA3FF6FF61F9159DFDE41040000,NULL,3,NULL,142300),
	(274787,2,0x1F8B08000000000000009D93DD8EDA301085EFFB1451AEBBF9D1A296AD06AF76A12D48155A15F6010C19B296FC836CA7DDF6E93B4E483084ABDEA039E77C9E6426061EDF954C7EA175C2E8595A66459AA0DE9B4AE87A96BE6EBFDD4DD347F6018CADB3460B2F1466E1C7F39DC4CC194947B346644FCE895A2BD4FEC5E2012DF5C0953E9873EB49CA401BABB6743A30ACC80AC82F1CD8A1F3EB113372C10F39E4430DD61815AA4454B3F4F3C3F453CAEECA82903EE81EF0B357A7D683066D37BEA96886B9D16D7C6950BEE4B61A31D7267173A394F038666F05C42F84F39C5636E26F05C48755FC307B3669A15E511086096519FC5E84C1B8C27650C9F76B13CD37F64F74BBED1BF4954FF43515A73BBF5B69E7EDB0F0588370AB70A7B864DE3608F95983D0A2BB536CBB7D4B1EBEDC173CF9BA789D276551266BFCADB8FE987CA72303076F3C1CEFDFF1D4F2CA8CA030F6086A4D38A2F52FA8B9F47FBA2B181BE08D7916757BF7BA0A94D01BF117D904F2BE84C6A144E7965C1E96A6B18E4D211F7950E1D13F73499FB87B50A441F1F7451453EF0B036A6B9A23AD99D619D258823B5AE455D7F354877E9BC83E4BC8FFF7EFCDFE012DA6B2E140040000,NULL,3,NULL,142301),
	(274788,2,0x1F8B08000000000000009D53DD4EC23014BEF72996DDBB8DA051CC61444003892146E0010A3BCC26FD59DACEA84F6FDB31561857DE2CE7FBE9D79DB333987C73167DA1D2548A713C48B23842B1970515E538DE6E5E6F1FE3497E035295492DA8A11C13F73064C730D192D9A3494D9367AD6929380AF3AEF080CA66E0521C64177D17E720A4E21B7BDA79F22CC9203D636087DAAC7A9E1E0BE6A4437AAA4149C95D15D1621C3F8C1E47B1D35BB649FF68D131F78441A8B5A90BDBC04C0A2F9F13565F1055F43C97A4F5CD24E7D460DF7B4DB0FE39D586D879F5FCD704EB77737893FBFCDE9B5A6405D78C2BEF1CDF02D718E1E81B6564BF923EE6DEF7D7E78F6E3FEA8ECD5AF7056FDD011A785B28EFCC6E29B451A7898718A85EBA8D222C37AA46483B0C54D066A3F24D347C1A6655F432DFCEA241665BEB34F824EE48FB62C7980B3230B95E7B264F4285CABCA320CCFC344B171260A49CD2D26F5B5301A7624D7F311F40DA96506B64A8F582B0C342D64A3B7F8F83022B3325CC7ED7E6A2000327DFF340B6D96704944AD6951DAD1DA1534308BA52488A26F358BBBC75407710D2FFFED0F91F91832CAE32040000,NULL,3,NULL,142302),
	(274789,2,0x1F8B08000000000000009D535B4FC230147EF7572C7B771B0AF192C388800612638CE00F28EC309AF4B2B49D417FBD6DC758613EF9B29CEFD2AF3B6767303970167DA1D2548A713C48B23842B1950515E538FE5CBF5CDFC793FC0AA42A935A50433926EE61C88661A225B347939A264F5AD3527014E65DE10E95CDC0A5D8C92E7A18E720A4E26B7BDA79F22CC9203D636083DABCF53C3D16CC4987F454839292BB2AA2C538BE7BB87F889DDEB24DFA478B8EB9270C42AD4C5DD806665278F99CB0FA82A8A2E7B924AD6F2639A706FBDEBF04EB9F536D889D57CFFF9760FD6E0EAF729B8FBCA9455670CDB872E8F816B8C60847DF2823DB37E96346BEBF3E7F74FB51776CD6BA2F78EB0ED0C0DB427963364BA18D3A4D3CC440F5D26D1461B9513542DA61A082361B95AFF7D1CDE36D5645CFF3CF5934C86C6F9D087BE2CEB46F76CCB92003936BB667F22454A8CC3B0AC2CC77B375210146CA292DFDBA3515702A56F407F301A46D09B546865A2F08DB2D64ADB4F3F73828B03253C2EC876D2E0A3070729807B2CD3E23A054B2AEEC6CED0C9D1A42D09542523499C7DAE5AD02BA8390FEF78FCE7F01B0F0767333040000,NULL,3,NULL,142303),
	(274790,2,0x1F8B08000000000000009D535B4FC230147EF7572C7B771B5E229A438D820612438C407C2EEC309BF442DACEA8BFDEB663AC309F7C59CE77E9D79DB333B8FF123CF9446D9892A3749015698272A34A26AB51BA5A3E9F0FD37B72064A57592D99650233FFB074CD31338ABBA359CDB207635825054AFBAA718BDA65E04C6E55177D9512904A8BA53BED3DA4C80AC88F1858A3B1F39EA7C7823DE8901F6AD04A095F25AC1CA537B7C3DBD4EB2DDBA4BFB5689F7BC020F5C2D6A56B60AC64908F09A74FA92E7B9E53D2F9C64A0866B1EFFD4B70FE093396BA79F5FC7F09CEEFE7F0A236E43A985AE404DF8C2FAF3CDF02DF1815181AE574335721E63AF4D7E7F7EE30EA8E2D5AF709EFDC111A045B2CAFED7A268DD58789C7189899F98DA29C585D23E41D062659B351E43DB9B9BB2C68F234598D9341E15AEB34F8A0FE48FB62FB98133232F95E7BA640C20EB57D4549B9FD6E962E26C02AF5C8AAB06D4D0582C905FB413280BC2DA136C8D19829E5DBA9AAB5211790F7382871671F2977DFB5B928C220E8D724925DF611019556F5CE8DD68DD0AB3104B3D348CB26735FFBBC45447710F2FFFED0E417A5685E8632040000,NULL,3,NULL,142304),
	(274791,2,0x1F8B08000000000000009D53DD4EC23014BEF72996DDBB8DA811CC61464102892146E0013A76984DFA43DACEA04F6FDB31561857DE2CE7FBE9D79DB333783E70167DA3D2548A713C48B23842B1952515D538DEAC67B7C3F839BF01A9AAA416D4508E897B1852304CB464F66852D3E4456B5A098EC27C28DCA1B219B8103BD945DFC73908A9F8DA9E769E3C4B3248CF1828509B65CFD363C19C74484F352829B9AB225A8EE3C7D170143BBD659BF4CF161D734F18845A99BAB40D4CA4F0F23961F5395165CF73495ADF44724E0DF6BDD704EB9F526D889D57CF7F4DB07E378777B9CD1FBCA9455670CDB8F2DEF12D708D118EBE5146B64BE9631E7C7F7DFEE8F6A3EED8AC755FF0D61DA081B78572618A85D0469D261E62A07AE1368AB0DCA81A21ED3050419B8DCA67D1F0E92E23D1DB74338906996DADD3E08BB823ED8B1D632EC8C0E47AED993C097B54E6030561E6A759BA900023E52BADFCB63515702A56F417F301A46D09B546865ACF09DBCD65ADB4F3F73828716F5E09B3DFB5B928C0C0C9611AC836FB8C804AC97A6F476B47E8D41082DE2B24659379AC5DDE2AA03B08E97F7FE8FC0F1E23BFCC32040000,NULL,3,NULL,142305),
	(274792,2,0x1F8B08000000000000009D535B4FC230147EF7572C7B77978811CC61464003892144E0071476984D7A216D67D45F6FDB3156984FBE2CE7BBF4EBCED9193C7D71167DA2D2548A719C27591CA1D8CB928A6A1C6F37AFB7C3F8A9B801A9AAA416D4508E897B18B2639868C9ECD1A4A6C9B3D6B4121C8559293CA0B219B81007D9450FE20284547C634F3B4F912519A4170CEC509B65CFD363C19C7548CF352829B9AB225A8EE387D170143BBD659BF4F7169D72CF18845A9BBAB40D4CA5F0F22561F5395165CF734D5ADF54724E0DF6BD7F09D63FA3DA103BAF9EFF2FC1FADD1CDEE4BEB8F7A61659C135E3CA81E35BE01A231C7DA38CEC97D2C7DCFBFEFAFCC9ED47DDB159EBBEE2AD3B40B9B785F2CEEC16421B759E788881EA85DB28C20AA36A84B4C340056D36AAD84479FE789791E865B69D4679667BEB44F820EE4CFB66A79C2B3230B9667B264FC2119559A120CC7C375B171260A49CD0CAAF5B5301A7624D7FB0C8216D4BA83532D47A4ED8612E6BA59DBFC74189473321CC7ED8E6A20003275FB340B6D91704544AD6473B5B3B43A78610F45121299BCC53EDF2D601DD4148FFFB4717BF9DFF760733040000,NULL,3,NULL,142306),
	(274793,2,0x1F8B08000000000000009D53C94EC33010BDF31551EE646111054D83A005B512AA2A5A3EC06DA6C19297C87650E1EBB19DA6711B4E5CA2798B9F3393093CEE398BBE50692AC538CE932C8E506C654945358E3FD6AF97A3F8B1B800A9AAA411D4508E897B18B2619868C9ECD1A4A1C993D6B4121C85592ADCA1B21938173BD947DFC40508A9F8DA9E769E224B32484F18D8A0368B8167C08239EA901E6B5052725745B41CC777F7A3FBD8E91DDBA6BF77E8907BC420D4CA34A56D602285974F09ABCF882A079E73D2FA2692736A70E8FD4BB0FE29D586D8790DFC7F09D6EFE6F026B7C5AD3775C80AAE1957DE38BE03AE31C2D137CAC876217DCCADEF6FC81FDC7ED43D9B75EE33DEBA03947B5B286FCC662EB451C7898718A89EBB8D22AC30AA41487B0C54D076A38A75945F3D5C6775F432FD984479667BEB45F824EE4CF766879C333230B96607264F428DCA2C511066BEDBAD0B0930523ED3CAAF5B5B01A762457FB0C821ED4A683432D47A46D86E261BA59D7FC04189B57926CC7ED8F6A2000327FB6920DBEC13022A259BDACED6CED0A921045D2B24659B79A85DDE2AA07B08E97FFFE8E21721DBC84833040000,NULL,3,NULL,142307),
	(274794,2,0x1F8B08000000000000009D53C94EC33010BDF31551EE24A90051D034085A502B0142B47C80DB4C83252F91ED20E0EBB19DCD6D7AE212CD5BFC9C994CE0EE9BB3E80B95A652CCE24992C5118A9D2CA82867F1C7E6E97C1ADFE567205599D4821ACA31710F43B60C132D993D9AD434B9D79A9682A3306F0AF7A86C06AEC45E0ED197710E422ABEB1A79D27CF920CD20306B6A8CDEBC83362C1F43AA47D0D4A4AEEAA8816B3F8FA667A133BBD639BF4F70EB5B93D06A1D6A62E6C037329BC7C48587D495431F21C93D637979C538363EF29C1FA17541B62E735F29F12ACDFCDE159EEF22B6FEA90155C33AEBC747C075C6384A36F9491DDABF43157BEBF31DFBAFDA80736EBDC47BC750768E26DA1BC35DB95D046F5130F3150BD721B45586E548D900E18A8A0CD46E52FD1F4F62223D1E3E2631E4D32DBDAA0C1277147BA176B638EC8C0E47A1D993C09152AF3868230F3D32C5D488091F281967EDB9A0A38156BFA8BF904D2AE845A2343AD9784ED97B256DAF9471C14589907C2EC776D2E0A3070F2BD08649B7D4040A9645DD9D1DA113A3584A02B85A46832DBDAE5AD037A8090FEF787CEFF007DAE11F732040000,NULL,3,NULL,142308),
	(274795,2,0x1F8B08000000000000009D535B4FC230147EF7572C7B77970811CD61464003893146E0071476184D7A216D67D05F6FDB3156984FBE2CE7BBF4EBCED9193C1D398BBE50692AC538CE932C8E506C654945358ED7ABD7DB51FC54DC805455520B6A28C7C43D0CD9304CB464F66852D3E4596B5A098EC27C28DCA1B219B8103BD9450FE20284547C654F3B4F912519A4170C6C509BF79EA7C78239EB909E6B5052725745B41CC7F70FA387D8E92DDBA47FB6E8947BC620D4D2D4A56D602A85972F09ABCF892A7B9E6BD2FAA692736AB0EFFD4BB0FE19D586D879F5FC7F09D6EFE6F026B7C5D09B5A6405D78C2B078E6F816B8C70F48D32B27D973E66E8FBEBF327B71F75C766ADFB8AB7EE00E5DE16CA1BB359086DD479E22106AA176EA3082B8CAA11D20E0315B4D9A862B58FF2FCF12E23D1CB6C3D8DF2CC36D7A9B027EE50FB6AA7A02B3230B96E7B264FC20195F9404198F96ED62E24C04839A195DFB7A6024EC592FE609143DA96506B64A8F59CB0DD5CD64A3B7F8F83120F664298FDB2CD4501064E8EB340B6D91704544AD6073B5C3B44A78610F44121299BCC53EDF29601DD4148FFFB4B17BFF5334FC034040000,NULL,3,NULL,142309),
	(274796,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE2DAD8F8866A851D0406208118CE7850E75937D90DDAD517FBDB32D2D0BF5E4A599EFB1DF76A653B8FF9222FA4463B956A3384BD23842B5D10557E5287E5B3D9F0FE3FBFC0CB429934A71C72526FEE1D85A6062B5A0A349C593076B79A9242AB730B845431938535B7D88BE8A7350DAC8159DF69E3C4D52181C31B046EBE63D4F8F05D7E930E86A305A4B5F45BC18C537B7C361ECF5966DD25F5BB4CFED3028B37455410D8CB5AAE56382F4293345CF734A926FACA5E40EFBDEBF04F24FB8758CE6D5F3FF2590DFCFE1456FF2EBDAD422127C33BEBCF27C0B7C634C62DDA8609BB9AE632EEAFEFAFCDE5D8FFAC0A6ADFB84277780B2DA16CA6BB79E29EB4C37F11003B733BF514CE4CE5408830306AE78B351F97B747B7799B2E869F2368EB2F4926C9D061FCC1F695F6C1F73420626DF6BCF5493B043E316A89870DFCDD2850438AD1F799967B46D4D0592AB25FF414FB5255416055A3B65623BD595B1BEE31E0705EEDC2313F45D9B8B020C927D4D0299B28F08288DAE76345A1AA1574308766790154DE6BEF679CB803E4018FCF787CE7F0158497B2E32040000,NULL,3,NULL,142310),
	(274797,2,0x1F8B08000000000000009D53C94EC33010BDF31551EE6411200A9A06410B6A2584106DC5D96DA6C19297C87650E1EBB19DA6719B9EB844F3163F67261378D871167DA3D2548A719C27591CA1D8C8928A6A1CAF962F97A3F8A1B800A9AAA411D4508E897B18B2669868C9ECD1A4A1C9A3D6B4121C857957B8456533702EB6B28FBE8E0B1052F1A53DED3C459664901E31B0466DDE069E010BE6A0437AA84149C95D15D1721CDFDE8DEE62A7776C9BFED1A17DEE0183500BD394B68189145E3E26AC3E23AA1C784E49EB9B48CEA9C1A1F79C60FD53AA0DB1F31AF8CF09D6EFE6F02A37C58D3775C80AAE19575E3BBE03AE31C2D137CAC8E64DFA981BDFDF90DFBBFDA87B36EBDC27BC750728F7B6505E9BF55C68A30E130F31503D771B455861548390F618A8A0ED46159F517E7F95D5D1F3743589F2CCB6D66BF045DC91EEC5F63127646072BD0E4C9E841A9579474198F969972E24C048F9442BBF6D6D059C8A05FDC52287B42BA1D1C850EB1961DB996C9476FE010725D6E68930FB5DDB8B020C9CECA6816CB38F08A8946C6A3B5A3B42A7861074AD90946DE6BE76798B80EE21A4FFFDA18B3F8E9416C232040000,NULL,3,NULL,142311),
	(274798,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE2DC54744339428682031C408C4F34287BAC93EC8EED6A8BFDED996968572F2D2CCF7D86F3BD3298CBEA588BED058AED530EE27691CA1DAE89CAB6218AF962F978378945D803645522AEEB8C4C43F1C5B0B4CAC1674342979F2682D2F9444E5DE0C6ED15006CED4561FA26FE20C94367249A7BD274B93147A470CACD1BA79C7D361C1B53AF4DA1A8CD6D25711CF87F1DDFD60107BBD61EBF4F706ED735B0CCA2C5C99530363AD2AF998207DCA4CDEF19C92E41B6B29B9C3AEF79C40FE09B78ED1BC3AFE7302F9FD1C5EF526BBAD4C0D22C137E3CB1BCF37C037C624568D0AB699EB2AE6AAEAAFCBEFDDD5A80F6CDAB84F787207A85FD94279EDD633659D69271E62E076E6378A89CC9912A177C0C015AF372AFB88FAE9C375CAA2E7C96A4CF535F95A113E993FD3BCD93EE7840C4CBED98EA9226187C6BDA162C2FDD45B1712E0B47EE245D6A775AB2B905C2DF82F7AAA29A1B428D0DA2913DBA92E8DF52D7738C871E79E98A00F5B5F146090EC7B12C8947D44406174B9A3D9D20CBD1A42B03B832CAF33F7B5CF5B04F40142EFBF7F74F60721B135EE33040000,NULL,3,NULL,142312),
	(274799,2,0x1F8B08000000000000009D53DB6E8240107DEF5710DE45E825B6CD8869B58D268D69AA7EC02A23DD642F647769DA7E7D674110C5A7BE9039973DCB0C034CBEA508BED058AED5384CA2380C50ED74C6553E0E37EBD7C17D3849AF409B3C2A15775C62E41F8E6D0546560B3A1A953C7AB296E74AA272EF06F7682803176AAF8FD1B7610A4A1BB9A6D3DE93C6510CC31306B668DDB2E7E9B1E05A1D866D0D466BE9AB8067E370F4F0701DA68324264B23D4177C34E810DD625066E5CA8C7A986A55C9A704E97366B29EE79C24DF544BC91DF6BD9704F2CFB8758C46D6F35F12C8EF47F1A6776972E74D0D22C13753099E6F806F8C49AC1A156CB7D455CC6DD55F9F3FB8AB691FD9B8719FF1E43ECFECAA5BB75D28EB4C3BF02E066E177EA798489D291186470C5CF17AA7D2D72079BC898BE065B69906493C225BABC127F3479AF73AC49C911D936FB567AA4828D0B877544CB89F7AEDBA0438AD9F795EED5B5D81E46AC57FD14FBA29A1B428D0DA3913FBB92E8DF5FE1E071916EE9909FAACF5451D0C927DCF3A32659F10901B5D16345A1AA157BB106C61906575E6A1F679AB0E7D8430FCEF2F9DFE01F2C39F6234040000,NULL,3,NULL,142313),
	(274800,2,0x1F8B08000000000000009D534B4F834010BEFB2B087729688DD64C31B6D5B489691AABF1BC2D53DC641F647731EAAF77160AA5A5272F64BEC77ECB0C033C7C4B117CA1B15CAB7198447118A0DAEA8CAB7C1CBEBF3D5FDE850FE905689347A5E28E4B8CFCC3B18DC0C86A4147A392478FD6F25C49546E657087863270A176FA103D0C5350DAC8373AED3D691CC53038626083D62D7B9E1E0BAED561D0D660B496BE0A78360E6F47A3AB30BD4C62B234427DC16B83F6D12D0665D6AECCA887A956957C4C903E6726EB794E49F24DB594DC61DF7B4E20FF8C5BC768643DFF3981FC7E142F7A9B2637DED420127C3395E0F906F8C698C4AA51C1B64B5DC50CABFEFAFCDE5D4DFBC0C68DFB8427F7696657DDB8CD425967DA81773170BBF03BC544EA4C89303860E08AD73B957E04C9FD755C044FB3F76990C4B7646B35F864FE48F35EFB9813B263F2ADF64C1509051AB742C584FBA9D7AE4B80D37AC2F36ADFEA0A24576BFE8B7ED24D09A54581D6CE99D8CD7569ACF7F738C8B0701326E8B3D617753048F63DEBC8947D44406E7459D06869845EED42B0854196D599FBDAE7AD3BF401C2E0BFBF74FA07FB72710734040000,NULL,3,NULL,142314),
	(274801,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE29AD8F2866A851D04062081188E7850E75937D90DDAD417FBDB32D2D8572F2D2CCF7D86F3BD3293CEDA508BED158AED5304CA2380C506D74C6553E0C57CBB7DE43F8945E8136795428EEB8C4C83F1C5B0B8CAC1674342A78F46C2DCF9544E5E606B7682803A76AAB8FD1B7610A4A1BB9A4D3DE93C6510CFD1306D668DDACE3E9B0E01A1DFA4D0D466BE9AB8067C3F07E30B80ED35E1293A516AA0B3E6A74886E3028B37045463D8CB42AE55382F4093359C7734E926FA4A5E40EBBDE4B02F9C7DC3A4623EBF82F09E4F7A378D79B34B9F3A61A91E09B2905CFD7C037C624968D0AB699E932E6B6ECAFCB1FDCE5B48F6C5CBBCF78729F67B6D5B55B4F9575A619781B03B753BF534CA4CE1408FD2306AE78B553E9673078BC8959F03A5E8D8224BE275BA3C117F347EAF73AC49C912D936FB5632A49D8A17173544CB89F6AEDDA0438AD5F785EEE5B5581E46AC17FD14FBA2EA1B028D0DA0913DB892E8CF5FE0E0719EEDC0B13F459AB8B5A1824DB8F5B32659F10901B5DEC68B43442AFB621D89D4196559987DAE72D5AF41142FFBFBF74FA0738DB085F34040000,NULL,3,NULL,142315),
	(274802,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE2DC547103394086820318608C6F3960E75937D34BB5BA3FE7A675B5A0AF5E4A599EFB1DF76A653987E49117CA2B15CAB49388CE23040B5D31957F9247CDB3E5DDE85D3E402B4C9A35271C72546FEE1582A30B25AD0D1A8E4D183B53C5712955B1BDCA3A10C5CA9BD3E46DF8409286DE4964E7B4F1247310C4E1848D1BA979EA7C7826B7518B43518ADA5AF029E4DC2D1787C152697C3982C8D505FF0DAA043748B41998D2B33EA61AE55259F12A42F99C97A9E73927C732D2577D8F7FE25907FC1AD6334B29EFF2F81FC7E14CF7A970C6FBDA94124F8662AC1F30DF08D318955A382ED5E74157353F5D7E70FEE6ADA47366EDC673CB9CF33BB6AEAD295B2CEB403EF62E076E5778A89C499126170C4C015AF772A790F46F7D7310B1E176FF360188FC8D66AF0C1FC91E6BD0E316764C7E45BED992A120A346E8D8A09F75DAF5D9700A7F58CE7D5BED51548AE36FC07FDA49B124A8B02AD5D32B15FEAD2583F8F1E0719166EC6047DD6FAA20E06C9BE161D99B24F08C88D2E0B1A2D8DD0AB5D08B630C8B23AF350FBBC4D873E4218FCF7974E7E017ED71F8434040000,NULL,3,NULL,142316),
	(274803,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE5B8A625033D42848203184087CC04287BAC95E9ADDAD41BFDED996964279F2A59973D9B39DE9145E0E5204DF682CD76A14F6A3380C50ED74CA55360A37EBE9ED63F892DC8036595428EEB8C4C83F1CDB0A8CAC1674342A78F46A2DCF9444E59606F7682803E76AAF4FD1833001A58D5CD369EF49E22886DE19035BB46ED1F17458708D0EBDA606A3B5F455C0D351387C7ABA0B93DB7E4C965AA82EF8ACD131BAC1A0CCCA1529F530D6AA94CF09D267CCA41DCF2549BEB196923BEC7AAF09E49F70EB188DACE3BF2690DF8FE243EF92FE8337D58804DF4C2978BE06BE3126B16C54B0DD42973183B2BF2E7F7497D33EB171EDBEE0C97D99D956B76E3B57D69966E06D0CDCCEFD4E3191385320F44E18B8E2D54E25D3E0FEF93ECE83F7C9661CF4E321D91A0DBE983F52BFD731E6826C997CAB1D5349428EC62D5131E17EAAB56B13E0B47EE359B96F550592AB15FF453FE9BA84C2A2406B674CEC67BA30D6FB3B1CA498BB3726E8B35617B530487698B464CA3E232033BAC869B43442AFB621D8DC204BABCC63EDF3562DFA04A1F7DF5F3AF903469DE20434040000,NULL,3,NULL,142317),
	(274804,2,0x1F8B08000000000000009D53DB6E8240107DEF5710DE8BD04B5A9B91A66A1B4D9AC654FD805546DC642F647769DA7E7D674110C5A7BE9039973DCB0C033C7F4B117CA1B15CAB5198447118A0DAEA8CAB7C14AE576FD78FE1737A05DAE451A9B8E31223FF706C2330B25AD0D1A8E4D18BB53C5712955B18DCA1A10C9CAB9D3E46DF8529286DE48A4E7B4F1A47310C4E18D8A0751F3D4F8F05D7EA30686B305A4B5F053C1B850FC3E14D985E2731591AA1BEE0B34187E81683324B5766D4C344AB4A3E25489F3193F53CE724F9265A4AEEB0EFBD24907FCAAD6334B29EFF92407E3F8A77BD4D937B6F6A1009BE994AF07C037C634C62D5A860DB0F5DC5DC55FDF5F983BB9AF6918D1BF7194FEEF3CCAEBA719BB9B2CEB403EF62E076EE778A89D499126170C4C015AF772A5DED83E4E9362E82D7E97A1224F103F95A11F6CC9F695EEC907346764CBED79EA922A140E316A898703FF5DE7509705A8F795E2D5C5D81E46AC97FD18FBA29A1B428D0DA1913BB992E8DF503E9719061E1C64CD077AD2FEA6090EC7BDA9129FB8480DCE8B2A0D9D20CBDDA85600B832CAB330FB5CF5B76E82384C17FFFE9F40FE33E923335040000,NULL,3,NULL,142318),
	(274805,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE5B5AC52066A851D040620811F880850E7593BD90DDAD41BFDED996964279F2A59973D9B39DE9149E0F5204DF682CD76A1426511C06A8B63AE32A1F85EBD5FBED63F89CDE8036795428EEB8C4C83F1CDB088CAC1674342A78F4622DCF9544E5160677682803676AA74FD1FD3005A58D5CD169EF49E32886DE19031BB46EDEF17458708D0EBDA606A3B5F455C0B35138180EEFC2F43689C9520BD5059F353A4637189459BA22A31EC65A95F23941FA9499ACE3B924C937D65272875DEF3581FC136E1DA39175FCD704F2FB517CE86D9A3C78538D48F0CD9482E76BE01B6312CB4605DBCE7519D32FFBEBF2477739ED131BD7EE0B9EDC97996D75E33633659D6906DEC6C0EDCCEF1413A9330542EF84812B5EED54BAFA0A92E4E93E66C1DB643D0E927840C646852FE60FD56F760CBA205B26DF6CC75492B047E316A898703FD5E2B509705ABFF2BCDCB8AA02C9D592FFA29F755D426151A0B5532676535D18EB27D2E120C3BD7B65823E6C75510B836487494BA6EC330272A38B3D0D9786E8D53604BB37C8B22AF358FBBC658B3E41E8FDF7A74EFF00084B66D736040000,NULL,3,NULL,142319),
	(274806,2,0x1F8B08000000000000009D53DB4E8340107DF72B08EFA5D46ABC644AA3ADA64D8C31B67EC052A67493BD90DDC5A85FEF2C144AC1275FC89CCB9E658601E65F52049F682CD76A164EA2380C50ED74C6553E0B3FB6CFA3DB709E5C803679542AEEB8C4C83F1C4B0546560B3A1A953C7AB096E74AA2726F06F7682803D76AAF4FD15761024A1BB9A5D3DE93C4510CE3330652B4EE75E019B0E05A1DC66D0D466BE9AB8067B3F0E6EEEE324C4693982C8D505FF0DEA063748B41998D2B33EA61A155259F13A4AF98C9069E3E49BE8596923B1C7AFF12C8BFE4D6311AD9C0FF97407E3F8A17BD4B26D7DED420127C3395E0F906F8C698C4AA51C176AFBA8AB9AAFA1BF2477735ED131B37EE1E4FEE7E66574D5DBA56D69976E05D0CDCAEFD4E31913853228C4F18B8E2F54E25DB4330BD9FC645F0B4FC580493F8867CAD0807E6CF342F76CCE9911D93EF7560AA4828D0B837544CB8EF7AEFBA0438AD1F795E2D5C5D81E46AC37FD08FBA29A1B428D0DA1513FB952E8DF50319709061E11E99A0EF5A5FD4C120D9D7B22353F61901B9D16541B3A5197AB50BC116065956671E6B9FB7E9D02708E3FFFED3C92F5760EF5535040000,NULL,3,NULL,142320),
	(274807,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE538A621033940848203184887CC04287BAC95EC8EED6A05FEF6C4B4BA13EF9D2CCB9ECD9CE740AE39314C1171ACBB51A85BD280E03547B9D72958DC2EDC7BCF3148E933BD0268B72C51D9718F987633B8191D5828E46398F5EACE59992A8DCDAE0010D65E0521DF425BA1F26A0B4911F74DA7B92388AA17BC5C00EAD5BB53C2D165CAD43B7AEC1682D7D15F074140E86C3FB30E9F462B2544279C17B85CED1350665362E4FA987A956857C4D90BE60266D796E49F24DB594DC61DBFB9740FE19B78ED1C85AFEBF04F2FB51BCE97DD27BF4A60A91E09B2904CF57C037C624168D0AB65FE922A65FF4D7E6CFEE62DA1736AEDC373CB96F339BEACEED96CA3A530FBC8981DBA5DF292612677284EE050357BCDCA9641E0C9F1F6216BCCEB6D3A0170FC8566BF0C9FC91EABDCE313764C3E45B6D990A128E68DC1A1513EEBB5CBB26014EEB09CF8A7D2B2B905C6DF80FFA495725E416055ABB60E2B0D0B9B1DEDFE220C5A39B30419FB5BCA88141B2D3AC2153F6150199D1F991464B23F46A13823D1A64699979AE7DDEA6415F2074FFFB4B27BF316AE63A34040000,NULL,3,NULL,142321),
	(274808,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE535AC52066A811D040620C11F880850E7593BD90DDAD51BFDED996964279F2A59973D9B39DE9149EBEA508BED058AED5384CA2380C50ED74C6553E0E37EBD7DE43F894DE8036795428EEB8C4C83F1CDB0A8CAC1674342A78F46C2DCF9544E59606F7682803176AAF4FD1833005A58D5CD369EF49E32886FE19035BB4EEBDE3E9B0E01A1DFA4D0D466BE9AB8067E370381ADD86692F89C9520BD5051F353A4637189459B922A31EA65A95F23941FA9C99ACE3B924C937D55272875DEF3581FC336E1DA39175FCD704F2FB51BCE95D9ADC7B538D48F0CD9482E76BE01B6312CB4605DBBDEB326650F6D7E58FEE72DA2736AEDD173CB92F33DBEAD66D17CA3AD30CBC8D81DB85DF292652670A84FE090357BCDAA974FD190C1FEF6216BCCC36D3208987E46B44F864FE4CFD62C79C0BB265F2BD764C250907346E898A09F753ED5D9B00A7F584E7E5C2551548AE56FC17FDA8EB120A8B02AD9D33B19FEBC2583F900E07191EDC8409FAAED5452D0C927DCF5A32659F11901B5D1C68B63443AFB621D88341965599C7DAE7AD5AF40942FFBFFF74FA076D08E88335040000,NULL,3,NULL,142322),
	(274809,2,0x1F8B08000000000000009D534B4F834010BEFB2B087781FA888F4C31DA6ADAC4348D6DE3792953DC641F647731EAAF77160AA5C5931732DF63BF6586011EBEA4083ED158AED5381C454918A0DAEA9CAB621C6ED62FE7B7E1437A06DA1451A5B8E31223FF702C1318592DE86854F1E8D15A5E2889CA2D0DEED05006CED54E1FA2AFC2149436724DA7BD274DA204E2230632B46E31F00C58709D0E715783D15AFA2AE0F938BCB9BBBB08D3F351429656682E786BD13EBAC3A0CCCA5539F530D1AA968F09D267CCE403CF2949BE8996923B1C7AFF12C83FE5D6311AD9C0FF97407E3F8A57BD4D47D7DED422127C33B5E0F916F8C698C4BA51C1B60B5DC75CD5FD0DF9BDBB9EF6814D5AF7094FEED3CCBE9AB96CAEAC33DDC0FB18B89DFB9D622275A642880F18B8E2CD4EA5EFC1E5FD655206CFD3CD2418253764EB34F860FE48FB5EFB9813B267F2AD0E4C3509251AB744C584FB6ED6AE4F80D3FA8917F5BE351548AE56FC07FDA4DB122A8B02AD9D31B19BE9CA58EF1F709063E99E98A0CFDA5CD4C320D9D7B42753F6110185D15549A3A5117AB50FC1960659DE64EE6B9FB7EAD10708F17F7FE9F4174F2C0C6134040000,NULL,3,NULL,142323),
	(274810,2,0x1F8B08000000000000009D53DB6EDA40107DEF57587E6E7C49489B56C346092405A942A8900F58F0E0ACB417B4BB4E69BFBEB3363606F3D4176BCE65CF7AC663783C28197DA075C2E8719C27591CA1DE9A42E8721CBFAD5F6F1EE247F6098C2D934A0B2F1426E1E1F94662E28CA4A349259227E744A9156ABFB4B8434B1938D73B738A1EC50CB4B16A4DA78387654906E919031B747E31F00C58F09D0E6957833546852A12C538FEFAEDE14BCC6EF28C2CADD05CF0AB45C7E80E83B62B5F15D4C3C4E85A3E27489F715B0C3C9724F9264629E171E8BD26907F2A9CE734B281FF9A40FE308A9F66CBEE6B538B4808CD84320F7C0B42635C61DDA8E4DB85A9636EEBFE86FCD15D4FFBC466ADFB8227F765665FDDF8CD5C3B6FBB81F73108370F3BC525F3B642484F188416CD4EB17594E7DFEF321EBD4CDF26519EE5D1027F2BAE3F473FE8446783771E4EB7AF784CBC207BA6D0F5C05493B047EB97A8B9F47F9A0DEC13E08D791665BD7A4D054AE895F88B6C04695B42E550A273332E7733535917FC030E0ADCFB672EE90B3717F530287E98F664CA3E23A0B4A6DAD394699A41ED43707B8BBC68328F75C85BF5E81384F47FFF6EF60FCE9B3C553F040000,NULL,3,NULL,142324),
	(274811,2,0x1F8B08000000000000009D53DB4EE330107DDFAF88F20CB9705B40532368615B095588960F709B69B0E44B653B2CECD7EF3869D2B4E1899768CEC5C799C904EE3E958C3ED03A61F428CE932C8E50AF4D2174398ADF964FA7D7F11DFB05C69649A585170A93F0F07C25317146D2D1A412C9BD73A2D40AB57FB1B8414B1938D31BB38FBE88196863D5924E070FCB920CD2030656E8FC7CE019B0E03B1DD2AE066B8C0A55248A51FCFBE6FA2A66A779469656682E786DD12EBAC3A0EDC25705F53036BA960F09D2A7DC1603CF3149BEB1514A781C7ABF13C83F11CE731AD9C0FF9D40FE308A67B36697B5A945248466429907BE05A131AEB06E54F2F5DCD43167757F437EE7AEA7BD67B3D67DC493FB38B3AFAEFC6AA69DB7DDC0FB18849B859DE292795B21A47B0C428B66A7D8F23DCAF3DBF38C478F93B77194677934C7BF8AEB93E80F1DE97CF0CEC3F1F61D77914764CF14DA1E986A12B668FD0B6A2EFD57B3827D02BC310FA2AC77AFA94009BD10FF905D40DA96503994E8DC94CBCDD454D605FF808302B7FE814BFAC4CD453D0C8A7F4E7A32651F10505A536D69CC34CEA0F621B8AD455E3499BB3AE42D7AF41E42FAD3DF9BFD07E300F5DC40040000,NULL,3,NULL,142325),
	(274812,2,0x1F8B08000000000000009D534B6FDA4010BEF757583E277EB4B4A5D1B051036D408A102A44392F787057DA07DA5D37697F7D676D6C0CE6948B35DF63BFF58CC770FFA664F407AD13464FE23CC9E208F5CE14429793F879F3F3761CDFB30F606C99545A78A130090FCFB7121367241D4D2A917C774E945AA1F62B8B7BB494810BBD37A7E851CC401BAB36743A78589664909E31B045E79703CF8005DFE9907635586354A822514CE2AFDFC65F62769B67646985E6825F2D3A467718B45DFBAAA01EA646D7F23941FA9CDB62E0B924C937354A098F43EF3581FC33E13CA7910DFCD704F287513C991DFB5C9B5A444268269479E05B101AE30AEB4625DF2D4D1DF3B1EE6FC81FDDF5B44F6CD6BA2F78725F66F6D5ADDF2EB4F3B61B781F83708BB0535C326F2B84F4844168D1EC147B89F2FCEE53C6A31FB3E769946779B4C457C5F54DF448273A1BFCE6E174FB8AC7C40BB2670A5D0F4C350907B47E859A4BFFB7D9C03E01DE980751D6ABD754A0845E8B7FC84690B625540E253A37E7723F379575C13FE0A0C0837FE092BE7073510F83E26FB39E4CD9670494D654079A324D33A87D08EE6091174DE6B10E79EB1E7D8290BEF7EF66FF01AEF8FCCE3F040000,NULL,3,NULL,142326),
	(274813,2,0x1F8B08000000000000009D93416FDB300C85EFFB1586CFADEDB6019A0D8C8B36D9900C5B512C2D765662C613208981240FDD7EFD283B4EE438A75D0CF2BD4F2F212DC3C3BB56C96FB44E9299A53759912668B6544953CFD2B7D72FD7D3F4A1FC0064EBAC31D24B8D597878B1519839527C346B64F6E89CAC8D46E35F2CEED07206AECC8E4ED193B4044356BFF2E9C0944556403E506083CE3FC7CAF524402319FC3104F2630D9648872A91D52CBDFF38BD4F3900F25EEEF27FF45DB0060218BBF64DC533CCC9B4D14381FDA5B0D5883917999B93D6D2E398BD6430BF90CE0B5ED988BF64301F36F18DB6E5DD24407DC74618A63582DE376130A1B11D5489ED3345F38DF503DD2EFB027DA6337D4EC5EEC66F56C679DBBFAC410FD2ADC29D12AAF4B641C84F3D4823BB3B557EFF994C3FDD1522F9BC789B2737C56DB220BC4ABE327E64E0970847FBFF77883B1323288C3C825A11F668FD0B1AA1FC9FEE8AC60278A22759B7D7AEAB404BB3967FB1BC85BC2FA171A8D0B9A550BB2535D6057EA441857BFF2414BFDEEE87A21EB4785F4436670F04A82D357B5E31AF32B8710B6E6F51545DE6A10E79EB483EB590FFEFA75DFE0341C3B5303C040000,NULL,3,NULL,142327),
	(274814,2,0x1F8B08000000000000009D93616FDA301086BFEF5744F9BC26E9401A9B0E572BB48269ABAAD1FE00438ED492ED43B633B5FDF5F305520CE1D3BEA07BDFF7F125773170F36A74F6179D5764A7F97551E519DA0DD5CA36D3FCF9E9FE6A92DF884F40AE295AAB823258F04F906B8D85271D8F16AD2A7E78AF1A6BD08647875B74B1072EED968EADC7B9004BCE3CC5D3CC88AB7151417962C11A7D781842031BC21180F2438023325C65AA9EE65FBF4D267907F4F6FE017F7AC5D18901D6AD425BC7296664B7825FEFC488F942BA7AC09C9B919B91312AE090BD14447EAE7C90716903FE5210795EC52FDA88D198A15EC58087E902F67BC1834983DDA05A6E1E28996FE81FE86EDB17E8333FD2E7549AAEC37A697D70DD82F95BA61A945FF2AD925A04D72294470DCAAAFDAD12BFEFB3EBEAFBA892D9DDFC7916EB513627FC9CFD8CFC07042F92CFF62F78E877662610CF3C803A1376E8C2235AA9C39BA8F8FEA50604A25BD5F028870A8CB22BF58EE20B947D09AD478DDE2FA4DE2EA8759EF9810735EEC2ADD4F1FBEE1F946830F2759EC4B1F789018DA37617771C77C9692AC1EF1CCA7ADFF35073BF55621F2594FFFBEF16FF00AFF282C63F040000,NULL,3,NULL,142328),
	(274815,2,0x1F8B08000000000000009D53DB4EE330107DE72BA23C2F494A1771D1D4686941AD8410A2E503DC661A2CF912D90E02BE9E716E4D1B9EF6259A73F171663281BB4F25A30FB44E183D8B27491647A8772617BA98C56F9BC7F3EBF88E9D81B1455269E185C2243C3CDF4A4C9C917434A944F2CF39516885DABF58DCA3A50C5CE9BD3944FF8D196863D5864E070FCB920CD22306B6E8FCF3C83362C1F73AA47D0DD61815AA48E4B3F8EAE6661AB3F34946964E682E78ED501BDD63D076EDAB9C7A981B5DCBC704E94B6EF391E79424DFDC28253C8EBDBF09E45F08E7398D6CE4FF4D207F18C593D9B18BCB60EA1009A199504E02DF81D0185758372AF9EED9D431D3BABF31DFBAEB691FD8AC739FF0E43ECD1CAA5BBF5D69E76D3FF02106E15661A7B864DE5608E90183D0A2D929B6798FA6B7D3AC8C1E166FF368925D47ED30FE446B3AD2FBE09D87E3DD3BB69127E4C014DA1E996A124AB4FE053597FEAB59C12101DE987B51D4BBD754A0845E8B6F0C53EF4AA81C4A746EC9E57E692AEBD805A4230E722CFD3D97F4899B8B061814FF5C0C64CA3E22A0B0A62A69CC34CEA00E21B8D222CF9BCCB60E79EB017D8090FEEFEFCD7E00953A324C40040000,NULL,3,NULL,142329),
	(274816,2,0x1F8B08000000000000009D53C94EC33010BDF31551CE902614C4A2692A68412D420851FA016E330D96BC44B68380AF679CAD69C3894B346FF173663281E99714C1271ACBB59A8449148701AAADCEB8CA27E1FAFDF1EC3A9CA627A04D1E958A3B2E31F20FC7360223AB051D8D4A1EDD59CB732551B957833B3494814BB5D3FBE88B3005A58D7CA7D3DE93C6510CA303063668DDCBC03360C1753A8CBA1A8CD6D25701CF26E1D5CDCD384CCF92982CAD505FF0D6A226BAC3A0CCCA9519F530D3AA920F09D217CC6403CF3149BE9996923B1C7AFF12C83FE7D6311AD9C0FF97407E3F8A67BD4DCF2FBDA94524F8667C9978BE05BE3126B16A54B0ED8BAE62C6557F43BE7157D3DEB371EB3EE2C97D9CD957376EB354D6996EE07D0CDC2EFD4E31913A53228CF618B8E2F54EA58F41723B8E8BE061BE9E05497C1D34B3380D9EE84467830FE64FB7AFD8241E913D93EF7A60AA4828D0B857544CB8EF7A03FB0438ADEF795EAD5E5D81E46AC57FD00FBD2DA1B428D0DA0513BB852E8DF5FE01071916EE9E09FAC2F5453D0C927DCD7B32651F10901B5D1634659AA657FB106C619065756653FBBC558FDE4318FDF7EF4E7F01AD6B512A3F040000,NULL,3,NULL,142330),
	(274817,2,0x1F8B08000000000000009D53C94EC33010BDF31551CE902614C4A2692A6841AD8410A2E503DC669A5AF212D90E02BE9E71B6A60D272ED1BCC5CF99C904A65F52049F682CD76A1226511C06A8B63AE32A9F841FEBE78BDB709A9E813679542AEEB8C4C83F1CDB088CAC1674342A79F4602DCF9544E5DE0CEED050062ED54E1FA2AFC2149436724DA7BD278DA31846470C6CD0BAD78167C082EB7418753518ADA5AF029E4DC29BBBBB71985E2431595AA1BEE0BD454D74874199952B33EA61A655251F13A42F98C9069E53927C332D257738F4FE25907FCEAD6334B281FF2F81FC7E142F7A9B5E5E7B538B48F0CDF832F17C0B7C634C62D5A860DB575DC58CABFE867CE3AEA67D60E3D67DC293FB34B3AF6EDC66A9AC33DDC0FB18B85DFA9D622275A644181D3070C5EB9D4AD7FB20B91FC745F034FF9805497C1B34C3380F5674A4F3C19EF9E3ED3B36912764CFE4DB1E982A120A34EE0D1513EEBB5EC13E014EEB479E57BB575720B95AF11FF4536F4B282D0AB476C1C46EA14B63BD7FC04186857B64823E717D510F83645FF39E4CD94704E44697058D99C6E9D53E045B1864599DD9D43E6FD5A30F1046FFFDBDD35F74C6E7E740040000,NULL,3,NULL,142331),
	(274818,2,0x1F8B08000000000000009D53DB4EC240107DF72B9A3E6B29A251CC50A32001630811FC80850E7593BD90DDAD41BFDED9DE28D4275F9A39973DDB994EE1F12045F085C672AD46613F8AC300D556A75C65A3F0633DBDBA0F1F930BD0268B72C51D9718F987631B8191D5828E46398F9EACE59992A8DCD2E00E0D65E05CEDF431FA264C406923D774DA7B92388AA177C2C006AD5B743C1D165CA343AFA9C1682D7D15F07414DE0D878330B9EAC764A985F282F71A55D10D0665562E4FA987B156857C4A903E6326ED78CE49F28DB594DC61D7FB9740FE09B78ED1C83AFEBF04F2FB51BCE96D727DEB4D3522C137E3CBBEE76BE01B63128B4605DB2E74113328FAEBF295BB98F6918D6BF7194FEEF3CCB6BA719BB9B2CE34036F63E076EE778A89C4991CA177C4C0152F772A9906C38741CC8297C9C738E8C7F741358BCBE0954E3436F864FE74FD8A55E219D932F9AE3BA682843D1AB744C584FB2E37B04D80D3FA9967C5EA951548AE56FC07FDD0EB12728B02AD9D31B19BE9DC58EFEF7090E2DE3D33415FB8BCA88541B2C3A42553F6090199D1F99EA64CD3F46A1B82DD1B64699959D53E6FD5A28F107AFFFDBB935F3A9D949D3F040000,NULL,3,NULL,142332),
	(274819,2,0x1F8B08000000000000009D934D8FD3301086EFFC8A28679A0FA8604153AFD896558BD8D58AEE8AB3DB4C8325DB13D90E5AF8F5D84993BA4D4F5CA299F77D3CCE4C2670FBAA64F21B8D15A41769991569827A4F95D0F5227D79BE9FDDA4B7EC0D90A9B3560B271466E1E1F84E626649FAA3592BB22FD68A5A2BD4EEC9E0018DAF811B7DA053E979CA409351CFFE7460589115909F29B043EB1E27CC440537FA908F31182215A244548BF4E3A79B0F299B95854706A3BFE0C7901D4B8F3968B3756DE57B5892EEEC73C1FB6B6EAA0973297A6E494A098753F69AE1F995B08EFB914DF86B86E7C328BED39E951D3464DE08CD7446D0872434C615768D4ABE7FA4A8BFA97EA4BB695FA12F744F5F52B1BB73BB8DB6CE8C038F73107613768A4BE64C8B909F72105AF43BC51E7EDE27E5BBCFEF8B26F9BA7A59266551262BC2B7C9377F60A4E0170F8787373C16BC102328343D813A111A34EE093597EE4FBF80B1008EE84ED4DDE6F51128A1B7E22FB239E44308AD4589D6AEB93CACA93536F0130D2A6CDC1D97FE03F717453928FEBA8A6C5FFB4C80DA50DBF821FB61B2D93CAC79AC806D0CF2AA2F7B8C43C96D249F52C8FFF7FF66FF00C4BBB9DC41040000,NULL,3,NULL,142333),
	(274820,2,0x1F8B08000000000000009D934D8FD3301086EFFC8A28679A0FA8604153AFD896558BD8D58AEE8AB3DB4C8325DB13D90E5AF8F5D84993BA4D4F5CA299F77D3CCE4C2670FBAA64F21B8D15A41769991569827A4F95D0F5227D79BE9FDDA4B7EC0D90A9B3560B271466E1E1F84E626649FAA3592BB22FD68A5A2BD4EEC9E0018DAF811B7DA053E979CA409351CFFE7460589115909F29B043EB1E27CC440537FA908F31182215A244548BF4E3A79B0F299B95854706A3BFE0C7901D4B8F3968B3756DE57B5892EEEC73C1FB6B6EAA0973297A6E494A098753F69AE1F995B08EFB914DF86B86E7C328BED39E951D3464DE08CD7446D0872434C615768D4ABE7FA4A8BFA97EA4BB695FA12F744F5F52B1BB73BB8DB6CE8C038F73107613768A4BE64C8B909F72105AF43BC51E7EDE27EF3EBF2F9AE4EBEA6599944599AC08DF26DF3C3F42F08B87B3C30B1EEB5D8811147A9E409D080D1AF7849A4BF7A7DFBF5800477427EA6EF1FA0894D05BF117D91CF22184D6A2446BD75C1ED6D41A1BF889061536EE8E4BFF7DFB8BA21C147F5D45B6AF7D26406DA86DFC8CFD2CD96C1EB63C56C0360679D5973DC6A1E436924F29E4FFFB7BB37FBFC9974440040000,NULL,3,NULL,142334),
	(274821,2,0x1F8B08000000000000009D934D6FDB300C86EFFB1586CF8B3FB060ED0A46C59AB44886AD289A163B2B31E30A90C44092876EBF7E921D3B4A9C532F06F9BE8F2893A6E1F65DC9E40F1A2B48CFD2322BD204F5962AA1EB59FAFAF230B94E6FD9272053678D164E28CCC2C3F18DC4CC92F447B34664DFAD15B556A8DD93C11D1A5F03577A47C7D2D3948126A35EFCE9C0B0222B203F516083D63D8E98910A6EF0211F6230442A4489A866E9D5B7EBAF299B9485477AA3BBE0B9CF0EA5871CB459BBA6F23DCC49B7F6A9E0FD2537D58839173D3727A584C3317BC9F0FC4258C7FDC846FC25C3F361143F69CBCA16EA336F84665A23E87D121AE30ADB4625DF3E52D4DF583FD0EDB42FD067BAA7CFA9D8DDB8CD4A5B678681C73908BB0A3BC52573A641C88F39082DBA9D62BF7E3F2457375F0A9EDC2F5EE7495994C982F073F2C3F303046F3C9CED5FF050EF4C8CA0D0F3086A45D8A3714FA8B9747FBBFD8B05704477A26E17AF8B4009BD16FF904D21EF43682C4AB476C9E56E498DB1811F6950E1DEDD71E9BF6F77519483E2EF8BC8F6B54F04A80D357B3F633F4B3699862D8F15B07B83BCEACA1EE250721DC9C714F28FFEDEEC3FA862CC8240040000,NULL,3,NULL,142335),
	(274822,2,0x1F8B08000000000000009D93DD4EC2401085EF7D8AA6D7524AC42866A811D08031C6083EC04287B2C9FE90DDAD519FDED99696857AE50D9973CEB7D3CE7481FB2F29A24F34966B358E07491A47A8363AE7AA18C71FABA7DE6D7C9F5D803645522AEEB8C4C4FF38B61698582DE86852F2E4C15A5E2889CABD19DCA2A11EB8505B7D6C3D8C3350DAC8159DF64C962629F44F1C58A375AF1DA6E3826B73E8B73518ADA5AF229E8FE39BD1ED28F679E3D6DDDF1B75E8DB6A5066E9CA9C06986A55C5A706E57366F20E736E1237D55272875DF6AF80F819B78ED1BE3AFC5F01F17E0F2F7A935D5750A328F0C3F872E8FD46F8C198C46A50C136AFBA6A735DCDD7F50F74B5EAA33B68E8339FE8408D3C15A66BB75E28EB4CBBF05003B70B7FA198C89C2911FA470D5CF1FA4265AB5D3448EFAE52163DCE3EA6540FA325ED7077193DD38916831DF3A79B573C743C3303C84FDD812A13F668DC1B2A26DC777DFD42039CD6135E54F7AEAE4072B5E43FE877D494505A1468ED9C89ED5C97C67ABEE3418E7B376182BE70FDA04083645FB320A6DE27061446977BDA326D33EB0D52024207ECDE20CBEBB687DAB75C06F65142FFBFFFEEEC1786F51C0C3F040000,NULL,3,NULL,142336),
	(274823,2,0x1F8B08000000000000009D93CB6EDB301045F7FD0A41EB460FC4419D62CC20B15BD8451104B5F301B4355608F021905491F6EB3B942C99B6B2EAC698B9F7F04A33A2E1E15DC9E4375A278C5EA46556A409EA83A984AE17E9EBEEFBCD3C7D609FC0D83A6BB5F04261167E3CDF4BCC9C9174346B45F6E89CA8B542ED5F2C1ED152066EF4D19CA36729036DACDAD1E9C0B0222B20BF50608FCE3F4F98890A7EF4211F6BB0C6A85025A25AA45FEEE7F769F007B54FFF3574A7DCB1076DB7BEAD6880A5D19D7D2990BFE6B69A30D722714BA394F038653F32885F09E739ED6BC27F64101FF6F0D31CD85D070D1D19619850CE823E346130AEB01B54F2C3B3E962EEBAF9A6FA89EE567D568B81BED2898EBA79A06277EFF71BEDBC1D171EF720DC265C282E99B72D427EEE4168D15F28B64BCAAFB745937C5BBD2E93B298255BDAE0DBE7E407F123046F3C9C1D5EF0947725465098790275223468FD0B6A2EFD9FFEF2C50278639E44DDDDBABE0225F456FC4556423E94D03A94E8DC9ACBE3DAB4D6057EA241858D7FE292BE6FFFA0A807C5DF57914DD91702D4D6B40DED9876C96ECA82805801D758E4551F7BAA43E43692CF2DE4FFFBDF66FF008B0A3C483D040000,NULL,3,NULL,142337),
	(274824,2,0x1F8B08000000000000009D93DF4EEA4010C6EF7D8AA6D7C752A24634C39A231C03C61823F8000B1DCA26FB87EC6E8DFAF4CEB6B42C94AB7343E6FBBEDF4E3BD3051EBE944C3ED13A61F4381D66799AA05E9B42E8729C7E2C9F2E47E903BB0063CBACD2C20B8559F8F17C25317346D2D1AC12D95FE744A9156AFF667183967AE05C6FCCA1F575CA401BAB96743A302CCF72181C39B042E75F7B4CCF05DFE530E86AB0C6A85025A218A7B777A3511AF2D66DBABFB76ADFB7D3A0EDC257050D3031BA8E8F0DCA67DC163DE6D4246E6294121EFBECB980F8A9709ED3BE7AFCB980F8B08717B3663735D42A0AC230A1BC0E7E2BC2605C613DA8E4EB5713CDD7F7F774BDEA33F4894F74A446818AD3955FCDB5F3B65B78AC41B879B8505C326F2B84C14183D0A2B9506CB94DEEEEAF729EFC9B7E4C92617E952C6885DB3FC9331DE828D8F270B87DC37DC3133382C2D03DA8366187D6BFA1E6D27F37B72F36C01BF3284A36A46BD754A0845E881F0C565B42E550A273332E373353591766EF7950E0CE3F72491FB87950A441F1AF691453EF23034A6BAA1D2D9996C92E873901B1036E6791174DDB7D1D5A2E22FB2061F0BF7F6EF60B6F9BA70F3E040000,NULL,3,NULL,142338),
	(274825,2,0x1F8B08000000000000009D93DD6EE2301085EFF729A25CB721515B2DBB1A5CB5D00A56ABAA2AF4010C198225FF20DBA9BA7DFA8E13120CE16A6FD09C733E4F321303F79F4A261F689D307A9216599E26A837A614BA9AA4EFABE7EB717ACF7E80B155566BE185C22CFC78BE96983923E968568BECC139516985DABF5ADCA2A51EB8D05B736C7D9B32D0C6AA159D0E0CCBB31C46270EACD1F997013370C1F7398CFA1AAC312A54892827E9CF5FE3711AF2CE6DBBBF75EAD0B7D7A0EDD2D7250D3035BA894F0DCAE7DC9603E6DC246E6A94121E87ECA580F899709ED3BE06FCA580F8B087BF66C3EE1AA85314846142791BFC4E84C1B8C26650C9372F269A6FE81FE866D517E8339FE8488D0315A76BBF5E68E76DBFF05883708B70A1B864DED608A3A306A1457BA1D86A9714C5EF9B9C274FB3F76952E437C99276B8BB4AFED0891E831D0FA7BB573C743C3323284C3D801A13F668FD2B6A2EFDBFF6FAC50678631E45C50ABA776D054AE8A5F8C2607525D40E253A37E7723B37B57561F8810725EEFD2397F485DB07451A14FF9C4531F53E31A0B2A6DED396699BECBAC809881D707B8BBC6CDB1EEAD07219D94709A3FFFD77B36FA54C14D53F040000,NULL,3,NULL,142339),
	(274826,2,0x1F8B08000000000000009D93CD4EEB301085F73C459435A4293FA2174D8DA005B50821740B0FE036D360C93F95ED20E0E919274DEA365DB1A9E69CF3799299B870FBA564F289D609A3C7E930CBD304F5CA144297E3F4FDEDF16C94DEB21330B6CC2A2DBC5098851FCF97123367241DCD2A91DD39274AAD50FB578B6BB4D403E77A6D76AD2F5306DA58F546A703C3F22C87C19E034B74FEA5C7F45CF05D0E83AE066B8C0A55228A717AFD6F749D86BC759BEEFF5BB5EDDB69D076E1AB820698185DC7FB06E5336E8B1E73681237314A098F7DF65840FC5438CF695F3DFE58407CD8C3B359B1AB1A6A15056198505E06BF156130AEB01E54F2D58B89E6EBFB5BBA5EF511FAC0273A5257818AD3A55FCEB5F3B65B78AC41B879B8505C326F2B84C14E83D0A2B950EC3119DD5CE43C7998BE4F92617E9E2C68831FA7C913F11D041F3C9C6D5F70DBEFC08CA030730FAA4DD8A0F5AFA8B9F4DFCDE58B0DF0C6DC8B920DE9D6351528A117E20783D596503994E8DC8CCBF5CC54D685D17B1E14B8F1F75CD2F76D1E146950FC6B1AC5D47BCF80D29A6A433BA65DB2B3614E40EC80DB58E445D3765B87968BC8DE4918FCF5BFCD7E01A0ABAF113D040000,NULL,3,NULL,142340),
	(274827,2,0x1F8B08000000000000009D93DB8EDA301086EFFB1451AEBB39EC41A5D5E055175A4155AD56857D004386AC251F22DBA9B67DFA8E13120CE1AA3768FEFFFF3CC94C0C3CBE2B99FC46EB84D1F3B4CC8A3441BD3795D0F53C7DDD7EBF99A58FEC03185B67AD165E28CCC28FE73B899933928E66ADC8BE3A276AAD50FB178B07B4D403D7FA604EADEF5306DA58B5A5D381614556407EE6C00E9D7F9E301317FC98433ED6608D51A14A44354F3F7D9ECDD2900F6EDFFDD7A08E7D470DDA6E7C5BD1000BA3BBF8DCA07CC56D35612E4DE2164629E171CA5E0B885F0AE739ED6BC25F0B880F7BF869F6ECA183064541182694F7C11F44188C2BEC06957CFF6CA2F9A6FE91EE567D85BEF0898ED443A0E274E7776BEDBC1D171E6B106E1D2E1497CCDB16213F69105AF4178A6D93F2F6CB5DD124DF96AF8BA42CEE920DADF0ED63F2830E8C14BCF1707878C363C30B3382C2D013A833A141EB5F5073E9FFF4B72F36C01BF3246A56D2B5EB2B50426FC45F0CD65042EB50A2732B2E0F2BD35AC76E219F785061E39FB8A40FDC3F28D2A0F8FB328AA9F79901B5356D434BA665B29BB2202076C0351679D5B73DD6A1E526B24F12F2FFFD73B37FADE26BE93E040000,NULL,3,NULL,142341),
	(274828,2,0x1F8B08000000000000009D93CB6EDB301045F7FD0A41EB4696D2047960CCA0B15BD84511047182AC696BAC10E04320A922C9D7772859326D79958D31F7DEC3916644C3DDBB92C93FB44E183D4D8B2C4F13D41B530A5D4DD397E7DF67D7E91DFB06C65659A385170AB3F0E3F95A62E68CA4A35923B29FCE894A2BD4FED1E2162DF5C0A5DE9A7DEB8B948136563DD3E9C0B03CCB6172E0C01A9D7F18312317FC90C364A8C11AA3429588729A5EDD5C5FA521EFDDAEFB53AF767D070DDAAE7C53D20033A3DBF8D0A07CC16D39628E4DE2664629E171CC9E0A889F0BE739ED6BC49F0A880F7BF86B36ECB2857A454118269417C1EF45188C2B6C07957CF360A2F9C6FE8E6E577D823EF2898ED465A0E274EDD74BEDBC1D161E6B106E192E1497CCDB0661B2D720B4E82E147B4D8AF3DB1F799DFC9ABFCC92223F4F56B4C2B7EFC91F3A3050F0C6C3E1FE0D770D8FCC080A438FA0D6841AAD7F44CDA5FFE86E5F6C8037E65E54ACA06BD755A0845E894F0C565F42E350A2730B2EB70BD35817661F795062EDEFB9A40FDC3D28D2A0F8FB3C8AA9F7810195354D4D4BA665B2B322272076C0D51679D9B5DDD5A1E52AB2F712265FFD73B3FF066FD4EC3E040000,NULL,3,NULL,142342),
	(274829,2,0x1F8B08000000000000009D93DD4EE3301085EFF729A25C439AB0207E34355ADA45ED6A85108507709B69B0E49FC87656C0D3EF386952B7E91537D59C733E4F321317EE3F944CFEA175C2E8695A64799AA0DE9852E86A9ABEBD3E9EDFA4F7EC07185B658D165E28CCC28FE76B899933928E668DC87E39272AAD50FB678B5BB4D403977A6BF6AD2F5306DA58F54AA703C3F22C87C981036B74FE69C48C5CF0430E93A1066B8C0A5522CA697A7D7B739D86BC77BBEE2FBDDAF51D3468BBF24D4903CC8C6EE34383F205B7E5883936899B19A584C7317B2A207E2E9CE7B4AF117F2A203EECE1AFD9B0AB16EA15056198505E06BF176130AEB01D54F2CD9389E61BFB3BBA5DF509FAC8273A5257818AD3B55F2FB5F3765878AC41B865B8505C326F1B84C95E83D0A2BB50EC31292EEE7EE675F27BFE364B8AFC2259D10ADFCF923F7460A0E09D87C3FD1BEE1A1E991114861E41AD09355AFF8C9A4BFFD9DDBED8006FCC83A85841D7AEAB4009BD125F18ACBE84C6A144E7165C6E17A6B12ECC3EF2A0C4DA3F70491FB87B50A441F18F791453EF03032A6B9A9A964CCB64E7454E40EC80AB2DF2B26BBBAB43CB5564EF254CBEFBE766FF01F03787C63E040000,NULL,3,NULL,142343),
	(274830,2,0x1F8B08000000000000009D93DD4EE3301085EF798A28D790A6E267BB686A042DA84508A16D7900B799064BFEA96C07C13E3DE3A449DDA657DC5473CEF93CC94C5CB8FB5232F944EB84D1E37498E569827A6D0AA1CB71FABE7CBA18A577EC0C8C2DB34A0B2F1466E1C7F395C4CC194947B34A64F7CE89522BD4FECDE2062DF5C0B9DE987DEBAB948136562DE97460589EE53038706085CEBFF6989E0BBECB61D0D5608D51A14A44314EFFFC1D8DD290B76ED3FD5FAB767D3B0DDA2E7C55D00013A3EBF8D0A07CC66DD1638E4DE2264629E1B1CF9E0A889F0AE739EDABC79F0A880F7B78316B765D43ADA2200C13CAABE0B7220CC615D6834ABE7E35D17C7D7F47D7AB3E411FF94447EA265071BAF2ABB976DE760B8F3508370F178A4BE66D8530D86B105A34178A2D93D1ED65CE93C7E9FB2419E697C98236F8719E3C13DF41F0C1C3D9F60577FD8ECC080A33F7A0DA842D5AFF869A4BFFDD5CBED8006FCC8328D9906E5D5381127A21FE63B0DA122A87129D9B71B99999CABA307ACF8302B7FE814BFABECD83220D8A7F4DA3987A1F18505A536D69C7B44B7631CC09881D705B8BBC68DAEEEAD07211D97B0983DFFEB7D90F85C4C1993D040000,NULL,3,NULL,142344),
	(274831,2,0x1F8B08000000000000009D93DD4EE3301085EF798A28D79026825DCA6A6A04EDAE5A8410A2E501DC661A2CF9A7B29D15CBD3334E9AD46D7AB537D59C733E4F321317EE3F954CFEA275C2E8495A64799AA0DE9852E86A92BEAFFE5C8DD37B7601C65659AD85170AB3F0E3F95A62E68CA4A3592DB207E744A5156AFF6A718B967AE0426FCDA1F54DCA401BAB56743A302CCF72181D39B046E75F06CCC005DFE730EA6BB0C6A85025A29CA4B777E3711AF2CE6DBBBF756ADFB7D7A0EDD2D7250D3035BA898F0DCAE7DC9603E6D4246E6A94121E87ECB980F899709ED3BE06FCB980F8B08767B3613F1AA853148461427913FC4E84C1B8C26650C9372F269A6FE8EFE966D567E8139FE848FD0C549CAEFD7AA19DB7FDC2630DC22DC285E292795B238C0E1A8416ED8562ABA4287E5DE73CF93D7B9F26457E9D2C69851F97C9131DE829F8E0E170F786FB8627660485A1075063C20EAD7F45CDA5FFD7DEBED8006FCCA3A85841D7AEAD4009BD145F18ACAE84DAA144E7E65C6EE7A6B62ECC3EF0A0C49D7FE4923E70FBA04883E29FB328A6DE470654D6D43B5A322D935D153901B1036E6791976DDB7D1D5A2E23FB2061F4BF7F6EF60D830232553E040000,NULL,3,NULL,142345),
	(274832,2,0x1F8B08000000000000009D93DD6EE2301085EFFB1451AEB749D8765BBA1A5CB5D015ACAAAA2AF4010C19524BFE41B6B3EAF6E9779C906008577B83E69CF379929918B8FF5432F983D609A327E9282BD204F5C694425793F47DF5EB729CDEB30B30B6CA6A2DBC5098851FCFD7123367241DCD6A913D38272AAD50FB578B5BB4D403177A6B0EADAF5306DA58B5A2D381614556407EE4C01A9D7F193003177C9F43DED7608D51A14A4439496FEFC6E334E49DDB767FEBD4BE6FAF41DBA5AF4B1A606A74131F1B94CFB92D07CCA949DCD428253C0ED97301F133E13CA77D0DF87301F1610FCF66C37E3450A72808C384F23AF89D08837185CDA0926F5E4C34DFD0DFD3CDAACFD0273ED191BA09549CAEFD7AA19DB7FDC2630DC22DC285E292795B23E4070D428BF642B155322A7E5E153C799ABD4FA9BE4A96B4C28F6FC96F3AD053F0C1C3E1EE0DF70D4FCC080A430FA0C6841D5AFF8A9A4BFFB7BD7DB101DE984751B1115DBBB60225F4527C61B0BA126A87129D9B73B99D9BDA3AF61DF2810725EEFC2397F481DB07451A14FF9C4531F53E32A0B2A6DED1926999EC725410103BE0761679D9B6DDD7A1E532B20F12F2FFFD73B37FC7410CA63E040000,NULL,3,NULL,142346),
	(274833,2,0x1F8B08000000000000009D93DD4EE3301085EFF729A25C439A4057FC681A042DA8452B84687900B799A696FC13D9CE0A787AC64993BA0D57DC5473CEF93CC94C5CB8FB9022FA8FC672AD267196A471846AA30BAECA49FCBE7A3ABF8EEFF23FA04D99D48A3B2E31F13F8EAD0526560B3A9AD43CB9B796974AA272AF06B768A8072ED4561F5A8FE31C94367245A73D93A7490AA32307D668DDCB8019B8E0FA1C467D0D466BE9AB881793F8EAE6FA26F679E7B6DDDF3AB5EFDB6B5066E9EA8206986AD5C4C706E573668A01736A1237D552728743F6A780F819B78ED1BE06FC4F01F17E0FFFF426FFDB409DA2C00FE3CBB1F73BE10763129B4105DBBCE8A6CD6533DFD0DFD3CDAA0F6ED6D1273ED181BAF25498AEDD7AA1AC33FDC2430DDC2EFC85622277A646181D3470C5DB0B95AF765176717B9956D1E3EC7D1A65E9385AD20E7767D1339DE831D8317FBA7BC57DC7133380FCD403A831A142E35E5131E13EDBEB171AE0B47EE06573EFDA0A24574BFE857E475D09B54581D6CE99D8CE756DACE7071E1458B90726E80BB70F0A3448F6310B62EA7D644069745DD196699BF9799612103A602B83AC68DBEE6BDF7219D80709A3DFFEBBF36FA85510973F040000,NULL,3,NULL,142347),
	(274834,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE698B125F19D608482031C688C6F34287BAC93EC8EED6A8BFDED996D2423D7969E67BECB79DE914EEBE948C3ED13A61F4381E26591CA1DE985CE8621CBFBDCE07D7F11D3B03638BA4D4C20B85497878BE96983823E968528AE4DE39516885DA3F5BDCA2A50C5CEAAD69A34731036DAC7AA5D3C1C3B22483F48881353AFFD4F3F458F0071DD2430DD61815AA48E4E3F8EAE6FA32668361469646A82F7869D03EFA8041DB952F73EA616A74251F13A42FB8CD7B9E53927C53A394F0D8F7FE25907F269CE734B29EFF2F81FC61148F66C34695A94124846642390C7C0342635C61D5A8E49B2753C59C57FDF5F9BDBB9A76CB668DFB8427F76966575DFBF5523B6F0F03EF62106E19768A4BE66D8990B6188416F54EB1F77934CC6E2F321E3DCCDEA654536FAD0A1F3C1C6ADE6C1F7442764CA1D99EA9226187D63FA3E6D27FD78BD725C01B331145B57175054AE895F8413682B429A17428D1B90597DB8529AD0B13E97190E3CE4FB8A40F5B5FD4C1A0F8D7AC2353F611018535E58E864B4364835158EF2E036E6791E775ECBE0E91AB0EDD4248FFFB5FB35F8CEC71C039040000,NULL,3,NULL,142348),
	(274835,2,0x1F8B08000000000000009D93DB6EE2301086EFFB1451EEC94145BB6D35B8DAC22290B65555DA073064C85AF201D9CE8AF6E9779C103084ABDE4433FFFF799C994CE071AF64F20FAD13464FD2322BD204F5C65442D793F4E37D3EBA4B1FD90D185B678D165E28CCC2C3F3B5C4CC194947B34664BF9C13B556A8FDABC52D5AAA814BBD35A7D2E394813656BDD3E9C0B0222B203F53608DCEBF0C98810AFEE8437E8CC11AA34294886A92FEBCBFFB91B2515910D21BDD056F7D76287DCC41DB956F2AEA616A746B9F0BE42FB8AD06CCA548DCD428253C0ED96B06F133E13CA7910DF86B06F161147FCC868D5BA8CFC808CD84B00C7A9F84C6B8C2B651C9372F26EA6FA81FE876DA57E80B9DE84B2A76D77EBDD4CEDBE3C0E31C845B869DE29279DB20E4A71C8416DD4EB1E77952960FB7054F7ECF3EA64959506F2717FEF270A87FB343A10B318242B303A8156187D6BFA2E6D27F768B170BE08D791275BB715D044AE895F8423686BC0FA17128D1B90597DB8569AC0BFC40830A77FE894BFAB0DD45510E8AEF67914DB5CF04A8AD6976345C1A221B8DC37AC70AB89D455E75650F7128B98AE4530AF977FF6BF61FA9C242C839040000,NULL,3,NULL,142349),
	(274836,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE698B125F19D6286820514344E379A143DD641F64776BD45FEF6C4B69A19EBC34F33DF6DBCE740A375F4A469F689D307A1C0F932C8E50AF4D2E74318EDF5E1F0697F10D3B01638BA4D4C20B85497878BE92983823E968528AE4D639516885DA2F2C6ED05206CEF5C6B4D1A398813656BDD2E9E0615992417AC0C00A9D7FEE797A2CF8BD0EE9BE066B8C0A5524F2717C7175791EB3C130234B23D417BC346817BDC7A0EDD29739F53031BA920F09D267DCE63DCF3149BE89514A78EC7BFF12C83F15CE731A59CFFF9740FE308A47B366A3CAD420124233A11C06BE01A131AEB06A54F2F5B3A9624EABFEFAFCCE5D4DBB65B3C67DC493FB38B3ABAEFC6AAE9DB7FB81773108370F3BC525F3B644485B0C428B7AA7D8D37B74757D96F1E87EFA36898619B5D68AF0C1C399E6C576394764C7147AED992A12B668FD023597FEBBDEBB2E01DE983B51540B5757A0845E8A1F6423489B124A87129D9B71B99999D2BA30901E07396EFD1D97F45DEB8B3A1814FF9A7664CA3E20A0B0A6DCD26C69866C300ADBDD65C06D2DF2BC8EDDD52172D9A15B08E97F7F6BF60BB2E1439938040000,NULL,3,NULL,142350),
	(274837,2,0x1F8B08000000000000009D93DB6EDB300C86EFFB1486EFEBC3166CEDC0A858920D093014C5923E8012339E001D02491EDA3EFD289FA2C4B9DA8D41FEFF27CAA469787A5332F98BD609A3E76999156982FA602AA1EB79FABAFB79FF903EB13B30B6CE1A2DBC50988587E77B899933928E668DC8BE3B276AAD50FB178B47B4540337FA68CEA56729036DACDAD1E9C0B0222B20BF50608FCE3F4F98890A7EF4211F63B0C6A81025A29AA75F1F1FCB94DD97052183D15DF07BC8FAD2630EDA6E7D53510F4BA35BFB52207FCD6D3561AE45E2964629E171CADE32885F09E7398D6CC2DF32880FA3F8650EACFC14A021232334D31A411F92D01857D8362AF9E1D944FD4DF59E6EA77D83BED289BEA66277EFF71BEDBC1D071EE720DC26EC1497CCDB06213FE720B4E8768AED92B2FCF6B9E0C98FD5EB32298B2FC48D26FCE1E1CCF0627D9D2B318242AF13A815E184D6BFA0E6D2BF777B170BE08D5988BA5DB82E0225F4567C6018F51042E350A2736B2E8F6BD358C766904F34A8F0E4175CD277ED2E8A7250FC6D15D954FB4280DA9AE644B3A519F6DB1D2BE04E1679D595EDE350721BC9E714F2FFFDADD93F59A7EFC738040000,NULL,3,NULL,142351),
	(274838,2,0x1F8B08000000000000009D93DB6EDB300C86EFF71486EFEB4357ACEBC0A868930D09301445933E801233AE001D02492EDA3EFD289FA2C4B9DA8D41FEFF27CAA469B8FF50327947EB84D1B3B4CC8A3441BD3395D0F52C7DDDFCB9FA99DEB36F606C9D355A78A1300B0FCFB7123367241DCD1A913D38276AAD50FB678B7BB45403577A6F8EA56F5206DA58B5A1D381614556407EA2C0169D7F9A301315FCE8433EC6608D51214A44354B6FEFEECA945D95052183D15DF032647DE931076DD7BEA9A887B9D1AD7D2A90BFE4B69A30E7227173A394F038652F19C42F84F39C4636E12F19C48751FC353B565E0768C8C808CDB446D0872434C615B68D4ABE7B32517F53BDA7DB695FA0CF74A2CFA9D8DDFAED4A3B6FC781C73908B70A3BC525F3B641C88F39082DBA9D629BB7A42C7F7D2F78F27BF13A4FCAE20781A30B6F3C1C1ADEAC2F74264650687602B5221CD0FA67D45CFACF6EF16201BC318FA26E37AE8B4009BD165F18663D84D03894E8DC92CBFDD234D6B11BC8271A5478F08F5CD287ED2E8A7250FC6311D954FB4480DA9AE640C3A521F6EB1D2BE00E1679D595EDE350721DC9C714F2FFFDAFD93F0FAA18CB39040000,NULL,3,NULL,142352),
	(274839,2,0x1F8B08000000000000009D93DB4EE3301086EFF729A2DC932680D8054D8DA005B5124288C203B8CD3458F2A1B29D15F0F48C73AADBF48A9B68E6FF3F8F339309DC7E2A99FC47EB84D1D3B4C8F23441BD31A5D0D5347D7F7B3CFB97DEB23F606C95D55A78A1300B0FCFD7123367241DCD6A91DD39272AAD50FB178B5BB45403977A6BF6A52F5306DA58F546A703C3F22C87C981026B74FE79C48C54F0830F9321066B8C0A5122CA69FAF7FABA48D9599113D21BED05AF7DD6951E72D076E5EB927A9819DDD88702F90B6ECB11732C1237334A098F63F69441FC5C38CF696423FE94417C18C593D9B0E23C407D464668A63182DE27A131AEB06954F2CDB389FA1BEB1DDD4CFB047DA4137D4CC5EEDAAF97DA793B0C3CCE41B865D8292E99B735C2649F83D0A2DD29F69814C5CD45CE9387F9FB2C29F22BE206133E7838D3BF5857E7488CA0D0EB086A44D8A1F52FA8B9F45FEDDEC5027863EE45D52C5C1B81127A25BE318CBA0FA17628D1B90597DB85A9AD63051D188950E2CEDF73491FB6BD29CA41F1CF796453F103012A6BEA1D0D9786D8AD77AC80DB59E4655BB68B43C95524EF5398FCF6BF663F078EB7CF39040000,NULL,3,NULL,142353),
	(274840,2,0x1F8B08000000000000009D93DB6EDB300C86EFF71486EFEBC35AACEBC0A858930E093014C5923E8012339E001D0C492EBA3DFD289FA2C4B9DA8D41FEFF27CAA46978FC50327947EB84D18BB4CC8A34417D3095D0F5227DDBFDB8F99A3EB24F606C9DB55A78A1300B0FCFF7123367241DCD5A917D774ED45AA1F6AF168F68A9066EF4D19C4ADFA50CB4B16A47A703C38AAC80FC4C813D3AFF3263662AF8C9877C8AC11AA34294886A91DE3F3C9429BB290B4246A3BFE0D7980DA5A71CB4DDFAB6A21E964677F6B940FE9ADB6AC65C8AC42D8D52C2E39CBD6610BF12CE731AD98CBF66101F46F1D31C58F9394063464668A633823E26A131AEB06B54F2C38B89FA9BEB03DD4DFB0A7DA1137D49C5EEDEEF37DA793B0D3CCE41B84DD8292E99B72D427ECA4168D1EF14DB25B7DF8AA2499E576FCBA42CBE103679F09B8723E37B0D652EC4080AADCEA04E8406AD7F45CDA5FFD3AF5D2C8037E649D4DDBEF51128A1B7E22F86498F21B40E253AB7E6F2B836AD75EC0EF299061536FE894BFAACFD45510E8A7FAC229B6A9F09505BD336345A1AE1B0DCB102AEB1C8ABBEEC108792DB483EA590FFEF5FCDFE01CC9AC6FF37040000,NULL,3,NULL,142354),
	(274841,2,0x1F8B08000000000000009D93DB4EE3301086EF798A28F7A409A0E5A0A911B4A0565A2144E101DC661A2CF950D9CE0A78FA1DE754B7E91537D1CCFF7F1E672613B8FF5232F987D609A3A76991E569827A634AA1AB69FAF1FE7C7E93DEB33330B6CA6A2DBC50988587E76B899933928E66B5C81E9C139556A8FDABC52D5AAA814BBD35FBD25729036DAC7AA7D381617996C3E44081353AFF3262462AF8C187C910833546852811E534BDBEBD2D52765EE484F4467BC15B9F75A5871CB45DF9BAA41E664637F6A140FE82DB72C41C8BC4CD8C52C2E3983D65103F17CE731AD9883F65101F46F1D76C587111A03E232334D31841EF93D01857D8342AF9E6C544FD8DF58E6EA67D823ED2893EA66277EDD74BEDBC1D061EE720DC32EC1497CCDB1A61B2CF4168D1EE147B4EAEEF2E739E3CCD3F664991FF216CF0E0938723FD7B75658EC4080AAD8EA046841D5AFF8A9A4BFFDDAE5D2C8037E65154CDBEB51128A157E207C3A4FB106A87129D5B70B95D98DA3A462F3BD2A0C49D7FE4923E6B7B519483E25FF3C8A6DA070254D6D43B1A2D8DB05BEE5801B7B3C8CBB66C178792AB48DEA730F9ED5FCDFE037D0A7F2D37040000,NULL,3,NULL,142355),
	(274842,2,0x1F8B08000000000000009D93DB4EC3300C86EF798AAAF7742D204EF28A60036D1242886D0F90AD5E8994C394A408787A9C9E96ADBBE2A6B2FFFF8B53BB2E3C7C4B117DA1B15CAB719C25691CA1DAE882AB721CAF962FE7B7F1437E06DA9449A5B8E31213FF706C2D30B15AD0D1A4E2C9A3B5BC5412957B37B845433570AEB67A5FFA2ACE4169239774DA33799AA4303A50608DD6BD0D98810AAEF761D4C760B4963E8A78318E6FEEEEB2383FCF52423AA3B9E0A3CBDAD27D0ECA2C5C55500F13AD6AFB50207FC64C31608E45E2265A4AEE70C89E32889F72EB188D6CC09F3288F7A378D59B3CBBF0509791E19BA90DAF77896F8C49AC1B156CF3A683FE867A4BD7D33E411FE9441F53A1BB76EBB9B2CEF4030F73E076EE778A89DC990A61B4CF812BDEEC54BE8C6EEE2F53163D4F5793284BAF09EB3DF864FE48F75E6D992331807CAB03A8166187C6BDA362C2FD346B170AE0B47EE265BD6F4D0492AB05FF453FE92E84CAA2406B674C6C67BA32D6F3030D0ADCB92726E8B33617053948F63D0D6CAA7D20406974B5A3D1D208DBE50E15B03B83AC68CAB6B12FB908E47D0AA3FFFED5F91FA8E07EEE37040000,NULL,3,NULL,142356),
	(274843,2,0x1F8B08000000000000009D93DB6EDB300C86EFFB1486EFEBD8DBB01EC0A868931509501445D33E801233AE001D0C492EBA3D7D299FA2C4B9DA8D41FEFF27CAA469B8FB5232F944EB84D1F3B4C8F23441BD33A5D0D53C7D7F7BBCBC4EEFD805185B658D165E28CCC2C3F3ADC4CC194947B34664F7CE894A2BD4FEC5E21E2DD5C0B5DE9B43E95F29036DAC7AA3D381617996C3EC48812D3AFF3C61262AF8D187D918833546852811E53CBDBAB929527659E4840C4677C1EB90F5A5C71CB4DDF8A6A41E1646B7F6B140FE8ADB72C29C8AC42D8C52C2E3943D6710BF14CE731AD9843F67101F46F16476ACF811A021232334D31A411F92D01857D8362AF9EED944FD4DF59E6EA77D863ED1893EA56277EBB76BEDBC1D071EE720DC3AEC1497CCDB066176C84168D1ED147B4C7EDEE6799DFC59BE2F9222FF4DD8E8C1070F4786F7EACB9C8811145A9D40AD08355AFF829A4BFFB75BBB58006FCC83A8DA7DEB2250426FC43F0C931E42681C4A746EC5E57E651AEB58410726229458FB072EE9BB7637453928FEB58C6C2A7E2440654D53D36C6986FD76C70AB8DA222FBBB27D1C4A6E22F990C2EC7F7F6BF60D47AB6ECC38040000,NULL,3,NULL,142357),
	(274844,2,0x1F8B08000000000000009D934D4FE3301086EFFC8A2877D204560BACA646D02E6A2584102DE2EC36D3AC257F54B683D8FDF58CF355B7E9692FD1CCFB3E1E672613B8FF5232F944EB84D1D3B4C8F23441BD35A5D0D5347D5F3F5DDEA6F7EC028CADB25A0B2F1466E1E1F94662E68CA4A3592DB207E744A5156AFF6A7187966AE052EFCCA1F48F94813656ADE97460589EE53039526083CEBF8C98910A7EF06132C4608D51214A44394D6FEEEE8A945D163921BDD15EF0D6675DE921076D57BE2EA98799D18D7D2C90BFE0B61C31A7227133A394F03866CF19C4CF85F39C4636E2CF19C487513C9B2D2BAE02D4676484661A23E87D121AE30A9B4625DFBE98A8BFB1DED1CDB4CFD0273AD1A754EC6EFC66A99DB7C3C0E31C845B869DE292795B234C0E39082DDA9D621FC9CDAFEB9C27BFE7EFB3A4C87F123678F0878723FD7B75654EC4080AAD8EA046843D5AFF8A9A4BFFB75DBB58006FCCA3A89A7D6B235042AFC43F0C93EE43A81D4A746EC1E56E616AEB18BDEC488312F7FE914BFAACED45510E8A7FCD239B6A1F09505953EF69B434C26EB96305DCDE222FDBB25D1C4AAE22F990C2E47FFF6AF60D1161C29837040000,NULL,3,NULL,142358),
	(274845,2,0x1F8B08000000000000009D934D6FDB300C86EFFD1586EF75EC6EE8DA8151D1262B12A0288AA5C5CE4ACC7802F46148F2D0F6D797F2579438A75D0CF27D1F51264DC3DDBB92C93FB44E183D4F8B2C4F13D43B530A5DCDD3B7D7C7CB9BF48E5D80B155D668E185C22C3C3CDF4ACC9C9174346B4476EF9CA8B442ED5F2CEED1520D5CEBBD3994FE9E32D0C6AA573A1D18966739CC8E14D8A2F3CF1366A2821F7D988D31586354881251CED31FB7B745CA2E8B9C90C1E82EF83D647DE931076D37BE29A98785D1AD7D2C90BFE2B69C30A722710BA394F03865CF19C42F85F39C4636E1CF19C487513C991D2BAE0234646484665A23E843121AE30ADB4625DF3D9BA8BFA9DED3EDB4CFD0273AD1A754EC6EFD76AD9DB7E3C0E31C845B879DE29279DB20CC0E39082DBA9D627F926F3FF3BC4E7E2DDF1649915F13367AF0978723C37BF5654EC4080AAD4EA056841AAD7F41CDA5FFE8D62E16C01BF320AA76DFBA0894D01BF18961D243088D4389CEADB8DCAF4C631D2BE8C04484126BFFC0257DD7EEA62807C5DF97914DC58F04A8AC696A9A2DCDB0DFEE5801575BE46557B68F43C94D241F5298FDEF6FCDBE005F3BDF8838040000,NULL,3,NULL,142359),
	(274846,2,0x1F8B08000000000000009D93DB6EDB300C86EFF71486EFEB43576CEBC0A868930D09301445933E801233AE001D0C491EBA3DFD289FA2C4B9DA8D41FEFF27CAA46978F85032F98DD609A3176999156982FA602AA1EB45FAB6FB79F32D7D609FC0D83A6BB5F04261161E9EEF2566CE483A9AB5227B744ED45AA1F62F168F68A9066EF4D19C4ADFA50CB4B16A47A703C38AAC80FC4C813D3AFF3C63662AF8C9877C8AC11AA34294886A917EBDBF2F53765316848C467FC1EB980DA5A71CB4DDFAB6A21E964677F6B940FE9ADB6AC65C8AC42D8D52C2E39CBD6610BF12CE731AD98CBF66101F46F1CB1C58791BA031232334D319411F93D01857D8352AF9E1D944FDCDF581EEA67D85BED089BEA46277EFF71BEDBC9D061EE720DC26EC1497CCDB16213FE520B4E8778AEDDE93CFDF8BA2497EACDE9649597C216E32E19D8733E38B0D752EC4080ABDCEA04E8406AD7F41CDA5FFD3EF5D2C8037E649D4DDC2F51128A1B7E22F86518F21B40E253AB7E6F2B836AD75EC0EF299061536FE894BFAAEFD45510E8A7FAC229B6A9F09505BD336345B9AE1B0DDB102AEB1C8ABBEEC108792DB483EA590FFEF6FCDFE0107F4D0BE38040000,NULL,3,NULL,142360),
	(274847,2,0x1F8B08000000000000009D93DB4EC3300C86EF798AAAF7742D204EF28A60036D1242886D0F90AD5E8994C394A408787A9C9E96ADBBE2A6B2FFFF8B53BB2E3C7C4B117DA1B15CAB719C25691CA1DAE882AB721CAF962FE7B7F1437E06DA9449A5B8E31213FF706C2D30B15AD0D1A4E2C9A3B5BC5412957B37B845433570AEB67A5FFA2ACE4169239774DA33799AA4303A50608DD6BD0D98810AAEF761D4C760B4963E8A78318E6FEEEEB2383FCF52423AA3B9E0A3CBDAD27D0ECA2C5C55500F13AD6AFB50207FC64C31608E45E2265A4AEE70C89E32889F72EB188D6CC09F3288F7A378D59B3CBBF0509791E19BA90DAF77896F8C49AC1B156CF3A683FE867A4BD7D33E411FE9441F53A1BB76EBB9B2CEF4030F73E076EE778A89DC990A61B4CF812BDEEC54BEFC8C6EEE2F53163D4F5793284BAF89EB4DF864FE4CF7626D9D2331807CAF03A8166187C6BDA362C2FD347B170AE0B47EE265BD704D0492AB05FF453FEA2E84CAA2406B674C6C67BA32D6F3030D0ADCB92726E8BB3617053948F63D0D6CAA7D20406974B5A3D9D20CDBED0E15B03B83AC68CAB6B12FB908E47D0AA3FFFED6F91F638E68AF38040000,NULL,3,NULL,142361),
	(274848,2,0x1F8B08000000000000009D934D4FE3301086EFFB2BA2DC491340B0ACA646D0825A0921B40571769B69B0E48FCA7610BBBF9E71BEEA363D718966DEF7F1383399C0ED9792C9275A278C9EA64596A709EA8D2985AEA6E9DBEBE3D9EFF496FD0263ABACD6C20B85597878BE96983923E968568BECCE39516985DABF58DCA2A51AB8D45BB32F7D9932D0C6AA573A1D189667394C0E1458A3F3CF2366A4821F7C980C315863548812514ED3EB9B9B226567454E486FB417FCEDB3AEF49083B62B5F97D4C3CCE8C63E14C85F705B8E986391B899514A781CB3A70CE2E7C2794E231BF1A70CE2C3289ECC8615E701EA333242338D11F43E098D71854DA3926F9E4DD4DF58EFE866DA27E8239DE8632A76D77EBDD4CEDB61E0710EC22DC34E71C9BCAD1126FB1C8416ED4EB1F7A428FE5CE43C7998BFCD9222BF226E30E1838733FD8B75758EC4080ABD8EA046841D5AFF829A4BFFAFDDBB58006FCCBDA89A856B235042AFC47F0CA3EE43A81D4A746EC1E576616AEB584107462294B8F3F75CD2876D6F8A7250FC6B1ED954FC4080CA9A7A47C3A52176EB1D2BE0761679D996EDE2507215C9FB14263FFDAFD937C1A79FDC39040000,NULL,3,NULL,142362),
	(274849,2,0x1F8B08000000000000009D93CB4EC3301045F77C45943D7908100F4D8DA005B5124288B61FE036D360C98FC87610F0F5D84ED3B80D2B36D5CCBDC73799890BF75F82279FA80D5372929659912628B7AA62B29EA4EBD5F3F94D7A4FCE40E93A6B25B34C60E67F2CDD70CC8CE2EE68D6B2ECC118564B81D2BE69DCA17619B8903B35445FA604A4D262E54E7B86145901F991021B34F675C48C54B0071FF2430D5A29E1AB845593F4FAF6E636F57EAF76E9EF7DB7CF3DF420F5D2B6951B60AA64B08F05E7CFA9AE46CCA9E8B8A91282591CB37F198E9F3163A9DBD788FFCB70BCDFC38BDA92AB00F59D33FC30BEBCF47ADFF8C1A8C03028A7DB571562AEC27C637D4F87550F6AD1D327BAA3A3AE0C586C6FEC66218DD5878DC73D30B3F0378A7262758B900F3D30C9BA1B45561FC9C5DD45D1244FB3F534290B37DB60C207F567FA37DBE79C8811E4871D41418406B57D4349B9FDEE6E5D2C8055EA91D5E1BA7515082697EC074909795F426B90A33173CA7773D56AE3F991061536F69172F761BB07453D08FA358B6C977D2440AD55DBB8DDBA1D92F3B27040AC806934D2AA8BDDD73E7219C9430BF97FFFD4E417CA17225036040000,NULL,3,NULL,142363),
	(274850,2,0x1F8B08000000000000009D934F6FE23010C5EFFD1451EE24416DB5A51A8CB6D01548ABAA5A5AF56CC8905AF29FC876AA763FFD8E13420CE9692F68E6BD9F5F3213038B4F25930FB44E183D4FA7599126A8F7A614BA9AA7AF2FBF2677E9825D81B155D668E185C22CFC78BE93983923E968D688ECA773A2D20AB57FB678404B19B8D1073344DFA40CB4B1EA854E0786155901F999023B74FE69C48C54F0271FF2530DD61815AA4494F3F4C7EC6E9606BF57BBF43F7D77CC3DF5A0EDD637250DB034BAB5CF05F2D7DC9623E652246E6994121EC7EC7706F12BE13CA77D8DF8EF0CE2C31E7E9B3DBB6DA1BE23230C13CA9BA0F74D188C2B6C07957CFF64DA98DB76BEB17EA4DB550F6AD1D3173AD151370B54ECEEFC6EA39DB7A785C73D08B709178A4BE66D83900F3D082DBA0BC5DE92EBFBEBA24E1E57AFCB645AD0648307EF3C1CE9DFEB1873214650187504B522D468FD336A2EFD5777E76201BC310FA26A2F5B5781127A2BFE229B42DE97D03894E8DC9ACBC3DA34D6057EA44189B57FE0923E6BF7A0A807C53F57914DD9670254D63435AD9656C826D382805801575BE465177BAC43E436928716F2FFFD4BB37F87ADB1B434040000,NULL,3,NULL,142364),
	(274851,2,0x1F8B08000000000000009D93CB4EC3301045F77C45943D7988221E9A1A410B6A2584102D1FE036D360C98FC87610F0F5D84ED3B80D2B36D5CCBDC73799890B775F82279FA80D53729A9659912628B7AA62B29EA6EFEBA7F3EBF48E9C81D275D64A6699C0CCFF58BAE19819C5DDD1AC65D9BD31AC9602A57DD5B843ED327029776A889EA404A4D262ED4E7B86145901F991021B34F665C48C54B0071FF2430D5A29E1AB8455D3F4EAE6FA26F57EAF76E96F7DB7CF3DF420F5CAB6951B60A664B08F05E72FA8AE46CCA9E8B8991282591CB37F198E9F3363A9DBD788FFCB70BCDFC3B3DA92CB00F59D33FC30BE9C78BD6FFC6054601894D3ED8B0A319761BEB1BEA7C3AA07B5E8E913DDD15157062CB63776B394C6EAC3C6E31E9859FA1B4539B1BA45C8871E9864DD8D22EB64727B5134C9E3FC7D9694851B6DF0E083FA23FD8BED634EC408F2B38EA0204283DABEA2A4DC7E77972E16C02AF5C0EA70DBBA0A04932BF683A484BC2FA135C8D19805E5BB856AB5F1FC48830A1BFB40B9FBAEDD83A21E04FD9A47B6CB3E12A0D6AA6DDC6ADD0AC97959382056C0341A69D5C5EE6B1FB98AE4A185FCBFFF69F20B4DD31D6435040000,NULL,3,NULL,142365),
	(274852,2,0x1F8B08000000000000009D93CD4EEB301085F73C45943D69C28F285753236841AD8410BA2D0FE036D360C93F95ED20E0E919274DEA36ACD85433DF393EC94C5CB8FB5432F940EB84D193B4C8F23441BD31A5D0D5247D5B3D9D8FD33B7606C65659AD85170AB3F0E3F95A62E68CA4A3592DB27BE744A5156AFF6A718B963270A1B7E6107D9532D0C6AA159D0E1E9667398C8E08ACD1F997816740C1F73A8CFA1AAC312A54892827E9CDED789C06BDA36DFAFFAEDBE7F63D68BBF47549034C8D6EE46340FA9CDB72E03985E49B1AA584C7A1F73781FC33E13CA77D0DFCBF09E40F7B78361B76DD98BA8E84304C28AF02EF9A301857D80C2AF9E6C5343117CD7C43BE7737AB3ED0BC739F7072475DD1D86279EDD70BEDBCED371EF720DC22DC282E99B735C2E8D083D0A2BD516C95DCFCBBCC79F2387B9B26457E49B65E83771E8E742FB68F39819129CC3A3035107668FD2B6A2EFD577BE96200DE980751B1826E5B5B81127A29BE31A0AE84DAA144E7E65C6EE7A6B62E4C3C6050E2CE3F7049DFB57D50D483E29FB348A6EC23009535F58E564B2B64E7454E869880DB59E4651BBBAF43E432C28716467FFD4FB31FFBA20C3E35040000,NULL,3,NULL,142366),
	(274853,2,0x1F8B08000000000000009D93DD6EE2301085EFFB1451EE9B042DD5966A7055A02B905655B5D0073064482DF907D94ED5F6E93B4E083184ABBD4133E77C3EC94C0C3C7E2A997CA075C2E8693ACA8A3441BD33A5D0D5347DDBFCB9BD4F1FD90D185B65B5165E28CCC28FE75B899933928E66B5C89E9C139556A8FDABC53D5ACAC095DE9B3E7A9C32D0C6AA0D9D0E0C2BB202F23305B6E8FCCB8019A8E04F3EE4A71AAC312A548928A7E9EFC9FD240D7EA7B6E9FFBAEE987BEA41DBB5AF4B1A606E74639F0BE42FB92D07CCA548DCDC28253C0ED96B06F10BE13CA77D0DF86B06F1610F7FCD8EDD3550D791118609E538E85D1306E30A9B4125DFBD9826A641AEE847BA5975AF161D7DA1131D759340C5EED66F57DA797B5A78DC8370AB70A1B864DED60879DF83D0A2BD506C938C8A875F054F9E176F73AAE9BD7B13DE7938D3BDD831E7428CA030EB006A4438A0F5AFA8B9F45FEDA58B05F0C6CC44D5DCB6B60225F45A7C231B41DE95503B94E8DC92CBFDD2D4D6057EA04189073FE392BE6BFBA0A807C53F17914DD9670254D6D407DA2DED90DD8E0A026205DCC1222FDBD8631D22D791DCB790FFEF7F9AFD0019DD264A35040000,NULL,3,NULL,142367),
	(274854,2,0x1F8B08000000000000009D93CB6EDB301045F7FD0A41FBE88126A8538C1934760B1B0882A04ED0356D8D55027C18241524F9FA0E29CBA2ADACBA3166EE3DBCD28C68B87B53327B45EB84D1F3BC2EAA3C43BD338DD0ED3C7F79FE7535CBEFD81730B62D3A2DBC5058841FCFB7120B67241D2D3A51FC704EB45AA1F64F16F7682903D77A6FC6E8EB9C8136563DD3E9C0B0AAA8A03C53608BCE3F4E98890AFEE44379AAC11AA3429589669E7FBB9DDDE6C11FD43EFDF7D01D734F3D68BBF15D43032C8C8EF6B940FE8ADB66C25C8AC42D8C52C2E394FDCC207E299CE7B4AF09FF99417CD8C383D9B19B080D1D196198505E077D68C2605C611C54F2DDA389313771BEA97EA4E3AA47B51AE80B9DE8A4AB2396DA5BBF5D6BE7ED69E3690FC2ADC38DE29279DB2194630F428BFE46B13FD9ECFBD78A673F972F8BACAE68B4D183BF3C1C195EEC187321265098750245110E68FD136A2EFD7B7FE95201BC31F7A28DB7ADAF4009BD111FC86A2887123A87129D5B71B95F99CEBAC04F3468F0E0EFB9A4EFDA3F28E941F1B7656253F69900AD35DD81564B2B6457754540AA803B58E44D1F7BAC43E42691C716CAFFFD4FB37F63F601F735040000,NULL,3,NULL,142368),
	(274855,2,0x1F8B08000000000000009D93DD6EE2301085EFF729A2DC373FDAAE96AE06575BD81548ABAA5AE8031832A496FC13D94ED5F6E93B4E083184ABDEA099733E9F642606EEDF944C5ED13A61F43C2DB3224D50EF4D25743D4F9FB77F6F66E93DFB06C6D659AB85170AB3F0E3F94E62E68CA4A3592BB2DFCE895A2BD4FEC9E2012D65E05A1FCC187D9B32D0C6AA2D9D0E0C2BB202F2330576E8FCE38499A8E04F3EE4A71AAC312A5489A8E6E9CFBBD95D1AFC41EDD3FF0FDD31F7D483B61BDF5634C0C2E8CE3E17C85F715B4D984B91B885514A789CB2D70CE297C2794EFB9AF0D70CE2C31EFE993DFBD141434746182694B7411F9A301857D80D2AF9FED174311D72453FD2DDAA47B518E80B9DE8A89B052A76777EB7D6CEDBD3C2E31E845B870BC525F3B645C8C71E8416FD8562DB97A4FCF5BD68923FCBE7455216F4DEA3092F3C9C195EEC987321465098750275223468FD136A2EFD7B7FE96201BC310FA2EE6E5B5F81127A233E9095900F25B40E253AB7E2F2B032AD75819F685061E31FB8A4EFDA3F28EA41F1B7656453F69900B5356D43BBA51DB29BB2202056C0351679D5C71EEB10B989E4B185FCABFF69F609CE4C5DC335040000,NULL,3,NULL,142369),
	(274856,2,0x1F8B08000000000000009D93CB6EDB301045F7FD0A41FBE8812668528C192476031B2882A04E3E80B6C60A013E04922AD27E7D879465D15656DD1833F71E5E694634DC7F2899FD46EB84D18BBC2EAA3C43BD378DD0ED227F7B7DBABACDEFD91730B62D7A2DBC5058841FCF77120B67241D2D7A513C38275AAD50FB178B07B494811B7D3053F475CE401BAB5EE97460585554509E29B043E79F67CC4C057FF2A13CD5608D51A1CA44B3C8BFDDDDDEE5C11FD521FDD7D81D734F3D68BBF57D43032C8D8EF6B940FE9ADB66C65C8AC42D8D52C2E39CFDCC207E259CE7B4AF19FF99417CD8C34FB36737111A3B32C230A1BC0EFAD884C1B8C238A8E4FB6713636EE27C73FD48C7554F6A35D2173AD14957472CB5777EB7D1CEDBD3C6D31E84DB841BC525F3B64728A71E8416C38D624F59FDFD6BD5653F566FCBACAE68B4C983771E8E8C2F768CB9101328CC3A83A2081D5AFF829A4BFF67B874A900DE9847D1C6DB3654A084DE8ABFC86A28C7127A87129D5B7379589BDEBAC0CF3468B0F38F5CD2771D1E94F4A0F8C72AB129FB4C80D69ABEA3D5D20AD9555D11902AE03A8BBC19628F7588DC26F2D442F9BFFF69F60FAE6D9C0E35040000,NULL,3,NULL,142370),
	(274857,2,0x1F8B08000000000000009D93DD6EE2301085EFF729A2DC3784FEA8D96A70D5422B90AAAA2AF4010C19524BFE41B65375F7E93B4E483084ABDEA099EF1C9F642606EEBF954CBED03A61F4241D67799AA0DE9852E86A927EAC9E2F8AF49EFD0163ABACD6C20B8559F8F17C2D317346D2D1AC16D98373A2D20AB57FB3B8454B19B8D05B7388BE4E196863D58A4E070FCBB31C464704D6E8FCEBC033A0E07B1D467D0DD61815AA449493F4F66F51A441EF689BFEDE75FBDCBE076D97BE2E6980A9D18D7C0C489F735B0E3CA7907C53A394F038F49E13C83F13CE73DAD7C07F4E207FD8C38BD9B09BC6D47524846142791D78D784C1B8C26650C937AFA689B96CE61BF2BDBB59F581E69DFB84933BEA8AE08AD5B55F2FB4F3B65F78DC83708B70A1B864DED608A3430F428BF642B1D56752DC5DE53C799A7D4C93717E45BE5E844F1ECE742FB6CF39819129CC3A3035107668FD1B6A2EFDBFF6D2C500BC318FA26263BA6D6D054AE8A5F88F017525D40E253A37E7723B37B57561E401831277FE914BFAAEED83A21E14FF9E4532651F01A8ACA977B45BDA21BB18E7648809B89D455EB6B1FB3A442E237C6861F4DBFF34FB01018ADBA535040000,NULL,3,NULL,142371),
	(274858,2,0x1F8B08000000000000009D93DB4EEB301045DFF98A28EFA4091771D1D4E8D01ED44A8010850F709B698E255F22DB41C0D7334E9AD46D783A2FD5CCDADB3B99890B779F4A261F689D307A9A16599E26A837A614BA9AA6EF6F0FA7D7E91D3B0163ABACD1C20B8559F8F17C2D317346D2D1AC11D91FE744A5156AFF62718B963270A9B7661F7D9132D0C6AA373A1D3C2CCF72981C1058A3F3CF23CF88821F74980C35586354A812514ED3AB9BEBAB34E83DEDD25FFB6E973BF4A0EDCA37250D3033BA950F01E90B6ECB91E718926F6694121EC7DEDF04F2CF85F39CF635F2FF26903FECE1D16CD8656BEA3B12C230A1BC08BC6FC2605C613BA8E49B67D3C69CB7F38DF9CEDDAE7A4FF3DE7DC4C91D75456B8BE5B55F2FB5F376D878DC8370CB70A3B864DE3608937D0F428BEE46B1A7A438BB3DCFEBE4EFFC7D9614F919F90611FEF170A67FB35DCE118C4C61D891A98550A3F52FA8B9F45FDDAD8B017863EE45C50ABA6E5D054AE895F8C680FA121A87129D5B70B95D98C6BA30F2884189B5BFE7923E6CF7A0A807C53FE7914CD907002A6B9A9A764B3B64A7454E869880AB2DF2B28BDDD5217215E17D0B93FFFD53B31FE5E8C89036040000,NULL,3,NULL,142372),
	(274859,2,0x1F8B08000000000000009D93CD4EEB301085F73C45943D69C28F285753236841AD8410BA2D0FE036D360C93F95ED20E0E919274DEA36ACD85433DF393EC94C5CB8FB5432F940EB84D193B4C8F23441BD31A5D0D5247D5B3D9D8FD33B7606C65659AD85170AB3F0E3F95A62E68CA4A3592DB27BE744A5156AFF6A718B963270A1B7E6107D9532D0C6AA159D0E1E9667398C8E08ACD1F997816740C1F73A8CFA1AAC312A54892827E9CDED789C06BDA36DFAFFAEDBE7F63D68BBF47549034C8D6EE46340FA9CDB72E03985E49B1AA584C7A1F73781FC33E13CA77D0DFCBF09E40F7B78361B76DD98BA8E84304C28AF02EF9A301857D80C2AF9E6C5343117CD7C43BE7737AB3ED0BC739F7072475DD1D86279EDD70BEDBCED371EF720DC22DC282E99B735C2E8D083D0A2BD516C95DCFEBBCC79F2387B9B26457E49B65E83771E8E742FB68F39819129CC3A3035107668FD2B6A2EFD577BE96200DE980751B1826E5B5B81127A29BE31A0AE84DAA144E7E65C6EE7A6B62E4C3C6050E2CE3F7049DFB57D50D483E29FB348A6EC23009535F58E564B2B64E7454E869880DB59E4651BBBAF43E432C28716467FFD4FB31FEF7B9E2935040000,NULL,3,NULL,142373),
	(274860,2,0x1F8B08000000000000009D93CB6EDB301045F7FD0A41FBE8812468528C1934760B1B6883204E3E80B6C62A013E04922AD27E7D879465D15656DD1833F71E5E6946343CBC2B99FD46EB84D18BBC2EAA3C43BD378DD0ED227F7BFD7E75973FB04F606C5BF45A78A1B0083F9EEF2416CE483A5AF4A2F8EA9C68B542ED9F2D1ED052066EF4C14CD13739036DAC7AA5D3816155514179A6C00E9D7F9A313315FCC987F254833546852A13CD22FF7C7F779F077F5487F497B13BE69E7AD076EBFB8606581A1DED7381FC35B7CD8CB914895B1AA584C739FB9141FC4A38CF695F33FE2383F8B0871F66CF6E233476648461427913F4B1098371857150C9F74F26C6DCC6F9E6FA918EAB9ED46AA42F74A293AE8E586AEFFC6EA39DB7A78DA73D08B709378A4BE66D8F504E3D082D861BC57E66D75FAEAB2EFBB67A5B667545A34D1EFCE2E1C8F862C7980B3181C2AC33288AD0A1F5CFA8B9F47F864B970AE08D79146DBC6D43054AE8ADF88BAC86722CA17728D1B9359787B5E9AD0BFC4C83063BFFC8257DD7E141490F8ABFAF129BB2CF0468ADE93B5A2DAD905DD51501A902AEB3C89B21F65887C86D224F2D94FFFB9F66FF00F45B953335040000,NULL,3,NULL,142374),
	(274861,2,0x1F8B08000000000000009D93DF4EEA4010C6EF7D8AA6F796124DC493A1464103893146F001163AD44DF64FB3BB359EF3F46786D2B250AEBC21F37DDF6FA79DE9020F3F5A25DFE8BCB4669A8EB33C4DD06C6D294D354D3FD72FD793F4A1B802EBAAAC3132488D19FF04B1519879ABE868D6C8ECD17B59198D26BC3BDCA1A31EB8343B7B6C7D9B1660ACD36B3ACD4C9167398C4E1CD8A00F6F0366E042E87318F535386B3557892CA7E9DDFD649272DEB96DF78F4E1DFAF61A8C5B85A6A40166D6ECE35383F28570E5803937899B59AD65C0217B29207E2E7D10B4AF017F29209EF7F06AB7C51D339D209F67E1F296FD4EF05C42E37E4E25B66F361A6FE81FE8FDA62FD0673ED1E7549C6EC266697C70FDBE630DD22FF93E095504D7208C8E1AA491ED7D2AD6EBAF64FCE726AF93E7F9E72C19E73704F6297C093ED4BDD9A1D19919413CEC00DA9B50A30BEF68840A7FDB4B171B10AC7D925531A6DBD656A0A559C97FC8565742E351A1F70BA1760BDB38CF330F3C28B10E4F42D1776D1F1469D0E2671EC5D4FBC480CAD9A6A6E5D212398D25F8DAA128DB9E879AFBAD22FB2861F4DB3F74F11FAFDB49C632040000,NULL,3,NULL,142375),
	(274862,2,0x1F8B08000000000000009D93DD6EE2301085EFF729A2DC37841689EE6A48D5422B905655B5D0073064482DF927B29DAABB4FBF33840443B8EA0D9A73CEE7496662E0E14BABE4139D97D6CCD27196A7099A9D2DA5A966E9FBE6E5E63E7D287E807555D61819A4C68C7F82D82ACCBC5574346B64F6E8BDAC8C4613DE1CEED1510F5C99BD3DB59EA40518EBF4864E3353E4590EA33307B6E8C3EB8019B810FA1C467D0DCE5ACD5522CB593AFD793F4D39EFDCB6FB9F4E1DFBF61A8C5B87A6A401E6D61CE27383F2A570E580B934899B5BAD65C0217B2D207E217D10B4AF017F2D209EF7F0DBEE8A29339D209F67E172C27E27782EA1F130A712BB571B8D37F48FF461D357E80B9FE84B2A4EB761BB323EB87EDFB106E9577C9F842A826B1046270DD2C8F63E159BCD4732F97597D7C9F3E27D9E8CF35B02FB143E041FEADEECD8E8C28C201E76001D4CA8D18537344285BFEDA58B0D08D63EC9AA18D36D6B2BD0D2ACE53F64AB2BA1F1A8D0FBA550FBA56D9CE799071E94588727A1E8BBB60F8A3468F1B58862EA7D6640E56C53D37269899CC6127CED50946DCF63CDFDD6917D9230FAEE1FBAF80FC2FCDA7932040000,NULL,3,NULL,142376),
	(274863,2,0x1F8B08000000000000009D93CB6EC2301045F7FD8A28FB26414502AA21A8402B902A840A7C802143B0E407B29D8AF6EB6BE7012661D50D9A7BEFF124333130B970167CA3D2548A71D88B92304071901915F938DC6D3F9E87E1247D02A9F2A810D4508E91FB3164CF30D292D9A35141A337AD692E380AB3567844657BE0521CE5AD753F4C4148C5B7F6B463D2244A20BE73608FDAAC3A4CC70573CD21BED6A0A4E4AE0A68360E07A3E1287479E356DDBF1A55F7BD6A106A638ACC0E3093A28CEF0D9B2F88CA3A4CDBB4DC4C724E0D76D94781E5E7541B62F7D5E11F0596777BF8948774E0984658DFCDE2CABEF31BE1E6221CCB391939ACA4375ED7AFE972D30FE8966FE936E5A77BB35F0A6DD475DFBE06AA97EE3E11961A5520C4370D54D0EA3EA5DBED2918BCBE2424789FEF66412FB1B3DD52381177A879B3BA51CBF420376C072A4D38A3326B1484999FEAD2F9061829A7342F6F5B5501A762437F31ED41DC94506864A8F582B0E342164A3BBEE34186673325CC7ED7EA419E064E2E732FB6BDEF0CC8952CCE76B976892EF525E8B34292553DEBDAF5DB78F64D42FCDF3F74FA071F1C791532040000,NULL,3,NULL,142377),
	(274864,2,0x1F8B08000000000000009D93DF4EEA4010C6EF7D8AA6F796124DC493A1464103893146F001163AD44DF64FB3BB359EF3F46786D2B250AEBC21F37DDF6FA79DE9020F3F5A25DFE8BCB4669A8EB33C4DD06C6D294D354D3FD72FD793F4A1B802EBAAAC3132488D19FF04B1519879ABE868D6C8ECD17B59198D26BC3BDCA1A31EB8343B7B6C7D9B1660ACD36B3ACD4C9167398C4E1CD8A00F6F0366E042E87318F535386B3557892CA7E9DDFD649272DEB96DF78F4E1DFAF61A8C5B85A6A40166D6ECE35383F28570E5803937899B59AD65C0217B29207E2E7D10B4AF017F29209EF7F06AB7C51D339D209F67E1F296FD4EF05C42E37E4E25B66F361A6FE81FE8FDA62FD0673ED1E7549C6EC266697C70FDBE630DD22FF93E095504D7208C8E1AA491ED7D2AD6EBAFE4E64F9ED7C9F3FC73968CF31B02FB14BE041FEADEECD0E8CC8C201E7600ED4DA8D18577344285BFEDA58B0D08D63EC9AA18D36D6B2BD0D2ACE43F64AB2BA1F1A8D0FB8550BB856D9CE799071E94588727A1E8BBB60F8A3468F1338F62EA7D6240E56C53D37269899CC6127CED50946DCF43CDFD56917D9430FAED1FBAF80FB44B4B1E32040000,NULL,3,NULL,142378),
	(274865,2,0x1F8B08000000000000009D93DD6EE2301085EFF729A2DC37846D25DAD590AA855620ADAAAAD0073064482DF927B29DAAEDD3EF0C21C110AEF606CD39E7F324333170FFA555F289CE4B6BA6E938CBD304CDD696D254D3F47DFD7C759BDE17BFC0BA2A6B8C0C5263C63F416C1466DE2A3A9A35327BF05E5646A309AF0E77E8A8072ECDCE1E5BDFA40518EBF49A4E3353E4590EA3130736E8C3CB8019B810FA1C467D0DCE5ACD5522CB693AB9BB9DA49C776EDBFDAD5387BEBD06E356A12969809935FBF8D4A07C215C3960CE4DE266566B1970C85E0A889F4B1F04ED6BC05F0A88E73DFCB5DB62C24C27C8E759B8BC61BF133C97D0B89F5389ED8B8DC61BFA077ABFE90BF4994FF43915A79BB0591A1F5CBFEF5883F44BBE4F4215C13508A3A30669647B9F8AF5FA2319FFB9CEEBE469FE3E4BC6F96F02FB143E041FEADEECD0E8CC8C201E7600ED4DA8D18557344285EFF6D2C506046B1F65558CE9B6B515686956F207D9EA4A683C2AF47E21D46E611BE779E6810725D6E15128FAAEED83220D5A7CCDA3987A9F185039DBD4B45C5A22A7B1045F3B1465DBF35073BF55641F258CFEF70F5DFC03F0EE1E8632040000,NULL,3,NULL,142379),
	(274866,2,0x1F8B08000000000000009D93DD6E82401085EFFB1484FB0226266A3362AAB6D1A4314DD5075865C44DF687EC2E8DEDD377170457F0AA3766CE39DF0ECCB0C2ECC259F08D4A5329A6E1204AC200C5516654E4D370BF7B7F1E87B3F409A4CAA35250433946EEC79003C3484B668F46258D5EB5A6B9E028CCA7C2132ADB03D7E2246FAD87610A422ABEB3A71D93265102F19D0307D466D3637A2E983687B8AD4149C95D15D06C1A8E26E349E8F2C6ADBB7F35EADAB7D520D4D694991D60214515DF1B365F1195F598AE69B985E49C1AECB38F02CB2FA936C4EEABC73F0A2CEFF6F0218FE9C8318DB0BE9BC59543E737C2CD453856733272DC486FBCBE7FA5AB4D3FA03BBEA5BB949F1ECC612DB451EDBE7D0D54AFDD7D222C35AA44886F1AA8A0F57D4A77BB733079491212BC2DF78B6090D8D96E299C893BD4BCD9B551C7F420376C0FAA4C2850994F1484999FFAD2F9061829E734AF6E5B5D01A7624B7F311D40DC94506A64A8F58AB0D34A964A3BBEE7418685991366BF6BFD204F032797A517DBDE7706E44A96855DAE5DA24B7D09BA5048B2BAE7B576FDB69E7D9310FFF70F9DFE01FD4D054332040000,NULL,3,NULL,142380),
	(274867,2,0x1F8B08000000000000009D93DD6EE2301085EFF729A2DC6F082A526935A46A6157205555B5C0031832A496FC13D9CEAABB4FDF194282215CF506CD39E7F3243331F0F4A955F2179D97D6CCD27196A7099ABD2DA5A966E976F3FBE7347D2A7E807555D61819A4C68C7F82D829CCBC5574346B64F6ECBDAC8C4613DE1D1ED0510F5C99833DB79EA40518EBF4864E3353E4590EA30B0776E8C3DB8019B810FA1C467D0DCE5ACD5522CB597AFF309DA69C776EDBFD4FA74E7D7B0DC6AD4353D200736B8EF1A541F952B872C05C9BC4CDADD632E090BD1510BF903E08DAD780BF1510CF7B78B5FBE29E994E90CFB3703961BF133C97D0789C5389FD9B8DC61BFA27FAB8E91BF4954FF43515A7BBB05B191F5CBFEF5883F42BBE4F4215C13508A3B30669647B9F8ACDE623993CDEE575F26BB19D27E3FC8EC03E850FC187BA373B35BA322388871D4047136A74E11D8D50E15F7BE9620382B52FB22AC674DBDA0AB4346BF91FD9EA4A683C2AF47E29D461691BE779E6810725D6E14528FAAEED83220D5A7C2EA2987A5F185039DBD4B45C5A22A7B1045F3B1465DBF35473BF75649F258CBEFB872EBE009DC98D3932040000,NULL,3,NULL,142381),
	(274868,2,0x1F8B08000000000000009D93DF4EEA4010C6EF7D8AA6F796624CD093A1464103893146F001163AD44DF64FB3BB359EF3F46786D2B250AEBC21F37DDF6FA79DE9020F3F5A25DFE8BCB4669A8EB33C4DD06C6D294D354D3FD72FD777E9437105D655596364901A33FE0962A330F356D1D1AC91D9A3F7B2321A4D7877B843473D706976F6D8FA362DC058A7D7749A9922CF72189D38B0411FDE06CCC085D0E730EA6B70D66AAE12594ED3C9FDDD24E5BC73DBEE1F9D3AF4ED3518B70A4D4903CCACD9C7A706E50BE1CA01736E1237B35ACB8043F65240FC5CFA20685F03FE52403CEFE1D56E8B09339D209F67E1F296FD4EF05C42E37E4E25B66F361A6FE81FE8FDA62FD0673ED1E7549C6EC266697C70FDBE630DD22FF93E095504D7208C8E1AA491ED7D2AD6EBAF647CF327CFEBE479FE394BC6F90D917D0C5F824F75AF76E8746646104F3B80F626D4E8C23B1AA1C2DFF6D6C506046B9F64558CE9BAB515686956F21FB2D595D07854E8FD42A8DDC236CEF3D0030F4AACC39350F461DB07451AB4F8994731F53E31A072B6A969BBB4454E6309BE7628CAB6E7A1E67EABC83E4A18FDF61F5DFC07179552F433040000,NULL,3,NULL,142382),
	(274869,2,0x1F8B08000000000000009D93DD4EC2401085EF7D8AA6F796624C5033D428682031C6083EC04287BAC9FE90DDAD519FDE194ACB42B9F286CC39E7DB6967BAC0FDB756C9173A2FAD19A7C32C4F13346B5B4A538DD38FE5F3E54D7A5F5C807555561B19A4C68C7F825829CCBC557434AB65F6E0BDAC8C4613DE1C6ED0510F9C9B8D3DB4BE4E0B30D6E9259D66A6C8B31C06470EACD087D71ED3732174390CBA1A9CB59AAB4496E374747B334A396FDDA6FB7BABF67D3B0DC62D425DD200136B76F1B141F94CB8B2C79C9AC44DACD632609F3D17103F953E08DA578F3F1710CF7B78B1EB62C44C2BC8E759B8BC66BF153C97D0B89B5389F5AB8DC6EBFB7B7AB7E933F4894FF42915A7ABB09A1B1F5CB7EF5883F473BE4F4215C1D5088383066964739F8AE5F233B9BDCB73913C4D3F26C930BF22B04BE153F0A1F6CDF68D4ECC08E2617BD0CE842DBAF08646A8F0D35CBAD88060EDA3AC8A21DDB6A6022DCD42FE225B6D09B54785DECF84DACC6CED3CCFDCF3A0C46D78148ABE6BF3A0488316DFD328A6DE470654CED65B5A2E2D91D35882DF3A1465D3735F73BF45641F240CFEFB872EFE009C89186032040000,NULL,3,NULL,142383),
	(274870,2,0x1F8B08000000000000009D93DD4EC2401085EF7D8AA6F7B6251A4133AC51D040628C117C80850E7593FD21BB5BA33EBDB32D858572E50D9973CEB7D3CE7481FB6F25932FB44E183D4E07599126A8D7A614BA1AA71FCBE7CB517ACF2EC0D82AABB5F04261167E3C5F49CC9C917434AB45F6E09CA8B442EDDF2C6ED0520F9CEB8D39B4BE4E196863D5924E0786155901F991032B74FEB5C7F45CF0FB1CF27D0DD61815AA4494E374783BBA49D9E5A020A40BDA07BC776AD77AAF41DB85AF4B9A616274131F1B94CFB82D7BCCA949DCC428253CF6D97301F153E13CA795F5F87301F161152F66CD06C300758A82304C1304BF136130AEB01954F2F5AB89E6EBFB3BBAD9F619FAC427FA948AD3955FCDB5F376BFF0588370F370A7B864DED608F94183D0A2BD536CB9FC4C867757054F9EA61F936450D06C87143E7938D4BDD9AED189194161D81ED498B045EBDF5073E97FDA8B171BE08D79145573E3DA0A94D00BF18BEC1AF2AE84DAA144E7665C6E66A6B68E8D20EF7950E2D63F72491FB67D50A441F1EF691453EF23032A6BEA2D2D979618D25882DB5AE465DB7357877E8BC83E48C8FFFBA7667F04445D3B36040000,NULL,3,NULL,142384),
	(274871,2,0x1F8B08000000000000009D934B4FEB301085F7FC8A287BD2042AF1D034085A502B014214C4DA6DA6C1921F91ED20B8BFFE8EF3AADBB06253CD7CE7F8243371E1E65B8AE80B8DE55ACDE22C49E308D556175C95B3F8FDEDE1F432BEC94F409B32A915775C62E27F1CDB084CAC167434A979726B2D2F9544E55E0CEED05006AED44EEFA3A7710E4A1BF946A7BD274F93142607043668DDF3C833A2E0061D26430D466BE9AB8817B3F8E2EAF222F67A4FDBF4D7BEEB72871E9459BBBAA001E65A35F221207DC94C31F21C43F2CDB594DCE1D8FB9B40FE05B78ED1BE46FEDF04F2FB3D3CEA6D9E35A6BE23C10FE3CBA9E77DE30763129B4105DB3EEB60BE31EFDCCDAAF734EBDD479CDCC7AE50DDB8CD4A59678685873D70BBF2178A89DC991A61B2EF812BDE5EA8FCE9E3219A5E9FA75574BF789F47597A46C641854FE60FF56FD6051DC1C0E4871D991A08151AF7828A09F7D3DEBA1080D3FA8E977EC2AE02C9D59AFF438FFA126A8B02AD5D32B15BEADA583FF388418195BB63823E6CFBA0A007C9BE17814CD907004AA3EB8A964B4BCC4FB3940C21015B1964451BDBD53E721DE07D0B93BFFEA9F3FFD4E4202136040000,NULL,3,NULL,142385),
	(274872,2,0x1F8B08000000000000009D93CD4EEB301085F73C45943D692290285753236841AD040851106BB799064BFEA96C07014F7FC74993BA4D576CAA99733E9F64262EDC7C2B997CA175C2E8495A64799AA05E9B52E86A92BEBF3D9C8FD31B7606C65659AD85170AB3F0E3F94A62E68CA4A3592DB25BE744A5156AFF627183963270A137661F7D9932D0C6AA373A1D189667398C0E1458A1F3CF0366A082EF7D18F535586354A812514ED2ABEBF1380D7EA7B6E9AF5DB7CBED7BD076E9EB9206981ADDD88702F9736ECB01732C1237354A098F43F69441FC4C38CF695F03FE94417CD8C3A359B3A281BA8E8C304C282F83DE356130AEB01954F2F5B389E61BEA3BBA59F509FA4827FA988ADD955F2DB4F3B65F78DC83708B70A1B864DED608A37D0F428BF642B1A78F87E4EADF45CE93FBD9FB3429F20B027B173E7938D4BDD92EE8488CA030EC006A44D8A2F52FA8B9F43FEDAD8B05F0C6DC898A1574DDDA0A94D04BF18B41EA4AA81D4A746ECEE5666E6AEBC2CC030D4ADCFA3B2EE9C3B60F8A7A50FC7B16D9947D2040654DBDA5E5D212D9799113102BE0B61679D9C6EEEA10B98CE47D0BA3BFFEA9D97FE995B17B36040000,NULL,3,NULL,142386),
	(274873,2,0x1F8B08000000000000009D934F6FE23010C5EFFB29A2DC1B1251A96C35B86AA11548BB55B5B4EAD99021B5E43F91EDACBAFBE93B4E483084532F68E6BD9F5F321303779F4A267FD13A61F43C2DB23C4D50EF4C2974354FDF5E9FAE66E91DFB01C65659A385170AB3F0E3F95662E68CA4A35923B27BE744A5156AFF62718F963270ADF7E6187D9D32D0C6AA573A1D189667394C4E14D8A2F3CF2366A4821F7C980C35586354A81251CED39B9FB3591AFC5EEDD2FFF4DD2177E841DB8D6F4A1A6061746B9F0AE4AFB82D47CCB948DCC228253C8ED94B06F14BE13CA77D8DF84B06F1610FBFCC8E152DD47764846142791DF4BE09837185EDA092EF9E4D34DF583FD0EDAA2FD0673AD1E754EC6EFD76AD9DB7C3C2E31E845B870BC525F3B641981C7B105A74178AFD7E7F4AA6B7D3BC4E1E976F8BA4C8A7040E2E7CF070A87FB343D099184161D811D48A50A3F52FA8B9F4FFBA5B170BE08D7910152BE8BA751528A137E23F06A92FA17128D1B91597FB9569AC0B338F3428B1F60F5CD287ED1E14F5A0F8E732B229FB4480CA9AA6A6E5D212D9559113102BE06A8BBCEC620F7588DC44F2B185C977FFD4EC0B75810D6136040000,NULL,3,NULL,142387),
	(274874,2,0x1F8B08000000000000009D935B4FE3301085DFF91551DEC985455A4053236817B5D282102DDA67B799662DF912D90E82FDF58C93A6759B3EED4B3573CEE793CCC485FB4F25930FB44E183D49CBAC4813D41B53095D4FD2F7D5D3E54D7ACF2EC0D83A6BB5F04261167E3C5F4BCC9C9174346B45F6E09CA8B542ED5F2D6ED152062EF4D61CA2AF5306DA58B5A2D381614556407EA4C01A9D7F19312315FCDE877C5F833546852A11D524FD797B739B067F50FBF4B7A1DBE5EE7BD076E9DB8A06981ADDD9C702F9736EAB11732A1237354A098F63F69C41FC4C38CF695F23FE9C417CD8C36FB36165070D1D196198505E077D68C2605C6137A8E49B1713CD37D67774B7EA33F4894EF42915BB6BBF5E68E7ED7EE1710FC22DC285E29279DB22E4871E8416FD8562CF7F9E92F2EAEE47D124BF66EFD3A42C68B8830D7F793835BCDA2EE9448CA030ED08EA4468D0FA57D45CFAAFFEDAC50278631E45DDDDB7BE0225F452FC4356423E94D03A94E8DC9CCBEDDCB4D6057EA441858D7FE492BE6CFFA0A807C53F67914DD94702D4D6B40D6D97B6C82ECB82805801D758E4551FBBAB43E432920F2DE4FFFBAF66DF11E1515737040000,NULL,3,NULL,142388),
	(274875,2,0x1F8B08000000000000009D93CD4EEB301085F73C45943D69229028686A042DA89500210ABA6BB799064BFEA96C07014FCF386952B7E9EA6EAA99733E9F64262EDC7E2B997CA175C2E8495A64799AA05E9B52E86A927EBC3F9E8FD35B7606C65659AD85170AB3F0E3F94A62E68CA4A3592DB23BE744A5156AFF6A7183963270A137661F7D9932D0C6AA773A1D189667398C0E1458A1F32F0366A082EF7D18F535586354A812514ED2ABEBF1380D7EA7B6E96F5DB7CBED7BD076E9EB9206981ADDD88702F9736ECB01732C1237354A098F43F69441FC4C38CF695F03FE94417CD8C39359B3A281BA8E8C304C282F83DE356130AEB01954F2F58B89E61BEA3BBA59F509FA4827FA988ADD955F2DB4F3B65F78DC83708B70A1B864DED608A37D0F428BF642B1E77F8FC9F8E622E7C9C3EC639A14F90581BD0B9F3C1CEADE6C177424465018760035226CD1FA57D45CFA9FF6D6C5027863EE45C50ABA6E6D054AE8A5F8C5207525D40E253A37E7723337B57561E68106256EFD3D97F461DB07453D28FE3D8B6CCA3E10A0B2A6DED2726989ECBCC8098815705B8BBC6C637775885C46F2BE85D1FFFEA9D91F255AF6E536040000,NULL,3,NULL,142389),
	(274876,2,0x1F8B08000000000000009D93CB4EC3301045F77C45943D7908241E9A1A410B6A2540888258BBCD3458F2A3B21D047C3DE3A469DDA62B36D5CCBDC73799890B37DF4A265F689D307A9496599126A897A612BA1EA5EF6F0FA797E90D3B0163EBACD1C20B8559F8F17C21317346D2D1AC11D9AD73A2D60AB57FB1B8424B1938D32BB38B3E4F196863D51B9D0E0C2BB202F23D0516E8FCF38019A8E0B73EE4DB1AAC312A5489A846E9C5D5E5551AFC5EEDD25FFB6E93BBED41DBB96F2A1A606C746BEF0BE44FB9AD06CCA148DCD828253C0ED96306F113E13CA77D0DF86306F1610F8F66C9CA16EA3B32C230A13C0F7ADF84C1B8C27650C997CF269A6FA86FE876D547E8039DE8432A76177E31D3CEDBEDC2E31E849B850BC525F3B641C8773D082DBA0BC59E3E1E92B2B83E2B78723F791F534DC3ED6CF8E4E154FF6A9BA4033182C2B403A815618DD6BFA0E6D2FF74D72E16C01B7327EAF6BE751528A1E7E2175909795F42E350A273532E5753D35817F8810615AEFD1D97F465BB07453D28FE3D896CCADE13A0B6A659D376698BECB42C088815706B8BBCEA623775889C47F2AE85FCBFFF6AF607DF8FF1CF37040000,NULL,3,NULL,142390),
	(274877,2,0x1F8B08000000000000009D934B4FEB301085F7FC8A287BF210485034358216D44A801005DDB5DB4C83253F2ADB41C0AF679C34ADDB747537D5CC399F4F3213176EBF954CBED03A61F4382DB3224D50AF4C25743D4E3FDE1FCFAFD35B7606C6D659A385170AB3F0E3F95262E68CA4A35923B23BE744AD156AFF6A718D963270AED7661F7D9932D0C6AA773A1D18566405E4070A2CD1F997013350C1EF7CC87735586354A812518DD3ABD1F5280D7EAF76E96F7DB7CDDDF5A0EDC237150D3031BAB50F05F267DC5603E658246E6294121E87EC2983F8A9709ED3BE06FC2983F8B08727B362650BF51D196198505E06BD6FC2605C613BA8E4AB1713CD37D4B774BBEA13F4914EF43115BB4BBF9C6BE7ED6EE1710FC2CDC385E29279DB20E4FB1E8416DD8562CFFF1E93D1CD45C19387E9C724290B9A6DEFC2270F87FA37DB061D891114861D40AD081BB4FE153597FEA7BB75B100DE987B51B7D7ADAB4009BD10BFC84AC8FB121A87129D9B71B99E99C6BAC00F34A870E3EFB9A40FDB3D28EA41F1EF696453F68100B535CD86964B4B64E7654140AC80DB58E45517BBAD43E42292F72DE4FFFBA7667F77F113BE36040000,NULL,3,NULL,142391),
	(274878,2,0x1F8B08000000000000009D93CB4EC3301045F77C45943D7908241E9A1A410B6A2540888258BBCD3458F2A3B21D047C3DE3A469DDA62B36D5CCBDC73799890B37DF4A265F689D307A9496599126A897A612BA1EA5EF6F0FA797E90D3B0163EBACD1C20B8559F8F17C21317346D2D1AC11D9AD73A2D60AB57FB1B8424B1938D32BB38B3E4F196863D51B9D0E0C2BB202F23D0516E8FCF38019A8E0B73EE4DB1AAC312A5489A846E9C5D5E5551AFC5EEDD25FFB6E93BBED41DBB96F2A1A606C746BEF0BE44FB9AD06CCA148DCD828253C0ED96306F113E13CA77D0DF86306F1610F8F66C9CA16EA3B32C230A13C0F7ADF84C1B8C27650C997CF269A6FA86FE876D547E8039DE8432A76177E31D3CEDBEDC2E31E849B850BC525F3B641C8773D082DBA0BC59E3E1E92B2BC3E2B78723F791F276541C3ED6CF8E4E154FF6A9BA4033182C2B403A815618DD6BFA0E6D2FF74D72E16C01B7327EAF6BE751528A1E7E2175909795F42E350A273532E5753D35817F8810615AEFD1D97F465BB07453D28FE3D896CCADE13A0B6A659D376698BECB42C088815706B8BBCEA623775889C47F2AE85FCBFFF6AF6070799244637040000,NULL,3,NULL,142392),
	(274879,2,0x1F8B08000000000000009D93CB4EC3301045F77C45943D69029578681A445B502B014214C4DA6DA6C1921F91ED20E0EB19274DE336ACD85433F71EDF64262EDC7C49117DA2B15CAB499C25691CA1DAE882AB7212BFBDDE9F5EC637F909685326B5E28E4B4CFC8F636B8189D5828E26354F6EADE5A592A8DCB3C12D1ACAC0A5DAEA3E7A1CE7A0B491AF74DA33799AA4303A50608DD63D0D98810A6EEFC3685F83D15AFA2AE2C524BEB8BABC8ABDDFA96DFA4BD7ED72F73D28B372754103CCB46AEC4381FC0533C5803916899B6929B9C321FB9741FC9C5BC7685F03FE2F8378BF8707BDC9B306EA3A32FC30BE1C7BBD6BFC604C6233A8609B271DCC37D47774B3EA5ECD3AFA4827FA980ADDB55B2F957566BFF0B0076E97FE4231913B53238CFA1EB8E2ED85CA1FDFEFA3B3EBF3B48AEEE66FB3284B69B6DE850FE60F756FB60B3A1203C80F3B801A112A34EE191513EEBBBD75A1004EEB292F9BEBD65620B95AF11FF4437725D416055ABB6062BBD0B5B19E1F685060E5A64CD0876D1F14F420D9D73CB029FB4080D2E8BAA2E5D212F3D32C252054C0560659D1C6EE6A1FB90AE4BE85D17FFFD4F92FEC0D082336040000,NULL,3,NULL,142393),
	(274880,2,0x1F8B08000000000000009D934F4FE33010C5EFFB29A2DC49138144594D8DA005B51220B405EDD96DA6C192FF44B683804FBFE3A449DDA6A7BD5433EFFDFC9299B870FBA564F289D609A3676991E569827A6B4AA1AB59FAFEF678314D6FD92F30B6CA1A2DBC5098851FCF37123367241DCD1A91DD39272AAD50FB578B3BB494812BBD3387E8AB94813656BDD1E9C0B03CCB6172A4C0069D7F19312315FCE0C364A8C11AA342958872965EDF4CA769F07BB54BFFD377FBDCA1076DD7BE296980B9D1AD7D2C90BFE4B61C31A7227173A394F03866CF19C42F84F39CF635E2CF19C4873D3C992D2B5AA8EFC808C384F22AE87D1306E30ADB4125DFBE9868BEB1BEA7DB559FA14F74A24FA9D8DDF8CD4A3B6F8785C73D08B70A178A4BE66D833039F420B4E82E147BFEFB9814BF2FF33A7958BCCF9322BF247070E1838743FD9BED834EC4080AC38EA056841AAD7F45CDA5FFEE6E5D2C8037E65E54ACA0EBD655A0845E8B1F0C525F42E350A2734B2E774BD35817661E695062EDEFB9A40FDB3D28EA41F1AF456453F6910095354D4DCBA525B28B22272056C0D51679D9C5EEEB10B98EE4430B93FFFD53B37F84AAD6A936040000,NULL,3,NULL,142394),
	(274881,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE29254A043394086820318608C4F34287BAC93EC8EED6A8BFDED9BE28D4939766BEC77EDB994E61FA2545F089C672AD26E1208AC300D541A75C659370B77DEE8DC2697203DA6451AEB8E31223FF706C2F30B25AD0D128E7D1A3B53C5312955B1B3CA2A10C5CA9A33E47DF8509286DE4964E7B4F124731F42F18D8A375AF1D4F8705D7E8D06F6A305A4B5F053C9D84F7E3F16D98F40631596AA1BCE0AD4655748341998DCB53EA61AE55215F12A42F99493B9E6B927C732D2577D8F5FE25907FC1AD6334B28EFF2F81FC7E142FFA900C0B538D48F0CDF872E0F91AF8C698C4A251C10EAFBA881916FD75F9CA5D4CFBCCC6B5FB8A27F775665BDDBBFD4A59679A81B73170BBF23BC544E24C8ED03F63E08A973B95BC07A387DB98054F8BDD3C18C423B2351A7C307FA47EAF2AE68A6C997CAB1D5341C2098D5BA362C27D976BD726C0693DE359B16F650592AB0DFF413FE9BA84DCA2406B974C1C973A37D6FB3B1CA478723326E8B39617B53048F6B568C9947D414066747EA2D1D208ABE56E33604F06595AC656B58FDCB4E83384FE7FFFEAE417D8DD8D7537040000,NULL,3,NULL,142395),
	(274882,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE534AD008662811D040628811FC80850E6593BD90DDAD41BFDED95E68A13EF9D2CCB9ECD9CE740AD3B314C1171ACBB59A8483280E03547B9D72954DC2CFED6B6F144E933BD0268B72C51D9718F987633B8191D5828E46398F9EADE59992A8DCBBC1031ACAC0953AE826FA3E4C406923B774DA7B92388AA17FC5C00EAD5B773C1D16DC4587FEA506A3B5F455C0D349F8381E0FC3A43788C9520BE5051F35AAA22F1894D9B83CA51EE65A15F23541FA9299B4E3B925C937D75272875DEF5F02F917DC3A4623EBF8FF12C8EF47F1A6F7C94361AA1109BE195F0E3C5F03DF189358342AD87EAD8B9851D15F97AFDCC5B41B36AEDD373CB96F33DBEACEED56CA3A7319781B03B72BBF534C24CEE408FD060357BCDCA9647B0CC64FC398052F8BCF793088E98E468423F367EA17AB726EC896C9F7DA3115249CD0B877544CB8EF72EFDA0438AD673C2B16AEAC4072B5E13FE8475D97905B1468ED9289C352E7C67A7F8783144F6EC6047DD7F2A21606C9CE8B964CD957046446E7279A2DCDB0DAEE3603F66490A5656C55FBC84D8B6E20F4FFFB5B27BF5BA3652F38040000,NULL,3,NULL,142396),
	(274883,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE5B5A9578C950A32081C41823F0010B1DEA267B6976B746FD7A677BA3509E7C69E65CF66C673A85C76F29822F34966B350993280E03543B9D71954FC2CD7A7E79173EA617A04D1E958A3B2E31F20FC7B60223AB051D8D4A1E3D59CB732551B977837B3494814BB5D787E89B3005A58D5CD369EF49E32886D111035BB4EE6DE019B0E03A1D465D0D466BE9AB806793F0F6FEFE3A4C2F93982CAD505FF0D1A226BAC3A0CCCA9519F530D5AA928F09D217CC6403CF2949BEA996923B1C7ACF09E49F71EB188D6CE03F2790DF8FE255EFD271656A1109BE195F269E6F816F8C49AC1A156CF7A6AB9871D5DF906FDCD5B40F6CDCBA4F78729F66F6D5ADDB2E9575A61B781F03B74BBF534CA4CE9408A30306AE78BD53E93C48AE1EAEE32278996DA64112DF91AF13E193F933ED8B35392764CFE47B1D982A120A34EE1D1513EEA7DEBB3E014EEB679E570B575720B95AF15FF4A36E4B282D0AB476C1C47EA14B63BD7FC04186857B6682BE6B7D510F8364DFB39E4CD94704E4469705CD9666D86C779F015B1864591DDBD43E72D5A30F1046FFFDADD33FBF46863438040000,NULL,3,NULL,142397),
	(274884,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE53DAA811CC50A3A081C41023F0010B1DEA267B21BB5B837EBDB3BDD04279F2A59973D9B39DE9149E8E5204DF682CD76A1226511C06A8763AE32A9F849BF5DB60143EA537A04D1E158A3B2E31F20FC7B60223AB051D8D0A1E3D5BCB732551B90F837B3494810BB5D76DF45D9882D246AEE9B4F7A47114C3F08C812D5AB7EC797A2CB8930EC3530D466BE9AB806793F0613CBE0DD3411293A511AA0B3E1B54479F3028B37245463D4CB52AE57382F4393359CF7349926FAAA5E40EFBDE6B02F967DC3A4623EBF9AF09E4F7A378D7BBF4BE34358804DF8C2F13CF37C037C624968D0AB65BEA326654F6D7E76B7739ED968D1BF7054FEECBCCAEBA75DB85B2CE9C06DEC5C0EDC2EF1413A93305C2B0C5C015AF762A7D0B92E4F13666C1EB6C330D9298EE6845F862FE4CF36275CE05D931F95E7BA69284031AF7818A09F753ED5D9700A7F50BCFCB85AB2A905CADF82FFA5137251416055A3B67623FD785B1DEDFE320C3837B6182BE6B7551078364C75947A6EC330272A38B03CD9666586F7797017B30C8B22AB6AE7DE4AA43B71086FFFDADD33F8C39EEE238040000,NULL,3,NULL,142398),
	(274885,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE5B8A68BC64A811D040620811F880850E7593BD34BB5BA37EBDB3BDD04279F2A59973D9B39DE9149EBFA508BED058AED5381C467118A0DAEB94AB6C1C6E376FD70FE1737205DA6451A1B8E31223FF706C2730B25AD0D1A8E0D18BB53C5312955B193CA0A10C5CA8836EA36FC30494367243A7BD2789A31806270CECD0BA65CFD363C11D75181C6B305A4B5F053C1D87F78F8FA330B91EC6646984EA828F06D5D1470CCAAC5D91520F53AD4AF994207DCE4CDAF39C93E49B6A29B9C3BEF79240FE19B78ED1C87AFE4B02F9FD28DEF53EB92B4D0D22C137E3CBA1E71BE01B6312CB4605DB2F7519F350F6D7E76B7739ED968D1BF7194FEEF3CCAEBA73BB85B2CE1C07DEC5C0EDC2EF1413893305C2A0C5C015AF762AD904374FA3380F5E67DB69308CE98A56834FE68F34EF55C79C911D936FB5672A49C8D1B8152A26DC4FB5765D029CD6139E95FB565520B95AF35FF4936E4A282C0AB476CEC461AE0B63BDBFC7418AB99B30419FB5BAA88341B2EF5947A6EC130232A38B9C464B23AC97BBCB80CD0DB2B48AAD6B1FB9EED02D84C17FFFEAE40FDF1322AE37040000,NULL,3,NULL,142399),
	(274886,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE6D4BD40866A811D0406288118DE7850E75937D90DDAD417FBDB37D433D7969E67BECB79DE914EE8F52045F682CD76A1A8EA2240C50ED74C6553E0DDFDF9E2EC7E17D7A01DAE451A1B8E31223FF706C2B30B25AD0D1A8E0D183B53C5712957B31B8474319B8527BDD455F8729286DE41B9DF69E348912884F18D8A275EB8167C0826B7588DB1A8CD6D25701CFA6E1ED647215A697A3842C8D505DF0DAA03ABAC5A0CCC61519F530D7AA944F09D297CC6403CF3949BEB996923B1C7AFF12C8BFE0D6311AD9C0FF97407E3F8A67BD4B6F4A538348F0CDF872E4F906F8C698C4B251C1766B5DC68CCBFE867CED2EA7DDB149E33EE3C97D9ED957B76EBB52D69976E07D0CDCAEFC4E31913A5320C41D06AE78B553E94730B9BB4A58F0B8789F07A384AEE834F864FE48F35E75CC19D933F95607A69284031AF7828A09F75DAD5D9F00A7F58CE7E5BE551548AE36FC07FDA49B120A8B02AD5D32B15FEAC258EF1F7090E1C1CD98A0CF5A5DD4C320D971D19329FB8480DCE8E240A3A511D6CBDD67C01E0CB2AC8AAD6B1FB9E9D11D84F8BF7F75FA0B7B5AF73637040000,NULL,3,NULL,142400),
	(274887,2,0x1F8B08000000000000009D534B4F834010BEFB2B087729448DD64C31DA6ADAC434C6D6785ECA1437D907D95D8CFAEB9DE55168F1E485CCF7D86F996180BB2F29824F34966B350B93280E03543B9D7355CCC2B7EDD3F94D78979E8136455429EEB8C4C83F1CCB0446560B3A1A553CBAB796174AA2722F06F7682803576AAFFBE8CB3005A58DDCD269EF49E32886C91103195AB71E79462CB8830E93430D466BE9AB80E7B3F07A3ABD08D3F324264B273417BC76A88D3E605066E3AA9C7A986B55CBC704E94B66F291E79424DF5C4BC91D8EBD7F09E45F70EB188D6CE4FF4B20BF1FC5B3DEA557B5A94324F8667C9978BE03BE3126B16E54B0DD5AD73137757F63BE75D7D3EED9B8739FF0E43ECD1CAA99CB56CA3A7318F81003B72BBF534CA4CE5408931E0357BCD9A9F43D486E2FE232785CBCCD8324A62B7A0D3E983FD2BD571B73420E4CBED591A926A144E35E5031E1BE9BB51B12E0B47EE045BD6F4D0592AB0DFF413FE9AE84CAA2406B974CEC97BA32D6FB471CE458BA0726E8B336170D3048F6B518C8947D4440617455D2686984ED720F19B0A5419637B16DED233703BA8730F9EF5F9DFE0202BC02F337040000,NULL,3,NULL,142401),
	(274888,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE5B5A2F11CD5023A081C41023F8010B1DEA267B6976B706FD7A677BA185FAE44B33E7B2673BD3293C1EA408BED058AED5244CA2380C50ED74C6553E093F362F97E3F031BD006DF2A854DC7189917F38B61518592DE86854F2E8C95A9E2B89CABD19DCA3A10C5CAABDEEA26FC21494367243A7BD278DA31846270C6CD1BAD5C03360C11D75181D6B305A4B5F053C9B8477F7F7D7617A99C4646985FA82F71635D1470CCAAC5D99510F33AD2AF994207DC14C36F09C93E49B6929B9C3A1F72F81FC736E1DA3910DFC7F09E4F7A378D5BBF4B632B58804DF8C2F13CFB7C037C624568D0AB65BE92A665CF537E41B7735ED8E8D5BF7194FEEF3CCBEBA75DBA5B2CE1C07DEC7C0EDD2EF1413A93325C2A8C3C015AF772ADD7C06C9D5C3755C04CFF38F5990C47449A7C227F387DA376B82CEC89EC9373B3055241468DC1B2A26DC77BD787D029CD6539E571B575720B95AF31FF4B36E4B282D0AB476C1C47EA14B63BD7FC04186859B32411FB6BEA88741B2C3BC2753F60901B9D16541C3A52136EBDD67C016065956C736B58F5CF7E80EC2E8BFFF75FA0BB3635D8C39040000,NULL,3,NULL,142402),
	(274889,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE2925687C642811D040628C118CE7850E75937D34BB5BA3FE7A67FB867AF2D2CCF7D86F3BD329CCBFA4083ED158AED52C9C447118A03AE894AB6C16BEED1E4737E13CB9006DB2A850DC7189917F38B61718592DE86854F0E8DE5A9E2989CABD183CA2A10CDCA8A3EEA22FC30494367247A7BD2789A318C6270CECD1BAE78167C0826B7518B73518ADA5AF029ECEC2EBDBDB69988C2631591AA1BAE0B54175748B4199AD2B52EA61A955299F12A4AF9949079E73927C4B2D257738F4FE25907FC5AD6334B281FF2F81FC7E144FFA905C95A60691E09BF1E5C4F30DF08D318965A3821D9E75197353F637E46B7739ED8E8D1BF7194FEEF3CCBEBA77FB8DB2CEB403EF63E076E3778A89C4990261DC61E08A573B95BC0793F86E1AB3E061F5B6A49AEEE844F860FE4CF36275CE19D933F95E07A692841C8D7B41C584FBAEF6AE4F80D37AC1B372E1AA0A24575BFE837ED44D09854581D6AE9938AE7561ACF70F384831770B26E8BB5617F53048F6B5EAC9947D4240667491D36C6986F576F719B0B9419656B175ED23B73DBA8330FEEF6F9DFC024CBF8A2F38040000,NULL,3,NULL,142403),
	(274890,2,0x1F8B08000000000000009D53DB4E8340107DF72B08EF521A355633C568AB6913638C6D3F602953DC642F647731D5AF77964BA1E0932F64CE65CF32C3000F4729822F34966B350FA7511C06A8F63AE32A9F87BBEDCBE52C7C482E409B3C2A15775C62E41F8EA50223AB051D8D4A1E3D5ACB732551B97783073494816B75D05DF4759880D2466EE9B4F7247114C3E48C8114AD7B1B79462CB8930E93530D466BE9AB8067F3F0F6EEEE2A4C2EA731595AA1BEE0A3454DF40983321B5766D4C342AB4A3E27485F31938D3C43927C0B2D257738F6FE25907FC9AD6334B291FF2F81FC7E14AF7A9FDC54A61691E09BF1E5D4F32DF08D318955A382EDDF741533ABFA1BF38DBB9A76C7C6AD7BC0937B98D9575397AE9575E634F03E066ED77EA798489C2911261D06AE78BD53C936B8BDBF8A59F0BCDC2D82694C57741A7C327FA47DAF266640F64CBED591A922A140E3DE5131E1BEEBB5EB13E0B47EE279B56F750592AB0DFF413FE9B684D2A2406B574C1C56BA34D6FB471C6458B82726E8B3D617F53048765CF664CA3E232037BA2C68B434C266B9FB0CD8C220CBEAD8A6F6919B1EDD4198FCF7AF4E7E019B114B3D37040000,NULL,3,NULL,142404),
	(274891,2,0x1F8B08000000000000009D93DD6EE2301085EFFB1451EE49C21675DBD5E0AA855620ADAA6A81073064482DF927B29D55DBA7DF7142C010AEF6269A39E7F3383399C0E3A792C95FB44E183D4DC7599126A877A614BA9AA69BF5EBE83E7D6437606C95355A78A1300B0FCFB7123367241DCD1A913D39272AAD50FB778B7BB45403977A6F4EA52729036DAC5AD3E9C0B0222B203F53608BCEBF0D98810AFEE8437E8CC11AA3429488729AFE7CB8BF4BD9685C10D21BDD057FFAEC50FA9883B62BDF94D4C3CCE8D63E17C85F705B0E984B91B899514A781CB2D70CE2E7C2794E231BF0D70CE2C3287E9B1D9BB4509F91119A09E138E87D121AE30ADB4625DFBD99A8BFA17EA0DB695FA12F74A22FA9D8DDFAED523B6F8F038F73106E19768A4BE66D83909F72105A743BC5D6EB8FE4C7AFDBA24E5EE69B59322EA8B7930B1F3C1CEADFEC50E8428CA0D0EC006A45A8D1FA77D45CFAAF6EF16201BC31CFA26A37AE8B4009BD12DFC82690F721340E253AB7E072BF308D75811F685062ED9FB9A40FDB5D14E5A0F8E73CB2A9F6990095354D4DC3A521B2D16D58EF5801575BE46557F6108792AB483EA590FFEF7FCDFE01C6B9668E39040000,NULL,3,NULL,142405),
	(274892,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE5B8A684033942868203184087EC04287B2C95EC8EED6A85FEF6C6F14CA932FCD9CCB9EED4CA730F99622F84263B956E3B01FC561806AA753AEB271F8B979BB1D8593E406B4C9A25C71C72546FEE1D8566064B5A0A351CEA3676B79A6242AB732B8474319B8507B7D8ABE0F1350DAC80D9DF69E248E62E89D31B045EB961D4F8705D7E8D06B6A305A4B5F053C1D87C3C7C74198DCF663B2D44279C1478DAAE80683326B97A7D4C354AB423E27489F3393763C9724F9A65A4AEEB0EBBD26907FC6AD6334B28EFF9A407E3F8A77BD4BEE1EBCA94624F8667CD9F77C0D7C634C62D1A860BBA52E6206457F5DBE7217D33EB171EDBEE0C97D99D956B76EBB50D69966E06D0CDC2EFC4E3191389323F44E18B8E2E54E259B43307C1AC42C789D7D4E837E3C225F23C281F933F58B55391764CBE47BED980A128E68DC0A1513EEA7DCBB36014EEB179E150B575620B95AF35FF4A3AE4BC82D0AB476CEC47EAE7363BDBFC3418A47F7C2047DD7F2A21606C9BE672D99B2CF08C88CCE8F345B9A61B5DD6D06ECD1204BCBD8AAF691EB167D82D0FBEF6F9DFC0136BFBABD38040000,NULL,3,NULL,142406),
	(274893,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE5B8A681433940868205142043F60A143DD642F64776BD4AF77B6370AE5C99766CE65CF76A653187F4B117CA1B15CAB51D88FE23040B5D32957D928FCD8BC5C3F84E3E40AB4C9A25C71C72546FEE1D8566064B5A0A351CEA3276B79A6242AB732B8474319B8507B7D8CBE0D1350DAC80D9DF69E248E62E89D30B045EB961D4F8705D7E8D06B6A305A4B5F053C1D85F7C3E1204CAEFB31596AA1BCE0BD465574834199B5CB53EA61AA55219F12A4CF99493B9E73927C532D2577D8F55E12C83FE3D6311A59C77F4920BF1FC5ABDE253777DE5423127C33BEEC7BBE06BE3126B16854B0DD52173183A2BF2E5FB98B691FD9B8769FF1E43ECF6CAB5BB75D28EB4C33F036066E177EA798489CC9117A470C5CF172A792B760F8388859F03CFB9806FDF8816C8D069FCC1FA9DFAB8A39235B26DF6AC754907040E356A898703FE5DAB509705A4F7856EC5B5981E46ACD7FD14FBA2E21B728D0DA3913FBB9CE8DF5FE0E07291EDC8409FAACE5452D0C927DCF5A32659F1090199D1F68B434C26AB9DB0CD883419696B155ED23D72DFA08A1F7DFBF3AF903EE8D6D5E37040000,NULL,3,NULL,142407),
	(274894,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE535AD178C950A3A081C41022F0010B1DEA267B21BB5BA37EBDB3BD51284FBE34732E7BB6339DC2D3B714C1171ACBB51A8749148701AA9DCEB8CAC7E166FD36B80F9FD22BD0268F0AC51D9718F987635B8191D5828E46058F9EADE5B992A8DCD2E01E0D65E05CEDF531FA264C416923D774DA7BD2388A6178C2C016AD5BF43C3D165CABC3B0ADC1682D7D15F06C1CDE3D3C8CC27490C4646984EA828F06D5D12D066556AEC8A8878956A57C4A903E6326EB79CE49F24DB494DC61DF7B4920FF945BC768643DFF2581FC7E14EF7A975EDF7A538348F0CDF832F17C037C634C62D9A860BB852E6346657F7DBE7697D33EB271E33EE3C97D9ED955B76E3B57D69976E05D0CDCCEFD4E31913A53200C8F18B8E2D54EA5EB20491E47310B5EA79B4990C4F7E46B45F864FE4CF36275CE19D931F95E7BA69284031AB744C584FBA9F6AE4B80D3FA85E7E5C2551548AE56FC17FDA89B120A8B02AD9D31B19FE9C258EFEF7190E1C1BD3041DFB5BAA88341B2EF6947A6EC130272A38B03CD9666586F7797017B30C8B22AB6AE7DE4AA431F210CFFFB5BA77F7A74DE9938040000,NULL,3,NULL,142408),
	(274895,2,0x1F8B08000000000000009D934B4FEB301085F7F75744D9930720D17B35358216D44A5C842888B5DB4C83253F2ADB41C0AF679C34ADDB74C5A69A39E7F34966E2C2F5A792C9075A278C1EA76556A409EA95A984AEC7E9EBCBFDD928BD667FC0D83A6BB4F04261167E3C5F4ACC9C9174346B4476E39CA8B542ED9F2CAED15206CEF5DAECA32F5306DA58F542A703C38AAC80FC4081253AFF3860062AF89D0FF9AE066B8C0A5522AA717AF577344A83DFAB5DFA73DF6D73773D68BBF04D45034C8C6EED4381FC19B7D5803916899B18A584C7217BCA207E2A9CE7B4AF017FCA203EECE1C1AC58D9427D47461826941741EF9B301857D80E2AF9EAD144F30DF52DDDAEFA047DA4137D4CC5EED22FE7DA79BB5B78DC8370F370A1B864DE3608F9BE07A14577A1D8FFB7FBA42CFF5D143CB99BBE4E92B2A0E1F636BCF370AA7FB56DD291184161DA01D48AB041EB9F5073E9BFBA6B170BE08DB915757BDFBA0A94D00BF18DEC1CF2BE84C6A144E7665CAE67A6B12EF0030D2ADCF85B2EE9CB760F8A7A50FC731AD9947D20406D4DB3A1EDD216D9D9794140AC80DB58E45517BBAD43E42292F72DE4BFFD57B31F5FEC8D4437040000,NULL,3,NULL,142409),
	(274896,2,0x1F8B08000000000000009D935B4FC2401085DFFD154DDF29454CBC6458A2A081448D118CCF0B1DEA267B6976B746FDF5CEB6B414EA932F64E69C6F4F3BD305A65F4A469F689D307A128F92348E506F4D26743E89DFD60F83AB78CACEC0D83C29B5F04261127E3CDF484C9C917434294572EB9CC8B542ED5F2CEED052062EF5CE1CA22F6206DA58B5A6D381616992C2F048810D3AFFDC637A2AF8D687615B833546852A12D924BEBCBEBA8C83DFA875FA6BD3ED73DB1EB45DF932A301664657F6B140FE82DBACC79C8AC4CD8C52C2639FFDCB207E2E9CE7B4AF1EFF97417CD8C3A3D9B25105351D196198508E83DE346130AEB01A54F2EDB3A96246D57C7D7D4F57AB3EA869439FE8449F6676DD8DDF2CB5F3B65D78B707E196E14271C9BC2D1186871E8416F585624FEF0FD1F8669C16D1FDFC6D168DD273025B173E7838D4BCD93EE844EC4061D81E548950A0F52FA8B9F4DFF5ADEB0AE08DB9137975DDEA0A94D02BF1838CDEA729A17428D1B90597BB8529AD0B7C4F830C0B7FC7257DD8FA419D1E14FF9A776CCA3E1220B7A62C68B9B44436384F09E82AE00A8B3CAB63F775885C75E4430BC3FFFEA9D92FAF13045936040000,NULL,3,NULL,142410),
	(274897,2,0x1F8B08000000000000009D53C94EC33010BDF31551EEA4890051D034085A502B0142B47C80D34C83252F95ED20E0EB19676FD3139768DEE2E7CC640277DF52045F682CD76A1626511C06A8B63AE7AA98851F9BA7F36978979E813645542AEEB8C4C83F1CCB0446560B3A1A953CBAB796174AA2726F0677682803576AA7FBE8CB3005A58DDCD069EF49E32886C90103195AF73AF28C58709D0E93AE06A3B5F455C0F359787D737311A6E7494C9656A82F786F5113DD615066EDCA9C7A986B55C98704E94B66F291E79824DF5C4BC91D8EBDA704F22FB8758C4636F29F12C8EF47F1ACB7E955656A1109BE195F269E6F816F8C49AC1A156CFBAAAB9869D5DF986FDCD5B47B366EDD473CB98F33876AE6B295B2CE74031F62E076E5778A89D4991261D263E08AD73B95BE04D3DB8B98058F8B8F7990C47445AFC127F347DAF76A628EC881C9B73A325524ECD1B837544CB89F7AED860438AD1F7851ED5B5D81E46ACD7FD14FBA2DA1B428D0DA2513BBA52E8DF5FE110739EEDD0313F459EB8B061824FB5E0C64CA3E20A030BADCD3686984CD720F19B07B832CAF639BDA47AE07740F61F2DFBF3AFD03643A4DFF37040000,NULL,3,NULL,142411),
	(274898,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE2D45348A196A043490184244E379A143DD641FCDEED6A8BFDED93E68A19CBC34F33DF6DBCE740A0FDF52045F682CD76A120EA3380C50ED74CA553609DFDF9E2FEFC287E402B4C9A24271C72546FEE1D8566064B5A0A351C1A3476B79A6242AB736B8474319B8547BDD465F8709286DE41B9DF69E248E62181C31B045EB563D4F8F0577D06170A8C1682D7D15F07412DE8EC7A330B91CC6646984EA82D706D5D1070CCA6C5C91520F33AD4AF998207DC14CDAF39C92E49B6929B9C3BEF79C40FE39B78ED1C87AFE7302F9FD285EF42EB9294D0D22C137E3CBA1E71BE01B6312CB4605DBAD74197357F6D7E76B7739ED968D1BF7094FEED3CCAEBA75DBA5B2CE1C06DEC5C0EDD2EF1413893305C2A0C5C015AF762AF908AEEE47711E3CCDDF67C130A62B5A0D3E993FD2BC571D7342764CBED59EA9242147E3D6A898703FD5DA7509705A4F7956EE5B5581E46AC37FD14FBA29A1B028D0DA0513FB852E8CF5FE1E0729E66ECA047DD6EAA20E06C9BEE71D99B28F08C88C2E721A2D8DB05EEE2E033637C8D22AB6AE7DE4A643B71006FFFDAB933F2B810CB237040000,NULL,3,NULL,142412),
	(274899,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE534AD078C95022A081448D11FC80850E7593BD34BB5BA37EBDB3BD437DF2A59973D9B39DE914E65F52049F682CD76A164EA2380C501D74CA55360BDF778FA39B709E5C8036595428EEB8C4C83F1CDB0B8CAC1674342A78746F2DCF9444E55E0D1ED150066ED45177D19761024A1BB9A3D3DE93C4510CE31306F668DDCBC03360C1B53A8CDB1A8CD6D257014F67E1F5EDED344C4693982C8D505DF0D6A03ABAC5A0CCD61529F5B0D4AA944F09D2D7CCA403CF3949BEA596923B1C7AFF12C8BFE2D6311AD9C0FF97407E3F8A277D48AE4A538348F0CDF872E2F906F8C698C4B251C10E2FBA8CB92AFB1BF2B5BB9C76C7C68DFB8C27F779665FDDBBFD465967DA81F73170BBF13BC544E24C8130EE3070C5AB9D4A9E83EBBB69CC8287D5FB3298C437646B35F860FE48F35E75CC19D933F95607A692841C8D7B45C584FBAED6AE4F80D37AC1B372DFAA0A24575BFE837ED24D09854581D6AE9938AE7561ACF70F384831770B26E8B35617F53048F6B5EAC9947D4240667491D3686984F572F719B0B9419656B175ED23B73DBA8330FEEF5F9DFC02D364A5AB37040000,NULL,3,NULL,142413),
	(274900,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE2925687C642811D040628C118CE7850E75937D34BB5BA3FE7A67FBA2B49EBC34F33DF6DBCE740AF32F29824F34966B350B27511C06A80E3AE52A9B856FBBC7D14D384F2E409B2C2A14775C62E41F8EED0546560B3A1A153CBAB796674AA2722F068F68280337EAA84FD19761024A1BB9A3D3DE93C4510CE33306F668DDF3C03360C1B53A8CDB1A8CD6D257014F67E1F5EDED344C4693982C8D505DF0DAA03ABAC5A0CCD61529F5B0D4AA94CF09D2D7CCA4034F9F24DF524BC91D0EBD7F09E45F71EB188D6CE0FF4B20BF1FC5933E2457A5A94124F8667C39F17C037C634C62D9A86087675DC65C95FD0DF9DA5D4EFBC4C68DBBC793BB9FD955F76EBF51D69976E05D0CDC6EFC4E31913853208C4F18B8E2D54E25EFC1F5DD3466C1C3EA6D194CE21BB2B51A7C307FA479AF3AA647764CBED581A9242147E35E5031E1BEABB5EB12E0B45EF0ACDCB7AA02C9D596FFA09F7453426151A0B56B268E6B5D18EBFD030E52CCDD8209FAACD5451D0C927DAD3A32659F1190195DE4345A1A61BDDC5D066C6E90A5556C5DFBC86D873E4118FFF7AF4E7E011412CAEB37040000,NULL,3,NULL,142414),
	(274901,2,0x1F8B08000000000000009D53DB6E8240107DEF5710DE8B589B689B1153B58D268D31553F60951137D98BD95D1ADBAFEF2C08A2F8D41732E7B2879D6180D1498AE01B8DE55A0DC36E148701AA9D4EB9CA86E166FDF1380847C903689345B9E28E4B8CFCC3B1ADC0C86A4147A39C476FD6F24C49546E69708F863270AEF6FA12FD1C26A0B4916B3AED3D491CC5D0B962608BD62D5A9E160BAED6A153D760B496BE0A783A0CFB2F837EE8F58A2DD3BF2A74CEAD3128B372794A0D4CB42AE46B82F4193369CB734B926FA2A5E40EDBDE7B02F9A7DC3A46F36AF9EF09E4F773F8D4BBA4DBF7A60A91E09BF165CFF315F08D318945A382ED16BA88E916FDB5F9B3BB18F5858D2BF70D4FEEDBCCA6BA75DBB9B2CED4036F62E076EE178A89C4991CA173C1C0152F172A59AF0F41FFB517B3E07DBA9904DDF8898CB50A07E60F55373B07DD900D936FB6652A4838A2714B544CB89F72EB9A0438ADC73C2BD6ADAC4072B5E2BF98D07DAA12728B02AD9D31B19FE9DC58EF6F7190E2D18D99A00F5BBEA88141B2D3B42153F6150199D1F991864B43F46A13823D1A64699979AE7DDEAA415F2074FEFB47277F5005318E33040000,NULL,3,NULL,142415),
	(274902,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE2D454D503394286820514204E279A143DD641F64776BD05FEF6C5F14CAC94B33DF63BFEE4CA7303A48117CA3B15CAB61D88FE23040B5D52957D9305CAF5EAFEFC3517205DA6451AEB8E31223FF706C2330B25AD0D128E7D193B53C5312955B18DCA1A10C9CA99D3E46DF8509286DE48A4E7B4F124731F44E18D8A075F38EA7C3826B74E8353518ADA5AF029E0EC3C1C3FD20F47ACD96E91F35AA721B0CCA2C5D9E520363AD0AF994207DCA4CDAF19C93E41B6B29B9C3AEF79240FE09B78ED1BC3AFE4B02F9FD1CDEF436E90FBCA94624F8667C79EBF91AF8C698C4A251C1B6735DC4F48BFEBA7CE52E467D64E3DA7DC693FB3CB3AD6EDC66A6AC33CDC0DB18B89DF9856222712647E81D3170C5CB854ADE3F5F837EFC781BB3E065B21E537D43CE46862FE64FD557AB92CEC896C977DB311524ECD1B8052A26DC4FB9766D029CD6CF3C2BF6ADAC4072B5E4BF98D07DEA12728B02AD9D32B19BEADC58EFEF7090E2DE3D33415FB67C510B836487494BA6EC130232A3F33D4D97A6E8D53604BB37C8D232B3AA7DDEB2451F21F4FEFB4B277F6EF8219534040000,NULL,3,NULL,142416),
	(274903,2,0x1F8B08000000000000009D93CD6EC2301084EF7D8A28F726A12095564B508122905A840AA8674396D4927F22DBA9689FBE7642C0104EBDA09D99CF9BECC6C0F0C059F08D4A53290661274AC200C54E6654E48370B39EDEF7C3617A0752E55129A8A11C23F763C89661A425B347A392462F5AD35C701466A9708FCAF6C0B9D8CB73EB5E9882908AAFED69C7A44994407CE1C016B559B498960BE694437CAA4149C95D15D06C103E3EF5FBA1CB1BB7EEFED1A863DF9306A156A6CCEC006329AAF8D2B0F98CA8ACC55C9B961B4BCEA9C1367B2BB0FC846A43ECBE5AFCADC0F26E0F6F7297762AA8513670C3B8B2EBFC46B8C108C76A5046760BE9CDD7F68F74B5EA1BF4956F694F751CE5A75BB39D0B6DD469E1BE06AAE7EE4211961A5522C4670D54D0FA42A5EF9FD3A0F7DC4D8AE075B219079DC4CE764EE18BB843CD9B1D1B5D991EE4866D419509052AB3444198F9A96F9D6F80917244F3EABAD515702A56F417D307889B124A8D0CB59E11B69FC95269C7B73CC8B03023C2EC87AD1FE469E0E430F162DBFBC2805CC9B2B0CBB54B74A92F41170A4956F73CD6AEDFCAB3CF12E2FFFEA3D33F37E892D233040000,NULL,3,NULL,142417),
	(274904,2,0x1F8B08000000000000009D93CD6EEA301085F7F729A2EC49828A5AEED5E0AA855620555575A1EADA9021B5E41F643B55DBA7EF38216008AB6EA299733E8F339309DC7E2A997CA075C2E8493ACC8A3441BD31A5D0D5247D5D3D0EC6E92DFB03C65659AD85170AB3F0F07C2D317346D2D1AC16D99D73A2D20AB57FB1B8454B3570A1B7E6587A9432D0C6AA159D0E0C2BB202F21305D6E8FC738FE9A9E00F3EE48718AC312A44892827E9CDDFF175CA06C38290CE682FF8DF65FBD2871CB45DFABAA41EA64637F6A940FE9CDBB2C79C8BC44D8D52C2639FBD64103F13CE731A598FBF64101F46F164366CD4405D4646682684C3A07749688C2B6C1A957CF36CA2FEFAFA9E6EA67D813ED3893EA76277EDD70BEDBC3D0C3CCE41B845D8292E99B735427ECC4168D1EE147B7B4CC6FFAE0A9E3CCC5EA7C9B0A0D68E26BCF370A67BB17D9D33318242AF3DA8116187D6BFA0E6D27FB57B170BE08DB91755B3706D044AE8A5F8463682BC0BA17628D1B93997DBB9A9AD0B7C4F831277FE9E4BFAAEED45510E8A7FCE229B6A9F08505953EF68B6344336B80ADB1D2BE0761679D996DDC7A1E432928F29E4BFFDADD90F21EFED2F38040000,NULL,3,NULL,142418),
	(274905,2,0x1F8B08000000000000009D93DD4EC2401085EF7D8AA6F796A2268A196A143490A831020FB0A543DD647F9ADDAD419FDED9FED042B9F286CC39F3ED6967BAC0C35E8AE01B8DE55A4DC371148701AAADCEB8CAA7E166FD7279173E2417A04D1E958A3B2E31F23F8EA50223AB051D8D4A1E3D5ACB732551B90F833B3494814BB5D35DF44D9880D246AEE9B46792388A6174E4408AD6BD0F98810BAEAD2EC731010709466BE9AB8067D3F07632B90A1BA46DD4CFF86C55937ED0A0CCCA95198D31D3AA6A1F1BD45F30930D985393B89996923B1CB2E71AC4CFB9758CB636E0CF3588F7DB78D5DBE4C633AD20DFCFE2CBB1F75BE1E76212AB3905DBBEEB2AA542CEF80D5DEDBB73E3963EF1893ECDEC7753972E9575E6B0EFBE066E97FE5631913853228C3A0D5CF1FA56256FC1F5FD755C04CFF3CD2C18C7B7841D7AF0C5FC91F6BD9A9813B307F9510750654281C67DA062C2FDD417AF6F80D3FA89E77E82A602C9D58AFFA21FB92DA1B428D0DA0513BB852E8DF5FCC0830C0BF7C4047DD5FA413D0D92EDE7BD36651F19901B5D16B45A5A6173B7FB0ED8C220CBEAD8A6F691AB9EDD4918FDF77F9DFC01D7EE84B439040000,NULL,3,NULL,142419),
	(274906,2,0x1F8B08000000000000009D93DD4EC2401085EF7D8AA6F79656491433D40868205162041E60A143DD647F9ADDAD519FDED9FE40A15C7943E69CF9F6B4335DE0F15B8AE00B8DE55A8DC3248AC300D54E675CE5E370B37EB9BE0F1FD32BD0268F4AC51D9718F91FC7B60223AB051D8D4A1E3D59CB732551B977837B3494810BB5D7C7E8619882D246AEE9B467D2388A6170E2C016AD5BF6989E0BAEADAE9398808304A3B5F455C0B37178371ADD840DD236EA677CB4AA493F685066E5CA8CC6986A55B54F0DEACF99C97ACCB949DC544BC91DF6D94B0DE267DC3A465BEBF1971AC4FB6DBCEA5D3AF44C2BC8F7B3F832F17E2BFC5C4C6235A760BBA5AE522AE482DFD0D5BE8F6EDCD2673ED1E799DDEED66D17CA3A73D8775703B70B7FAB98489D291106470D5CF1FA56A56F41F2701B17C1F36C330D92F88EB0430F3E993FD2BE5713736676203F6A0FAA4C28D0B877544CB89FFAE2750D705A4F78EE27682A905CADF82FFA91DB124A8B02AD9D33B19FEBD258CFF73CC8B0701326E8ABD60FEA6890EC7BD66953F68901B9D16541ABA5153677BBEB802D0CB2AC8E6D6A1FB9EAD8470983FFFEAFD33F26C55F7C39040000,NULL,3,NULL,142420),
	(274907,2,0x1F8B08000000000000009D93DD4EC2401085EF7D8AA6F794A22488194A0434902831020FB0D0A16EB23F64776BD0A777B63F502857DE903967BE3DED4C17181FA508BED158AED528EC457118A0DAE994AB6C146ED6AF9DC7709CDC813659942BEEB8C4C8FF38B61518592DE86894F3E8D95A9E2989CA7D18DCA3A10C5CA8BD3E47F7C3049436724DA73D93C4510CDD0B07B668DDB2C5B45C7075D5E9C5049C2418ADA5AF029E8EC2C170781F5648DD289FF159AB2AFDA4419995CB531A63AA55D1BE34A83F67266D31D72671532D2577D8666F35889F71EB186DADC5DF6A10EFB7F1A67749DF33B520DFCFE2CB9EF76BE1E762128B3905DB2D7591522037FC8A2EF67D76E39ABEF289BECE6C76B76EBB50D699D3BE9B1AB85DF85BC544E24C8ED03D6BE08A97B72A790F864F0F310B5E669B69D08B07849D7AF0C5FC91FABDAA982BB301F9515B5061C2018DFB40C584FB292F5ED300A7F584677E82AA02C9D58AFFA21FB92E21B728D0DA3913FBB9CE8DF57CCB83140F6EC2047DD5F2410D0D921D678D36655F1890199D1F68B5B4C2EA6E371DB007832C2D63ABDA47AE1AF65942F7BFFFEBE40F5F23AAB939040000,NULL,3,NULL,142421),
	(274908,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABED316AF6886250A1A48D418D10F58E85037D90BD9DD1AF5EB9D6D292DD4275F9A39973DDB994E61F2A564F489D609A3C7F130C9E208F5DAE44217E3F8FDED61308A27EC048C2D92520B2F1426E1E1F94A62E28CA4A34929925BE744A1156AFF627183963270A137A68D3E8F196863D51B9D0E1E962519A4070CACD0F9E79EA7C782DFEB90EE6BB0C6A85045221FC757D7A3CB980D8619591AA1BEE0B541BBE83D066D97BECCA987A9D1957C48903EE736EF798E49F24D8D52C263DFFB9740FE99709ED3C87AFEBF04F287513C9A35BBA84C0D22213413CA61E01B101AE30AAB46255F3F9B2AE6B4EAAFCFEFDCD5B45B366BDC473CB98F33BBEACAAF16DA79BB1F781783708BB0535C326F4B84B4C520B4A8778A3D45A39BB38C47F7B3F76934CCA8B356830F1E8E34EFB58B39223BA6D06ACF5491B045EB5F5073E9BFEBB5EB12E08DB91345B56F75054AE8A5F841760E695342E950A273732E3773535A17FC3D0E72DCFA3B2EE9B3D617753028FE35EBC8947D4040614DB9A5D1D20883DA85E0B616795E67EEEA90B7ECD02D84F4BFBF34FB051A4FBAB234040000,NULL,3,NULL,142422),
	(274909,2,0x1F8B08000000000000009D53DB6E8240107DEF5710DE8B589B689B1153B58D268D31553F60951137D98BD95D1ADBAFEF2C08A2F8D41732E7B2879D6180D1498AE01B8DE55A0DC36E148701AA9D4EB9CA86E166FDF1380847C903689345B9E28E4B8CFCC3B1ADC0C86A4147A39C476FD6F24C49546E69708F863270AEF6FA12FD1C26A0B4916B3AED3D491CC5D0B962608BD62D5A9E160BAED6A153D760B496BE0A783A0CFB2F837EE8F58A2DD3BF2A74CEAD3128B372794A0D4CB42AE46B82F4193369CB734B926FA2A5E40EDBDE7B02F9A7DC3A46F36AF9EF09E4F773F8D4BBA4DBF7A60A91E09BF165CFF315F08D318945A382ED16BA88E916FDB5F9B3BB18F5858D2BF70D4FEEDBCCA6BA75DBB9B2CED4036F62E076EE178A89C4991CA173C1C0152F172A59AF0F41377EEDC52C789F6E26543F91B396E1C0FCA9EA6AE7A41BB261F2DDB64C050947346E898A09F753AE5D9300A7F59867C5BE951548AE56FC1713BA4F55426E51A0B53326F6339D1BEBFD2D0E523CBA3113F465CB17353048769A3664CABE2220333A3FD274698A5E6D42B047832C2D33CFB5CF5B35E80B84CE7F7FE9E40FC3D4A8A734040000,NULL,3,NULL,142423),
	(274910,2,0x1F8B08000000000000009D93DB6EE2301086EFF729A2DC93838ABADDD5E0AA855620ADAA6AA10F60C8905AF221B29D55DBA7DF7142C010AE7A13CDFCFFE771663281FB0F25937F689D307A9696599126A877A612BA9EA56F9BE7C95D7ACF7E80B175D66AE185C22C3C3CDF4ACC9C9174346B45F6E09CA8B542ED5F2DEED1520D5CE9BD39959EA60CB4B16A43A703C38AAC80FC4C812D3AFF3262462AF8A30FF931066B8C0A5122AA59FAF3D7DD6DCA266541C860F417FC1DB243E9630EDAAE7D5B510F73A33BFB5C207FC96D35622E45E2E64629E171CC5E33885F08E7398D6CC45F33880FA3F863766CDA4143464668268465D0872434C615768D4ABE7B31517F63FD4077D3BE425FE8445F52B1BBF5DB9576DE1E071EE720DC2AEC1497CCDB16213FE520B4E8778A6D36EF49F9FBA66892A7C5DB3C290BEAEDE4C23B0F8786373B14BA102328343B823A111AB4FE153597FEB35FBC58006FCCA3A8BB8DEB235042AFC517B229E44308AD4389CE2DB9DC2F4D6B5DE0471A54D8F8472EE9C3F617453928FEB1886CAA7D26406D4DDBD07069886C7213D63B56C0351679D5973DC4A1E43A924F29E4DFFDAFD97FEF8468CF39040000,NULL,3,NULL,142424),
	(274911,2,0x1F8B08000000000000009D93DD4EC2401085EF7D8AA6F7B6454D4433AC51D040A2C6083EC04287BAC9FE90DDAD519FDED996C242B9F286CC39E7DB6967BAC0DDB792C9175A278C1EA583AC4813D42B530A5D8DD28FC5D3F930BD6367606C95D55A78A1300B3F9E2F2566CE483A9AD522BB774E545AA1F66F16D768A907CEF4DAEC5B5FA50CB4B16A41A703C38AAC80FCC081253AFFDA637A2EF85D0EF9AE066B8C0A5522CA517A7D331CA621EFDCB6FB7BA7B67D771AB49DFBBAA401C64637F1A141F994DBB2C71C9BC48D8D52C2639F3D15103F11CE73DA578F3F15101FF6F06C56ECAA813A454118269497C1EF44188C2B6C06957CF56AA2F9FAFE966E567D823EF2898ED4205071BAF4CB9976DEEE161E6B106E162E1497CCDB1A21DF6B105AB4178ABD3C2537B797054F1E271FE36450D068FB103E7938D3BDD8B6CF91194161D61ED498B041EBDF5073E97FDA4B171BE08D79105573DBDA0A94D073F18BEC02F2AE84DAA144E7A65CAEA7A6B62EF03D0F4ADCF8072EE9BBB60F8A3428FE3D8962EA7D6040654DBDA1DDD20ED9F9454140EC80DB58E465DB765B8796F3C8DE4BC8FFFB9F667F9A9BCBA135040000,NULL,3,NULL,142425),
	(274912,2,0x1F8B08000000000000009D93CB6EDB301045F7FD0A41FBE881A6685C8C1924760B1B4883204E3E80B6C60A013E04920A927C7D879265D19657DD1833F71E5E694634DC7E2899BCA375C2E8795A66459AA0DE994AE87A9EBEBEFCB9BA496FD93730B6CE5A2DBC5098851FCFB7123367241DCD5A91DD39276AAD50FB278B7BB494816BBD3763F475CA401BAB5EE87460589115909F28B045E71F27CC44057FF4213FD6608D51A14A44354F7FCE6E6669F007B54F7F1EBA43EEB1076D37BEAD688085D19D7D2A90BFE2B69A30E722710BA394F038652F19C42F85F39CF635E12F19C4873D3C981DFBD141434746182694D7411F9A301857D80D2AF9EED174311D72413FD0DDAA47B518E8339DE8A89B052A76B77EBBD6CEDBE3C2E31E845B870BC525F3B645C8C71E8416FD85627F93F2D7F7A2497E2F5F174959D06B8F1EBCF1706478AF43CC99184161D409D489D0A0F54FA8B9F49FFD9D8B05F0C6DC8BBABB6C7D054AE88DF84256423E94D03A94E8DC8ACBFDCAB4D6057EA241858DBFE7923E6BFFA0A807C53F96914DD92702D4D6B40DAD9656C8AECA82805801D758E4551F7BA843E42692C716F2FFFD4BB37F6FEDC59534040000,NULL,3,NULL,142426),
	(274913,2,0x1F8B08000000000000009D93CB6EDB301045F7FD0A41FBE8812468528C193476031B2882A04E3E80B6C62A013E04922AD27E7D879465D15656D91833F71E5E6946343CBC2B99FD41EB84D18BBC2EAA3C43BD378DD0ED227F7B7DBABACB1FD81730B62D7A2DBC5058841FCF77120B67241D2D7A517C774EB45AA1F62F160F68290337FA60A6E89B9C813656BDD2E9C0B0AAA8A03C536087CE3FCF98990AFEE44379AAC11AA342958966917FBDBFBBCF833FAA43FAAFB13BE69E7AD076EBFB8606581A1DED7381FC35B7CD8CB914895B1AA584C739FB9141FC4A38CF695F33FE2383F8B0879F66CF6E233476648461427913F4B1098371857150C9F7CF26C6DCC6F9E6FA918EAB9ED46AA42F74A293AE8E586AEFFC6EA39DB7A78DA73D08B709378A4BE66D8F504E3D082D861BC59EB2EB6FD75597FD58BD2DB3BAA2D1260F7EF370647CB163CC85984061D6191445E8D0FA17D45CFABFC3A54B05F0C63C8A36DEB6A10225F456FC4356433996D03B94E8DC9ACBC3DAF4D6057EA641839D7FE492BEEBF0A0A407C5DF57894DD96702B4D6F41DAD9656C8AEEA8A805401D759E4CD107BAC43E43691A716CACFFEA7D97F5F4647C635040000,NULL,3,NULL,142427),
	(274914,2,0x1F8B08000000000000009D93DD4EE3301085EF798A28F7A4C9C28A82A6464BBBA8951042B43C80DB4C8325FF54B68380A7679C34A9DBF48A9B6AE63BC72799890BF79F4A261F689D307A9216599E26A837A614BA9AA46FABC7CB717ACF2EC0D82AABB5F04261167E3C5F4BCC9C917434AB45F6CF39516985DABF58DCA2A50C5CE8AD39445FA70CB4B16A45A78387E5590EA323026B74FE79E01950F0BD0EA3BE066B8C0A5522CA497A733B1EA741EF689BFEDA75FBDCBE076D97BE2E6980A9D18D7C0C489F735B0E3CA7907C53A394F038F49E13C83F13CE73DAD7C07F4E207FD8C393D9B0BF8DA9EB4808C384F23AF0AE09837185CDA0926F9E4D13F3A7996FC8F7EE66D5079A77EE134EEEA82B1A5B2CAFFD7AA19DB7FDC6E31E845B841BC525F3B646181D7A105AB4378AADDE939BBBAB9C27FF676FD3A4C8AFC8D78BF0CEC399EECDF639273032856107A606C20EAD7F41CDA5FF6A6F5D0CC01BF3202A56D0756B2B50422FC53706D495503B94E8DC9CCBEDDCD4D68591070C4ADCF9072EE9C3B60F8A7A50FC7316C9947D04A0B2A6DED16E6987ECB2C8C91013703B8BBC6C63F775885C46F8D0C2E8B77F6AF6032578EC3436040000,NULL,3,NULL,142428),
	(274915,2,0x1F8B08000000000000009D93DD6EE2301085EFF729A2DC37095AAA96D5E0AA855620555555E8031832A496FC13D9CEAADBA7EF3821C4905EED0D9A39E7F3496662E0EE53C9E42F5A278C9EA793AC4813D47B530A5DCDD3F7EDD3D56D7AC77E81B155D668E185C22CFC78BE93983923E968D688ECDE39516985DABF5A3CA0A50C5CEB8319A2A729036DACDAD2E9C0B0222B203F536087CEBF8C98910AFEE4437EAAC11AA3429588729EDECC6E6769F07BB54B7FEBBB63EEA9076D37BE29698085D1AD7D2E90BFE2B61C319722710BA394F038667F32885F0AE739ED6BC4FF64101FF6F06CF6ECBA85FA8E8C304C28A741EF9B301857D80E2AF9FEC5B431D7ED7C63FD48B7AB1ED4A2A72F74A2A36E16A8D8DDF9DD5A3B6F4F0B8F7B106E1D2E1497CCDB06211F7A105A74178A6D3F92E99FDF459D3C2EDF17C9A4A0D106133E7838D3BFD831E7428CA030EB086A45A8D1FA57D45CFA7FDDA58B05F0C63C88AABD6D5D054AE88DF8423681BC2FA17128D1B91597879569AC0BFC4883126BFFC0257DD7EE41510F8A7F2E239BB2CF04A8AC696ADA2DED905D4D0A0262055C6D91975DECB10E919B481E5AC8FFF73FCDBE015547209735040000,NULL,3,NULL,142429),
	(274916,2,0x1F8B08000000000000009D93CB6EDB301045F7FD0A41FBE8D12668528C1934760B1B2882A0763E80B6C62A013E04922AD27E7D879465D15656DD1833F71E5E6946343CBE2999FD46EB84D18BBC2EAA3C437D308DD0ED227FDD7DBFB9CF1FD90730B62D7A2DBC5058841FCFF7120B67241D2D7A517C754EB45AA1F62F168F68290337FA68A6E8DB9C813656EDE87460585554505E28B047E79F67CC4C057FF6A13CD7608D51A1CA44B3C83F3FDC3FE4C11FD521FDE7D89D72CF3D68BBF57D43032C8D8EF6A540FE9ADB66C65C8BC42D8D52C2E39C7DCF207E259CE7B4AF19FF9E417CD8C30F736077111A3B32C230A1BC0DFAD884C1B8C238A8E487671363EEE27C73FD44C7554F6A35D2573AD14957472CB5F77EBFD1CEDBF3C6D31E84DB841BC525F3B64728A71E8416C38D62BBECE3974F55977D5BBD2EB3BAA2D1260F7EF170647CB153CC95984061D6191445E8D0FA17D45CFA3FC3A54B05F0C63C8936DEB6A10225F456FC4556433996D03B94E8DC9ACBE3DAF4D6057EA641839D7FE292BEEBF0A0A407C5DF56894DD91702B4D6F41DAD9656C86EEA8A805401D759E4CD107BAA43E43691A716CAFFFD4FB37F1FA901E635040000,NULL,3,NULL,142430),
	(274917,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE538A68BC642811D040628C11F9802D1DEA267B6976B746FD7A677BA3509F7C69E65CF66C673A85F99714C1271ACBB59A8593280E03547B9D7195CFC2DDFBD3E8369C2717A04D1E958A3B2E31F20FC7528191D5828E46258F1EACE5B992A8DCABC1031ACAC08D3AE863F4559880D246BED369EF49E22886F10903295AF732F00C58709D0EE3AE06A3B5F455C0B359787377370D93D124264B2BD417BCB5A889EE3028B37565463D2CB5AAE45382F43533D9C0734E926FA9A5E40E87DEBF04F2AFB8758C4636F0FF2590DF8FE259EF93CB6B6F6A1109BE195F4E3CDF02DF189358352AD8FE455731D3AABF21DFB8AB691FD9B8759FF1E43ECFECABA94B37CA3AD30DBC8F81DB8DDF292612674A84F1110357BCDEA9E429B8B99FC62C785CED96C124BE255BA7C107F347DAF76A62CEC89EC9B73A3055241468DC2B2A26DC77BD767D029CD60B9E57FB565720B9DAF21FF4936E4B282D0AB476CDC461AD4B63BD7FC04186855B30419FB5BEA88741B2AF554FA6EC130272A3CB82464B236C96BBCF802D0CB2AC8E6D6A1FB9EDD14708E3FFFED5C92F51492DBC37040000,NULL,3,NULL,142431),
	(274918,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE530A6A1433942868203184087CC04287BAC95EC8EED6A85FEF6C6F14CA932FCD9CCB9EED4CA730F99622F84263B956E37010C561806AAF53AEB271B8DDBCF51EC3497203DA6451AEB8E31223FF706C2730B25AD0D128E7D1B3B53C5312955B193CA0A10C5CA8833E45DF8509286DE4864E7B4F124731F4CF18D8A175CB8EA7C3826B74E8373518ADA5AF029E8EC387D1E8364C7A83982CB5505EF051A32ABAC1A0CCDAE529F530D5AA90CF09D2E7CCA41DCF2549BEA996923BEC7AAF09E49F71EB188DACE3BF2690DF8FE25DEF93E1BD37D58804DF8C2F079EAF816F8C492C1A156CBFD445CCB0E8AFCB57EE62DA2736AEDD173CB92F33DBEACEED16CA3AD30CBC8D81DB85DF292612677284FE090357BCDCA964138C9E6E6316BCCEB6D360103F92ADD1E093F923F57B55311764CBE45BED980A128E68DC0A1513EEA75CBB36014EEB179E15FB565620B95AF35FF493AE4BC82D0AB476CEC461AE7363FD3C3A1CA478742F4CD0672D2F6A6190EC7BD69229FB8C80CCE8FC48A3A51156CBDD66C01E0DB2B48CAD6A1FB96ED12708FDFFFED5C91FEDF0C89937040000,NULL,3,NULL,142432),
	(274919,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE5B5AD12866A851D040A284087CC04287BAC95EC8EED6A85FEF6C6F14EA932FCD9CCB9EED4CA7F0F02545F089C672ADC66112C561806AA733AEF271B859BF5CDE850FE90568934785E28E4B8CFCC3B1ADC0C86A4147A382478FD6F25C49546E69708F863270AEF6FA187D1DA6A0B4916B3AED3D691CC5303861608BD62D7A9E1E0BAED561D0D660B496BE0A78360E6F47A361985E2631591AA1BAE0BD4175748B4199952B32EA61A255299F12A4CF98C97A9E73927C132D2577D8F7FE25907FCAAD6334B29EFF2F81FC7E14AF7A975EDD78538348F0CDF832F17C037C634C62D9A860BB852E6386657F7DBE7697D33EB271E33EE3C97D9ED955B76E3B57D69976E05D0CDCCEFD4E31913A53200C8E18B8E2D54EA56F4192DC0F63163C4F37932089EFC8D78AF0C1FC99E6C5EA9C33B263F2BDF64C250907346E898A09F75DED5D9700A7F513CFCB85AB2A905CADF80FFA5137251416055A3B63623FD385B1DEDFE320C3837B6282BE6B75510783645FD38E4CD92704E44617079A2DCDB0DEEE2E03F6609065556C5DFBC855873E4218FCF7B74E7F018854522638040000,NULL,3,NULL,142433),
	(274920,2,0x1F8B08000000000000009D53C94EC33010BDF31551EE4D130A62D13415B4A056025451F800B799064B5E22DB41C0D733CED6B4E1C4259AB7F8393399C0EC4B8AE0138DE55A4DC3248AC300D54E675CE5D3F0FDED71741DCED233D0268F4AC51D9718F987635B8191D5828E46258FEEACE5B992A8DCDAE01E0D65E04AEDF521FA224C416923DFE8B4F7A47114C3F888812D5AF732F00C58709D0EE3AE06A3B5F455C0B3697875733309D3511293A515EA0B5E5BD444771894D9B832A31EE65A55F23141FA92996CE03925C937D752728743EF5F02F917DC3A46231BF8FF12C8EF47F1A477E9F9A537B58804DF8C2F13CFB7C037C624568D0AB67BD155CCA4EA6FC837EE6ADA07366EDD273CB94F33FBEAD66D57CA3AD30DBC8F81DB95DF292652674A84F1010357BCDEA9F439486E2771113C2CDEE741125F93ADD3E083F923ED7B35312764CFE45B1D982A120A346E8D8A09F75DAF5D9F00A7F53DCFAB7DAB2B905C6DF80FFA49B7259416055ABB6462BFD4A5B1DE3FE020C3C2DD33419FB5BEA88741B2AF454FA6EC230272A3CB82464B236C96BBCF802D0CB2AC8E6D6A1FB9E9D10708E3FFFED5E92F976B989B37040000,NULL,3,NULL,142434),
	(274921,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE29AD681433D428682031C608C4F34287BAC93EC8EED6A8BFDED9BE2894939766BEC77EDB994EE1FE5B8AE00B8DE55A4DC2248AC300D556675CE59370BD7A1EDC86F7E90568934785E28E4B8CFCC3B18DC0C86A4147A382470FD6F25C4954EECDE00E0D65E042EDF421FA2A4C4169235774DA7BD2388A6178C4C006AD7BED797A2CB85687615B83D15AFA2AE0D924BC198F47613A4862B2344275C17B83EAE81683324B5764D4C354AB523E26489F3393F53CA724F9A65A4AEEB0EF3D27907FC6AD6334B29EFF9C407E3F8A17BD4D2FAFBDA94124F8667C9978BE01BE3126B16C54B0EDAB2E6346657F7DBE7697D33EB071E33EE1C97D9AD955376EB350D69976E05D0CDC2EFC4E31913A53200C0F18B8E2D54EA51F4192DC8D62163CCDD6D320896FC9D78AF0C9FC99E6C5EA9C13B263F2BDF64C25097B34EE0D1513EEA7DABB2E014EEB479E970B575520B95AF25FF4A36E4A282C0AB476CEC46EAE0B63BDBFC741867BF7C8047DD7EAA20E06C9BE671D99B28F08C88D2EF6345B9A61BDDD5D06ECDE20CBAAD8BAF691CB0E7D8030FCEF6F9DFE01ED6C122338040000,NULL,3,NULL,142435),
	(274922,2,0x1F8B08000000000000009D93CB4EC3301045F77C45943D790012054D83A005B512204441ACDD661A2CF911D90E02BE1E4FD2B46ED3159B6AEEBDC793CCC4859B6F29A22F34966B358EF3248B23542B5D72558DE3F7B787D3517C539C803655D228EEB8C4847E1C5B0A4CAC16FE68D2F0E4D65A5E2989CABD185CA3F13D70AED67AD7FA222E406923DFFC69628A2CC920DD736089D63D0F98810B6E9B43BAADC1682DA98A78398E2FAF46A398F2DEEDBABFF66AD377AB4199856B4A3FC044AB36DE377C3E63A61C3087A6E7265A4AEE70C81E0B3C3FE5D631BFAF017F2CF03CEDE151AF8AFC92A05EF98086A1F29CFC5ED0604C623BA860AB671DCC37F43774BBEA23F481EFE940E54485E9D22DE7CA3AB35D78A881DB395D28260A671A8474A7812BDE5DA8E2E9E321CACFAECFB33ABA9FBE4FA23CF3C3ED62F86474AA7FB54DA703338068DA01D49A50A3712FA898703FDDB50B0D705ADFF1AABD6F5D0592AB05FFC5E20CD2BE84C6A2406B674CAC67BA3196F8810725D6EE8E09FF65BB07051A24FB9E06B1EFBD6740657453FBEDFA2D521A4AB0B54156763D3735F55B04F64E42FADFBF74F107A3F52A8834040000,NULL,3,NULL,142436),
	(274923,2,0x1F8B08000000000000009D534B4F834010BEFB2B087729A849D54C69B4D5B4891A63DB78DE96296EB20FB2BB98EAAF77160AA5A5272F64BEC77EEC0C038C775204DF682CD76A1426511C06A8363AE32A1F85ABE5F3E56D384E2F409B3C2A15775C62E41F8EAD0546560B3A1A953C7AB096E74AA272EF06B7682803E76AAB0FD137610A4A1BB9A4D3DE93C6510C832306D668DD5BCFD363C1B53A0CDA1A8CD6D25701CF46E1F0EE76187ABD61EBF48F06ED735B0CCA2C5C99510313AD2AF998207DC64CD6F39C92E49B6829B9C3BEF79C40FE29B78ED1BC7AFE7302F9FD1C5EF4264D86DED420127C33BEBCF67C037C634C62D5A8609B375DC524557F7D7EEFAE467D60E3C67DC293FB34B3ABAEDD7AAEAC33EDC0BB18B89DFB85622275A644181C3070C5EB854A5F3F9F83E4FE3A2E82A7E96A1224F115195B15BE983FD4DC6C1F7442764CBED99EA922A140E3DE5131E17EEAADEB12E0B47EE479B56E750592AB05FFC594EED394505A1468ED8C89ED4C97C67A7F8F830C0BF7C8047DD8FA451D0C92EDA61D99B28F08C88D2E0B1A2E0DD1AB5D08B630C8B23A735FFBBC45873E4018FCF78F4EFF00F27D0B6F33040000,NULL,3,NULL,142437),
	(274924,2,0x1F8B08000000000000009D935B6FE2301085DFFB2BA2BC3717B5DA5E34B86A612B90B65555A8F6D990216BC997C87656DDFEFA8E130286F0B42F68CE399F27998981874F2593BF689D307A9296599126A837A612BA9EA41FABE7CBDBF4815D80B175D66AE185C22CFC78BE96983923E968D68AECD139516B85DABF59DCA2A51EB8D05B73687D9D32D0C6AA159D0E0C2BB202F22307D6E8FCEB8819B9E0F739E4FB1AAC312A5489A826E9CDDDED8F945D96052143D03FE07D50BBD67B0DDA2E7D5BD10C53A3BBF8D8A07CCE6D35624E4DE2A64629E171CC9E0B889F09E739AD6CC49F0B880FABF86536ACBC09D0A02808C37441F0071106E30ABB4125DFBC9A68BEB1BFA3BB6D9FA14F7CA24FA9385DFBF5423B6FF70B8F3508B708778A4BE66D8B901F34082DFA3BC55E7E3F27E5FD55D1243F671FD3A42C68B6430A7F783834BCD9AED189194161D811D499D0A0F56FA8B9F4FFFA8B171BE08D79127577E3FA0A94D04BF185EC1AF2A184D6A144E7E65C6EE7A6B52EF0230F2A6CFC1397F461FB07451A14FF9C4531F53E32A0B6A66D68B9B4C490C6125C6391577DCF5D1DFA2D23FB2021FFDF3F35FB06B01A4EBC36040000,NULL,3,NULL,142438),
	(274925,2,0x1F8B08000000000000009D534B4FC24010BEFB2B9ADE2DAD98806628119040A2C608C4F34287BAC93EC8EED6A8BFDED99696423D7969E67BECD79DE914C65F52049F682CD76A1426511C06A8763AE32A1F859BF5FC7A188ED32BD0268F0AC51D9718F987635B8191D5828E46058F1EACE5B992A8DCABC13D1ACAC0A5DAEB53F46D9882D246AEE9B4F7A4711443EF8C812D5AF7D2F17458708D0EBDA606A3B5F455C0B35138B81B0E42AFD76C95FE56A3636E834199952B326A60AA55299F13A42F98C93A9E4B927C532D2577D8F5FE25907FC6AD6334AF8EFF2F81FC7E0E4F7A9726036FAA1109BE195FF63D5F03DF189358362AD8EE45973149D95F973FBACB519FD8B8765FF0E4BECC6CAB5BB75D2AEB4C33F036066E977EA198489D29107A270C5CF16AA1D2E7F7799024F7FD98058FB3CD3448E21B7236327C307FAABEDA31E9826C997CB71D5349C2018D7B45C584FBAED6AE4D80D37AC2F372DFAA0A24572BFE8329DDA72EA1B028D0DA0513FB852E8CF5FE0E07191EDC8409FAB2D58B5A1824FB9AB564CA3E232037BA38D074698A5E6D43B007832CAB328FB5CF5BB5E81384DE7F7FE9F41734571FA634040000,NULL,3,NULL,142439),
	(274926,2,0x1F8B08000000000000009D534B4F834010BEFB2B087729B5265433C5D8D6A64DD4185BE3792953DC641FCDEE62D45FEF2C144A8B272F64BEC77EEC0C03DC7D49117CA2B15CAB49388CE23040B5D53957C5247CDB2C2EC7E15D7A01DA1451A9B8E31223FF702C1318592DE86854F2E8DE5A5E2889CABD18DCA1A10C5CA99D3E465F8729286DE4864E7B4F1A47310C4E18C8D0BAE79EA7C7826B7518B43518ADA5AF029E4FC2E4669C845E6FD83AFDB54187DC1683326B57E6D4C04CAB4A3E25485F3293F73CE724F9665A4AEEB0EFFD4B20FF9C5BC7685E3DFF5F02F9FD1C1EF5361D26DED420127C33BE1C79BE01BE3126B16A54B0EDB3AE6286557F7DFEE0AE467D64E3C67DC693FB3CB3AB662E5B29EB4C3BF02E066E577EA198489D291106470C5CF17AA1D2A7F74590DC8E62163CCCDF66C130BE2263ABC207F3879A9B1D82CEC88EC937DB335524ECD1B817544CB8EF7AEBBA0438ADA7BCA8D6ADAE4072B5E63F98D27D9A124A8B02AD5D32B15BEAD258EFEF7190E3DE4D99A00F5BBFA88341B2AF7947A6EC13020AA3CB3D0D9786E8D52E04BB37C8F23AF350FBBC75873E4218FCF78F4E7F017C4B71DF33040000,NULL,3,NULL,142440),
	(274927,2,0x1F8B08000000000000009D93DD6EE2301085EFFB1451EE1B02AC445B0DAEB6B01548555515FA00860CA925FF44B65375F7E93B4E483084ABBD8966CEF93CF14C26F0F8AD64F285D609A3E7E938CBD304F5DE144297F3F463FB7C7B973EB21B30B6CC6A2DBC50988587E73B899933928E66B5C87E3B274AAD50FB378B07B45403D7FA604EA57FA50CB4B16A4BA703C3F22C87D199023B74FE75C00C54F0BD0FA33E066B8C0A51228A793ABBBF9BA5C1EFD4B6FA7B971DEBF63968BBF175410D2C8C6EEC7381FC15B7C580B914895B18A584C7217BCD207E299CE734AF017FCD203ECCE1C5ECD97816A02E23233413C269D0BB2434C615368D4ABE7F35517F43FD4837A3BE425FE8445F52B1BBF3BBB576DEF6038F73106E1D168A4BE66D8D303AE520B468178A6DB79FC9F421CFABE4CFF263918CF30981BD0B9F3C1CEA6E762C7421465068760035225468FD1B6A2EFDDF76EB6201BC314FA26CD6AD8D4009BD11FF90D17DBA106A87129D5B71795899DABAC00F3428B0F24F5CD2876D5F14E5A0F8F732B2A9F69900A5357545C3A521B2DB494E40AC80AB2CF2A22D7B8C43C94D249F5218FDEF4FCD7E0061CB256836040000,NULL,3,NULL,142441),
	(274928,2,0x1F8B08000000000000009D934F4FE33010C5EFFB29A2DC49D282447735358216D44A2C425B1067B799064BFE13D90E82FDF43B4E9AC66D38EDA59A79EFE797CCC4859B4F25930FB44E183D4F27599126A877A614BA9AA7AF2F0F17B3F486FD0063ABACD1C20B8559F8F17C2B317346D2D1AC11D9AD73A2D20AB57FB6B8474B19B8D67B33445FA50CB4B1EA854E0786155901F989025B74FE69C48C54F0471FF2630DD61815AA4494F3F4FAE76C9606BF57BBF43F7D77C83DF6A0EDC637250DB030BAB54F05F257DC9623E65C246E6194121EC7EC7706F14BE13CA77D8DF8EF0CE2C31E1ECD8E4DAE03D477648461427919F4BE09837185EDA092EF9E4C34DF583FD0EDAA0775D2D3673AD1E754EC6EFD76AD9DB7C785C73D08B70E178A4BE66D83900F3D082DBA0BC57EBF3D24D35F97459DDC2F5F17C9A4A0D90617DE7938D4BFD921E84C8CA030EC086A45A8D1FA67D45CFAAFEED6C5027863EE44D55EB7AE0225F446FC453685BC2FA17128D1B91597FB9569AC0BFC4883126B7FC7257DD8EE41510F8A7F2E239BB24F04A8AC696A5A2E2D915D4C0B0262055C6D91975DECA10E919B481E5AC8FFF74FCDFE01D2C482C436040000,NULL,3,NULL,142442),
	(274929,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE53DAA8F192A1464103892144E003163AD44DF6D2EC6E8DFAF5CEF6420BE5C99766CE65CF76A65378FA9622F84263B956933089E23040B5D71957F924DC6EDE46F7E1537A05DAE451A9B8E31223FF706C2730B25AD0D1A8E4D1B3B53C5712955B193CA0A10C5CA883EEA26FC21494367243A7BD278DA318C6270CECD0BAE5C03360C11D75181F6B305A4B5F053C9B84770F0FD7613A4A62B2B4427DC1478B9AE8230665D6AECCA887A956957C4A903E67261B78CE49F24DB594DCE1D07B4920FF8C5BC7686403FF2581FC7E14EF7A9FDE56A61691E09BF165E2F916F8C698C4AA51C1F64B5DC5DC57FD0DF9C65D4DBB63E3D67DC693FB3CB3AFEEDC6EA1AC33C781F73170BBF03BC544EA4C8930EE3070C5EB9D4A3741F2781D17C1EB6C3B0D9298AEE834F864FE48FB5E4DCC19D933F95607A68A84028D5BA162C2FDD46BD727C069FDC2F36ADFEA0A24576BFE8B7ED26D09A54581D6CE9938CC7569ACF70F38C8B0702F4CD067AD2FEA6190EC7BD69329FB8480DCE8B2A0D1D2089BE5EE33600B832CAB639BDA47AE7B740761FCDFBF3AFD03F62E2CEF37040000,NULL,3,NULL,142443),
	(274930,2,0x1F8B08000000000000009D53C94EC33010BDF31551EEA4A90051D034085A502B218468FB014E330D96BC44B68380AF679CBD4D4F5CA2798B9F3393093C7C4B117CA1B15CAB79388DE23040B5D71957F93CDC6D5F2E67E1437201DAE451A9B8E31223FF702C1518592DE86854F2E8D15A9E2B89CABD1B3CA0A10C5CAB83EEA3AFC3049436724BA7BD2789A31826470CA468DDDBC83362C1753A4CBA1A8CD6D25701CFE6E1EDDDDD55985C4E63B2B4427DC1478B9AE80E83321B5766D4C342AB4A3E26485F31938D3CA724F9165A4AEE70EC3D27907FC9AD6334B291FF9C407E3F8A57BD4F6E2A538B48F0CDF872EAF916F8C698C4AA51C1F66FBA8A9955FD8DF9C65D4DBB67E3D67DC293FB3473A8A62E5D2BEB4C37F021066ED77EA798489C2911263D06AE78BD53C93698DD5FC52C785EEE16C134A62B7A0D3E993FD2BE571373420E4CBED591A922A140E3DE5131E17EEAB51B12E0B47EE279B56F750592AB0DFF453FE9B684D2A2406B574C1C56BA34D6FB471C6458B82726E8B3D6170D3048F6BD1CC8947D44406E7459D0686984CD720F19B0854196D5B14DED233703BA8730F9EF5F9DFC0157DE0CA337040000,NULL,3,NULL,142444),
	(274931,2,0x1F8B08000000000000009D53C96EC23010BDF72BA2DC0941B4EAA221A8402B902A840AFD004386D49297C8762ADAAFEF380B09A4A75EA2798B9F3393094C4F52045F682CD76A128EA2380C501D74CA5536093F76AF8387709ADC8036595428EEB8C4C83F1CDB0B8CAC1674342A78F46C2DCF9444E536068F68280357EAA8DBE8DB3001A58DDCD169EF49E22886E105037BB46EDDF3F45870671D86E71A8CD6D257014F27E1FDE3E3384C06A3982C8D505DF0DEA03AFA8C4199AD2B52EA61AE55295F12A42F99497B9E6B927C732D2577D8F7FE25907FC1AD6334B29EFF2F81FC7E146FFA90DC95A60691E09BF1E5C8F30DF08D318965A3821DD6BA8C7928FBEBF3B5BB9C76CBC68DFB8A27F7756657DDBBFD4A5967CE03EF62E076E5778A89C4990261D862E08A573B95EC82F1D338CE8397C5C73C18C57445ABC127F3479AF7AA63AEC88EC9B7DA339524E468DC061513EEBB5ABB2E014EEB19CFCA7DAB2A905C6DF90FFA4937251416055ABB64E2B8D485B1DEDFE320C5DCCD98A0CF5A5DD4C120D969D19129FB8280CCE822A7D1D208EBE5EE326073832CAD62EBDA476E3B740B61F8DFBF3AF9050705F72737040000,NULL,3,NULL,142445),
	(274932,2,0x1F8B08000000000000009D53DB4EC240107DF72B9ABE5BDAA811CC5023A081C41023F0010B1DCA267B21BB5B837EBDB3BDD0427DF2A59973D9B39DE9149E4F52045F682CD76A1C26511C06A8763AE32A1F879BF5DBED307C4E6F409B3C2A14775C62E41F8E6D0546560B3A1A153C7AB196E74AA2721F06F7682803176AAFDBE8FB3005A58D5CD369EF49E32886C105035BB46ED9F3F45870671D06E71A8CD6D25701CFC6E1E3687417A6B7494C9646A82EF86C501D7DC6A0CCCA1519F530D5AA942F09D2E7CC643DCF3549BEA996923BEC7BFF12C83FE3D6311A59CFFF97407E3F8A77BD4B1F4A538348F0CDF832F17C037C634C62D9A860BBA52E6386657F7DBE7697D36ED9B8715FF1E4BECEECAA5BB75D28EBCC79E05D0CDC2EFC4E31913A53200C5A0C5CF16AA7D2F5214892A7BB9805AFB3CD344862BAA455E1C0FCA1E6CDEAA02BB263F2CDF64C25094734EE031513EEBB5ABC2E014EEB09CFCB8DAB2A905CADF80FFA5937251416055A3B67623FD785B1DEDFE320C3A39B30411FB6BAA88341B2D3AC2353F60501B9D1C591864B43ACD7BBCB803D1A6459155BD73E72D5A15B0883FFFED7E92FA51B289D39040000,NULL,3,NULL,142446),
	(274933,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274934,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274935,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274936,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274937,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274938,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274939,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274940,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274941,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274942,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274943,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274944,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274945,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274946,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274947,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274948,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274949,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274950,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274951,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274952,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274953,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274954,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274955,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274956,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274957,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274958,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274959,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274960,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274961,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274962,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274963,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274964,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274965,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274966,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274967,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274968,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274969,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274970,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274971,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274972,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274973,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274974,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274975,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274976,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274977,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274978,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274979,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274980,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274981,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274982,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274983,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274984,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274985,3,0x1F8B08000000000000009D8E3D0F824010447B7F05B9DE3BED2C962346D05868E1416D4E59C826B047EEC3F8F3552A6A9B99E4256F3250BCC7217BA10FE438175BB91119F2D3B5C47D2E9AFAB8DE8942AFC0F95E26A64823CA5F44FB185006377C5599489EBC4BD3C17188DE12C733776EB12A34B01D519BFDA5BA9BBA29AB6B6D40CD0C268F9DBE819A1B28181B297484AD8E3E21A82501F5C711FD019BA9304BE5000000,'1',4,NULL,NULL),
	(274986,1,0x1F8B0800000000000000AD97516F9B3010C7DFF7292CDE4B81400252D36AEA36A952274DEAFA344D9301877A3336B20DDDF6E97706D2D00443D2ECA15589B85FFE77BEFB9F7B75F3BB64A8215251C1D78EEF7A0E223C1339E5C5DA79FCFAE922766EAEDF5D0959B835A79A96C435BF344E1971956010EAD6D4BD17C51DDF8801C9B9BE2A55811869085B3BA183E069EDDC0B6CD088F2AAD628C71A23D7751DF31781A0C0F7FCE5220923CF8F9CCB5784608F9031AC1451E3E1D1329809A75C6959675A48841B4C194E2983F46CC095B798014A21CA33510F446B83AAB0245C4F679878CB194139850C695A6B380F5449B22140CDDECE1B54AC45BB2813E6234CB95668031FDF99470B3EF02DF82F42B549E35A8B126B9A21854BF243E93A27063CFC9237A2DB4222464BAACFC16D0BF122EDBC782365C36806A067AA9FE0B1048124473055EDA19DFD05844BC1CA56EA37FFFB286DE925738D3D460B4EA6DD19F3C00C299299DC0CF844C2AD28C1334CE04F90C2C6C37D2FB1854B8275D7C79D12E8095A709390BD3A7E60B3A1499CAD3C7EE81D3F0530B2389FEDD729662D8B4E618319CD51C570464A6BE74E906E9F48F6CBA0CC94536E348103809B80C98DA3A27D37D92E8087BE9B3E9A6EEADBA9C58F4056B6467FD133986C8B907906D9291947C42B0BE283E0E498F717FDFB9F454E6002EA0C5C586D6AC6FE20064346F2A3BE755BC1F7CF9876B6068681796E39CDC08F6D47005BBB5D3352C0122F8F0DDF9B64FAB73587F606704AF803C1327BDA35536F0BBDE79D2CA6842C9A8E56F37C8EB3084F38CAE52288F62762584322C11B45558D9CDF64286EFACA5995AEFC38B1CDE22EDC0880AB026C4B0DB7AE514EBCB266DC7376B6354A48C295FD247B25C3FDC0EC24F899C9A96022855EA0E622394688ED76DC13B62BF522C5CA6C520D560AC69A8D2B8A43EB2AED790D96D4DC745B4D1648E4CDA495EA747879B2A042CFF30E6D73BF4252D4D560279C053B3CB8295C14CEE0BAFB4B7B81F94FE0C3A134EF2FED6BAA53303D5D2DE2A0348BDD5C7771AF5C5AE1E660C881930449CBB93CF2BFA3EB7F53AFE3A86E0D0000,NULL,6,806,NULL),
	(274987,1,0x1F8B0800000000000000AD97516F9B3010C7DFF7292CDE4B81400252D36AEA36A952274DEAFA344D9301877A3336B20DDDF6E97706D2D00443D2ECA15589B85FFE77BEFB9F7B75F3BB64A8215251C1D78EEF7A0E223C1339E5C5DA79FCFAE922766EAEDF5D0959B835A79A96C435BF344E1971956010EAD6D4BD17C51DDF8801C9B9BE2A55811869085B3BA183E069EDDC0B6CD088F2AAD628C71A23D7751DF31781A0C0F7FCE5220923CF8F9CCB5784608F9031AC1451E3E1D1329809A75C6959675A48841B4C194E2983F46CC095B798014A21CA33510F446B83AAB0245C4F679878CB194139850C695A6B380F5449B22140CDDECE1B54AC45BB2813E6234CB95668031FDF99470B3EF02DF82F42B549E35A8B126B9A21854BF243E93A27063CFC9237A2DB4222464BAACFC16D0BF122EDBC782365C36806A067AA9FE0B1048124473055EDA19DFD05844BC1CA56EA37FFFB286DE925738D3D460B4EA6DD19F3C00C299299DC0CF844C2AD28C1334CE04F90C2C6C37D2FB1854B8275D7C79D12E8095A709390BD3A7E60B3A1499CAD3C7EE81D3F0530B2389FEDD729662D8B4E618319CD51C570464A6BE74E906E9F48F6CBA0CC94536E348103809B80C98DA3A27D37D92E8087BE9B3E9A6EEADBA9C58F4056B6467FD133986C8B907906D9291947C42B0BE283E0E498F717FDFB9F454E6002EA0C5C586D6AC6FE20064346F2A3BE755BC1F7CF9876B6068681796E39CDC08F6D47005BBB5D3352C0122F8F0DDF9B64FAB73587F606704AF803C1327BDA35536F0BBDE79D2CA6842C9A8E56F37C8EB3084F38CAE52288F62762584322C11B45558D9CDF64286EFACA5995AEFC38B1CDE22EDC0880AB026C4B0DB7AE514EBCB266DC7376B6354A48C295FD247B25C3FDC0EC24F899C9A96022855EA0E622394688ED76DC13B62BF522C5CA6C520D560AC69A8D2B8A43EB2AED790D96D4DC745B4D1648E4CDA495EA747879B2A042CFF30E6D73BF4252D4D560279C053B3CB8295C14CEE0BAFB4B7B81F94FE0C3A134EF2FED6BAA53303D5D2DE2A0348BDD5C7771AF5C5AE1E660C881930449CBB93CF2BFA3EB7F53AFE3A86E0D0000,NULL,6,807,NULL),
	(274999,1,0x1F8B080000000000000095924F4BC43010C5EF7E8A212028DA6CD2BAAECA6E4511C18328BA9EC443DACED6603629F923EEB777AA0715B2070F6D13FA7E2F33F3323FFF581B78471FB4B30B26B96080B6759DB6FD823D2DAF8B13765EEFCC9DEF79B23AEA35F2F115556390076708E549F37BEF06F45163B8B12BF7CB90D573B4D16FE00D370BF6382076AC9E093E95A0E324CC275F7FFF886E71ED689D82EA91D5F274CA8F4E6F73C2A573D0E81EBC73EBC0EA233E13BBB0574EF773E28B10746FB18377E5F5583D1152082E464656D5849E2CF81490C4015E955915AF2E7902052FE578141C407992A56E227A156906AC2ECBAACA491EA86C183CAED0D3C8FFD453C832EB7AA9DAB722BAA2A12F681BA24F6D747E8B8BC87A2C29BEADC71ED3622BC5EA4AF2E319046C73923B4A5D1903742BD2D8394DDA24820A2928991C71A5A903DD7CABB7F4C0F3F53CC6D4D1165A675746B7710C059E3B3254E470260E292FDF9D89972CAC6804213583F2111A6508A1FB0E035A65E2668C57FCD43BF9DFDDAF3F01FF1C54E453030000,NULL,1,826,NULL),
	(275000,1,0x1F8B08000000000000009592CB4A03311486F73EC52120283A69D2AA6DA51D514470218AB62B719199391D836932E422F6ED3D634514D2859B5CC8FF9DFCE732BBF8581B78471FB4B37326B96080B6768DB6ED9C2D1737C5845D947B33E75B9EAC8E7A8DBC5FA2AA0CF2E00CA13C69FEE05D873E6A0CB776E57E0564E50C6DF41B78C3CD9C3D75880D2BC7829F4AD071106683AFD73FA23B5C3B3AA7A05A64A59C9EF293E95D4EB8700E2ADD82776E1D5829B810FB70200E73DACB10746BB18177E5756F9E0029BE11391EC871165B06246980576556C5AB4B7EFBCFA4FF078E6098856E237A15297F560E87A3514EF24896A1F3B8424FE5FE6326EFFF4AD56F457445453B681BA24F7574FE5F3116D4B81D4071D21F7652AC1C497E368680754E724FFD56C600CD43EAF3A6229B445021259F881C71AD29035D6DD53B72E0793F4F31357485DAD995D175EC3B02CF0D055414E15C1C53B37C732E5EB2B0A212845475CA47A8942184261D3AB4CAC4CD76867EB8C1FFA6BEFC049B02549A4D030000,NULL,1,827,NULL),
	(275001,1,0x1F8B0800000000000000B3B1AFC8CD51284B2D2ACECCCFB35532D433505248CD4BCE4FC9CC4BB7550A0D71D3B550B2B7E3B2C92F4AD72BCDCB2CC9CC4DD5031125894939A97AC5F93940AD7AA5997A6E9939A99E7969F948462929E425E6A6DA2A393B058364E2832D8CCCF4AA80D629E9DB010040DD607A77000000,NULL,2,826,NULL),
	(275002,1,0x1F8B0800000000000000B3B1AFC8CD51284B2D2ACECCCFB35532D433505248CD4BCE4FC9CC4BB7550A0D71D3B550B2B7E3B2C92F4AD72BCDCB2CC9CC4DD5031125894939A97AC5F93940AD7AA5997A6E9939A99E7969F948462929E425E6A6DA2A393B058364E2832D8CCCF5AA80D629E9DB010003C91B6D77000000,NULL,2,827,NULL),
	(275003,2,0x1F8B08000000000000009D93CD6E82401080EF7D0AC35DC0D6034DC63555D368D21853DB075865A09BEC8FD95D1ADBA7EF0E8A8278EA85CC7CF331CB0C00D3A392836FB44E183D8946711A0D50EF4D2E7439893E3F5E875934650F606C19575A78A130A68BE73B89B13332DC1A57227E714E945AA1F61B8B05DAD00357BA30D7D6E3888136567D84BBC961C32C4E21E920D8A1F3EBBED4C3E02FC218924B02D61845D140E493284B47CF512D34F874C07B9351A90340DBADAFF230C5DCE882D1E37540A82FB9CD7BCE2D0CDEDC28253CF6DD7B85E02F84F33C2CADE7DF2B049F56F166F62C23A74902A759287C22DE2434175758CF29F97E6DEA2EA37ABC3E3FDBF5B2AF346DEC1B1EECDB9EEDEACEEF56DA795BEF975E653B07E156F45171C90A2E1D427205F0C5296E4E6C841BDAB2688ABE555338A0F51BD45CFA1F96D217D506E08D9989929EEE1C81127A2B7E913D42D284503994E8DC92CB62692AEBC8EF31C8F1E0675C8637763AA89583E2C745AB1C7A770094D65487B0B6B01EAAB65370078B3C3FF53CC7D46FDBC2D71492FFFEAFEC0FFDDD260811040000,NULL,3,NULL,142457),
	(275004,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E105A162C06A302AA40AA102AF400860CA925FF44B653D19EBEE3408821ACBA89E6BDF765CC0C0E4C4F4AF6BED13A61F42419A659D2437D30B9D0C524F9DCBDF5C7C9943D81B1455A69E185C2343C3CDF4B4C9D91F46A5A89F4D539516885DA6F2C1ED1520F5CE9A3695B8F1206DA58B5A3B703C3FAA32CCD6070E3C11E9D5F3FA03A3EF89680C15580354685AA27F24932CE9E5F12D61F66D4A109CE677C34EAD2FBAA41DBADAF721A646E741DDF1A942FB9CD3BCCBD49DCDC28253C76D94701F10BE13CA7BD75F84701F16117EFE6C08635D4280AC2307510FC4684C1B8C27A50C90F6B13CDD7F52F74BDEE07F49D4FF43D15A77BBF5F69E7ED75E1B106E156E16271C98E5C3A84416BC0170F75736203DCB91115A6E852B50B255ABF41CDA5FF61F59D8A0DF0C6CC44117EDDA50225F456FC22A3EBD594503994E8DC92CBE3D254D605BEE3418EA59F71497FD9F9A04883E2A7451453EF1B030A6BAA92D646EB09692CC19516797EEE79A943BF6D64B71206FFFD66D91F86EC490915040000,NULL,3,NULL,142458),
	(275005,2,0x1F8B08000000000000009D93CF6E824010C6EF7D0AC35DC0D683871153358D268D31D53EC02203DD64FF90DDA5B17DFAEE820B089E7A2133DFF7E3DBCCB0C0EACAD9E41B95A6522C835918071314179951512C83CFF3DB7411AC922790AA082B410DE518BA872129C3504B665F0D2B1ABE6A4D0BC15198A3C21C95CDC0BDC865173D0F121052F1B37DDB31491CC610DD2990A23687113352C1B43E446D0D4A4AEEAA09CD96C1227E7E0992E92CB688379A033E7C778B6E7B10EA64AACCCEB091A2B6EF05EBEF88CA46CC50B4DC46724E0D8ED94786E5B7541B625736E21F199677AB789797645E43BEB3861BC69533A7FBC60D4638D683327239C83AA6461EE837BADE76A7C69E1EE8961E66F6DDD4A47BA18D6A17DEEF81EABDBB53842539611A21EA04F822AEF6277A60A0F62837C598AA55285199230AC2CC4F73A5FA021829D7B4A8EF525301A7E2447F319943E44BA83432D47A4758BE9395D28E1F69906169D684D94FD61CD4EB8193EBB667DBEC3B010A25ABD2AECDAEC7B9FD1674A990644DE6AD7679A79EDCB510FDF7774DFE00001A3ECC10040000,NULL,3,NULL,142459),
	(275006,2,0x1F8B08000000000000009D93CF6E824010C6EF7D0AC35DC0D683871153358D268D31D53EC02203DD64FF90DDA5B17DFAEE820B089E7A2133DFF7E3DBCCB0C0EACAD9E41B95A6522C835918071314179951512C83CFF3DB7411AC922790AA082B410DE518BA872129C3504B665F0D2B1ABE6A4D0BC15198A3C21C95CDC0BDC865173D0F121052F1B37DDB31491CC610DD2990A23687113352C1B43E446D0D4A4AEEAA09CD96C1227E7E0992E92CB688379A033E7C778B6E7B10EA64AACCCEB091A2B6EF05EBEF88CA46CC50B4DC46724E0D8ED94786E5B7541B625736E21F199677AB789797645E43BEB3861BC69533A7FBC60D4638D683327239C83AA6461EE837BADE76A7C69E1EE8961E66F6DDD4A47BA18D6A17DEEF81EABDBB53842539611A21EA04F822AEF6277A60A0F62837C598AA55285199230AC2CC4F73A5FA021829D7B4A8EF525301A7E2447F319943E44BA83432D47A4758BE9395D28E1F69906169D684D94FD61CD4EB8193EBB667DBEC3B010A25ABD2AECDAEC7B9FD1674A990644DE6AD7679A79EDCB510FDF7774DFE00001A3ECC10040000,NULL,3,NULL,142460),
	(275007,2,0x1F8B08000000000000009D93CF6E824010C6EF7D0AC35DC0D683871153358D268D31D53EC02203DD64FF90DDA5B17DFAEE820B089E7A2133DFF7E3DBCCB0C0EACAD9E41B95A6522C835918071314179951512C83CFF3DB7411AC922790AA082B410DE518BA872129C3504B665F0D2B1ABE6A4D0BC15198A3C21C95CDC0BDC865173D0F121052F1B37DDB31491CC610DD2990A23687113352C1B43E446D0D4A4AEEAA09CD96C1227E7E0992E92CB688379A033E7C778B6E7B10EA64AACCCEB091A2B6EF05EBEF88CA46CC50B4DC46724E0D8ED94786E5B7541B625736E21F199677AB789797645E43BEB3861BC69533A7FBC60D4638D683327239C83AA6461EE837BADE76A7C69E1EE8961E66F6DDD4A47BA18D6A17DEEF81EABDBB53842539611A21EA04F822AEF6277A60A0F62837C598AA55285199230AC2CC4F73A5FA021829D7B4A8EF525301A7E2447F319943E44BA83432D47A4758BE9395D28E1F69906169D684D94FD61CD4EB8193EBB667DBEC3B010A25ABD2AECDAEC7B9FD1674A990644DE6AD7679A79EDCB510FDF7774DFE00001A3ECC10040000,NULL,3,NULL,142461),
	(275008,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A8A8CA62082AA00AA40AA1420FE09021B5E49FC8762ADAD3D7931030845537D1BCF7BE8C351307A6472906DF682CD76A120DE3341AA0DAEB82AB72127DEEDE1EC7D1347B006DCAB856DC7189313D1CCB05C6560BFF6A5CF3F8D55A5E2A89CA6D0C1ED0F81EB852077D693D8A3250DAC89D7F9B982C8D5348AE1CC8D1BA758FE9B9E0CE3924E71A8CD692AA012F26D1387D4A23CA3BB7EDFED1A953DFB30665B6AE2EFC0073AD9AF8DAF0F99299A2C7DC9A9E9B6B29B9C33E7B2FF0FC825BC7FCBE7AFCBDC0F3B48777BDCF9E1BA8533EA061A81C91DF091A8C496C06156CBFD6C17C7DFF4437ABBEB8C38EBEF13D1DA817A2C23477F94A5967CE0B0F3570BBA20BC5447660C222241703BE18D5DD891D70E306144DD1A71A172A346E838A09F7D3DEA7D000A7F58C97CD456A2B905C6DF92FD2D05D09B54581D62E99382C756D2CF13D0F0AACDC8C09FFC9DA83020D921D1741EC7B5F19501A5D577E6D7E3D9486126C6590156DCF534DFDB6817D9190FCF75FCDFE000FE8408A0D040000,NULL,3,NULL,142462),
	(275009,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A868C562082AA00AA40AA1420FE090496AC93F91ED54B4A7AF9D906030AB6EA279EF7D196B260ECC4F9C8DBE51692AC52C1AC769344271940515D52CFA3CBC3D4EA379F60052557123A8A11C63F7302467186BC9ECAB7143E357AD6925380AB35358A2B23D70234A79693D89321052F1837DDB31591AA7905C3990A336DB80095C30430EC950839292BB6A448B59344D9FD2C8E5BDDB75FFE8D5B9EFA041A8BD690A3BC0528A36BE366CBE26AA08985BD3724BC9393518B2F702CBAFA836C4EE2BE0EF0596777B7897C7ECB9857A6503378C2B27CEEF851B8C706C0765E4B895DE7CA17FA6DB55DFA16F7C4B7BEAC5517E9A9B7C23B451C3C27D0D546FDC85222C2B09D308C9C5802FE2EAFEC41EB8713DCA4D1152AD0B352AB3434198F9E9EE936F80917241ABF6227515702AF6F417B331247D098D46865AAF092BD7B251DAF1810705D6664198FD64DD419E064E4E2B2FB6BDAF0CA8946C6ABB36BB1E97FA1274AD90145DCF73EDFAED3DFB2221F9EFBF9AFD0198ADABFB0D040000,NULL,3,NULL,142463),
	(275010,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A868C562082AA00AA40AA1420FE090496AC93F91ED54B4A7AF9D906030AB6EA279EF7D196B260ECC4F9C8DBE51692AC52C1AC769344271940515D52CFA3CBC3D4EA379F60052557123A8A11C63F7302467186BC9ECAB7143E357AD6925380AB35358A2B23D70234A79693D89321052F1837DDB31591AA7905C3990A336DB80095C30430EC950839292BB6A448B59344D9FD2C8E5BDDB75FFE8D5B9EFA041A8BD690A3BC0528A36BE366CBE26AA08985BD3724BC9393518B2F702CBAFA836C4EE2BE0EF0596777B7897C7ECB9857A6503378C2B27CEEF851B8C706C0765E4B895DE7CA17FA6DB55DFA16F7C4B7BEAC5517E9A9B7C23B451C3C27D0D546FDC85222C2B09D308C9C5802FE2EAFEC41EB8713DCA4D1152AD0B352AB3434198F9E9EE936F80917241ABF6227515702AF6F417B331247D098D46865AAF092BD7B251DAF1810705D6664198FD64DD419E064E4E2B2FB6BDAF0CA8946C6ABB36BB1E97FA1274AD90145DCF73EDFAED3DFB2221F9EFBF9AFD0198ADABFB0D040000,NULL,3,NULL,142464),
	(275011,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A868C562082AA00AA40AA1420FE090496AC93F91ED54B4A7AF9D906030AB6EA279EF7D196B260ECC4F9C8DBE51692AC52C1AC769344271940515D52CFA3CBC3D4EA379F60052557123A8A11C63F7302467186BC9ECAB7143E357AD6925380AB35358A2B23D70234A79693D89321052F1837DDB31591AA7905C3990A336DB80095C30430EC950839292BB6A448B59344D9FD2C8E5BDDB75FFE8D5B9EFA041A8BD690A3BC0528A36BE366CBE26AA08985BD3724BC9393518B2F702CBAFA836C4EE2BE0EF0596777B7897C7ECB9857A6503378C2B27CEEF851B8C706C0765E4B895DE7CA17FA6DB55DFA16F7C4B7BEAC5517E9A9B7C23B451C3C27D0D546FDC85222C2B09D308C9C5802FE2EAFEC41EB8713DCA4D1152AD0B352AB3434198F9E9EE936F80917241ABF6227515702AF6F417B331247D098D46865AAF092BD7B251DAF1810705D6664198FD64DD419E064E4E2B2FB6BDAF0CA8946C6ABB36BB1E97FA1274AD90145DCF73EDFAED3DFB2221F9EFBF9AFD0198ADABFB0D040000,NULL,3,NULL,142465),
	(275012,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A8A8CA62082AA00AA40AA1420FE09021B5E49FC8762ADAD3D7931030845537D1BCF7BE8C351307A6472906DF682CD76A120DE3341AA0DAEB82AB72127DEEDE1EC7D1347B006DCAB856DC7189313D1CCB05C6560BFF6A5CF3F8D55A5E2A89CA6D0C1ED0F81EB852077D693D8A3250DAC89D7F9B982C8D5348AE1CC8D1BA758FE9B9E0CE3924E71A8CD692AA012F26D1387D4A23CA3BB7EDFED1A953DFB30665B6AE2EFC0073AD9AF8DAF0F99299A2C7DC9A9E9B6B29B9C33E7B2FF0FC825BC7FCBE7AFCBDC0F3B48777BDCF9E1BA8533EA061A81C91DF091A8C496C06156CBFD6C17C7DFF4437ABBEB8C38EBEF13D1DA817A2C23477F94A5967CE0B0F3570BBA20BC5447660C222241703BE18D5DD891D70E306144DD1A71A172A346E838A09F7D3DEA7D000A7F58C97CD456A2B905C6DF92FD2D05D09B54581D62E99382C756D2CF13D0F0AACDC8C09FFC9DA83020D921D1741EC7B5F19501A5D577E6D7E3D9486126C6590156DCF534DFDB6817D9190FCF75FCDFE000FE8408A0D040000,NULL,3,NULL,142466),
	(275013,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A868C562082AA00AA40AA1420FE090496AC93F91ED54B4A7AF9D906030AB6EA279EF7D196B260ECC4F9C8DBE51692AC52C1AC769344271940515D52CFA3CBC3D4EA379F60052557123A8A11C63F7302467186BC9ECAB7143E357AD6925380AB35358A2B23D70234A79693D89321052F1837DDB31591AA7905C3990A336DB80095C30430EC950839292BB6A448B59344D9FD2C8E5BDDB75FFE8D5B9EFA041A8BD690A3BC0528A36BE366CBE26AA08985BD3724BC9393518B2F702CBAFA836C4EE2BE0EF0596777B7897C7ECB9857A6503378C2B27CEEF851B8C706C0765E4B895DE7CA17FA6DB55DFA16F7C4B7BEAC5517E9A9B7C23B451C3C27D0D546FDC85222C2B09D308C9C5802FE2EAFEC41EB8713DCA4D1152AD0B352AB3434198F9E9EE936F80917241ABF6227515702AF6F417B331247D098D46865AAF092BD7B251DAF1810705D6664198FD64DD419E064E4E2B2FB6BDAF0CA8946C6ABB36BB1E97FA1274AD90145DCF73EDFAED3DFB2221F9EFBF9AFD0198ADABFB0D040000,NULL,3,NULL,142467),
	(275014,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A868C562082AA00AA40AA1420FE090496AC93F91ED54B4A7AF9D906030AB6EA279EF7D196B260ECC4F9C8DBE51692AC52C1AC769344271940515D52CFA3CBC3D4EA379F60052557123A8A11C63F7302467186BC9ECAB7143E357AD6925380AB35358A2B23D70234A79693D89321052F1837DDB31591AA7905C3990A336DB80095C30430EC950839292BB6A448B59344D9FD2C8E5BDDB75FFE8D5B9EFA041A8BD690A3BC0528A36BE366CBE26AA08985BD3724BC9393518B2F702CBAFA836C4EE2BE0EF0596777B7897C7ECB9857A6503378C2B27CEEF851B8C706C0765E4B895DE7CA17FA6DB55DFA16F7C4B7BEAC5517E9A9B7C23B451C3C27D0D546FDC85222C2B09D308C9C5802FE2EAFEC41EB8713DCA4D1152AD0B352AB3434198F9E9EE936F80917241ABF6227515702AF6F417B331247D098D46865AAF092BD7B251DAF1810705D6664198FD64DD419E064E4E2B2FB6BDAF0CA8946C6ABB36BB1E97FA1274AD90145DCF73EDFAED3DFB2221F9EFBF9AFD0198ADABFB0D040000,NULL,3,NULL,142468),
	(275015,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE494050B118820AA802A942A8D0033864482DF907D94E457BFA8E130286B0EA269AF7BD97B166E2C0F42445EF1B8DE55A4DA27E9C463D547B5D70554EA2CFDDDBF3389A664FA04D19578A3B2E31F60FC77281B1D5825E8D2B1EBF5ACB4B2551B98DC1031AEA812B75D0D7D6C32803A58DDCD1DB3E93A5710AC90D811CAD5B77321D0AEEE24372A9C1682D7DD5E3C5241AA7033A91FC9636DD3F5A75EE7BD1A0CCD655050D30D7AAB66F01F94B668A4EE61E526EAEA5E40EBBD94706E517DC3A46FBEAE41F1994F77B78D7FB6C54875A45861FC69743CF5BE1076312EB4105DBAF75DD6654CFD7E5E774BDEA2B4DDBF41DA774A05E7C2A747397AF9475E6B2F05003B72B7FA198C80E4C5884E40AE08BF9BA3DB10DDCD120E5A7E8A66A0A47346E838A09F7D3DCA71080D37AC6CBAC4F17A9A94072B5E5BFE8515B426551A0B54B260E4B5D199B0D20E93028F0E8664CD0276B0E0A3448765A0436F5BE01501A5D1D696DB41EEF8612ECD1202B9A9EE7DAF7DB06F82A21F9EFBF9AFD0199EA1BCE0D040000,NULL,3,NULL,142469),
	(275016,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A868C562082AA00AA40AA1420FE090496AC93F91ED54B4A7AF9D906030AB6EA279EF7D196B260ECC4F9C8DBE51692AC52C1AC769344271940515D52CFA3CBC3D4EA379F60052557123A8A11C63F7302467186BC9ECAB7143E357AD6925380AB35358A2B23D70234A79693D89321052F1837DDB31591AA7905C3990A336DB80095C30430EC950839292BB6A448B59344D9FD2C8E5BDDB75FFE8D5B9EFA041A8BD690A3BC0528A36BE366CBE26AA08985BD3724BC9393518B2F702CBAFA836C4EE2BE0EF0596777B7897C7ECB9857A6503378C2B27CEEF851B8C706C0765E4B895DE7CA17FA6DB55DFA16F7C4B7BEAC5517E9A9B7C23B451C3C27D0D546FDC85222C2B09D308C9C5802FE2EAFEC41EB8713DCA4D1152AD0B352AB3434198F9E9EE936F80917241ABF6227515702AF6F417B331247D098D46865AAF092BD7B251DAF1810705D6664198FD64DD419E064E4E2B2FB6BDAF0CA8946C6ABB36BB1E97FA1274AD90145DCF73EDFAED3DFB2221F9EFBF9AFD0198ADABFB0D040000,NULL,3,NULL,142470),
	(275017,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A8A0623104155005528550690FE09021B5E49FC8762ADAD3779C1030845537D1BCEFBD8C35130766472906DF682CD76A1A0DE3341AA0DAEB82AB721A7D7EBC3E4EA259F600DA9471ADB8E31263FF702C17185B2DE8D5B8E6F18BB5BC541295DB1A3CA0A11EB856077D693D8A3250DAC80F7ADB67B2344E21B92290A3759B5EA647C19D7D48CE3518ADA5AF06BC984693F4894E24BFA36DF7F74E9DFA9E3528B3737541032CB46AEC6B40FE8A99A297B985945B6829B9C37EF69E41F925B78ED1BE7AF97B06E5FD1EDEF43E1B37A14E91E187F1E5C8F34EF8C198C46650C1F61BDDB41937F3F5F929DDACFA42D32E7DC3291DA8679F0ADDDCE56B659D392F3CD4C0EDDA5F2826B203131621B900F862BEEE4EEC02373448F929FAA9864285C66D5131E17EDAFB1402705ACF79990DE922B51548AE76FC173DEA4AA82D0AB476C5C461A56B63FD343D0605566ECE047DB2F6A0408364C7656053EF2B00A5D175456BA3F5783794602B83AC687B9E6ADF6F17E08B84E4BFFF6AF6073C20293A0D040000,NULL,3,NULL,142471),
	(275018,2,0x1F8B08000000000000009D934D6EC2301085F73D05CABE49A868C562082AA00AA40AA1420FE090496AC93F91ED54B4A7AF9D906030AB6EA279EF7D196B260ECC4F9C8DBE51692AC52C1AC769344271940515D52CFA3CBC3D4EA379F60052557123A8A11C63F7302467186BC9ECAB7143E357AD6925380AB35358A2B23D70234A79693D89321052F1837DDB31591AA7905C3990A336DB80095C30430EC950839292BB6A448B59344D9FD2C8E5BDDB75FFE8D5B9EFA041A8BD690A3BC0528A36BE366CBE26AA08985BD3724BC9393518B2F702CBAFA836C4EE2BE0EF0596777B7897C7ECB9857A6503378C2B27CEEF851B8C706C0765E4B895DE7CA17FA6DB55DFA16F7C4B7BEAC5517E9A9B7C23B451C3C27D0D546FDC85222C2B09D308C9C5802FE2EAFEC41EB8713DCA4D1152AD0B352AB3434198F9E9EE936F80917241ABF6227515702AF6F417B331247D098D46865AAF092BD7B251DAF1810705D6664198FD64DD419E064E4E2B2FB6BDAF0CA8946C6ABB36BB1E97FA1274AD90145DCF73EDFAED3DFB2221F9EFBF9AFD0198ADABFB0D040000,NULL,3,NULL,142472),
	(275019,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795445623104155005528550A11FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903CB0B67936F549A4AB10892300E2628CE32A7A25C049FA7B7E93C58A64F205519D6821ACA31740F433286A196CCBE1AD6347CD59A9682A3300785052A9B813B51C83EFA25484148C54FF66DC7A471184374A34086DAEC47CC4805D3F91075352829B9AB26345F04F3389905E934892DD21ACD011F6D778DEE7A10EA68EADCCEB096C2DBB782F5B744E523E65EB4DC5A724E0D8ED94786E537541B625736E21F199677AB7897E7349939A8EDACE186F186D3DBC60D4638FA411939EFA58F79F6F38DF52BEDB7DDAB714BDFE996BECF1CBA99C976421BD52D7CD803D53B77A7084B0BC23442D40BF0455CDD9ED80277EA8072538C29AF4285CA1C5010667E9A2B3514C048B9A2A5BF4B4D059C8A23FD45B7C5B6845A2343ADB784155B592BEDF891063956664598FD64CD41831E38B96C06B6CDBE11A054B2AEECDAEC7A9C3B6C41570A49DE645E6B97771CC87D0BD17F7FD7F40FAF21994110040000,NULL,3,NULL,142473),
	(275020,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795445623104155005528550A11FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903CB0B67936F549A4AB10892300E2628CE32A7A25C049FA7B7E93C58A64F205519D6821ACA31740F433286A196CCBE1AD6347CD59A9682A3300785052A9B813B51C83EFA25484148C54FF66DC7A471184374A34086DAEC47CC4805D3F91075352829B9AB26345F04F3389905E934892DD21ACD011F6D778DEE7A10EA68EADCCEB096C2DBB782F5B744E523E65EB4DC5A724E0D8ED94786E537541B625736E21F199677AB7897E7349939A8EDACE186F186D3DBC60D4638FA411939EFA58F79F6F38DF52BEDB7DDAB714BDFE996BECF1CBA99C976421BD52D7CD803D53B77A7084B0BC23442D40BF0455CDD9ED80277EA8072538C29AF4285CA1C5010667E9A2B3514C048B9A2A5BF4B4D059C8A23FD45B7C5B6845A2343ADB784155B592BEDF891063956664598FD64CD41831E38B96C06B6CDBE11A054B2AEECDAEC7A9C3B6C41570A49DE645E6B97771CC87D0BD17F7FD7F40FAF21994110040000,NULL,3,NULL,142474),
	(275021,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795420B118820AA802A942A8B41FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903AB0B67936F549A4AB10C92300E2628CE32A7A25C069F1FAFD345B04A9F40AA32AC05359463E81E86640C432D997D35AC69F8A2352D0547618E0A0B543603F7A2907DF42C484148C53FECDB8E49E33086E846810CB5398C98910AA6F321EA6A505272574D68BE0C1671320FD269125BA4359A03DEDBEE1ADDF520D4C9D4B99D612385B76F05EBEF88CA47CCBD68B98DE49C1A1CB38F0CCB6FA936C4AE6CC43F322CEF56F126CF69327750DB59C30DE30DA7B78D1B8C70F48332723E481FF3ECE71BEB57DA6FBB57E396BED32D7D9F39743393ED8536AA5BF8B007AAF7EE4E119616846984A817E08BB8BA3DB105EED401E5A618535E850A9539A220CCFC34576A288091724D4B7F979A0A381527FA8B6E8B6D09B546865AEF082B76B2563A9D4134D220C7CAAC09B39FAC3968D0032797EDC0B6D93702944AD6955D9B5D8F73872DE84A21C99BCC6BEDF24E03B96F21FAEFEF9AFE01A4B28D7210040000,NULL,3,NULL,142475),
	(275022,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795420B118820AA802A942A8B41FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903AB0B67936F549A4AB10C92300E2628CE32A7A25C069F1FAFD345B04A9F40AA32AC05359463E81E86640C432D997D35AC69F8A2352D0547618E0A0B543603F7A2907DF42C484148C53FECDB8E49E33086E846810CB5398C98910AA6F321EA6A505272574D68BE0C1671320FD269125BA4359A03DEDBEE1ADDF520D4C9D4B99D612385B76F05EBEF88CA47CCBD68B98DE49C1A1CB38F0CCB6FA936C4AE6CC43F322CEF56F126CF69327750DB59C30DE30DA7B78D1B8C70F48332723E481FF3ECE71BEB57DA6FBB57E396BED32D7D9F39743393ED8536AA5BF8B007AAF7EE4E119616846984A817E08BB8BA3DB105EED401E5A618535E850A9539A220CCFC34576A288091724D4B7F979A0A381527FA8B6E8B6D09B546865AEF082B76B2563A9D4134D220C7CAAC09B39FAC3968D0032797EDC0B6D93702944AD6955D9B5D8F73872DE84A21C99BCC6BEDF24E03B96F21FAEFEF9AFE01A4B28D7210040000,NULL,3,NULL,142476),
	(275023,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795445623104155005528550A11FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903CB0B67936F549A4AB10892300E2628CE32A7A25C049FA7B7E93C58A64F205519D6821ACA31740F433286A196CCBE1AD6347CD59A9682A3300785052A9B813B51C83EFA25484148C54FF66DC7A471184374A34086DAEC47CC4805D3F91075352829B9AB26345F04F3389905E934892DD21ACD011F6D778DEE7A10EA68EADCCEB096C2DBB782F5B744E523E65EB4DC5A724E0D8ED94786E537541B625736E21F199677AB7897E7349939A8EDACE186F186D3DBC60D4638FA411939EFA58F79F6F38DF52BEDB7DDAB714BDFE996BECF1CBA99C976421BD52D7CD803D53B77A7084B0BC23442D40BF0455CDD9ED80277EA8072538C29AF4285CA1C5010667E9A2B3514C048B9A2A5BF4B4D059C8A23FD45B7C5B6845A2343ADB784155B592BEDF891063956664598FD64CD41831E38B96C06B6CDBE11A054B2AEECDAEC7A9C3B6C41570A49DE645E6B97771CC87D0BD17F7FD7F40FAF21994110040000,NULL,3,NULL,142477),
	(275024,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795445623104155005528550A11FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903CB0B67936F549A4AB10892300E2628CE32A7A25C049FA7B7E93C58A64F205519D6821ACA31740F433286A196CCBE1AD6347CD59A9682A3300785052A9B813B51C83EFA25484148C54FF66DC7A471184374A34086DAEC47CC4805D3F91075352829B9AB26345F04F3389905E934892DD21ACD011F6D778DEE7A10EA68EADCCEB096C2DBB782F5B744E523E65EB4DC5A724E0D8ED94786E537541B625736E21F199677AB7897E7349939A8EDACE186F186D3DBC60D4638FA411939EFA58F79F6F38DF52BEDB7DDAB714BDFE996BECF1CBA99C976421BD52D7CD803D53B77A7084B0BC23442D40BF0455CDD9ED80277EA8072538C29AF4285CA1C5010667E9A2B3514C048B9A2A5BF4B4D059C8A23FD45B7C5B6845A2343ADB784155B592BEDF891063956664598FD64CD41831E38B96C06B6CDBE11A054B2AEECDAEC7A9C3B6C41570A49DE645E6B97771CC87D0BD17F7FD7F40FAF21994110040000,NULL,3,NULL,142478),
	(275025,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795445623104155005528550A11FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903CB0B67936F549A4AB10892300E2628CE32A7A25C049FA7B7E93C58A64F205519D6821ACA31740F433286A196CCBE1AD6347CD59A9682A3300785052A9B813B51C83EFA25484148C54FF66DC7A471184374A34086DAEC47CC4805D3F91075352829B9AB26345F04F3389905E934892DD21ACD011F6D778DEE7A10EA68EADCCEB096C2DBB782F5B744E523E65EB4DC5A724E0D8ED94786E537541B625736E21F199677AB7897E7349939A8EDACE186F186D3DBC60D4638FA411939EFA58F79F6F38DF52BEDB7DDAB714BDFE996BECF1CBA99C976421BD52D7CD803D53B77A7084B0BC23442D40BF0455CDD9ED80277EA8072538C29AF4285CA1C5010667E9A2B3514C048B9A2A5BF4B4D059C8A23FD45B7C5B6845A2343ADB784155B592BEDF891063956664598FD64CD41831E38B96C06B6CDBE11A054B2AEECDAEC7A9C3B6C41570A49DE645E6B97771CC87D0BD17F7FD7F40FAF21994110040000,NULL,3,NULL,142479),
	(275026,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795445623104155005528550A11FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903CB0B67936F549A4AB10892300E2628CE32A7A25C049FA7B7E93C58A64F205519D6821ACA31740F433286A196CCBE1AD6347CD59A9682A3300785052A9B813B51C83EFA25484148C54FF66DC7A471184374A34086DAEC47CC4805D3F91075352829B9AB26345F04F3389905E934892DD21ACD011F6D778DEE7A10EA68EADCCEB096C2DBB782F5B744E523E65EB4DC5A724E0D8ED94786E537541B625736E21F199677AB7897E7349939A8EDACE186F186D3DBC60D4638FA411939EFA58F79F6F38DF52BEDB7DDAB714BDFE996BECF1CBA99C976421BD52D7CD803D53B77A7084B0BC23442D40BF0455CDD9ED80277EA8072538C29AF4285CA1C5010667E9A2B3514C048B9A2A5BF4B4D059C8A23FD45B7C5B6845A2343ADB784155B592BED661D699063655684D94FD61C34E88193CB6660DBEC1B014A25EBCAAECDAEC7B9C31674A590E44DE6B57679C781DCB710FDF7774DFF000AEBABB510040000,NULL,3,NULL,142480),
	(275027,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795420B118820AA802A942A8B41FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903AB0B67936F549A4AB10C92300E2628CE32A7A25C069F1FAFD345B04A9F40AA32AC05359463E81E86640C432D997D35AC69F8A2352D0547618E0A0B543603F7A2907DF42C484148C53FECDB8E49E33086E846810CB5398C98910AA6F321EA6A505272574D68BE0C1671320FD269125BA4359A03DEDBEE1ADDF520D4C9D4B99D612385B76F05EBEF88CA47CCBD68B98DE49C1A1CB38F0CCB6FA936C4AE6CC43F322CEF56F126CF69327750DB59C30DE30DA7B78D1B8C70F48332723E481FF3ECE71BEB57DA6FBB57E396BED32D7D9F39743393ED8536AA5BF8B007AAF7EE4E119616846984A817E08BB8BA3DB105EED401E5A618535E850A9539A220CCFC34576A288091724D4B7F979A0A381527FA8B6E8B6D09B546865AEF082B76B2563A9D4134D220C7CAAC09B39FAC3968D0032797EDC0B6D93702944AD6955D9B5D8F73872DE84A21C99BCC6BEDF24E03B96F21FAEFEF9AFE01A4B28D7210040000,NULL,3,NULL,142481),
	(275028,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795445623104155005528550A11FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903CB0B67936F549A4AB10892300E2628CE32A7A25C049FA7B7E93C58A64F205519D6821ACA31740F433286A196CCBE1AD6347CD59A9682A3300785052A9B813B51C83EFA25484148C54FF66DC7A471184374A34086DAEC47CC4805D3F91075352829B9AB26345F04F3389905E934892DD21ACD011F6D778DEE7A10EA68EADCCEB096C2DBB782F5B744E523E65EB4DC5A724E0D8ED94786E537541B625736E21F199677AB7897E7349939A8EDACE186F186D3DBC60D4638FA411939EFA58F79F6F38DF52BEDB7DDAB714BDFE996BECF1CBA99C976421BD52D7CD803D53B77A7084B0BC23442D40BF0455CDD9ED80277EA8072538C29AF4285CA1C5010667E9A2B3514C048B9A2A5BF4B4D059C8A23FD45B7C5B6845A2343ADB784155B592BEDF891063956664598FD64CD41831E38B96C06B6CDBE11A054B2AEECDAEC7A9C3B6C41570A49DE645E6B97771CC87D0BD17F7FD7F40FAF21994110040000,NULL,3,NULL,142482),
	(275029,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D795445623104155005528550A11FE090496AC98FC8762ADAAFAFED9007845537D1CCBD27D79A8903CB0B67936F549A4AB10892300E2628CE32A7A25C049FA7B7E93C58A64F205519D6821ACA31740F433286A196CCBE1AD6347CD59A9682A3300785052A9B813B51C83EFA25484148C54FF66DC7A471184374A34086DAEC47CC4805D3F91075352829B9AB26345F04F3389905E934892DD21ACD011F6D778DEE7A10EA68EADCCEB096C2DBB782F5B744E523E65EB4DC5A724E0D8ED94786E537541B625736E21F199677AB7897E7349939A8EDACE186F186D3DBC60D4638FA411939EFA58F79F6F38DF52BEDB7DDAB714BDFE996BECF1CBA99C976421BD52D7CD803D53B77A7084B0BC23442D40BF0455CDD9ED80277EA8072538C29AF4285CA1C5010667E9A2B3514C048B9A2A5BF4B4D059C8A23FD45B7C5B6845A2343ADB784155B592BEDF891063956664598FD64CD41831E38B96C06B6CDBE11A054B2AEECDAEC7A9C3B6C41570A49DE645E6B97771CC87D0BD17F7FD7F40FAF21994110040000,NULL,3,NULL,142483),
	(275030,2,0x1F8B08000000000000009D93DD6E82401085EFFB14867B01AB4DBC183155D368D21853ED032C32D04DF687EC2E8DEDD377174456F0AA3764E69C8FB3996181E585B3D1372A4DA5580493300E4628CE32A3A258049FA7B7F13C58264F20551156821ACA31740F435286A196CCBE1A56347CD59A1682A3300785392A9B813B91CB2E7A162420A4E227FBB66392388C21BA5320456DF60366A082B9F910DD6A505272578D68B608E6F1F33448C693D822ADD11CF0D176D7E85B0F421D4D95D919D652D4F6BD60FD2D51D980E98B965B4BCEA9C121FBC8B0FC866A43ECCA06FC23C3F26E15EFF29CBCD450DB59C30DE3CA89D3DBC60D4638D6833272DECB3A665ACF37D4AF74BDED4E8D5BBAA75BBA9FE9BBA94977421B755BB8DF03D53B77A7084B72C23442D409F0455CDD9ED8023DD5A3DC1443AA56A144650E2808333FCD95F2053052AE6851DFA5A6024EC591FE623283A82DA1D2C850EB2D61F956564A3B7EA04186A55911663F597390D70327978D67DBEC3B010A25ABD2AECDAEC7B97E0BBA5448B226F35ABBBCA327772D44FFFD5D933F98BADE6B10040000,NULL,3,NULL,142484),
	(275031,2,0x1F8B08000000000000009D93DD6E82401085EFFB14867B01AB4DBC183155D368D21853ED032C32D04DF687EC2E8DEDD377174456F0AA3764E69C8FB3996181E585B3D1372A4DA5580493300E4628CE32A3A258049FA7B7F13C58264F20551156821ACA31740F435286A196CCBE1A56347CD59A1682A3300785392A9B813B91CB2E7A162420A4E227FBB66392388C21BA5320456DF60366A082B9F910DD6A505272578D68B608E6F1F33448C693D822ADD11CF0D176D7E85B0F421D4D95D919D652D4F6BD60FD2D51D980E98B965B4BCEA9C121FBC8B0FC866A43ECCA06FC23C3F26E15EFF29CBCD450DB59C30DE3CA89D3DBC60D4638D6833272DECB3A665ACF37D4AF74BDED4E8D5BBAA75BBA9FE9BBA94977421B755BB8DF03D53B77A7084B72C23442D409F0455CDD9ED8023DD5A3DC1443AA56A144650E2808333FCD95F2053052AE6851DFA5A6024EC591FE623283A82DA1D2C850EB2D61F956564A3B7EA04186A55911663F597390D70327978D67DBEC3B010A25ABD2AECDAEC7B97E0BBA5448B226F35ABBBCA327772D44FFFD5D933F98BADE6B10040000,NULL,3,NULL,142485),
	(275032,2,0x1F8B08000000000000009D93DD6E82401085EFFB14867B01AB4DBC183155D368D21853ED032C32D04DF687EC2E8DEDD377174456F0AA3764E69C8FB3996181E585B3D1372A4DA5580493300E4628CE32A3A258049FA7B7F13C58264F20551156821ACA31740F435286A196CCBE1A56347CD59A1682A3300785392A9B813B91CB2E7A162420A4E227FBB66392388C21BA5320456DF60366A082B9F910DD6A505272578D68B608E6F1F33448C693D822ADD11CF0D176D7E85B0F421D4D95D919D652D4F6BD60FD2D51D980E98B965B4BCEA9C121FBC8B0FC866A43ECCA06FC23C3F26E15EFF29CBCD450DB59C30DE3CA89D3DBC60D4638D6833272DECB3A665ACF37D4AF74BDED4E8D5BBAA75BBA9FE9BBA94977421B755BB8DF03D53B77A7084B72C23442D409F0455CDD9ED8023DD5A3DC1443AA56A144650E2808333FCD95F2053052AE6851DFA5A6024EC591FE623283A82DA1D2C850EB2D61F956564A3B7EA04186A55911663F597390D70327978D67DBEC3B010A25ABD2AECDAEC7B97E0BBA5448B226F35ABBBCA327772D44FFFD5D933F98BADE6B10040000,NULL,3,NULL,142486),
	(275033,2,0x1F8B08000000000000009D934D4EC3301085F79CA2CA9E24942EBA98BA8222D44A0855140EE0349360C93F91ED20E0F478D286380D2B36D5BCF7BE8C3D9314D69F4ACE3ED03A61F42AB949F36486FA684AA1EB55F2F6FA78BD4CD6EC0A8CADD3560B2F14A6F4E379213175468647D356A477CE895A2BD47E6FB1421B7AE04E576668BD48186863D56B789A1876BD4873C8461614E8FCF3149AD8E00700B25F01D61845D54C94AB6499CFC3A104F4F6E980975E51343240DB836FCB30C5C6E88AD1F54646C8B7DC9613E6D20CDCC628253C4ED9BF82C03F08E77958DA84FF2B083CADE2C91CD9ED82A05E858086E902F27B41837185DDA0921F9F4DD7E6A69B6FEA9FE96EDB839BF7F4851FE84875D789D3C2173BEDBCED164CEF32D620DC8EBE2A2E59C5A543C80603DE39D5FD893D70E146144D31A53A171AB47E8F9A4BFFC572FAA46203BC31F7A2A6DB9D2B50421FC437B239647D09AD4389CE6DB9ACB6A6B58EF889072536FE9ECBF0CA4E07451A14FF7C88E2D07B64406D4DDB84B585F5501A4B708D455E9E7A9E6BEA7788EC4142F6DF3F2CFB01AC72DF4712040000,NULL,3,NULL,142487),
	(275034,2,0x1F8B08000000000000009D93DD4EC2401085EF7D0AD27BDBA25C68322C118D81C41822F8000B9DD64DF687EC6E8DFAF4EE2CD42E942B6FC89C73BECEEE4C0BCCBE941C7DA275C2E86936CECB6C847A672AA19B69F6BE79BEBECB66EC0A8C6DF2560B2F14E6F4E3F95662EE8C0C8FE6ADC81F9C138D56A8FDCA628D36F4C0A5AE4DDF7A9231D0C6AA4D789A18763DC94B284E2CD8A2F3AF43686083EF0128FE045863145523514DB3BB727C9F45A0B30F07BC758AA21303B45DFBB60A533C1A5D33BADE8911F205B7D580393703F76894121E87ECA520F04FC2791E9636E02F0581A755BC981DBB9D10D4A910D0303120BF133418571807957CF76A629B885CF08F74DC76EF961D7DE6073A51F13A69BAF5DBA576DEC605D3BB4C3508B7A4AF8A4B5673E9108ADE800F4E757762079CB90945530CA9E8C21EAD5FA1E6D27FB3923EA9D4006FCC5C3474BB63054AE8B5F8417603455742EB50A2730B2EEB8569AD237EE041857B3FE732BCB2C3418906C5BF9E9238F43E31A0B1A6DD87B585F5509A4A707B8BBC3AF43CD6D46F9DD8BD84E2BF7F58F60BAB69A6E912040000,NULL,3,NULL,142488),
	(275035,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D79546DC562082AA00AA40AA1423FC02193D4921F91ED54B45F5F3B21C124ACBA89E6DE7B32D64C1C589C399B7CA3D2548A79908471304171923915E53CF83CBE4D67C1227D00A9CAB016D4508EA17B1892310CB564F6D5B0A6E1ABD6B4141C85D92B2C50D91EB81585BCB67E0A521052F1A37DDB31691CC610DD3890A136BB113372C1F439447D0D4A4AEEAA09CDE7C12C4E5E82749AC416E982F6808F4E5D5AF71A843A983AB733ACA468E25BC3E61BA2F21133342DB7929C538363F65E60F935D586D8958DF87B81E5DD2ADEE5297D7C7650A76CE0867165E2FC4EB8C108C76650464E3BE9CD37F62F74B3ED3BF4C0B7F490F2D3CC645BA18DEA17EE6BA07AEBEE14616941984688AE067C1157772776C0C0F52837C5986A5CA850993D0AC2CC4F7BA57C038C944B5A3677A9AD805371A0BFE8B6D895506B64A8F586B062236BA51D3FF220C7CA2C09B39FAC3DC8D3C0C979EDC5B6F78D01A5927565D766D7E3525F82AE1492BCED79A95DBF83675F2544FFFD5DD33F7615AFDB10040000,NULL,3,NULL,142489),
	(275036,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D79546DC562082AA00AA40AA1423FC02193D4921F91ED54B45F5F3B21C124ACBA89E6DE7B32D64C1C589C399B7CA3D2548A79908471304171923915E53CF83CBE4D67C1227D00A9CAB016D4508EA17B1892310CB564F6D5B0A6E1ABD6B4141C85D92B2C50D91EB81585BCB67E0A521052F1A37DDB31691CC610DD3890A136BB113372C1F439447D0D4A4AEEAA09CDE7C12C4E5E82749AC416E982F6808F4E5D5AF71A843A983AB733ACA468E25BC3E61BA2F21133342DB7929C538363F65E60F935D586D8958DF87B81E5DD2ADEE5297D7C7650A76CE0867165E2FC4EB8C108C76650464E3BE9CD37F62F74B3ED3BF4C0B7F490F2D3CC645BA18DEA17EE6BA07AEBEE14616941984688AE067C1157772776C0C0F52837C5986A5CA850993D0AC2CC4F7BA57C038C944B5A3677A9AD805371A0BFE8B6D895506B64A8F586B062236BA51D3FF220C7CA2C09B39FAC3DC8D3C0C979EDC5B6F78D01A5927565D766D7E3525F82AE1492BCED79A95DBF83675F2544FFFD5DD33F7615AFDB10040000,NULL,3,NULL,142490),
	(275037,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D79546DC562082AA00AA40AA1423FC02193D4921F91ED54B45F5F3B21C124ACBA89E6DE7B32D64C1C589C399B7CA3D2548A79908471304171923915E53CF83CBE4D67C1227D00A9CAB016D4508EA17B1892310CB564F6D5B0A6E1ABD6B4141C85D92B2C50D91EB81585BCB67E0A521052F1A37DDB31691CC610DD3890A136BB113372C1F439447D0D4A4AEEAA09CDE7C12C4E5E82749AC416E982F6808F4E5D5AF71A843A983AB733ACA468E25BC3E61BA2F21133342DB7929C538363F65E60F935D586D8958DF87B81E5DD2ADEE5297D7C7650A76CE0867165E2FC4EB8C108C76650464E3BE9CD37F62F74B3ED3BF4C0B7F490F2D3CC645BA18DEA17EE6BA07AEBEE14616941984688AE067C1157772776C0C0F52837C5986A5CA850993D0AC2CC4F7BA57C038C944B5A3677A9AD805371A0BFE8B6D895506B64A8F586B062236BA51D3FF220C7CA2C09B39FAC3DC8D3C0C979EDC5B6F78D01A5927565D766D7E3525F82AE1492BCED79A95DBF83675F2544FFFD5DD33F7615AFDB10040000,NULL,3,NULL,142491),
	(275038,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D79546DC562082AA00AA40AA1423FC02193D4921F91ED54B45F5F3B21C124ACBA89E6DE7B32D64C1C589C399B7CA3D2548A79908471304171923915E53CF83CBE4D67C1227D00A9CAB016D4508EA17B1892310CB564F6D5B0A6E1ABD6B4141C85D92B2C50D91EB81585BCB67E0A521052F1A37DDB31691CC610DD3890A136BB113372C1F439447D0D4A4AEEAA09CDE7C12C4E5E82749AC416E982F6808F4E5D5AF71A843A983AB733ACA468E25BC3E61BA2F21133342DB7929C538363F65E60F935D586D8958DF87B81E5DD2ADEE5297D7C7650A76CE0867165E2FC4EB8C108C76650464E3BE9CD37F62F74B3ED3BF4C0B7F490F2D3CC645BA18DEA17EE6BA07AEBEE14616941984688AE067C1157772776C0C0F52837C5986A5CA850993D0AC2CC4F7BA57C038C944B5A3677A9AD805371A0BFE8B6D895506B64A8F586B062236BA51D3FF220C7CA2C09B39FAC3DC8D3C0C979EDC5B6F78D01A5927565D766D7E3525F82AE1492BCED79A95DBF83675F2544FFFD5DD33F7615AFDB10040000,NULL,3,NULL,142492),
	(275039,2,0x1F8B08000000000000009D93CF6EC2300CC6EF7B0AD43B6DD938703041033481342134D803A4D4ED22E54F95A413DBD32F69690994D32E95FD7DBF38B2E3C2E22CF8E81BB5614ACEA3499C46239427953359CEA3CFE3DB78162DC813285DC6B56496098CFDC7D28C636C147747E39AC5AFC6B0520A9476AFB140ED6AE05616EA5A7A1A11904A8BA33BED1992C62924370A6468EC6EC00C54B0BD0F491F83564AF868C4F279344B9F5F22329EA40EE98CF6828F2EBB94EE7390FA60EBDCF5B052B2B16F05E76FA8CE07CCBDE8B8951282591CB28F0CC7AF99B1D48D6CC03F321CEF47F1AE4E64D2405DE60CDF4C6378BD4B7C635460D328A7A79D0AFA1BEA17BA99F603FA4E77F43D15BA99CDB6D258DD0F3CCC8199ADDF29CA4941B94148AE027C511F773776C09D1A50BE8B21D5A850A1B67B9494DB9F76A54201AC524B5636BBD44620983CB05F245348BA106A831C8DD9505E6C54AD8DE7071AE458D925E5EEC9DA8B821C043DAF03DBD5BE11A0D4AAAEDCD8DC78C878EA173754C0541A69DE96BDC4BEE42190AF2924FFFD63C91FCD01D25D13040000,NULL,3,NULL,142493),
	(275040,2,0x1F8B08000000000000009D93CF6EC2300CC6EF7B0AD43B6DD938703041033481342134D803A4D4ED22E54F95A413DBD32F69690994D32E95FD7DBF38B2E3C2E22CF8E81BB5614ACEA3499C46239427953359CEA3CFE3DB78162DC813285DC6B56496098CFDC7D28C636C147747E39AC5AFC6B0520A9476AFB140ED6AE05616EA5A7A1A11904A8BA33BED1992C62924370A6468EC6EC00C54B0BD0F491F83564AF868C4F279344B9F5F22329EA40EE98CF6828F2EBB94EE7390FA60EBDCF5B052B2B16F05E76FA8CE07CCBDE8B8951282591CB28F0CC7AF99B1D48D6CC03F321CEF47F1AE4E64D2405DE60CDF4C6378BD4B7C635460D328A7A79D0AFA1BEA17BA99F603FA4E77F43D15BA99CDB6D258DD0F3CCC8199ADDF29CA4941B94148AE027C511F773776C09D1A50BE8B21D5A850A1B67B9494DB9F76A54201AC524B5636BBD44620983CB05F245348BA106A831C8DD9505E6C54AD8DE7071AE458D925E5EEC9DA8B821C043DAF03DBD5BE11A0D4AAAEDCD8DC78C878EA173754C0541A69DE96BDC4BEE42190AF2924FFFD63C91FCD01D25D13040000,NULL,3,NULL,142494),
	(275041,2,0x1F8B08000000000000009D93CF6EC2300CC6EF7B0AD43B6DD938703041033481342134D803A4D4ED22E54F95A413DBD32F69690994D32E95FD7DBF38B2E3C2E22CF8E81BB5614ACEA3499C46239427953359CEA3CFE3DB78162DC813285DC6B56496098CFDC7D28C636C147747E39AC5AFC6B0520A9476AFB140ED6AE05616EA5A7A1A11904A8BA33BED1992C62924370A6468EC6EC00C54B0BD0F491F83564AF868C4F279344B9F5F22329EA40EE98CF6828F2EBB94EE7390FA60EBDCF5B052B2B16F05E76FA8CE07CCBDE8B8951282591CB28F0CC7AF99B1D48D6CC03F321CEF47F1AE4E64D2405DE60CDF4C6378BD4B7C635460D328A7A79D0AFA1BEA17BA99F603FA4E77F43D15BA99CDB6D258DD0F3CCC8199ADDF29CA4941B94148AE027C511F773776C09D1A50BE8B21D5A850A1B67B9494DB9F76A54201AC524B5636BBD44620983CB05F245348BA106A831C8DD9505E6C54AD8DE7071AE458D925E5EEC9DA8B821C043DAF03DBD5BE11A0D4AAAEDCD8DC78C878EA173754C0541A69DE96BDC4BEE42190AF2924FFFD63C91FCD01D25D13040000,NULL,3,NULL,142495),
	(275042,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E245454653118155005528550690FE090496AC93F91ED54B4A7AF9D906008AB6EA279EF7D196B260E2C4E828FBE511BA6E43C9AC469344279543993E53CFAFC781DCFA2057900A5CBB896CC3281B17F589A718C8DE2EED5B866F18B31AC9402A5DD6B2C50BB1EB89585BAB49E4604A4D2E2C3BDED1992C62924570E6468EC6EC00C5CB07D0E495F83564AF86AC4F279344B1FD3C8E79DDB767FEFD4B96FAF41EA83AD7337C04AC926BE365CBEA13A1F30B7A6E3564A086671C8DE0B1CBF66C652B7AF017F2F70BCDFC39B3A92A706EA940BFC30BE9C7ABF137E302AB01994D3E34E05F30DFD33DDACFA0E7DE33B3A50CF9E0AD3CC665B69ACEE171E6A6066EB2F14E5A4A0DC20241703BEA8AFBB133BE0C60D283FC5906A5CA850DB3D4ACAED4F7B9F4203AC524B563617A9AD40307960BF4826907425D406391AB3A1BCD8A85A1BCF0F3CC8B1B24BCADD276B0F0A34087A5A07B1EB7D6540A9555DB9B5B9F590F1247540E880A934D2BC6D7BAE7DCB43605F2424FFFD5DC91FBA15748610040000,NULL,3,NULL,142496),
	(275043,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E245454653118155005528550690FE090496AC93F91ED54B4A7AF9D906008AB6EA279EF7D196B260E2C4E828FBE511BA6E43C9AC469344279543993E53CFAFC781DCFA2057900A5CBB896CC3281B17F589A718C8DE2EED5B866F18B31AC9402A5DD6B2C50BB1EB89585BAB49E4604A4D2E2C3BDED1992C62924570E6468EC6EC00C5CB07D0E495F83564AF86AC4F279344B1FD3C8E79DDB767FEFD4B96FAF41EA83AD7337C04AC926BE365CBEA13A1F30B7A6E3564A086671C8DE0B1CBF66C652B7AF017F2F70BCDFC39B3A92A706EA940BFC30BE9C7ABF137E302AB01994D3E34E05F30DFD33DDACFA0E7DE33B3A50CF9E0AD3CC665B69ACEE171E6A6066EB2F14E5A4A0DC20241703BEA8AFBB133BE0C60D283FC5906A5CA850DB3D4ACAED4F7B9F4203AC524B563617A9AD40307960BF4826907425D406391AB3A1BCD8A85A1BCF0F3CC8B1B24BCADD276B0F0A34087A5A07B1EB7D6540A9555DB9B5B9F590F1247540E880A934D2BC6D7BAE7DCB43605F2424FFFD5DC91FBA15748610040000,NULL,3,NULL,142497),
	(275044,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E245454653118155005528550690FE090496AC93F91ED54B4A7AF9D906008AB6EA279EF7D196B260E2C4E828FBE511BA6E43C9AC469344279543993E53CFAFC781DCFA2057900A5CBB896CC3281B17F589A718C8DE2EED5B866F18B31AC9402A5DD6B2C50BB1EB89585BAB49E4604A4D2E2C3BDED1992C62924570E6468EC6EC00C5CB07D0E495F83564AF86AC4F279344B1FD3C8E79DDB767FEFD4B96FAF41EA83AD7337C04AC926BE365CBEA13A1F30B7A6E3564A086671C8DE0B1CBF66C652B7AF017F2F70BCDFC39B3A92A706EA940BFC30BE9C7ABF137E302AB01994D3E34E05F30DFD33DDACFA0E7DE33B3A50CF9E0AD3CC665B69ACEE171E6A6066EB2F14E5A4A0DC20241703BEA8AFBB133BE0C60D283FC5906A5CA850DB3D4ACAED4F7B9F4203AC524B563617A9AD40307960BF4826907425D406391AB3A1BCD8A85A1BCF0F3CC8B1B24BCADD276B0F0A34087A5A07B1EB7D6540A9555DB9B5B9F590F1247540E880A934D2BC6D7BAE7DCB43605F2424FFFD5DC91FBA15748610040000,NULL,3,NULL,142498),
	(275045,2,0x1F8B08000000000000009D93CD6EC2300C80EF7B0AD43B6D9998C6C1140DD004D284D0D81E20A5A68B949F2A4927B6A79FD3520894D32E95FDF9AB23BB29CC8E520CBED158AED5341AC5693440B5D70557E534FAFC781D4EA259F600DA9471ADB8E31263FF702C17185B2DE8D5B8E6F18BB5BC541295DB1A3CA0A11EB856077D693D8E3250DAC80F7ADB3B591AA7905C11C8D1BA4DCFE95170E73A24E7188CD6D247035E4CA349FA482752BDA36DF7F72E3BF53DE7A0CCCED5050DB0D0AA295F03AAAF98297ACE2D246FA1A5E40EFBEEBD02F94B6E1DA37DF5FC7B05F2FD1EDEF43E7B6AA42EA3821FC68763CFBBC40FC62436830AB6DFE8A64DA3DCE127BB59F585A69D7DC3C90EB2676F85D5DCE56B659D392F3CCC81DBB5BF504C6407262C427201F0C57CDC9DD8093734B0FC147DABA150A1715B544CB89FF63E85009CD6735E6623BA486D0492AB1DFF458FBA106A8B02AD5D317158E9DA583F4D8F4181959B33419FAC3D28C841B2E3322853EF2B00A5D175456BA3F564C3514A4248C0560659D1B63DC5BEE52EC0971492FFFEAED91F27D1A70E10040000,NULL,3,NULL,142499),
	(275046,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E245454653118155005528550690FE090496AC93F91ED54B4A7AF9D906008AB6EA279EF7D196B260E2C4E828FBE511BA6E43C9AC469344279543993E53CFAFC781DCFA2057900A5CBB896CC3281B17F589A718C8DE2EED5B866F18B31AC9402A5DD6B2C50BB1EB89585BAB49E4604A4D2E2C3BDED1992C62924570E6468EC6EC00C5CB07D0E495F83564AF86AC4F279344B1FD3C8E79DDB767FEFD4B96FAF41EA83AD7337C04AC926BE365CBEA13A1F30B7A6E3564A086671C8DE0B1CBF66C652B7AF017F2F70BCDFC39B3A92A706EA940BFC30BE9C7ABF137E302AB01994D3E34E05F30DFD33DDACFA0E7DE33B3A50CF9E0AD3CC665B69ACEE171E6A6066EB2F14E5A4A0DC20241703BEA8AFBB133BE0C60D283FC5906A5CA850DB3D4ACAED4F7B9F4203AC524B563617A9AD40307960BF4826907425D406391AB3A1BCD8A85A1BCF0F3CC8B1B24BCADD276B0F0A34087A5A07B1EB7D6540A9555DB9B5B9F590F1247540E880A934D2BC6D7BAE7DCB43605F2424FFFD5DC91FBA15748610040000,NULL,3,NULL,142500),
	(275047,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E245454653118155005528550690FE090496AC93F91ED54B4A7AF9D906008AB6EA279EF7D196B260E2C4E828FBE511BA6E43C9AC469344279543993E53CFAFC781DCFA2057900A5CBB896CC3281B17F589A718C8DE2EED5B866F18B31AC9402A5DD6B2C50BB1EB89585BAB49E4604A4D2E2C3BDED1992C62924570E6468EC6EC00C5CB07D0E495F83564AF86AC4F279344B1FD3C8E79DDB767FEFD4B96FAF41EA83AD7337C04AC926BE365CBEA13A1F30B7A6E3564A086671C8DE0B1CBF66C652B7AF017F2F70BCDFC39B3A92A706EA940BFC30BE9C7ABF137E302AB01994D3E34E05F30DFD33DDACFA0E7DE33B3A50CF9E0AD3CC665B69ACEE171E6A6066EB2F14E5A4A0DC20241703BEA8AFBB133BE0C60D283FC5906A5CA850DB3D4ACAED4F7B9F4203AC524B563617A9AD40307960BF4826907425D406391AB3A1BCD8A85A1BCF0F3CC8B1B24BCADD276B0F0A34087A5A07B1EB7D6540A9555DB9B5B9F590F1247540E880A934D2BC6D7BAE7DCB43605F2424FFFD5DC91FBA15748610040000,NULL,3,NULL,142501),
	(275048,2,0x1F8B08000000000000009D93CD6EC2300C80EF7B0AD43B6D9998C6C1140DD004D284D0D81E20A5A68B949F2A4927B6A79FD3520894D32E95FDF9AB23BB29CC8E520CBED158AED5341AC5693440B5D70557E534FAFC781D4EA259F600DA9471ADB8E31263FF702C17185B2DE8D5B8E6F18BB5BC541295DB1A3CA0A11EB856077D693D8E3250DAC80F7ADB3B591AA7905C11C8D1BA4DCFE95170E73A24E7188CD6D247035E4CA349FA482752BDA36DF7F72E3BF53DE7A0CCCED5050DB0D0AA295F03AAAF98297ACE2D246FA1A5E40EFBEEBD02F94B6E1DA37DF5FC7B05F2FD1EDEF43E7B6AA42EA3821FC68763CFBBC40FC62436830AB6DFE8A64DA3DCE127BB59F585A69D7DC3C90EB2676F85D5DCE56B659D392F3CCC81DBB5BF504C6407262C427201F0C57CDC9DD8093734B0FC147DABA150A1715B544CB89FF63E85009CD6735E6623BA486D0492AB1DFF458FBA106A8B02AD5D317158E9DA583F4D8F4181959B33419FAC3D28C841B2E3322853EF2B00A5D175456BA3F564C3514A4248C0560659D1B63DC5BEE52EC0971492FFFEAED91F27D1A70E10040000,NULL,3,NULL,142502),
	(275049,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E245454653118155005528550690FE090496AC93F91ED54B4A7AF9D906008AB6EA279EF7D196B260E2C4E828FBE511BA6E43C9AC469344279543993E53CFAFC781DCFA2057900A5CBB896CC3281B17F589A718C8DE2EED5B866F18B31AC9402A5DD6B2C50BB1EB89585BAB49E4604A4D2E2C3BDED1992C62924570E6468EC6EC00C5CB07D0E495F83564AF86AC4F279344B1FD3C8E79DDB767FEFD4B96FAF41EA83AD7337C04AC926BE365CBEA13A1F30B7A6E3564A086671C8DE0B1CBF66C652B7AF017F2F70BCDFC39B3A92A706EA940BFC30BE9C7ABF137E302AB01994D3E34E05F30DFD33DDACFA0E7DE33B3A50CF9E0AD3CC665B69ACEE171E6A6066EB2F14E5A4A0DC20241703BEA8AFBB133BE0C60D283FC5906A5CA850DB3D4ACAED4F7B9F4203AC524B563617A9AD40307960BF4826907425D406391AB3A1BCD8A85A1BCF0F3CC8B1B24BCADD276B0F0A34087A5A07B1EB7D6540A9555DB9B5B9F590F1247540E880A934D2BC6D7BAE7DCB43605F2424FFFD5DC91FBA15748610040000,NULL,3,NULL,142503),
	(275050,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E245420B1188C0AA802A942A8B40770C824B5E49FC8762ADAD3D74E4830845537D1BCF7BE8C3513079667C147DFA80D5372114DE2341AA13CA99CC972117D7EBC8EE7D1923C81D2655C4B6699C0D83F2CCD38C64671F76A5CB3F8C518564A81D21E3416A85D0FDCC9425D5B4F23025269F1E1DEF60C49E314921B073234763F60062ED83E87A4AF412B257C3562F9229AA7CF69E4F3CE6DBBBF77EAD2B7D720F5D1D6B91B60AD6413DF1A2EDF529D0F987BD3716B2504B338641F058EDF3063A9DBD7807F1438DEEFE14D9DC8AC813AE5023F8C2FA7DEEF841F8C0A6C06E5F4B457C17C43FF4237AB7E40DFF98E0ED4CC53619AD96C278DD5FDC2430DCCECFC85A29C14941B84E46AC017F575776207DCB901E5A718528D0B156A7B4049B9FD69EF536880556AC5CAE622B51508268FEC17C90492AE84DA204763B694175B556BE3F9810739567645B9FB64ED41810641CF9B2076BD6F0C28B5AA2BB736B71E329EA40E081D3095469AB76D2FB56F790CECAB84E4BFBF2BF903EB0F506010040000,NULL,3,NULL,142504),
	(275051,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E245420B1188C0AA802A942A8B40770C824B5E49FC8762ADAD3D74E4830845537D1BCF7BE8C3513079667C147DFA80D5372114DE2341AA13CA99CC972117D7EBC8EE7D1923C81D2655C4B6699C0D83F2CCD38C64671F76A5CB3F8C518564A81D21E3416A85D0FDCC9425D5B4F23025269F1E1DEF60C49E314921B073234763F60062ED83E87A4AF412B257C3562F9229AA7CF69E4F3CE6DBBBF77EAD2B7D720F5D1D6B91B60AD6413DF1A2EDF529D0F987BD3716B2504B338641F058EDF3063A9DBD7807F1438DEEFE14D9DC8AC813AE5023F8C2FA7DEEF841F8C0A6C06E5F4B457C17C43FF4237AB7E40DFF98E0ED4CC53619AD96C278DD5FDC2430DCCECFC85A29C14941B84E46AC017F575776207DCB901E5A718528D0B156A7B4049B9FD69EF536880556AC5CAE622B51508268FEC17C90492AE84DA204763B694175B556BE3F9810739567645B9FB64ED41810641CF9B2076BD6F0C28B5AA2BB736B71E329EA40E081D3095469AB76D2FB56F790CECAB84E4BFBF2BF903EB0F506010040000,NULL,3,NULL,142505),
	(275052,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E245420B1188C0AA802A942A8B40770C824B5E49FC8762ADAD3D74E4830845537D1BCF7BE8C3513079667C147DFA80D5372114DE2341AA13CA99CC972117D7EBC8EE7D1923C81D2655C4B6699C0D83F2CCD38C64671F76A5CB3F8C518564A81D21E3416A85D0FDCC9425D5B4F23025269F1E1DEF60C49E314921B073234763F60062ED83E87A4AF412B257C3562F9229AA7CF69E4F3CE6DBBBF77EAD2B7D720F5D1D6B91B60AD6413DF1A2EDF529D0F987BD3716B2504B338641F058EDF3063A9DBD7807F1438DEEFE14D9DC8AC813AE5023F8C2FA7DEEF841F8C0A6C06E5F4B457C17C43FF4237AB7E40DFF98E0ED4CC53619AD96C278DD5FDC2430DCCECFC85A29C14941B84E46AC017F575776207DCB901E5A718528D0B156A7B4049B9FD69EF536880556AC5CAE622B51508268FEC17C90492AE84DA204763B694175B556BE3F9810739567645B9FB64ED41810641CF9B2076BD6F0C28B5AA2BB736B71E329EA40E081D3095469AB76D2FB56F790CECAB84E4BFBF2BF903EB0F506010040000,NULL,3,NULL,142506),
	(275053,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E2454B4623104155005528550690FE090496AC93F91ED54B4A7AF9D106230AB6EA279EF7D196B260E2C4E9C8DBE51692AC53C9AC469344271940515D53CFAFC781DCFA245F60052557123A8A11C63F7302467186BC9ECAB7143E317AD6925380AB35758A2B23D702B4A39B49E461908A9F8877DDB31591AA7905C3990A336BB80095C30971C924B0D4A4AEEAA112DE6D12C7D4C2397F76ED7FDBD57E7BE170D421D4C53D8015652B4F1B561F30D5145C0DC9A965B49CEA9C190BD17587E4DB521765F017F2FB0BCDBC39B3C664F2DD42B1BB8615C39757E2FDC6084633B2823C79DF4E60BFD33DDAE7A70273D7DE35BDA53CF8EF2D3DCE45BA18DBA2CDCD740F5D65D28C2B292308D900C067C1157F727F6C08DEB516E8A906A5DA851993D0AC2CC4F779F7C038C944B5AB517A9AB805371A0BFE886EE4B683432D47A4358B9918DD28E0F3C28B0364BC2EC27EB0EF23470725A7BB1ED7D6540A56453DBB5D9F564E3496A01DF015D2B2445D7F65CBB9607CF1E2424FFFD5DB33F0E3BFEC410040000,NULL,3,NULL,142507),
	(275054,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D49A059B0188C0AA802A942A8B41FE090496AC98FC8762ADAAFAF9D9007845537D1CCBD27D79A8903AB8BE0936FD48629B90C66611C4C509E55C664B10C3E3F5EA78B60459E40E922AC24B34C60E81F96A61C43A3B87B35AC58F8620C2BA440698F1A73D42E03F732577D741210904A8B0FF7B667481CC610DD2890A2B187113352C1763E445D0D5A29E1AB09CB96C1229E3F07643A8B1DD21ACD01EF6D778DEE7A90FA64ABCCCDB051B2B66F05E7EFA8CE46CCBDE8B88D1282591CB38F0CC76F99B1D4AD6CC43F321CEF57F1A6CE24A9A1B673861FC69733AFB78D1F8C0AAC07E5F47C5075CCBC9E6FAC5FE97ADBBD1AB7F49DEEE8FBCCA19BDA742F8DD5DDC2873D30B3F7778A7292536E10A25E802FEAEBF6C416B85307949F624CD52A94A8ED1125E5F6A7B9524301AC526B56D477A9A940307962BF481288DA122A831C8DD9519EEF54A58D9F75A44186A55D53EE3E5973D0A007412FDB81EDB26F0428B4AA4AB736B71E324DFCC51D2A604A8D346B62AFB58F3C0DE4BE85E8BF7F2CF9032143748513040000,NULL,3,NULL,142508),
	(275055,2,0x1F8B08000000000000009D93CF6EC2300CC6EF7B0AD43B6DD938703041033481342134D803A4D4ED22E50F4AD289EDE997B41402E1B44B657FDF2F8EECB8303B093EF8466D9892D36494E6C900E541954CD6D3E473FF369C2433F2044AD7692399650253FFB1B4E0981AC5DDD1B461E9AB31AC9602A5DD6AAC50BB1AB89695BA961E2704A4D262EF4E7B86E4690ED98D02051ABB899848057BF121BBC4A095123E1AB0729A4CF2E797840C47B9437AA3BBE0A3CFCEA52F3948BDB34DE97A5828D9DAB782F357549711732F3A6EA184601663F691E1F8253396BA9145FC23C3F17E14EFEA40C62DD467CEF0CDF870E4F53EF18D51816DA39C1E362AE82FD6CF743BED07F49DEEE87B2A740B5BACA5B1FA32F0300766D67EA7282715E50621BB0AF0457DDCDFD803776A40F92E62AA55E188DA6E51526E7FBA950A05B04ACD59DDEE5217816072C77E918C21EB43680C7234664579B5528D369E8F3428F168E794BB27EB2E0A7210F4B40C6C57FB46805AABE6E8C6E6C6438663BFB8A102E6A891965DD973EC4BEE02F99A42F6DF3F96FC01DEC5222813040000,NULL,3,NULL,142509),
	(275056,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D4968B3603118155005528550A11FE090496AC98FC8762ADAAFAF9D9007845537D1CCBD27D79A8903CB8BE0936FD48629B90866611C4C509E55C664B1083E4F6FD379B0244FA074115692592630F40F4B538EA151DCBD1A562C7C35861552A0B4078D396A97813B99AB3E3A090848A5C5C9BDED1912873144370AA468EC7EC48C54B09D0F515783564AF86AC2B245308F9F5F02329DC50E698DE6808FB6BB46773D487DB455E666582B59DBB782F3B7546723E65E74DC5A09C12C8ED94786E337CC58EA5636E21F198EF7AB78576792D450DB39C30FE3CB99D7DBC60F4605D683727ADEAB3AA6461EE857BADE76AFC62D7DA73BFA3E73E8A636DD496375B7F0610FCCECFC9DA29CE4941B84A817E08BFABA3DB105EED401E5A71853B50A256A7B4049B9FD69AED45000ABD48A15F55D6A2A104C1ED92F9204A2B684CA204763B694E75B5569E3F9910619967645B9FB64CD41831E04BD6C06B6CBBE11A0D0AA2ADDDADC7AC834F11777A8802935D2AC89BDD63EF23890FB16A2FFFEB1E40F3C7EB16D13040000,NULL,3,NULL,142510),
	(275057,2,0x1F8B08000000000000009D93CB6EC2301045F7FD0A943D79A04A653104155005528550A11FE090496AC98FC8762ADAAFAF9D90601256DD4433F79E5C6B260E2C2F9C4DBE51692AC52248C23898A038CB9C8A72117C9EDEA6F360993E815465580B6A28C7D03D0CC918865A32FB6A58D3F0556B5A0A8EC21C1416A86C06EE44216FD1CF410A422A7EB26F3B268DC318A23B0532D4663F62462A98DE87A8AF4149C95D35A1F92298C7B359E0FC4E6DD33FBAEE9ADBF720D4D1D4B91D602D4563DF0BD6DF12958F98A168B9B5E49C1A1CB38F0CCB6FA836C4EE6BC43F322CEFF6F02ECF69327350D759C30DE3CA17A7778D1B8C706C0665E4BC97DE7C63FD4A37AB7E400F744B0F29DFCD4CB613DAA87EE17E0F54EFDC85222C2D08D308D14D802FE2EAEEC40E18A81EE5A618538D0A152A73404198F969EF932F80917245CBE622B515702A8EF417D304A2AE845A2343ADB784155B592BEDF891063956664598FD64ED415E0F9C5C369E6DB3EF042895AC2BBB36BB9E749AC416F015D0954292B7B1D7DA451E3DF9D642F4DFDF35FD0324AD582C10040000,NULL,3,NULL,142511),
	(275058,2,0x1F8B08000000000000009D93CB4EC3301045F77C45957DF3A8906031358256A8951042143EC06DA6C1921F95EDA0C2D7334E9AD44DBA6213CDDC7B7CA39938F0705472F28DD609A3E74991E6C904F5CE944257F3E4F3E3797A9F3CB01B30B64A6B2DBC50988687E75B89A933928EA6B5481F9D139556A8FD9BC53D5ACAC0B5DE9B73F46DC2401BAB3EE87460589EE6905D28B045E75F47CC4805DFFB90F535586354A826A29C27F7F96C9604BF53DBF4F7AE3BE5F63D68BBF17549032C8C6EEC4B81FC15B7E588198AC42D8C52C2E398BD6610BF14CE73DAD788BF66101FF6F06276AC9805A8EBC808C384F22EE85D1306E30A9B4125DFBD9A68BEB17EA29B555FA1073AD1432A76B77EBBD6CEDB7EE1710FC2ADC385E292EDB97408D959802F1EEAEE8D1D3050232A4C31A61A150E68FD1B6A2EFD4F7B9F6201BC314FA26A2E525B81127A237E9115907525D40E253AB7E272BF32B575ACA00323114A3CF8272EE99BB56F8A7A50FCB88C6C0ABF10A0B2A63ED0DE683F6C5AE404C40AB883455EB6B1A73A446E22F9DC42F6DFFF95FD015EE03B2511040000,NULL,3,NULL,142512),
	(275059,2,0x1F8B08000000000000009D93CD6E82401080EF7D0AC35D84A6496D3262AAA6D1A431A6DA075864A09BEC8FD95D1ADBA7EF0E82AEE2A91732F3CDC72C33004C8F520CBED158AED5244AE3241AA0DAEB82AB6A127DEEDE86E3689A3D8036555C2BEEB8C4982E8EE50263AB85BF35AE79FC6A2DAF9444E536064B34BE07AE54A92FAD9FA20C943672E7EF26274BE20446570472B46EDD737A14DCB90EA3730C466B49D1801793689CA42F11D53B7AEAFED1656DDF730ECA6C5D5DF801E65A35E56BE0EB4B668A9E730BBD37D75272877DF75EC1FB0B6E1DF3FBEAF9F70ADEA73DBCEB7D963E92D465BE40C350F84CBC4B683026B11954B0FD5A07F3F5796B37ABBED0B4B36FB8B76FADB09ABB7CA5AC33E785873970BBA20F8A89AC64C2228C2E00BE18C5DD899D7043038BA6E85B0D85031AB741C584FB397D4F2100A7F58C57F4EC6D0492AB2DFF45425D08B54581D62E992897BA3696A6E93128F0E0664CF857763A28C841B2E32228FBDE57002AA3EB835F9B5F4F364C132F8404ECC1202B4E6DDB985A6E037C4961F4DFDF35FB030A7ECBE510040000,NULL,3,NULL,142513),
	(275060,2,0x1F8B08000000000000009D93CD6EC2300C80EF7B0AD43BFD99368D83291AA009A409A1C11E20A56E17293F55924E6C4FBFA4A525B49C76A9ECCF5F1DD94D6171E66CF28D4A5329E64112C6C104C549E65494F3E0F3F8369D058BF401A42AC35A50433986EE6148C630D492D957C39A86AF5AD352701466AFB040657BE05614F2DAFA29484148C58FF66DE7A4711843744320436D76236744C1F47588FA189494DC45139ACF83599C3C07AEDED1B6FB47975DFAF639087530756E075849D1946F81AD6F88CA47CE105A6F2539A706C7EEBD82F5D7541B62F735F2EF15ACEFF6F02E4F69F2E8A42EB305378C0B5F1CEF123718E1D80CCAC86927BDF9C6FC6237ABBED2A4B307DCDA43CBAF6626DB0A6D54BF703F07AAB7EE42119616846984E80AE08BB8B83BB11306D4B3DC1463ABA150A1327B1484999FF63EF9008C944B5A3617A98D805371A0BFE8C6E942A83532D47A4358B191B5D2CE1F31C8B1324BC2EC276B0FF272E0E4BCF6CAB6F70D8052C9BAB26BB3EB49A7496C059F80AE1492BC6D7B895DCB8387AF2944FFFD5DD33F1C1EF4BB10040000,NULL,3,NULL,142514),
	(275061,2,0x1F8B08000000000000009D93CD6E82401080EF7D0AC35D40D3B41E464CD5349A34C6D4F6011619E826FB437697C6F6E9BB0B022B78EA85CC7CF3319B1916585D389B7CA3D2548A65300BE36082E22C332A8A65F0F9F13A5D04ABE401A42AC24A50433986EE6148CA30D492D957C38A862F5AD3427014E6A83047657BE05EE4B26FFD182420A4E21FF66DE724711843744320456D0E236744C1747588BA189494DC45139A2D83453C9F07AEDED2A6FB7B9B5DFB7639087532556607D84851976F81ADEF88CA46CE105A6F2339A706C7EEBD82F5B7541B62F735F2EF15ACEFF6F026CFC96CEEA436B305378C0B9F1D6F133718E1580FCAC8F920BDF9C6FC6AD7ABEEE9ACB507DCDA43CBAFA626DD0B6D54B7703F07AAF7EE421196E4846984A807F0455CDC9ED80A03EA596E8AB15553285199230AC2CC4F739F7C0046CA352DEA8BD444C0A938D15F74E3B421541A196ABD232CDFC94AE9E409A211830C4BB326CC7EB2E6202F074E2E5BAF6C7BDF002894AC4ABB36BB9E643A8BADE013D0A54292356DAFB16B79F2709F42F4DFDF35F903DD90400410040000,NULL,3,NULL,142515),
	(275062,2,0x1F8B08000000000000009D934D6EC2301085F73D05CA9E24A0AA653118155005528550690FE090496AC93FC8762ADAD3D74E0818CCAA9B68E6BD2FCF9A8903B3A3E0836FD48629394D46699E0C50EE55C9643D4D3E3F5E879364461E40E93A6D24B34C60EA1F96161C53A3B87B356D58FA620CABA54069B71A2BD42E03D7B25297E8C78480545A7CB8B73D43F23487EC4A81028DDD444CA4823DFB909D6BD04A095F0D58394D26F9789C78BF57BBF4F7BE3BE59E7B907A679BD20DB050B2B5AF05E7AFA82E23E65674DC4209C12CC6EC3DC3F14B662C75FB8AF87B86E3FD1EDED49E8CC61EEA3B67F8617CF9ECF5BEF1835181EDA09CEE372A982FD64F74BBEA3BF48DEEE85B2A740B5BACA5B1FABCF0B00766D6FE42514E2ACA0D427611E08BFABA3FB1076ED480F253C454ABC201B5DDA2A4DCFE74F72914C02A3567757B91BA0A04933BF68B6404595F426390A3312BCAAB956AB4214F90451A9478B073CADD27EB0E0A7A10F4B80C6C977D2540AD5573706B73EB21C351EE80500173D048CB2EF654FBC85D205F5AC8FEFBBB923F69BECA4610040000,NULL,3,NULL,142516),
	(275063,2,0x1F8B08000000000000009D93CB4EC3301045F77C45957DF3A8906031358256A8951042143EC06DA6C1921F95EDA0C2D7334E9AD44DBA6213CDDC7B7CA39938F0705472F28DD609A3E74991E6C904F5CE944257F3E4F3E3797A9F3CB01B30B64A6B2DBC50988687E75B89A933928EA6B5481F9D139556A8FD9BC53D5ACAC0B5DE9B73F46DC2401BAB3EE87460589EE6905D28B045E75F47CC4805DFFB90F535586354A826A29C27F7F96C9604BF53DBF4F7AE3BE5F63D68BBF17549032C8C6EEC4B81FC15B7E588198AC42D8C52C2E398BD6610BF14CE73DAD788BF66101FF6F06276AC9805A8EBC808C384F22EE85D1306E30A9B4125DFBD9A68BEB17EA29B555FA1073AD1432A76B77EBBD6CEDB7EE1710FC2ADC385E292EDB97408D959802F1EEAEE8D1D3050232A4C31A61A150E68FD1B6A2EFD4F7B9F6201BC314FA26A2E525B81127A237E9115907525D40E253AB7E272BF32B575ACA00323114A3CF8272EE99BB56F8A7A50FCB88C6C0ABF10A0B2A63ED0DE683F6C5AE404C40AB883455EB6B1A73A446E22F9DC42F6DFFF95FD015EE03B2511040000,NULL,3,NULL,142517),
	(275064,2,0x1F8B08000000000000009D93CD6EC2300C80EF7B0AD43BFD4193C6C1140DD004D284D0600F9052B78B949F2A4927B6A75FD2D236504EBB54F6E7AF8EECA6B0BC7036F946A5A9148B2009E36082E22C732ACA45F0797A9BCE8365FA045295612DA8A11C43F7302463186AC9ECAB614DC357AD6929380A735058A0B23D70270A39B47E0E521052F1937DDB39691CC610DD10C8509BFDC81951307D1DA23E06252577D184E68B601ECF6681AB77B4EDFED165D7BE7D0E421D4D9DDB01D65234E55B60EB5BA2F291730FADB7969C538363F751C1FA1BAA0DB1FB1AF98F0AD6777B7897E7349939A9CB6CC10DE3C217C7BBC40D463836833272DE4B6FBE31BFDACDAA079A74F61DB7F6BDE5573393ED8436AA5FB89F03D53B77A1084B0BC234423400F8222EEE4EEC843BEA596E8AB1D550A85099030AC2CC4F7B9F7C0046CA152D9B8BD446C0A938D25F74E37421D41A196ABD25ACD8CA5A69E78F18E458991561F693B50779397072D97865DBFB0640A9645DD9B5D9F5A4D324B6824F40570A49DEB6BDC6AEE5D1C3430AD17F7FD7F40F9083D26E10040000,NULL,3,NULL,142518),
	(275065,2,0x1F8B08000000000000009D93CD6EC2300C80EF7B0AD43BFD99368D83291AA009A409A1C11E20A56E17293F55924E6C4FBFA4A525B49C76A9ECCF5F1DD94D6171E66CF28D4A5329E64112C6C104C549E65494F3E0F3F8369D058BF401A42AC35A50433986EE6148C630D492D957C39A86AF5AD352701466AFB040657BE05614F2DAFA29484148C58FF66DE7A4711843744320436D76236744C1F47588FA189494DC45139ACF83599C3C07AEDED1B6FB47975DFAF639087530756E075849D1946F81AD6F88CA47CE105A6F2539A706C7EEBD82F5D7541B62F735F2EF15ACEFF6F02E4F69F2E8A42EB305378C0B5F1CEF123718E1D80CCAC86927BDF9C6FC6237ABBED2A4B307DCDA43CBAF6626DB0A6D54BF703F07AAB7EE42119616846984E80AE08BB8B83BB11306D4B3DC1463ABA150A1327B1484999FF63EF9008C944B5A3617A98D805371A0BFE8C6E942A83532D47A4358B191B5D2CE1F31C8B1324BC2EC276B0FF272E0E4BCF6CAB6F70D8052C9BAB26BB3EB49A7496C059F80AE1492BC6D7B895DCB8387AF2944FFFD5DD33F1C1EF4BB10040000,NULL,3,NULL,142519),
	(275066,2,0x1F8B08000000000000009D93CD6EC2300C80EF7B0AD43BFD99368D83291AA009A409A1C11E20A56E17293F55924E6C4FBFA4A525B49C76A9ECCF5F1DD94D6171E66CF28D4A5329E64112C6C104C549E65494F3E0F3F8369D058BF401A42AC35A50433986EE6148C630D492D957C39A86AF5AD352701466AFB040657BE05614F2DAFA29484148C58FF66DE7A4711843744320436D76236744C1F47588FA189494DC45139ACF83599C3C07AEDED1B6FB47975DFAF639087530756E075849D1946F81AD6F88CA47CE105A6F2539A706C7EEBD82F5D7541B62F735F2EF15ACEFF6F02E4F69F2E8A42EB305378C0B5F1CEF123718E1D80CCAC86927BDF9C6FC6237ABBED2A4B307DCDA43CBAF6626DB0A6D54BF703F07AAB7EE42119616846984E80AE08BB8B83BB11306D4B3DC1463ABA150A1327B1484999FF63EF9008C944B5A3617A98D805371A0BFE8C6E942A83532D47A4358B191B5D2CE1F31C8B1324BC2EC276B0FF272E0E4BCF6CAB6F70D8052C9BAB26BB3EB49A7496C059F80AE1492BC6D7B895DCB8387AF2944FFFD5DD33F1C1EF4BB10040000,NULL,3,NULL,142520),
	(275067,2,0x1F8B08000000000000009D93CB4EC3301045F77C45957DF3A8906031358256A8951042143EC06DA6C1921F95EDA0C2D7334E9AD44DBA6213CDDC7B7CA39938F0705472F28DD609A3E74991E6C904F5CE944257F3E4F3E3797A9F3CB01B30B64A6B2DBC50988687E75B89A933928EA6B5481F9D139556A8FD9BC53D5ACAC0B5DE9B73F46DC2401BAB3EE87460589EE6905D28B045E75F47CC4805DFFB90F535586354A826A29C27F7F96C9604BF53DBF4F7AE3BE5F63D68BBF17549032C8C6EEC4B81FC15B7E588198AC42D8C52C2E398BD6610BF14CE73DAD788BF66101FF6F06276AC9805A8EBC808C384F22EE85D1306E30A9B4125DFBD9A68BEB17EA29B555FA1073AD1432A76B77EBBD6CEDB7EE1710FC2ADC385E292EDB97408D959802F1EEAEE8D1D3050232A4C31A61A150E68FD1B6A2EFD4F7B9F6201BC314FA26A2E525B81127A237E9115907525D40E253AB7E272BF32B575ACA00323114A3CF8272EE99BB56F8A7A50FCB88C6C0ABF10A0B2A63ED0DE683F6C5AE404C40AB883455EB6B1A73A446E22F9DC42F6DFFF95FD015EE03B2511040000,NULL,3,NULL,142521),
	(275068,2,0x1F8B08000000000000009D93CB4EC3301045F77C45957DF3A8906031358256A8951042143EC06DA6C1921F95EDA0C2D7334E9AD44DBA6213CDDC7B7CA39938F0705472F28DD609A3E74991E6C904F5CE944257F3E4F3E3797A9F3CB01B30B64A6B2DBC50988687E75B89A933928EA6B5481F9D139556A8FD9BC53D5ACAC0B5DE9B73F46DC2401BAB3EE87460589EE6905D28B045E75F47CC4805DFFB90F535586354A826A29C27F7F96C9604BF53DBF4F7AE3BE5F63D68BBF17549032C8C6EEC4B81FC15B7E588198AC42D8C52C2E398BD6610BF14CE73DAD788BF66101FF6F06276AC9805A8EBC808C384F22EE85D1306E30A9B4125DFBD9A68BEB17EA29B555FA1073AD1432A76B77EBBD6CEDB7EE1710FC2ADC385E292EDB97408D959802F1EEAEE8D1D3050232A4C31A61A150E68FD1B6A2EFD4F7B9F6201BC314FA26A2E525B81127A237E9115907525D40E253AB7E272BF32B575ACA00323114A3CF8272EE99BB56F8A7A50FCB88C6C0ABF10A0B2A63ED0DE683F6C5AE404C40AB883455EB6B1A73A446E22F9DC42F6DFFF95FD015EE03B2511040000,NULL,3,NULL,142522),
	(275069,2,0x1F8B08000000000000009D93DD6AC2401085EFFB14927B632CB658182355290A45A4DA0758CD982EEC4FD8DD14DBA7EF6C62E26ABCEA4D98F9CEC95966B281E9498ADE371ACBB59A44C338897AA80E3AE32A9F449FBBB7FE389AA60FA04D1E978A3B2E31F60FC7F60263AB05BD1A973C7EB596E74AA2721B83473494812B75D497E8519482D246EEE86DEF49933881C115813D5AB7EE783A145CABC3A0ADC1682D7DD5E3D9241A27C397C8EB0DADD33F9AEE9CDBF6A0CCD695190D30D7AA92AF01E94B66B28EE716926FAEA5E40EBBDE7B02F917DC3A46FBEAF8EF09E4F77B78D787F4A932351D097E185F8E3C6F1A3F1893580D2AD861ADAB98C76ABE2E3FBBAB555F68D2B86F38B983EED9BB4275EFF62B659D69171EF6C0EDCA5F2826D2231316617001F0C57CDD9CD8186E68E0F253745D1585028DDBA062C2FDD4F72904E0B49EF13C1DD245AA2B905C6DF92F7AD494505A1468ED9289E35297C6FA693A0C322CDC8C09FA64F541410F929D16814CD9570072A3CB82D646EB49FBC3840C21015B1864591D7BAE7DE436C0971606FFFD5DD33FC5D5228B10040000,NULL,3,NULL,142523),
	(275070,2,0x1F8B08000000000000009D93DD6AC2401085EFFB14927B632CB658182355290A45A4DA0758CD982EEC4FD8DD14DBA7EF6C62E26ABCEA4D98F9CEC95966B281E9498ADE371ACBB59A44C338897AA80E3AE32A9F449FBBB7FE389AA60FA04D1E978A3B2E31F60FC7F60263AB05BD1A973C7EB596E74AA2721B83473494812B75D497E8519482D246EEE86DEF49933881C115813D5AB7EE783A145CABC3A0ADC1682D7DD5E3D9241A27C397C8EB0DADD33F9AEE9CDBF6A0CCD695190D30D7AA92AF01E94B66B28EE716926FAEA5E40EBBDE7B02F917DC3A46FBEAF8EF09E4F77B78D787F4A932351D097E185F8E3C6F1A3F1893580D2AD861ADAB98C76ABE2E3FBBAB555F68D2B86F38B983EED9BB4275EFF62B659D69171EF6C0EDCA5F2826D2231316617001F0C57CDD9CD8186E68E0F253745D1585028DDBA062C2FDD4F72904E0B49EF13C1DD245AA2B905C6DF92F7AD494505A1468ED9289E35297C6FA693A0C322CDC8C09FA64F541410F929D16814CD9570072A3CB82D646EB49FBC3840C21015B1864591D7BAE7DE436C0971606FFFD5DD33FC5D5228B10040000,NULL,3,NULL,142524),
	(275071,2,0x1F8B08000000000000009D93CD4EC3300C80EF3CC5D43B6D870071F0826013DA24344D0C1E205DBD12293F559222E0E971DAB5CBD69DB854F6E7AF8EECA6F0F8ADE4E40BAD1346CF92699A2713D43B530A5DCD928FF797EB87E4915D81B155DA68E185C2343C3C2F24A6CE487A356D44FAE49CA8B442ED3716F768A907AEF4DE1C5BDF260CB4B1EA9DDE0E0ECBD31CB21302053ABF1E39230A7EA84336C4608D51219A887296