/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.property.ICalProperty;
import biweekly.util.ICalDateFormat;
import biweekly.util.Period;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecurrenceDates
extends ICalProperty {
    private List<Date> dates;
    private boolean hasTime;
    private List<Period> periods;

    public RecurrenceDates(List<Date> dates, boolean hasTime) {
        this.dates = dates;
        this.hasTime = hasTime;
    }

    public RecurrenceDates(List<Period> periods) {
        this.periods = periods;
    }

    public List<Date> getDates() {
        return this.dates;
    }

    public boolean hasTime() {
        return this.hasTime;
    }

    public List<Period> getPeriods() {
        return this.periods;
    }

    @Override
    public String getTimezoneId() {
        return super.getTimezoneId();
    }

    @Override
    public void setTimezoneId(String timezoneId) {
        super.setTimezoneId(timezoneId);
    }

    @Override
    public void setTimezone(VTimezone timezone) {
        super.setTimezone(timezone);
    }

    @Override
    protected void validate(List<ICalComponent> components, List<Warning> warnings) {
        String tzid = this.getTimezoneId();
        if (tzid != null && tzid.contains("/") && ICalDateFormat.parseTimeZoneId(tzid) == null) {
            warnings.add(Warning.validate(27, tzid));
        }
    }
}

