/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.property.ICalProperty;
import biweekly.util.DateTimeComponents;
import biweekly.util.ICalDateFormat;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateOrDateTimeProperty
extends ICalProperty {
    protected Date value;
    protected DateTimeComponents rawComponents;
    protected boolean hasTime;
    protected boolean localTime;

    public DateOrDateTimeProperty(DateTimeComponents rawComponents) {
        this.setRawComponents(rawComponents);
    }

    public DateOrDateTimeProperty(Date value, boolean hasTime) {
        this.setValue(value, hasTime);
    }

    public Date getValue() {
        return this.value;
    }

    public void setValue(Date value, boolean hasTime) {
        this.value = value;
        this.hasTime = hasTime;
    }

    public DateTimeComponents getRawComponents() {
        return this.rawComponents;
    }

    public void setRawComponents(DateTimeComponents rawComponents) {
        this.rawComponents = rawComponents;
    }

    public boolean hasTime() {
        return this.hasTime;
    }

    public boolean isLocalTime() {
        return this.localTime;
    }

    public void setLocalTime(boolean localTime) {
        this.localTime = localTime;
        if (localTime) {
            this.setTimezoneId(null);
        }
    }

    @Override
    public String getTimezoneId() {
        return super.getTimezoneId();
    }

    @Override
    public void setTimezoneId(String timezoneId) {
        super.setTimezoneId(timezoneId);
    }

    @Override
    public void setTimezone(VTimezone timezone) {
        super.setTimezone(timezone);
    }

    @Override
    protected void validate(List<ICalComponent> components, List<Warning> warnings) {
        String tzid;
        if (this.value == null && this.rawComponents == null) {
            warnings.add(Warning.validate(26, new Object[0]));
        }
        if ((tzid = this.getTimezoneId()) != null && tzid.contains("/") && ICalDateFormat.parseTimeZoneId(tzid) == null) {
            warnings.add(Warning.validate(27, tzid));
        }
    }
}

