/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.io.text.FoldedLineWriter;
import biweekly.io.text.FoldingScheme;
import biweekly.parameter.ICalParameters;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ICalRawWriter
implements Closeable,
Flushable {
    private static final Pattern quoteMeRegex = Pattern.compile(".*?[,:;].*");
    private static final Pattern newlineRegex = Pattern.compile("\\r\\n|\\r|\\n");
    private static final Pattern propertyNameRegex = Pattern.compile("(?i)[-a-z0-9]+");
    private static final BitSet invalidParamValueChars = new BitSet(128);
    private final String newline;
    private boolean caretEncodingEnabled = false;
    private final FoldingScheme foldingScheme;
    private final Writer writer;
    private ParameterValueChangedListener parameterValueChangedListener;

    public ICalRawWriter(Writer writer) {
        this(writer, FoldingScheme.DEFAULT);
    }

    public ICalRawWriter(Writer writer, FoldingScheme foldingScheme) {
        this(writer, foldingScheme, "\r\n");
    }

    public ICalRawWriter(Writer writer, FoldingScheme foldingScheme, String newline) {
        this.writer = foldingScheme == null ? writer : new FoldedLineWriter(writer, foldingScheme.getLineLength(), foldingScheme.getIndent(), newline);
        this.foldingScheme = foldingScheme;
        this.newline = newline;
    }

    public boolean isCaretEncodingEnabled() {
        return this.caretEncodingEnabled;
    }

    public void setCaretEncodingEnabled(boolean enable) {
        this.caretEncodingEnabled = enable;
    }

    public String getNewline() {
        return this.newline;
    }

    public ParameterValueChangedListener getParameterValueChangedListener() {
        return this.parameterValueChangedListener;
    }

    public void setParameterValueChangedListener(ParameterValueChangedListener parameterValueChangedListener) {
        this.parameterValueChangedListener = parameterValueChangedListener;
    }

    public FoldingScheme getFoldingScheme() {
        return this.foldingScheme;
    }

    public void writeBeginComponent(String componentName) throws IOException {
        this.writeProperty("BEGIN", componentName);
    }

    public void writeEndComponent(String componentName) throws IOException {
        this.writeProperty("END", componentName);
    }

    public void writeProperty(String propertyName, String value) throws IOException {
        this.writeProperty(propertyName, new ICalParameters(), value);
    }

    public void writeProperty(String propertyName, ICalParameters parameters, String value) throws IOException {
        if (!propertyNameRegex.matcher(propertyName).matches()) {
            throw new IllegalArgumentException("Property name invalid.  Property names can only contain letters, numbers, and hyphens.");
        }
        this.writer.append(propertyName);
        for (Map.Entry subType : parameters) {
            String parameterName = (String)subType.getKey();
            List parameterValues = subType.getValue();
            if (parameterValues.isEmpty()) continue;
            boolean first = true;
            this.writer.append(';').append(parameterName).append('=');
            for (String parameterValue : parameterValues) {
                if (!first) {
                    this.writer.append(',');
                }
                if (quoteMeRegex.matcher(parameterValue = this.sanitizeParameterValue(parameterValue, parameterName, propertyName)).matches()) {
                    this.writer.append('\"');
                    this.writer.append(parameterValue);
                    this.writer.append('\"');
                } else {
                    this.writer.append(parameterValue);
                }
                first = false;
            }
        }
        this.writer.append(':');
        value = value == null ? "" : this.escapeNewlines(value);
        this.writer.append(value);
        this.writer.append(this.newline);
    }

    private String sanitizeParameterValue(String parameterValue, String parameterName, String propertyName) {
        boolean valueChanged = false;
        String modifiedValue = this.removeInvalidParameterValueChars(parameterValue);
        if (this.caretEncodingEnabled) {
            valueChanged = modifiedValue != parameterValue;
            modifiedValue = this.applyCaretEncoding(modifiedValue);
        } else {
            modifiedValue = modifiedValue.replace('\"', '\'');
            boolean bl = valueChanged = (modifiedValue = newlineRegex.matcher(modifiedValue).replaceAll(" ")) != parameterValue;
        }
        if (valueChanged && this.parameterValueChangedListener != null) {
            this.parameterValueChangedListener.onParameterValueChanged(propertyName, parameterName, parameterValue, modifiedValue);
        }
        return modifiedValue;
    }

    private String removeInvalidParameterValueChars(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (invalidParamValueChars.get(ch)) continue;
            sb.append(ch);
        }
        return sb.length() == value.length() ? value : sb.toString();
    }

    private String applyCaretEncoding(String value) {
        value = value.replace("^", "^^");
        value = newlineRegex.matcher(value).replaceAll("^n");
        value = value.replace("\"", "^'");
        return value;
    }

    private String escapeNewlines(String text) {
        return newlineRegex.matcher(text).replaceAll("\\\\n");
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    static {
        invalidParamValueChars.set(0, 31);
        invalidParamValueChars.set(127);
        invalidParamValueChars.set(9, false);
        invalidParamValueChars.set(10, false);
        invalidParamValueChars.set(13, false);
    }

    public static interface ParameterValueChangedListener {
        public void onParameterValueChanged(String var1, String var2, String var3, String var4);
    }
}

