/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import java.io.IOException;
import java.io.Writer;

public class FoldedLineWriter
extends Writer {
    private int curLineLength = 0;
    private int lineLength;
    private String indent;
    private String newline;
    private final Writer writer;

    public FoldedLineWriter(Writer writer, int lineLength, String indent, String newline) {
        this.setLineLength(lineLength);
        this.setIndent(indent);
        this.writer = writer;
        this.newline = newline;
    }

    public void writeln(String str) throws IOException {
        this.write(str);
        this.write(this.newline);
    }

    public void write(char[] buf, int start, int end) throws IOException {
        this.write(buf, start, end, this.lineLength, this.indent);
    }

    public void write(char[] buf, int start, int end, int lineLength, String indent) throws IOException {
        for (int i = start; i < end; ++i) {
            char c = buf[i];
            if (c == '\n') {
                this.writer.write(buf, start, i - start + 1);
                this.curLineLength = 0;
                start = i + 1;
                continue;
            }
            if (c == '\r') {
                if (i == end - 1 || buf[i + 1] != '\n') {
                    this.writer.write(buf, start, i - start + 1);
                    this.curLineLength = 0;
                    start = i + 1;
                    continue;
                }
                ++this.curLineLength;
                continue;
            }
            if (this.curLineLength >= lineLength) {
                if (Character.isWhitespace(c)) {
                    while (Character.isWhitespace(c) && i < end - 1) {
                        c = buf[++i];
                    }
                    if (i == end - 1) break;
                }
                this.writer.write(buf, start, i - start);
                String s = this.newline + indent;
                this.writer.write(s.toCharArray(), 0, s.length());
                start = i;
                this.curLineLength = indent.length() + 1;
                continue;
            }
            ++this.curLineLength;
        }
        this.writer.write(buf, start, end - start);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        if (lineLength <= 0) {
            throw new IllegalArgumentException("Line length must be greater than 0.");
        }
        this.lineLength = lineLength;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        if (indent.length() >= this.lineLength) {
            throw new IllegalArgumentException("The length of the indent string must be less than the max line length.");
        }
        this.indent = indent;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }
}

