/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.Version;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionScribe
extends ICalPropertyScribe<Version> {
    public VersionScribe() {
        super(Version.class, "VERSION", ICalDataType.TEXT);
    }

    @Override
    protected String _writeText(Version property) {
        StringBuilder sb = new StringBuilder();
        if (property.getMinVersion() != null) {
            sb.append(property.getMinVersion()).append(';');
        }
        if (property.getMaxVersion() != null) {
            sb.append(property.getMaxVersion());
        }
        return sb.toString();
    }

    @Override
    protected Version _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        ICalPropertyScribe.SemiStructuredIterator it = VersionScribe.semistructured(value, true);
        String one = it.next();
        String two = it.next();
        String min = null;
        String max = null;
        if (two == null) {
            max = one;
        } else {
            min = one;
            max = two;
        }
        return new Version(min, max);
    }

    @Override
    protected void _writeXml(Version property, XCalElement element) {
        element.append(this.dataType(property), property.getMaxVersion());
    }

    @Override
    protected Version _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String value = element.first(this.defaultDataType);
        if (value != null) {
            return new Version(value);
        }
        throw VersionScribe.missingXmlElements(this.defaultDataType);
    }

    @Override
    protected JCalValue _writeJson(Version property) {
        return JCalValue.single(property.getMaxVersion());
    }

    @Override
    protected Version _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return new Version(value.asSingle());
    }
}

