/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.RecurrenceDates;
import biweekly.util.Duration;
import biweekly.util.Period;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecurrenceDatesScribe
extends ICalPropertyScribe<RecurrenceDates> {
    public RecurrenceDatesScribe() {
        super(RecurrenceDates.class, "RDATE", ICalDataType.DATE_TIME);
    }

    @Override
    protected ICalDataType _dataType(RecurrenceDates property) {
        if (property.getDates() != null) {
            return property.hasTime() ? ICalDataType.DATE_TIME : ICalDataType.DATE;
        }
        if (property.getPeriods() != null) {
            return ICalDataType.PERIOD;
        }
        return this.getDefaultDataType();
    }

    @Override
    protected String _writeText(final RecurrenceDates property) {
        List<Date> dates = property.getDates();
        if (dates != null) {
            return RecurrenceDatesScribe.list(dates, new ICalPropertyScribe.ListCallback<Date>(){

                @Override
                public String asString(Date date) {
                    return ICalPropertyScribe.date(date).time(property.hasTime()).tzid(property.getTimezoneId()).write();
                }
            });
        }
        List<Period> periods = property.getPeriods();
        if (periods != null) {
            return RecurrenceDatesScribe.list(periods, new ICalPropertyScribe.ListCallback<Period>(){

                @Override
                public String asString(Period period) {
                    String date;
                    StringBuilder sb = new StringBuilder();
                    if (period.getStartDate() != null) {
                        date = ICalPropertyScribe.date(period.getStartDate()).tzid(property.getTimezoneId()).write();
                        sb.append(date);
                    }
                    sb.append('/');
                    if (period.getEndDate() != null) {
                        date = ICalPropertyScribe.date(period.getEndDate()).tzid(property.getTimezoneId()).write();
                        sb.append(date);
                    } else if (period.getDuration() != null) {
                        sb.append(period.getDuration());
                    }
                    return sb.toString();
                }
            });
        }
        return "";
    }

    @Override
    protected RecurrenceDates _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return this.parse(RecurrenceDatesScribe.list(value), dataType, parameters, warnings);
    }

    @Override
    protected void _writeXml(RecurrenceDates property, XCalElement element) {
        List<Date> dates = property.getDates();
        if (dates != null) {
            ICalDataType dataType;
            ICalDataType iCalDataType = dataType = property.hasTime() ? ICalDataType.DATE_TIME : ICalDataType.DATE;
            if (dates.isEmpty()) {
                element.append(dataType, "");
            } else {
                for (Date date : dates) {
                    String dateStr = RecurrenceDatesScribe.date(date).time(property.hasTime()).tzid(property.getTimezoneId()).extended(true).write();
                    element.append(dataType, dateStr);
                }
            }
            return;
        }
        List<Period> periods = property.getPeriods();
        if (periods != null) {
            if (periods.isEmpty()) {
                element.append(ICalDataType.PERIOD, "");
            } else {
                for (Period period : periods) {
                    Duration duration;
                    Date end;
                    XCalElement periodElement = element.append(ICalDataType.PERIOD);
                    Date start = period.getStartDate();
                    if (start != null) {
                        periodElement.append("start", RecurrenceDatesScribe.date(start).tzid(property.getTimezoneId()).extended(true).write());
                    }
                    if ((end = period.getEndDate()) != null) {
                        periodElement.append("end", RecurrenceDatesScribe.date(end).tzid(property.getTimezoneId()).extended(true).write());
                    }
                    if ((duration = period.getDuration()) == null) continue;
                    periodElement.append("duration", duration.toString());
                }
            }
            return;
        }
        element.append(this.defaultDataType, "");
    }

    @Override
    protected RecurrenceDates _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        List<XCalElement> periodElements = element.children(ICalDataType.PERIOD);
        if (!periodElements.isEmpty()) {
            ArrayList<Period> periods = new ArrayList<Period>(periodElements.size());
            for (XCalElement periodElement : periodElements) {
                String startStr = periodElement.first("start");
                if (startStr == null) {
                    warnings.add(Warning.parse(9, new Object[0]));
                    continue;
                }
                Date start = null;
                try {
                    start = RecurrenceDatesScribe.date(startStr).tzid(parameters.getTimezoneId(), warnings).parse();
                }
                catch (IllegalArgumentException e) {
                    warnings.add(Warning.parse(10, startStr));
                    continue;
                }
                String endStr = periodElement.first("end");
                if (endStr != null) {
                    try {
                        Date end = RecurrenceDatesScribe.date(endStr).tzid(parameters.getTimezoneId(), warnings).parse();
                        periods.add(new Period(start, end));
                    }
                    catch (IllegalArgumentException e) {
                        warnings.add(Warning.parse(11, endStr));
                    }
                    continue;
                }
                String durationStr = periodElement.first("duration");
                if (durationStr != null) {
                    try {
                        Duration duration = Duration.parse(durationStr);
                        periods.add(new Period(start, duration));
                    }
                    catch (IllegalArgumentException e) {
                        warnings.add(Warning.parse(12, durationStr));
                    }
                    continue;
                }
                warnings.add(Warning.parse(13, new Object[0]));
            }
            return new RecurrenceDates(periods);
        }
        List<String> dateStrs = element.all(ICalDataType.DATE_TIME);
        boolean hasTime = !dateStrs.isEmpty();
        dateStrs.addAll(element.all(ICalDataType.DATE));
        if (!dateStrs.isEmpty()) {
            ArrayList<Date> dates = new ArrayList<Date>(dateStrs.size());
            for (String dateStr : dateStrs) {
                try {
                    Date date = RecurrenceDatesScribe.date(dateStr).tzid(parameters.getTimezoneId(), warnings).parse();
                    dates.add(date);
                }
                catch (IllegalArgumentException e) {
                    warnings.add(Warning.parse(15, dateStr));
                }
            }
            return new RecurrenceDates(dates, hasTime);
        }
        throw RecurrenceDatesScribe.missingXmlElements(ICalDataType.PERIOD, ICalDataType.DATE_TIME, ICalDataType.DATE);
    }

    @Override
    protected JCalValue _writeJson(RecurrenceDates property) {
        ArrayList<String> values = new ArrayList<String>();
        List<Date> dates = property.getDates();
        List<Period> periods = property.getPeriods();
        if (dates != null) {
            for (Date date : dates) {
                String dateStr = RecurrenceDatesScribe.date(date).time(property.hasTime()).tzid(property.getTimezoneId()).extended(true).write();
                values.add(dateStr);
            }
        } else if (periods != null) {
            for (Period period : property.getPeriods()) {
                String value;
                StringBuilder sb = new StringBuilder();
                if (period.getStartDate() != null) {
                    value = RecurrenceDatesScribe.date(period.getStartDate()).tzid(property.getTimezoneId()).extended(true).write();
                    sb.append(value);
                }
                sb.append('/');
                if (period.getEndDate() != null) {
                    value = RecurrenceDatesScribe.date(period.getEndDate()).tzid(property.getTimezoneId()).extended(true).write();
                    sb.append(value);
                } else if (period.getDuration() != null) {
                    sb.append(period.getDuration());
                }
                values.add(sb.toString());
            }
        }
        if (values.isEmpty()) {
            values.add("");
        }
        return JCalValue.multi(values);
    }

    @Override
    protected RecurrenceDates _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return this.parse(value.asMulti(), dataType, parameters, warnings);
    }

    private RecurrenceDates parse(List<String> valueStrs, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        if (dataType == ICalDataType.PERIOD) {
            ArrayList<Period> periods = new ArrayList<Period>(valueStrs.size());
            for (String timePeriodStr : valueStrs) {
                Date start;
                String[] timePeriodStrSplit = timePeriodStr.split("/");
                if (timePeriodStrSplit.length < 2) {
                    warnings.add(Warning.parse(13, new Object[0]));
                    continue;
                }
                String startStr = timePeriodStrSplit[0];
                try {
                    start = RecurrenceDatesScribe.date(startStr).tzid(parameters.getTimezoneId(), warnings).parse();
                }
                catch (IllegalArgumentException e) {
                    warnings.add(Warning.parse(10, startStr));
                    continue;
                }
                String endStr = timePeriodStrSplit[1];
                try {
                    Date end = RecurrenceDatesScribe.date(endStr).tzid(parameters.getTimezoneId(), warnings).parse();
                    periods.add(new Period(start, end));
                }
                catch (IllegalArgumentException e) {
                    try {
                        Duration duration = Duration.parse(endStr);
                        periods.add(new Period(start, duration));
                    }
                    catch (IllegalArgumentException e2) {
                        warnings.add(Warning.parse(14, endStr));
                    }
                }
            }
            return new RecurrenceDates(periods);
        }
        boolean hasTime = dataType == ICalDataType.DATE_TIME;
        ArrayList<Date> dates = new ArrayList<Date>(valueStrs.size());
        for (String s : valueStrs) {
            try {
                Date date = RecurrenceDatesScribe.date(s).tzid(parameters.getTimezoneId(), warnings).parse();
                dates.add(date);
            }
            catch (IllegalArgumentException e) {
                warnings.add(Warning.parse(15, s));
            }
        }
        return new RecurrenceDates(dates, hasTime);
    }
}

