/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.FreeBusy;
import biweekly.util.Duration;
import biweekly.util.Period;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeBusyScribe
extends ICalPropertyScribe<FreeBusy> {
    public FreeBusyScribe() {
        super(FreeBusy.class, "FREEBUSY", ICalDataType.PERIOD);
    }

    @Override
    protected String _writeText(FreeBusy property) {
        List<Period> values = property.getValues();
        return FreeBusyScribe.list(values, new ICalPropertyScribe.ListCallback<Period>(){

            @Override
            public String asString(Period period) {
                String date;
                StringBuilder sb = new StringBuilder();
                if (period.getStartDate() != null) {
                    date = ICalPropertyScribe.date(period.getStartDate()).write();
                    sb.append(date);
                }
                sb.append('/');
                if (period.getEndDate() != null) {
                    date = ICalPropertyScribe.date(period.getEndDate()).write();
                    sb.append(date);
                } else if (period.getDuration() != null) {
                    sb.append(period.getDuration());
                }
                return sb.toString();
            }
        });
    }

    @Override
    protected FreeBusy _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return this.parse(FreeBusyScribe.list(value), parameters, warnings);
    }

    @Override
    protected void _writeXml(FreeBusy property, XCalElement element) {
        for (Period period : property.getValues()) {
            Duration duration;
            Date end;
            XCalElement periodElement = element.append(ICalDataType.PERIOD);
            Date start = period.getStartDate();
            if (start != null) {
                periodElement.append("start", FreeBusyScribe.date(start).extended(true).write());
            }
            if ((end = period.getEndDate()) != null) {
                periodElement.append("end", FreeBusyScribe.date(end).extended(true).write());
            }
            if ((duration = period.getDuration()) == null) continue;
            periodElement.append("duration", duration.toString());
        }
    }

    @Override
    protected FreeBusy _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        List<XCalElement> periodElements = element.children(ICalDataType.PERIOD);
        if (periodElements.isEmpty()) {
            throw FreeBusyScribe.missingXmlElements(ICalDataType.PERIOD);
        }
        FreeBusy prop = new FreeBusy();
        for (XCalElement periodElement : periodElements) {
            String startStr = periodElement.first("start");
            if (startStr == null) {
                warnings.add(Warning.parse(9, new Object[0]));
                continue;
            }
            Date start = null;
            try {
                start = FreeBusyScribe.date(startStr).tzid(parameters.getTimezoneId(), warnings).parse();
            }
            catch (IllegalArgumentException e) {
                warnings.add(Warning.parse(10, startStr));
                continue;
            }
            String endStr = periodElement.first("end");
            if (endStr != null) {
                try {
                    Date end = FreeBusyScribe.date(endStr).tzid(parameters.getTimezoneId(), warnings).parse();
                    prop.addValue(start, end);
                }
                catch (IllegalArgumentException e) {
                    warnings.add(Warning.parse(11, endStr));
                }
                continue;
            }
            String durationStr = periodElement.first("duration");
            if (durationStr != null) {
                try {
                    Duration duration = Duration.parse(durationStr);
                    prop.addValue(start, duration);
                }
                catch (IllegalArgumentException e) {
                    warnings.add(Warning.parse(12, durationStr));
                }
                continue;
            }
            warnings.add(Warning.parse(13, new Object[0]));
        }
        return prop;
    }

    @Override
    protected JCalValue _writeJson(FreeBusy property) {
        List<Period> values = property.getValues();
        if (values.isEmpty()) {
            return JCalValue.single("");
        }
        ArrayList<String> valuesStr = new ArrayList<String>();
        for (Period period : values) {
            String date;
            StringBuilder sb = new StringBuilder();
            if (period.getStartDate() != null) {
                date = FreeBusyScribe.date(period.getStartDate()).extended(true).write();
                sb.append(date);
            }
            sb.append('/');
            if (period.getEndDate() != null) {
                date = FreeBusyScribe.date(period.getEndDate()).extended(true).write();
                sb.append(date);
            } else if (period.getDuration() != null) {
                sb.append(period.getDuration());
            }
            valuesStr.add(sb.toString());
        }
        return JCalValue.multi(valuesStr);
    }

    @Override
    protected FreeBusy _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return this.parse(value.asMulti(), parameters, warnings);
    }

    private FreeBusy parse(List<String> periods, ICalParameters parameters, List<Warning> warnings) {
        FreeBusy freebusy = new FreeBusy();
        for (String period : periods) {
            String[] periodSplit = period.split("/");
            if (periodSplit.length < 2) {
                warnings.add(Warning.parse(13, new Object[0]));
                continue;
            }
            String startStr = periodSplit[0];
            Date start = null;
            try {
                start = FreeBusyScribe.date(startStr).tzid(parameters.getTimezoneId(), warnings).parse();
            }
            catch (IllegalArgumentException e) {
                warnings.add(Warning.parse(10, startStr));
                continue;
            }
            String endStr = periodSplit[1];
            try {
                Date end = FreeBusyScribe.date(endStr).tzid(parameters.getTimezoneId(), warnings).parse();
                freebusy.addValue(start, end);
            }
            catch (IllegalArgumentException e) {
                try {
                    Duration duration = Duration.parse(endStr);
                    freebusy.addValue(start, duration);
                }
                catch (IllegalArgumentException e2) {
                    warnings.add(Warning.parse(14, endStr));
                }
            }
        }
        return freebusy;
    }
}

