/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe;

import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.RawComponent;
import biweekly.io.scribe.component.DaylightSavingsTimeScribe;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.component.ICalendarScribe;
import biweekly.io.scribe.component.RawComponentScribe;
import biweekly.io.scribe.component.StandardTimeScribe;
import biweekly.io.scribe.component.VAlarmScribe;
import biweekly.io.scribe.component.VEventScribe;
import biweekly.io.scribe.component.VFreeBusyScribe;
import biweekly.io.scribe.component.VJournalScribe;
import biweekly.io.scribe.component.VTimezoneScribe;
import biweekly.io.scribe.component.VTodoScribe;
import biweekly.io.scribe.property.ActionScribe;
import biweekly.io.scribe.property.AttachmentScribe;
import biweekly.io.scribe.property.AttendeeScribe;
import biweekly.io.scribe.property.CalendarScaleScribe;
import biweekly.io.scribe.property.CategoriesScribe;
import biweekly.io.scribe.property.ClassificationScribe;
import biweekly.io.scribe.property.CommentScribe;
import biweekly.io.scribe.property.CompletedScribe;
import biweekly.io.scribe.property.ContactScribe;
import biweekly.io.scribe.property.CreatedScribe;
import biweekly.io.scribe.property.DateDueScribe;
import biweekly.io.scribe.property.DateEndScribe;
import biweekly.io.scribe.property.DateStartScribe;
import biweekly.io.scribe.property.DateTimeStampScribe;
import biweekly.io.scribe.property.DescriptionScribe;
import biweekly.io.scribe.property.DurationPropertyScribe;
import biweekly.io.scribe.property.ExceptionDatesScribe;
import biweekly.io.scribe.property.ExceptionRuleScribe;
import biweekly.io.scribe.property.FreeBusyScribe;
import biweekly.io.scribe.property.GeoScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.scribe.property.LastModifiedScribe;
import biweekly.io.scribe.property.LocationScribe;
import biweekly.io.scribe.property.MethodScribe;
import biweekly.io.scribe.property.OrganizerScribe;
import biweekly.io.scribe.property.PercentCompleteScribe;
import biweekly.io.scribe.property.PriorityScribe;
import biweekly.io.scribe.property.ProductIdScribe;
import biweekly.io.scribe.property.RawPropertyScribe;
import biweekly.io.scribe.property.RecurrenceDatesScribe;
import biweekly.io.scribe.property.RecurrenceIdScribe;
import biweekly.io.scribe.property.RecurrenceRuleScribe;
import biweekly.io.scribe.property.RelatedToScribe;
import biweekly.io.scribe.property.RepeatScribe;
import biweekly.io.scribe.property.RequestStatusScribe;
import biweekly.io.scribe.property.ResourcesScribe;
import biweekly.io.scribe.property.SequenceScribe;
import biweekly.io.scribe.property.StatusScribe;
import biweekly.io.scribe.property.SummaryScribe;
import biweekly.io.scribe.property.TimezoneIdScribe;
import biweekly.io.scribe.property.TimezoneNameScribe;
import biweekly.io.scribe.property.TimezoneOffsetFromScribe;
import biweekly.io.scribe.property.TimezoneOffsetToScribe;
import biweekly.io.scribe.property.TimezoneUrlScribe;
import biweekly.io.scribe.property.TransparencyScribe;
import biweekly.io.scribe.property.TriggerScribe;
import biweekly.io.scribe.property.UidScribe;
import biweekly.io.scribe.property.UrlScribe;
import biweekly.io.scribe.property.VersionScribe;
import biweekly.io.scribe.property.XmlScribe;
import biweekly.property.ICalProperty;
import biweekly.property.RawProperty;
import biweekly.property.Xml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScribeIndex {
    private static final Map<String, ICalComponentScribe<? extends ICalComponent>> standardCompByName = new HashMap<String, ICalComponentScribe<? extends ICalComponent>>();
    private static final Map<Class<? extends ICalComponent>, ICalComponentScribe<? extends ICalComponent>> standardCompByClass = new HashMap<Class<? extends ICalComponent>, ICalComponentScribe<? extends ICalComponent>>();
    private static final Map<String, ICalPropertyScribe<? extends ICalProperty>> standardPropByName;
    private static final Map<Class<? extends ICalProperty>, ICalPropertyScribe<? extends ICalProperty>> standardPropByClass;
    private static final Map<QName, ICalPropertyScribe<? extends ICalProperty>> standardPropByQName;
    private final Map<String, ICalComponentScribe<? extends ICalComponent>> experimentalCompByName = new HashMap<String, ICalComponentScribe<? extends ICalComponent>>(0);
    private final Map<Class<? extends ICalComponent>, ICalComponentScribe<? extends ICalComponent>> experimentalCompByClass = new HashMap<Class<? extends ICalComponent>, ICalComponentScribe<? extends ICalComponent>>(0);
    private final Map<String, ICalPropertyScribe<? extends ICalProperty>> experimentalPropByName = new HashMap<String, ICalPropertyScribe<? extends ICalProperty>>(0);
    private final Map<Class<? extends ICalProperty>, ICalPropertyScribe<? extends ICalProperty>> experimentalPropByClass = new HashMap<Class<? extends ICalProperty>, ICalPropertyScribe<? extends ICalProperty>>(0);
    private final Map<QName, ICalPropertyScribe<? extends ICalProperty>> experimentalPropByQName = new HashMap<QName, ICalPropertyScribe<? extends ICalProperty>>(0);

    public ICalComponentScribe<? extends ICalComponent> getComponentScribe(String componentName) {
        ICalComponentScribe<? extends ICalComponent> marshaller = this.experimentalCompByName.get(componentName = componentName.toUpperCase());
        if (marshaller != null) {
            return marshaller;
        }
        marshaller = standardCompByName.get(componentName);
        if (marshaller != null) {
            return marshaller;
        }
        return new RawComponentScribe(componentName);
    }

    public ICalPropertyScribe<? extends ICalProperty> getPropertyScribe(String propertyName) {
        ICalPropertyScribe<? extends ICalProperty> marshaller = this.experimentalPropByName.get(propertyName = propertyName.toUpperCase());
        if (marshaller != null) {
            return marshaller;
        }
        marshaller = standardPropByName.get(propertyName);
        if (marshaller != null) {
            return marshaller;
        }
        return new RawPropertyScribe(propertyName);
    }

    public ICalComponentScribe<? extends ICalComponent> getComponentScribe(Class<? extends ICalComponent> clazz) {
        ICalComponentScribe<? extends ICalComponent> marshaller = this.experimentalCompByClass.get(clazz);
        if (marshaller != null) {
            return marshaller;
        }
        return standardCompByClass.get(clazz);
    }

    public ICalPropertyScribe<? extends ICalProperty> getPropertyScribe(Class<? extends ICalProperty> clazz) {
        ICalPropertyScribe<? extends ICalProperty> marshaller = this.experimentalPropByClass.get(clazz);
        if (marshaller != null) {
            return marshaller;
        }
        return standardPropByClass.get(clazz);
    }

    public ICalComponentScribe<? extends ICalComponent> getComponentScribe(ICalComponent component) {
        if (component instanceof RawComponent) {
            RawComponent raw = (RawComponent)component;
            return new RawComponentScribe(raw.getName());
        }
        return this.getComponentScribe(component.getClass());
    }

    public ICalPropertyScribe<? extends ICalProperty> getPropertyScribe(ICalProperty property) {
        if (property instanceof RawProperty) {
            RawProperty raw = (RawProperty)property;
            return new RawPropertyScribe(raw.getName());
        }
        return this.getPropertyScribe(property.getClass());
    }

    public ICalPropertyScribe<? extends ICalProperty> getPropertyScribe(QName qname) {
        ICalPropertyScribe<? extends ICalProperty> marshaller = this.experimentalPropByQName.get(qname);
        if (marshaller != null) {
            return marshaller;
        }
        marshaller = standardPropByQName.get(qname);
        if (marshaller != null) {
            return marshaller;
        }
        if ("urn:ietf:params:xml:ns:icalendar-2.0".equals(qname.getNamespaceURI())) {
            return new RawPropertyScribe(qname.getLocalPart().toUpperCase());
        }
        return this.getPropertyScribe(Xml.class);
    }

    public void register(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.experimentalCompByName.put(scribe.getComponentName().toUpperCase(), scribe);
        this.experimentalCompByClass.put(scribe.getComponentClass(), scribe);
    }

    public void register(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.experimentalPropByName.put(scribe.getPropertyName().toUpperCase(), scribe);
        this.experimentalPropByClass.put(scribe.getPropertyClass(), scribe);
        this.experimentalPropByQName.put(scribe.getQName(), scribe);
    }

    public void unregister(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.experimentalCompByName.remove(scribe.getComponentName().toUpperCase());
        this.experimentalCompByClass.remove(scribe.getComponentClass());
    }

    public void unregister(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.experimentalPropByName.remove(scribe.getPropertyName().toUpperCase());
        this.experimentalPropByClass.remove(scribe.getPropertyClass());
        this.experimentalPropByQName.remove(scribe.getQName());
    }

    public void hasScribesFor(ICalendar ical) {
        HashSet unregistered = new HashSet();
        ArrayList<ICalComponent> components = new ArrayList<ICalComponent>();
        components.add(ical);
        while (!components.isEmpty()) {
            ICalComponent component = (ICalComponent)components.remove(components.size() - 1);
            Class<?> componentClass = component.getClass();
            if (componentClass != RawComponent.class && this.getComponentScribe(componentClass) == null) {
                unregistered.add(componentClass);
            }
            for (Map.Entry<Class<? extends ICalProperty>, List<ICalProperty>> entry : component.getProperties()) {
                Class<? extends ICalProperty> clazz;
                List<ICalProperty> properties = entry.getValue();
                if (properties.isEmpty() || (clazz = entry.getKey()) == RawProperty.class || this.getPropertyScribe(clazz) != null) continue;
                unregistered.add(clazz);
            }
            components.addAll(component.getComponents().values());
        }
        if (!unregistered.isEmpty()) {
            throw new IllegalArgumentException("No scribes were found the following component/property classes: " + unregistered);
        }
    }

    public static ICalendarScribe getICalendarScribe() {
        return (ICalendarScribe)standardCompByClass.get(ICalendar.class);
    }

    private static void registerStandard(ICalComponentScribe<? extends ICalComponent> marshaller) {
        standardCompByName.put(marshaller.getComponentName().toUpperCase(), marshaller);
        standardCompByClass.put(marshaller.getComponentClass(), marshaller);
    }

    private static void registerStandard(ICalPropertyScribe<? extends ICalProperty> marshaller) {
        standardPropByName.put(marshaller.getPropertyName().toUpperCase(), marshaller);
        standardPropByClass.put(marshaller.getPropertyClass(), marshaller);
        standardPropByQName.put(marshaller.getQName(), marshaller);
    }

    static {
        ScribeIndex.registerStandard(new ICalendarScribe());
        ScribeIndex.registerStandard(new VAlarmScribe());
        ScribeIndex.registerStandard(new VEventScribe());
        ScribeIndex.registerStandard(new VFreeBusyScribe());
        ScribeIndex.registerStandard(new VJournalScribe());
        ScribeIndex.registerStandard(new VTodoScribe());
        ScribeIndex.registerStandard(new VTimezoneScribe());
        ScribeIndex.registerStandard(new StandardTimeScribe());
        ScribeIndex.registerStandard(new DaylightSavingsTimeScribe());
        standardPropByName = new HashMap<String, ICalPropertyScribe<? extends ICalProperty>>();
        standardPropByClass = new HashMap<Class<? extends ICalProperty>, ICalPropertyScribe<? extends ICalProperty>>();
        standardPropByQName = new HashMap<QName, ICalPropertyScribe<? extends ICalProperty>>();
        ScribeIndex.registerStandard(new ActionScribe());
        ScribeIndex.registerStandard(new AttachmentScribe());
        ScribeIndex.registerStandard(new AttendeeScribe());
        ScribeIndex.registerStandard(new CalendarScaleScribe());
        ScribeIndex.registerStandard(new CategoriesScribe());
        ScribeIndex.registerStandard(new ClassificationScribe());
        ScribeIndex.registerStandard(new CommentScribe());
        ScribeIndex.registerStandard(new CompletedScribe());
        ScribeIndex.registerStandard(new ContactScribe());
        ScribeIndex.registerStandard(new CreatedScribe());
        ScribeIndex.registerStandard(new DateDueScribe());
        ScribeIndex.registerStandard(new DateEndScribe());
        ScribeIndex.registerStandard(new DateStartScribe());
        ScribeIndex.registerStandard(new DateTimeStampScribe());
        ScribeIndex.registerStandard(new DescriptionScribe());
        ScribeIndex.registerStandard(new DurationPropertyScribe());
        ScribeIndex.registerStandard(new ExceptionDatesScribe());
        ScribeIndex.registerStandard(new FreeBusyScribe());
        ScribeIndex.registerStandard(new GeoScribe());
        ScribeIndex.registerStandard(new LastModifiedScribe());
        ScribeIndex.registerStandard(new LocationScribe());
        ScribeIndex.registerStandard(new MethodScribe());
        ScribeIndex.registerStandard(new OrganizerScribe());
        ScribeIndex.registerStandard(new PercentCompleteScribe());
        ScribeIndex.registerStandard(new PriorityScribe());
        ScribeIndex.registerStandard(new ProductIdScribe());
        ScribeIndex.registerStandard(new RecurrenceDatesScribe());
        ScribeIndex.registerStandard(new RecurrenceIdScribe());
        ScribeIndex.registerStandard(new RecurrenceRuleScribe());
        ScribeIndex.registerStandard(new RelatedToScribe());
        ScribeIndex.registerStandard(new RepeatScribe());
        ScribeIndex.registerStandard(new RequestStatusScribe());
        ScribeIndex.registerStandard(new ResourcesScribe());
        ScribeIndex.registerStandard(new SequenceScribe());
        ScribeIndex.registerStandard(new StatusScribe());
        ScribeIndex.registerStandard(new SummaryScribe());
        ScribeIndex.registerStandard(new TimezoneIdScribe());
        ScribeIndex.registerStandard(new TimezoneNameScribe());
        ScribeIndex.registerStandard(new TimezoneOffsetFromScribe());
        ScribeIndex.registerStandard(new TimezoneOffsetToScribe());
        ScribeIndex.registerStandard(new TimezoneUrlScribe());
        ScribeIndex.registerStandard(new TransparencyScribe());
        ScribeIndex.registerStandard(new TriggerScribe());
        ScribeIndex.registerStandard(new UidScribe());
        ScribeIndex.registerStandard(new UrlScribe());
        ScribeIndex.registerStandard(new VersionScribe());
        ScribeIndex.registerStandard(new XmlScribe());
        ScribeIndex.registerStandard(new ExceptionRuleScribe());
    }
}

