/*
 * Decompiled with CFR 0.152.
 */
package biweekly;

import biweekly.ICalDataType;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.io.json.JCalReader;
import biweekly.io.json.JCalWriter;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.text.ICalReader;
import biweekly.io.text.ICalWriter;
import biweekly.io.xml.XCalDocument;
import biweekly.property.ICalProperty;
import biweekly.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Biweekly {
    public static final String VERSION;
    public static final String URL;

    public static ParserChainTextString parse(String ical) {
        return new ParserChainTextString(ical);
    }

    public static ParserChainTextReader parse(File file) {
        return new ParserChainTextReader(file);
    }

    public static ParserChainTextReader parse(InputStream in) {
        return new ParserChainTextReader(in);
    }

    public static ParserChainTextReader parse(Reader reader) {
        return new ParserChainTextReader(reader);
    }

    public static WriterChainText write(ICalendar ... icals) {
        return Biweekly.write(Arrays.asList(icals));
    }

    public static WriterChainText write(Collection<ICalendar> icals) {
        return new WriterChainText(icals);
    }

    public static ParserChainXmlString parseXml(String xml) {
        return new ParserChainXmlString(xml);
    }

    public static ParserChainXmlReader parseXml(File file) {
        return new ParserChainXmlReader(file);
    }

    public static ParserChainXmlReader parseXml(InputStream in) {
        return new ParserChainXmlReader(in);
    }

    public static ParserChainXmlReader parseXml(Reader reader) {
        return new ParserChainXmlReader(reader);
    }

    public static ParserChainXmlDocument parseXml(Document document) {
        return new ParserChainXmlDocument(document);
    }

    public static WriterChainXml writeXml(ICalendar ... icals) {
        return Biweekly.writeXml(Arrays.asList(icals));
    }

    public static WriterChainXml writeXml(Collection<ICalendar> icals) {
        return new WriterChainXml(icals);
    }

    public static ParserChainJsonString parseJson(String json) {
        return new ParserChainJsonString(json);
    }

    public static ParserChainJsonReader parseJson(File file) {
        return new ParserChainJsonReader(file);
    }

    public static ParserChainJsonReader parseJson(InputStream in) {
        return new ParserChainJsonReader(in);
    }

    public static ParserChainJsonReader parseJson(Reader reader) {
        return new ParserChainJsonReader(reader);
    }

    public static WriterChainJson writeJson(ICalendar ... icals) {
        return Biweekly.writeJson(Arrays.asList(icals));
    }

    public static WriterChainJson writeJson(Collection<ICalendar> icals) {
        return new WriterChainJson(icals);
    }

    private Biweekly() {
    }

    static {
        InputStream in = null;
        try {
            in = Biweekly.class.getResourceAsStream("/biweekly.properties");
            Properties props = new Properties();
            props.load(in);
            VERSION = props.getProperty("version");
            URL = props.getProperty("url");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriterChainJson
    extends WriterChain<WriterChainJson> {
        private boolean indent = false;

        private WriterChainJson(Collection<ICalendar> icals) {
            super(icals);
        }

        public WriterChainJson indent(boolean indent) {
            this.indent = indent;
            return (WriterChainJson)this.this_;
        }

        public String go() {
            StringWriter sw = new StringWriter();
            try {
                this.go(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        public void go(OutputStream out) throws IOException {
            this.go(new JCalWriter(out, this.icals.size() > 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go(File file) throws IOException {
            JCalWriter jcalWriter = new JCalWriter(file, this.icals.size() > 1);
            try {
                this.go(jcalWriter);
            }
            finally {
                IOUtils.closeQuietly(jcalWriter);
            }
        }

        public void go(Writer writer) throws IOException {
            this.go(new JCalWriter(writer, this.icals.size() > 1));
        }

        private void go(JCalWriter jcalWriter) throws IOException {
            jcalWriter.setScribeIndex(this.index);
            jcalWriter.setIndent(this.indent);
            for (ICalendar ical : this.icals) {
                jcalWriter.write(ical);
                jcalWriter.flush();
            }
            jcalWriter.closeJsonStream();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriterChainXml
    extends WriterChain<WriterChainXml> {
        int indent = -1;
        final Map<String, ICalDataType> parameterDataTypes = new HashMap<String, ICalDataType>(0);

        WriterChainXml(Collection<ICalendar> icals) {
            super(icals);
        }

        @Override
        public WriterChainXml register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            return (WriterChainXml)super.register(scribe);
        }

        @Override
        public WriterChainXml register(ICalComponentScribe<? extends ICalComponent> scribe) {
            return (WriterChainXml)super.register(scribe);
        }

        public WriterChainXml register(String parameterName, ICalDataType dataType) {
            this.parameterDataTypes.put(parameterName, dataType);
            return (WriterChainXml)this.this_;
        }

        public WriterChainXml indent(int indent) {
            this.indent = indent;
            return (WriterChainXml)this.this_;
        }

        public String go() {
            StringWriter sw = new StringWriter();
            try {
                this.go(sw);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            return sw.toString();
        }

        public void go(OutputStream out) throws TransformerException {
            XCalDocument document = this.constructDocument();
            document.write(out, this.indent);
        }

        public void go(File file) throws TransformerException, IOException {
            XCalDocument document = this.constructDocument();
            document.write(file, this.indent);
        }

        public void go(Writer writer) throws TransformerException {
            XCalDocument document = this.constructDocument();
            document.write(writer, this.indent);
        }

        public Document dom() {
            XCalDocument document = this.constructDocument();
            return document.getDocument();
        }

        private XCalDocument constructDocument() {
            XCalDocument document = new XCalDocument();
            document.setScribeIndex(this.index);
            for (Map.Entry<String, ICalDataType> entry : this.parameterDataTypes.entrySet()) {
                document.registerParameterDataType(entry.getKey(), entry.getValue());
            }
            for (ICalendar ical : this.icals) {
                document.add(ical);
            }
            return document;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WriterChainText
    extends WriterChain<WriterChainText> {
        boolean caretEncoding = false;

        private WriterChainText(Collection<ICalendar> icals) {
            super(icals);
        }

        public WriterChainText caretEncoding(boolean enable) {
            this.caretEncoding = enable;
            return (WriterChainText)this.this_;
        }

        public String go() {
            StringWriter sw = new StringWriter();
            try {
                this.go(sw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sw.toString();
        }

        public void go(OutputStream out) throws IOException {
            this.go(new ICalWriter(out));
        }

        public void go(File file) throws IOException {
            this.go(file, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go(File file, boolean append) throws IOException {
            ICalWriter icalWriter = new ICalWriter(file, append);
            try {
                this.go(icalWriter);
            }
            finally {
                IOUtils.closeQuietly(icalWriter);
            }
        }

        public void go(Writer writer) throws IOException {
            this.go(new ICalWriter(writer));
        }

        private void go(ICalWriter icalWriter) throws IOException {
            icalWriter.setScribeIndex(this.index);
            icalWriter.setCaretEncodingEnabled(this.caretEncoding);
            for (ICalendar ical : this.icals) {
                icalWriter.write(ical);
                icalWriter.flush();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class WriterChain<T> {
        final Collection<ICalendar> icals;
        final ScribeIndex index = new ScribeIndex();
        final T this_ = this;

        WriterChain(Collection<ICalendar> icals) {
            this.icals = icals;
        }

        public T register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            this.index.register(scribe);
            return this.this_;
        }

        public T register(ICalComponentScribe<? extends ICalComponent> scribe) {
            this.index.register(scribe);
            return this.this_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainJsonString
    extends ParserChainJson<ParserChainJsonString> {
        private final String text;

        private ParserChainJsonString(String text) {
            super(false);
            this.text = text;
        }

        @Override
        public ParserChainJsonString register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            return (ParserChainJsonString)super.register(scribe);
        }

        @Override
        public ParserChainJsonString register(ICalComponentScribe<? extends ICalComponent> scribe) {
            return (ParserChainJsonString)super.register(scribe);
        }

        @Override
        public ParserChainJsonString warnings(List<List<String>> warnings) {
            return (ParserChainJsonString)super.warnings(warnings);
        }

        @Override
        JCalReader _constructReader() {
            return new JCalReader(this.text);
        }

        @Override
        public ICalendar first() {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<ICalendar> all() {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainJsonReader
    extends ParserChainJson<ParserChainJsonReader> {
        private final InputStream in;
        private final File file;
        private final Reader reader;

        private ParserChainJsonReader(InputStream in) {
            super(false);
            this.in = in;
            this.reader = null;
            this.file = null;
        }

        private ParserChainJsonReader(File file) {
            super(true);
            this.in = null;
            this.reader = null;
            this.file = file;
        }

        private ParserChainJsonReader(Reader reader) {
            super(false);
            this.in = null;
            this.reader = reader;
            this.file = null;
        }

        @Override
        public ParserChainJsonReader register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            return (ParserChainJsonReader)super.register(scribe);
        }

        @Override
        public ParserChainJsonReader register(ICalComponentScribe<? extends ICalComponent> scribe) {
            return (ParserChainJsonReader)super.register(scribe);
        }

        @Override
        public ParserChainJsonReader warnings(List<List<String>> warnings) {
            return (ParserChainJsonReader)super.warnings(warnings);
        }

        @Override
        JCalReader _constructReader() throws IOException {
            if (this.in != null) {
                return new JCalReader(this.in);
            }
            if (this.file != null) {
                return new JCalReader(this.file);
            }
            return new JCalReader(this.reader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ParserChainJson<T>
    extends ParserChain<T> {
        final boolean closeWhenDone;

        private ParserChainJson(boolean closeWhenDone) {
            this.closeWhenDone = closeWhenDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICalendar first() throws IOException {
            JCalReader parser = this.constructReader();
            try {
                ICalendar ical = parser.readNext();
                if (this.warnings != null) {
                    this.warnings.add(parser.getWarnings());
                }
                ICalendar iCalendar = ical;
                return iCalendar;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ICalendar> all() throws IOException {
            JCalReader parser = this.constructReader();
            try {
                ICalendar ical;
                ArrayList<ICalendar> icals = new ArrayList<ICalendar>();
                while ((ical = parser.readNext()) != null) {
                    if (this.warnings != null) {
                        this.warnings.add(parser.getWarnings());
                    }
                    icals.add(ical);
                }
                ArrayList<ICalendar> arrayList = icals;
                return arrayList;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        private JCalReader constructReader() throws IOException {
            JCalReader parser = this._constructReader();
            parser.setScribeIndex(this.index);
            return parser;
        }

        abstract JCalReader _constructReader() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainXmlDocument
    extends ParserChainXml<ParserChainXmlDocument> {
        private final Document document;

        private ParserChainXmlDocument(Document document) {
            this.document = document;
        }

        @Override
        public ParserChainXmlDocument register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            return (ParserChainXmlDocument)super.register(scribe);
        }

        @Override
        public ParserChainXmlDocument register(ICalComponentScribe<? extends ICalComponent> scribe) {
            return (ParserChainXmlDocument)super.register(scribe);
        }

        @Override
        public ParserChainXmlDocument warnings(List<List<String>> warnings) {
            return (ParserChainXmlDocument)super.warnings(warnings);
        }

        @Override
        XCalDocument _constructDocument() {
            return new XCalDocument(this.document);
        }

        @Override
        public ICalendar first() {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<ICalendar> all() {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainXmlReader
    extends ParserChainXml<ParserChainXmlReader> {
        private final InputStream in;
        private final File file;
        private final Reader reader;

        private ParserChainXmlReader(InputStream in) {
            this.in = in;
            this.reader = null;
            this.file = null;
        }

        private ParserChainXmlReader(File file) {
            this.in = null;
            this.reader = null;
            this.file = file;
        }

        private ParserChainXmlReader(Reader reader) {
            this.in = null;
            this.reader = reader;
            this.file = null;
        }

        @Override
        public ParserChainXmlReader register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            return (ParserChainXmlReader)super.register(scribe);
        }

        @Override
        public ParserChainXmlReader register(ICalComponentScribe<? extends ICalComponent> scribe) {
            return (ParserChainXmlReader)super.register(scribe);
        }

        @Override
        public ParserChainXmlReader warnings(List<List<String>> warnings) {
            return (ParserChainXmlReader)super.warnings(warnings);
        }

        @Override
        XCalDocument _constructDocument() throws IOException, SAXException {
            if (this.in != null) {
                return new XCalDocument(this.in);
            }
            if (this.file != null) {
                return new XCalDocument(this.file);
            }
            return new XCalDocument(this.reader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainXmlString
    extends ParserChainXml<ParserChainXmlString> {
        private final String xml;

        private ParserChainXmlString(String xml) {
            this.xml = xml;
        }

        @Override
        public ParserChainXmlString register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            return (ParserChainXmlString)super.register(scribe);
        }

        @Override
        public ParserChainXmlString register(ICalComponentScribe<? extends ICalComponent> scribe) {
            return (ParserChainXmlString)super.register(scribe);
        }

        @Override
        public ParserChainXmlString warnings(List<List<String>> warnings) {
            return (ParserChainXmlString)super.warnings(warnings);
        }

        @Override
        XCalDocument _constructDocument() throws SAXException {
            return new XCalDocument(this.xml);
        }

        @Override
        public ICalendar first() throws SAXException {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<ICalendar> all() throws SAXException {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ParserChainXml<T>
    extends ParserChain<T> {
        ParserChainXml() {
        }

        @Override
        public ICalendar first() throws IOException, SAXException {
            XCalDocument document = this.constructDocument();
            ICalendar ical = document.parseFirst();
            if (this.warnings != null) {
                this.warnings.addAll(document.getParseWarnings());
            }
            return ical;
        }

        @Override
        public List<ICalendar> all() throws IOException, SAXException {
            XCalDocument document = this.constructDocument();
            List<ICalendar> icals = document.parseAll();
            if (this.warnings != null) {
                this.warnings.addAll(document.getParseWarnings());
            }
            return icals;
        }

        private XCalDocument constructDocument() throws SAXException, IOException {
            XCalDocument parser = this._constructDocument();
            parser.setScribeIndex(this.index);
            return parser;
        }

        abstract XCalDocument _constructDocument() throws IOException, SAXException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainTextString
    extends ParserChainText<ParserChainTextString> {
        private final String text;

        private ParserChainTextString(String text) {
            super(false);
            this.text = text;
        }

        @Override
        public ParserChainTextString register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            return (ParserChainTextString)super.register(scribe);
        }

        @Override
        public ParserChainTextString register(ICalComponentScribe<? extends ICalComponent> scribe) {
            return (ParserChainTextString)super.register(scribe);
        }

        @Override
        public ParserChainTextString warnings(List<List<String>> warnings) {
            return (ParserChainTextString)super.warnings(warnings);
        }

        @Override
        public ParserChainTextString caretDecoding(boolean enable) {
            return (ParserChainTextString)super.caretDecoding(enable);
        }

        @Override
        ICalReader _constructReader() {
            return new ICalReader(this.text);
        }

        @Override
        public ICalendar first() {
            try {
                return super.first();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<ICalendar> all() {
            try {
                return super.all();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserChainTextReader
    extends ParserChainText<ParserChainTextReader> {
        private final InputStream in;
        private final File file;
        private final Reader reader;

        private ParserChainTextReader(InputStream in) {
            super(false);
            this.in = in;
            this.reader = null;
            this.file = null;
        }

        private ParserChainTextReader(File file) {
            super(true);
            this.in = null;
            this.reader = null;
            this.file = file;
        }

        private ParserChainTextReader(Reader reader) {
            super(false);
            this.in = null;
            this.reader = reader;
            this.file = null;
        }

        @Override
        public ParserChainTextReader register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            return (ParserChainTextReader)super.register(scribe);
        }

        @Override
        public ParserChainTextReader register(ICalComponentScribe<? extends ICalComponent> scribe) {
            return (ParserChainTextReader)super.register(scribe);
        }

        @Override
        public ParserChainTextReader warnings(List<List<String>> warnings) {
            return (ParserChainTextReader)super.warnings(warnings);
        }

        @Override
        public ParserChainTextReader caretDecoding(boolean enable) {
            return (ParserChainTextReader)super.caretDecoding(enable);
        }

        @Override
        ICalReader _constructReader() throws IOException {
            if (this.in != null) {
                return new ICalReader(this.in);
            }
            if (this.file != null) {
                return new ICalReader(this.file);
            }
            return new ICalReader(this.reader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ParserChainText<T>
    extends ParserChain<T> {
        boolean caretDecoding = true;
        final boolean closeWhenDone;

        private ParserChainText(boolean closeWhenDone) {
            this.closeWhenDone = closeWhenDone;
        }

        public T caretDecoding(boolean enable) {
            this.caretDecoding = enable;
            return (T)this.this_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICalendar first() throws IOException {
            ICalReader parser = this.constructReader();
            try {
                ICalendar ical = parser.readNext();
                if (this.warnings != null) {
                    this.warnings.add(parser.getWarnings());
                }
                ICalendar iCalendar = ical;
                return iCalendar;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ICalendar> all() throws IOException {
            ICalReader parser = this.constructReader();
            try {
                ICalendar ical;
                ArrayList<ICalendar> icals = new ArrayList<ICalendar>();
                while ((ical = parser.readNext()) != null) {
                    if (this.warnings != null) {
                        this.warnings.add(parser.getWarnings());
                    }
                    icals.add(ical);
                }
                ArrayList<ICalendar> arrayList = icals;
                return arrayList;
            }
            finally {
                if (this.closeWhenDone) {
                    IOUtils.closeQuietly(parser);
                }
            }
        }

        private ICalReader constructReader() throws IOException {
            ICalReader parser = this._constructReader();
            parser.setScribeIndex(this.index);
            parser.setCaretDecodingEnabled(this.caretDecoding);
            return parser;
        }

        abstract ICalReader _constructReader() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ParserChain<T> {
        final ScribeIndex index = new ScribeIndex();
        final T this_ = this;
        List<List<String>> warnings;

        ParserChain() {
        }

        public T register(ICalPropertyScribe<? extends ICalProperty> scribe) {
            this.index.register(scribe);
            return this.this_;
        }

        public T register(ICalComponentScribe<? extends ICalComponent> scribe) {
            this.index.register(scribe);
            return this.this_;
        }

        public T warnings(List<List<String>> warnings) {
            this.warnings = warnings;
            return this.this_;
        }

        public abstract ICalendar first() throws IOException, SAXException;

        public abstract List<ICalendar> all() throws IOException, SAXException;
    }
}

