/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.unitime.timetable.util.queue.QueueItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueProcessor
extends Thread {
    protected static Logger sLog = Logger.getLogger(QueueProcessor.class);
    protected static long sTimeToKeep = 36000000L;
    protected static long sTimeToSleep = 3600000L;
    private Queue<QueueItem> iQueue = new LinkedList<QueueItem>();
    private List<QueueItem> iFinished = new ArrayList<QueueItem>();
    private QueueItem iItem = null;
    private static QueueProcessor sInstance = null;
    private boolean iCanContinue = true;
    private long iLastId = 0L;

    private QueueProcessor() {
        super("QueueProcessor");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        sLog.info((Object)"Queue processor is up and running.");
        while (this.iCanContinue) {
            Queue<QueueItem> queue = this.iQueue;
            synchronized (queue) {
                long now = new Date().getTime();
                Iterator<QueueItem> i = this.iFinished.iterator();
                while (i.hasNext()) {
                    QueueItem item = i.next();
                    if (item.finished() != null && now - item.finished().getTime() <= sTimeToKeep) continue;
                    i.remove();
                }
                if (this.iQueue.isEmpty()) {
                    sLog.info((Object)"Waiting for tasks to run...");
                    try {
                        this.iQueue.wait(sTimeToSleep);
                    }
                    catch (InterruptedException e) {
                        sLog.info((Object)"Interrupted.");
                    }
                }
                this.iItem = this.iQueue.poll();
                if (this.iItem == null) {
                    continue;
                }
            }
            sLog.info((Object)("Executing " + this.iItem.name()));
            this.iItem.executeItem();
            sLog.info((Object)("Task " + this.iItem.name() + (this.iItem.error() == null ? " is done." : " failed (" + this.iItem.error().getMessage() + ").")));
            queue = this.iQueue;
            synchronized (queue) {
                this.iFinished.add(this.iItem);
                this.iItem = null;
            }
        }
        sLog.info((Object)"Queue processor is down.");
        sInstance = null;
    }

    public static synchronized QueueProcessor getInstance() {
        if (sInstance == null) {
            sInstance = new QueueProcessor();
            sInstance.start();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(QueueItem item) {
        Queue<QueueItem> queue = this.iQueue;
        synchronized (queue) {
            item.setId(this.iLastId++);
            this.iQueue.add(item);
            this.iQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueueItem> getItems(String ownerId, Long sessionId, String type) {
        Queue<QueueItem> queue = this.iQueue;
        synchronized (queue) {
            ArrayList<QueueItem> ret = new ArrayList<QueueItem>();
            for (QueueItem item : this.iFinished) {
                if (ownerId != null && !ownerId.equals(item.getOwnerId()) || sessionId != null && !sessionId.equals(item.getSessionId()) || type != null && !type.equals(item.type())) continue;
                ret.add(item);
            }
            if (this.iItem != null) {
                boolean add = true;
                if (ownerId != null && !ownerId.equals(this.iItem.getOwnerId())) {
                    add = false;
                }
                if (sessionId != null && !sessionId.equals(this.iItem.getSessionId())) {
                    add = false;
                }
                if (type != null && !type.equals(this.iItem.type())) {
                    add = false;
                }
                if (add) {
                    ret.add(this.iItem);
                }
            }
            for (QueueItem item : this.iQueue) {
                if (ownerId != null && !ownerId.equals(item.getOwnerId()) || sessionId != null && !sessionId.equals(item.getSessionId()) || type != null && !type.equals(item.type())) continue;
                ret.add(item);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Long id) {
        Queue<QueueItem> queue = this.iQueue;
        synchronized (queue) {
            QueueItem item;
            Iterator<Object> i = this.iQueue.iterator();
            while (i.hasNext()) {
                item = (QueueItem)i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
            }
            i = this.iFinished.iterator();
            while (i.hasNext()) {
                item = (QueueItem)i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
            }
        }
    }

    public static void stopProcessor() {
        if (sInstance == null) {
            return;
        }
        sLog.info((Object)"Stopping queue processor...");
        try {
            QueueProcessor.sInstance.iCanContinue = false;
            sInstance.interrupt();
            sInstance.join();
        }
        catch (InterruptedException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

