/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.MessageLog;
import org.unitime.timetable.model.dao.MessageLogDAO;
import org.unitime.timetable.util.LogCleaner;

public class MessageLogAppender
extends AppenderSkeleton {
    private Saver iSaver = null;
    private Level iMinLevel = null;

    public void close() {
        if (this.iSaver != null) {
            this.iSaver.interrupt();
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    private Saver getSaver() {
        if (this.iSaver == null) {
            this.iSaver = new Saver();
            this.iSaver.start();
        }
        return this.iSaver;
    }

    public Level getMinLevel() {
        if (this.iMinLevel == null) {
            this.iMinLevel = Level.toLevel((String)ApplicationProperty.MessageLogLevel.value());
        }
        return this.iMinLevel;
    }

    protected void append(LoggingEvent event) {
        Throwable t;
        if (!event.getLevel().isGreaterOrEqual((Priority)this.getMinLevel())) {
            return;
        }
        if (event.getLogger().equals(MessageLogAppender.class.getName())) {
            return;
        }
        MessageLog m = new MessageLog();
        m.setLevel(event.getLevel().toInt());
        String logger = event.getLoggerName();
        if (logger.indexOf(46) >= 0) {
            logger = logger.substring(logger.lastIndexOf(46) + 1);
        }
        m.setLogger(logger.length() > 255 ? logger.substring(0, 255) : logger);
        m.setMessage(event.getMessage() == null ? null : event.getMessage().toString());
        m.setTimeStamp(new Date(event.getTimeStamp()));
        m.setNdc(event.getNDC());
        String thread = event.getThreadName();
        m.setThread(thread == null ? null : (thread.length() > 100 ? thread.substring(0, 100) : thread));
        Throwable throwable = t = event.getThrowableInformation() != null ? event.getThrowableInformation().getThrowable() : null;
        if (t != null) {
            String ex = "";
            while (t != null) {
                String clazz = t.getClass().getName();
                if (clazz.indexOf(46) >= 0) {
                    clazz = clazz.substring(1 + clazz.lastIndexOf(46));
                }
                if (!ex.isEmpty()) {
                    ex = ex + "\n";
                }
                ex = ex + clazz + ": " + t.getMessage();
                if (t.getStackTrace() != null && t.getStackTrace().length > 0) {
                    ex = ex + " (at " + t.getStackTrace()[0].getFileName() + ":" + t.getStackTrace()[0].getLineNumber() + ")";
                }
                t = t.getCause();
            }
            if (!ex.isEmpty()) {
                m.setException(ex);
            }
        }
        this.getSaver().add(m);
    }

    public static class Saver
    extends Thread {
        private List<MessageLog> iMessages = new Vector<MessageLog>();
        private boolean iActive = true;
        private int iLogLimit = ApplicationProperty.MessageLogLimit.intValue();
        private int iCleanupInterval = ApplicationProperty.MessageLogCleanupInterval.intValue();
        private int iCleanupDays = ApplicationProperty.LogCleanupMessageLog.intValue();
        private long iCounter = 0L;

        public Saver() {
            super("MessageLogSaver");
            this.setDaemon(true);
        }

        public void interrupt() {
            this.iActive = false;
            super.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(MessageLog m) {
            if (!this.iActive) {
                return;
            }
            List<MessageLog> list = this.iMessages;
            synchronized (list) {
                if (this.iLogLimit <= 0 || this.iMessages.size() < this.iLogLimit) {
                    this.iMessages.add(m);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    do {
                        Object var7_9;
                        try {
                            Saver.sleep(60000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        ++this.iCounter;
                        if (this.iCounter % (long)this.iCleanupInterval == 0L) {
                            LogCleaner.cleanupMessageLog(this.iCleanupDays);
                        }
                        ArrayList<MessageLog> messagesToSave = null;
                        List<MessageLog> list = this.iMessages;
                        synchronized (list) {
                            if (!this.iMessages.isEmpty()) {
                                messagesToSave = new ArrayList<MessageLog>(this.iMessages);
                                this.iMessages.clear();
                            }
                            if (messagesToSave == null) continue;
                        }
                        Session hibSession = MessageLogDAO.getInstance().createNewSession();
                        hibSession.setCacheMode(CacheMode.IGNORE);
                        Transaction tx = hibSession.beginTransaction();
                        try {
                            try {
                                for (MessageLog m : messagesToSave) {
                                    hibSession.save((Object)m);
                                }
                                hibSession.flush();
                                tx.commit();
                            }
                            catch (Exception e) {
                                tx.rollback();
                                System.err.println("Failed to persist " + messagesToSave.size() + " log entries:" + e.getMessage());
                                var7_9 = null;
                                hibSession.close();
                                continue;
                            }
                            var7_9 = null;
                        }
                        catch (Throwable throwable) {
                            var7_9 = null;
                            hibSession.close();
                            throw throwable;
                        }
                        hibSession.close();
                    } while (this.iActive);
                    return;
                }
                catch (Exception e) {
                    System.err.println("Failed to persist log entries:" + e.getMessage());
                    continue;
                }
                break;
            }
        }
    }
}

