/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.TimetableXMLLoader;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.solver.interactive.Suggestion;
import org.unitime.timetable.solver.interactive.Suggestions;
import org.unitime.timetable.solver.interactive.SuggestionsModel;

public class InteractiveTimetablingTest {
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("yyMMdd_HHmmss", Locale.US);
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private static Logger sLogger = Logger.getLogger(InteractiveTimetablingTest.class);

    public static void main(String[] args) {
        try {
            DataProperties properties = ToolBox.loadProperties((File)new File(args[0]));
            properties.putAll((Map)System.getProperties());
            properties.setProperty("General.Output", properties.getProperty("General.Output", ".") + File.separator + sDateFormat.format(new Date()));
            if (args.length > 1) {
                properties.setProperty("General.Input", args[1]);
            }
            if (args.length > 2) {
                properties.setProperty("General.Output", args[2] + File.separator + sDateFormat.format(new Date()));
            }
            System.out.println("Output folder: " + properties.getProperty("General.Output"));
            ToolBox.configureLogging((String)properties.getProperty("General.Output"), (Properties)properties, (boolean)false, (boolean)false);
            File outDir = new File(properties.getProperty("General.Output", "."));
            outDir.mkdirs();
            Solver solver = new Solver(properties);
            TimetableModel model = new TimetableModel(properties);
            solver.setInitalSolution((Model)model);
            Progress.getInstance((Object)model).addProgressListener((ProgressListener)new ProgressWriter(System.out));
            TimetableXMLLoader loader = new TimetableXMLLoader(model, solver.currentSolution().getAssignment());
            loader.load();
            solver.initSolver();
            sLogger.info((Object)("Starting from: " + ToolBox.dict2string((Map)model.getExtendedInfo(solver.currentSolution().getAssignment()), (int)2)));
            PrintWriter csv = new PrintWriter(new FileWriter(outDir.toString() + File.separator + "stat.csv"));
            csv.println("class,timeout,#sol,#comb,time,best,timeout,#sol,#comb,time,best");
            csv.flush();
            int depth = Integer.parseInt(System.getProperty("depth", "3"));
            int nrClasses1 = 0;
            int nrClasses2 = 0;
            double bestValue1 = 0.0;
            double bestValue2 = 0.0;
            long combinations1 = 0L;
            long combinations2 = 0L;
            long solutions1 = 0L;
            long solutions2 = 0L;
            double time1 = 0.0;
            double time2 = 0.0;
            int timeout = 0;
            for (Lecture lect : model.variables()) {
                SuggestionsModel m1 = new SuggestionsModel();
                m1.setDepth(depth);
                m1.setTimeout(5000L);
                m1.setClassId(lect.getClassId());
                Suggestions s1 = new Suggestions(solver, m1);
                long t0 = System.currentTimeMillis();
                s1.computeSuggestions();
                long t1 = System.currentTimeMillis();
                csv.print(lect.getName() + "," + (s1.getTimeoutReached() ? "T" : "F") + "," + s1.getNrSolutions() + "," + s1.getNrCombinationsConsidered() + "," + (t1 - t0) + "," + (s1.getSuggestions().isEmpty() ? "-" : Double.valueOf(((Suggestion)s1.getSuggestions().first()).getValue())) + ",");
                csv.flush();
                SuggestionsModel m2 = new SuggestionsModel();
                m2.setDepth(m1.getDepth());
                m2.setTimeout(360000L);
                m2.setClassId(lect.getClassId());
                Suggestions s2 = new Suggestions(solver, m2);
                long t2 = System.currentTimeMillis();
                s2.computeSuggestions();
                long t3 = System.currentTimeMillis();
                combinations1 += s1.getNrCombinationsConsidered();
                combinations2 += s2.getNrCombinationsConsidered();
                time1 += (double)(t1 - t0) / 1000.0;
                time2 += (double)(t3 - t2) / 1000.0;
                solutions1 += s1.getNrSolutions();
                solutions2 += s2.getNrSolutions();
                if (s1.getTimeoutReached()) {
                    ++timeout;
                }
                if (!s1.getSuggestions().isEmpty() && !s2.getSuggestions().isEmpty()) {
                    Suggestion x1 = (Suggestion)s1.getSuggestions().first();
                    Suggestion x2 = (Suggestion)s2.getSuggestions().first();
                    bestValue1 += x1.getValue();
                    bestValue2 += x2.getValue();
                    ++nrClasses1;
                    ++nrClasses2;
                } else if (!s2.getSuggestions().isEmpty()) {
                    ++nrClasses2;
                }
                csv.println((s2.getTimeoutReached() ? "T" : "F") + "," + s2.getNrSolutions() + "," + s2.getNrCombinationsConsidered() + "," + (t3 - t2) + "," + (s2.getSuggestions().isEmpty() ? "-" : Double.valueOf(((Suggestion)s2.getSuggestions().first()).getValue())));
                csv.flush();
            }
            csv.close();
            sLogger.info((Object)("Number of solutions: " + sDoubleFormat.format(100.0 * (double)solutions1 / (double)solutions2) + "% (" + solutions1 + " of " + solutions2 + ")"));
            sLogger.info((Object)("Number of combinations: " + sDoubleFormat.format(100.0 * (double)combinations1 / (double)combinations2) + "% (" + combinations1 + " of " + combinations2 + ")"));
            sLogger.info((Object)("Average time needed: " + sDoubleFormat.format(time1 / (double)model.variables().size()) + " (versus " + sDoubleFormat.format(time2 / (double)model.variables().size()) + ")"));
            sLogger.info((Object)("Timeout reached: " + sDoubleFormat.format(100.0 * (double)timeout / (double)model.variables().size()) + " (" + timeout + "x)"));
            sLogger.info((Object)("Improvement found: " + sDoubleFormat.format(100.0 * (double)nrClasses1 / (double)model.variables().size()) + " (" + nrClasses1 + ")"));
            sLogger.info((Object)("Improvement found (w/o time limit): " + sDoubleFormat.format(100.0 * (double)nrClasses2 / (double)model.variables().size()) + " (" + nrClasses2 + ")"));
            sLogger.info((Object)("Average improvement: " + sDoubleFormat.format(bestValue1 / (double)nrClasses1)));
            sLogger.info((Object)("Average improvement (w/o time limit): " + sDoubleFormat.format(bestValue2 / (double)nrClasses1)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

