/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cpsolver.ifs.util.Progress;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelInitialization {
    private Lock iLock = new ReentrantLock();
    private List<? extends Task> iTasks = null;
    private int iNrThreads;
    private String iPhase;

    public ParallelInitialization(String phase, int nrThreads, List<? extends Task> tasks) {
        this.iPhase = phase;
        this.iNrThreads = nrThreads;
        this.iTasks = tasks;
    }

    public void execute(Session hibSession, Progress progress) {
        progress.setPhase(this.iPhase, (long)this.iTasks.size());
        if (this.iNrThreads <= 1) {
            for (Task task : this.iTasks) {
                task.setup(hibSession);
                task.execute();
                task.teardown(hibSession);
                progress.incProgress();
            }
        } else {
            Iterator<? extends Task> iterator = this.iTasks.iterator();
            ArrayList<Executor> arrayList = new ArrayList<Executor>();
            for (int i = 0; i < this.iNrThreads; ++i) {
                Executor executor = new Executor(i, iterator, progress, hibSession);
                executor.start();
                arrayList.add(executor);
            }
            for (Executor executor : arrayList) {
                try {
                    executor.join();
                }
                catch (InterruptedException e) {}
            }
            for (Executor executor : arrayList) {
                if (executor.getException() == null) continue;
                throw new ParallelInitializationException(executor.getException());
            }
        }
    }

    static /* synthetic */ Lock access$000(ParallelInitialization x0) {
        return x0.iLock;
    }

    public static class ParallelInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParallelInitializationException(Exception e) {
            super(e.getMessage(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Executor
    extends Thread {
        private Iterator<? extends Task> iIterator;
        private Progress iProgress;
        private Session iHibSession;
        private Exception iException;

        public Executor(int index, Iterator<? extends Task> iterator, Progress progress, Session hibSession) {
            this.setName("Initialization-" + (1 + index));
            this.iIterator = iterator;
            this.iProgress = progress;
            this.iHibSession = hibSession;
        }

        public Exception getException() {
            return this.iException;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static interface Task {
        public void setup(Session var1);

        public void execute();

        public void teardown(Session var1);
    }
}

