/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import org.cpsolver.ifs.util.DataProperties;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.solver.curricula.CurriculumEnrollmentPriorityProvider;

public class DefaultCurriculumEnrollmentPriorityProvider
implements CurriculumEnrollmentPriorityProvider {
    private float iThreshold = 0.95f;
    private String iGroupMatch = null;

    public DefaultCurriculumEnrollmentPriorityProvider(DataProperties config) {
        this.iThreshold = config.getPropertyFloat("CurriculumEnrollmentPriority.Threshold", this.iThreshold);
        this.iGroupMatch = config.getProperty("CurriculumEnrollmentPriority.GroupMatch");
    }

    public Double getEnrollmentPriority(CurriculumCourse course) {
        if (course.getPercShare().floatValue() >= this.iThreshold) {
            return 1.0;
        }
        for (CurriculumCourseGroup group : course.getGroups()) {
            if (this.iGroupMatch != null && !this.iGroupMatch.isEmpty() && group.getName().matches(this.iGroupMatch)) {
                return 1.0;
            }
            if (group.getType() == 0) {
                float totalShare = 0.0f;
                for (CurriculumCourse other : course.getClassification().getCourses()) {
                    if (!other.getGroups().contains(group)) continue;
                    totalShare += other.getPercShare().floatValue();
                }
                if (!(totalShare >= this.iThreshold)) continue;
                return 1.0;
            }
            if (group.getType() != 1) continue;
            for (CurriculumCourse other : course.getClassification().getCourses()) {
                if (!other.getGroups().contains(group) || !(other.getPercShare().floatValue() >= this.iThreshold)) continue;
                return 1.0;
            }
        }
        return null;
    }
}

