/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.context;

import java.util.Iterator;
import java.util.List;
import org.springframework.security.access.AccessDeniedException;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.context.UniTimeUserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;

public class ChameleonUserContext
extends UniTimeUserContext
implements UserContext.Chameleon {
    private static final long serialVersionUID = 1L;
    private UserContext iOriginalUser;

    public ChameleonUserContext(String userId, UserContext originalUser) {
        super(userId, originalUser.getUsername(), originalUser.getName(), null);
        UserAuthority authority;
        if (originalUser.getCurrentAuthority() == null || !originalUser.getCurrentAuthority().hasRight(Right.SessionIndependent)) {
            Iterator<? extends UserAuthority> i = this.getAuthorities().iterator();
            while (i.hasNext()) {
                UserAuthority authority2 = i.next();
                if (!authority2.hasRight(Right.SessionIndependent)) continue;
                i.remove();
            }
            if (this.getCurrentAuthority() != null && this.getCurrentAuthority().hasRight(Right.SessionIndependent)) {
                List<? extends UserAuthority> authorities = this.getAuthorities(null, new SimpleQualifier("Session", originalUser.getCurrentAcademicSessionId()));
                if (!authorities.isEmpty()) {
                    this.setCurrentAuthority(authorities.get(0));
                } else {
                    throw new AccessDeniedException("Access denied for " + super.getName().trim() + ": not enough permissions for role " + this.getCurrentAuthority().getRole() + ".");
                }
            }
            if (this.getAuthorities().isEmpty()) {
                throw new AccessDeniedException("Access denied for " + super.getName().trim() + ": no role available.");
            }
        }
        this.iOriginalUser = originalUser;
        if (this.iOriginalUser instanceof UserContext.Chameleon) {
            this.iOriginalUser = ((UserContext.Chameleon)((Object)this.iOriginalUser)).getOriginalUserContext();
        }
        if (originalUser.getCurrentAuthority() != null && (authority = this.getAuthority(originalUser.getCurrentAuthority().getAuthority())) != null) {
            this.setCurrentAuthority(authority);
        }
    }

    public UserContext getOriginalUserContext() {
        return this.iOriginalUser;
    }

    public String getName() {
        return super.getName() + " (A)";
    }
}

