/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.security.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUserContext
implements UserContext {
    private static final long serialVersionUID = 1L;
    private UserAuthority iCurrentAuthority = null;
    private Set<UserAuthority> iAuthorities = new HashSet<UserAuthority>();
    private Map<String, String> iProperties = new HashMap<String, String>();

    public String getPassword() {
        return null;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public UserAuthority getCurrentAuthority() {
        return this.iCurrentAuthority;
    }

    @Override
    public void setCurrentAuthority(UserAuthority authority) {
        if (!this.hasAuthority(authority)) {
            throw new RuntimeException("Invalid authority.");
        }
        this.iCurrentAuthority = authority;
    }

    @Override
    public boolean hasAuthority(UserAuthority authority) {
        return this.getAuthorities().contains(authority);
    }

    @Override
    public boolean hasAuthority(String role, Long uniqueId) {
        return this.getAuthority(role, uniqueId) != null;
    }

    @Override
    public UserAuthority getAuthority(String role, Long uniqueId) {
        UserQualifier session = this.getCurrentAuthority() == null ? null : this.getCurrentAuthority().getAcademicSession();
        for (UserAuthority userAuthority : this.getAuthorities()) {
            if (role != null && !role.equals(userAuthority.getRole())) continue;
            if (uniqueId != null && uniqueId.equals(userAuthority.getUniqueId())) {
                return userAuthority;
            }
            if (uniqueId != null || session == null || !session.equals(userAuthority.getAcademicSession())) continue;
            return userAuthority;
        }
        return null;
    }

    @Override
    public boolean hasAuthority(String authority) {
        return this.getAuthority(authority) != null;
    }

    @Override
    public UserAuthority getAuthority(String authority) {
        for (UserAuthority userAuthority : this.getAuthorities()) {
            if (!authority.equals(userAuthority.getAuthority())) continue;
            return userAuthority;
        }
        return null;
    }

    @Override
    public Long getCurrentAcademicSessionId() {
        return (Long)(this.getCurrentAuthority() == null || this.getCurrentAuthority().getAcademicSession() == null ? null : this.getCurrentAuthority().getAcademicSession().getQualifierId());
    }

    @Override
    public boolean hasDepartment(Long departmentId) {
        return this.getCurrentAuthority() == null ? false : this.getCurrentAuthority().hasQualifier(new SimpleQualifier(Department.class.getSimpleName(), departmentId));
    }

    @Override
    public boolean hasRole(String role) {
        return this.hasAuthority(role, null);
    }

    @Override
    public Collection<? extends UserAuthority> getAuthorities() {
        return this.iAuthorities;
    }

    @Override
    public List<? extends UserAuthority> getAuthorities(String role, Qualifiable ... filter) {
        ArrayList<UserAuthority> ret = new ArrayList<UserAuthority>();
        block0: for (UserAuthority userAuthority : this.getAuthorities()) {
            if (role != null && !role.equals(userAuthority.getRole())) continue;
            for (Qualifiable q : filter) {
                if (!userAuthority.hasQualifier(q)) continue block0;
            }
            ret.add(userAuthority);
        }
        return ret;
    }

    protected void addAuthority(UserAuthority authority) {
        authority.addQualifier(new SimpleQualifier("Role", (Serializable)((Object)authority.getRole())));
        this.iAuthorities.add(authority);
    }

    @Override
    public String getProperty(String key) {
        return this.iProperties.get(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public void setProperty(String key, String value) {
        if (value == null) {
            this.iProperties.remove(key);
        } else {
            this.iProperties.put(key, value);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.iProperties;
    }

    @Override
    public String getProperty(UserProperty property) {
        return this.getProperty(property.key(), property.defaultValue());
    }

    @Override
    public void setProperty(UserProperty property, String value) {
        this.setProperty(property.key(), value);
    }
}

