/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServerContext;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.StudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.AbstractServer;
import org.unitime.timetable.onlinesectioning.server.CourseComparator;
import org.unitime.timetable.onlinesectioning.server.SubSet;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedServer
extends AbstractServer {
    private boolean iLockStartsTransaction = false;
    private EmbeddedCacheManager iCacheManager;
    private Cache<Long, XCourseId> iCourseForId;
    private Cache<String, TreeSet<XCourseId>> iCourseForName;
    private Cache<Long, XStudent> iStudentTable;
    private Cache<Long, XOffering> iOfferingTable;
    private Cache<Long, Set<XCourseRequest>> iOfferingRequests;
    private Cache<Long, XExpectations> iExpectations;
    private Cache<Long, Boolean> iOfferingLocks;

    public ReplicatedServer(OnlineSectioningServerContext context) throws SectioningException {
        super(context);
    }

    private String cacheName(String table) {
        return this.getAcademicSession().toCompactString() + "[" + table + "]";
    }

    private <U, T> Cache<U, T> getCache(String name) {
        Configuration config = this.iCacheManager.getCacheConfiguration(name);
        if (config != null) {
            this.iLog.info((Object)("Using " + config + " for " + name + " cache."));
            this.iCacheManager.defineConfiguration(this.cacheName(name), config);
        }
        return this.iCacheManager.getCache(this.cacheName(name), true);
    }

    @Override
    protected void load(OnlineSectioningServerContext context) throws SectioningException {
        this.iCacheManager = context.getCacheManager();
        this.iCourseForId = this.getCache("CourseForId");
        this.iCourseForName = this.getCache("CourseForName");
        this.iStudentTable = this.getCache("StudentTable");
        this.iOfferingTable = this.getCache("OfferingTable");
        this.iOfferingRequests = this.getCache("OfferingRequests");
        this.iExpectations = this.getCache("Expectations");
        this.iOfferingLocks = this.getCache("OfferingLocks");
        HashMap original = new HashMap(this.iProperties);
        this.iProperties = this.getCache("Config");
        if (this.iProperties.isEmpty()) {
            this.iProperties.putAll(original);
        }
        if (this.isOptimisticLocking()) {
            this.iLog.info((Object)"Using optimistic locking.");
        }
        super.load(context);
    }

    private boolean isOptimisticLocking() {
        return this.iOfferingLocks.getAdvancedCache().getCacheConfiguration().transaction().lockingMode() == LockingMode.OPTIMISTIC;
    }

    protected void removeCache(Cache<?, ?> cache) {
        this.iCacheManager.getGlobalComponentRegistry().removeCache(cache.getName());
        CacheJmxRegistration jmx = (CacheJmxRegistration)cache.getAdvancedCache().getComponentRegistry().getComponent(CacheJmxRegistration.class);
        cache.stop();
        if (jmx != null) {
            jmx.unregisterCacheMBean();
        }
    }

    @Override
    public void unload() {
        super.unload();
        this.removeCache(this.iCourseForId);
        this.removeCache(this.iCourseForName);
        this.removeCache(this.iStudentTable);
        this.removeCache(this.iOfferingTable);
        this.removeCache(this.iOfferingRequests);
        this.removeCache(this.iExpectations);
        this.removeCache(this.iOfferingLocks);
        this.removeCache((Cache)this.iProperties);
    }

    private TransactionManager getTransactionManager() {
        return this.iOfferingTable.getAdvancedCache().getTransactionManager();
    }

    private boolean inTransaction() {
        try {
            Transaction tx = this.getTransactionManager().getTransaction();
            return tx != null && tx.getStatus() == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<XCourseId> findCourses(String query, Integer limit, CourseMatcher matcher) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            try {
                DefaultExecutorService ex = new DefaultExecutorService(this.iCourseForId);
                SubSet<XCourseId> ret = new SubSet<XCourseId>(limit, new CourseComparator(query));
                String queryInLowerCase = query.toLowerCase();
                List futures = ex.submitEverywhere((Callable)((Object)new FindCoursesCallable(this.getAcademicSession().getUniqueId(), queryInLowerCase, limit, matcher)));
                if (limit == null) {
                    for (Future future : futures) {
                        ret.addAll((Collection)future.get());
                    }
                } else {
                    for (Future future : futures) {
                        for (XCourseId c : (Collection)future.get()) {
                            if (!c.matchCourseName(queryInLowerCase)) continue;
                            ret.add(c);
                        }
                    }
                    if (!ret.isLimitReached() && queryInLowerCase.length() > 2) {
                        for (Future future : futures) {
                            for (XCourseId c : (Collection)future.get()) {
                                ret.add(c);
                            }
                        }
                    }
                }
                Iterator iterator = ret;
                Object var14_16 = null;
                lock.release();
                return iterator;
            }
            catch (InterruptedException e) {
                throw new SectioningException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new SectioningException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<XCourseId> findCourses(CourseMatcher matcher) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            try {
                DefaultExecutorService ex = new DefaultExecutorService(this.iCourseForId);
                TreeSet ret = new TreeSet();
                List futures = ex.submitEverywhere((Callable)((Object)new FindCoursesCallable(this.getAcademicSession().getUniqueId(), null, null, matcher)));
                Object object = futures.iterator();
                while (true) {
                    if (!object.hasNext()) {
                        object = ret;
                        Object var9_10 = null;
                        lock.release();
                        return object;
                    }
                    Future future = (Future)object.next();
                    ret.addAll((Collection)future.get());
                }
            }
            catch (InterruptedException e) {
                throw new SectioningException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new SectioningException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<XStudent> findStudents(StudentMatcher matcher) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            try {
                DefaultExecutorService ex = new DefaultExecutorService(this.iStudentTable);
                TreeSet ret = new TreeSet();
                List futures = ex.submitEverywhere((Callable)((Object)new FindStudentsCallable(this.getAcademicSession().getUniqueId(), matcher)));
                Object object = futures.iterator();
                while (true) {
                    if (!object.hasNext()) {
                        object = ret;
                        Object var9_10 = null;
                        lock.release();
                        return object;
                    }
                    Future future = (Future)object.next();
                    ret.addAll((Collection)future.get());
                }
            }
            catch (InterruptedException e) {
                throw new SectioningException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new SectioningException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XCourseId getCourse(String course) {
        XCourseId xCourseId;
        OnlineSectioningServer.Lock lock;
        block7: {
            block6: {
                lock = this.readLock();
                try {
                    int idx = course.indexOf(45);
                    while (idx >= 0) {
                        String courseName = course.substring(0, idx).trim();
                        String title = course.substring(idx + 1).trim();
                        TreeSet infos = (TreeSet)this.iCourseForName.get((Object)courseName.toLowerCase());
                        if (infos != null && !infos.isEmpty()) {
                            for (XCourseId info : infos) {
                                if (!title.equalsIgnoreCase(info.getTitle())) continue;
                                XCourseId xCourseId2 = info;
                                Object var11_11 = null;
                                lock.release();
                                return xCourseId2;
                            }
                        }
                        idx = course.indexOf(45, idx + 1);
                    }
                    TreeSet infos = (TreeSet)this.iCourseForName.get((Object)course.toLowerCase());
                    if (infos != null && !infos.isEmpty()) {
                        xCourseId = (XCourseId)infos.first();
                        break block6;
                    }
                    xCourseId = null;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    lock.release();
                    throw throwable;
                }
            }
            Object var11_12 = null;
            lock.release();
            return xCourseId;
        }
        Object var11_13 = null;
        lock.release();
        return xCourseId;
    }

    private XCourse toCourse(XCourseId course) {
        if (course == null) {
            return null;
        }
        if (course instanceof XCourse) {
            return (XCourse)course;
        }
        XOffering offering = this.getOffering(course.getOfferingId());
        return offering == null ? null : offering.getCourse(course);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XCourse getCourse(Long courseId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XCourse xCourse = this.toCourse((XCourseId)this.iCourseForId.get((Object)courseId));
            Object var5_4 = null;
            lock.release();
            return xCourse;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XStudent getStudent(Long studentId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XStudent xStudent = (XStudent)this.iStudentTable.get((Object)studentId);
            Object var5_4 = null;
            lock.release();
            return xStudent;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XOffering getOffering(Long offeringId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XOffering xOffering = (XOffering)this.iOfferingTable.get((Object)offeringId);
            Object var5_4 = null;
            lock.release();
            return xOffering;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<XCourseRequest> getRequests(Long offeringId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            Collection requests = (Collection)this.iOfferingRequests.get((Object)offeringId);
            ArrayList<XCourseRequest> arrayList = requests == null ? null : new ArrayList<XCourseRequest>(requests);
            Object var6_5 = null;
            lock.release();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XExpectations getExpectations(Long offeringId) {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            XExpectations expectations = (XExpectations)this.iExpectations.get((Object)offeringId);
            XExpectations xExpectations = expectations == null ? new XExpectations(offeringId) : expectations;
            Object var6_5 = null;
            lock.release();
            return xExpectations;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(XExpectations expectations) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iExpectations.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)expectations.getOfferingId(), (Object)expectations);
            Object var4_3 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(XStudent student) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XStudent oldStudent = (XStudent)this.iStudentTable.remove((Object)student.getStudentId());
            if (oldStudent != null) {
                for (XRequest request : oldStudent.getRequests()) {
                    if (!(request instanceof XCourseRequest)) continue;
                    for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                        Set requests = (Set)this.iOfferingRequests.get((Object)course.getOfferingId());
                        if (requests != null) {
                            if (!requests.remove(request)) {
                                this.iLog.warn((Object)("REMOVE[1]: Request " + student + " " + request + " was not present in the offering requests table for " + course));
                            }
                            this.iOfferingRequests.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getOfferingId(), (Object)requests);
                            continue;
                        }
                        this.iLog.warn((Object)("REMOVE[2]: Request " + student + " " + request + " was not present in the offering requests table for " + course));
                    }
                }
            }
            Object var10_9 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(XStudent student, boolean updateRequests) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            if (updateRequests) {
                Set<XCourseRequest> requests;
                XStudent oldStudent = (XStudent)this.iStudentTable.get((Object)student.getStudentId());
                this.iStudentTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)student.getStudentId(), (Object)student);
                if (oldStudent != null) {
                    for (XRequest request : oldStudent.getRequests()) {
                        if (!(request instanceof XCourseRequest)) continue;
                        for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                            requests = (HashSet<XCourseRequest>)this.iOfferingRequests.get((Object)course.getOfferingId());
                            if (requests != null) {
                                if (!requests.remove(request)) {
                                    this.iLog.warn((Object)("UPDATE[1]: Request " + student + " " + request + " was not present in the offering requests table for " + course));
                                }
                                this.iOfferingRequests.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getOfferingId(), requests);
                                continue;
                            }
                            this.iLog.warn((Object)("UPDATE[2]: Request " + student + " " + request + " was not present in the offering requests table for " + course));
                        }
                    }
                }
                for (XRequest request : student.getRequests()) {
                    if (!(request instanceof XCourseRequest)) continue;
                    for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                        requests = (Set)this.iOfferingRequests.get((Object)course.getOfferingId());
                        if (requests == null) {
                            requests = new HashSet<XCourseRequest>();
                        }
                        requests.add((XCourseRequest)request);
                        this.iOfferingRequests.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getOfferingId(), requests);
                    }
                }
            } else {
                this.iStudentTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)student.getStudentId(), (Object)student);
            }
            Object var11_10 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            lock.release();
            throw throwable;
        }
    }

    @Override
    public void remove(XOffering offering) {
        this.remove(offering, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(XOffering offering, boolean removeExpectations) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            for (XCourse course : offering.getCourses()) {
                this.iCourseForId.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)course.getCourseId());
                TreeSet courses = (TreeSet)this.iCourseForName.get((Object)course.getCourseNameInLowerCase());
                if (courses == null) continue;
                courses.remove(course);
                if (courses.size() == 1) {
                    for (XCourseId x : courses) {
                        x.setHasUniqueName(true);
                    }
                }
                if (courses.isEmpty()) {
                    this.iCourseForName.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)course.getCourseNameInLowerCase());
                    continue;
                }
                this.iCourseForName.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getCourseNameInLowerCase(), (Object)courses);
            }
            this.iOfferingTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)offering.getOfferingId());
            if (removeExpectations) {
                this.iExpectations.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)offering.getOfferingId());
            }
            Object var10_9 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(XOffering offering) {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XOffering oldOffering = (XOffering)this.iOfferingTable.get((Object)offering.getOfferingId());
            if (oldOffering != null) {
                this.remove(oldOffering, false);
            }
            this.iOfferingTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)offering.getOfferingId(), (Object)offering);
            for (XCourse course : offering.getCourses()) {
                this.iCourseForId.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getCourseId(), (Object)new XCourseId(course));
                TreeSet<XCourseId> courses = (TreeSet<XCourseId>)this.iCourseForName.get((Object)course.getCourseNameInLowerCase());
                if (courses == null) {
                    courses = new TreeSet<XCourseId>();
                    courses.add(new XCourseId(course));
                    this.iCourseForName.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getCourseNameInLowerCase(), courses);
                    continue;
                }
                courses.add(new XCourseId(course));
                if (courses.size() == 1) {
                    for (XCourseId x : courses) {
                        x.setHasUniqueName(true);
                    }
                } else if (courses.size() > 1) {
                    for (XCourseId x : courses) {
                        x.setHasUniqueName(false);
                    }
                }
                this.iCourseForName.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getCourseNameInLowerCase(), courses);
            }
            Object var10_9 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iStudentTable.clear();
            this.iOfferingTable.clear();
            this.iCourseForId.clear();
            this.iCourseForName.clear();
            this.iOfferingRequests.clear();
            Object var3_2 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllStudents() {
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            this.iStudentTable.clear();
            this.iOfferingRequests.clear();
            Object var3_2 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XCourseRequest assign(XCourseRequest request, XEnrollment enrollment) {
        Iterator<Comparable<XRequest>> iterator;
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XStudent student = (XStudent)this.iStudentTable.get((Object)request.getStudentId());
            for (XRequest r : student.getRequests()) {
                Set<XCourseRequest> requests;
                if (!r.equals(request)) continue;
                XCourseRequest cr = (XCourseRequest)r;
                for (XCourseId course : cr.getCourseIds()) {
                    requests = (HashSet<XCourseRequest>)this.iOfferingRequests.get((Object)course.getOfferingId());
                    if (requests != null) {
                        if (!requests.remove(cr)) {
                            this.iLog.warn((Object)("ASSIGN[1]: Request " + student + " " + request + " was not present in the offering requests table for " + course));
                        }
                        this.iOfferingRequests.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getOfferingId(), requests);
                        continue;
                    }
                    this.iLog.warn((Object)("ASSIGN[2]: Request " + student + " " + request + " was not present in the offering requests table for " + course));
                }
                cr.setEnrollment(enrollment);
                Object object = cr.getCourseIds().iterator();
                while (true) {
                    XCourseId course;
                    if (!object.hasNext()) {
                        this.iStudentTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)student.getStudentId(), (Object)student);
                        object = cr;
                        Object var12_12 = null;
                        lock.release();
                        return object;
                    }
                    course = object.next();
                    requests = (Set)this.iOfferingRequests.get((Object)course.getOfferingId());
                    if (requests == null) {
                        requests = new HashSet<XCourseRequest>();
                    }
                    requests.add(cr);
                    this.iOfferingRequests.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getOfferingId(), requests);
                }
            }
            this.iLog.warn((Object)("ASSIGN[3]: Request " + student + " " + request + " was not found among student requests"));
            for (XCourseId course : request.getCourseIds()) {
                Set requests = (Set)this.iOfferingRequests.get((Object)course.getOfferingId());
                if (requests == null) continue;
                requests.remove(request);
                this.iOfferingRequests.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getOfferingId(), (Object)requests);
            }
            iterator = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            lock.release();
            throw throwable;
        }
        Object var12_13 = null;
        lock.release();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XCourseRequest waitlist(XCourseRequest request, boolean waitlist) {
        Iterator<Comparable<XRequest>> iterator;
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            XStudent student = (XStudent)this.iStudentTable.get((Object)request.getStudentId());
            for (XRequest r : student.getRequests()) {
                Set requests;
                if (!r.equals(request)) continue;
                XCourseRequest cr = (XCourseRequest)r;
                for (XCourseId course : cr.getCourseIds()) {
                    requests = (HashSet)this.iOfferingRequests.get((Object)course.getOfferingId());
                    if (requests != null) {
                        if (!requests.remove(cr)) {
                            this.iLog.warn((Object)("WAITLIST[1]: Request " + student + " " + request + " was not present in the offering requests table for " + course));
                        }
                        this.iOfferingRequests.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getOfferingId(), requests);
                        continue;
                    }
                    this.iLog.warn((Object)("WAITLIST[2]: Request " + student + " " + request + " was not present in the offering requests table for " + course));
                }
                cr.setWaitlist(waitlist);
                Object object = cr.getCourseIds().iterator();
                while (true) {
                    XCourseId course;
                    if (!object.hasNext()) {
                        this.iStudentTable.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)student.getStudentId(), (Object)student);
                        object = cr;
                        Object var12_12 = null;
                        lock.release();
                        return object;
                    }
                    course = object.next();
                    requests = (Set)this.iOfferingRequests.get((Object)course.getOfferingId());
                    if (requests == null) {
                        requests = new HashSet();
                    }
                    this.iOfferingRequests.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getOfferingId(), requests);
                }
            }
            this.iLog.warn((Object)("WAITLIST[3]: Request " + student + " " + request + " was not found among student requests"));
            for (XCourseId course : request.getCourseIds()) {
                Set requests = (Set)this.iOfferingRequests.get((Object)course.getOfferingId());
                if (requests == null) continue;
                requests.remove(request);
                this.iOfferingRequests.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)course.getOfferingId(), (Object)requests);
            }
            iterator = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            lock.release();
            throw throwable;
        }
        Object var12_13 = null;
        lock.release();
        return iterator;
    }

    private static OnlineSectioningServer getLocalServer(Long sessionId) {
        SolverServer server = null;
        server = SpringApplicationContextHolder.isInitialized() ? ((SolverServerService)SpringApplicationContextHolder.getBean("solverServerService")).getLocalServer() : SolverServerImplementation.getInstance();
        return server == null ? null : server.getOnlineStudentSchedulingContainer().getSolver(sessionId.toString());
    }

    @Override
    public OnlineSectioningServer.Lock readLock() {
        if (!this.iLockStartsTransaction) {
            return new OnlineSectioningServer.Lock(){

                public void release() {
                }
            };
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm.getTransaction() == null) {
                tm.setTransactionTimeout(3600);
                tm.begin();
                return new OnlineSectioningServer.Lock(){

                    public void release() {
                        try {
                            TransactionManager tm = ReplicatedServer.this.getTransactionManager();
                            if (tm.getStatus() == 1) {
                                tm.rollback();
                            } else {
                                tm.commit();
                            }
                        }
                        catch (Exception e) {
                            throw new SectioningException("Failed to commit a transaction: " + e.getMessage(), e);
                        }
                    }
                };
            }
            return new OnlineSectioningServer.Lock(){

                public void release() {
                }
            };
        }
        catch (Exception e) {
            throw new SectioningException("Failed to begin a transaction: " + e.getMessage(), e);
        }
    }

    @Override
    public OnlineSectioningServer.Lock writeLock() {
        return this.readLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockAll() {
        return this.readLock();
    }

    @Override
    public OnlineSectioningServer.Lock lockStudent(Long studentId, Collection<Long> offeringIds, String actionName) {
        boolean lockStudents = this.getConfig().getPropertyBoolean(actionName + ".LockStudents", true);
        boolean lockOfferings = this.getConfig().getPropertyBoolean(actionName + ".LockOfferings", true);
        boolean excludeLockedOfferings = lockOfferings && this.getConfig().getPropertyBoolean(actionName + ".ExcludeLockedOfferings", true);
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            if (!this.inTransaction()) {
                this.iLog.warn((Object)("Failed to lock a student " + studentId + ": No transaction has been started."));
                return lock;
            }
            if (this.isOptimisticLocking()) {
                this.iLog.warn((Object)("Failed to lock a student " + studentId + ": No eager locks in optimistic locking."));
                return lock;
            }
            HashSet<Long> ids = new HashSet<Long>();
            if (lockStudents) {
                ids.add(-studentId.longValue());
            }
            if (lockOfferings) {
                XStudent student;
                if (offeringIds != null) {
                    for (Long offeringId : offeringIds) {
                        if (excludeLockedOfferings && this.iOfferingLocks.containsKey((Object)offeringId)) continue;
                        ids.add(offeringId);
                    }
                }
                if ((student = this.getStudent(studentId)) != null) {
                    for (XRequest r : student.getRequests()) {
                        if (!(r instanceof XCourseRequest) || ((XCourseRequest)r).getEnrollment() == null) continue;
                        Long offeringId = ((XCourseRequest)r).getEnrollment().getOfferingId();
                        if (excludeLockedOfferings && this.iOfferingLocks.containsKey((Object)offeringId)) continue;
                        ids.add(offeringId);
                    }
                }
            }
            while (!this.iOfferingLocks.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}).lock(ids)) {
                this.iLog.info((Object)("Failed to lock a student " + studentId + ", retrying..."));
            }
            return lock;
        }
        catch (Exception e) {
            lock.release();
            throw new SectioningException("Failed to lock a student: " + e.getMessage(), e);
        }
    }

    @Override
    public OnlineSectioningServer.Lock lockOffering(Long offeringId, Collection<Long> studentIds, String actionName) {
        boolean lockStudents = this.getConfig().getPropertyBoolean(actionName + ".LockStudents", true);
        boolean lockOfferings = this.getConfig().getPropertyBoolean(actionName + ".LockOfferings", true);
        boolean excludeLockedOffering = lockOfferings && this.getConfig().getPropertyBoolean(actionName + ".ExcludeLockedOfferings", true);
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            if (!this.inTransaction()) {
                this.iLog.warn((Object)("Failed to lock an offering " + offeringId + ": No transaction has been started."));
                return lock;
            }
            if (this.isOptimisticLocking()) {
                this.iLog.warn((Object)("Failed to lock an offering " + offeringId + ": No eager locks in optimistic locking."));
                return lock;
            }
            HashSet<Long> ids = new HashSet<Long>();
            if (!(!lockOfferings || excludeLockedOffering && this.iOfferingLocks.containsKey((Object)offeringId))) {
                ids.add(offeringId);
            }
            if (lockStudents) {
                Collection<XCourseRequest> requests;
                if (studentIds != null) {
                    for (Long studentId : studentIds) {
                        ids.add(-studentId.longValue());
                    }
                }
                if ((requests = this.getRequests(offeringId)) != null) {
                    for (XCourseRequest request : requests) {
                        ids.add(-request.getStudentId().longValue());
                    }
                }
            }
            while (!this.iOfferingLocks.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}).lock(ids)) {
                this.iLog.info((Object)("Failed to lock an offering " + offeringId + ", retrying..."));
            }
            return lock;
        }
        catch (Exception e) {
            lock.release();
            throw new SectioningException("Failed to lock an offering: " + e.getMessage(), e);
        }
    }

    private Long getOfferingIdFromCourseName(String courseName) {
        if (courseName == null) {
            return null;
        }
        XCourseId c = this.getCourse(courseName);
        return c == null ? null : c.getOfferingId();
    }

    @Override
    public OnlineSectioningServer.Lock lockRequest(CourseRequestInterface request, String actionName) {
        boolean lockStudents = this.getConfig().getPropertyBoolean(actionName + ".LockStudents", true);
        boolean lockOfferings = this.getConfig().getPropertyBoolean(actionName + ".LockOfferings", true);
        boolean excludeLockedOffering = lockOfferings && this.getConfig().getPropertyBoolean(actionName + ".ExcludeLockedOfferings", true);
        OnlineSectioningServer.Lock lock = this.writeLock();
        try {
            if (!this.inTransaction()) {
                this.iLog.warn((Object)("Failed to lock a request for student " + request.getStudentId() + ": No transaction has been started."));
                return lock;
            }
            if (this.isOptimisticLocking()) {
                this.iLog.warn((Object)("Failed to lock a request for student " + request.getStudentId() + ": No eager locks in optimistic locking."));
                return lock;
            }
            HashSet<Long> ids = new HashSet<Long>();
            if (lockStudents) {
                ids.add(-request.getStudentId().longValue());
            }
            if (lockOfferings) {
                Long id;
                for (CourseRequestInterface.Request r : request.getCourses()) {
                    if (!(!r.hasRequestedCourse() || (id = this.getOfferingIdFromCourseName(r.getRequestedCourse())) == null || excludeLockedOffering && this.isOfferingLocked(id))) {
                        ids.add(id);
                    }
                    if (!(!r.hasFirstAlternative() || (id = this.getOfferingIdFromCourseName(r.getFirstAlternative())) == null || excludeLockedOffering && this.isOfferingLocked(id))) {
                        ids.add(id);
                    }
                    if (!r.hasSecondAlternative() || (id = this.getOfferingIdFromCourseName(r.getSecondAlternative())) == null || excludeLockedOffering && this.isOfferingLocked(id)) continue;
                    ids.add(id);
                }
                for (CourseRequestInterface.Request r : request.getAlternatives()) {
                    if (!(!r.hasRequestedCourse() || (id = this.getOfferingIdFromCourseName(r.getRequestedCourse())) == null || excludeLockedOffering && this.isOfferingLocked(id))) {
                        ids.add(id);
                    }
                    if (!(!r.hasFirstAlternative() || (id = this.getOfferingIdFromCourseName(r.getFirstAlternative())) == null || excludeLockedOffering && this.isOfferingLocked(id))) {
                        ids.add(id);
                    }
                    if (!r.hasSecondAlternative() || (id = this.getOfferingIdFromCourseName(r.getSecondAlternative())) == null || excludeLockedOffering && this.isOfferingLocked(id)) continue;
                    ids.add(id);
                }
            }
            while (!this.iOfferingLocks.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY}).lock(ids)) {
                this.iLog.info((Object)("Failed to lock a request for student " + request.getStudentId() + ", retrying..."));
            }
            return lock;
        }
        catch (Exception e) {
            lock.release();
            throw new SectioningException("Failed to lock a request: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isOfferingLocked(Long offeringId) {
        return this.iOfferingLocks.containsKey((Object)offeringId);
    }

    @Override
    public void lockOffering(Long offeringId) {
        this.iOfferingLocks.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)offeringId, (Object)Boolean.TRUE);
    }

    @Override
    public void unlockOffering(Long offeringId) {
        this.iOfferingLocks.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)offeringId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<Long> getLockedOfferings() {
        OnlineSectioningServer.Lock lock = this.readLock();
        try {
            try {
                DefaultExecutorService ex = new DefaultExecutorService(this.iOfferingLocks);
                HashSet ret = new HashSet();
                List futures = ex.submitEverywhere(new GetKeysCallable());
                Object object = futures.iterator();
                while (true) {
                    if (!object.hasNext()) {
                        object = ret;
                        Object var8_9 = null;
                        lock.release();
                        return object;
                    }
                    Future future = (Future)object.next();
                    ret.addAll((Collection)future.get());
                }
            }
            catch (InterruptedException e) {
                throw new SectioningException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new SectioningException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            lock.release();
            throw throwable;
        }
    }

    @Override
    public void releaseAllOfferingLocks() {
        this.iOfferingLocks.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FindStudentsCallable
    implements DistributedCallable<Long, XStudent, Collection<XStudent>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSessionId;
        private StudentMatcher iMatcher;
        private transient Cache<Long, XStudent> iCache;

        public FindStudentsCallable(Long sessionId, StudentMatcher matcher) {
            this.iSessionId = sessionId;
            this.iMatcher = matcher;
        }

        public void setEnvironment(Cache<Long, XStudent> cache, Set<Long> inputKeys) {
            this.iCache = cache;
        }

        public Collection<XStudent> call() throws Exception {
            if (this.iMatcher != null) {
                this.iMatcher.setServer(ReplicatedServer.getLocalServer(this.iSessionId));
            }
            ArrayList<XStudent> ret = new ArrayList<XStudent>();
            for (XStudent s : this.iCache.values()) {
                if (!this.iMatcher.match(s)) continue;
                ret.add(s);
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetKeysCallable<T>
    implements DistributedCallable<Long, T, Collection<Long>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Cache<Long, T> iCache;

        public void setEnvironment(Cache<Long, T> cache, Set<Long> inputKeys) {
            this.iCache = cache;
        }

        public Collection<Long> call() throws Exception {
            return new ArrayList<Long>(this.iCache.keySet());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FindCoursesCallable
    implements DistributedCallable<Long, XCourseId, Collection<XCourseId>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSessionId;
        private String iQuery;
        private Integer iLimit;
        private CourseMatcher iMatcher;
        private transient Cache<Long, XCourseId> iCache;

        public FindCoursesCallable(Long sessionId, String queryInLowerCase, Integer limit, CourseMatcher matcher) {
            this.iSessionId = sessionId;
            this.iQuery = queryInLowerCase;
            this.iLimit = limit;
            this.iMatcher = matcher;
        }

        public void setEnvironment(Cache<Long, XCourseId> cache, Set<Long> inputKeys) {
            this.iCache = cache;
        }

        public Collection<XCourseId> call() throws Exception {
            if (this.iMatcher != null) {
                this.iMatcher.setServer(ReplicatedServer.getLocalServer(this.iSessionId));
            }
            SubSet<XCourseId> ret = new SubSet<XCourseId>(this.iLimit, new CourseComparator(this.iQuery));
            for (XCourseId c : this.iCache.values()) {
                if (this.iQuery != null && !c.matchCourseName(this.iQuery) || this.iMatcher != null && !this.iMatcher.match(c)) continue;
                ret.add(c);
            }
            if (!ret.isLimitReached() && this.iQuery != null && this.iQuery.length() > 2) {
                for (XCourseId c : this.iCache.values()) {
                    if (!c.matchTitle(this.iQuery) || this.iMatcher != null && !this.iMatcher.match(c)) continue;
                    ret.add(c);
                }
            }
            return ret;
        }
    }
}

