/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.cpsolver.studentsct.model.Student;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SerializeWith(value=XStudentIdSerializer.class)
public class XStudentId
implements Serializable,
Comparable<XStudentId>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iStudentId;
    private String iExternalId = null;
    private String iName = null;

    public XStudentId() {
    }

    public XStudentId(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XStudentId(org.unitime.timetable.model.Student student, OnlineSectioningHelper helper) {
        this.iStudentId = student.getUniqueId();
        this.iExternalId = student.getExternalUniqueId();
        this.iName = helper.getStudentNameFormat().format(student);
    }

    public XStudentId(Student student) {
        this.iStudentId = student.getId();
        this.iExternalId = student.getExternalId();
        this.iName = student.getName();
    }

    public XStudentId(XStudentId student) {
        this.iStudentId = student.getStudentId();
        this.iExternalId = student.getExternalId();
        this.iName = student.getName();
    }

    public XStudentId(Long studentId, String externalId, String name) {
        this.iStudentId = studentId;
        this.iExternalId = externalId;
        this.iName = name;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public String getName() {
        return this.iName;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof XStudentId)) {
            return false;
        }
        return this.getStudentId().equals(((XStudentId)object).getStudentId());
    }

    public int hashCode() {
        return (int)(this.getStudentId() ^ this.getStudentId() >>> 32);
    }

    @Override
    public int compareTo(XStudentId id) {
        int cmp = this.getName().compareToIgnoreCase(id.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getStudentId().compareTo(id.getStudentId());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iStudentId = in.readLong();
        this.iExternalId = (String)in.readObject();
        this.iName = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iStudentId);
        out.writeObject(this.iExternalId);
        out.writeObject(this.iName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XStudentIdSerializer
    implements Externalizer<XStudentId> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XStudentId object) throws IOException {
            object.writeExternal(output);
        }

        public XStudentId readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XStudentId(input);
        }
    }
}

