/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservationId;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XReservation
extends XReservationId
implements Comparable<XReservation> {
    private static final long serialVersionUID = 1L;
    private Date iExpirationDate;
    private Set<Long> iConfigs = new HashSet<Long>();
    private Map<Long, Set<Long>> iSections = new HashMap<Long, Set<Long>>();
    private int iLimitCap = -1;
    private double iRestrictivity = 1.0;
    private int iPriority = 1000;
    private int iFlags = 0;

    public XReservation() {
    }

    public XReservation(XReservationType type, XOffering offering, Reservation reservation) {
        super(type, offering.getOfferingId(), reservation == null ? -1L : reservation.getUniqueId());
        if (reservation != null) {
            this.iExpirationDate = reservation.getExpirationDate();
            for (InstrOfferingConfig config : reservation.getConfigurations()) {
                this.iConfigs.add(config.getUniqueId());
            }
            Iterator<Serializable> iterator = reservation.getClasses().iterator();
            while (iterator.hasNext()) {
                Class_ clazz;
                this.iConfigs.add(clazz.getSchedulingSubpart().getInstrOfferingConfig().getUniqueId());
                for (clazz = (Class_)iterator.next(); clazz != null; clazz = clazz.getParentClass()) {
                    Set<Long> sections = this.iSections.get(clazz.getSchedulingSubpart().getUniqueId());
                    if (sections == null) {
                        sections = new HashSet<Long>();
                        this.iSections.put(clazz.getSchedulingSubpart().getUniqueId(), sections);
                    }
                    sections.add(clazz.getUniqueId());
                }
            }
        }
        if (!this.iConfigs.isEmpty()) {
            int cap = 0;
            for (XConfig config : offering.getConfigs()) {
                if (!this.iConfigs.contains(config.getConfigId())) continue;
                cap = XReservation.add(cap, config.getLimit());
            }
            for (XConfig config : offering.getConfigs()) {
                for (XSubpart subpart : config.getSubparts()) {
                    Set<Long> sections = this.iSections.get(subpart.getSubpartId());
                    if (sections == null) continue;
                    int subpartCap = 0;
                    for (XSection section : subpart.getSections()) {
                        if (!sections.contains(section.getSectionId())) continue;
                        subpartCap = XReservation.add(subpartCap, section.getLimit());
                    }
                    cap = XReservation.min(cap, subpartCap);
                }
            }
            this.iLimitCap = cap;
        }
        this.iRestrictivity = this.computeRestrictivity(offering);
        switch (type) {
            case Individual: {
                this.setPriority(ApplicationProperty.ReservationPriorityIndividual.intValue());
                this.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitIndividual.isTrue());
                this.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedIndividual.isTrue());
                this.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapIndividual.isTrue());
                break;
            }
            case Group: {
                this.setPriority(ApplicationProperty.ReservationPriorityGroup.intValue());
                this.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitGroup.isTrue());
                this.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedGroup.isTrue());
                this.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapGroup.isTrue());
                break;
            }
            case Curriculum: {
                this.setPriority(ApplicationProperty.ReservationPriorityCurriculum.intValue());
                this.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitCurriculum.isTrue());
                this.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedCurriculum.isTrue());
                this.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapCurriculum.isTrue());
                break;
            }
            case Course: {
                this.setPriority(ApplicationProperty.ReservationPriorityCourse.intValue());
                this.setCanAssignOverLimit(ApplicationProperty.ReservationCanOverLimitCourse.isTrue());
                this.setMustBeUsed(ApplicationProperty.ReservationMustBeUsedCourse.isTrue());
                this.setAllowOverlap(ApplicationProperty.ReservationAllowOverlapCourse.isTrue());
                break;
            }
            case Override: {
                this.setPriority(ApplicationProperty.ReservationPriorityOverride.intValue());
                break;
            }
            case Dummy: {
                this.setPriority(ApplicationProperty.ReservationPriorityDummy.intValue());
            }
        }
    }

    public XReservation(XReservationType type, org.cpsolver.studentsct.reservation.Reservation reservation) {
        super(type, reservation.getOffering().getId(), reservation.getId());
        this.iLimitCap = (int)Math.round(reservation.getLimitCap());
        this.iRestrictivity = reservation.getRestrictivity();
        this.iExpirationDate = reservation.isExpired() ? new Date(0L) : null;
        for (Config config : reservation.getConfigs()) {
            this.iConfigs.add(config.getId());
        }
        for (Map.Entry entry : reservation.getSections().entrySet()) {
            HashSet<Long> sections = new HashSet<Long>();
            for (Section section : (Set)entry.getValue()) {
                sections.add(section.getId());
            }
            this.iSections.put(((Subpart)entry.getKey()).getId(), sections);
        }
        this.setPriority(reservation.getPriority());
        this.setMustBeUsed(reservation.mustBeUsed());
        this.setCanAssignOverLimit(reservation.canAssignOverLimit());
        this.setAllowOverlap(reservation.isAllowOverlap());
    }

    public abstract int getReservationLimit();

    public int getPriority() {
        return this.iPriority;
    }

    public void setPriority(int priority) {
        this.iPriority = priority;
    }

    public abstract boolean isApplicable(XStudent var1);

    public Set<Long> getConfigsIds() {
        return this.iConfigs;
    }

    public Map<Long, Set<Long>> getSections() {
        return this.iSections;
    }

    public Set<Long> getSectionIds(Long subpartId) {
        return this.iSections.get(subpartId);
    }

    public boolean canAssignOverLimit() {
        return Flags.CanAssignOverLimit.in(this.iFlags);
    }

    public void setCanAssignOverLimit(boolean canAssignOverLimit) {
        this.iFlags = Flags.CanAssignOverLimit.set(this.iFlags, canAssignOverLimit);
    }

    public boolean mustBeUsed() {
        return Flags.MustBeUsed.in(this.iFlags);
    }

    public void setMustBeUsed(boolean mustBeUsed) {
        this.iFlags = Flags.MustBeUsed.set(this.iFlags, mustBeUsed);
    }

    private static int min(int l1, int l2) {
        return l1 < 0 ? l2 : (l2 < 0 ? l1 : Math.min(l1, l2));
    }

    private static int add(int l1, int l2) {
        return l1 < 0 ? -1 : (l2 < 0 ? -1 : l1 + l2);
    }

    public int getLimit() {
        return XReservation.min(this.iLimitCap, this.getReservationLimit());
    }

    public boolean isAllowOverlap() {
        return Flags.AllowOverlap.in(this.iFlags);
    }

    public void setAllowOverlap(boolean allowOverlap) {
        this.iFlags = Flags.AllowOverlap.set(this.iFlags, allowOverlap);
    }

    public boolean isExpired() {
        if (this.iExpirationDate == null) {
            return false;
        }
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return this.iExpirationDate.before(c.getTime());
    }

    public boolean isIncluded(Long configId, List<XSection> sections) {
        if (!this.iConfigs.isEmpty() && !this.iConfigs.contains(configId)) {
            return false;
        }
        for (XSection section : sections) {
            Set<Long> reserved = this.iSections.get(section.getSubpartId());
            if (reserved == null || reserved.contains(section.getSectionId())) continue;
            return false;
        }
        return true;
    }

    public double getRestrictivity() {
        return this.iRestrictivity;
    }

    private double computeRestrictivity(XOffering offering) {
        if (this.iConfigs.isEmpty()) {
            return 1.0;
        }
        int nrChoices = 0;
        int nrMatchingChoices = 0;
        for (XConfig config : offering.getConfigs()) {
            int[] x = this.nrChoices(config, 0, new HashSet<XSection>(), this.iConfigs.contains(config.getConfigId()));
            nrChoices += x[0];
            nrMatchingChoices += x[1];
        }
        return (double)nrMatchingChoices / (double)nrChoices;
    }

    private int[] nrChoices(XConfig config, int idx, HashSet<XSection> sections, boolean matching) {
        if (config.getSubparts().size() == idx) {
            return new int[]{1, matching ? 1 : 0};
        }
        XSubpart subpart = config.getSubparts().get(idx);
        Set<Long> matchingSections = this.iSections.get(subpart.getSubpartId());
        int choicesThisSubpart = 0;
        int matchingChoicesThisSubpart = 0;
        for (XSection section : subpart.getSections()) {
            if (section.getParentId() != null) {
                XSection parent = null;
                for (XSection s : sections) {
                    if (!s.getSectionId().equals(section.getParentId())) continue;
                    parent = s;
                    break;
                }
                if (parent == null) continue;
            }
            if (section.isOverlapping(null, sections)) continue;
            sections.add(section);
            boolean m = matching && (matchingSections == null || matchingSections.contains(section.getSectionId()));
            int[] x = this.nrChoices(config, 1 + idx, sections, m);
            choicesThisSubpart += x[0];
            matchingChoicesThisSubpart += x[1];
            sections.remove(section);
        }
        return new int[]{choicesThisSubpart, matchingChoicesThisSubpart};
    }

    @Override
    public int compareTo(XReservation r) {
        if (this.getPriority() != r.getPriority()) {
            return this.getPriority() < r.getPriority() ? -1 : 1;
        }
        int cmp = Double.compare(this.getRestrictivity(), r.getRestrictivity());
        if (cmp != 0) {
            return cmp;
        }
        return this.getReservationId().compareTo(r.getReservationId());
    }

    public int getReservedAvailableSpace(XEnrollments enrollments) {
        if (this.getLimit() < 0) {
            return Integer.MAX_VALUE;
        }
        return this.getLimit() - enrollments.countEnrollmentsForReservation(this.getReservationId());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iExpirationDate = in.readBoolean() ? new Date(in.readLong()) : null;
        int nrConfigs = in.readInt();
        this.iConfigs.clear();
        for (int i = 0; i < nrConfigs; ++i) {
            this.iConfigs.add(in.readLong());
        }
        int nrSubparts = in.readInt();
        this.iSections.clear();
        for (int i = 0; i < nrSubparts; ++i) {
            HashSet<Long> sections = new HashSet<Long>();
            this.iSections.put(in.readLong(), sections);
            int nrSection = in.readInt();
            for (int j = 0; j < nrSection; ++j) {
                sections.add(in.readLong());
            }
        }
        this.iLimitCap = in.readInt();
        this.iRestrictivity = in.readDouble();
        this.iPriority = in.readInt();
        this.iFlags = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.iExpirationDate != null);
        if (this.iExpirationDate != null) {
            out.writeLong(this.iExpirationDate.getTime());
        }
        out.writeInt(this.iConfigs.size());
        for (Long config : this.iConfigs) {
            out.writeLong(config);
        }
        Set<Map.Entry<Long, Set<Long>>> entries = this.iSections.entrySet();
        out.writeInt(entries.size());
        for (Map.Entry<Long, Set<Long>> entry : entries) {
            out.writeLong(entry.getKey());
            out.writeInt(entry.getValue().size());
            for (Long id : entry.getValue()) {
                out.writeLong(id);
            }
        }
        out.writeInt(this.iLimitCap);
        out.writeDouble(this.iRestrictivity);
        out.writeInt(this.iPriority);
        out.writeInt(this.iFlags);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flags {
        MustBeUsed,
        CanAssignOverLimit,
        AllowOverlap;


        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags, boolean value) {
            if (value) {
                return flags | this.flag();
            }
            return flags & ~this.flag();
        }
    }
}

