/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.comparators;

import java.util.Comparator;
import org.unitime.timetable.model.ClassInstructor;

public class InstructorComparator
implements Comparator {
    public final short COMPARE_BY_NAME = 1;
    public final short COMPARE_BY_LEAD = (short)2;
    public final short COMPARE_BY_PCT_SHARE = (short)3;
    private short compareBy = 1;

    public void setCompareBy(short compareBy) {
        this.compareBy = compareBy;
    }

    public static int compareStrings(String s1, String s2) {
        return (s1 == null ? "" : s1.toUpperCase()).compareTo(s2 == null ? "" : s2.toUpperCase());
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof ClassInstructor)) {
            throw new ClassCastException("o1 Class must be of type ClassInstructor");
        }
        if (!(o2 instanceof ClassInstructor)) {
            throw new ClassCastException("o2 Class must be of type ClassInstructor");
        }
        ClassInstructor ci1 = (ClassInstructor)o1;
        ClassInstructor ci2 = (ClassInstructor)o2;
        if (ci1.getUniqueId().equals(ci2.getUniqueId())) {
            return 0;
        }
        int cmp = Double.compare(ci1.isLead() != false ? 0.0 : 1.0, ci2.isLead() != false ? 0.0 : 1.0);
        if (cmp != 0) {
            return cmp;
        }
        if ((this.compareBy == 2 || this.compareBy == 3) && (cmp = ci1.getPercentShare().compareTo(ci1.getPercentShare())) != 0) {
            return cmp;
        }
        cmp = InstructorComparator.compareStrings(ci1.getInstructor().getLastName(), ci2.getInstructor().getLastName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = InstructorComparator.compareStrings(ci1.getInstructor().getFirstName(), ci2.getInstructor().getFirstName());
        if (cmp != 0) {
            return cmp;
        }
        cmp = InstructorComparator.compareStrings(ci1.getInstructor().getMiddleName(), ci2.getInstructor().getMiddleName());
        if (cmp != 0) {
            return cmp;
        }
        return ci1.getInstructor().getUniqueId().compareTo(ci2.getInstructor().getUniqueId());
    }
}

