/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.CourseCreditFormat;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.DemandOfferingType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseSavedHQL;
import org.unitime.timetable.model.dao.SavedHQLDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedHQL
extends BaseSavedHQL {
    private static final long serialVersionUID = 2532519378106863655L;

    public static void main(String[] args) {
        for (Flag f : Flag.values()) {
            System.out.println(f.name() + ": " + f.flag() + " (" + f.isSet(255) + ")");
        }
    }

    public boolean isSet(Flag f) {
        return this.getType() != null && f.isSet(this.getType());
    }

    public void set(Flag f) {
        if (!this.isSet(f)) {
            this.setType((this.getType() == null ? 0 : this.getType()) + f.flag());
        }
    }

    public void clear(Flag f) {
        if (this.isSet(f)) {
            this.setType(this.getType() - f.flag());
        }
    }

    public static List<SavedHQL> listAll(org.hibernate.Session hibSession, Flag appearance, boolean admin) {
        if (admin) {
            return (hibSession == null ? SavedHQLDAO.getInstance().getSession() : hibSession).createQuery("from SavedHQL q where bit_and(q.type, :flag) > 0 order by q.name").setInteger("flag", appearance.flag()).setCacheable(true).list();
        }
        return (hibSession == null ? SavedHQLDAO.getInstance().getSession() : hibSession).createQuery("from SavedHQL q where bit_and(q.type, :flag) > 0 and bit_and(q.type, :admin) = 0 order by q.name").setInteger("flag", appearance.flag()).setInteger("admin", Flag.ADMIN_ONLY.flag()).setCacheable(true).list();
    }

    public static boolean hasQueries(Flag appearance, boolean admin) {
        if (admin) {
            return ((Number)SavedHQLDAO.getInstance().getSession().createQuery("select count(q) from SavedHQL q where bit_and(q.type, :flag) > 0").setInteger("flag", appearance.flag()).setCacheable(true).uniqueResult()).intValue() > 0;
        }
        return ((Number)SavedHQLDAO.getInstance().getSession().createQuery("select count(q) from SavedHQL q where bit_and(q.type, :flag) > 0 and bit_and(q.type, :admin) = 0").setInteger("flag", appearance.flag()).setInteger("admin", Flag.ADMIN_ONLY.flag()).setCacheable(true).uniqueResult()).intValue() > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        SESSION("Academic Session", false, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Session session;
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session2 = session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                if (session == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                ret.put(session.getUniqueId(), session.getLabel());
                return ret;
            }
        }),
        DEPARTMENT("Department", true, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Session session;
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session2 = session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                if (session == null) {
                    return null;
                }
                TimetableManager manager = TimetableManager.findByExternalId(user.getExternalUserId());
                if (manager == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (Department d : Department.getUserDepartments(user)) {
                    ret.put(d.getUniqueId(), d.htmlLabel());
                }
                return ret;
            }
        }),
        DEPARTMENTS("Departments", true, true, Option.DEPARTMENT.iImplementation),
        SUBJECT("Subject Area", true, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                try {
                    for (SubjectArea s : SubjectArea.getUserSubjectAreas(user)) {
                        ret.put(s.getUniqueId(), s.getSubjectAreaAbbreviation());
                    }
                }
                catch (Exception e) {
                    return null;
                }
                return ret;
            }
        }),
        SUBJECTS("Subject Areas", true, true, Option.SUBJECT.iImplementation),
        BUILDING("Building", true, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                TimetableManager manager = TimetableManager.findByExternalId(user.getExternalUserId());
                if (manager == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (Building b : Building.findAll(session.getUniqueId())) {
                    ret.put(b.getUniqueId(), b.getAbbrName());
                }
                return ret;
            }
        }),
        BUILDINGS("Buildings", true, true, Option.BUILDING.iImplementation),
        ROOM("Room", true, false, new OptionImplementation(){

            @Override
            public Map<Long, String> getValues(UserContext user) {
                Long sessionId = user.getCurrentAcademicSessionId();
                Session session = sessionId == null ? null : (Session)SessionDAO.getInstance().get(sessionId);
                TimetableManager manager = TimetableManager.findByExternalId(user.getExternalUserId());
                if (manager == null) {
                    return null;
                }
                Hashtable<Long, String> ret = new Hashtable<Long, String>();
                for (Room r : Room.findAllRooms(session.getUniqueId())) {
                    ret.put(r.getUniqueId(), r.getLabel());
                }
                return ret;
            }
        }),
        ROOMS("Rooms", true, true, Option.ROOM.iImplementation),
        DistributionType(DistributionType.class, false),
        DistributionTypes(DistributionType.class, true),
        DemandOfferingType(DemandOfferingType.class, false),
        DemandOfferingTypes(DemandOfferingType.class, true),
        OfferingConsentType(OfferingConsentType.class, false),
        OfferingConsentTypes(OfferingConsentType.class, true),
        CourseCreditFormat(CourseCreditFormat.class, false),
        CourseCreditFormats(CourseCreditFormat.class, true),
        CourseCreditType(CourseCreditType.class, false),
        CourseCreditTypes(CourseCreditType.class, true),
        CourseCreditUnitType(CourseCreditUnitType.class, false),
        CourseCreditUnitTypes(CourseCreditUnitType.class, true),
        PositionType(PositionType.class, false),
        PositionTypes(PositionType.class, true),
        DepartmentStatusType(DepartmentStatusType.class, false),
        DepartmentStatusTypes(DepartmentStatusType.class, true),
        RoomType(RoomType.class, false),
        RoomTypes(RoomType.class, true),
        StudentSectioningStatus(StudentSectioningStatus.class, false),
        StudentSectioningStatuses(StudentSectioningStatus.class, true),
        ExamType(ExamType.class, false),
        ExamTypes(ExamType.class, true),
        RoomFeatureType(RoomFeatureType.class, false),
        RoomFeatureTypes(RoomFeatureType.class, true),
        CourseType(CourseType.class, false),
        CourseTypes(CourseType.class, true);

        String iName;
        OptionImplementation iImplementation;
        boolean iAllowSelection;
        boolean iMultiSelect;

        private Option(String name, boolean allowSelection, boolean multiSelect, OptionImplementation impl) {
            this.iName = name;
            this.iAllowSelection = allowSelection;
            this.iMultiSelect = multiSelect;
            this.iImplementation = impl;
        }

        private Option(Class<? extends RefTableEntry> reference, boolean multiSelect) {
            this.iName = this.name().replaceAll("(?<=[^A-Z])([A-Z])", " $1");
            this.iAllowSelection = true;
            this.iMultiSelect = multiSelect;
            this.iImplementation = new RefTableOptions(reference);
        }

        public String text() {
            return this.iName;
        }

        public boolean allowSingleSelection() {
            return this.iAllowSelection;
        }

        public boolean allowMultiSelection() {
            return this.iAllowSelection && this.iMultiSelect;
        }

        public Map<Long, String> values(UserContext user) {
            return this.iImplementation.getValues(user);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefTableOptions
    implements OptionImplementation {
        private Class<? extends RefTableEntry> iReference;

        RefTableOptions(Class<? extends RefTableEntry> reference) {
            this.iReference = reference;
        }

        @Override
        public Map<Long, String> getValues(UserContext user) {
            Hashtable<Long, String> ret = new Hashtable<Long, String>();
            for (RefTableEntry ref : SessionDAO.getInstance().getSession().createCriteria(this.iReference).list()) {
                ret.put(ref.getUniqueId(), ref.getLabel());
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface OptionImplementation {
        public Map<Long, String> getValues(UserContext var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        APPEARANCE_COURSES("Appearance: Courses", "courses"),
        APPEARANCE_EXAMS("Appearance: Examinations", "exams"),
        APPEARANCE_SECTIONING("Appearance: Student Sectioning", "sectioning"),
        APPEARANCE_EVENTS("Appearance: Events", "events"),
        APPEARANCE_ADMINISTRATION("Appearance: Administration", "administration"),
        ADMIN_ONLY("Restrictions: Administrator Only");

        private String iDescription;
        private String iAppearance;

        private Flag(String desc, String appearance) {
            this.iDescription = desc;
            this.iAppearance = appearance;
        }

        private Flag(String desc) {
            this(desc, null);
        }

        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean isSet(int type) {
            return (type & this.flag()) != 0;
        }

        public String description() {
            return this.iDescription;
        }

        public String getAppearance() {
            return this.iAppearance;
        }
    }
}

