/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BasePreference;

public abstract class Preference
extends BasePreference
implements Comparable {
    private static final long serialVersionUID = 1L;
    public static final String BLANK_PREF_VALUE = "-";

    public Preference() {
    }

    public Preference(Long uniqueId) {
        super(uniqueId);
    }

    public String preferenceTitle() {
        return this.getPrefLevel().getPrefName() + " " + this.preferenceText();
    }

    public String preferenceHtml() {
        StringBuffer sb = new StringBuffer("<span ");
        String style = "font-weight:bold;";
        if (this.getPrefLevel().getPrefId() != 4) {
            style = style + "color:" + this.getPrefLevel().prefcolor() + ";";
        }
        if (this.getOwner() != null && this.getOwner() instanceof Class_ && ApplicationProperty.PreferencesHighlighClassPreferences.isTrue()) {
            style = style + "background: #ffa;";
        }
        sb.append("style='" + style + "' ");
        String owner = "";
        if (this.getOwner() != null && this.getOwner() instanceof Class_) {
            owner = " (class)";
        } else if (this.getOwner() != null && this.getOwner() instanceof SchedulingSubpart) {
            owner = " (scheduling subpart)";
        } else if (this.getOwner() != null && this.getOwner() instanceof DepartmentalInstructor) {
            owner = " (instructor)";
        } else if (this.getOwner() != null && this.getOwner() instanceof Exam) {
            owner = " (examination)";
        } else if (this.getOwner() != null && this.getOwner() instanceof Department) {
            owner = " (department)";
        } else if (this.getOwner() != null && this.getOwner() instanceof Session) {
            owner = " (session)";
        }
        sb.append("onmouseover=\"showGwtHint(this, '" + this.preferenceTitle() + owner + "');\" onmouseout=\"hideGwtHint();\">");
        sb.append(this.preferenceAbbv());
        sb.append("</span>");
        return sb.toString();
    }

    public abstract String preferenceText();

    public String preferenceAbbv() {
        return this.preferenceText();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Preference)) {
            throw new RuntimeException("Object must be of type Preference");
        }
        Preference p = (Preference)o;
        int cmp = this.getClass().getName().compareTo(o.getClass().getName());
        if (cmp != 0) {
            return cmp;
        }
        if (this.getUniqueId() == null || p.getUniqueId() == null) {
            return -1;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(p.getUniqueId() == null ? -1L : p.getUniqueId());
    }

    public boolean appliesTo(PreferenceGroup group) {
        return true;
    }

    public boolean weakenHardPreferences() {
        if (PreferenceLevel.sRequired.equals(this.getPrefLevel().getPrefProlog())) {
            this.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
        }
        if (PreferenceLevel.sProhibited.equals(this.getPrefLevel().getPrefProlog())) {
            this.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyDiscouraged));
        }
        return true;
    }

    public abstract Object clone();

    public abstract boolean isSame(Preference var1);
}

