/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.HashMap;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.model.dao.AcademicClassificationDAO;

public class AcademicClassification
extends BaseAcademicClassification {
    private static final long serialVersionUID = 1L;
    private static HashMap academicClassifications = new HashMap(40);
    public static final String ACAD_CLASS_REQUEST_ATTR = "academicClassifications";

    public AcademicClassification() {
    }

    public AcademicClassification(Long uniqueId) {
        super(uniqueId);
    }

    public static List getAcademicClassificationList(Long sessionId) throws HibernateException {
        AcademicClassificationDAO adao = new AcademicClassificationDAO();
        Session hibSession = adao.getSession();
        List l = hibSession.createQuery("select c from AcademicClassification as c where c.session.uniqueId=:sessionId order by c.name").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        return l;
    }

    public String getLabelNameCode() {
        return this.getName() + " - " + this.getCode();
    }

    public String getLabelCodeName() {
        return this.getCode() + " - " + this.getName();
    }

    public static void loadAcademicClassifications(Long sessionId) {
        List acadClasses = AcademicClassification.getAcademicClassificationList(sessionId);
        for (int i = 0; i < acadClasses.size(); ++i) {
            AcademicClassification acadClass = (AcademicClassification)acadClasses.get(i);
            String code = acadClass.getCode();
            academicClassifications.put(code, acadClass);
        }
    }

    public static AcademicClassification getAcademicClassification(String academicClass) {
        return (AcademicClassification)academicClassifications.get(academicClass);
    }

    public Long getSessionId() {
        if (this.getSession() != null) {
            return this.getSession().getUniqueId();
        }
        return null;
    }

    public static AcademicClassification findByCode(Long sessionId, String code) {
        return AcademicClassification.findByCode(new AcademicClassificationDAO().getSession(), sessionId, code);
    }

    public static AcademicClassification findByCode(Session hibSession, Long sessionId, String code) {
        return (AcademicClassification)hibSession.createQuery("select a from AcademicClassification a where a.session.uniqueId=:sessionId and a.code=:code").setLong("sessionId", sessionId.longValue()).setString("code", code).setCacheable(true).uniqueResult();
    }

    public static AcademicClassification findByExternalId(Long sessionId, String externalId) {
        return AcademicClassification.findByExternalId(new AcademicClassificationDAO().getSession(), sessionId, externalId);
    }

    public static AcademicClassification findByExternalId(Session hibSession, Long sessionId, String externalId) {
        return (AcademicClassification)hibSession.createQuery("select a from AcademicClassification a where a.session.uniqueId=:sessionId and a.externalUniqueId=:externalUniqueId").setLong("sessionId", sessionId.longValue()).setString("externalUniqueId", externalId).setCacheable(true).uniqueResult();
    }

    public Object clone() {
        AcademicClassification c = new AcademicClassification();
        c.setExternalUniqueId(this.getExternalUniqueId());
        c.setCode(this.getCode());
        c.setName(this.getName());
        return c;
    }
}

