/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class PatternServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean vertical = "1".equals(request.getParameter("v"));
        RequiredTimeTable rtt = null;
        if (request.getParameter("tp") != null) {
            TimePattern p = (TimePattern)TimePatternDAO.getInstance().get(Long.valueOf(request.getParameter("tp")));
            if (p != null) {
                TimeLocation t = null;
                if (request.getParameter("as") != null && request.getParameter("ad") != null) {
                    t = new TimeLocation(Integer.parseInt(request.getParameter("ad")), Integer.parseInt(request.getParameter("as")), 1, 0, 0.0, null, null, null, 0);
                }
                rtt = new RequiredTimeTable(p.getTimePatternModel(t, true));
            }
        } else if (request.getParameter("loc") != null) {
            Location location = (Location)LocationDAO.getInstance().get(Long.valueOf(request.getParameter("loc")));
            if (location != null) {
                if (request.getParameter("xt") != null) {
                    PeriodPreferenceModel px = new PeriodPreferenceModel(location.getSession(), Long.valueOf(request.getParameter("xt")));
                    px.load(location);
                    rtt = new RequiredTimeTable(px);
                } else {
                    rtt = "1".equals(request.getParameter("e")) ? location.getEventAvailabilityTable() : location.getRoomSharingTable();
                }
            }
        } else if (request.getParameter("x") != null) {
            Exam exam = (Exam)ExamDAO.getInstance().get(Long.valueOf(request.getParameter("x")));
            if (exam != null) {
                ExamPeriod p = null;
                if (request.getParameter("ap") != null) {
                    p = (ExamPeriod)ExamPeriodDAO.getInstance().get(Long.valueOf(request.getParameter("ap")));
                }
                PeriodPreferenceModel px = new PeriodPreferenceModel(exam.getSession(), p, exam.getExamType().getUniqueId());
                px.load(exam);
                rtt = new RequiredTimeTable(px);
            }
        } else {
            rtt = new RequiredTimeTable(new TimePattern().getTimePatternModel());
        }
        if (rtt != null) {
            if (request.getParameter("s") != null) {
                try {
                    rtt.getModel().setDefaultSelection(Integer.parseInt(request.getParameter("s")));
                }
                catch (NumberFormatException e) {
                    rtt.getModel().setDefaultSelection(request.getParameter("s"));
                }
            }
            if (request.getParameter("p") != null) {
                rtt.getModel().setPreferences(request.getParameter("p"));
            }
            boolean hc = "1".equals(request.getParameter("hc"));
            response.setContentType("image/png");
            response.setHeader("Content-Disposition", "attachment; filename=\"pattern.png\"");
            BufferedImage image = rtt.createBufferedImage(vertical, hc);
            if (image != null) {
                ImageIO.write((RenderedImage)image, "PNG", (OutputStream)response.getOutputStream());
            }
        }
    }
}

