/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.mobile.client.page;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.mgwt.dom.client.event.tap.TapEvent;
import com.googlecode.mgwt.dom.client.event.tap.TapHandler;
import com.googlecode.mgwt.ui.client.MGWT;
import com.googlecode.mgwt.ui.client.animation.AnimationHelper;
import com.googlecode.mgwt.ui.client.widget.animation.AnimationEndCallback;
import com.googlecode.mgwt.ui.client.widget.animation.Animations;
import com.googlecode.mgwt.ui.client.widget.button.ImageButton;
import com.googlecode.mgwt.ui.client.widget.button.image.PreviousitemImageButton;
import com.googlecode.mgwt.ui.client.widget.header.HeaderPanel;
import com.googlecode.mgwt.ui.client.widget.header.HeaderTitle;
import com.googlecode.mgwt.ui.client.widget.list.celllist.Cell;
import com.googlecode.mgwt.ui.client.widget.list.celllist.CellList;
import com.googlecode.mgwt.ui.client.widget.list.celllist.CellSelectedEvent;
import com.googlecode.mgwt.ui.client.widget.list.celllist.CellSelectedHandler;
import com.googlecode.mgwt.ui.client.widget.panel.flex.FixedSpacer;
import com.googlecode.mgwt.ui.client.widget.panel.flex.FlexPanel;
import com.googlecode.mgwt.ui.client.widget.panel.flex.FlexSpacer;
import com.googlecode.mgwt.ui.client.widget.panel.scroll.ScrollPanel;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeMenu;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.mobile.resources.MobileResourceHolder;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.MenuInterface;

public class MobileMenu
extends UniTimeMenu {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final Template TEMPLATE = (Template)GWT.create(Template.class);
    private AnimationHelper iAnimationHelper = new AnimationHelper();
    private ImageButton iButton;
    private MenuWidget iMenu = null;
    private HandlerRegistration iPageLabelRegistration = null;

    public MobileMenu() {
        this.iAnimationHelper.addStyleName("unitime-AnimationHelper");
        this.iButton = new ImageButton(MobileResourceHolder.get().menu());
        this.iButton.addTapHandler(new TapHandler(){

            public void onTap(TapEvent event) {
                RootPanel.get().add((Widget)MobileMenu.this.iAnimationHelper);
                MobileMenu.this.iAnimationHelper.goTo((Widget)MobileMenu.this.iMenu, Animations.SLIDE);
            }
        });
    }

    private void attach(final RootPanel rootPanel) {
        RPC.execute(new MenuInterface.MenuRpcRequest(), new AsyncCallback<GwtRpcResponseList<MenuInterface>>(){

            public void onSuccess(GwtRpcResponseList<MenuInterface> result) {
                MobileMenu.this.iMenu = new MenuWidget(null, result, new TapHandler(){

                    public void onTap(TapEvent event) {
                        MobileMenu.this.iAnimationHelper.goTo(null, Animations.SLIDE_REVERSE, new AnimationEndCallback(){

                            public void onAnimationEnd() {
                                if (MobileMenu.this.iAnimationHelper.isAttached()) {
                                    RootPanel.get().remove((Widget)MobileMenu.this.iAnimationHelper);
                                }
                            }
                        });
                    }
                });
                rootPanel.add((Widget)MobileMenu.this.iButton);
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    public void reload() {
        RPC.execute(new MenuInterface.MenuRpcRequest(), new AsyncCallback<GwtRpcResponseList<MenuInterface>>(){

            public void onSuccess(GwtRpcResponseList<MenuInterface> result) {
                if (MobileMenu.this.iPageLabelRegistration != null) {
                    MobileMenu.this.iPageLabelRegistration.removeHandler();
                    MobileMenu.this.iPageLabelRegistration = null;
                }
                MobileMenu.this.iMenu = new MenuWidget(null, result, new TapHandler(){

                    public void onTap(TapEvent event) {
                        MobileMenu.this.iAnimationHelper.goTo(null, Animations.SLIDE_REVERSE, new AnimationEndCallback(){

                            public void onAnimationEnd() {
                                if (MobileMenu.this.iAnimationHelper.isAttached()) {
                                    RootPanel.get().remove((Widget)MobileMenu.this.iAnimationHelper);
                                }
                            }
                        });
                    }
                });
            }

            public void onFailure(Throwable caught) {
            }
        });
    }

    public void insert(RootPanel panel) {
        if ("hide".equals(Window.Location.getParameter((String)"menu"))) {
            panel.setVisible(false);
        } else {
            this.attach(panel);
        }
    }

    protected void openUrl(String name, String url, String target) {
        if ("PAGE_HELP".equals(url)) {
            url = UniTimePageLabel.getInstance().getValue().getHelpUrl();
            name = UniTimePageLabel.getInstance().getValue().getName();
            if (url == null || url.isEmpty()) {
                return;
            }
        }
        if (target == null) {
            LoadingWidget.getInstance().show();
        }
        if ("dialog".equals(target)) {
            UniTimeFrameDialog.openDialog(name, url);
        } else if ("eval".equals(target)) {
            ToolBox.eval(url);
        } else if ("download".equals(target)) {
            ToolBox.open(url);
        } else {
            ToolBox.open(GWT.getHostPageBaseURL() + url);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MenuWidget
    extends FlexPanel {
        private HeaderPanel iHeaderPanel;
        private PreviousitemImageButton iHeaderBackButton;
        private HeaderTitle iHeaderTitle;
        private CellList<MenuInterface> iCellList;
        private List<MenuInterface> iMenu;
        private boolean iFirstItemIsParent = false;

        public MenuWidget(MenuInterface parent, List<MenuInterface> menus, TapHandler back) {
            if (MGWT.getFormFactor().isTablet()) {
                this.setStyleName("unitime-MobileMenuTablet");
            } else {
                this.setStyleName("unitime-MobileMenuPhone");
            }
            this.iHeaderPanel = new HeaderPanel();
            this.add((Widget)this.iHeaderPanel);
            this.iHeaderBackButton = new PreviousitemImageButton();
            this.iHeaderPanel.add((Widget)this.iHeaderBackButton);
            this.iHeaderPanel.add((Widget)new FlexSpacer());
            this.iHeaderTitle = new HeaderTitle(parent == null ? MESSAGES.navigation() : parent.getName());
            this.iHeaderPanel.add((Widget)this.iHeaderTitle);
            this.iHeaderPanel.add((Widget)new FlexSpacer());
            FixedSpacer fixedSpacer = new FixedSpacer();
            fixedSpacer.setVisible(!MGWT.getOsDetection().isAndroid());
            this.iHeaderPanel.add((Widget)fixedSpacer);
            ScrollPanel scrollPanel = new ScrollPanel();
            this.iCellList = new CellList((Cell)new Cell<MenuInterface>(){

                public void render(SafeHtmlBuilder safeHtmlBuilder, MenuInterface item) {
                    safeHtmlBuilder.append(TEMPLATE.content(item.getName()));
                }

                public boolean canBeSelected(MenuInterface item) {
                    return item.hasSubMenus() || item.hasPage();
                }
            });
            scrollPanel.setWidget(this.iCellList);
            scrollPanel.setScrollingEnabledX(false);
            this.add((Widget)scrollPanel);
            this.iMenu = new ArrayList<MenuInterface>();
            if (parent != null && parent.hasPage()) {
                this.iFirstItemIsParent = true;
                this.iMenu.add(parent);
            } else {
                this.iFirstItemIsParent = false;
            }
            for (MenuInterface menu : menus) {
                if (menu.isSeparator()) continue;
                this.iMenu.add(menu);
            }
            this.iCellList.render(this.iMenu);
            final MenuInterface.ValueEncoder encoder = new MenuInterface.ValueEncoder(){

                public String encode(String value) {
                    return URL.encodeQueryString((String)value);
                }
            };
            this.iCellList.addCellSelectedHandler(new CellSelectedHandler(){

                public void onCellSelected(CellSelectedEvent event) {
                    MenuInterface item = (MenuInterface)MenuWidget.this.iMenu.get(event.getIndex());
                    if (event.getIndex() == 0 && MenuWidget.this.iFirstItemIsParent && item.hasPage()) {
                        MobileMenu.this.openUrl(item.getName(), item.getURL(encoder), item.getTarget());
                    } else if (item.hasSubMenus()) {
                        MenuWidget m = new MenuWidget(item, item.getSubMenus(), new TapHandler(){

                            public void onTap(TapEvent event) {
                                MobileMenu.this.iAnimationHelper.goTo((Widget)MenuWidget.this, Animations.SLIDE_REVERSE);
                            }
                        });
                        MobileMenu.this.iAnimationHelper.goTo((Widget)m, Animations.SLIDE);
                    } else if (item.hasPage()) {
                        MobileMenu.this.iAnimationHelper.goTo(null, Animations.SLIDE_REVERSE, new AnimationEndCallback(){

                            public void onAnimationEnd() {
                                if (MobileMenu.this.iAnimationHelper.isAttached()) {
                                    RootPanel.get().remove((Widget)MobileMenu.this.iAnimationHelper);
                                }
                            }
                        });
                        MobileMenu.this.openUrl(item.getName(), item.getURL(encoder), item.getTarget());
                    }
                }
            });
            this.iHeaderBackButton.addTapHandler(back);
        }
    }

    public static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div>{0}</div>")
        public SafeHtml content(String var1);
    }
}

