/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniTimeTableHeader
extends HTML
implements UniTimeTable.HasStyleName,
UniTimeTable.HasCellAlignment,
UniTimeTable.HasColSpan,
UniTimeTable.HasAdditionalStyleNames,
UniTimeTable.HasColumn {
    private int iColSpan = 1;
    private int iColumn = -1;
    private HasHorizontalAlignment.HorizontalAlignmentConstant iAlign;
    private List<Operation> iOperations = new ArrayList<Operation>();
    private List<String> iStyleNames = new ArrayList<String>();
    private String iTitle = null;
    private Boolean iOrder = null;
    private ClickHandler iClickHandler = null;

    public UniTimeTableHeader(String title, int colSpan, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        super(title, false);
        this.iColSpan = colSpan;
        this.iAlign = align;
        this.iTitle = title;
        this.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PopupPanel popup = new PopupPanel(true);
                popup.addStyleName("unitime-Menu");
                if (!UniTimeTableHeader.this.setMenu(popup)) {
                    return;
                }
                popup.showRelativeTo((UIObject)((Widget)event.getSource()));
                ((MenuBar)popup.getWidget()).focus();
            }
        });
    }

    public UniTimeTableHeader(String title, int colSpan, HasHorizontalAlignment.HorizontalAlignmentConstant align, ClickHandler clickHandler) {
        super(title, false);
        this.iColSpan = colSpan;
        this.iAlign = align;
        this.iTitle = title;
        this.iClickHandler = clickHandler;
        this.addClickHandler(clickHandler);
    }

    public boolean setMenu(final PopupPanel popup) {
        List<Operation> operations = this.getOperations();
        if (operations.isEmpty()) {
            return false;
        }
        boolean first = true;
        MenuBarWithAccessKeys menu = new MenuBarWithAccessKeys();
        for (final Operation op : operations) {
            if (!op.isApplicable()) continue;
            if (op.hasSeparator() && !first) {
                menu.addSeparator();
            }
            first = false;
            MenuItem item = new MenuItem(op.getName(), true, (Scheduler.ScheduledCommand)new Command(){

                public void execute() {
                    popup.hide();
                    op.execute();
                }
            });
            if (op instanceof AriaOperation) {
                Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), ((AriaOperation)op).getAriaLabel());
            } else {
                Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(op.getName()));
            }
            menu.addItem(item);
        }
        if (first) {
            return false;
        }
        menu.setVisible(true);
        popup.add((Widget)menu);
        return true;
    }

    public UniTimeTableHeader(String title) {
        this(title, 1, HasHorizontalAlignment.ALIGN_LEFT);
    }

    public UniTimeTableHeader(String title, int colSpan) {
        this(title, colSpan, HasHorizontalAlignment.ALIGN_LEFT);
    }

    public UniTimeTableHeader() {
        this(" ", 1, HasHorizontalAlignment.ALIGN_LEFT);
    }

    public UniTimeTableHeader(String title, ClickHandler clickHandler) {
        this(title, 1, HasHorizontalAlignment.ALIGN_LEFT, clickHandler);
    }

    public UniTimeTableHeader(String title, int colSpan, ClickHandler clickHandler) {
        this(title, colSpan, HasHorizontalAlignment.ALIGN_LEFT, clickHandler);
    }

    public UniTimeTableHeader(ClickHandler clickHandler) {
        this(" ", 1, HasHorizontalAlignment.ALIGN_LEFT, clickHandler);
    }

    public UniTimeTableHeader(String title, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
        this(title, 1, align);
    }

    @Override
    public int getColSpan() {
        return this.iColSpan;
    }

    @Override
    public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
        return this.iAlign;
    }

    @Override
    public String getStyleName() {
        return this.iOperations.isEmpty() && this.iClickHandler == null ? "unitime-TableHeader" : "unitime-ClickableTableHeader";
    }

    public void addOperation(Operation operation) {
        this.iOperations.add(operation);
    }

    public List<Operation> getOperations() {
        return this.iOperations;
    }

    public String getHint() {
        return null;
    }

    @Override
    public List<String> getAdditionalStyleNames() {
        return this.iStyleNames;
    }

    public void addAdditionalStyleName(String styleName) {
        this.iStyleNames.add(styleName);
    }

    @Override
    public int getColumn() {
        return this.iColumn;
    }

    @Override
    public void setColumn(int column) {
        this.iColumn = column;
    }

    public void setHTML(String html) {
        this.iTitle = html;
        super.setHTML(html);
    }

    public String getHTML() {
        return this.iTitle;
    }

    public void setOrder(Boolean order) {
        this.iOrder = order;
        super.setHTML(order == null ? this.iTitle : (order != false ? "&uarr; " + this.iTitle : "&darr; " + this.iTitle));
    }

    public Boolean getOrder() {
        return this.iOrder;
    }

    public static class MenuBarWithAccessKeys
    extends MenuBar {
        private Map<Character, MenuItem> iAccessKeys = new HashMap<Character, MenuItem>();

        public MenuBarWithAccessKeys() {
            super(true);
            this.setFocusOnHoverEnabled(true);
            this.sinkEvents(256);
        }

        public MenuItem addItem(MenuItem item) {
            Character ch = UniTimeHeaderPanel.guessAccessKey(item.getHTML());
            if (ch != null) {
                this.iAccessKeys.put(Character.valueOf(Character.toLowerCase(ch.charValue())), item);
            }
            item.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            return super.addItem(item);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 256: {
                    MenuItem item = this.iAccessKeys.get(Character.valueOf(Character.toLowerCase((char)event.getCharCode())));
                    if (item == null) break;
                    item.getScheduledCommand().execute();
                }
            }
            super.onBrowserEvent(event);
        }
    }

    public static interface AriaOperation
    extends Operation {
        public String getAriaLabel();
    }

    public static interface Operation
    extends Command {
        public String getName();

        public boolean isApplicable();

        public boolean hasSeparator();
    }
}

