/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.CourseRequestsTable;
import org.unitime.timetable.gwt.client.sectioning.PinDialog;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningPage;
import org.unitime.timetable.gwt.client.sectioning.SuggestionsBox;
import org.unitime.timetable.gwt.client.sectioning.TimeGrid;
import org.unitime.timetable.gwt.client.widgets.ImageLink;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeTabPanel;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.UserAuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSectioningWidget
extends Composite
implements HasResizeHandlers {
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    public static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private AcademicSessionProvider iSessionSelector;
    private UserAuthenticationProvider iUserAuthentication;
    private VerticalPanel iPanel;
    private HorizontalPanel iFooter;
    private AriaButton iRequests;
    private AriaButton iReset;
    private AriaButton iSchedule;
    private AriaButton iEnroll;
    private AriaButton iPrint;
    private AriaButton iExport = null;
    private AriaButton iSave;
    private AriaButton iStartOver;
    private UniTimeTabPanel iAssignmentPanel;
    private FocusPanel iAssignmentPanelWithFocus;
    private ImageLink iCalendar = null;
    private CourseRequestsTable iCourseRequests;
    private WebTable iAssignments;
    private TimeGrid iAssignmentGrid;
    private SuggestionsBox iSuggestionsBox;
    private CheckBox iShowUnassignments;
    private Label iTotalCredit;
    private ArrayList<ClassAssignmentInterface.ClassAssignment> iLastResult;
    private ClassAssignmentInterface iLastAssignment;
    private ClassAssignmentInterface iSavedAssignment = null;
    private ArrayList<HistoryItem> iHistory = new ArrayList();
    private int iAssignmentTab = 0;
    private boolean iInRestore = false;
    private boolean iTrackHistory = true;
    private boolean iOnline;
    private StudentSectioningPage.Mode iMode = null;
    private OnlineSectioningInterface.EligibilityCheck iEligibilityCheck = null;
    private PinDialog iPinDialog = null;
    private boolean iScheduleChanged = false;
    private HTML iMessage = null;

    public StudentSectioningWidget(boolean online, AcademicSessionProvider sessionSelector, UserAuthenticationProvider userAuthentication, StudentSectioningPage.Mode mode, boolean history) {
        this.iMode = mode;
        this.iOnline = online;
        this.iSessionSelector = sessionSelector;
        this.iUserAuthentication = userAuthentication;
        this.iTrackHistory = history;
        this.iPanel = new VerticalPanel();
        this.iCourseRequests = new CourseRequestsTable(this.iSessionSelector, this.iOnline);
        this.iCourseRequests.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface>(){

            public void onValueChange(ValueChangeEvent<CourseRequestInterface> event) {
                if (StudentSectioningWidget.this.iLastAssignment == null || !StudentSectioningWidget.this.iLastAssignment.isCanEnroll() || StudentSectioningWidget.this.iEligibilityCheck == null || !StudentSectioningWidget.this.iEligibilityCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL)) {
                    return;
                }
                if (!StudentSectioningWidget.this.iScheduleChanged || MESSAGES.warnScheduleChanged().equals(StudentSectioningWidget.this.getMessage())) {
                    block0: for (ClassAssignmentInterface.CourseAssignment course : StudentSectioningWidget.this.iLastAssignment.getCourseAssignments()) {
                        if (!course.isAssigned() || course.isFreeTime()) continue;
                        for (CourseRequestInterface.Request r : ((CourseRequestInterface)event.getValue()).getCourses()) {
                            if (!(r.hasRequestedCourse() && course.getCourseName().equalsIgnoreCase(r.getRequestedCourse()) || r.hasFirstAlternative() && course.getCourseName().equalsIgnoreCase(r.getFirstAlternative())) && (!r.hasSecondAlternative() || !course.getCourseName().equalsIgnoreCase(r.getSecondAlternative()))) continue;
                            continue block0;
                        }
                        for (CourseRequestInterface.Request r : ((CourseRequestInterface)event.getValue()).getAlternatives()) {
                            if (!(r.hasRequestedCourse() && course.getCourseName().equalsIgnoreCase(r.getRequestedCourse()) || r.hasFirstAlternative() && course.getCourseName().equalsIgnoreCase(r.getFirstAlternative())) && (!r.hasSecondAlternative() || !course.getCourseName().equalsIgnoreCase(r.getSecondAlternative()))) continue;
                            continue block0;
                        }
                        StudentSectioningWidget.this.iScheduleChanged = true;
                        StudentSectioningWidget.this.setWarning(MESSAGES.warnScheduleChanged(), false);
                        StudentSectioningWidget.this.iEnroll.addStyleName("unitime-EnrollButton");
                        return;
                    }
                    StudentSectioningWidget.this.iScheduleChanged = false;
                    StudentSectioningWidget.this.clearMessage();
                }
            }
        });
        this.iPanel.add((Widget)this.iCourseRequests);
        this.iFooter = new HorizontalPanel();
        this.iFooter.setStyleName("unitime-MainTableBottomHeader");
        this.iFooter.setWidth("100%");
        HorizontalPanel leftFooterPanel = new HorizontalPanel();
        this.iRequests = new AriaButton(MESSAGES.buttonRequests());
        this.iRequests.setTitle(MESSAGES.hintRequests());
        this.iRequests.setVisible(false);
        this.iRequests.setEnabled(false);
        leftFooterPanel.add((Widget)this.iRequests);
        this.iReset = new AriaButton(MESSAGES.buttonReset());
        this.iReset.setTitle(MESSAGES.hintReset());
        this.iReset.setVisible(false);
        this.iReset.setEnabled(false);
        this.iReset.getElement().getStyle().setMarginLeft(4.0, Style.Unit.PX);
        this.iReset.getElement().getStyle().setMarginRight(4.0, Style.Unit.PX);
        leftFooterPanel.add((Widget)this.iReset);
        this.iFooter.add((Widget)leftFooterPanel);
        HorizontalPanel rightFooterPanel = new HorizontalPanel();
        this.iFooter.add((Widget)rightFooterPanel);
        this.iFooter.setCellHorizontalAlignment((Widget)rightFooterPanel, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iStartOver = new AriaButton(MESSAGES.buttonStartOver());
        this.iStartOver.setTitle(MESSAGES.hintStartOver());
        if (mode.isSectioning()) {
            leftFooterPanel.add((Widget)this.iStartOver);
        }
        this.iStartOver.setVisible(false);
        this.iStartOver.setEnabled(false);
        this.iSchedule = new AriaButton(MESSAGES.buttonSchedule());
        this.iSchedule.setTitle(MESSAGES.hintSchedule());
        if (mode.isSectioning()) {
            rightFooterPanel.add((Widget)this.iSchedule);
        }
        this.iSchedule.setVisible(mode.isSectioning());
        this.iSchedule.setEnabled(mode.isSectioning());
        this.iSave = new AriaButton(MESSAGES.buttonSave());
        this.iSave.setTitle(MESSAGES.hintSave());
        if (!mode.isSectioning()) {
            rightFooterPanel.add((Widget)this.iSave);
        }
        this.iSave.setVisible(!mode.isSectioning());
        this.iSave.setEnabled(!mode.isSectioning());
        this.iEnroll = new AriaButton(MESSAGES.buttonEnroll());
        this.iEnroll.setTitle(MESSAGES.hintEnroll());
        this.iEnroll.setVisible(false);
        this.iEnroll.setEnabled(false);
        rightFooterPanel.add((Widget)this.iEnroll);
        this.iPrint = new AriaButton(MESSAGES.buttonPrint());
        this.iPrint.setTitle(MESSAGES.hintPrint());
        this.iPrint.setVisible(false);
        this.iPrint.setEnabled(false);
        this.iPrint.getElement().getStyle().setMarginLeft(4.0, Style.Unit.PX);
        rightFooterPanel.add((Widget)this.iPrint);
        if (CONSTANTS.allowCalendarExport()) {
            this.iExport = new AriaButton(MESSAGES.buttonExport());
            this.iExport.setTitle(MESSAGES.hintExport());
            this.iExport.setVisible(false);
            this.iExport.setEnabled(false);
            this.iExport.getElement().getStyle().setMarginLeft(4.0, Style.Unit.PX);
            rightFooterPanel.add((Widget)this.iExport);
        }
        this.iPanel.add((Widget)this.iFooter);
        this.iMessage = new HTML();
        this.iMessage.setStyleName("unitime-ScheduleBlankMessage");
        this.iPanel.add((Widget)this.iMessage);
        this.iLastResult = new ArrayList();
        this.initWidget((Widget)this.iPanel);
        this.init();
    }

    private void addHistory() {
        if (this.iInRestore || !this.iTrackHistory || this.iUserAuthentication.getUser() == null) {
            return;
        }
        this.iHistory.add(new HistoryItem());
        History.newItem((String)String.valueOf(this.iHistory.size() - 1), (boolean)false);
    }

    private void updateHistory() {
        if (this.iInRestore || !this.iTrackHistory || this.iUserAuthentication.getUser() == null) {
            return;
        }
        if (!this.iHistory.isEmpty()) {
            this.iHistory.remove(this.iHistory.size() - 1);
        }
        this.addHistory();
    }

    private void init() {
        if (CONSTANTS.allowCalendarExport()) {
            this.iCalendar = new ImageLink();
            this.iCalendar.setImage(new Image(RESOURCES.calendar()));
            this.iCalendar.setTarget(null);
            this.iCalendar.setTitle(MESSAGES.exportICalendar());
            this.iCalendar.setAriaLabel(MESSAGES.exportICalendar());
        }
        this.iAssignments = new WebTable();
        this.iAssignments.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colLock(), 1, "15px"), new WebTable.Cell(MESSAGES.colSubject(), 1, "40px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "40px"), new WebTable.Cell(MESSAGES.colSubpart(), 1, "30px"), new WebTable.Cell(MESSAGES.colClass(), 1, "50px"), new WebTable.Cell(MESSAGES.colLimit(), 1, "30px").aria(ARIA.colLimit()), new WebTable.Cell(MESSAGES.colDays(), 1, "30px"), new WebTable.Cell(MESSAGES.colStart(), 1, "40px"), new WebTable.Cell(MESSAGES.colEnd(), 1, "40px"), new WebTable.Cell(MESSAGES.colDate(), 1, "50px"), new WebTable.Cell(MESSAGES.colRoom(), 1, "80px"), new WebTable.Cell(MESSAGES.colInstructor(), 1, "80px"), new WebTable.Cell(MESSAGES.colParent(), 1, "80px"), new WebTable.Cell(MESSAGES.colNote(), 1, "50px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "30px"), this.iCalendar != null ? new WebTable.WidgetCell(this.iCalendar, MESSAGES.colIcons(), 1, "1px") : new WebTable.Cell(MESSAGES.colIcons(), 1, "1px")));
        this.iAssignments.setWidth("100%");
        this.iAssignments.setEmptyMessage(MESSAGES.emptySchedule());
        FlexTable vp = new FlexTable();
        vp.setCellPadding(0);
        vp.setCellSpacing(0);
        vp.setWidget(0, 0, (Widget)this.iAssignments);
        vp.getFlexCellFormatter().setColSpan(0, 0, 2);
        this.iTotalCredit = new Label();
        this.iTotalCredit.getElement().getStyle().setMarginTop(2.0, Style.Unit.PX);
        vp.setWidget(1, 0, (Widget)this.iTotalCredit);
        this.iShowUnassignments = new CheckBox(MESSAGES.showUnassignments());
        this.iShowUnassignments.getElement().getStyle().setMarginTop(2.0, Style.Unit.PX);
        vp.setWidget(1, 1, (Widget)this.iShowUnassignments);
        vp.getFlexCellFormatter().setHorizontalAlignment(1, 1, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iShowUnassignments.setVisible(false);
        String showUnassignments = Cookies.getCookie((String)"UniTime:Unassignments");
        this.iShowUnassignments.setValue(Boolean.valueOf(showUnassignments == null || "1".equals(showUnassignments)));
        this.iAssignmentPanel = new UniTimeTabPanel();
        this.iAssignmentPanel.add((Widget)vp, MESSAGES.tabClasses(), true);
        this.iAssignmentPanel.selectTab(0);
        this.iAssignmentGrid = new TimeGrid();
        this.iAssignmentPanel.add((Widget)this.iAssignmentGrid, MESSAGES.tabTimetable(), true);
        this.iAssignmentPanel.addSelectionHandler(new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                StudentSectioningWidget.this.iAssignmentTab = (Integer)event.getSelectedItem();
                if ((Integer)event.getSelectedItem() == 1) {
                    StudentSectioningWidget.this.iAssignmentGrid.scrollDown();
                }
                StudentSectioningWidget.this.addHistory();
                if (StudentSectioningWidget.this.iAssignmentTab == 0) {
                    AriaStatus.getInstance().setHTML(ARIA.listOfClasses());
                } else {
                    AriaStatus.getInstance().setHTML(ARIA.timetable());
                }
                ResizeEvent.fire((HasResizeHandlers)StudentSectioningWidget.this, (int)StudentSectioningWidget.this.getOffsetWidth(), (int)StudentSectioningWidget.this.getOffsetHeight());
            }
        });
        this.iAssignmentPanelWithFocus = new FocusPanel((Widget)this.iAssignmentPanel);
        this.iAssignmentPanelWithFocus.setStyleName("unitime-FocusPanel");
        this.iRequests.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentSectioningWidget.this.prev();
                StudentSectioningWidget.this.addHistory();
            }
        });
        this.iReset.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentSectioningWidget.this.clearMessage();
                LoadingWidget.getInstance().show(MESSAGES.courseRequestsScheduling());
                StudentSectioningWidget.this.iSectioningService.section(StudentSectioningWidget.this.iOnline, StudentSectioningWidget.this.iCourseRequests.getRequest(), null, new AsyncCallback<ClassAssignmentInterface>(){

                    public void onFailure(Throwable caught) {
                        StudentSectioningWidget.this.setError(MESSAGES.exceptionSectioningFailed(caught.getMessage()), caught);
                        LoadingWidget.getInstance().hide();
                        StudentSectioningWidget.this.updateHistory();
                    }

                    public void onSuccess(ClassAssignmentInterface result) {
                        StudentSectioningWidget.this.fillIn(result);
                        StudentSectioningWidget.this.addHistory();
                    }
                });
            }
        });
        this.iSchedule.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentSectioningWidget.this.iCourseRequests.changeTip();
                StudentSectioningWidget.this.clearMessage();
                StudentSectioningWidget.this.iCourseRequests.validate(new AsyncCallback<Boolean>(){

                    public void onSuccess(Boolean result) {
                        StudentSectioningWidget.this.updateHistory();
                        if (result.booleanValue()) {
                            if (StudentSectioningWidget.this.iOnline) {
                                StudentSectioningWidget.this.iSectioningService.saveRequest(StudentSectioningWidget.this.iCourseRequests.getRequest(), new AsyncCallback<Boolean>(){

                                    public void onSuccess(Boolean result) {
                                        if (result.booleanValue()) {
                                            StudentSectioningWidget.this.setMessage(MESSAGES.saveRequestsOK());
                                        }
                                    }

                                    public void onFailure(Throwable caught) {
                                        StudentSectioningWidget.this.setError(MESSAGES.saveRequestsFail(caught.getMessage()), caught);
                                    }
                                });
                            }
                            LoadingWidget.getInstance().show(MESSAGES.courseRequestsScheduling());
                            StudentSectioningWidget.this.iSectioningService.section(StudentSectioningWidget.this.iOnline, StudentSectioningWidget.this.iCourseRequests.getRequest(), StudentSectioningWidget.this.iLastResult, new AsyncCallback<ClassAssignmentInterface>(){

                                public void onFailure(Throwable caught) {
                                    StudentSectioningWidget.this.setError(MESSAGES.exceptionSectioningFailed(caught.getMessage()), caught);
                                    LoadingWidget.getInstance().hide();
                                    StudentSectioningWidget.this.updateHistory();
                                }

                                public void onSuccess(ClassAssignmentInterface result) {
                                    StudentSectioningWidget.this.fillIn(result);
                                    StudentSectioningWidget.this.addHistory();
                                }
                            });
                        } else {
                            String error = StudentSectioningWidget.this.iCourseRequests.getFirstError();
                            StudentSectioningWidget.this.setError(error == null ? MESSAGES.validationFailed() : MESSAGES.validationFailedWithMessage(error));
                            LoadingWidget.getInstance().hide();
                            StudentSectioningWidget.this.updateHistory();
                        }
                    }

                    public void onFailure(Throwable caught) {
                        StudentSectioningWidget.this.setError(MESSAGES.validationFailedWithMessage(caught.getMessage()), caught);
                        LoadingWidget.getInstance().hide();
                        StudentSectioningWidget.this.updateHistory();
                    }
                });
            }
        });
        this.iStartOver.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentSectioningWidget.this.clearMessage();
                StudentSectioningWidget.this.clear();
                StudentSectioningWidget.this.addHistory();
                StudentSectioningWidget.this.lastRequest(StudentSectioningWidget.this.iSessionSelector.getAcademicSessionId(), null, true);
            }
        });
        this.iAssignmentPanelWithFocus.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 40) {
                    do {
                        StudentSectioningWidget.this.iAssignments.setSelectedRow(StudentSectioningWidget.this.iAssignments.getSelectedRow() + 1);
                    } while (StudentSectioningWidget.this.iAssignments.getRows()[StudentSectioningWidget.this.iAssignments.getSelectedRow()] != null && !StudentSectioningWidget.this.iAssignments.getRows()[StudentSectioningWidget.this.iAssignments.getSelectedRow()].isSelectable());
                    if (StudentSectioningWidget.this.iAssignments.getSelectedRow() >= 0 && StudentSectioningWidget.this.iAssignments.getSelectedRow() < StudentSectioningWidget.this.iAssignments.getRows().length && StudentSectioningWidget.this.iAssignments.getRows()[StudentSectioningWidget.this.iAssignments.getSelectedRow()] != null) {
                        AriaStatus.getInstance().setHTML(ARIA.classSelected(1 + StudentSectioningWidget.this.iAssignments.getSelectedRow(), StudentSectioningWidget.this.iAssignments.getRowsCount(), StudentSectioningWidget.this.iAssignments.getRows()[StudentSectioningWidget.this.iAssignments.getSelectedRow()].getAriaLabel()));
                    }
                }
                if (event.getNativeKeyCode() == 38) {
                    do {
                        StudentSectioningWidget.this.iAssignments.setSelectedRow(StudentSectioningWidget.this.iAssignments.getSelectedRow() == 0 ? StudentSectioningWidget.this.iAssignments.getRowsCount() - 1 : StudentSectioningWidget.this.iAssignments.getSelectedRow() - 1);
                    } while (StudentSectioningWidget.this.iAssignments.getRows()[StudentSectioningWidget.this.iAssignments.getSelectedRow()] != null && !StudentSectioningWidget.this.iAssignments.getRows()[StudentSectioningWidget.this.iAssignments.getSelectedRow()].isSelectable());
                    if (StudentSectioningWidget.this.iAssignments.getSelectedRow() >= 0 && StudentSectioningWidget.this.iAssignments.getSelectedRow() < StudentSectioningWidget.this.iAssignments.getRows().length && StudentSectioningWidget.this.iAssignments.getRows()[StudentSectioningWidget.this.iAssignments.getSelectedRow()] != null) {
                        AriaStatus.getInstance().setHTML(ARIA.classSelected(1 + StudentSectioningWidget.this.iAssignments.getSelectedRow(), StudentSectioningWidget.this.iAssignments.getRowsCount(), StudentSectioningWidget.this.iAssignments.getRows()[StudentSectioningWidget.this.iAssignments.getSelectedRow()].getAriaLabel()));
                    }
                }
                if (event.getNativeKeyCode() == 13) {
                    StudentSectioningWidget.this.updateHistory();
                    StudentSectioningWidget.this.showSuggestionsAsync(StudentSectioningWidget.this.iAssignments.getSelectedRow());
                }
                if (event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == 108 || event.getNativeKeyCode() == 76)) {
                    StudentSectioningWidget.this.iAssignmentPanel.selectTab(0);
                    event.preventDefault();
                }
                if (event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == 116 || event.getNativeKeyCode() == 84)) {
                    StudentSectioningWidget.this.iAssignmentPanel.selectTab(1);
                    event.preventDefault();
                }
            }
        });
        this.iAssignments.addRowClickHandler(new WebTable.RowClickHandler(){

            public void onRowClick(WebTable.RowClickEvent event) {
                if (StudentSectioningWidget.this.iLastResult.get(event.getRowIdx()) == null) {
                    return;
                }
                StudentSectioningWidget.this.updateHistory();
                StudentSectioningWidget.this.showSuggestionsAsync(event.getRowIdx());
            }
        });
        this.iAssignmentGrid.addMeetingClickHandler(new TimeGrid.MeetingClickHandler(){

            public void onMeetingClick(TimeGrid.MeetingClickEvent event) {
                StudentSectioningWidget.this.updateHistory();
                StudentSectioningWidget.this.showSuggestionsAsync(event.getRowIndex());
            }
        });
        this.iAssignmentGrid.addPinClickHandler(new TimeGrid.PinClickHandler(){

            public void onPinClick(TimeGrid.PinClickEvent event) {
                ((CheckBox)StudentSectioningWidget.this.iAssignments.getRows()[event.getRowIndex()].getCell(0).getWidget()).setValue(Boolean.valueOf(event.isPinChecked()));
                ((ClassAssignmentInterface.ClassAssignment)StudentSectioningWidget.this.iLastResult.get(event.getRowIndex())).setPinned(event.isPinChecked());
                StudentSectioningWidget.this.updateHistory();
            }
        });
        this.iEnroll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentSectioningWidget.this.clearMessage();
                LoadingWidget.getInstance().show(MESSAGES.waitEnroll());
                StudentSectioningWidget.this.iSectioningService.enroll(StudentSectioningWidget.this.iCourseRequests.getRequest(), StudentSectioningWidget.this.iLastResult, new AsyncCallback<ClassAssignmentInterface>(){

                    public void onSuccess(ClassAssignmentInterface result) {
                        LoadingWidget.getInstance().hide();
                        StudentSectioningWidget.this.iSavedAssignment = result;
                        StudentSectioningWidget.this.fillIn(result);
                        if (result.hasRequest()) {
                            StudentSectioningWidget.this.iCourseRequests.setRequest(result.getRequest());
                        }
                        if (!result.hasMessages()) {
                            StudentSectioningWidget.this.setMessage(MESSAGES.enrollOK());
                        }
                        StudentSectioningWidget.this.updateHistory();
                    }

                    public void onFailure(Throwable caught) {
                        OnlineSectioningInterface.EligibilityCheck check;
                        LoadingWidget.getInstance().hide();
                        StudentSectioningWidget.this.setError(MESSAGES.enrollFailed(caught.getMessage()), caught);
                        StudentSectioningWidget.this.updateHistory();
                        if (caught instanceof SectioningException && (check = ((SectioningException)caught).getEligibilityCheck()) != null) {
                            StudentSectioningWidget.this.setElibibilityCheckDuringEnrollment(check);
                            if (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED)) {
                                if (StudentSectioningWidget.this.iPinDialog == null) {
                                    StudentSectioningWidget.this.iPinDialog = new PinDialog();
                                }
                                PinDialog.PinCallback callback = new PinDialog.PinCallback(){

                                    public void onFailure(Throwable caught) {
                                        StudentSectioningWidget.this.setError(MESSAGES.exceptionFailedEligibilityCheck(caught.getMessage()), caught);
                                    }

                                    public void onSuccess(OnlineSectioningInterface.EligibilityCheck result) {
                                        StudentSectioningWidget.this.setElibibilityCheckDuringEnrollment(result);
                                        if (result.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL) && !result.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT)) {
                                            StudentSectioningWidget.this.iEnroll.click();
                                        }
                                    }

                                    public void onMessage(OnlineSectioningInterface.EligibilityCheck result) {
                                        if (result.hasMessage()) {
                                            StudentSectioningWidget.this.setError(result.getMessage());
                                        } else if (result.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED)) {
                                            StudentSectioningWidget.this.setWarning(MESSAGES.exceptionAuthenticationPinRequired());
                                        } else {
                                            StudentSectioningWidget.this.clearMessage(false);
                                        }
                                    }
                                };
                                StudentSectioningWidget.this.iPinDialog.checkEligibility(StudentSectioningWidget.this.iOnline, StudentSectioningWidget.this.iSessionSelector.getAcademicSessionId(), null, callback);
                            }
                        }
                    }
                });
            }
        });
        this.iPrint.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean allSaved = true;
                for (ClassAssignmentInterface.ClassAssignment clazz : StudentSectioningWidget.this.iLastResult) {
                    if (clazz == null || clazz.isFreeTime() || clazz.isSaved()) continue;
                    allSaved = false;
                }
                Widget w = StudentSectioningWidget.this.iAssignments.getPrintWidget(0, 5, 15);
                w.setWidth("100%");
                ToolBox.print(allSaved && !StudentSectioningWidget.this.isChanged() ? MESSAGES.studentSchedule() : MESSAGES.studentScheduleNotEnrolled(), CONSTANTS.printReportShowUserName() ? StudentSectioningWidget.this.iUserAuthentication.getUser() : "", StudentSectioningWidget.this.iSessionSelector.getAcademicSessionName(), new Widget[]{StudentSectioningWidget.this.iAssignmentGrid.getPrintWidget(), w, StudentSectioningWidget.this.iMessage});
            }
        });
        if (this.iExport != null) {
            this.iExport.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ToolBox.open(StudentSectioningWidget.this.iCalendar.getUrl());
                }
            });
        }
        if (this.iTrackHistory) {
            History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (!((String)event.getValue()).isEmpty()) {
                        int item = StudentSectioningWidget.this.iHistory.size() - 1;
                        try {
                            item = Integer.parseInt((String)event.getValue());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (item < 0) {
                            item = 0;
                        }
                        if (item >= StudentSectioningWidget.this.iHistory.size()) {
                            item = StudentSectioningWidget.this.iHistory.size() - 1;
                        }
                        if (item >= 0) {
                            ((HistoryItem)StudentSectioningWidget.this.iHistory.get(item)).restore();
                        }
                    } else if (StudentSectioningWidget.this.isChanged() && Window.confirm((String)MESSAGES.queryLeaveChanges())) {
                        StudentSectioningWidget.this.iCourseRequests.clear();
                        if (!StudentSectioningWidget.this.iSchedule.isVisible()) {
                            StudentSectioningWidget.this.prev();
                        }
                    }
                }
            });
        }
        this.iSessionSelector.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                StudentSectioningWidget.this.addHistory();
            }
        });
        this.iSave.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                StudentSectioningWidget.this.iCourseRequests.changeTip();
                StudentSectioningWidget.this.clearMessage();
                StudentSectioningWidget.this.iCourseRequests.validate(new AsyncCallback<Boolean>(){

                    public void onSuccess(Boolean result) {
                        StudentSectioningWidget.this.updateHistory();
                        if (result.booleanValue()) {
                            LoadingWidget.getInstance().show(MESSAGES.courseRequestsSaving());
                            StudentSectioningWidget.this.iSectioningService.saveRequest(StudentSectioningWidget.this.iCourseRequests.getRequest(), new AsyncCallback<Boolean>(){

                                public void onSuccess(Boolean result) {
                                    if (result.booleanValue()) {
                                        StudentSectioningWidget.this.setMessage(MESSAGES.saveRequestsOK());
                                    }
                                    LoadingWidget.getInstance().hide();
                                }

                                public void onFailure(Throwable caught) {
                                    StudentSectioningWidget.this.setError(MESSAGES.saveRequestsFail(caught.getMessage()), caught);
                                    LoadingWidget.getInstance().hide();
                                }
                            });
                        } else {
                            String error = StudentSectioningWidget.this.iCourseRequests.getFirstError();
                            StudentSectioningWidget.this.setError(error == null ? MESSAGES.validationFailed() : MESSAGES.validationFailedWithMessage(error));
                            LoadingWidget.getInstance().hide();
                            StudentSectioningWidget.this.updateHistory();
                        }
                    }

                    public void onFailure(Throwable caught) {
                        StudentSectioningWidget.this.setError(MESSAGES.validationFailedWithMessage(caught.getMessage()), caught);
                        LoadingWidget.getInstance().hide();
                        StudentSectioningWidget.this.updateHistory();
                    }
                });
            }
        });
        this.iShowUnassignments.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                Cookies.setCookie((String)"UniTime:Unassignments", (String)"1");
                StudentSectioningWidget.this.fillIn(StudentSectioningWidget.this.iLastAssignment);
            }
        });
    }

    public void openSuggestionsBox(int rowIndex) {
        if (this.iSuggestionsBox == null) {
            this.iSuggestionsBox = new SuggestionsBox(this.iAssignmentGrid.getColorProvider(), this.iOnline);
            this.iSuggestionsBox.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                public void onClose(CloseEvent<PopupPanel> event) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            StudentSectioningWidget.this.iAssignmentPanelWithFocus.setFocus(true);
                        }
                    });
                }
            });
            this.iSuggestionsBox.addSuggestionSelectedHandler(new SuggestionsBox.SuggestionSelectedHandler(){

                public void onSuggestionSelected(SuggestionsBox.SuggestionSelectedEvent event) {
                    ClassAssignmentInterface result = event.getSuggestion();
                    StudentSectioningWidget.this.clearMessage();
                    StudentSectioningWidget.this.fillIn(result);
                    StudentSectioningWidget.this.addHistory();
                }
            });
        }
        this.iAssignments.setSelectedRow(rowIndex);
        this.clearMessage();
        this.iSuggestionsBox.open(this.iCourseRequests.getRequest(), this.iLastResult, rowIndex);
    }

    /*
     * WARNING - void declaration
     */
    private void fillIn(ClassAssignmentInterface result) {
        this.iLastResult.clear();
        this.iLastAssignment = result;
        String calendarUrl = GWT.getHostPageBaseURL() + "calendar?sid=" + this.iSessionSelector.getAcademicSessionId() + "&cid=";
        String ftParam = "&ft=";
        boolean hasError = false;
        float totalCredit = 0.0f;
        if (!result.getCourseAssignments().isEmpty() || CONSTANTS.allowEmptySchedule()) {
            WebTable.IconsCell icons;
            WebTable.Row row;
            String style;
            ArrayList<Object> rows = new ArrayList<Object>();
            this.iAssignmentGrid.clear(true);
            for (final ClassAssignmentInterface.CourseAssignment course : result.getCourseAssignments()) {
                int n;
                Object finalRow;
                if (course.isAssigned()) {
                    boolean firstClazz = true;
                    for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                        if (clazz.getClassId() != null) {
                            calendarUrl = calendarUrl + clazz.getCourseId() + "-" + clazz.getClassId() + ",";
                        } else if (clazz.isFreeTime()) {
                            ftParam = ftParam + clazz.getDaysString(CONSTANTS.shortDays()) + "-" + clazz.getStart() + "-" + clazz.getLength() + ",";
                        }
                        style = firstClazz && !rows.isEmpty() ? "top-border-dashed" : "";
                        row = null;
                        icons = new WebTable.IconsCell();
                        if (clazz.isSaved()) {
                            icons.add(RESOURCES.saved(), MESSAGES.saved(course.getSubject() + " " + course.getCourseNbr() + " " + clazz.getSubpart() + " " + clazz.getSection()));
                        } else if (clazz.isDummy()) {
                            icons.add(RESOURCES.unassignment(), MESSAGES.unassignment(course.getSubject() + " " + course.getCourseNbr() + " " + clazz.getSubpart() + " " + clazz.getSection()));
                        } else if (!clazz.isFreeTime() && result.isCanEnroll()) {
                            icons.add(RESOURCES.assignment(), MESSAGES.assignment(course.getSubject() + " " + course.getCourseNbr() + " " + clazz.getSubpart() + " " + clazz.getSection()));
                        }
                        if (clazz.hasError()) {
                            icons.add(RESOURCES.error(), clazz.getError());
                            style = style + " text-red";
                            hasError = true;
                        }
                        if (course.isLocked()) {
                            icons.add(RESOURCES.courseLocked(), MESSAGES.courseLocked(course.getSubject() + " " + course.getCourseNbr()));
                        }
                        if (clazz.isOfHighDemand()) {
                            icons.add(RESOURCES.highDemand(), MESSAGES.highDemand(clazz.getExpected(), clazz.getAvailableLimit()));
                        }
                        if (clazz != null && clazz.hasOverlapNote()) {
                            icons.add(RESOURCES.overlap(), clazz.getOverlapNote());
                        }
                        totalCredit += clazz.guessCreditCount();
                        if (clazz.isAssigned()) {
                            WebTable.Cell[] cellArray = new WebTable.Cell[16];
                            WebTable.Cell cell = clazz.isDummy() ? new WebTable.Cell(null) : (cellArray[0] = new WebTable.CheckboxCell(clazz.isPinned(), course.isFreeTime() ? ARIA.freeTimePin(clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours())) : ARIA.classPin(MESSAGES.clazz(course.getSubject(), course.getCourseNbr(), clazz.getSubpart(), clazz.getSection())), MESSAGES.hintLocked(), MESSAGES.hintUnlocked()));
                            cellArray[1] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()) : "").aria(firstClazz ? "" : (course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()));
                            cellArray[2] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()) : "").aria(firstClazz ? "" : (course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()));
                            cellArray[3] = new WebTable.Cell(clazz.getSubpart());
                            cellArray[4] = new WebTable.Cell(clazz.getSection());
                            cellArray[5] = new WebTable.Cell(clazz.getLimitString());
                            cellArray[6] = new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())).aria(clazz.getDaysString(CONSTANTS.longDays(), " "));
                            cellArray[7] = new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())).aria(clazz.getStartStringAria(CONSTANTS.useAmPm()));
                            cellArray[8] = new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())).aria(clazz.getEndStringAria(CONSTANTS.useAmPm()));
                            cellArray[9] = new WebTable.Cell(clazz.getDatePattern());
                            cellArray[10] = clazz.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(", ")) : new WebTable.Cell(clazz.getRooms(", "));
                            cellArray[11] = new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", ");
                            cellArray[12] = new WebTable.Cell(clazz.getParentSection(), clazz.getParentSection() == null || clazz.getParentSection().length() > 10);
                            cellArray[13] = new WebTable.NoteCell(clazz.getOverlapAndNote("text-red"), clazz.getOverlapAndNote(null));
                            cellArray[14] = new WebTable.AbbvTextCell(clazz.getCredit());
                            cellArray[15] = icons;
                            row = new WebTable.Row(cellArray);
                        } else {
                            WebTable.Cell[] cellArray = new WebTable.Cell[13];
                            WebTable.Cell cell = clazz.isDummy() ? new WebTable.Cell(null) : (cellArray[0] = new WebTable.CheckboxCell(clazz.isPinned(), course.isFreeTime() ? ARIA.freeTimePin(clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours())) : ARIA.classPin(MESSAGES.clazz(course.getSubject(), course.getCourseNbr(), clazz.getSubpart(), clazz.getSection())), MESSAGES.hintLocked(), MESSAGES.hintUnlocked()));
                            cellArray[1] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()) : "");
                            cellArray[2] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()) : "");
                            cellArray[3] = new WebTable.Cell(clazz.getSubpart());
                            cellArray[4] = new WebTable.Cell(clazz.getSection());
                            cellArray[5] = new WebTable.Cell(clazz.getLimitString());
                            cellArray[6] = new WebTable.Cell(MESSAGES.arrangeHours(), 4, null);
                            cellArray[7] = clazz.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(", ")) : new WebTable.Cell(clazz.getRooms(", "));
                            cellArray[8] = new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", ");
                            cellArray[9] = new WebTable.Cell(clazz.getParentSection(), clazz.getParentSection() == null || clazz.getParentSection().length() > 10);
                            cellArray[10] = new WebTable.NoteCell(clazz.getOverlapAndNote("text-red"), clazz.getOverlapAndNote(null));
                            cellArray[11] = new WebTable.AbbvTextCell(clazz.getCredit());
                            cellArray[12] = icons;
                            row = new WebTable.Row(cellArray);
                        }
                        if (course.isFreeTime()) {
                            row.setAriaLabel(ARIA.freeTimeAssignment(clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours())));
                        } else {
                            row.setAriaLabel(ARIA.classAssignment(MESSAGES.clazz(course.getSubject(), course.getCourseNbr(), clazz.getSubpart(), clazz.getSection()), clazz.isAssigned() ? clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + clazz.getRooms(",") : ARIA.arrangeHours()));
                        }
                        finalRow = row;
                        ArrayList<TimeGrid.Meeting> meetings = clazz.isFreeTime() ? null : this.iAssignmentGrid.addClass(clazz, rows.size());
                        int index = rows.size();
                        if (!clazz.isDummy()) {
                            ((CheckBox)row.getCell(0).getWidget()).addClickHandler(new ClickHandler((WebTable.Row)finalRow, meetings, index){
                                final /* synthetic */ WebTable.Row val$finalRow;
                                final /* synthetic */ ArrayList val$meetings;
                                final /* synthetic */ int val$index;
                                {
                                    this.val$finalRow = row;
                                    this.val$meetings = arrayList;
                                    this.val$index = n;
                                }

                                public void onClick(ClickEvent event) {
                                    Boolean checked = Boolean.valueOf(this.val$finalRow.getCell(0).getValue());
                                    if (this.val$meetings == null) {
                                        ((ClassAssignmentInterface.ClassAssignment)StudentSectioningWidget.this.iLastResult.get(this.val$index)).setPinned(checked);
                                    } else {
                                        for (TimeGrid.Meeting m : this.val$meetings) {
                                            m.setPinned(checked);
                                            ((ClassAssignmentInterface.ClassAssignment)StudentSectioningWidget.this.iLastResult.get(m.getIndex())).setPinned(checked);
                                        }
                                    }
                                }
                            });
                        }
                        rows.add(row);
                        this.iLastResult.add(clazz.isDummy() ? null : clazz);
                        for (WebTable.Cell cell : row.getCells()) {
                            cell.setStyleName(style);
                        }
                        firstClazz = false;
                    }
                } else {
                    void var10_28;
                    void var10_24;
                    String style2 = "text-red" + (!rows.isEmpty() ? " top-border-dashed" : "");
                    Object var10_19 = null;
                    Object unassignedMessage = MESSAGES.courseNotAssigned();
                    if (course.hasEnrollmentMessage()) {
                        unassignedMessage = course.getEnrollmentMessage();
                    } else if (course.getNote() != null) {
                        unassignedMessage = course.getNote();
                    } else if (course.getOverlaps() != null && !course.getOverlaps().isEmpty()) {
                        unassignedMessage = "";
                        Iterator<String> i = course.getOverlaps().iterator();
                        while (i.hasNext()) {
                            String x = i.next();
                            if (((String)unassignedMessage).isEmpty()) {
                                unassignedMessage = (String)unassignedMessage + MESSAGES.conflictWithFirst(x);
                                continue;
                            }
                            if (!i.hasNext()) {
                                unassignedMessage = (String)unassignedMessage + MESSAGES.conflictWithLast(x);
                                continue;
                            }
                            unassignedMessage = (String)unassignedMessage + MESSAGES.conflictWithMiddle(x);
                        }
                        if (course.getInstead() != null) {
                            unassignedMessage = (String)unassignedMessage + MESSAGES.conflictAssignedAlternative(course.getInstead());
                        }
                        unassignedMessage = (String)unassignedMessage + ".";
                    } else if (course.isNotAvailable()) {
                        unassignedMessage = MESSAGES.classNotAvailable();
                    } else if (course.isLocked()) {
                        unassignedMessage = MESSAGES.courseLocked(course.getSubject() + " " + course.getCourseNbr());
                    }
                    WebTable.IconsCell icons2 = new WebTable.IconsCell();
                    if (course.isLocked()) {
                        icons2.add(RESOURCES.courseLocked(), course.getNote() != null ? course.getNote() : MESSAGES.courseLocked(course.getSubject() + " " + course.getCourseNbr()));
                    }
                    Object waitList = null;
                    Boolean w = this.iCourseRequests.getWaitList(course.getCourseName());
                    if (w != null) {
                        waitList = new WebTable.CheckboxCell(w, MESSAGES.toggleWaitList(), ARIA.titleRequestedWaitListForCourse(MESSAGES.course(course.getSubject(), course.getCourseNbr())));
                        ((WebTable.CheckboxCell)waitList).getWidget().setStyleName("toggle");
                        ((CheckBox)((WebTable.CheckboxCell)waitList).getWidget()).addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                            public void onValueChange(ValueChangeEvent<Boolean> event) {
                                StudentSectioningWidget.this.clearMessage();
                                StudentSectioningWidget.this.iCourseRequests.setWaitList(course.getCourseName(), (Boolean)event.getValue());
                                LoadingWidget.getInstance().show(MESSAGES.courseRequestsScheduling());
                                CourseRequestInterface r = StudentSectioningWidget.this.iCourseRequests.getRequest();
                                r.setNoChange(true);
                                StudentSectioningWidget.this.iSectioningService.section(StudentSectioningWidget.this.iOnline, r, StudentSectioningWidget.this.iLastResult, new AsyncCallback<ClassAssignmentInterface>(){

                                    public void onFailure(Throwable caught) {
                                        StudentSectioningWidget.this.setError(MESSAGES.exceptionSectioningFailed(caught.getMessage()), caught);
                                        LoadingWidget.getInstance().hide();
                                        StudentSectioningWidget.this.updateHistory();
                                    }

                                    public void onSuccess(ClassAssignmentInterface result) {
                                        StudentSectioningWidget.this.fillIn(result);
                                        StudentSectioningWidget.this.addHistory();
                                    }
                                });
                            }
                        });
                    }
                    if ((finalRow = course.getClassAssignments().iterator()).hasNext()) {
                        void var10_23;
                        ClassAssignmentInterface.ClassAssignment clazz = finalRow.next();
                        if (clazz.isAssigned()) {
                            WebTable.Row row2 = new WebTable.Row(new WebTable.Cell[]{new WebTable.Cell(null), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())).aria(clazz.getDaysString(CONSTANTS.longDays(), " ")), new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())).aria(clazz.getStartStringAria(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())).aria(clazz.getEndStringAria(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getDatePattern()), new WebTable.Cell((String)unassignedMessage, 3, null), new WebTable.NoteCell(clazz.getOverlapAndNote("text-red"), clazz.getOverlapAndNote(null)), waitList != null ? waitList : new WebTable.AbbvTextCell(clazz.getCredit()), icons2});
                            if (course.isFreeTime()) {
                                row2.setAriaLabel(ARIA.freeTimeUnassignment(clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()), (String)unassignedMessage));
                            } else {
                                row2.setAriaLabel(ARIA.courseUnassginment(MESSAGES.course(course.getSubject(), course.getCourseNbr()), (String)unassignedMessage));
                            }
                        } else if (clazz.getClassId() != null) {
                            WebTable.Row row3 = new WebTable.Row(new WebTable.Cell[]{new WebTable.Cell(null), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(MESSAGES.arrangeHours(), 4, null), new WebTable.Cell((String)unassignedMessage, 3, null), new WebTable.NoteCell(clazz.getOverlapAndNote("text-red"), clazz.getOverlapAndNote(null)), waitList != null ? waitList : new WebTable.AbbvTextCell(clazz.getCredit()), icons2});
                            if (course.isFreeTime()) {
                                row3.setAriaLabel(ARIA.freeTimeUnassignment("", (String)unassignedMessage));
                            } else {
                                row3.setAriaLabel(ARIA.courseUnassginment(MESSAGES.course(course.getSubject(), course.getCourseNbr()), (String)unassignedMessage));
                            }
                        } else {
                            WebTable.Row row4 = new WebTable.Row(new WebTable.Cell[]{new WebTable.Cell(null), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell((String)unassignedMessage, 7, null), new WebTable.NoteCell(clazz.getOverlapAndNote("text-red"), clazz.getOverlapAndNote(null)), waitList != null ? waitList : new WebTable.AbbvTextCell(clazz.getCredit()), icons2});
                            if (course.isFreeTime()) {
                                row4.setAriaLabel(ARIA.freeTimeUnassignment("", (String)unassignedMessage));
                            } else {
                                row4.setAriaLabel(ARIA.courseUnassginment(MESSAGES.course(course.getSubject(), course.getCourseNbr()), (String)unassignedMessage));
                            }
                        }
                        var10_23.setId(course.isFreeTime() ? CONSTANTS.freePrefix() + clazz.getDaysString(CONSTANTS.shortDays()) + " " + clazz.getStartString(CONSTANTS.useAmPm()) + " - " + clazz.getEndString(CONSTANTS.useAmPm()) : course.getCourseId() + ":" + clazz.getClassId());
                        this.iLastResult.add(clazz.isDummy() ? null : clazz);
                    }
                    if (var10_24 == null) {
                        void var10_27;
                        if (waitList != null) {
                            WebTable.Row row5 = new WebTable.Row(new WebTable.Cell[]{new WebTable.Cell(null), new WebTable.Cell(course.getSubject()), new WebTable.Cell(course.getCourseNbr()), new WebTable.Cell((String)unassignedMessage, 11, null), waitList, icons2});
                        } else {
                            WebTable.Row row6 = new WebTable.Row(new WebTable.Cell(null), new WebTable.Cell(course.getSubject()), new WebTable.Cell(course.getCourseNbr()), new WebTable.Cell((String)unassignedMessage, 12, null), icons2);
                        }
                        var10_27.setId(course.getCourseId().toString());
                        var10_27.setAriaLabel(ARIA.courseUnassginment(MESSAGES.course(course.getSubject(), course.getCourseNbr()), (String)unassignedMessage));
                        this.iLastResult.add(course.addClassAssignment());
                    }
                    finalRow = var10_28.getCells();
                    int n2 = ((WebTable.Cell[])finalRow).length;
                    for (n = 0; n < n2; ++n) {
                        WebTable.Cell cell = finalRow[n];
                        cell.setStyleName(style2);
                    }
                    var10_28.getCell(var10_28.getNrCells() - 1).setStyleName("text-red-centered" + (!rows.isEmpty() ? " top-border-dashed" : ""));
                    rows.add(var10_28);
                }
                if (this.iSavedAssignment == null || course.isFreeTime() || !this.iShowUnassignments.getValue().booleanValue()) continue;
                for (ClassAssignmentInterface.CourseAssignment courseAssignment : this.iSavedAssignment.getCourseAssignments()) {
                    if (!courseAssignment.isAssigned() || courseAssignment.isFreeTime() || !course.getCourseId().equals(courseAssignment.getCourseId())) continue;
                    block6: for (ClassAssignmentInterface.ClassAssignment clazz : courseAssignment.getClassAssignments()) {
                        for (ClassAssignmentInterface.ClassAssignment x : course.getClassAssignments()) {
                            if (!clazz.getClassId().equals(x.getClassId())) continue;
                            continue block6;
                        }
                        String style3 = "text-gray";
                        WebTable.Row row3 = null;
                        WebTable.IconsCell icons3 = new WebTable.IconsCell();
                        if (clazz.hasError()) {
                            icons3.add(RESOURCES.error(), clazz.getError());
                        }
                        if (clazz.isSaved()) {
                            icons3.add(RESOURCES.unassignment(), MESSAGES.unassignment(course.getSubject() + " " + course.getCourseNbr() + " " + clazz.getSubpart() + " " + clazz.getSection()));
                        }
                        if (clazz.isOfHighDemand()) {
                            icons3.add(RESOURCES.highDemand(), MESSAGES.highDemand(clazz.getExpected(), clazz.getAvailableLimit()));
                        }
                        row3 = clazz.isAssigned() ? new WebTable.Row(new WebTable.Cell(null), new WebTable.Cell("").aria(course.getSubject()), new WebTable.Cell("").aria(course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())).aria(clazz.getDaysString(CONSTANTS.longDays(), " ")), new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())).aria(clazz.getStartStringAria(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())).aria(clazz.getEndStringAria(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getDatePattern()), clazz.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(", ")) : new WebTable.Cell(clazz.getRooms(", ")), new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", "), new WebTable.Cell(clazz.getParentSection(), clazz.getParentSection() == null || clazz.getParentSection().length() > 10), new WebTable.NoteCell(clazz.getOverlapAndNote("text-red"), clazz.getOverlapAndNote(null)), new WebTable.AbbvTextCell(clazz.getCredit()), icons3) : new WebTable.Row(new WebTable.Cell(null), new WebTable.Cell("").aria(course.getSubject()), new WebTable.Cell("").aria(course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(MESSAGES.arrangeHours(), 4, null), clazz.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(", ")) : new WebTable.Cell(clazz.getRooms(", ")), new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", "), new WebTable.Cell(clazz.getParentSection(), clazz.getParentSection() == null || clazz.getParentSection().length() > 10), new WebTable.NoteCell(clazz.getOverlapAndNote("text-red"), clazz.getOverlapAndNote(null)), new WebTable.AbbvTextCell(clazz.getCredit()), icons3);
                        row3.setAriaLabel(ARIA.previousAssignment(MESSAGES.clazz(course.getSubject(), course.getCourseNbr(), clazz.getSubpart(), clazz.getSection()), clazz.isAssigned() ? clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + clazz.getRooms(",") : ARIA.arrangeHours()));
                        rows.add(row3);
                        row3.setSelectable(false);
                        this.iLastResult.add(null);
                        WebTable.Cell[] cellArray = row3.getCells();
                        n = cellArray.length;
                        for (int cell = 0; cell < n; ++cell) {
                            WebTable.Cell cell2 = cellArray[cell];
                            cell2.setStyleName(style3);
                        }
                    }
                }
            }
            if (this.iSavedAssignment != null && this.iShowUnassignments.getValue().booleanValue()) {
                block9: for (final ClassAssignmentInterface.CourseAssignment course : this.iSavedAssignment.getCourseAssignments()) {
                    if (!course.isAssigned() || course.isFreeTime()) continue;
                    for (ClassAssignmentInterface.CourseAssignment courseAssignment : result.getCourseAssignments()) {
                        if (!course.getCourseId().equals(courseAssignment.getCourseId())) continue;
                        continue block9;
                    }
                    boolean firstClazz = true;
                    for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                        style = "text-gray" + (firstClazz && !rows.isEmpty() ? " top-border-dashed" : "");
                        row = null;
                        icons = new WebTable.IconsCell();
                        if (clazz.hasError()) {
                            icons.add(RESOURCES.error(), clazz.getError());
                        }
                        if (clazz.isSaved()) {
                            icons.add(RESOURCES.unassignment(), MESSAGES.unassignment(course.getSubject() + " " + course.getCourseNbr() + " " + clazz.getSubpart() + " " + clazz.getSection()));
                        }
                        if (clazz.isOfHighDemand()) {
                            icons.add(RESOURCES.highDemand(), MESSAGES.highDemand(clazz.getExpected(), clazz.getAvailableLimit()));
                        }
                        row = clazz.isAssigned() ? new WebTable.Row(new WebTable.Cell(null), new WebTable.Cell(firstClazz ? course.getSubject() : "").aria(firstClazz ? "" : course.getSubject()), new WebTable.Cell(firstClazz ? course.getCourseNbr() : "").aria(firstClazz ? "" : course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())).aria(clazz.getDaysString(CONSTANTS.longDays(), " ")), new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())).aria(clazz.getStartStringAria(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())).aria(clazz.getEndStringAria(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getDatePattern()), clazz.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(", ")) : new WebTable.Cell(clazz.getRooms(", ")), new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", "), new WebTable.Cell(clazz.getParentSection(), clazz.getParentSection() == null || clazz.getParentSection().length() > 10), new WebTable.NoteCell(clazz.getOverlapAndNote("text-red"), clazz.getOverlapAndNote(null)), new WebTable.AbbvTextCell(clazz.getCredit()), icons) : new WebTable.Row(new WebTable.Cell(null), new WebTable.Cell(firstClazz ? course.getSubject() : "").aria(firstClazz ? "" : course.getSubject()), new WebTable.Cell(firstClazz ? course.getCourseNbr() : "").aria(firstClazz ? "" : course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(MESSAGES.arrangeHours(), 4, null), clazz.hasDistanceConflict() ? new WebTable.IconCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(", ")) : new WebTable.Cell(clazz.getRooms(", ")), new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", "), new WebTable.Cell(clazz.getParentSection(), clazz.getParentSection() == null || clazz.getParentSection().length() > 10), new WebTable.NoteCell(clazz.getOverlapAndNote("text-red"), clazz.getOverlapAndNote(null)), new WebTable.AbbvTextCell(clazz.getCredit()), icons);
                        row.setAriaLabel(ARIA.previousAssignment(MESSAGES.clazz(course.getSubject(), course.getCourseNbr(), clazz.getSubpart(), clazz.getSection()), clazz.isAssigned() ? clazz.getTimeStringAria(CONSTANTS.longDays(), CONSTANTS.useAmPm(), ARIA.arrangeHours()) + " " + clazz.getRooms(",") : ARIA.arrangeHours()));
                        rows.add(row);
                        row.setSelectable(false);
                        this.iLastResult.add(null);
                        for (WebTable.Cell cell : row.getCells()) {
                            cell.setStyleName(style);
                        }
                        firstClazz = false;
                    }
                }
            }
            for (final ClassAssignmentInterface.CourseAssignment course : result.getCourseAssignments()) {
                for (ClassAssignmentInterface.ClassAssignment classAssignment : course.getClassAssignments()) {
                    if (!classAssignment.isFreeTime()) continue;
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setLength(classAssignment.getLength());
                    ft.setStart(classAssignment.getStart());
                    for (int d : classAssignment.getDays()) {
                        ft.addDay(d);
                    }
                    this.iAssignmentGrid.addFreeTime(ft);
                }
            }
            WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
            int idx = 0;
            for (WebTable.Row row7 : rows) {
                rowArray[idx++] = row7;
            }
            this.iAssignmentGrid.shrink();
            this.iAssignmentPanel.setWidth(this.iAssignmentGrid.getWidth() + "px");
            this.iAssignments.setData(rowArray);
            if (LoadingWidget.getInstance().isShowing()) {
                LoadingWidget.getInstance().hide();
            }
            this.iPanel.remove((Widget)this.iCourseRequests);
            this.iPanel.insert((Widget)this.iAssignmentPanelWithFocus, 0);
            this.iRequests.setVisible(true);
            this.iRequests.setEnabled(true);
            this.iReset.setVisible(true);
            this.iReset.setEnabled(true);
            this.iEnroll.setVisible(result.isCanEnroll() && this.iEligibilityCheck != null && this.iEligibilityCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL));
            this.iEnroll.setEnabled(result.isCanEnroll() && this.iEligibilityCheck != null && this.iEligibilityCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL));
            this.iPrint.setVisible(true);
            this.iPrint.setEnabled(true);
            this.iStartOver.setVisible(this.iSavedAssignment != null);
            this.iStartOver.setEnabled(this.iSavedAssignment != null);
            if (this.iExport != null) {
                this.iExport.setVisible(true);
                this.iExport.setEnabled(true);
            }
            this.iSchedule.setVisible(false);
            this.iSchedule.setEnabled(false);
            this.iAssignmentGrid.scrollDown();
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    StudentSectioningWidget.this.iAssignmentPanelWithFocus.setFocus(true);
                }
            });
            if (this.iCalendar != null) {
                if (calendarUrl.endsWith(",")) {
                    calendarUrl = calendarUrl.substring(0, calendarUrl.length() - 1);
                }
                if ((calendarUrl = calendarUrl + ftParam).endsWith(",")) {
                    calendarUrl = calendarUrl.substring(0, calendarUrl.length() - 1);
                }
                this.iAssignmentGrid.setCalendarUrl(calendarUrl);
                this.iCalendar.setUrl(calendarUrl);
            }
            ResizeEvent.fire((HasResizeHandlers)this, (int)this.getOffsetWidth(), (int)this.getOffsetHeight());
            if (this.iAssignmentTab == 0) {
                AriaStatus.getInstance().setHTML(ARIA.listOfClasses());
            } else {
                AriaStatus.getInstance().setHTML(ARIA.timetable());
            }
            if (result.hasMessages()) {
                if (hasError) {
                    this.setError(result.getMessages("<br>"));
                } else {
                    this.setWarning(result.getMessages("<br>"));
                }
            } else {
                this.updateScheduleChangedNoteIfNeeded();
            }
            this.iTotalCredit.setVisible(totalCredit > 0.0f);
            this.iTotalCredit.setText(MESSAGES.totalCredit(totalCredit));
        } else {
            this.iTotalCredit.setVisible(false);
            this.setError(MESSAGES.noSchedule());
            if (LoadingWidget.getInstance().isShowing()) {
                LoadingWidget.getInstance().hide();
            }
        }
    }

    public void prev() {
        this.iPanel.remove((Widget)this.iAssignmentPanelWithFocus);
        this.iPanel.insert((Widget)this.iCourseRequests, 0);
        this.iRequests.setVisible(false);
        this.iRequests.setEnabled(false);
        this.iReset.setVisible(false);
        this.iReset.setEnabled(false);
        this.iEnroll.setVisible(false);
        this.iEnroll.setEnabled(false);
        this.iPrint.setVisible(false);
        this.iPrint.setEnabled(false);
        this.iStartOver.setVisible(false);
        this.iStartOver.setVisible(false);
        if (this.iExport != null) {
            this.iExport.setVisible(false);
            this.iExport.setEnabled(false);
        }
        this.iSchedule.setVisible(true);
        this.iSchedule.setEnabled(true);
        this.clearMessage();
        ResizeEvent.fire((HasResizeHandlers)this, (int)this.getOffsetWidth(), (int)this.getOffsetHeight());
        AriaStatus.getInstance().setHTML(ARIA.courseRequests());
        this.updateScheduleChangedNoteIfNeeded();
    }

    public void clear() {
        if (this.iShowUnassignments != null) {
            this.iShowUnassignments.setVisible(false);
        }
        this.iSavedAssignment = null;
        this.iLastAssignment = null;
        this.iCourseRequests.clear();
        this.iLastResult.clear();
        if (this.iRequests.isVisible()) {
            this.prev();
        }
    }

    public void checkEligibility(final Long sessionId, final Long studentId, final boolean saved, final AsyncCallback<OnlineSectioningInterface.EligibilityCheck> ret) {
        if (!this.iOnline || !this.iMode.isSectioning()) {
            this.lastRequest(sessionId, studentId, saved);
            if (ret != null) {
                ret.onSuccess(null);
            }
            return;
        }
        LoadingWidget.getInstance().show(MESSAGES.courseRequestsLoading());
        this.iStartOver.setVisible(false);
        this.iStartOver.setEnabled(false);
        this.iSectioningService.checkEligibility(this.iOnline, sessionId, studentId, null, new AsyncCallback<OnlineSectioningInterface.EligibilityCheck>(){

            public void onSuccess(OnlineSectioningInterface.EligibilityCheck result) {
                StudentSectioningWidget.this.clearMessage(false);
                StudentSectioningWidget.this.iEligibilityCheck = result;
                StudentSectioningWidget.this.iCourseRequests.setCanWaitList(result.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST));
                if (result.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_USE_ASSISTANT)) {
                    if (result.hasMessage()) {
                        StudentSectioningWidget.this.setWarning(result.getMessage());
                    } else {
                        StudentSectioningWidget.this.clearMessage();
                    }
                    if (result.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED)) {
                        if (StudentSectioningWidget.this.iPinDialog == null) {
                            StudentSectioningWidget.this.iPinDialog = new PinDialog();
                        }
                        LoadingWidget.getInstance().hide();
                        PinDialog.PinCallback callback = new PinDialog.PinCallback(){

                            public void onFailure(Throwable caught) {
                                StudentSectioningWidget.this.setError(MESSAGES.exceptionFailedEligibilityCheck(caught.getMessage()), caught);
                                StudentSectioningWidget.this.iSchedule.setVisible(true);
                                StudentSectioningWidget.this.iSchedule.setEnabled(true);
                                StudentSectioningWidget.this.lastRequest(sessionId, studentId, saved);
                                if (ret != null) {
                                    ret.onSuccess((Object)StudentSectioningWidget.this.iEligibilityCheck);
                                }
                            }

                            public void onSuccess(OnlineSectioningInterface.EligibilityCheck result) {
                                StudentSectioningWidget.this.iCourseRequests.setCanWaitList(result.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST));
                                StudentSectioningWidget.this.iEligibilityCheck = result;
                                StudentSectioningWidget.this.iSchedule.setVisible(true);
                                StudentSectioningWidget.this.iSchedule.setEnabled(true);
                                StudentSectioningWidget.this.lastRequest(sessionId, studentId, saved);
                                if (ret != null) {
                                    ret.onSuccess((Object)StudentSectioningWidget.this.iEligibilityCheck);
                                }
                            }

                            public void onMessage(OnlineSectioningInterface.EligibilityCheck result) {
                                if (result.hasMessage()) {
                                    StudentSectioningWidget.this.setError(result.getMessage());
                                } else if (result.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED)) {
                                    StudentSectioningWidget.this.setWarning(MESSAGES.exceptionAuthenticationPinRequired());
                                } else {
                                    StudentSectioningWidget.this.clearMessage(false);
                                }
                            }
                        };
                        StudentSectioningWidget.this.iPinDialog.checkEligibility(StudentSectioningWidget.this.iOnline, sessionId, null, callback);
                    } else {
                        StudentSectioningWidget.this.iSchedule.setVisible(true);
                        StudentSectioningWidget.this.iSchedule.setEnabled(true);
                        StudentSectioningWidget.this.lastRequest(sessionId, studentId, saved);
                        if (ret != null) {
                            ret.onSuccess((Object)StudentSectioningWidget.this.iEligibilityCheck);
                        }
                    }
                } else {
                    StudentSectioningWidget.this.iCourseRequests.setCanWaitList(false);
                    LoadingWidget.getInstance().hide();
                    if (result.hasMessage()) {
                        StudentSectioningWidget.this.setError(result.getMessage());
                    }
                    StudentSectioningWidget.this.iSchedule.setVisible(false);
                    StudentSectioningWidget.this.iSchedule.setEnabled(false);
                    if (ret != null) {
                        ret.onFailure((Throwable)new SectioningException(result.getMessage()));
                    }
                }
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                StudentSectioningWidget.this.iEligibilityCheck = null;
                if (ret != null) {
                    ret.onFailure(caught);
                }
            }
        });
    }

    private void lastResult(final CourseRequestInterface request, boolean saved) {
        AsyncCallback<ClassAssignmentInterface> callback = new AsyncCallback<ClassAssignmentInterface>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
            }

            public void onSuccess(final ClassAssignmentInterface saved) {
                StudentSectioningWidget.this.iSavedAssignment = saved;
                StudentSectioningWidget.this.iShowUnassignments.setVisible(true);
                if (request.isSaved()) {
                    StudentSectioningWidget.this.fillIn(saved);
                    StudentSectioningWidget.this.updateHistory();
                } else {
                    StudentSectioningWidget.this.iCourseRequests.validate(new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                        }

                        public void onSuccess(Boolean result) {
                            if (result.booleanValue()) {
                                ArrayList<ClassAssignmentInterface.ClassAssignment> classes = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
                                for (ClassAssignmentInterface.CourseAssignment course : saved.getCourseAssignments()) {
                                    classes.addAll(course.getClassAssignments());
                                }
                                StudentSectioningWidget.this.iSectioningService.section(StudentSectioningWidget.this.iOnline, request, classes, new AsyncCallback<ClassAssignmentInterface>(){

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.getInstance().hide();
                                    }

                                    public void onSuccess(ClassAssignmentInterface result) {
                                        StudentSectioningWidget.this.fillIn(result);
                                        StudentSectioningWidget.this.updateHistory();
                                    }
                                });
                            } else {
                                LoadingWidget.getInstance().hide();
                            }
                        }
                    });
                }
            }
        };
        if (saved) {
            this.iSectioningService.savedResult(this.iOnline, request.getAcademicSessionId(), request.getStudentId(), callback);
        } else {
            this.iSectioningService.lastResult(this.iOnline, request.getAcademicSessionId(), callback);
        }
    }

    public void lastRequest(Long sessionId, Long studentId, final boolean saved) {
        if (!LoadingWidget.getInstance().isShowing()) {
            LoadingWidget.getInstance().show(MESSAGES.courseRequestsLoading());
        }
        AsyncCallback<CourseRequestInterface> callback = new AsyncCallback<CourseRequestInterface>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                StudentSectioningWidget.this.clear();
            }

            public void onSuccess(CourseRequestInterface request) {
                if (request.isSaved() && request.getCourses().isEmpty()) {
                    LoadingWidget.getInstance().hide();
                    return;
                }
                StudentSectioningWidget.this.clear();
                StudentSectioningWidget.this.iCourseRequests.setRequest(request);
                if (StudentSectioningWidget.this.iSchedule.isVisible()) {
                    StudentSectioningWidget.this.lastResult(request, saved);
                } else {
                    LoadingWidget.getInstance().hide();
                }
            }
        };
        if (saved) {
            this.iSectioningService.savedRequest(this.iOnline, sessionId, studentId, callback);
        } else {
            this.iSectioningService.lastRequest(this.iOnline, sessionId, callback);
        }
    }

    public void showSuggestionsAsync(final int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        GWT.runAsync((RunAsyncCallback)new RunAsyncCallback(){

            public void onSuccess() {
                StudentSectioningWidget.this.openSuggestionsBox(rowIndex);
            }

            public void onFailure(Throwable caught) {
                StudentSectioningWidget.this.setError(MESSAGES.exceptionSuggestionsFailed(caught.getMessage()), caught);
            }
        });
    }

    public void setData(CourseRequestInterface request, ClassAssignmentInterface response) {
        this.clear();
        this.iCourseRequests.setRequest(request);
        if (response != null) {
            if (request.isSaved()) {
                this.iSavedAssignment = response;
                this.iShowUnassignments.setVisible(true);
            }
            this.fillIn(response);
        }
    }

    public HandlerRegistration addResizeHandler(ResizeHandler handler) {
        return this.addHandler((EventHandler)handler, ResizeEvent.getType());
    }

    public void updateScheduleChangedNoteIfNeeded() {
        if (this.iScheduleChanged) {
            this.iScheduleChanged = false;
            this.clearMessage();
        }
        if (this.iLastAssignment == null || !this.iLastAssignment.isCanEnroll() || this.iEligibilityCheck == null || !this.iEligibilityCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL)) {
            return;
        }
        boolean empty = true;
        if (this.iSavedAssignment != null) {
            block0: for (ClassAssignmentInterface.CourseAssignment course : this.iSavedAssignment.getCourseAssignments()) {
                if (!course.isAssigned() || course.isFreeTime()) continue;
                for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                    if (!clazz.isSaved()) continue;
                    empty = false;
                    break block0;
                }
            }
        }
        for (ClassAssignmentInterface.CourseAssignment course : this.iLastAssignment.getCourseAssignments()) {
            if (!course.isAssigned() || course.isFreeTime()) continue;
            for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                if (clazz.isSaved() || clazz.hasError()) continue;
                this.iScheduleChanged = true;
                this.iEnroll.addStyleName("unitime-EnrollButton");
                this.setWarning(empty ? MESSAGES.warnScheduleEmpty() : MESSAGES.warnScheduleChanged(), false);
                return;
            }
            if (this.iSavedAssignment == null) continue;
            for (ClassAssignmentInterface.CourseAssignment saved : this.iSavedAssignment.getCourseAssignments()) {
                if (!saved.isAssigned() || saved.isFreeTime() || !course.getCourseId().equals(saved.getCourseId())) continue;
                block5: for (ClassAssignmentInterface.ClassAssignment clazz : saved.getClassAssignments()) {
                    for (ClassAssignmentInterface.ClassAssignment x : course.getClassAssignments()) {
                        if (!clazz.getClassId().equals(x.getClassId())) continue;
                        continue block5;
                    }
                    if (!clazz.isSaved() || clazz.hasError()) continue;
                    this.iScheduleChanged = true;
                    this.iEnroll.addStyleName("unitime-EnrollButton");
                    this.setWarning(MESSAGES.warnScheduleChanged(), false);
                }
            }
        }
        if (this.iSavedAssignment != null) {
            block7: for (ClassAssignmentInterface.CourseAssignment course : this.iSavedAssignment.getCourseAssignments()) {
                if (!course.isAssigned() || course.isFreeTime()) continue;
                for (ClassAssignmentInterface.CourseAssignment x : this.iLastAssignment.getCourseAssignments()) {
                    if (!course.getCourseId().equals(x.getCourseId())) continue;
                    continue block7;
                }
                for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                    if (!clazz.isSaved() || clazz.hasError()) continue;
                    this.iScheduleChanged = true;
                    this.iEnroll.addStyleName("unitime-EnrollButton");
                    this.setWarning(MESSAGES.warnScheduleChanged(), false);
                }
            }
        }
        CourseRequestInterface request = this.iCourseRequests.getRequest();
        block10: for (ClassAssignmentInterface.CourseAssignment course : this.iLastAssignment.getCourseAssignments()) {
            if (!course.isAssigned() || course.isFreeTime()) continue;
            for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!(r.hasRequestedCourse() && course.getCourseName().equalsIgnoreCase(r.getRequestedCourse()) || r.hasFirstAlternative() && course.getCourseName().equalsIgnoreCase(r.getFirstAlternative())) && (!r.hasSecondAlternative() || !course.getCourseName().equalsIgnoreCase(r.getSecondAlternative()))) continue;
                continue block10;
            }
            for (CourseRequestInterface.Request r : request.getAlternatives()) {
                if (!(r.hasRequestedCourse() && course.getCourseName().equalsIgnoreCase(r.getRequestedCourse()) || r.hasFirstAlternative() && course.getCourseName().equalsIgnoreCase(r.getFirstAlternative())) && (!r.hasSecondAlternative() || !course.getCourseName().equalsIgnoreCase(r.getSecondAlternative()))) continue;
                continue block10;
            }
            this.iScheduleChanged = true;
            this.iEnroll.addStyleName("unitime-EnrollButton");
            this.setWarning(MESSAGES.warnScheduleChanged(), false);
        }
    }

    public boolean isChanged() {
        return this.iScheduleChanged;
    }

    public void clearMessage() {
        this.clearMessage(true);
    }

    public void clearMessage(boolean showEligibility) {
        if (this.iEligibilityCheck != null && this.iOnline && showEligibility) {
            if (this.iEligibilityCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED)) {
                this.setError(MESSAGES.exceptionAuthenticationPinNotProvided(), false);
            } else if (this.iEligibilityCheck.hasMessage() && !this.iEligibilityCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL)) {
                this.setError(this.iEligibilityCheck.getMessage(), false);
            } else if (this.iEligibilityCheck.hasMessage() && this.iEligibilityCheck.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.RECHECK_BEFORE_ENROLLMENT)) {
                this.setWarning(this.iEligibilityCheck.getMessage(), false);
            } else if (this.iEligibilityCheck.hasMessage()) {
                this.setMessage(this.iEligibilityCheck.getMessage(), false);
            } else {
                this.iMessage.setHTML("");
                this.iMessage.setStyleName("unitime-ScheduleBlankMessage");
                this.iEnroll.removeStyleName("unitime-EnrollButton");
            }
        } else {
            this.iMessage.setHTML("");
            this.iMessage.setStyleName("unitime-ScheduleBlankMessage");
            this.iEnroll.removeStyleName("unitime-EnrollButton");
        }
        if (this.isChanged()) {
            this.updateScheduleChangedNoteIfNeeded();
        }
    }

    public void setError(String message) {
        this.setError(message, true);
    }

    public void setError(String message, boolean popup) {
        this.iMessage.setHTML(message);
        this.iMessage.setStyleName("unitime-ScheduleErrorMessage");
        this.iMessage.setVisible(true);
        if (popup) {
            UniTimeNotifications.error(message);
        }
    }

    public void setError(String message, Throwable t) {
        this.iMessage.setHTML(message);
        this.iMessage.setStyleName("unitime-ScheduleErrorMessage");
        this.iMessage.setVisible(true);
        UniTimeNotifications.error(message, t);
    }

    public void setError(Throwable t) {
        this.setError(t.getMessage(), t);
    }

    public void setWarning(String message) {
        this.setWarning(message, true);
    }

    public void setWarning(String message, boolean popup) {
        this.iMessage.setHTML(message);
        this.iMessage.setStyleName("unitime-ScheduleWarningMessage");
        this.iMessage.setVisible(true);
        if (popup) {
            UniTimeNotifications.warn(message);
        }
    }

    public void setMessage(String message) {
        this.setMessage(message, true);
    }

    public void setMessage(String message, boolean popup) {
        this.iMessage.setHTML(message);
        this.iMessage.setStyleName("unitime-ScheduleMessage");
        this.iMessage.setVisible(true);
        if (popup) {
            UniTimeNotifications.info(message);
        }
    }

    public String getMessage() {
        return this.iMessage.getHTML();
    }

    protected void setElibibilityCheckDuringEnrollment(OnlineSectioningInterface.EligibilityCheck check) {
        this.iEligibilityCheck = check;
        this.iCourseRequests.setCanWaitList(check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_WAITLIST));
        if (check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL)) {
            this.iEnroll.setVisible(true);
            this.iEnroll.setEnabled(true);
        } else {
            this.iEnroll.setEnabled(false);
            this.iEnroll.setVisible(false);
        }
    }

    public class HistoryItem {
        private CourseRequestInterface iRequest;
        private ClassAssignmentInterface iAssignment;
        private boolean iFirstPage;
        private Long iSessionId;
        private String iUser;
        private String iError = null;
        private String iErrorStyle = null;
        private int iTab = 0;

        private HistoryItem() {
            this.iRequest = StudentSectioningWidget.this.iCourseRequests.getRequest();
            this.iAssignment = StudentSectioningWidget.this.iLastAssignment;
            this.iFirstPage = StudentSectioningWidget.this.iSchedule.isVisible();
            this.iSessionId = StudentSectioningWidget.this.iSessionSelector.getAcademicSessionId();
            this.iUser = StudentSectioningWidget.this.iUserAuthentication.getUser();
            this.iError = StudentSectioningWidget.this.getMessage();
            this.iErrorStyle = StudentSectioningWidget.this.iMessage.getStyleName();
            this.iTab = StudentSectioningWidget.this.iAssignmentTab;
        }

        public void restore() {
            if (StudentSectioningWidget.this.isChanged() && (this.iUser != null && !this.iUser.equals(StudentSectioningWidget.this.iUserAuthentication.getUser()) || this.iSessionId != null && !this.iSessionId.equals(StudentSectioningWidget.this.iSessionSelector.getAcademicSessionId())) && !Window.confirm((String)MESSAGES.queryLeaveChanges())) {
                return;
            }
            StudentSectioningWidget.this.iInRestore = true;
            StudentSectioningWidget.this.iUserAuthentication.setUser(this.iUser, new AsyncCallback<Boolean>(){

                public void onSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        StudentSectioningWidget.this.iSessionSelector.selectSession(HistoryItem.this.iSessionId, new AsyncCallback<Boolean>(){

                            public void onSuccess(Boolean result) {
                                if (result.booleanValue()) {
                                    StudentSectioningWidget.this.iCourseRequests.setRequest(HistoryItem.this.iRequest);
                                    if (HistoryItem.this.iTab != StudentSectioningWidget.this.iAssignmentTab) {
                                        StudentSectioningWidget.this.iAssignmentPanel.selectTab(HistoryItem.this.iTab);
                                    }
                                    if (HistoryItem.this.iFirstPage) {
                                        if (!StudentSectioningWidget.this.iSchedule.isVisible()) {
                                            StudentSectioningWidget.this.prev();
                                        }
                                        StudentSectioningWidget.this.iCourseRequests.changeTip();
                                    } else if (HistoryItem.this.iAssignment != null) {
                                        StudentSectioningWidget.this.fillIn(HistoryItem.this.iAssignment);
                                    }
                                    if (HistoryItem.this.iError != null && !HistoryItem.this.iError.isEmpty()) {
                                        if ("unitime-ScheduleErrorMessage".equals(HistoryItem.this.iErrorStyle)) {
                                            StudentSectioningWidget.this.setError(HistoryItem.this.iError);
                                        } else if ("unitime-ScheduleWarningMessage".equals(HistoryItem.this.iErrorStyle)) {
                                            StudentSectioningWidget.this.setWarning(HistoryItem.this.iError);
                                        } else {
                                            StudentSectioningWidget.this.setMessage(HistoryItem.this.iError);
                                        }
                                    } else {
                                        StudentSectioningWidget.this.clearMessage();
                                    }
                                }
                                StudentSectioningWidget.this.iInRestore = false;
                                ResizeEvent.fire((HasResizeHandlers)StudentSectioningWidget.this, (int)StudentSectioningWidget.this.getOffsetWidth(), (int)StudentSectioningWidget.this.getOffsetHeight());
                            }

                            public void onFailure(Throwable reason) {
                                StudentSectioningWidget.this.iInRestore = false;
                            }
                        });
                    } else {
                        StudentSectioningWidget.this.iInRestore = false;
                    }
                }

                public void onFailure(Throwable reason) {
                    StudentSectioningWidget.this.iInRestore = false;
                }
            });
        }
    }
}

