/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.events.UniTimeFilterBox;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventFilterBox
extends UniTimeFilterBox<EventInterface.EventFilterRpcRequest> {
    private ListBox iSponsors;
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static DateTimeFormat sDateFormat = DateTimeFormat.getFormat((String)CONSTANTS.eventDateFormat());
    private FilterBox.CustomFilter iOther = null;
    private AriaSuggestBox iRequested;
    private FilterBox.Chip iLastRequested = null;

    public EventFilterBox(AcademicSessionProvider session) {
        super(session);
        this.addFilter(new FilterBox.StaticSimpleFilter("type", new String[0]));
        this.iSponsors = new ListBox(true);
        this.iSponsors.setWidth("100%");
        this.iSponsors.setVisibleItemCount(3);
        this.addFilter(new FilterBox.CustomFilter("sponsor", new Widget[]{this.iSponsors}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    for (int i = 0; i < EventFilterBox.this.iSponsors.getItemCount(); ++i) {
                        FilterBox.Chip chip = new FilterBox.Chip("sponsor", EventFilterBox.this.iSponsors.getValue(i));
                        String name = EventFilterBox.this.iSponsors.getItemText(i);
                        if (EventFilterBox.this.iSponsors.getValue(i).toLowerCase().startsWith(text.toLowerCase())) {
                            suggestions.add(new FilterBox.Suggestion(name, chip));
                            continue;
                        }
                        if (text.length() <= 2 || !name.toLowerCase().contains(" " + text.toLowerCase())) continue;
                        suggestions.add(new FilterBox.Suggestion(name, chip));
                    }
                    callback.onSuccess(suggestions);
                }
            }

            @Override
            public boolean isVisible() {
                return EventFilterBox.this.iSponsors.getItemCount() > 0;
            }
        });
        this.iSponsors.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                boolean changed = false;
                for (int i = 0; i < EventFilterBox.this.iSponsors.getItemCount(); ++i) {
                    FilterBox.Chip chip = new FilterBox.Chip("sponsor", EventFilterBox.this.iSponsors.getValue(i));
                    if (EventFilterBox.this.iSponsors.isItemSelected(i)) {
                        if (EventFilterBox.this.hasChip(chip)) continue;
                        EventFilterBox.this.addChip(chip, false);
                        changed = true;
                        continue;
                    }
                    if (!EventFilterBox.this.hasChip(chip)) continue;
                    EventFilterBox.this.removeChip(chip, false);
                    changed = true;
                }
                if (changed) {
                    EventFilterBox.this.fireValueChangeEvent();
                }
            }
        });
        FilterBox.StaticSimpleFilter mode = new FilterBox.StaticSimpleFilter("mode", new String[0]);
        mode.setMultipleSelection(false);
        this.addFilter(mode);
        this.addFilter(new FilterBox.StaticSimpleFilter("role", new String[0]){

            @Override
            public void getPopupWidget(FilterBox box, AsyncCallback<Widget> callback) {
                callback.onSuccess(null);
            }
        });
        Label reqLab = new Label(MESSAGES.propRequestedBy());
        this.iRequested = new AriaSuggestBox(new RequestedByOracle());
        this.iRequested.setStyleName("unitime-TextArea");
        this.iRequested.setWidth("200px");
        final CheckBox conflicts = new CheckBox(MESSAGES.checkDisplayConflicts());
        conflicts.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        final CheckBox sessions = new CheckBox(MESSAGES.checkSpanMultipleSessions());
        sessions.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        this.iOther = new FilterBox.CustomFilter("other", new Widget[]{reqLab, this.iRequested, conflicts, sessions}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    if ("conflicts".startsWith(text.toLowerCase()) || MESSAGES.checkDisplayConflicts().toLowerCase().startsWith(text.toLowerCase())) {
                        suggestions.add(new FilterBox.Suggestion(MESSAGES.checkDisplayConflicts(), new FilterBox.Chip("flag", "Conflicts")));
                    }
                    if ("sessinons".startsWith(text.toLowerCase()) || MESSAGES.checkSpanMultipleSessions().toLowerCase().startsWith(text.toLowerCase())) {
                        suggestions.add(new FilterBox.Suggestion(MESSAGES.checkSpanMultipleSessions(), new FilterBox.Chip("flag", "All Sessions")));
                    }
                    callback.onSuccess(suggestions);
                }
            }
        };
        this.addFilter(this.iOther);
        this.addFilter(new FilterBox.StaticSimpleFilter("requested", new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("flag", new String[0]));
        this.iRequested.getValueBox().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EventFilterBox.this.requestedChanged(true);
            }
        });
        this.iRequested.getValueBox().addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        EventFilterBox.this.requestedChanged(false);
                    }
                });
            }
        });
        this.iRequested.getValueBox().addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            EventFilterBox.this.requestedChanged(false);
                        }
                    });
                }
            }
        });
        this.iRequested.getValueBox().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                EventFilterBox.this.requestedChanged(true);
            }
        });
        this.iRequested.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                EventFilterBox.this.requestedChanged(true);
            }
        });
        conflicts.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                FilterBox.Chip chip = new FilterBox.Chip("flag", "Conflicts");
                if (((Boolean)event.getValue()).booleanValue()) {
                    if (!EventFilterBox.this.hasChip(chip)) {
                        EventFilterBox.this.addChip(chip, true);
                    }
                } else if (EventFilterBox.this.hasChip(chip)) {
                    EventFilterBox.this.removeChip(chip, true);
                }
            }
        });
        conflicts.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                event.getNativeEvent().stopPropagation();
                event.getNativeEvent().preventDefault();
            }
        });
        sessions.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                FilterBox.Chip chip = new FilterBox.Chip("flag", "All Sessions");
                if (((Boolean)event.getValue()).booleanValue()) {
                    if (!EventFilterBox.this.hasChip(chip)) {
                        EventFilterBox.this.addChip(chip, true);
                    }
                } else if (EventFilterBox.this.hasChip(chip)) {
                    EventFilterBox.this.removeChip(chip, true);
                }
            }
        });
        sessions.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                event.getNativeEvent().stopPropagation();
                event.getNativeEvent().preventDefault();
            }
        });
        AbsolutePanel m = new AbsolutePanel();
        m.setStyleName("unitime-DateSelector");
        final SingleDateSelector.SingleMonth m1 = new SingleDateSelector.SingleMonth("From");
        m1.setAllowDeselect(true);
        m.add((Widget)m1);
        final SingleDateSelector.SingleMonth m2 = new SingleDateSelector.SingleMonth("To");
        m2.setAllowDeselect(true);
        m.add((Widget)m2);
        this.addFilter(new FilterBox.CustomFilter("date", new Widget[]{m}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                Date date;
                ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                FilterBox.Chip chFrom = null;
                FilterBox.Chip chTo = null;
                for (FilterBox.Chip c : chips) {
                    if (c.getCommand().equals("from")) {
                        chFrom = c;
                    }
                    if (!c.getCommand().equals("to")) continue;
                    chTo = c;
                }
                try {
                    date = DateTimeFormat.getFormat((String)"MM/dd").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"dd.MM").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"MM/dd/yy").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"dd.MM.yy").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"MMM dd").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    date = DateTimeFormat.getFormat((String)"MMM dd yy").parse(text);
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("from", sDateFormat.format(date)), chFrom));
                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("to", sDateFormat.format(date)), chTo));
                }
                catch (Exception e) {
                    // empty catch block
                }
                callback.onSuccess(suggestions);
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("from", new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("to", new String[0]));
        session.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                if (event.isChanged() && event.getNewAcademicSessionId() != null) {
                    RPC.execute(new EventInterface.RequestSessionDetails(event.getNewAcademicSessionId()), new AsyncCallback<GwtRpcResponseList<EventInterface.SessionMonth>>(){

                        public void onFailure(Throwable caught) {
                        }

                        public void onSuccess(GwtRpcResponseList<EventInterface.SessionMonth> result) {
                            m1.setMonths(result);
                            m2.setMonths(result);
                        }
                    });
                }
            }
        });
        m1.addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                FilterBox.Chip ch = EventFilterBox.this.getChip("from");
                if (event.getValue() == null) {
                    if (ch != null) {
                        EventFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    String text = m1.toString();
                    if (ch != null) {
                        if (ch.getCommand().equals(text)) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("from", text), true);
                }
            }
        });
        m2.addValueChangeHandler(new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                FilterBox.Chip ch = EventFilterBox.this.getChip("to");
                if (event.getValue() == null) {
                    if (ch != null) {
                        EventFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    String text = m2.toString();
                    if (ch != null) {
                        if (ch.getCommand().equals(text)) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("to", text), true);
                }
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("day", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"));
        final TimeSelector st = new TimeSelector(null);
        final TimeSelector et = new TimeSelector(st);
        st.setStyleName("unitime-TextArea");
        st.addStyleName("unitime-TimeSelector");
        et.setStyleName("unitime-TextArea");
        et.addStyleName("unitime-TimeSelector");
        this.addFilter(new FilterBox.CustomFilter("time", new Widget[]{new Label(MESSAGES.propAfter()), st, new Label(" " + MESSAGES.propBefore()), et}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                FilterBox.Chip chStart = null;
                FilterBox.Chip chStop = null;
                for (FilterBox.Chip c : chips) {
                    if (c.getCommand().equals("after")) {
                        chStart = c;
                    }
                    if (!c.getCommand().equals("before")) continue;
                    chStop = c;
                }
                Integer start = TimeSelector.TimeUtils.parseTime(CONSTANTS, text, null);
                Integer stop = TimeSelector.TimeUtils.parseTime(CONSTANTS, text, chStart == null ? null : TimeSelector.TimeUtils.parseTime(CONSTANTS, chStart.getValue(), null));
                if (chStart == null) {
                    if (start != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2time(start)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2time(start + 3)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2time(start + 6)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2time(start + 9)), chStart));
                    }
                    if (stop != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2time(stop)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2time(stop + 3)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2time(stop + 6)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2time(stop + 9)), chStop));
                    }
                } else {
                    if (stop != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2time(stop)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2time(stop + 3)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2time(stop + 6)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2time(stop + 9)), chStop));
                    }
                    if (start != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2time(start)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2time(start + 3)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2time(start + 6)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2time(start + 9)), chStart));
                    }
                }
                callback.onSuccess(suggestions);
            }
        });
        st.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                FilterBox.Chip ch = EventFilterBox.this.getChip("after");
                if (event.getValue() == null) {
                    if (ch != null) {
                        EventFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    String text = TimeSelector.TimeUtils.slot2time((Integer)event.getValue());
                    if (ch != null) {
                        if (ch.getCommand().equals(text)) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("after", text), true);
                }
                FilterBox.Chip ch2 = EventFilterBox.this.getChip("before");
                if (et.getValue() == null) {
                    if (ch2 != null) {
                        EventFilterBox.this.removeChip(ch2, true);
                    }
                } else {
                    String text = TimeSelector.TimeUtils.slot2time(et.getValue());
                    if (ch2 != null) {
                        if (ch2.getCommand().equals(text)) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch2, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("before", text), true);
                }
            }
        });
        et.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                FilterBox.Chip ch = EventFilterBox.this.getChip("before");
                if (event.getValue() == null) {
                    if (ch != null) {
                        EventFilterBox.this.removeChip(ch, true);
                    }
                } else {
                    String text = TimeSelector.TimeUtils.slot2time((Integer)event.getValue());
                    if (ch != null) {
                        if (ch.getCommand().equals(text)) {
                            return;
                        }
                        EventFilterBox.this.removeChip(ch, false);
                    }
                    EventFilterBox.this.addChip(new FilterBox.Chip("before", text), true);
                }
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("after", new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("before", new String[0]));
        this.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                EventFilterBox.this.iLastRequested = EventFilterBox.this.getChip("requested");
                if (!EventFilterBox.this.isFilterPopupShowing()) {
                    conflicts.setValue(Boolean.valueOf(EventFilterBox.this.hasChip(new FilterBox.Chip("flag", "Conflicts"))));
                    sessions.setValue(Boolean.valueOf(EventFilterBox.this.hasChip(new FilterBox.Chip("flag", "All Sessions"))));
                    FilterBox.Chip req = EventFilterBox.this.getChip("requested");
                    if (req == null) {
                        EventFilterBox.this.iRequested.setText("");
                    } else {
                        EventFilterBox.this.iRequested.setText(req.getValue());
                    }
                    for (int i = 0; i < EventFilterBox.this.iSponsors.getItemCount(); ++i) {
                        String value = EventFilterBox.this.iSponsors.getValue(i);
                        EventFilterBox.this.iSponsors.setItemSelected(i, EventFilterBox.this.hasChip(new FilterBox.Chip("sponsor", value)));
                    }
                    FilterBox.Chip chFrom = EventFilterBox.this.getChip("from");
                    if (chFrom != null) {
                        m1.setDate(sDateFormat.parse(chFrom.getValue()));
                    } else {
                        m1.clearSelection();
                    }
                    FilterBox.Chip chTo = EventFilterBox.this.getChip("to");
                    if (chTo != null) {
                        m2.setDate(sDateFormat.parse(chTo.getValue()));
                    } else {
                        m2.clearSelection();
                    }
                    FilterBox.Chip chStart = EventFilterBox.this.getChip("after");
                    if (chStart != null) {
                        st.setValue(TimeSelector.TimeUtils.parseTime(CONSTANTS, chStart.getValue(), null));
                    } else {
                        st.setValue(null);
                    }
                    FilterBox.Chip chStop = EventFilterBox.this.getChip("before");
                    if (chStop != null) {
                        et.setValue(TimeSelector.TimeUtils.parseTime(CONSTANTS, chStop.getValue(), st.getValue()));
                    } else {
                        et.setValue(null);
                    }
                }
                if (EventFilterBox.this.getAcademicSessionId() != null) {
                    EventFilterBox.this.init(false, EventFilterBox.this.getAcademicSessionId(), new Command(){

                        public void execute() {
                            if (EventFilterBox.this.isFilterPopupShowing()) {
                                EventFilterBox.this.showFilterPopup();
                            }
                        }
                    });
                }
                EventFilterBox.this.setAriaLabel(ARIA.eventFilter(EventFilterBox.this.toAriaString()));
            }
        });
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                EventFilterBox.this.setAriaLabel(ARIA.eventFilter(EventFilterBox.this.toAriaString()));
            }
        });
    }

    public void setOtherVisible(boolean visible) {
        this.iOther.setVisible(visible);
    }

    @Override
    protected boolean populateFilter(FilterBox.Filter filter, List<EventInterface.FilterRpcResponse.Entity> entities) {
        if ("sponsor".equals(filter.getCommand())) {
            this.iSponsors.clear();
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    this.iSponsors.addItem(entity.getName() + (entity.getCount() <= 0 ? "" : " (" + entity.getCount() + ")"), entity.getAbbreviation());
                }
            }
            for (int i = 0; i < this.iSponsors.getItemCount(); ++i) {
                String value = this.iSponsors.getValue(i);
                this.iSponsors.setItemSelected(i, this.hasChip(new FilterBox.Chip("sponsor", value)));
            }
            return true;
        }
        return super.populateFilter(filter, entities);
    }

    private void requestedChanged(boolean fireChange) {
        FilterBox.Chip oldChip = this.getChip("requested");
        if (this.iRequested.getText().isEmpty()) {
            if (oldChip != null) {
                this.removeChip(oldChip, fireChange);
            }
        } else {
            FilterBox.Chip newChip = new FilterBox.Chip("requested", this.iRequested.getText());
            if (oldChip != null) {
                if (newChip.equals(oldChip)) {
                    if (fireChange && !newChip.equals(this.iLastRequested)) {
                        this.fireValueChangeEvent();
                    }
                    return;
                }
                this.removeChip(oldChip, false);
            }
            this.addChip(newChip, fireChange);
        }
    }

    @Override
    public EventInterface.EventFilterRpcRequest createRpcRequest() {
        return new EventInterface.EventFilterRpcRequest();
    }

    public class RequestedBySuggestion
    implements SuggestOracle.Suggestion {
        private FilterBox.Suggestion iSuggestion;

        RequestedBySuggestion(FilterBox.Suggestion suggestion) {
            this.iSuggestion = suggestion;
        }

        public String getDisplayString() {
            return this.iSuggestion.getChipToAdd().getName();
        }

        public String getReplacementString() {
            return this.iSuggestion.getChipToAdd().getName();
        }
    }

    public class RequestedByOracle
    extends SuggestOracle {
        public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
            if (!request.getQuery().isEmpty()) {
                ((FilterBox)EventFilterBox.this.iFilter.getWidget()).getSuggestionsProvider().getSuggestions(((FilterBox)EventFilterBox.this.iFilter.getWidget()).getChips(null), request.getQuery(), new AsyncCallback<Collection<FilterBox.Suggestion>>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Collection<FilterBox.Suggestion> result) {
                        if (result == null) {
                            return;
                        }
                        ArrayList<RequestedBySuggestion> suggestions = new ArrayList<RequestedBySuggestion>();
                        for (FilterBox.Suggestion suggestion : result) {
                            if (suggestion.getChipToAdd() == null || !"requested".equals(suggestion.getChipToAdd().getCommand())) continue;
                            suggestions.add(new RequestedBySuggestion(suggestion));
                        }
                        callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
                    }
                });
            }
        }
    }
}

