/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.curricula.CurriculaClassifications;
import org.unitime.timetable.gwt.client.curricula.CurriculaCourseSelectionBox;
import org.unitime.timetable.gwt.client.curricula.CurriculumCookie;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculaCourses
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private UniTimeTable<String> iTable = null;
    private static NumberFormat NF = NumberFormat.getFormat((String)"##0.0");
    private List<Group> iGroups = new ArrayList<Group>();
    private CurriculaClassifications iClassifications;
    private CourseSelectionHandler iCourseChangedHandler = null;
    private GroupDialogBox iNewGroupDialog;
    private boolean iEditable = true;
    private static String[] sColors = new String[]{"red", "blue", "green", "orange", "yellow", "pink", "purple", "teal", "darkpurple", "steelblue", "lightblue", "lightgreen", "yellowgreen", "redorange", "lightbrown", "lightpurple", "grey", "bluegrey", "lightteal", "yellowgrey", "brown"};
    private TreeSet<String> iVisibleCourses = null;
    private HashMap<String, CurriculumInterface.CurriculumStudentsInterface[]> iLastCourses = null;

    public CurriculaCourses() {
        this.iTable = new UniTimeTable();
        this.initWidget((Widget)this.iTable);
        this.iCourseChangedHandler = new CourseSelectionHandler(){

            public void onCourseSelection(CourseSelectionEvent event) {
                CurriculumInterface.CurriculumStudentsInterface[] c = CurriculaCourses.this.iLastCourses == null ? null : (CurriculumInterface.CurriculumStudentsInterface[])CurriculaCourses.this.iLastCourses.get(event.getCourse());
                for (int col = 0; col < CurriculaCourses.this.iClassifications.getClassifications().size(); ++col) {
                    CurriculaCourses.this.setEnrollmentAndLastLike(event.getCourse(), col, c == null || c[col] == null ? null : Integer.valueOf(c[col].getEnrollment()), c == null || c[col] == null ? null : Integer.valueOf(c[col].getLastLike()), c == null || c[col] == null ? null : Integer.valueOf(c[col].getProjection()), c == null || c[col] == null ? null : Integer.valueOf(c[col].getRequested()));
                }
                com.google.gwt.user.client.Element td = ((Widget)event.getSource()).getElement();
                while (td != null && !td.getPropertyString("tagName").equalsIgnoreCase("td")) {
                    td = DOM.getParent((Element)td);
                }
                com.google.gwt.user.client.Element tr = DOM.getParent((Element)td);
                com.google.gwt.user.client.Element body = DOM.getParent((Element)tr);
                int row = DOM.getChildIndex((Element)body, (Element)tr);
                if (event.getCourse().isEmpty()) {
                    CurriculaCourses.this.iTable.getRowFormatter().addStyleName(row, "unitime-NoPrint");
                } else {
                    CurriculaCourses.this.iTable.getRowFormatter().removeStyleName(row, "unitime-NoPrint");
                }
                if (row + 1 == CurriculaCourses.this.iTable.getRowCount() && !event.getCourse().isEmpty()) {
                    CurriculaCourses.this.addBlankLine();
                }
            }
        };
        this.iNewGroupDialog = new GroupDialogBox();
        this.iTable.setHintProvider(new UniTimeTable.HintProvider<String>(){

            @Override
            public Widget getHint(UniTimeTable.TableEvent<String> event) {
                if (!CurriculaCourses.this.canShowStudentsTable(event.getRow())) {
                    return null;
                }
                StudentsTable studentsTable = new StudentsTable(event.getRow());
                if (studentsTable.canShow()) {
                    return studentsTable;
                }
                return null;
            }
        });
    }

    public void link(CurriculaClassifications cx) {
        this.iClassifications = cx;
        this.iClassifications.addExpectedChangedHandler(new CurriculaClassifications.ExpectedChangedHandler(){

            public void expectedChanged(CurriculaClassifications.ExpectedChangedEvent e) {
                CurriculaCourses.this.setVisible(e.getColumn(), e.getExpected() != null);
                if (e.getExpected() != null) {
                    CurriculaCourses.this.expectedChanged(e.getColumn(), e.getExpected());
                }
            }
        });
        this.iClassifications.addNameChangedHandler(new CurriculaClassifications.NameChangedHandler(){

            public void nameChanged(CurriculaClassifications.NameChangedEvent e) {
                ((Label)CurriculaCourses.this.iTable.getWidget(0, 2 + 2 * e.getColumn())).setText(e.getName());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void populate(CurriculumInterface curriculum, boolean editable) {
        this.iEditable = curriculum.isEditable() && editable;
        this.iTable.setAllowSelection(this.iEditable);
        this.iTable.clearTable();
        this.iGroups.clear();
        ArrayList<Object> header = new ArrayList<Object>();
        final UniTimeTableHeader hGroup = new UniTimeTableHeader(MESSAGES.colGroup()){

            @Override
            public List<UniTimeTableHeader.Operation> getOperations() {
                ArrayList<UniTimeTableHeader.Operation> ret = new ArrayList<UniTimeTableHeader.Operation>();
                for (Group g : CurriculaCourses.this.getGroups()) {
                    ret.add(g.getOperation());
                }
                ret.addAll(super.getOperations());
                return ret;
            }
        };
        header.add(hGroup);
        hGroup.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opNewGroup();
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable && CurriculaCourses.this.iTable.getSelectedCount() > 0;
            }

            public void execute() {
                CurriculaCourses.this.iTable.clearHover();
                CurriculaCourses.this.iNewGroupDialog.openNew();
            }
        });
        hGroup.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.colGroup());
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null;
            }

            public void execute() {
                CurriculaCourses.this.iTable.sortByRow(hGroup, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer a, Integer b) {
                        return CurriculaCourses.this.compareTwoRows(0, a, b);
                    }
                });
            }
        });
        final UniTimeTableHeader hCourse = new UniTimeTableHeader(MESSAGES.colCourse());
        header.add(hCourse);
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                CurriculaCourses.this.showAllCourses();
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses != null;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.opShowAllCourses();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                for (int i = 1; i < CurriculaCourses.this.iTable.getRowCount(); ++i) {
                    CurriculaCourses.this.iTable.setSelected(i, !((CurriculaCourseSelectionBox)CurriculaCourses.this.iTable.getWidget(i, 1)).getValue().isEmpty());
                }
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iEditable;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.opSelectAllCourses();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                for (int row = CurriculaCourses.this.iTable.getRowCount() - 1; row > 0; --row) {
                    if (!CurriculaCourses.this.iTable.isSelected(row)) continue;
                    String course = ((CurriculaCourseSelectionBox)CurriculaCourses.this.iTable.getWidget(row, 1)).getValue();
                    if (course.isEmpty() && row + 1 == CurriculaCourses.this.iTable.getRowCount()) {
                        CurriculaCourses.this.iTable.setSelected(row, false);
                        continue;
                    }
                    CurriculaCourses.this.iTable.removeRow(row);
                }
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iEditable && CurriculaCourses.this.iTable.getSelectedCount() > 0 && CurriculaCourses.this.iVisibleCourses == null;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.opRemoveSelectedCourses();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                for (int i = 1; i < CurriculaCourses.this.iTable.getRowCount(); ++i) {
                    CurriculaCourses.this.iTable.setSelected(i, false);
                }
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iEditable && CurriculaCourses.this.iTable.getSelectedCount() > 0;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.opClearSelection();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                CurriculaCourses.this.setPercent(!CurriculumCookie.getInstance().getCurriculaCoursesPercent());
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return true;
            }

            public String getName() {
                return CurriculumCookie.getInstance().getCurriculaCoursesPercent() ? MESSAGES.opShowNumbers() : MESSAGES.opShowPercentages();
            }
        });
        ArrayList<13> modeOps = new ArrayList<13>();
        for (final Mode m : Mode.values()) {
            if (m == Mode.NONE) continue;
            modeOps.add(new UniTimeTableHeader.Operation(){

                public void execute() {
                    CurriculaCourses.this.setMode(m == CurriculumCookie.getInstance().getCurriculaCoursesMode() ? Mode.NONE : m);
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return m == CurriculumCookie.getInstance().getCurriculaCoursesMode() ? MESSAGES.opHide(m.getName()) : MESSAGES.opShow(m.getName());
                }
            });
        }
        for (UniTimeTableHeader.Operation operation : modeOps) {
            hCourse.addOperation(operation);
        }
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                CurriculaCourses.this.updateEnrollmentsAndLastLike(CurriculaCourses.this.iLastCourses, true);
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iLastCourses != null;
            }

            public boolean hasSeparator() {
                return true;
            }

            public String getName() {
                return MESSAGES.opShowEmptyCourses();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                block0: for (int row = CurriculaCourses.this.iTable.getRowCount() - 1; row > 0; --row) {
                    String course = ((CurriculaCourseSelectionBox)CurriculaCourses.this.iTable.getWidget(row, 1)).getValue();
                    if (course.isEmpty() && row + 1 == CurriculaCourses.this.iTable.getRowCount()) continue;
                    for (int c = 0; c < CurriculaCourses.this.iClassifications.getClassifications().size(); ++c) {
                        int x = 2 + 2 * c;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, x);
                        if (text.getShare() != null) continue block0;
                    }
                    CurriculaCourses.this.iTable.removeRow(row);
                }
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null;
            }

            public boolean hasSeparator() {
                return CurriculaCourses.this.iLastCourses == null;
            }

            public String getName() {
                return MESSAGES.opHideEmptyCourses();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                for (int c = 0; c < CurriculaCourses.this.iClassifications.getClassifications().size(); ++c) {
                    int x = 2 + 2 * c;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, x);
                        text.setShare(null);
                    }
                }
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable;
            }

            public boolean hasSeparator() {
                return true;
            }

            public String getName() {
                return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opClearRequestedEnrollmentAllClassificationsSelectedCoursesOnly() : MESSAGES.opClearRequestedEnrollmentAllClassifications();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                for (int c = 0; c < CurriculaCourses.this.iClassifications.getClassifications().size(); ++c) {
                    int x = 2 + 2 * c;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, x);
                        EnrollmentLabel label = (EnrollmentLabel)CurriculaCourses.this.iTable.getWidget(row, x + 1);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                            text.setShare(label.getLastLikePercent());
                            continue;
                        }
                        text.setExpected(label.getLastLike());
                    }
                }
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable && CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.LAST;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opCopyLastLikeToRequestedAllClassificationsSelectedCoursesOnly() : MESSAGES.opCopyLastLikeToRequestedAllClassifications();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                for (int c = 0; c < CurriculaCourses.this.iClassifications.getClassifications().size(); ++c) {
                    int x = 2 + 2 * c;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, x);
                        EnrollmentLabel label = (EnrollmentLabel)CurriculaCourses.this.iTable.getWidget(row, x + 1);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                            text.setShare(label.getEnrollmentPercent());
                            continue;
                        }
                        text.setExpected(label.getEnrollment());
                    }
                }
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable && CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.ENRL;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opCopyCurrentToRequestedAllClassificationsSelectedCoursesOnly() : MESSAGES.opCopyCurrentToRequestedAllClassifications();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                for (int c = 0; c < CurriculaCourses.this.iClassifications.getClassifications().size(); ++c) {
                    int x = 2 + 2 * c;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, x);
                        EnrollmentLabel label = (EnrollmentLabel)CurriculaCourses.this.iTable.getWidget(row, x + 1);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                            text.setShare(label.getRequestedPercent());
                            continue;
                        }
                        text.setExpected(label.getRequested());
                    }
                }
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable && CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.REQ;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opCopyCourseRequestsToRequestedAllClassificationsSelectedCoursesOnly() : MESSAGES.opCopyCourseRequestsToRequestedAllClassifications();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public void execute() {
                boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                for (int c = 0; c < CurriculaCourses.this.iClassifications.getClassifications().size(); ++c) {
                    int x = 2 + 2 * c;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, x);
                        EnrollmentLabel label = (EnrollmentLabel)CurriculaCourses.this.iTable.getWidget(row, x + 1);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                            text.setShare(label.getProjectionPercent());
                            continue;
                        }
                        text.setExpected(label.getProjection());
                    }
                }
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable && CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.PROJ;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opCopyProjectionToRequestedAllClassificationsSelectedCoursesOnly() : MESSAGES.opCopyProjectionToRequestedAllClassifications();
            }
        });
        hCourse.addOperation(new UniTimeTableHeader.Operation(){

            public String getName() {
                return MESSAGES.opSortBy(MESSAGES.colCourse());
            }

            public boolean hasSeparator() {
                return true;
            }

            public boolean isApplicable() {
                return CurriculaCourses.this.iVisibleCourses == null;
            }

            public void execute() {
                CurriculaCourses.this.iTable.sortByRow(hCourse, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer a, Integer b) {
                        return CurriculaCourses.this.compareTwoRows(1, a, b);
                    }
                });
            }
        });
        OpenHandler<PopupPanel> fx = new OpenHandler<PopupPanel>(){

            public void onOpen(OpenEvent<PopupPanel> event) {
                CurriculaCourses.this.iTable.clearHover();
            }
        };
        int n = 2;
        for (final CurriculumInterface.AcademicClassificationInterface clasf : this.iClassifications.getClassifications()) {
            void var8_11;
            final UniTimeTableHeader hExp = new UniTimeTableHeader(clasf.getCode(), HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hExp);
            void expCol = var8_11++;
            hExp.addOperation(new UniTimeTableHeader.Operation((int)expCol){
                final /* synthetic */ int val$expCol;
                {
                    this.val$expCol = n;
                }

                public void execute() {
                    for (int i = 1; i < CurriculaCourses.this.iTable.getRowCount(); ++i) {
                        CurriculaCourses.this.iTable.setSelected(i, !((ShareTextBox)CurriculaCourses.this.iTable.getWidget(i, this.val$expCol)).getText().isEmpty());
                    }
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iEditable;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.opSelectAll();
                }
            });
            hExp.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int i = 1; i < CurriculaCourses.this.iTable.getRowCount(); ++i) {
                        CurriculaCourses.this.iTable.setSelected(i, false);
                    }
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iEditable && CurriculaCourses.this.iTable.getSelectedCount() > 0;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.opClearSelection();
                }
            });
            hExp.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    CurriculaCourses.this.setPercent(!CurriculumCookie.getInstance().getCurriculaCoursesPercent());
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return CurriculumCookie.getInstance().getCurriculaCoursesPercent() ? MESSAGES.opShowNumbers() : MESSAGES.opShowPercentages();
                }
            });
            for (UniTimeTableHeader.Operation operation : modeOps) {
                hExp.addOperation(operation);
            }
            hExp.addOperation(new UniTimeTableHeader.Operation((int)expCol){
                final /* synthetic */ int val$expCol;
                {
                    this.val$expCol = n;
                }

                public void execute() {
                    boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, this.val$expCol);
                        text.setShare(null);
                    }
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable;
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opClearRequestedEnrollmentSelectedCoursesOnly() : MESSAGES.opClearRequestedEnrollment();
                }
            });
            hExp.addOperation(new UniTimeTableHeader.Operation((int)expCol){
                final /* synthetic */ int val$expCol;
                {
                    this.val$expCol = n;
                }

                public void execute() {
                    boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, this.val$expCol);
                        EnrollmentLabel label = (EnrollmentLabel)CurriculaCourses.this.iTable.getWidget(row, this.val$expCol + 1);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                            text.setShare(label.getLastLikePercent());
                            continue;
                        }
                        text.setExpected(label.getLastLike());
                    }
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable && CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.LAST;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opCopyLastLikeToRequestedSelectedCoursesOnly() : MESSAGES.opCopyLastLikeToRequested();
                }
            });
            hExp.addOperation(new UniTimeTableHeader.Operation((int)expCol){
                final /* synthetic */ int val$expCol;
                {
                    this.val$expCol = n;
                }

                public void execute() {
                    boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, this.val$expCol);
                        EnrollmentLabel label = (EnrollmentLabel)CurriculaCourses.this.iTable.getWidget(row, this.val$expCol + 1);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                            text.setShare(label.getEnrollmentPercent());
                            continue;
                        }
                        text.setExpected(label.getEnrollment());
                    }
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable && CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.ENRL;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opCopyCurrentToRequestedSelectedCoursesOnly() : MESSAGES.opCopyCurrentToRequested();
                }
            });
            hExp.addOperation(new UniTimeTableHeader.Operation((int)expCol){
                final /* synthetic */ int val$expCol;
                {
                    this.val$expCol = n;
                }

                public void execute() {
                    boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, this.val$expCol);
                        EnrollmentLabel label = (EnrollmentLabel)CurriculaCourses.this.iTable.getWidget(row, this.val$expCol + 1);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                            text.setShare(label.getRequestedPercent());
                            continue;
                        }
                        text.setExpected(label.getRequested());
                    }
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable && CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.REQ;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opCopyCourseRequestsToRequestedSelectedCoursesOnly() : MESSAGES.opCopyCourseRequestsToRequested();
                }
            });
            hExp.addOperation(new UniTimeTableHeader.Operation((int)expCol){
                final /* synthetic */ int val$expCol;
                {
                    this.val$expCol = n;
                }

                public void execute() {
                    boolean selectedOnly = CurriculaCourses.this.iTable.getSelectedCount() > 0;
                    for (int row = 1; row < CurriculaCourses.this.iTable.getRowCount(); ++row) {
                        if (selectedOnly && !CurriculaCourses.this.iTable.isSelected(row)) continue;
                        ShareTextBox text = (ShareTextBox)CurriculaCourses.this.iTable.getWidget(row, this.val$expCol);
                        EnrollmentLabel label = (EnrollmentLabel)CurriculaCourses.this.iTable.getWidget(row, this.val$expCol + 1);
                        if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                            text.setShare(label.getProjectionPercent());
                            continue;
                        }
                        text.setExpected(label.getProjection());
                    }
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iVisibleCourses == null && CurriculaCourses.this.iEditable && CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.PROJ;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return CurriculaCourses.this.iTable.getSelectedCount() > 0 ? MESSAGES.opCopyProjectionToRequestedSelectedCoursesOnly() : MESSAGES.opCopyProjectionToRequested();
                }
            });
            hExp.addOperation(new UniTimeTableHeader.Operation((int)expCol){
                final /* synthetic */ int val$expCol;
                {
                    this.val$expCol = n;
                }

                public String getName() {
                    return MESSAGES.opSortBy(clasf.getCode());
                }

                public boolean hasSeparator() {
                    return true;
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iVisibleCourses == null;
                }

                public void execute() {
                    CurriculaCourses.this.iTable.sortByRow(hExp, new Comparator<Integer>(){

                        @Override
                        public int compare(Integer a, Integer b) {
                            return CurriculaCourses.this.compareTwoRows(val$expCol, a, b);
                        }
                    });
                }
            });
            final UniTimeTableHeader hCmp = new UniTimeTableHeader(CurriculumCookie.getInstance().getCurriculaCoursesMode().getAbbv(), HasHorizontalAlignment.ALIGN_CENTER);
            header.add(hCmp);
            void var14_20 = var8_11++;
            hCmp.addOperation(new UniTimeTableHeader.Operation((int)var14_20){
                final /* synthetic */ int val$cmpCol;
                {
                    this.val$cmpCol = n;
                }

                public void execute() {
                    for (int i = 1; i < CurriculaCourses.this.iTable.getRowCount(); ++i) {
                        CurriculaCourses.this.iTable.setSelected(i, !((EnrollmentLabel)CurriculaCourses.this.iTable.getWidget(i, this.val$cmpCol)).getText().isEmpty());
                    }
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iEditable;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.opSelectAll();
                }
            });
            hCmp.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    for (int i = 1; i < CurriculaCourses.this.iTable.getRowCount(); ++i) {
                        CurriculaCourses.this.iTable.setSelected(i, false);
                    }
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iEditable && CurriculaCourses.this.iTable.getSelectedCount() > 0;
                }

                public boolean hasSeparator() {
                    return false;
                }

                public String getName() {
                    return MESSAGES.opClearSelection();
                }
            });
            hCmp.addOperation(new UniTimeTableHeader.Operation(){

                public void execute() {
                    CurriculaCourses.this.setPercent(!CurriculumCookie.getInstance().getCurriculaCoursesPercent());
                }

                public boolean isApplicable() {
                    return true;
                }

                public boolean hasSeparator() {
                    return true;
                }

                public String getName() {
                    return CurriculumCookie.getInstance().getCurriculaCoursesPercent() ? MESSAGES.opShowNumbers() : MESSAGES.opShowPercentages();
                }
            });
            for (UniTimeTableHeader.Operation operation : modeOps) {
                hCmp.addOperation(operation);
            }
            hCmp.addOperation(new UniTimeTableHeader.Operation((int)var14_20){
                final /* synthetic */ int val$cmpCol;
                {
                    this.val$cmpCol = n;
                }

                public String getName() {
                    return MESSAGES.opSortBy(clasf.getCode() + " " + CurriculumCookie.getInstance().getCurriculaCoursesMode().getName());
                }

                public boolean hasSeparator() {
                    return true;
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iVisibleCourses == null;
                }

                public void execute() {
                    CurriculaCourses.this.iTable.sortByRow(hCmp, new Comparator<Integer>(){

                        @Override
                        public int compare(Integer a, Integer b) {
                            return CurriculaCourses.this.compareTwoRows(val$cmpCol, a, b);
                        }
                    });
                }
            });
        }
        this.iTable.addRow(null, header);
        if (curriculum.hasCourses()) {
            for (CurriculumInterface.CourseInterface course : curriculum.getCourses()) {
                ArrayList<Object> line = new ArrayList<Object>();
                HorizontalPanel hp = new HorizontalPanel();
                line.add(hp);
                if (course.hasGroups()) {
                    for (CurriculumInterface.CurriculumCourseGroupInterface curriculumCourseGroupInterface : course.getGroups()) {
                        Group gr = null;
                        for (Group x : this.iGroups) {
                            if (!x.getName().equals(curriculumCourseGroupInterface.getName())) continue;
                            gr = x;
                            break;
                        }
                        if (gr == null) {
                            gr = new Group(curriculumCourseGroupInterface.getName(), curriculumCourseGroupInterface.getType());
                            if (curriculumCourseGroupInterface.getColor() != null) {
                                gr.setColor(curriculumCourseGroupInterface.getColor());
                            } else {
                                block8: for (String c : sColors) {
                                    for (Group x : this.iGroups) {
                                        if (!x.getColor().equals(c)) continue;
                                        continue block8;
                                    }
                                    gr.setColor(c);
                                    break;
                                }
                                if (gr.getColor() == null) {
                                    gr.setColor(sColors[0]);
                                }
                            }
                            this.iGroups.add(gr);
                        }
                        hp.add((Widget)gr.cloneGroup());
                    }
                }
                CurriculaCourseSelectionBox cx = new CurriculaCourseSelectionBox();
                cx.setValue(course.getCourseName(), false);
                cx.setWidth("130px");
                if (cx.getCourseFinder() instanceof HasOpenHandlers) {
                    ((HasOpenHandlers)cx.getCourseFinder()).addOpenHandler((OpenHandler)fx);
                }
                cx.addCourseSelectionHandler(this.iCourseChangedHandler);
                if (!this.iEditable) {
                    cx.setEnabled(false);
                }
                line.add(cx);
                for (int i = 0; i < this.iClassifications.getClassifications().size(); ++i) {
                    CurriculumInterface.CurriculumCourseInterface curriculumCourseInterface = course.getCurriculumCourse(i);
                    ShareTextBox ex = new ShareTextBox(i, curriculumCourseInterface == null ? null : Float.valueOf(curriculumCourseInterface.getShare()));
                    if (!this.iEditable) {
                        ex.setReadOnly(true);
                    }
                    line.add(ex);
                    EnrollmentLabel enrollmentLabel = new EnrollmentLabel(i, curriculumCourseInterface == null ? null : curriculumCourseInterface.getEnrollment(), curriculumCourseInterface == null ? null : curriculumCourseInterface.getLastLike(), curriculumCourseInterface == null ? null : curriculumCourseInterface.getProjection(), curriculumCourseInterface == null ? null : curriculumCourseInterface.getRequested());
                    line.add(enrollmentLabel);
                }
                this.iTable.addRow(course.getCourseName(), line);
            }
        }
        if (this.iEditable) {
            this.addBlankLine();
        }
    }

    public boolean saveCurriculum(CurriculumInterface c) {
        boolean ret = true;
        HashSet<String> courses = new HashSet<String>();
        HashMap<String, CurriculumInterface.CurriculumCourseGroupInterface> groups = new HashMap<String, CurriculumInterface.CurriculumCourseGroupInterface>();
        if (c.hasCourses()) {
            c.getCourses().clear();
        }
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            String course = ((CurriculaCourseSelectionBox)this.iTable.getWidget(row, 1)).getValue();
            if (course.isEmpty()) continue;
            if (!courses.add(course)) {
                ((CurriculaCourseSelectionBox)this.iTable.getWidget(row, 1)).setError(MESSAGES.errorDuplicateCourse(course));
                ret = false;
                continue;
            }
            CurriculumInterface.CourseInterface cr = new CurriculumInterface.CourseInterface();
            cr.setCourseName(course);
            for (int i = 0; i < this.iClassifications.getClassifications().size(); ++i) {
                Float share = ((ShareTextBox)this.iTable.getWidget(row, 2 + 2 * i)).getShare();
                if (share == null) continue;
                Integer lastLike = ((EnrollmentLabel)this.iTable.getWidget(row, 3 + 2 * i)).iLastLike;
                CurriculumInterface.CurriculumCourseInterface cx = new CurriculumInterface.CurriculumCourseInterface();
                cx.setShare(share.floatValue());
                cx.setLastLike(lastLike);
                cx.setCurriculumClassificationId(this.iClassifications.getClassifications().get(i).getId());
                cr.setCurriculumCourse(i, cx);
            }
            if (!cr.hasCurriculumCourses()) continue;
            HorizontalPanel hp = (HorizontalPanel)this.iTable.getWidget(row, 0);
            for (int i = 0; i < hp.getWidgetCount(); ++i) {
                Group g = (Group)hp.getWidget(i);
                CurriculumInterface.CurriculumCourseGroupInterface gr = (CurriculumInterface.CurriculumCourseGroupInterface)groups.get(g.getName());
                if (gr == null) {
                    gr = new CurriculumInterface.CurriculumCourseGroupInterface();
                    gr.setName(g.getName());
                    gr.setType(g.getType());
                    gr.setColor(g.getColor());
                    groups.put(g.getName(), gr);
                }
                cr.addGroup(gr);
            }
            c.addCourse(cr);
        }
        return ret;
    }

    public void addBlankLine() {
        ArrayList<Object> line = new ArrayList<Object>();
        HorizontalPanel hp = new HorizontalPanel();
        line.add(hp);
        CurriculaCourseSelectionBox cx = new CurriculaCourseSelectionBox();
        cx.setWidth("130px");
        cx.addCourseSelectionHandler(this.iCourseChangedHandler);
        if (cx.getCourseFinder() instanceof HasOpenHandlers) {
            ((HasOpenHandlers)cx.getCourseFinder()).addOpenHandler((OpenHandler)new OpenHandler<PopupPanel>(){

                public void onOpen(OpenEvent<PopupPanel> event) {
                    CurriculaCourses.this.iTable.clearHover();
                }
            });
        }
        if (!this.iEditable) {
            cx.setEnabled(false);
        }
        line.add(cx);
        for (int col = 0; col < this.iClassifications.getClassifications().size(); ++col) {
            ShareTextBox ex = new ShareTextBox(col, null);
            if (!this.iEditable) {
                ex.setReadOnly(true);
            }
            line.add(ex);
            EnrollmentLabel note = new EnrollmentLabel(col, null, null, null, null);
            line.add(note);
        }
        int row = this.iTable.addRow("", line);
        this.iTable.getRowFormatter().addStyleName(row, "unitime-NoPrint");
        if (this.iVisibleCourses != null) {
            this.iTable.getRowFormatter().setVisible(row, false);
        }
        for (int col = 0; col < line.size(); ++col) {
            if (this.iTable.getCellFormatter().isVisible(0, col)) continue;
            this.iTable.getCellFormatter().setVisible(row, col, false);
        }
    }

    private int compareTwoRows(int column, int r0, int r1) {
        Integer i0;
        boolean e1 = ((CurriculaCourseSelectionBox)this.iTable.getWidget(r0, 1)).getValue().isEmpty();
        boolean e2 = ((CurriculaCourseSelectionBox)this.iTable.getWidget(r1, 1)).getValue().isEmpty();
        if (e1 && !e2) {
            return 1;
        }
        if (e2 && !e1) {
            return -1;
        }
        if (column == 0) {
            int i;
            HorizontalPanel p0 = (HorizontalPanel)this.iTable.getWidget(r0, 0);
            HorizontalPanel p1 = (HorizontalPanel)this.iTable.getWidget(r1, 0);
            TreeSet<Group> g0 = new TreeSet<Group>();
            TreeSet<Group> g1 = new TreeSet<Group>();
            for (i = 0; i < p0.getWidgetCount(); ++i) {
                g0.add((Group)p0.getWidget(i));
            }
            for (i = 0; i < p1.getWidgetCount(); ++i) {
                g1.add((Group)p1.getWidget(i));
            }
            Iterator i02 = g0.iterator();
            Iterator i1 = g1.iterator();
            while (i02.hasNext() || i1.hasNext()) {
                if (!i02.hasNext()) {
                    return 1;
                }
                if (!i1.hasNext()) {
                    return -1;
                }
                int cmp = ((Group)i02.next()).compareTo((Group)i1.next());
                if (cmp == 0) continue;
                return cmp;
            }
            return this.compareTwoRows(2, r0, r1);
        }
        if (column == 1) {
            return ((CurriculaCourseSelectionBox)this.iTable.getWidget(r0, 1)).getValue().compareTo(((CurriculaCourseSelectionBox)this.iTable.getWidget(r1, 1)).getValue());
        }
        if (column % 2 == 0) {
            Float s0 = ((ShareTextBox)this.iTable.getWidget(r0, column)).getShare();
            Float s1 = ((ShareTextBox)this.iTable.getWidget(r1, column)).getShare();
            return -(s0 == null ? new Float(0.0f) : s0).compareTo(s1 == null ? new Float(0.0f) : s1);
        }
        EnrollmentLabel l0 = (EnrollmentLabel)this.iTable.getWidget(r0, column);
        EnrollmentLabel l1 = (EnrollmentLabel)this.iTable.getWidget(r1, column);
        Mode mode = CurriculumCookie.getInstance().getCurriculaCoursesMode();
        Integer n = mode == Mode.ENRL ? l0.iEnrollment : (mode == Mode.LAST ? l0.iLastLike : (i0 = mode == Mode.REQ ? l0.iRequested : l0.iProjection));
        Integer i1 = mode == Mode.ENRL ? l1.iEnrollment : (mode == Mode.LAST ? l1.iLastLike : (mode == Mode.REQ ? l0.iRequested : l1.iProjection));
        return -(i0 == null ? new Integer(0) : i0).compareTo(i1 == null ? new Integer(0) : i1);
    }

    public int getCourseIndex(String course) {
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            String c = ((CurriculaCourseSelectionBox)this.iTable.getWidget(row, 1)).getValue();
            if (!course.equals(c)) continue;
            return row - 1;
        }
        return -1;
    }

    public boolean setEnrollmentAndLastLike(String course, int clasf, Integer enrollment, Integer lastLike, Integer projection, Integer requested) {
        boolean changed = false;
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            String c = ((CurriculaCourseSelectionBox)this.iTable.getWidget(row, 1)).getValue();
            if (!course.equals(c)) continue;
            EnrollmentLabel note = (EnrollmentLabel)this.iTable.getWidget(row, 3 + 2 * clasf);
            note.iEnrollment = enrollment;
            note.iLastLike = lastLike;
            note.iProjection = projection;
            note.iRequested = requested;
            note.update();
            changed = true;
        }
        return changed;
    }

    public void updateEnrollmentsAndLastLike(HashMap<String, CurriculumInterface.CurriculumStudentsInterface[]> courses, boolean showEmptyCourses) {
        CurriculumInterface.CurriculumStudentsInterface[] cc;
        this.iLastCourses = courses;
        int row = 1;
        block0: while (row < this.iTable.getRowCount() - 1) {
            for (int col = 0; col < this.iClassifications.getClassifications().size(); ++col) {
                ShareTextBox text = (ShareTextBox)this.iTable.getWidget(row, 2 + 2 * col);
                if (text.getText().isEmpty()) continue;
                ++row;
                continue block0;
            }
            this.iTable.removeRow(row);
        }
        HashSet<String> updated = new HashSet<String>();
        for (int row2 = 1; row2 < this.iTable.getRowCount(); ++row2) {
            String c = ((CurriculaCourseSelectionBox)this.iTable.getWidget(row2, 1)).getValue();
            if (c.isEmpty()) continue;
            updated.add(c);
            CurriculumInterface.CurriculumStudentsInterface[] cc2 = courses.get(c);
            for (int col = 0; col < this.iClassifications.getClassifications().size(); ++col) {
                EnrollmentLabel note = (EnrollmentLabel)this.iTable.getWidget(row2, 3 + 2 * col);
                note.iEnrollment = cc2 == null || cc2[col] == null ? null : Integer.valueOf(cc2[col].getEnrollment());
                note.iLastLike = cc2 == null || cc2[col] == null ? null : Integer.valueOf(cc2[col].getLastLike());
                note.iProjection = cc2 == null || cc2[col] == null ? null : Integer.valueOf(cc2[col].getProjection());
                note.iRequested = cc2 == null || cc2[col] == null ? null : Integer.valueOf(cc2[col].getRequested());
                note.update();
            }
        }
        CurriculumInterface.CurriculumStudentsInterface[] total = courses.get("");
        if (total == null) {
            return;
        }
        int totalEnrollment = 0;
        int totalLastLike = 0;
        int totalRequested = 0;
        for (int i = 0; i < total.length; ++i) {
            if (total[i] != null) {
                totalEnrollment += total[i].getEnrollment();
            }
            if (total[i] != null) {
                totalLastLike += total[i].getLastLike();
            }
            if (total[i] == null) continue;
            totalRequested += total[i].getRequested();
        }
        TreeSet<Map.Entry<String, CurriculumInterface.CurriculumStudentsInterface[]>> include = new TreeSet<Map.Entry<String, CurriculumInterface.CurriculumStudentsInterface[]>>(new Comparator<Map.Entry<String, CurriculumInterface.CurriculumStudentsInterface[]>>(){

            private int firstClassification(CurriculumInterface.CurriculumStudentsInterface[] a) {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] == null) continue;
                    if (a[i].getEnrollment() > 0) {
                        return i;
                    }
                    if (a[i].getLastLike() > 0) {
                        return i;
                    }
                    if (a[i].getProjection() > 0) {
                        return i;
                    }
                    if (a[i].getRequested() <= 0) continue;
                    return i;
                }
                return a.length;
            }

            @Override
            public int compare(Map.Entry<String, CurriculumInterface.CurriculumStudentsInterface[]> c0, Map.Entry<String, CurriculumInterface.CurriculumStudentsInterface[]> c1) {
                int b1;
                int b0 = this.firstClassification(c0.getValue());
                if (b0 < (b1 = this.firstClassification(c1.getValue()))) {
                    return -1;
                }
                if (b0 > b1) {
                    return 1;
                }
                while (b0 < c0.getValue().length) {
                    int x1;
                    int v0 = c0.getValue()[b0] == null ? 0 : c0.getValue()[b0].getEnrollment();
                    int v1 = c1.getValue()[b0] == null ? 0 : c1.getValue()[b0].getEnrollment();
                    int w0 = c0.getValue()[b0] == null ? 0 : c0.getValue()[b0].getLastLike();
                    int w1 = c1.getValue()[b0] == null ? 0 : c1.getValue()[b0].getLastLike();
                    int x0 = c0.getValue()[b0] == null ? 0 : c0.getValue()[b0].getRequested();
                    int n = x1 = c1.getValue()[b0] == null ? 0 : c1.getValue()[b0].getRequested();
                    if (v0 > v1 || w0 > w1 || x0 > x1) {
                        return -1;
                    }
                    if (v0 < v1 || w0 < w1 || x0 < x1) {
                        return 1;
                    }
                    ++b0;
                }
                return c0.getKey().compareTo(c1.getKey());
            }
        });
        for (Map.Entry<String, CurriculumInterface.CurriculumStudentsInterface[]> course : courses.entrySet()) {
            if (updated.contains(course.getKey()) || course.getKey().isEmpty()) continue;
            cc = course.getValue();
            int enrollment = 0;
            int lastLike = 0;
            int requested = 0;
            for (int i = 0; i < cc.length; ++i) {
                if (cc[i] != null) {
                    enrollment += cc[i].getEnrollment();
                }
                if (cc[i] != null) {
                    lastLike += cc[i].getLastLike();
                }
                if (cc[i] == null) continue;
                requested += cc[i].getRequested();
            }
            if (!(totalEnrollment > 0 && 100.0f * (float)enrollment / (float)totalEnrollment > 3.0f || totalLastLike > 0 && 100.0f * (float)lastLike / (float)totalLastLike > 3.0f) && (totalRequested <= 0 || !(100.0f * (float)requested / (float)totalRequested > 3.0f))) continue;
            include.add(course);
        }
        if (showEmptyCourses) {
            for (Map.Entry<String, CurriculumInterface.CurriculumStudentsInterface[]> course : include) {
                cc = course.getValue();
                int row3 = this.iTable.getRowCount() - 1;
                if (!this.iEditable) {
                    ++row3;
                }
                this.addBlankLine();
                CurriculaCourseSelectionBox c = (CurriculaCourseSelectionBox)this.iTable.getWidget(row3, 1);
                c.setValue(course.getKey(), false);
                this.iTable.getRowFormatter().removeStyleName(row3, "unitime-NoPrint");
                for (int col = 0; col < this.iClassifications.getClassifications().size(); ++col) {
                    EnrollmentLabel note = (EnrollmentLabel)this.iTable.getWidget(row3, 3 + 2 * col);
                    note.iEnrollment = cc == null || cc[col] == null ? null : Integer.valueOf(cc[col].getEnrollment());
                    note.iLastLike = cc == null || cc[col] == null ? null : Integer.valueOf(cc[col].getLastLike());
                    note.iProjection = cc == null || cc[col] == null ? null : Integer.valueOf(cc[col].getProjection());
                    note.iRequested = cc == null || cc[col] == null ? null : Integer.valueOf(cc[col].getRequested());
                    note.update();
                }
                if (this.iVisibleCourses == null) continue;
                if (this.iVisibleCourses.contains(course.getKey())) {
                    ((CurriculaCourseSelectionBox)this.iTable.getWidget(row3, 1)).setEnabled(false);
                    this.iTable.getRowFormatter().setVisible(row3, true);
                    continue;
                }
                this.iTable.getRowFormatter().setVisible(row3, false);
            }
        }
    }

    public void expectedChanged(int col, int expected) {
        if (!CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
            for (int row = 1; row < this.iTable.getRowCount(); ++row) {
                ((ShareTextBox)this.iTable.getWidget(row, 2 + 2 * col)).update();
            }
        }
    }

    private void setPercent(boolean percent) {
        if (CurriculumCookie.getInstance().getCurriculaCoursesPercent() == percent) {
            return;
        }
        CurriculumCookie.getInstance().setCurriculaCoursesPercent(percent);
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            for (int col = 0; col < this.iClassifications.getClassifications().size(); ++col) {
                ((ShareTextBox)this.iTable.getWidget(row, 2 + 2 * col)).update();
                ((EnrollmentLabel)this.iTable.getWidget(row, 3 + 2 * col)).update();
            }
        }
    }

    private void setMode(Mode mode) {
        CurriculumCookie.getInstance().setCurriculaCoursesMode(mode);
        for (int col = 0; col < this.iClassifications.getClassifications().size(); ++col) {
            ((HTML)this.iTable.getWidget(0, 3 + 2 * col)).setHTML(mode.getAbbv());
        }
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            for (int col = 0; col < this.iClassifications.getClassifications().size(); ++col) {
                ((EnrollmentLabel)this.iTable.getWidget(row, 3 + 2 * col)).update();
            }
        }
    }

    public void setVisible(int col, boolean visible) {
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            this.iTable.getFlexCellFormatter().setVisible(row, 2 + 2 * col, visible);
            this.iTable.getFlexCellFormatter().setVisible(row, 3 + 2 * col, visible);
        }
    }

    public void assignGroup(String oldName, String name, int type) {
        Group x;
        HorizontalPanel p;
        int row;
        Group g = null;
        for (Group x2 : this.iGroups) {
            if (!x2.getName().equals(oldName == null ? name : oldName)) continue;
            g = x2;
            break;
        }
        if (g == null) {
            if (name == null || name.isEmpty()) {
                return;
            }
            g = new Group(name, type);
            block1: for (String c : sColors) {
                for (Group x3 : this.iGroups) {
                    if (!x3.getColor().equals(c)) continue;
                    continue block1;
                }
                g.setColor(c);
                break;
            }
            this.iGroups.add(g);
        } else {
            block3: for (int row2 = 1; row2 < this.iTable.getRowCount(); ++row2) {
                HorizontalPanel p2 = (HorizontalPanel)this.iTable.getWidget(row2, 0);
                for (int i = 0; i < p2.getWidgetCount(); ++i) {
                    Group x4 = (Group)p2.getWidget(i);
                    if (!x4.equals(g)) continue;
                    if (name == null || name.isEmpty()) {
                        p2.remove(i);
                        continue block3;
                    }
                    x4.setName(name);
                    x4.setType(type);
                }
            }
            if (name == null || name.isEmpty()) {
                this.iGroups.remove(g);
                return;
            }
            g.setName(name);
            g.setType(type);
        }
        if (oldName != null) {
            return;
        }
        boolean nothing = true;
        boolean hasNoGroup = false;
        block5: for (row = 1; row < this.iTable.getRowCount(); ++row) {
            if (!this.iTable.isSelected(row)) continue;
            nothing = false;
            HorizontalPanel p3 = (HorizontalPanel)this.iTable.getWidget(row, 0);
            for (int i = 0; i < p3.getWidgetCount(); ++i) {
                Group x3;
                x3 = (Group)p3.getWidget(i);
                if (x3.equals(g)) continue block5;
            }
            hasNoGroup = true;
            break;
        }
        if (nothing) {
            boolean select = false;
            for (int row3 = 1; row3 < this.iTable.getRowCount(); ++row3) {
                p = (HorizontalPanel)this.iTable.getWidget(row3, 0);
                for (int i = 0; i < p.getWidgetCount(); ++i) {
                    x = (Group)p.getWidget(i);
                    if (!x.equals(g)) continue;
                    this.iTable.setSelected(row3, true);
                    select = true;
                }
            }
            if (select) {
                return;
            }
        }
        block9: for (row = 1; row < this.iTable.getRowCount(); ++row) {
            if (!this.iTable.isSelected(row)) continue;
            this.iTable.setSelected(row, false);
            HorizontalPanel p4 = (HorizontalPanel)this.iTable.getWidget(row, 0);
            for (int i = 0; i < p4.getWidgetCount(); ++i) {
                Group x5 = (Group)p4.getWidget(i);
                if (!x5.equals(g)) continue;
                if (hasNoGroup) continue block9;
                p4.remove(i);
                continue block9;
            }
            p4.add((Widget)g.cloneGroup());
        }
        boolean found = false;
        block11: for (int row4 = 1; row4 < this.iTable.getRowCount(); ++row4) {
            p = (HorizontalPanel)this.iTable.getWidget(row4, 0);
            for (int i = 0; i < p.getWidgetCount(); ++i) {
                x = (Group)p.getWidget(i);
                if (!x.equals(g)) continue;
                found = true;
                break block11;
            }
        }
        if (!found) {
            this.iGroups.remove(g);
        }
    }

    public List<Group> getGroups() {
        return this.iGroups;
    }

    public void showOnlyCourses(TreeSet<CurriculumInterface.CourseInterface> courses) {
        this.iVisibleCourses = new TreeSet();
        for (CurriculumInterface.CourseInterface c : courses) {
            this.iVisibleCourses.add(c.getCourseName());
        }
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            String courseName = ((CurriculaCourseSelectionBox)this.iTable.getWidget(row, 1)).getValue();
            if (this.iVisibleCourses.contains(courseName)) {
                ((CurriculaCourseSelectionBox)this.iTable.getWidget(row, 1)).setEnabled(false);
                this.iTable.getRowFormatter().setVisible(row, true);
                continue;
            }
            this.iTable.getRowFormatter().setVisible(row, false);
        }
    }

    public void showAllCourses() {
        if (this.iVisibleCourses != null) {
            for (int i = 1; i < this.iTable.getRowCount(); ++i) {
                String courseName = ((CurriculaCourseSelectionBox)this.iTable.getWidget(i, 1)).getValue();
                this.iTable.setSelected(i, this.iVisibleCourses.contains(courseName));
            }
        }
        this.iVisibleCourses = null;
        for (int row = 1; row < this.iTable.getRowCount(); ++row) {
            ((CurriculaCourseSelectionBox)this.iTable.getWidget(row, 1)).setEnabled(true);
            this.iTable.getRowFormatter().setVisible(row, true);
        }
    }

    public boolean canShowStudentsTable(int row) {
        if (CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.NONE) {
            return false;
        }
        if (row < 1 || row >= this.iTable.getRowCount()) {
            return false;
        }
        String course = ((CurriculaCourseSelectionBox)this.iTable.getWidget(row, 1)).getValue();
        if (this.iLastCourses == null || !this.iLastCourses.containsKey(course)) {
            return false;
        }
        int nrOther = 0;
        for (int r = 1; r < this.iTable.getRowCount(); ++r) {
            if (r == row || !this.iTable.isSelected(r)) continue;
            ++nrOther;
        }
        return nrOther > 0;
    }

    private class GroupDialogBox
    extends UniTimeDialogBox {
        private TextBox iGrName;
        private ListBox iGrType;
        private Button iGrAssign;
        private Button iGrDelete;
        private Button iGrUpdate;
        private String iGrOldName;
        private ClickHandler iGrHandler;

        private GroupDialogBox() {
            super(true, true);
            this.iGrOldName = null;
            FlexTable groupTable = new FlexTable();
            groupTable.setCellSpacing(2);
            groupTable.setText(0, 0, MESSAGES.propName());
            this.iGrName = new UniTimeTextBox();
            groupTable.setWidget(0, 1, (Widget)this.iGrName);
            groupTable.setText(1, 0, MESSAGES.propType());
            this.iGrType = new ListBox();
            this.iGrType.addItem(MESSAGES.groupDifferentStudents());
            this.iGrType.addItem(MESSAGES.groupSameStudents());
            this.iGrType.setSelectedIndex(0);
            groupTable.setWidget(1, 1, (Widget)this.iGrType);
            HorizontalPanel grButtons = new HorizontalPanel();
            grButtons.setSpacing(2);
            this.iGrAssign = new Button(MESSAGES.opGroupAssign());
            grButtons.add((Widget)this.iGrAssign);
            this.iGrUpdate = new Button(MESSAGES.opGroupUpdate());
            grButtons.add((Widget)this.iGrUpdate);
            this.iGrDelete = new Button(MESSAGES.opGroupDelete());
            grButtons.add((Widget)this.iGrDelete);
            groupTable.setWidget(2, 1, (Widget)grButtons);
            groupTable.getFlexCellFormatter().setHorizontalAlignment(2, 1, HasHorizontalAlignment.ALIGN_RIGHT);
            this.setWidget((Widget)groupTable);
            this.iGrAssign.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    GroupDialogBox.this.hide();
                    CurriculaCourses.this.assignGroup(GroupDialogBox.this.iGrOldName, GroupDialogBox.this.iGrName.getText(), GroupDialogBox.this.iGrType.getSelectedIndex());
                }
            });
            this.setEscapeToHide(true);
            this.setEnterToSubmit(new Command(){

                public void execute() {
                    GroupDialogBox.this.hide();
                    CurriculaCourses.this.assignGroup(GroupDialogBox.this.iGrOldName, GroupDialogBox.this.iGrName.getText(), GroupDialogBox.this.iGrType.getSelectedIndex());
                }
            });
            this.iGrUpdate.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    GroupDialogBox.this.hide();
                    CurriculaCourses.this.assignGroup(GroupDialogBox.this.iGrOldName, GroupDialogBox.this.iGrName.getText(), GroupDialogBox.this.iGrType.getSelectedIndex());
                }
            });
            this.iGrDelete.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    GroupDialogBox.this.hide();
                    CurriculaCourses.this.assignGroup(GroupDialogBox.this.iGrOldName, null, GroupDialogBox.this.iGrType.getSelectedIndex());
                }
            });
            this.iGrHandler = new ClickHandler(){

                public void onClick(ClickEvent event) {
                    GroupDialogBox.this.setText(MESSAGES.dialogEditGroup());
                    GroupDialogBox.this.iGrOldName = ((Group)event.getSource()).getName();
                    GroupDialogBox.this.iGrName.setText(((Group)event.getSource()).getText());
                    GroupDialogBox.this.iGrType.setSelectedIndex(((Group)event.getSource()).getType());
                    GroupDialogBox.this.iGrAssign.setVisible(false);
                    GroupDialogBox.this.iGrDelete.setVisible(true);
                    GroupDialogBox.this.iGrUpdate.setVisible(true);
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            GroupDialogBox.this.iGrName.setFocus(true);
                            GroupDialogBox.this.iGrName.selectAll();
                        }
                    });
                    CurriculaCourses.this.iTable.clearHover();
                    event.stopPropagation();
                    GroupDialogBox.this.center();
                }
            };
        }

        public ClickHandler getClickHandler() {
            return this.iGrHandler;
        }

        public void openNew() {
            this.setText(MESSAGES.dialogNewGroup());
            this.iGrOldName = null;
            this.iGrName.setText(String.valueOf((char)(65 + CurriculaCourses.this.getGroups().size())));
            this.iGrType.setSelectedIndex(0);
            this.iGrAssign.setVisible(true);
            this.iGrDelete.setVisible(false);
            this.iGrUpdate.setVisible(false);
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    GroupDialogBox.this.iGrName.setFocus(true);
                    GroupDialogBox.this.iGrName.selectAll();
                }
            });
            this.center();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StudentsTable
    extends Composite {
        private FlexTable iT = new FlexTable();
        private VerticalPanel iP = new VerticalPanel();
        private boolean iCanShow = false;

        private int count(CurriculumInterface.CurriculumStudentsInterface c, Set<Long> students) {
            if (CurriculumCookie.getInstance().getCurriculaCoursesMode() != Mode.PROJ || c == null) {
                return students.size();
            }
            return c.countProjectedStudents(students);
        }

        private StudentsTable(int currentRow) {
            String course = ((CurriculaCourseSelectionBox)CurriculaCourses.this.iTable.getWidget(currentRow, 1)).getValue();
            this.iP.add((Widget)new Label(MESSAGES.hintComparingStudentsWithOtherCourses(course + " " + CurriculumCookie.getInstance().getCurriculaCoursesMode().getName().toLowerCase().replace(" enrollment", ""))));
            this.iP.add((Widget)this.iT);
            this.initWidget((Widget)this.iP);
            if (CurriculaCourses.this.iLastCourses == null) {
                return;
            }
            CurriculumInterface.CurriculumStudentsInterface[] thisCourse = (CurriculumInterface.CurriculumStudentsInterface[])CurriculaCourses.this.iLastCourses.get(course);
            CurriculumInterface.CurriculumStudentsInterface[] totals = (CurriculumInterface.CurriculumStudentsInterface[])CurriculaCourses.this.iLastCourses.get("");
            if (thisCourse == null) {
                return;
            }
            int column = 0;
            for (int c = 0; c < CurriculaCourses.this.iClassifications.getClassifications().size(); ++c) {
                if (CurriculaCourses.this.iClassifications.getExpected(c) == null) continue;
                this.iT.setText(0, 1 + column, CurriculaCourses.this.iClassifications.getName(c));
                this.iT.getCellFormatter().setWidth(0, 1 + column, "50px");
                this.iT.getCellFormatter().setStyleName(0, 1 + column, "unitime-DashedBottom");
                ++column;
            }
            this.iT.setText(1, 0, MESSAGES.hintStudentsInOneOtherCourse());
            this.iT.setText(2, 0, MESSAGES.hintStudentsInTwoOtherCourses());
            this.iT.setText(3, 0, MESSAGES.hintStudentsInThreeOtherCourses());
            this.iT.setText(4, 0, MESSAGES.hintStudentsInAllOtherCourses());
            this.iT.setText(5, 0, MESSAGES.hintStudentsNotInAnyOtherCourse());
            int row = 0;
            ArrayList other = new ArrayList();
            for (int r = 1; r < CurriculaCourses.this.iTable.getRowCount(); ++r) {
                String c;
                if (r == currentRow || !CurriculaCourses.this.iTable.isSelected(r) || (c = ((CurriculaCourseSelectionBox)CurriculaCourses.this.iTable.getWidget(r, 1)).getValue()).isEmpty()) continue;
                other.add(CurriculaCourses.this.iLastCourses.get(c));
                this.iT.setText(6 + row, 0, MESSAGES.hinStudentsSharedWith(c));
                ++row;
            }
            column = 0;
            int[] totalC = new int[other.size()];
            for (int i = 0; i < totalC.length; ++i) {
                totalC[i] = 0;
            }
            boolean has1 = false;
            boolean has2 = false;
            boolean has3 = false;
            boolean hasAll = false;
            boolean hasNone = false;
            for (int c = 0; c < CurriculaCourses.this.iClassifications.getClassifications().size(); ++c) {
                Set<Long> thisEnrollment;
                CurriculumInterface.CurriculumStudentsInterface tc = totals[c];
                if (CurriculaCourses.this.iClassifications.getExpected(c) == null) continue;
                Set<Long> set = thisCourse[c] == null ? null : (CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.ENRL ? thisCourse[c].getEnrolledStudents() : (thisEnrollment = CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.REQ ? thisCourse[c].getRequestedStudents() : thisCourse[c].getLastLikeStudents()));
                if (thisEnrollment != null && this.count(tc, thisEnrollment) != 0) {
                    HashSet<Long> sharedWithOneOther = new HashSet<Long>();
                    HashSet<Long> sharedWithTwoOther = new HashSet<Long>();
                    HashSet<Long> sharedWithThreeOther = new HashSet<Long>();
                    HashSet<Long> sharedWithAll = new HashSet<Long>(thisEnrollment);
                    HashSet<Long> notShared = new HashSet<Long>(thisEnrollment);
                    row = 0;
                    for (CurriculumInterface.CurriculumStudentsInterface[] o : other) {
                        Set<Long> enrl;
                        Set<Long> set2 = o == null || o[c] == null ? null : (CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.ENRL ? o[c].getEnrolledStudents() : (enrl = CurriculumCookie.getInstance().getCurriculaCoursesMode() == Mode.REQ ? o[c].getRequestedStudents() : o[c].getLastLikeStudents()));
                        if (enrl == null) {
                            sharedWithAll.clear();
                            ++row;
                            continue;
                        }
                        HashSet<Long> share = new HashSet<Long>();
                        for (Long s : thisEnrollment) {
                            if (!enrl.contains(s)) continue;
                            if (!sharedWithOneOther.add(s) && !sharedWithTwoOther.add(s)) {
                                sharedWithThreeOther.add(s);
                            }
                            share.add(s);
                        }
                        Iterator i = sharedWithAll.iterator();
                        while (i.hasNext()) {
                            if (enrl.contains(i.next())) continue;
                            i.remove();
                        }
                        i = notShared.iterator();
                        while (i.hasNext()) {
                            if (!enrl.contains(i.next())) continue;
                            i.remove();
                        }
                        if (!share.isEmpty() && this.count(tc, share) != 0) {
                            int n = row;
                            totalC[n] = totalC[n] + share.size();
                            this.iT.setText(6 + row, 1 + column, CurriculumCookie.getInstance().getCurriculaCoursesPercent() ? NF.format(100.0 * (double)this.count(tc, share) / (double)this.count(tc, thisEnrollment)) + "%" : "" + this.count(tc, share));
                        }
                        ++row;
                    }
                    boolean percent = CurriculumCookie.getInstance().getCurriculaCoursesPercent();
                    if (!sharedWithOneOther.isEmpty() && this.count(tc, sharedWithOneOther) != 0) {
                        this.iT.setText(1, 1 + column, percent ? NF.format(100.0 * (double)this.count(tc, sharedWithOneOther) / (double)this.count(tc, thisEnrollment)) + "%" : "" + this.count(tc, sharedWithOneOther));
                        has1 = true;
                    }
                    if (!sharedWithTwoOther.isEmpty() && this.count(tc, sharedWithTwoOther) != 0) {
                        this.iT.setText(2, 1 + column, percent ? NF.format(100.0 * (double)this.count(tc, sharedWithTwoOther) / (double)this.count(tc, thisEnrollment)) + "%" : "" + this.count(tc, sharedWithTwoOther));
                        has2 = true;
                    }
                    if (!sharedWithThreeOther.isEmpty() && this.count(tc, sharedWithThreeOther) != 0) {
                        this.iT.setText(3, 1 + column, percent ? NF.format(100.0 * (double)this.count(tc, sharedWithThreeOther) / (double)this.count(tc, thisEnrollment)) + "%" : "" + this.count(tc, sharedWithThreeOther));
                        has3 = true;
                    }
                    if (!sharedWithAll.isEmpty() && this.count(tc, sharedWithAll) != 0) {
                        this.iT.setText(4, 1 + column, percent ? NF.format(100.0 * (double)this.count(tc, sharedWithAll) / (double)this.count(tc, thisEnrollment)) + "%" : "" + this.count(tc, sharedWithAll));
                        hasAll = true;
                    }
                    if (!notShared.isEmpty() && this.count(tc, notShared) != 0) {
                        this.iT.setText(5, 1 + column, percent ? NF.format(100.0 * (double)this.count(tc, notShared) / (double)this.count(tc, thisEnrollment)) + "%" : "" + this.count(tc, notShared));
                        hasNone = true;
                    }
                }
                ++column;
            }
            if (!has1 || other.size() == 1) {
                this.iT.getRowFormatter().setVisible(1, false);
            }
            if (!has2 || other.size() == 1) {
                this.iT.getRowFormatter().setVisible(2, false);
            }
            if (!has3 || other.size() == 1) {
                this.iT.getRowFormatter().setVisible(3, false);
            }
            if (!hasAll || other.size() <= 3) {
                this.iT.getRowFormatter().setVisible(4, false);
            }
            if (!hasNone || other.size() == 1) {
                this.iT.getRowFormatter().setVisible(5, false);
            }
            if (other.size() > 1) {
                int minTotal = -1;
                ArrayList<Integer> visible = new ArrayList<Integer>();
                for (row = other.size() - 1; row >= 0; --row) {
                    if (totalC[row] < 1) {
                        this.iT.getRowFormatter().setVisible(6 + row, false);
                        continue;
                    }
                    visible.add(row);
                    if (minTotal >= 0 && minTotal >= totalC[row]) continue;
                    minTotal = totalC[row];
                }
                while (visible.size() > 10) {
                    int limit = minTotal;
                    minTotal = -1;
                    Iterator i = visible.iterator();
                    while (i.hasNext() && visible.size() > 10) {
                        row = (Integer)i.next();
                        if (totalC[row] <= limit) {
                            this.iT.getRowFormatter().setVisible(6 + row, false);
                            i.remove();
                            continue;
                        }
                        if (minTotal >= 0 && minTotal >= totalC[row]) continue;
                        minTotal = totalC[row];
                    }
                }
                if (!visible.isEmpty()) {
                    int r = 6 + (Integer)visible.get(visible.size() - 1);
                    int col = 1;
                    for (int c = 0; c < CurriculaCourses.this.iClassifications.getClassifications().size(); ++c) {
                        if (CurriculaCourses.this.iClassifications.getExpected(c) == null) continue;
                        if (this.iT.getCellCount(r) <= col || this.iT.getText(r, col) == null || this.iT.getText(r, col).isEmpty()) {
                            this.iT.setHTML(r, col, "&nbsp;");
                        }
                        this.iT.getCellFormatter().setStyleName(r, col, "unitime-DashedTop");
                        ++col;
                    }
                }
            }
            this.iCanShow = has1 || has2 || hasAll || hasNone;
        }

        public boolean canShow() {
            return this.iCanShow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Group
    extends Label
    implements Comparable<Group> {
        private String iName;
        private int iType;
        private String iColor;
        private UniTimeTableHeader.Operation iOperation;

        public Group(String name, int type) {
            super(name, false);
            this.iName = name;
            this.iType = type;
            this.setStylePrimaryName("unitime-TinyLabel" + (this.iType == 1 ? "White" : ""));
            if (CurriculaCourses.this.iEditable) {
                this.addClickHandler(CurriculaCourses.this.iNewGroupDialog.getClickHandler());
                this.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            }
            this.iOperation = new UniTimeTableHeader.Operation(){

                public String getName() {
                    return Group.this.getElement().getString();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public boolean isApplicable() {
                    return CurriculaCourses.this.iEditable && CurriculaCourses.this.iVisibleCourses == null;
                }

                public void execute() {
                    CurriculaCourses.this.assignGroup(null, Group.this.iName, Group.this.iType);
                }
            };
        }

        public String getName() {
            return this.iName;
        }

        public int getType() {
            return this.iType;
        }

        public void setType(int type) {
            this.iType = type;
            this.setStylePrimaryName("unitime-TinyLabel" + (this.iType == 1 ? "White" : ""));
        }

        public void setName(String name) {
            this.iName = name;
            this.setText(name);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Group)) {
                return false;
            }
            return this.getName().equals(((Group)o).getName());
        }

        public Group cloneGroup() {
            Group g = new Group(this.iName, this.iType);
            g.setColor(this.getColor());
            return g;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
            this.addStyleName(color);
        }

        @Override
        public int compareTo(Group g) {
            return this.getName().compareTo(g.getName());
        }

        public UniTimeTableHeader.Operation getOperation() {
            return this.iOperation;
        }
    }

    public static class CourseChangedEvent {
        private String iCourseName = null;

        public CourseChangedEvent(String courseName) {
            this.iCourseName = courseName;
        }

        public String getCourseName() {
            return this.iCourseName;
        }
    }

    public class ShareTextBox
    extends UniTimeTextBox {
        private int iColumn;
        private Float iShare;

        public ShareTextBox(int column, Float share) {
            super(6, ValueBoxBase.TextAlignment.RIGHT);
            this.iShare = null;
            this.iColumn = column;
            this.iShare = share;
            this.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    try {
                        if (ShareTextBox.this.getText().isEmpty()) {
                            ShareTextBox.this.iShare = null;
                        } else if (ShareTextBox.this.getText().endsWith("%")) {
                            ShareTextBox.this.iShare = Float.valueOf((float)NF.parse(ShareTextBox.this.getText().substring(0, ShareTextBox.this.getText().length() - 1)) / 100.0f);
                            if (ShareTextBox.this.iShare.floatValue() > 1.0f) {
                                ShareTextBox.this.iShare = Float.valueOf(1.0f);
                            }
                            if (ShareTextBox.this.iShare.floatValue() <= 0.0f) {
                                ShareTextBox.this.iShare = null;
                            }
                        } else {
                            ShareTextBox.this.iShare = Float.valueOf((float)NF.parse(ShareTextBox.this.getText()) / (float)CurriculaCourses.this.iClassifications.getExpected(ShareTextBox.this.iColumn).intValue());
                            if (ShareTextBox.this.iShare.floatValue() > 1.0f) {
                                ShareTextBox.this.iShare = Float.valueOf(1.0f);
                            }
                            if (ShareTextBox.this.iShare.floatValue() <= 0.0f) {
                                ShareTextBox.this.iShare = null;
                            }
                        }
                    }
                    catch (Exception e) {
                        ShareTextBox.this.iShare = null;
                    }
                    ShareTextBox.this.update();
                }
            });
            this.update();
        }

        public void setShare(Float share) {
            this.iShare = share;
            this.update();
        }

        public void setExpected(Integer expected) {
            Integer total;
            this.iShare = expected == null ? null : ((total = CurriculaCourses.this.iClassifications.getExpected(this.iColumn)) == null ? null : Float.valueOf((float)expected.intValue() / (float)total.intValue()));
            this.update();
        }

        public Float getShare() {
            return this.iShare;
        }

        public void update() {
            if (this.iShare == null) {
                this.setText("");
            } else if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                this.setText(NF.format(100.0 * (double)this.iShare.floatValue()) + "%");
            } else {
                Integer exp = CurriculaCourses.this.iClassifications.getExpected(this.iColumn);
                this.setText(exp == null ? MESSAGES.notApplicable() : String.valueOf(Math.round((float)exp.intValue() * this.iShare.floatValue())));
            }
        }
    }

    public class EnrollmentLabel
    extends Label
    implements UniTimeTable.HasCellAlignment {
        private int iColumn;
        private Integer iEnrollment;
        private Integer iLastLike;
        private Integer iProjection;
        private Integer iRequested;

        public EnrollmentLabel(int column, Integer enrollment, Integer lastLike, Integer projection, Integer requested) {
            this.setStyleName("unitime-Label");
            this.iColumn = column;
            this.iEnrollment = enrollment;
            this.iLastLike = lastLike;
            this.iProjection = projection;
            this.iRequested = requested;
            this.update();
        }

        public void update() {
            switch (CurriculumCookie.getInstance().getCurriculaCoursesMode()) {
                case NONE: {
                    this.setText("");
                    break;
                }
                case ENRL: {
                    if (this.iEnrollment == null || this.iEnrollment == 0) {
                        this.setText("");
                        break;
                    }
                    if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                        Integer total = CurriculaCourses.this.iClassifications.getEnrollment(this.iColumn);
                        this.setText(total == null ? MESSAGES.notApplicable() : NF.format(100.0 * (double)this.iEnrollment.intValue() / (double)total.intValue()) + "%");
                        break;
                    }
                    this.setText(this.iEnrollment.toString());
                    break;
                }
                case LAST: {
                    if (this.iLastLike == null || this.iLastLike == 0) {
                        this.setText("");
                        break;
                    }
                    if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                        Integer total = CurriculaCourses.this.iClassifications.getLastLike(this.iColumn);
                        this.setText(total == null ? MESSAGES.notApplicable() : NF.format(100.0 * (double)this.iLastLike.intValue() / (double)total.intValue()) + "%");
                        break;
                    }
                    this.setText(this.iLastLike.toString());
                    break;
                }
                case PROJ: {
                    if (this.iProjection == null || this.iProjection == 0) {
                        this.setText("");
                        break;
                    }
                    if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                        Integer total = CurriculaCourses.this.iClassifications.getProjection(this.iColumn);
                        this.setText(total == null ? MESSAGES.notApplicable() : NF.format(100.0 * (double)this.iProjection.intValue() / (double)total.intValue()) + "%");
                        break;
                    }
                    this.setText(this.iProjection.toString());
                    break;
                }
                case REQ: {
                    if (this.iRequested == null || this.iRequested == 0) {
                        this.setText("");
                        break;
                    }
                    if (CurriculumCookie.getInstance().getCurriculaCoursesPercent()) {
                        Integer total = CurriculaCourses.this.iClassifications.getRequested(this.iColumn);
                        this.setText(total == null ? MESSAGES.notApplicable() : NF.format(100.0 * (double)this.iRequested.intValue() / (double)total.intValue()) + "%");
                        break;
                    }
                    this.setText(this.iRequested.toString());
                }
            }
        }

        public Integer getLastLike() {
            return this.iLastLike == null || this.iLastLike == 0 ? null : this.iLastLike;
        }

        public Integer getEnrollment() {
            return this.iEnrollment == null || this.iEnrollment == 0 ? null : this.iEnrollment;
        }

        public Integer getProjection() {
            return this.iProjection == null || this.iProjection == 0 ? null : this.iProjection;
        }

        public Integer getRequested() {
            return this.iRequested == null || this.iRequested == 0 ? null : this.iRequested;
        }

        public Float getLastLikePercent() {
            if (this.iLastLike == null || this.iLastLike == 0) {
                return null;
            }
            Integer total = CurriculaCourses.this.iClassifications.getLastLike(this.iColumn);
            if (total == null) {
                return null;
            }
            return Float.valueOf((float)this.iLastLike.intValue() / (float)total.intValue());
        }

        public Float getEnrollmentPercent() {
            if (this.iEnrollment == null || this.iEnrollment == 0) {
                return null;
            }
            Integer total = CurriculaCourses.this.iClassifications.getEnrollment(this.iColumn);
            if (total == null) {
                return null;
            }
            return Float.valueOf((float)this.iEnrollment.intValue() / (float)total.intValue());
        }

        public Float getProjectionPercent() {
            if (this.iProjection == null || this.iProjection == 0) {
                return null;
            }
            Integer total = CurriculaCourses.this.iClassifications.getProjection(this.iColumn);
            if (total == null) {
                return null;
            }
            return Float.valueOf((float)this.iProjection.intValue() / (float)total.intValue());
        }

        public Float getRequestedPercent() {
            if (this.iRequested == null || this.iRequested == 0) {
                return null;
            }
            Integer total = CurriculaCourses.this.iClassifications.getRequested(this.iColumn);
            if (total == null) {
                return null;
            }
            return Float.valueOf((float)this.iRequested.intValue() / (float)total.intValue());
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        LAST(MESSAGES.abbvLastLikeEnrollment(), MESSAGES.fieldLastLikeEnrollment()),
        PROJ(MESSAGES.abbvProjectedByRule(), MESSAGES.fieldProjectedByRule()),
        ENRL(MESSAGES.abbvCurrentEnrollment(), MESSAGES.fieldCurrentEnrollment()),
        REQ(MESSAGES.abbvCourseRequests(), MESSAGES.fieldCourseRequests()),
        NONE("&nbsp;", "NONE");

        private String iAbbv;
        private String iName;

        private Mode(String abbv, String name) {
            this.iAbbv = abbv;
            this.iName = name;
        }

        public String getAbbv() {
            return this.iAbbv;
        }

        public String getName() {
            return this.iName;
        }
    }
}

