/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.aria;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Button;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;

public class AriaButton
extends Button
implements HasAriaLabel {
    public AriaButton() {
    }

    public AriaButton(String html) {
        super(html);
        this.setAriaLabel(UniTimeHeaderPanel.stripAccessKey(html).replace("&nbsp;", " ").replace("&#8209;", "-"));
        Character accessKey = UniTimeHeaderPanel.guessAccessKey(html);
        if (accessKey != null) {
            this.setAccessKey(accessKey.charValue());
        }
        ToolBox.setMinWidth(this.getElement().getStyle(), "75px");
    }

    public void setHTML(String html) {
        super.setHTML(html);
        this.setAriaLabel(UniTimeHeaderPanel.stripAccessKey(html));
        Character accessKey = UniTimeHeaderPanel.guessAccessKey(html);
        if (accessKey != null) {
            this.setAccessKey(accessKey.charValue());
        }
    }

    public void setAriaLabel(String text) {
        if (text == null || text.isEmpty()) {
            Roles.getButtonRole().removeAriaLabelledbyProperty((Element)this.getElement());
        } else {
            Roles.getButtonRole().setAriaLabelProperty((Element)this.getElement(), text);
        }
    }

    public String getAriaLabel() {
        return Roles.getButtonRole().getAriaLabelProperty((Element)this.getElement());
    }
}

