/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;
import org.unitime.timetable.util.IdValue;

public class InquiryForm
extends ActionForm {
    private static final long serialVersionUID = -2461671741219768003L;
    private String iOp;
    private String iSubject;
    private String iMessage;
    private int iType;
    private List carbonCopy;
    private String puid = null;
    private boolean iNoRole;
    public static String[] sTypeMsgs = new String[]{Constants.BLANK_OPTION_LABEL, "Ask a question", "Report an error", "Make a suggestion", "Request addition of a time pattern", "Request addition of an exact time", "Request addition of a date pattern", "Request a change of owner on class and/or scheduling subpart", "Request a course cross-listing", "Request a room to be shared", "Request any other administrative change", "LLR/LAB data entry is done", "Other"};
    public static String[] sTypeMsgsNoRole = new String[]{Constants.BLANK_OPTION_LABEL, "Ask a question", "Report an error", "Make a suggestion"};
    public static String[] sDefaultMessage = new String[]{"", "", "", "", "1. Specify the list of classes or scheduling subparts on which the requested time pattern need to be set (e.g., AB 100 Lec 1, AB 100 Lec 2) : \r\n\r\n2. Specify the time pattern (number of meetings and number of minutes per meeting, e.g., 2x75) : \r\n\r\n3. Specify the available days (e.g., MW, WF, MF, TTh) : \r\n\r\n4. Specify the available starting times (e.g., 7:30am, 8:30am, 9:30am, ... 4:30pm) : \r\n", "1. Specify the list of classes on which the requested time pattern need to be set (e.g., AB 100 Lec 1, AB 100 Lec 2) : \r\n\r\n2. Specify the time (e.g., MWF 8:15am - 10:20am) : ", "1. Specify the list of classes or scheduling subparts on which the requested date pattern need to be set (e.g., AB 100 Lec 1, AB 100 Lec 2) : \r\n\r\n2. Specify the list weeks for the date pattern (e.g., Weeks 2-8; alternatively, you can specify start and end date) : \r\n", "1. Specify the list of classes or scheduling subparts on which the requested date pattern need to be set (e.g., AB 100 Lec 1, AB 100 Lec 2) : \r\n\r\n2. Specify the new owner (e.g., LLR) : \r\n", "1. Specify the controlling course (e.g., AB 100) : \r\n\r\n2. Specify courses that should be cross-listed with the controlling course (e.g., CDFS 100) : \r\n", "1. Specify the room that needs to be shared (e.g., GRIS 100) : \r\n\r\n2. Specify the departments between which the room needs to be shared (e.g., 1282-Aeronautics & Astronautics and 1287-Industrial Engineering) : \r\n\r\n3. Specify the times when the room is to be allocated for one of the departments or when the room is not available (e.g., MWF for Aero, TTh for I E, not available after 3:00pm) : \r\n", "", "1. Specify the managing department (e.g., LLR or LAB) : \r\n", ""};
    protected DynamicListObjectFactory factoryEmails = new DynamicListObjectFactory(){

        public Object create() {
            return new String(Constants.BLANK_OPTION_VALUE);
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iType == 0) {
            errors.add("type", new ActionMessage("errors.generic", (Object)"Please specify category of this inquiry:"));
        }
        if (this.iMessage.trim().length() == 0) {
            errors.add("message", new ActionMessage("errors.generic", (Object)"Message is required."));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iSubject = null;
        this.iMessage = null;
        this.iType = 0;
        this.puid = null;
        this.carbonCopy = DynamicList.getInstance(new ArrayList(), this.factoryEmails);
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getSubject() {
        return this.iSubject;
    }

    public void setSubject(String subject) {
        this.iSubject = subject;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public int getType() {
        return this.iType;
    }

    public void setType(int type) {
        this.iType = type;
    }

    public String getTypeMsg(int type) {
        return sTypeMsgs[this.iType];
    }

    public Vector getTypeOptions() {
        Vector<IdValue> ret = new Vector<IdValue>();
        for (int i = 0; i < (this.iNoRole ? sTypeMsgsNoRole : sTypeMsgs).length; ++i) {
            ret.add(new IdValue(new Long(i), (this.iNoRole ? sTypeMsgsNoRole : sTypeMsgs)[i]));
        }
        return ret;
    }

    public void updateMessage() {
        boolean eq = false;
        for (int i = 0; i < sTypeMsgs.length; ++i) {
            if (!sDefaultMessage[i].equals(this.iMessage)) continue;
            eq = true;
        }
        if (!eq) {
            return;
        }
        this.iMessage = sDefaultMessage[this.iType];
    }

    public String getPuid() {
        return this.puid;
    }

    public void setPuid(String puid) {
        this.puid = puid != null && puid.trim().length() == 0 ? null : puid;
    }

    public boolean getNoRole() {
        return this.iNoRole;
    }

    public void setNoRole(boolean noRole) {
        this.iNoRole = noRole;
    }

    public List getCarbonCopy() {
        return this.carbonCopy;
    }

    public void setCarbonCopy(List carbonCopy) {
        this.carbonCopy = carbonCopy;
    }

    public String getCarbonCopy(int key) {
        return this.carbonCopy.get(key).toString();
    }

    public void setCarbonCopy(int key, Object value) {
        this.carbonCopy.set(key, value);
    }

    public void addToCarbonCopy(String carbonCopy) {
        this.carbonCopy.add(carbonCopy);
    }

    public void removeCarbonCopy(int rowNum) {
        if (rowNum >= 0) {
            this.carbonCopy.remove(rowNum);
        }
    }
}

