/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.hibernate.Session;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.FilterBoxBackend;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomTypeOption;
import org.unitime.timetable.model.TravelTime;
import org.unitime.timetable.model.base.BaseRefTableEntry;
import org.unitime.timetable.model.base.BaseRoomFeatureType;
import org.unitime.timetable.model.dao.RoomDAO;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.RoomFilterRpcRequest.class)
public class RoomFilterBackend
extends FilterBoxBackend<EventInterface.RoomFilterRpcRequest> {
    private DistanceMetric iMetrics;
    private static double EPSILON = 1.0E-6;
    private static DecimalFormat sCDF = new DecimalFormat("0.000000");
    private static DecimalFormat sNF = new DecimalFormat("0000");

    @Override
    public void load(EventInterface.RoomFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        Set<String> departments = request.getOptions("department");
        HashSet userDepts = null;
        if (request.hasOption("user")) {
            userDepts = new HashSet(TimetableManagerDAO.getInstance().getSession().createQuery("select d.uniqueId from TimetableManager m inner join m.departments d where m.externalUniqueId = :user and d.session.uniqueId = :sessionId").setLong("sessionId", request.getSessionId().longValue()).setString("user", request.getOption("user")).setCacheable(true).list());
        }
        this.fixRoomFeatureTypes(request);
        HashMap<Long, Iterator<Location>> types = new HashMap<Long, Iterator<Location>>();
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, "type")) {
            Object type = (EventInterface.FilterRpcResponse.Entity)types.get(location.getRoomType().getUniqueId());
            if (type == null) {
                type = new EventInterface.FilterRpcResponse.Entity(location.getRoomType().getUniqueId(), location.getRoomType().getReference(), location.getRoomType().getLabel(), "order", sNF.format(location.getRoomType().getOrd()));
                types.put(((EventInterface.FilterRpcResponse.Entity)type).getUniqueId(), (Iterator<Location>)type);
            }
            ((EventInterface.FilterRpcResponse.Entity)type).incCount();
        }
        response.add("type", new TreeSet<EventInterface.FilterRpcResponse.Entity>(types.values()));
        HashMap featuresByType = new HashMap();
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, null)) {
            for (RoomFeature roomFeature : location.getFeatures()) {
                EventInterface.FilterRpcResponse.Entity feature;
                if (!(roomFeature instanceof GlobalRoomFeature) && (!(roomFeature instanceof DepartmentRoomFeature) || departments == null || !departments.contains(((DepartmentRoomFeature)roomFeature).getDepartment().getDeptCode())) || roomFeature.getFeatureType() != null && !roomFeature.getFeatureType().isShowInEventManagement().booleanValue()) continue;
                String type = roomFeature.getFeatureType() == null ? "feature" : roomFeature.getFeatureType().getReference();
                HashMap<Long, EventInterface.FilterRpcResponse.Entity> features = (HashMap<Long, EventInterface.FilterRpcResponse.Entity>)featuresByType.get(type);
                if (features == null) {
                    features = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
                    featuresByType.put(type, features);
                }
                if ((feature = (EventInterface.FilterRpcResponse.Entity)features.get(roomFeature.getUniqueId())) == null) {
                    feature = new EventInterface.FilterRpcResponse.Entity(roomFeature.getUniqueId(), roomFeature.getAbbv(), roomFeature.getLabel(), new String[0]);
                    features.put(feature.getUniqueId(), feature);
                }
                feature.incCount();
            }
        }
        for (Object type : new TreeSet(featuresByType.keySet())) {
            response.add(((String)type).replace(' ', '_'), new TreeSet<EventInterface.FilterRpcResponse.Entity>(((Map)featuresByType.get(type)).values()));
        }
        HashMap<Long, EventInterface.FilterRpcResponse.Entity> hashMap = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, "group")) {
            for (RoomGroup rg : location.getRoomGroups()) {
                if (!rg.isGlobal().booleanValue() && (departments == null || !departments.contains(rg.getDepartment().getDeptCode()))) continue;
                EventInterface.FilterRpcResponse.Entity group = (EventInterface.FilterRpcResponse.Entity)hashMap.get(rg.getUniqueId());
                if (group == null) {
                    group = new EventInterface.FilterRpcResponse.Entity(rg.getUniqueId(), rg.getAbbv(), rg.getName(), new String[0]);
                    hashMap.put(group.getUniqueId(), group);
                }
                group.incCount();
            }
        }
        response.add("group", new TreeSet<EventInterface.FilterRpcResponse.Entity>(hashMap.values()));
        HashMap<Long, EventInterface.FilterRpcResponse.Entity> buildings = new HashMap<Long, EventInterface.FilterRpcResponse.Entity>();
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, "building")) {
            if (!(location instanceof Room)) continue;
            Room room = (Room)location;
            EventInterface.FilterRpcResponse.Entity building = (EventInterface.FilterRpcResponse.Entity)buildings.get(room.getBuilding().getUniqueId());
            if (building == null) {
                building = new EventInterface.FilterRpcResponse.Entity(room.getBuilding().getUniqueId(), room.getBuilding().getAbbreviation(), room.getBuilding().getAbbrName(), new String[0]);
                buildings.put(building.getUniqueId(), building);
            }
            building.incCount();
        }
        response.add("building", new TreeSet<EventInterface.FilterRpcResponse.Entity>(buildings.values()));
        EventInterface.FilterRpcResponse.Entity entity = new EventInterface.FilterRpcResponse.Entity(-2L, "Managed", "Managed Rooms", new String[0]);
        EventInterface.FilterRpcResponse.Entity entity2 = new EventInterface.FilterRpcResponse.Entity(-3L, "Final", "Final Examination Rooms", new String[0]);
        EventInterface.FilterRpcResponse.Entity examMidterm = new EventInterface.FilterRpcResponse.Entity(-4L, "Midterm", "Midterm Examination Rooms", new String[0]);
        HashMap<Long, Object> depts = new HashMap<Long, Object>();
        boolean eventRooms = request.hasOptions("flag") && (request.getOptions("flag").contains("event") || request.getOptions("flag").contains("Event"));
        boolean allRooms = request.hasOptions("flag") && (request.getOptions("flag").contains("all") || request.getOptions("flag").contains("All"));
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), null, -1, null, "department")) {
            Object department;
            Department evtDept = location.getEventDepartment() != null && location.getEventDepartment().isAllowEvents() != false ? location.getEventDepartment() : null;
            boolean isManaged = false;
            if (eventRooms) {
                department = (EventInterface.FilterRpcResponse.Entity)depts.get(location.getEventDepartment().getUniqueId());
                if (department == null) {
                    department = new EventInterface.FilterRpcResponse.Entity(location.getEventDepartment().getUniqueId(), location.getEventDepartment().getDeptCode(), location.getEventDepartment().getDeptCode() + " - " + location.getEventDepartment().getName(), new String[0]);
                    depts.put(((EventInterface.FilterRpcResponse.Entity)department).getUniqueId(), department);
                }
                ((EventInterface.FilterRpcResponse.Entity)department).incCount();
                if (userDepts != null && userDepts.contains(location.getEventDepartment().getUniqueId())) {
                    isManaged = true;
                }
            } else {
                for (RoomDept rd : location.getRoomDepts()) {
                    EventInterface.FilterRpcResponse.Entity department2;
                    if (evtDept != null && rd.getDepartment().equals(evtDept)) {
                        evtDept = null;
                    }
                    if ((department2 = (EventInterface.FilterRpcResponse.Entity)depts.get(rd.getDepartment().getUniqueId())) == null) {
                        department2 = new EventInterface.FilterRpcResponse.Entity(rd.getDepartment().getUniqueId(), rd.getDepartment().getDeptCode(), rd.getDepartment().getDeptCode() + " - " + rd.getDepartment().getName() + (rd.getDepartment().isExternalManager() != false ? " (" + rd.getDepartment().getExternalMgrLabel() + ")" : ""), new String[0]);
                        depts.put(department2.getUniqueId(), department2);
                    }
                    department2.incCount();
                    if (userDepts == null || !userDepts.contains(rd.getDepartment().getUniqueId())) continue;
                    isManaged = true;
                }
                if (evtDept != null && allRooms) {
                    department = (EventInterface.FilterRpcResponse.Entity)depts.get(evtDept.getUniqueId());
                    if (department == null) {
                        department = new EventInterface.FilterRpcResponse.Entity(evtDept.getUniqueId(), evtDept.getDeptCode(), evtDept.getDeptCode() + " - " + evtDept.getName() + (evtDept.isExternalManager() != false ? " (" + evtDept.getExternalMgrLabel() + ")" : ""), new String[0]);
                        depts.put(((EventInterface.FilterRpcResponse.Entity)department).getUniqueId(), department);
                    }
                    ((EventInterface.FilterRpcResponse.Entity)department).incCount();
                }
            }
            if (location.hasFinalExamsEnabled()) {
                entity2.incCount();
            }
            if (location.hasMidtermExamsEnabled()) {
                examMidterm.incCount();
            }
            if (!isManaged) continue;
            entity.incCount();
        }
        if (entity.getCount() > 0) {
            response.add("department", entity);
        }
        if (entity2.getCount() > 0) {
            response.add("department", entity2);
        }
        if (examMidterm.getCount() > 0) {
            response.add("department", examMidterm);
        }
        response.add("department", new TreeSet<EventInterface.FilterRpcResponse.Entity>(depts.values()));
    }

    private void fixRoomFeatureTypes(EventInterface.RoomFilterRpcRequest request) {
        for (RoomFeatureType type : RoomFeatureTypeDAO.getInstance().findAll()) {
            if (!type.isShowInEventManagement().booleanValue() || !request.hasOptions(type.getReference().replace(' ', '_'))) continue;
            for (String option : request.getOptions(type.getReference().replace(' ', '_'))) {
                request.addOption("feature", option);
            }
        }
    }

    public List<Location> locations(Long sessionId, EventInterface.RoomFilterRpcRequest filter, int limit, Map<Long, Double> room2distance) {
        this.fixRoomFeatureTypes(filter);
        return this.locations(sessionId, filter.getOptions(), new Query(filter.getText()), 1000, room2distance, null);
    }

    /*
     * WARNING - void declaration
     */
    private List<Location> locations(Long sessionId, Map<String, Set<String>> options, Query query, int limit, Map<Long, Double> room2distance, String ignoreCommand) {
        Hashtable<Long, void> distances;
        boolean allRooms;
        Session hibSession = RoomDAO.getInstance().getSession();
        Set<String> type = options == null || "type".equals(ignoreCommand) ? null : options.get("type");
        Set<String> feature = options == null || "feature".equals(ignoreCommand) ? null : options.get("feature");
        Set<String> group = options == null || "group".equals(ignoreCommand) ? null : options.get("group");
        Set<String> building = options == null || "building".equals(ignoreCommand) ? null : options.get("building");
        Set<String> department = options == null || "department".equals(ignoreCommand) ? null : options.get("department");
        Set<String> groupFeaturedept = options == null ? null : options.get("department");
        Set<String> size = options == null || "size".equals(ignoreCommand) ? null : options.get("size");
        Set<String> flag = options == null || "flag".equals(ignoreCommand) ? null : options.get("flag");
        Set<String> user = options == null || "user".equals(ignoreCommand) ? null : options.get("user");
        Set<String> ids = options == null || "id".equals(ignoreCommand) ? null : options.get("id");
        int min = 0;
        int max = Integer.MAX_VALUE;
        boolean nearby = flag != null && (flag.contains("nearby") || flag.contains("Nearby"));
        boolean eventRooms = flag != null && (flag.contains("event") || flag.contains("Event"));
        boolean bl = allRooms = flag != null && (flag.contains("all") || flag.contains("All"));
        if (size != null && !size.isEmpty()) {
            Size prefix = Size.eq;
            String number = size.iterator().next();
            if (number.startsWith("<=")) {
                prefix = Size.le;
                number = number.substring(2);
            } else if (number.startsWith(">=")) {
                prefix = Size.ge;
                number = number.substring(2);
            } else if (number.startsWith("<")) {
                prefix = Size.lt;
                number = number.substring(1);
            } else if (number.startsWith(">")) {
                prefix = Size.gt;
                number = number.substring(1);
            } else if (number.startsWith("=")) {
                prefix = Size.eq;
                number = number.substring(1);
            }
            try {
                int a = Integer.parseInt(number);
                switch (prefix) {
                    case eq: {
                        min = max = a;
                        break;
                    }
                    case le: {
                        max = a;
                        break;
                    }
                    case ge: {
                        min = a;
                        break;
                    }
                    case lt: {
                        max = a - 1;
                        break;
                    }
                    case gt: {
                        min = a + 1;
                    }
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (number.contains("..")) {
                try {
                    String a = number.substring(0, number.indexOf(46));
                    String b = number.substring(number.indexOf("..") + 2);
                    min = Integer.parseInt(a);
                    max = Integer.parseInt(b);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        List locations = null;
        locations = department != null && department.contains("Managed") && user != null && !user.isEmpty() ? hibSession.createQuery("select distinct l from Location l" + (eventRooms ? " inner join l.eventDepartment.timetableManagers m" : " inner join l.roomDepts rd inner join rd.department.timetableManagers m") + (group != null && !group.isEmpty() ? " left join fetch l.roomGroups g" : "") + (feature != null && !feature.isEmpty() ? " left join fetch l.features f" : "") + (department.contains("Final") || department.contains("Midterm") ? " left join fetch l.examTypes x" : "") + (eventRooms ? " ,RoomTypeOption o" : "") + " where l.session.uniqueId = :sessionId and m.externalUniqueId = :user" + (eventRooms ? " and l.eventDepartment.allowEvents = true and ((l.eventStatus is null and o.status != 0 and o.roomType = l.roomType and o.department = l.eventDepartment) or l.eventStatus != 0)" : "")).setLong("sessionId", sessionId.longValue()).setString("user", user.iterator().next()).setCacheable(true).list() : hibSession.createQuery("select distinct l from Location l" + (department != null && !department.isEmpty() ? (department.contains("Final") || department.contains("Midterm") ? " left join fetch l.examTypes x" : " left join fetch l.roomDepts rd") : "") + (group != null && !group.isEmpty() ? " left join fetch l.roomGroups g" : "") + (feature != null && !feature.isEmpty() ? " left join fetch l.features f" : "") + (eventRooms ? " ,RoomTypeOption o" : "") + " where l.session.uniqueId = :sessionId" + (eventRooms ? " and l.eventDepartment.allowEvents = true and ((l.eventStatus is null and o.status != 0 and o.roomType = l.roomType and o.department = l.eventDepartment) or l.eventStatus != 0)" : "")).setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        HashSet<String> featureTypes = new HashSet<String>();
        for (Object ft : RoomFeatureTypeDAO.getInstance().findAll()) {
            if (!((BaseRoomFeatureType)ft).isShowInEventManagement().booleanValue()) continue;
            featureTypes.add(((BaseRefTableEntry)ft).getReference().toLowerCase().replace(' ', '_'));
        }
        ArrayList<Location> ret = new ArrayList<Location>();
        block12: for (Location location : locations) {
            if (ids != null && !ids.isEmpty() && !ids.contains(location.getUniqueId().toString()) || size != null && !size.isEmpty() && (location.getCapacity() < min || location.getCapacity() > max) || query != null && !query.match(new LocationMatcher(location, featureTypes)) || type != null && !type.isEmpty() && !type.contains(location.getRoomType().getLabel()) || building != null && !building.isEmpty() && (!(location instanceof Room) || !building.contains(((Room)location).getBuilding().getAbbreviation()))) continue;
            if (feature != null && !feature.isEmpty()) {
                for (String string : feature) {
                    boolean found = false;
                    for (RoomFeature roomFeature : location.getFeatures()) {
                        if (roomFeature instanceof GlobalRoomFeature) {
                            if (!string.equals(roomFeature.getLabel())) continue;
                            found = true;
                            break;
                        }
                        if (!(roomFeature instanceof DepartmentRoomFeature) || groupFeaturedept == null || groupFeaturedept.isEmpty() || !string.equals(roomFeature.getLabel()) || !groupFeaturedept.contains(((DepartmentRoomFeature)roomFeature).getDepartment().getDeptCode())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    continue block12;
                }
            }
            if (group != null && !group.isEmpty()) {
                boolean found = false;
                for (RoomGroup rg : location.getRoomGroups()) {
                    if (rg.isGlobal().booleanValue()) {
                        if (!group.contains(rg.getName())) continue;
                        found = true;
                        break;
                    }
                    if (groupFeaturedept == null || groupFeaturedept.isEmpty() || !group.contains(rg.getName()) || !groupFeaturedept.contains(rg.getDepartment().getDeptCode())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (department != null && !department.isEmpty()) {
                if (department.contains("Final")) {
                    if (!location.hasFinalExamsEnabled()) {
                        continue;
                    }
                } else if (department.contains("Midterm")) {
                    if (!location.hasMidtermExamsEnabled()) {
                        continue;
                    }
                } else if (!department.contains("Managed")) {
                    boolean found = false;
                    if ((eventRooms || allRooms) && location.getEventDepartment() != null && location.getEventDepartment().isAllowEvents().booleanValue() && department.contains(location.getEventDepartment().getDeptCode())) {
                        found = true;
                    }
                    if (!found && !eventRooms) {
                        for (RoomDept rd : location.getRoomDepts()) {
                            if (!department.contains(rd.getDepartment().getDeptCode())) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) continue;
                }
            }
            ret.add(location);
        }
        Hashtable<Long, void> hashtable = distances = room2distance == null ? new Hashtable<Long, void>() : room2distance;
        if (nearby && building != null && !building.isEmpty() && (limit <= 0 || ret.size() < limit)) {
            double allowedDistance = ApplicationProperty.EventNearByDistance.doubleValue();
            HashSet<Coordinates> hashSet = new HashSet<Coordinates>();
            for (Location location : ret) {
                hashSet.add(new Coordinates(location));
            }
            String buildingOnlyFilter = "";
            for (String string : building) {
                buildingOnlyFilter = buildingOnlyFilter + (buildingOnlyFilter.isEmpty() ? "" : " or ") + "b.abbreviation = '" + string + "'";
            }
            if (hashSet.isEmpty()) {
                for (Building building2 : hibSession.createQuery("select b from Building b where b.session.uniqueId = :sessionId and (" + buildingOnlyFilter + ")").setLong("sessionId", sessionId.longValue()).list()) {
                    hashSet.add(new Coordinates(-building2.getUniqueId().longValue(), building2.getCoordinateX(), building2.getCoordinateY()));
                }
            }
            if (!hashSet.isEmpty()) {
                block20: for (Location location : locations) {
                    void var34_62;
                    if (ids != null && !ids.isEmpty() && !ids.contains(location.getUniqueId().toString()) || building != null && !building.isEmpty() && location instanceof Room && building.contains(((Room)location).getBuilding().getAbbreviation()) || size != null && !size.isEmpty() && (location.getCapacity() < min || location.getCapacity() > max) || query != null && !query.match(new LocationMatcher(location, featureTypes)) || type != null && !type.isEmpty() && !type.contains(location.getRoomType().getLabel())) continue;
                    if (feature != null && !feature.isEmpty()) {
                        for (String string : feature) {
                            boolean found = false;
                            for (RoomFeature rf : location.getFeatures()) {
                                if (rf instanceof GlobalRoomFeature) {
                                    if (!string.equals(rf.getLabel())) continue;
                                    found = true;
                                    break;
                                }
                                if (!(rf instanceof DepartmentRoomFeature) || groupFeaturedept == null || groupFeaturedept.isEmpty() || !groupFeaturedept.contains(((DepartmentRoomFeature)rf).getDepartment().getDeptCode()) || !string.equals(rf.getLabel())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            continue block20;
                        }
                    }
                    if (group != null && !group.isEmpty()) {
                        boolean found = false;
                        for (RoomGroup rg : location.getRoomGroups()) {
                            if (rg.isGlobal().booleanValue()) {
                                if (!group.contains(rg.getName())) continue;
                                found = true;
                                break;
                            }
                            if (groupFeaturedept == null || groupFeaturedept.isEmpty() || !groupFeaturedept.contains(rg.getDepartment().getDeptCode()) || !group.contains(rg.getName())) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    if (department != null && !department.isEmpty()) {
                        if (department.contains("Final")) {
                            if (!location.hasFinalExamsEnabled()) {
                                continue;
                            }
                        } else if (department.contains("Midterm")) {
                            if (!location.hasMidtermExamsEnabled()) {
                                continue;
                            }
                        } else if (!department.contains("Managed")) {
                            boolean found = false;
                            if ((eventRooms || allRooms) && location.getEventDepartment() != null && location.getEventDepartment().isAllowEvents().booleanValue() && department.contains(location.getEventDepartment().getDeptCode())) {
                                found = true;
                            }
                            if (!found && !eventRooms) {
                                for (RoomDept rd : location.getRoomDepts()) {
                                    if (!department.contains(rd.getDepartment().getDeptCode())) continue;
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) continue;
                        }
                    }
                    Coordinates c = new Coordinates(location);
                    Object var34_61 = null;
                    for (Coordinates x : hashSet) {
                        double d = c.distance(x);
                        if (var34_62 != null && !(var34_62.doubleValue() > d)) continue;
                        Double d2 = d;
                    }
                    if (var34_62 == null || !(var34_62.doubleValue() <= allowedDistance)) continue;
                    ret.add(location);
                    if (distances == null) continue;
                    distances.put(location.getUniqueId(), var34_62);
                }
            }
        }
        final boolean sortBySize = size != null && !size.isEmpty();
        Collections.sort(ret, new Comparator<Location>(){

            @Override
            public int compare(Location l1, Location l2) {
                int cmp;
                Double d1 = (Double)distances.get(l1.getUniqueId());
                Double d2 = (Double)distances.get(l2.getUniqueId());
                if (d1 == null && d2 != null) {
                    return -1;
                }
                if (d1 != null && d2 == null) {
                    return 1;
                }
                if (d1 != null && (cmp = new Long(Math.round(d1)).compareTo(Math.round(d2))) != 0) {
                    return cmp;
                }
                if (sortBySize && (cmp = new Integer(l1.getCapacity() != null ? l1.getCapacity() : Integer.MAX_VALUE).compareTo(l2.getCapacity() != null ? l2.getCapacity() : Integer.MAX_VALUE)) != 0) {
                    return cmp;
                }
                return l1.getLabel().compareTo(l2.getLabel());
            }
        });
        return limit <= 0 || ret.size() < limit ? ret : ret.subList(0, limit);
    }

    private String suggestionQuery(String query) {
        if (query == null || query.isEmpty()) {
            return query;
        }
        if (!query.contains(":") && !query.contains("\"")) {
            return "starts:\"" + query + "\"";
        }
        return query;
    }

    @Override
    public void suggestions(EventInterface.RoomFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        this.fixRoomFeatureTypes(request);
        HashMap<Long, Double> distances = new HashMap<Long, Double>();
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), new Query(this.suggestionQuery(request.getText())), 20, distances, null)) {
            String hint = location.getRoomTypeLabel() + ", " + location.getCapacity() + " seats";
            Double dist = (Double)distances.get(location.getUniqueId());
            if (dist != null) {
                hint = hint + ", " + Math.round(dist) + " m";
            }
            response.addSuggestion(location.getLabel(), location.getLabel(), "(" + hint + ")");
        }
    }

    @Override
    public void enumarate(EventInterface.RoomFilterRpcRequest request, EventInterface.FilterRpcResponse response, EventAction.EventContext context) {
        this.fixRoomFeatureTypes(request);
        HashMap<Long, Double> distances = new HashMap<Long, Double>();
        for (Location location : this.locations(request.getSessionId(), request.getOptions(), new Query(request.getText()), -1, distances, null)) {
            Double dist = (Double)distances.get(location.getUniqueId());
            response.addResult(new EventInterface.FilterRpcResponse.Entity(location.getUniqueId(), location.getDisplayName(), location.getLabel(), "permId", location.getPermanentId().toString(), "type", location.getRoomType().getLabel(), "capacity", location.getCapacity().toString(), "distance", String.valueOf(dist == null ? 0L : Math.round(dist)), "overbook", context.hasPermission(location, Right.EventLocationOverbook) ? "1" : "0", "breakTime", String.valueOf(location.getEffectiveBreakTime()), "message", location.getEventMessage(), "ignoreRoomCheck", location.isIgnoreRoomCheck() != false ? "1" : "0"));
        }
    }

    public DistanceMetric getDistanceMetric() {
        if (this.iMetrics == null) {
            DataProperties config = new DataProperties();
            config.setProperty("Distances.Ellipsoid", ApplicationProperty.DistanceEllipsoid.value());
            config.setProperty("Distances.Speed", ApplicationProperty.EventDistanceSpeed.value());
            this.iMetrics = new DistanceMetric(new DataProperties((Properties)config));
            TravelTime.populateTravelTimes(this.iMetrics);
        }
        return this.iMetrics;
    }

    public static String toCommand(String label) {
        String ret = "";
        for (String word : label.toLowerCase().split(" ")) {
            ret = ret.isEmpty() || word.length() <= 1 ? ret + word : ret + word.substring(0, 1).toUpperCase() + word.substring(1);
        }
        return ret;
    }

    public static void main(String[] args) {
        String s = "TOto je divny Test ale mOOC d iv  n y T es T 5";
        System.out.println(RoomFilterBackend.toCommand(s));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LocationMatcher
    implements Query.TermMatcher {
        private Location iLocation;
        private Set<String> iFeatureTypes = null;

        LocationMatcher(Location location, Set<String> featureTypes) {
            this.iLocation = location;
            this.iFeatureTypes = featureTypes;
        }

        public Location getLocation() {
            return this.iLocation;
        }

        @Override
        public boolean match(String attr, String term) {
            if (attr == null || attr.isEmpty()) {
                return term.isEmpty() || this.has(this.getLocation().getLabel(), term) || this.has(this.getLocation().getDisplayName(), term);
            }
            if ("feature".equals(attr) || this.iFeatureTypes != null && this.iFeatureTypes.contains(attr.toLowerCase())) {
                for (RoomFeature rf : this.getLocation().getFeatures()) {
                    if (!(rf instanceof GlobalRoomFeature) || !this.eq(rf.getAbbv(), term) && !this.has(rf.getLabel(), term)) continue;
                    return true;
                }
                return false;
            }
            if ("group".equals(attr)) {
                for (RoomGroup rg : this.getLocation().getRoomGroups()) {
                    if (!rg.isGlobal().booleanValue() || !this.eq(rg.getAbbv(), term) && !this.has(rg.getName(), term)) continue;
                    return true;
                }
                return false;
            }
            if ("type".equals(attr)) {
                return this.eq(this.getLocation().getRoomType().getReference(), term) || this.has(this.getLocation().getRoomType().getLabel(), term);
            }
            if ("room".equals(attr)) {
                return this.has(this.getLocation().getLabel(), term) || this.has(this.getLocation().getDisplayName(), term);
            }
            if ("starts".equals(attr)) {
                return this.getLocation().getLabel().toLowerCase().startsWith(term.toLowerCase()) || this.getLocation() instanceof Room && ((Room)this.getLocation()).getRoomNumber().toLowerCase().startsWith(term.toLowerCase());
            }
            if ("contains".equals(attr)) {
                return this.getLocation().getLabel().toLowerCase().contains(term.toLowerCase()) || this.getLocation() instanceof Room && ((Room)this.getLocation()).getRoomNumber().toLowerCase().contains(term.toLowerCase());
            }
            if ("building".equals(attr) || "bldg".equals(attr)) {
                if (this.getLocation() instanceof Room) {
                    Building building = ((Room)this.getLocation()).getBuilding();
                    return this.eq(building.getAbbreviation(), term) || this.has(building.getName(), term);
                }
                return false;
            }
            if ("size".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                Size prefix = Size.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = Size.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = Size.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = Size.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = Size.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = Size.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                return min <= this.getLocation().getCapacity() && this.getLocation().getCapacity() <= max;
            }
            if ("flag".equals(attr) && "event".equalsIgnoreCase(term)) {
                return this.getLocation().getEventDepartment() != null && this.getLocation().getEventDepartment().isAllowEvents() != false && this.getLocation().getEffectiveEventStatus() != RoomTypeOption.Status.NoEventManagement;
            }
            if ("department".equals(attr) || "dept".equals(attr) || "event".equals(attr) || "control".equals(attr)) {
                if ("midterm".equalsIgnoreCase(term)) {
                    return this.getLocation().hasMidtermExamsEnabled();
                }
                if ("final".equalsIgnoreCase(term)) {
                    return this.getLocation().hasFinalExamsEnabled();
                }
                if ("event".equalsIgnoreCase(term)) {
                    return this.getLocation().getEventDepartment() != null && this.getLocation().getEventDepartment().isAllowEvents() != false && this.getLocation().getEffectiveEventStatus() != RoomTypeOption.Status.NoEventManagement;
                }
                if ("managed".equals(term)) {
                    return false;
                }
                if (!"control".equals(attr) && this.getLocation().getEventDepartment() != null && (this.eq(this.getLocation().getEventDepartment().getDeptCode(), term) || this.eq(this.getLocation().getEventDepartment().getAbbreviation(), term) || this.has(this.getLocation().getEventDepartment().getName(), term))) {
                    return true;
                }
                if (!"event".equals(attr)) {
                    for (RoomDept rd : this.getLocation().getRoomDepts()) {
                        if ("control".equals(attr) && !rd.isControl().booleanValue() || !this.eq(rd.getDepartment().getDeptCode(), term) && !this.eq(rd.getDepartment().getAbbreviation(), term) && !this.has(rd.getDepartment().getName(), term) && (!rd.getDepartment().isExternalManager().booleanValue() || !this.eq(rd.getDepartment().getExternalMgrAbbv(), term) && !this.has(rd.getDepartment().getExternalMgrLabel(), term))) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }
    }

    public class Coordinates {
        Long iId;
        Double iX;
        Double iY;

        public Coordinates(Long id, Double x, Double y) {
            this.iId = id;
            this.iX = x;
            this.iY = y;
        }

        public Coordinates(Location location) {
            this.iId = location.getUniqueId();
            this.iX = location.getCoordinateX();
            this.iY = location.getCoordinateY();
        }

        public Long id() {
            return this.iId;
        }

        public Double x() {
            return this.iX;
        }

        public Double y() {
            return this.iY;
        }

        public boolean hasCoordinates() {
            return this.iX != null && this.iY != null;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Coordinates)) {
                return false;
            }
            Coordinates c = (Coordinates)o;
            if (!this.hasCoordinates()) {
                return !c.hasCoordinates();
            }
            if (!c.hasCoordinates()) {
                return false;
            }
            return Math.abs(c.x() - this.x()) < EPSILON && Math.abs(c.y() - this.y()) < EPSILON;
        }

        public double distance(Coordinates c) {
            return this.hasCoordinates() && c.hasCoordinates() ? RoomFilterBackend.this.getDistanceMetric().getDistanceInMeters(this.id(), this.x(), this.y(), c.id(), c.x(), c.y()) : Double.POSITIVE_INFINITY;
        }

        public double distance(Location location) {
            return this.distance(new Coordinates(location));
        }

        public String toString() {
            return this.hasCoordinates() ? sCDF.format(this.iX) + "," + sCDF.format(this.iY) : "";
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Size {
        eq,
        lt,
        gt,
        le,
        ge;

    }
}

