/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.client.events.AcademicSessionSelectionBox;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.base.BaseSession;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.UniTimeUserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=AcademicSessionSelectionBox.ListAcademicSessions.class)
public class ListAcademicSessions
implements GwtRpcImplementation<AcademicSessionSelectionBox.ListAcademicSessions, GwtRpcResponseList<AcademicSessionSelectionBox.AcademicSession>> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public GwtRpcResponseList<AcademicSessionSelectionBox.AcademicSession> execute(AcademicSessionSelectionBox.ListAcademicSessions command, SessionContext context) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        org.hibernate.Session hibSession = SessionDAO.getInstance().getSession();
        Session selected = null;
        if (command.hasTerm()) {
            try {
                selected = ListAcademicSessions.findSession(hibSession, command.getTerm());
            }
            catch (GwtRpcException e) {}
        } else {
            Long sessionId;
            Long l = sessionId = context.isAuthenticated() && context.getUser().getCurrentAuthority() != null ? context.getUser().getCurrentAcademicSessionId() : null;
            if (sessionId != null) {
                selected = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
            }
        }
        if (selected == null) {
            try {
                selected = ListAcademicSessions.findSession(hibSession, "current");
            }
            catch (GwtRpcException e) {
                // empty catch block
            }
        }
        TreeSet<Session> sessions = new TreeSet<Session>();
        for (Object session : hibSession.createQuery("select s from Session s").list()) {
            if (((BaseSession)session).getStatusType() == null || ((BaseSession)session).getStatusType().isTestSession() || !context.hasPermissionAnyAuthority(Right.Events, new SimpleQualifier("Session", ((BasePreferenceGroup)session).getUniqueId()))) continue;
            sessions.add((Session)session);
        }
        if (sessions.isEmpty()) {
            throw new GwtRpcException(MESSAGES.noSessionAvailable());
        }
        if (selected == null || !sessions.contains(selected)) {
            selected = UniTimeUserContext.defaultSession(sessions, null);
        }
        if (selected == null) {
            selected = sessions.last();
        }
        if (!command.hasTerm() && !context.hasPermissionAnyAuthority((Object)selected, Right.EventAddSpecial, new Qualifiable[0])) {
            Session defaultSession;
            TreeSet<Session> preferred = new TreeSet<Session>();
            for (Session session : sessions) {
                if (!context.hasPermissionAnyAuthority((Object)session, Right.EventAddSpecial, new SimpleQualifier("Session", session.getUniqueId()))) continue;
                preferred.add(session);
            }
            if (!preferred.isEmpty() && (defaultSession = UniTimeUserContext.defaultSession(preferred, null)) != null) {
                selected = defaultSession;
            }
        }
        GwtRpcResponseList<AcademicSessionSelectionBox.AcademicSession> ret = new GwtRpcResponseList<AcademicSessionSelectionBox.AcademicSession>();
        for (Session session : sessions) {
            AcademicSessionSelectionBox.AcademicSession acadSession = new AcademicSessionSelectionBox.AcademicSession(session.getUniqueId(), session.getLabel(), session.getAcademicTerm() + session.getAcademicYear() + session.getAcademicInitiative(), df.format(session.getEventBeginDate()) + " - " + df.format(session.getEventEndDate()), session.equals(selected));
            if (session.getStatusType().canNoRoleReportClass() && Solution.hasTimetable(session.getUniqueId())) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.HasClasses);
            }
            if (session.getStatusType().canNoRoleReportExamFinal() && Exam.hasTimetable(session.getUniqueId(), 0)) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.HasFinalExams);
            }
            if (session.getStatusType().canNoRoleReportExamMidterm() && Exam.hasTimetable(session.getUniqueId(), 1)) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.HasMidtermExams);
            }
            if (context.hasPermissionAnyAuthority((Object)session, Right.Events, new SimpleQualifier("Session", session.getUniqueId()))) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.HasEvents);
            }
            if (context.hasPermissionAnyAuthority((Object)session, Right.EventAddSpecial, new SimpleQualifier("Session", session.getUniqueId()))) {
                acadSession.set(AcademicSessionSelectionBox.AcademicSession.Flag.CanAddEvents);
            }
            BasePreferenceGroup prev = null;
            BasePreferenceGroup next = null;
            for (Session s : sessions) {
                if (s.getUniqueId().equals(session.getUniqueId()) || !s.getAcademicInitiative().equals(session.getAcademicInitiative())) continue;
                if (s.getSessionEndDateTime().before(session.getSessionBeginDateTime())) {
                    if (prev != null && !((BaseSession)prev).getSessionBeginDateTime().before(s.getSessionBeginDateTime())) continue;
                    prev = s;
                    continue;
                }
                if (!s.getSessionBeginDateTime().after(session.getSessionEndDateTime()) || next != null && !((BaseSession)next).getSessionBeginDateTime().after(s.getSessionBeginDateTime())) continue;
                next = s;
            }
            if (next != null) {
                acadSession.setNextId(next.getUniqueId());
            }
            if (prev != null) {
                acadSession.setPreviousId(prev.getUniqueId());
            }
            ret.add(acadSession);
        }
        return ret;
    }

    public static Session findSession(org.hibernate.Session hibSession, String term) {
        try {
            Session ret = (Session)SessionDAO.getInstance().get(Long.parseLong(term), hibSession);
            if (ret != null) {
                return ret;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        List sessions = hibSession.createQuery("select s from Session s where s.academicTerm || s.academicYear = :term or s.academicTerm || s.academicYear || s.academicInitiative = :term").setString("term", term).list();
        if (!sessions.isEmpty()) {
            for (Session session : sessions) {
                if (session.getStatusType() == null || session.getStatusType().isTestSession()) continue;
                return session;
            }
        }
        if ("current".equalsIgnoreCase(term) && !(sessions = hibSession.createQuery("select s from Session s where s.eventBeginDate <= :today and s.eventEndDate >= :today").setDate("today", new Date()).list()).isEmpty()) {
            for (Session session : sessions) {
                if (session.getStatusType() == null || session.getStatusType().isTestSession()) continue;
                return session;
            }
        }
        throw new GwtRpcException("Academic session " + term + " not found.");
    }
}

